<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2024-2025 Letrium Ltd.
 *
 * License ID: f27e70ce6801a13265271f5669c8bc5c
 ************************************************************************************/

namespace Espo\Modules\Project\Classes\Record\Hooks\ProjectGroup;

use Espo\Core\Exceptions\Error\Body;
use Espo\Core\Exceptions\Forbidden;
use Espo\Core\Record\DeleteParams;
use Espo\Core\Record\Hook\DeleteHook;
use Espo\Modules\Project\Entities\ProjectGroup;
use Espo\Modules\Project\Entities\ProjectTask;
use Espo\ORM\Entity;
use Espo\ORM\EntityManager;

/**
 * @implements DeleteHook<ProjectGroup>
 */
class BeforeDelete implements DeleteHook
{
    public function __construct(
        private EntityManager $entityManager,
    ) {}

    public function process(Entity $entity, DeleteParams $params): void
    {
        $one = $this->entityManager
            ->getRDBRepositoryByClass(ProjectTask::class)
            ->where(['groupId' => $entity->getId()])
            ->findOne();

        if ($one) {
            throw Forbidden::createWithBody(
                'cannotRemoveUsedInTask',
                Body::create()->withMessageTranslation('cannotRemoveUsedInTask', ProjectGroup::ENTITY_TYPE)
            );
        }
    }
}
