<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2024-2025 Letrium Ltd.
 *
 * License ID: f27e70ce6801a13265271f5669c8bc5c
 ************************************************************************************/

namespace Espo\Modules\Project\Entities;

use Espo\Core\ORM\Entity;

class ProjectGroup extends Entity
{
    public const ENTITY_TYPE = 'ProjectGroup';

    public const TASK_PLACEMENT_TOP = 'Top';
    public const TASK_PLACEMENT_BOTTOM = 'Bottom';

    public function getName(): string
    {
        return $this->get('name');
    }

    public function setName(string $name): self
    {
        $this->set('name', $name);

        return $this;
    }

    public function getColor(): ?int
    {
        return $this->get('color');
    }

    public function setColor(?int $color): self
    {
        $this->set('color', $color);

        return $this;
    }

    public function getTaskPlacement(): string
    {
        return (string) $this->get('taskPlacement');
    }

    public function setTaskPlacement(string $taskPlacement): self
    {
        $this->set('taskPlacement', $taskPlacement);

        return $this;
    }

    public function setProjectId(string $projectId): self
    {
        $this->set('projectId', $projectId);

        return $this;
    }

    public function getProjectId(): string
    {
        return $this->get('projectId') ?? '';
    }
    public function getOrder(): int
    {
        return (int) $this->get('order');
    }

    public function setOrder(int $order): self
    {
        $this->set('order', $order);

        return $this;
    }
}
