<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2024-2025 Letrium Ltd.
 *
 * License ID: f27e70ce6801a13265271f5669c8bc5c
 ************************************************************************************/

namespace Espo\Modules\Project\Tools\Project\Api;

use Espo\Core\Acl;
use Espo\Core\Api\Action;
use Espo\Core\Api\Request;
use Espo\Core\Api\Response;
use Espo\Core\Api\ResponseComposer;
use Espo\Core\Exceptions\BadRequest;
use Espo\Core\Record\EntityProvider;
use Espo\Modules\Project\Entities\ProjectGroup;
use Espo\Modules\Project\Tools\ProjectTask\RecordService;

/**
 * @noinspection PhpUnused
 */
class PostGroupTasks implements Action
{
    public function __construct(
        private EntityProvider $entityProvider,
        private RecordService $service,
    ) {}

    /**
     * @inheritDoc
     */
    public function process(Request $request): Response
    {
        $id = $request->getRouteParam('id') ?? new BadRequest();
        $ids = $request->getParsedBody()->ids ?? null;

        if (!is_array($ids)) {
            throw new BadRequest("No ids.");
        }

        foreach ($ids as $it) {
            if (!is_string($it)) {
                throw new BadRequest("Bad ids.");
            }
        }

        $group = $this->entityProvider->getByClass(ProjectGroup::class, $id);

        $this->service->massMoveToGroup($ids, $group);

        return ResponseComposer::json(true);
    }
}
