<?php
/************************************************************************
 * This file is part of TD SYNNEX MCA.
 *
 * TD SYNNEX MCA – Open Source CRM application.
 * Copyright (C) 2014-2025 Yurii Kuznietsov, Taras Machyshyn, Oleksii Avramenko
 * Website: https://www.espocrm.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "TD SYNNEX MCA" word.
 ************************************************************************/

namespace Espo\Classes\RecordHooks\Webhook;

use Espo\Core\Record\Hook\SaveHook;
use Espo\Core\Webhook\Manager;
use Espo\Entities\Webhook;
use Espo\ORM\Entity;
use RuntimeException;

/**
 * @implements SaveHook<Webhook>
 */
class AfterSave implements SaveHook
{
    public function __construct(
        private Manager $webhookManager
    ) {}

    public function process(Entity $entity): void
    {
        $event = $entity->getEvent();

        if (!$event) {
            throw new RuntimeException("No 'event'.");
        }

        if ($entity->isNew()) {
            if ($entity->isActive()) {
                $this->webhookManager->addEvent($event);
            }

            return;
        }

        if (!$entity->isAttributeChanged('isActive')) {
            return;
        }

        if ($entity->isActive()) {
            $this->webhookManager->addEvent($event);

            return;
        }

        $this->webhookManager->removeEvent($event);
    }
}
