/*
 * This file is part of  the extension: Ebla Multiple Link Pro
 * Copyright (c) Eblasoft Bilişim Ltd.
 *
 * This Software is the property of Eblasoft Bilişim Ltd. and is protected
 * by copyright law - it is NOT Freeware and can be used only in one project
 * under a proprietary license, which is delivered along with this program.
 * If not, see <http://eblasoft.com.tr/eula>.
 *
 * This Software is distributed as is, with LIMITED WARRANTY AND LIABILITY.
 * Any unauthorised use of this Software without a valid license is
 * a violation of the License Agreement.
 *
 * According to the terms of the license you shall not resell, sublicense,
 * rent, lease, distribute or otherwise transfer rights or usage of this
 * Software or its derivatives. You may modify the code of this Software
 * for your own needs, if source code is provided.
 */

define('ebla-link-pro:views/field-manager/link-multiple-form/enable-form', 'views/fields/bool', function (Dep) {

    return Dep.extend({

        setup: function () {
            Dep.prototype.setup.call(this);
            this.once('after:render', function () {
                this.model.on('change', function () {
                    this.manageEnableForm();
                }.bind(this));
                this.manageEnableForm();
            }.bind(this));
        },

        manageEnableForm: function () {
            var linkDefs = this.getMetadata().get('entityDefs.' + this.options.scope + '.links.' + this.model.get('name'));
            var foreignType = this.getMetadata().get('entityDefs.' + linkDefs.entity + '.links.' + linkDefs.foreign + '.type');

            if (this.model.get('enableForm')) {
                this.getParentView().showField('enableSelect');
                this.getParentView().showField('buttonsPosition');
                this.getParentView().showField('customLayout');
                this.getParentView().showField('layout');
                this.getParentView().showField('layoutLink');
                this.getParentView().showField('editLayout');
                this.getParentView().showField('editLayoutLink');
                this.getParentView().showField('orderBy');
                this.getParentView().showField('rowActionItems');
                this.getParentView().showField('order');
                this.getParentView().showField('enableCreateInModal');
                if (!!this.model.get('middleLink')) {
                    this.getParentView().showField('isMiddleLinkUnique');
                    this.getParentView().showField('copyFields');
                } else {
                    this.getParentView().hideField('copyFields');
                    this.getParentView().hideField('isMiddleLinkUnique');
                    this.model.set('isMiddleLinkUnique', false);
                    this.model.set('copyFields', null);
                }
                if (foreignType === 'hasMany') {
                    this.getParentView().hideField('enableAdd');
                    this.getParentView().hideField('enableAddMultiple');
                    this.getParentView().hideField('middleLink');
                    this.getParentView().hideField('noEditAccessRequiredForUnLink');
                    this.getParentView().hideField('readOnlyFields');
                    this.getParentView().hideField('footerSumFields');
                    this.getParentView().hideField('footerSumFieldsMap');
                } else {
                    this.getParentView().showField('enableAdd');
                    this.getParentView().showField('enableAddMultiple');
                    this.getParentView().showField('middleLink');
                    this.getParentView().showField('noEditAccessRequiredForUnLink');
                    this.getParentView().showField('readOnlyFields');
                    this.getParentView().showField('footerSumFields');
                    this.getParentView().showField('footerSumFieldsMap');
                }
            } else {
                this.getParentView().hideField('enableSelect');
                this.getParentView().hideField('enableAdd');
                this.getParentView().hideField('enableAddMultiple');
                this.getParentView().hideField('footerSumFields');
                this.getParentView().hideField('footerSumFieldsMap');
                this.getParentView().hideField('middleLink');
                this.getParentView().hideField('buttonsPosition');
                this.getParentView().hideField('noEditAccessRequiredForUnLink');
                this.getParentView().hideField('readOnlyFields');
                this.getParentView().hideField('layout');
                this.getParentView().hideField('customLayout');
                this.getParentView().hideField('layoutLink');
                this.getParentView().hideField('editLayout');
                this.getParentView().hideField('editLayoutLink');
                this.getParentView().hideField('orderBy');
                this.getParentView().hideField('rowActionItems');
                this.getParentView().hideField('isMiddleLinkUnique');
                this.getParentView().hideField('order');
                this.getParentView().hideField('copyFields');
                this.getParentView().hideField('enableCreateInModal');
            }
        }
    });
});
