/*
 * This file is part of  the extension: Ebla Multiple Link Pro
 * Copyright (c) Eblasoft Bilişim Ltd.
 *
 * This Software is the property of Eblasoft Bilişim Ltd. and is protected
 * by copyright law - it is NOT Freeware and can be used only in one project
 * under a proprietary license, which is delivered along with this program.
 * If not, see <http://eblasoft.com.tr/eula>.
 *
 * This Software is distributed as is, with LIMITED WARRANTY AND LIABILITY.
 * Any unauthorised use of this Software without a valid license is
 * a violation of the License Agreement.
 *
 * According to the terms of the license you shall not resell, sublicense,
 * rent, lease, distribute or otherwise transfer rights or usage of this
 * Software or its derivatives. You may modify the code of this Software
 * for your own needs, if source code is provided.
 */

define('ebla-link-pro:views/modals/add', 'views/modals/edit', function (Dep) {
    return Dep.extend({

        editView: "ebla-link-pro:views/record/edit-small",

        createRecordView: function (model, callback) {
            Dep.prototype.createRecordView.call(this, model, (view) => {
                view.on('found-duplicates', (duplicates) => {
                    model.set(duplicates[0]);
                    this.trigger('add', model);
                    this.dialog.close();
                })
            });
        },

        setup: function () {
            Dep.prototype.setup.call(this);

            this.buttonList = [
                {
                    name: 'save',
                    label: 'Add',
                    style: 'primary',
                },
                {
                    name: 'cancel',
                    label: 'Cancel'
                }
            ];
        },

        actionSave: function () {
            const editView = this.getView('edit');
            const model = editView.model;
            if (this.options.dontSave) {
                this.trigger('add', model);
                this.dialog.close();
            } else {
                Dep.prototype.actionSave.call(this,);
            }
        },
    });
});

