define('custom:views/Opportunity/record/edit', ['views/record/edit'], (EditView) => {
    return class extends EditView {

        // custom template, omit if you don't need it
        // template = 'custom:your-entity-type/record/detail'

        // custom central view, omit if you don't need it
        // middleView = 'custom:views/your-entity-type/record/detail-middle'

        // custom side column view, omit if you don't need it
        // sideView = 'custom:views/your-entity-type/record/detail-side'

        // custom bottom view, omit if you don't need it
        // bottomView = 'custom:views/your-entity-type/record/detail-bottom'
        setup() {
            super.setup();
        }

        afterRender() {
            super.afterRender();
            var afterRenderModel = this;
            console.log(`${Date.now()} - v2 edit record`)
            var h4s = document.querySelectorAll('h4.panel-title');
            var headers = ''
            h4s.forEach(function (item) {
                if (item.textContent == "Items") {
                    headers = item
                }
            })
            var html = `
                <a class="minimizer" href="javascript:" style="width: 86%; display: inline-block; text-align: right;">
                    <span class="enube-open" title="click to expand view" style="display:none;">Click to expand view&nbsp;&nbsp;<span class="fas fa-arrow-circle-right"></span></span>
                    <span class="enube-close" title="Click to collapse view">Click to collapse view&nbsp;&nbsp;<span class="fas fa-arrow-circle-left"></span></span>
                </a>
            `
            document.querySelector('.sub-container.clearfix').innerHTML += html
            document.querySelector('.record-grid .side').style.display = "none"

            // headers.innerHTML = headers.innerHTML + html;
            var recordGrid = document.querySelector('.record-grid');
            var enubeOpen = document.querySelector('.enube-open');
            var enubeClose = document.querySelector('.enube-close');
            var side = document.querySelector('.side');
            recordGrid.style.gridTemplateColumns = "minmax(auto,100%) minmax(auto,0%)"
            enubeOpen.addEventListener('click', function () {
                enubeClose.style.display = "block"
                enubeOpen.style.display = "none"
                side.style.display = "none"
                recordGrid.style.gridTemplateColumns = "minmax(auto,100%) minmax(auto,0%)"
            })
            enubeClose.addEventListener('click', function () {
                enubeOpen.style.display = "block"
                enubeClose.style.display = "none"
                side.style.display = "block"
                recordGrid.style.gridTemplateColumns = "minmax(auto,67%) minmax(auto,33%)"
            })
        }
    }
});
