var Swal;
Espo.loader.requirePromise('swal').then((sw)=> { Swal = sw });

define('custom:views/PrizeRoulette/record/detail', ['views/record/detail'], function (Dep) {

    return Dep.extend({

        setup: function () {
            Dep.prototype.setup.call(this);
        },

        afterRender: function () {
            console.log('PrizeRoulette/record/detail');

            var url = window.location.href;
            var urlSplit = url.split("view/", 2);
            var rouletteID = urlSplit[1]

            var afterRenderModel = this;
            var jsonWinners = [];
            setTimeout(function () {
            }, 200)

            $('.panel-prizeWinner button[data-action="createRelated"]').hide();
            $('.panel-prizeWinner button[data-toggle="dropdown"]').hide();

            $('<button class="btn btn-default action" data-action="roulette" data-toggle="modal" data-target="#modal-panel" type="button" style="margin-left: 15px">Roleta</button>').appendTo(".btn-group.actions-btn-group");

            document.querySelector('button[data-action="roulette"]').addEventListener('click', function () {
                var modalRoulette = $(
                    `<div id="modal-roulette" class="modal-dialog modal-roulette">
                        <div class="modal-content">
                            <div class="modal-header">
                            </div>
                            <div class="modal-body">
                                <div id="chart" align="center"></div>
                            </div>
                        </div>
                    </div>`
                );

                $('body').append('<div id="modal-panel" class="modal hidden" tabindex="-1" role="dialog"></div>')
                $('.modal').html(modalRoulette);

                Init()
            });

            async function Init() {

                Swal.showLoading()
                var data = await getPremio()

                var padding = { top: 20, right: 40, bottom: 0, left: 0 },
                    w = 500 - padding.left - padding.right,
                    h = 500 - padding.top - padding.bottom,
                    r = Math.min(w, h) / 2,
                    rotation = 0,
                    oldrotation = 0,
                    picked = 100000,
                    oldpick = [],
                    color = d3.scale.category20();//category20c()

                //randomNumbers = getRandomNumbers();

                var svg = d3.select('#chart')
                    .append("svg")
                    .data([data.list])
                    .attr("width", w + padding.left + padding.right)
                    .attr("height", h + padding.top + padding.bottom);

                var container = svg.append("g")
                    .attr("class", "chartholder")
                    .attr("transform", "translate(" + (w / 2 + padding.left) + "," + (h / 2 + padding.top) + ")");

                var vis = container
                    .append("g");


                var pie = d3.layout.pie().sort(null).value(function (d) { return 1; });

                // declare an arc generator function
                var arc = d3.svg.arc().outerRadius(r);

                // select paths, use arc generator to draw
                var arcs = vis.selectAll("g.slice")
                    .data(pie)
                    .enter()
                    .append("g")
                    .attr("class", "slice");

                arcs.append("path")
                    .attr("fill", function (d, i) { return color(i); })
                    .attr("d", function (d) { return arc(d); });

                // add the text
                arcs.append("text").attr("transform", function (d) {

                    d.innerRadius = 0;
                    d.outerRadius = r;
                    d.angle = (d.startAngle + d.endAngle) / 2;

                    return "rotate(" + (d.angle * 180 / Math.PI - 90) + ")translate(" + (d.outerRadius - 10) + ")";

                })

                    .attr("text-anchor", "end")
                    .text(function (d, i) {
                        return data.list[i].name;
                    });

                container.on("click", spin);

                function spin(d) {

                    container.on("click", null);
                    //all slices have been seen, all done
                    console.log("OldPick: " + oldpick.length, "Data length: " + data.total);

                    if (oldpick.length == data.total) {
                        console.log("done");
                        container.on("click", null);
                        return;

                    }

                    var ps = 360 / data.total,
                        pieslice = Math.round(1440 / data.total),
                        rng = Math.floor((Math.random() * 1440) + 360);
                    rotation = (Math.round(rng / ps) * ps);
                    picked = Math.round(data.total - (rotation % 360) / ps);
                    picked = picked >= data.total ? (picked % data.total) : picked;

                    if (oldpick.indexOf(picked) !== -1) {
                        d3.select(this).call(spin);
                        return;
                    } else {
                        oldpick.push(picked);
                    }

                    rotation += 90 - Math.round(ps / 2);

                    vis.transition()
                        .duration(3000)
                        .attrTween("transform", rotTween)
                        .each("end", function () {

                            /* Get the result value from object "data" */
                            jsonWinners.push(data.list[picked].id)

                            Swal.fire({
                                title: 'Vencedor!!',
                                text: "Parabénsss, " + data.list[picked].name + " foi o ganhador!",
                                showCancelButton: true,
                                confirmButtonColor: '#3085d6',
                                cancelButtonColor: '#32CD32',
                                confirmButtonText: 'Sortear mais uma empresa',
                                cancelButtonText: 'Salvar'
                            }).then((result) => {
                                if (result.isConfirmed) {
                                } else {
                                    sendWinnerAward(jsonWinners)
                                }
                            })

                            /* Comentar a linha de baixo, restringe em girar a roleta apenas uma vez. */
                            container.on("click", spin);

                        });
                }

                //make arrow
                svg.append("g")
                    .attr("transform", "translate(" + (w + padding.left + padding.right) + "," + ((h / 2) + padding.top) + ")")
                    .append("path")
                    .attr("d", "M-" + (r * .15) + ",0L0," + (r * .05) + "L0,-" + (r * .05) + "Z")
                    .style({ "fill": "black" });

                //draw spin circle
                container.append("circle")
                    .attr("cx", 0)
                    .attr("cy", 0)
                    .attr("r", 60)
                    .style({ "fill": "white", "cursor": "pointer" });

                //spin text
                container.append("text")
                    .attr("x", 0)
                    .attr("y", 15)
                    .attr("text-anchor", "middle")
                    .text("Sortear")
                    .style({ "font-weight": "bold", "font-size": "30px" });


                function rotTween(to) {
                    var i = d3.interpolate(oldrotation % 360, rotation);
                    return function (t) {
                        return "rotate(" + i(t) + ")";
                    };
                }
            }

            function getPremio() {
                return new Promise(function (success, error) {

                    var xhr = new XMLHttpRequest();
                    xhr.open("GET", "https://cdp.cloudanalytics.me/api/v1/PrizeRoulette/" + rouletteID + "/accounts?primaryFilter=&select=name,emailAddressIsOptedOut,emailAddress,emailAddressData,phoneNumberIsOptedOut,phoneNumber,phoneNumberData,country,type&maxSize=200&offset=0&orderBy=createdAt&order=desc", true);
                    xhr.setRequestHeader('Authorization', 'Basic ' + localStorage.getItem('espo-user-auth'));
                    xhr.onreadystatechange = function () {
                        if (xhr.readyState == 4) {
                            var resp = JSON.parse(xhr.responseText);
                            success(resp)
                            if (resp.total > 0) {
                                $('#modal-panel').removeClass("hidden");
                                swal.close();
                            } else {
                                setTimeout(() => {
                                    $('#modal-panel').hide();
                                    $('.modal-backdrop.in').hide();
                                }, 500);

                                Swal.fire({
                                    icon: 'error',
                                    title: 'Oops...',
                                    text: 'Não encontramos nenhuma empresa para participar do sorteio!'
                                })
                            }
                        }
                    }
                    xhr.send();
                });

            }

            function sendWinnerAward(jsonWinners) {
                setTimeout(function () {
                    Swal.showLoading()
                    var payload = JSON.stringify({ ids: jsonWinners });
                    var xhr = new XMLHttpRequest();
                    xhr.open("POST", "https://cdp.cloudanalytics.me/api/v1/PrizeRoulette/"+ rouletteID +"/prizeWinner", true);
                    xhr.setRequestHeader('Authorization', 'Basic ' + localStorage.getItem('espo-user-auth'));
                    xhr.setRequestHeader("Content-Type", 'application/json');
                    xhr.addEventListener('readystatechange', function () {
                        if ((xhr.readyState == 0 || xhr.readyState == 4) && xhr.status == 200) {
                            console.log(xhr.responseText);
                            $('#modal-panel').hide();
                            $('.modal-backdrop.in').hide();
                            swal.close();
                            location.reload();
                        }
                    });
                    xhr.send(payload);
                }, 500)
            }
        },

    });
});
