<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2024-2025 Letrium Ltd.
 *
 * License ID: f27e70ce6801a13265271f5669c8bc5c
 ************************************************************************************/

namespace Espo\Modules\Project\Entities;

use Espo\Core\ORM\Entity;

class ProjectRole extends Entity
{
    public const ENTITY_TYPE = 'ProjectRole';

    public const LEVEL_YES = 'yes';
    public const LEVEL_ALL = 'all';
    public const LEVEL_ASSIGNED = 'assigned';
    public const LEVEL_OWN = 'own';
    public const LEVEL_NO = 'no';

    public function getName(): string
    {
        return $this->get('name');
    }

    /**
     * @return array<string, string>
     */
    public function getPermissionMap(): array
    {
        $list = [
            'taskCreate',
            'taskRead',
            'taskStream',
            'taskEdit',
            'taskColumnEdit',
            'taskDelete',
            'taskAssignment',
        ];

        $map = [];

        foreach ($list as $item) {
            $map[$item] = $this->get($item);
        }

        return $map;
    }

    public function populateMaxPermissions(): void
    {
        $this->setMultiple([
            'taskCreate' => self::LEVEL_YES,
            'taskRead' => self::LEVEL_ALL,
            'taskStream' => self::LEVEL_ALL,
            'taskEdit' => self::LEVEL_ALL,
            'taskColumnEdit' => self::LEVEL_ALL,
            'taskDelete' => self::LEVEL_ALL,
            'taskAssignment' => self::LEVEL_ALL,
        ]);
    }

    public function populateDefaultMemberPermissions(): void
    {
        $this->setMultiple([
            'taskCreate' => self::LEVEL_NO,
            'taskRead' => self::LEVEL_OWN,
            'taskStream' => self::LEVEL_OWN,
            'taskEdit' => self::LEVEL_OWN,
            'taskColumnEdit' => self::LEVEL_ASSIGNED,
            'taskDelete' => self::LEVEL_NO,
            'taskAssignment' => self::LEVEL_OWN,
        ]);
    }

    public function getTaskCreate(): string
    {
        return $this->get('taskCreate');
    }

    public function getTaskRead(): string
    {
        return $this->get('taskRead');
    }

    public function getTaskStream(): string
    {
        return $this->get('taskStream');
    }

    public function getTaskEdit(): string
    {
        return $this->get('taskEdit');
    }

    public function getTaskColumnEdit(): string
    {
        return $this->get('taskColumnEdit');
    }

    public function getTaskDelete(): string
    {
        return $this->get('taskDelete');
    }

    public function getTaskAssignment(): string
    {
        return $this->get('taskAssignment');
    }
}
