<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2024-2025 Letrium Ltd.
 *
 * License ID: f27e70ce6801a13265271f5669c8bc5c
 ************************************************************************************/

namespace Espo\Modules\Project\Hooks\ProjectTask;

use Espo\Core\Hook\Hook\AfterSave;
use Espo\Core\Job\JobSchedulerFactory;
use Espo\Core\Job\QueueName;
use Espo\Modules\Project\Entities\ProjectTask;
use Espo\ORM\Entity;
use Espo\ORM\Repository\Option\SaveOptions;
use Espo\Tools\Stream\Jobs\ControlFollowers as ControlFollowersJob;
use Espo\Tools\Stream\Service;

/**
 * @implements AfterSave<ProjectTask>
 */
class Subscribe implements AfterSave
{
    public function __construct(
        private Service $service,
        private JobSchedulerFactory $jobSchedulerFactory,
    ) {}

    public function afterSave(Entity $entity, SaveOptions $options): void
    {
        if (!$entity->getOwnerId()) {
            return;
        }

        if (!$entity->isNew() && !$entity->isAttributeChanged('ownerId')) {
            return;
        }

        $this->service->followEntity($entity, $entity->getOwnerId());

        if (!$entity->isNew()) {
            $this->jobSchedulerFactory
                ->create()
                ->setClassName(ControlFollowersJob::class)
                ->setQueue(QueueName::Q1)
                ->setData([
                    'entityType' => $entity->getEntityType(),
                    'entityId' => $entity->getId(),
                ])
                ->schedule();
        }
    }
}
