<?php

use Espo\Core\InjectableFactory;
use Espo\Modules\EblaLinkPro\Services\EblaLinkPro;
use Espo\Modules\EblaLinkPro\Tools\LinkPro\Service;

class AfterInstall
{
    protected $container;

    public function run($container)
    {
        $this->container = $container;

        $this->clearCache();
        $this->convertOldDefs();

        /* @var InjectableFactory $injectableFactory */
        $injectableFactory = $this->container->get('injectableFactory');
        $injectableFactory->create(EblaLinkPro::class)->eblaLinkProJob();
    }

    protected function clearCache()
    {
        try {
            $this->container->get('dataManager')->clearCache();
        }
        catch (\Exception $e) {
        }
    }

    /*
     * Search in fields in metadata and remove custom fields after converting them to list additional layout
     * */
    protected function convertOldDefs()
    {
        try {
            $config = $this->container->get('config');

            /*
             if (empty($config->get('unlinkButtonIconClass'))) {
                $config->set('unlinkButtonIconClass', 'fas fa-unlink');
            }
            */

            $metadata = $this->container->get('metadata');

            /* @var InjectableFactory $injectableFactory */
            $injectableFactory = $this->container->get('injectableFactory');
            $service = $injectableFactory->create(Service::class);

            foreach ($metadata->get(['entityDefs']) as $scope => $defs) {
                foreach ($metadata->get(['entityDefs', $scope, 'fields']) as $field => $fieldDefs) {
                    if (
                        (isset($fieldDefs['type']) && $fieldDefs['type'] !== 'linkMultiple') ||
                        (isset($fieldDefs['enableForm']) && $fieldDefs['enableForm'] !== true)
                    ) {
                        continue;
                    }

                    if (isset($fieldDefs['layout']) && $fieldDefs['layout'] === 'custom') {
                        $service->createCustomLayout($scope, $field, $fieldDefs);
                    }

                    $metadata->delete(
                        'entityDefs',
                        $scope,
                        ['fields.' . $field . '.fields']
                    );
                }
            }
        }
        catch (Exception $e) {
            return;
        }
    }
}
