<?php
return [
  'ActionHistoryRecord' => [
    'fields' => [
      'user' => 'Usuario',
      'action' => 'Acción',
      'createdAt' => 'Fecha',
      'userType' => 'User Type',
      'target' => 'Interés',
      'targetType' => 'Tipo de Interés',
      'authToken' => 'Clave de Autorización',
      'ipAddress' => 'Dirección IP',
      'authLogRecord' => 'Registro en Hist. de Aut.'
    ],
    'links' => [
      'authToken' => 'Clave de Autorización',
      'authLogRecord' => 'Registro en Hist. de Aut.',
      'user' => 'Usuario',
      'target' => 'Interés'
    ],
    'presetFilters' => [
      'onlyMy' => 'Sólo para Mi'
    ],
    'options' => [
      'action' => [
        'read' => 'Leer',
        'update' => 'Actualizar',
        'delete' => 'Borrar',
        'create' => 'Crear'
      ]
    ]
  ],
  'AddressCountry' => [
    'labels' => [
      'Create AddressCountry' => 'Create Address Country',
      'Populate' => 'Populate'
    ],
    'fields' => [
      'code' => 'Code',
      'isPreferred' => 'Is Preferred'
    ],
    'tooltips' => [
      'code' => 'ISO 3166-1 alpha-2 code.',
      'isPreferred' => 'Preferred countries appear first in the picklist.'
    ],
    'messages' => [
      'confirmPopulateDefaults' => 'All existing countries will be deleted, the default country list will be created. It won\'t be possible to revert the operation.

Are you sure?'
    ],
    'strings' => [
      'populateDefaults' => 'Populate with default country list'
    ]
  ],
  'Admin' => [
    'labels' => [
      'Enabled' => 'Activado',
      'Disabled' => 'Desactivado',
      'System' => 'Sistema',
      'Users' => 'Usuarios',
      'Email' => 'Correo',
      'Messaging' => 'Messaging',
      'Data' => 'Datos',
      'Misc' => 'Misc',
      'Setup' => 'Setup',
      'Customization' => 'Personalizar',
      'Available Fields' => 'Campos Disponibles',
      'Layout' => 'Diseño',
      'Entity Manager' => 'Entidades',
      'Add Panel' => 'Agregar Panel',
      'Add Field' => 'Agregar Campo',
      'Settings' => 'Ajustes',
      'Scheduled Jobs' => 'Tareas Agendadas',
      'Upgrade' => 'Actualizar',
      'Clear Cache' => 'Borrar Cache',
      'Rebuild' => 'Reconstruir',
      'Teams' => 'Equipos',
      'Roles' => 'Roles',
      'Portal' => 'Portal',
      'Portals' => 'Portales',
      'Portal Roles' => 'Roles',
      'Portal Users' => 'Usuarios',
      'API Users' => 'Usuarios de la API',
      'Outbound Emails' => 'Correos Salientes',
      'Group Email Accounts' => 'Grupo de Cuentas de Correo',
      'Personal Email Accounts' => 'Cuentas Personales',
      'Inbound Emails' => 'Correos Entrantes',
      'Email Templates' => 'Plantillas de Correo',
      'Import' => 'Importación',
      'Layout Manager' => 'Formatos',
      'User Interface' => 'Interfaz de Usuario',
      'Auth Tokens' => 'Clave de Aut.',
      'Auth Log' => 'Historial de Autorizaciones',
      'App Log' => 'App Log',
      'App Secrets' => 'App Secrets',
      'Authentication' => 'Autorización',
      'Currency' => 'Moneda',
      'Integrations' => 'Integracion',
      'Extensions' => 'Extensiones',
      'Webhooks' => 'Webhooks',
      'Dashboard Templates' => 'Dashboard Templates',
      'Upload' => 'Subir',
      'Installing...' => 'Instalando...',
      'Upgrading...' => 'Actualizando',
      'Upgraded successfully' => 'Actualización exitosa',
      'Installed successfully' => 'Instalado exitosamente',
      'Ready for upgrade' => 'Listo para actualizar',
      'Run Upgrade' => 'Ejecutar actualización',
      'Install' => 'Instalar',
      'Ready for installation' => 'Listo para instalación',
      'Uninstalling...' => 'Desinstalando...',
      'Uninstalled' => 'Desinstalado',
      'Create Entity' => 'Crear Entidad',
      'Edit Entity' => 'Editar Entidad',
      'Create Link' => 'Crear Enlace',
      'Edit Link' => 'Editar Enlace',
      'Notifications' => 'Notificaciones',
      'Jobs' => 'Trabajos',
      'Job Settings' => 'Job Settings',
      'Reset to Default' => 'Restablecer valores default',
      'Email Filters' => 'Filtros de Correo',
      'Action History' => 'Historial',
      'Label Manager' => 'Etiquetas',
      'Template Manager' => 'Administrador de Plantillas',
      'Lead Capture' => 'Capturar Referencia',
      'Attachments' => 'Adjuntos ',
      'System Requirements' => 'Requerimientos del Sistema',
      'PDF Templates' => 'PDF Templates',
      'PHP Settings' => 'Configuración PHP',
      'Database Settings' => 'Configuración de la Base de Datos',
      'Permissions' => 'Permisos',
      'Email Addresses' => 'Email Addresses',
      'Phone Numbers' => 'Phone Numbers',
      'Layout Sets' => 'Layout Sets',
      'Working Time Calendars' => 'Working Time Calendars',
      'Group Email Folders' => 'Group Email Folders',
      'Authentication Providers' => 'Authentication Providers',
      'Address Countries' => 'Address Countries',
      'Success' => 'Correcto',
      'Fail' => 'Falló',
      'Configuration Instructions' => 'Configuration Instructions',
      'Formula Sandbox' => 'Formula Sandbox',
      'is recommended' => 'es recomendado',
      'extension is missing' => 'falta la extensión ',
      'Workflow Manager' => 'Workflows',
      'Flowcharts' => 'Flowcharts',
      'Processes' => 'Processes',
      'Business Process Management' => 'Business Process Management',
      'Report Filters' => 'Report Filters',
      'Report Panels' => 'Report Panels',
      'Price Rule Conditions' => 'Price Rule Conditions'
    ],
    'layouts' => [
      'list' => 'Lista',
      'detail' => 'Detalle',
      'listSmall' => 'Lista (Pequeña)',
      'detailSmall' => 'Detalle (Pequeño)',
      'detailPortal' => 'Detalle (Portal)',
      'detailSmallPortal' => 'Detalle (Pequeño, Portal)',
      'listSmallPortal' => 'Lista (Pequeño, Portal)',
      'listPortal' => 'Lista (Portal)',
      'relationshipsPortal' => 'Paneles de Relaciones (Portal)',
      'filters' => 'Filtros de Búsqueda',
      'massUpdate' => 'Actualización Masiva',
      'relationships' => 'Paneles de Relaciones',
      'defaultSidePanel' => 'Side Panel Fields',
      'bottomPanelsDetail' => 'Bottom Panels',
      'bottomPanelsEdit' => 'Bottom Panels (Edit)',
      'bottomPanelsDetailSmall' => 'Bottom Panels (Detail Small)',
      'bottomPanelsEditSmall' => 'Bottom Panels (Edit Small)',
      'sidePanelsDetail' => 'Paneles auxiliares (detalle)',
      'sidePanelsEdit' => 'Paneles auxiliares (editar)',
      'sidePanelsDetailSmall' => 'Paneles auxiliares (detalle pequeño)',
      'sidePanelsEditSmall' => 'Paneles auxiliares (editar pequeño)',
      'kanban' => 'Tarjetas',
      'detailConvert' => 'Convertir Referencia',
      'listForAccount' => 'Listado (por Cuentas)',
      'listForContact' => 'Lista (para Contactos)',
      'listItem' => 'List (Item)',
      'detailBottomTotal' => 'Bottom Total',
      'listForAdd' => 'List (Select for Item)',
      'listForAddInventory' => 'List (Select Inventory)',
      'detailCreateFromSalesOrder' => 'Create from Sales Order',
      'detailCreateFromPurchaseOrder' => 'Create from Purchase Order',
      'listForProduct' => 'List for Product',
      'listForTemplateProduct' => 'List for Template Product',
      'listForWarehouse' => 'List for Warehouse',
      'listVariant' => 'List Variants',
      'listForProject' => 'List (for Project)',
      'listForTask' => 'List (Sub-Task)',
      'listSmallForProject' => 'List (Small, for Project)',
      'kanbanForProject' => 'Board (for Project)'
    ],
    'fieldTypes' => [
      'address' => 'Dirección',
      'array' => 'Arreglo',
      'foreign' => 'Externo',
      'duration' => 'Periodo',
      'password' => 'Contraseña',
      'personName' => 'Nombre',
      'autoincrement' => 'Auto-incremento',
      'bool' => 'Sí/No',
      'currency' => 'Moneda',
      'currencyConverted' => 'Moneda (Convertida)',
      'date' => 'Fecha',
      'datetime' => 'Fecha-Hr',
      'datetimeOptional' => 'Fecha/Fecha-Hr',
      'email' => 'Correo',
      'enum' => 'Lista',
      'enumInt' => 'Lista Enteros',
      'enumFloat' => 'Lista Numérica',
      'float' => 'Numérico',
      'int' => 'Entero',
      'link' => 'Liga',
      'linkMultiple' => 'Ligas',
      'linkParent' => 'Liga Orígen',
      'linkOne' => 'Link One',
      'phone' => 'Teléfono',
      'text' => 'Texto',
      'url' => 'Dirección Web',
      'urlMultiple' => 'Url Multiple',
      'varchar' => 'Varchar',
      'file' => 'Archivo',
      'image' => 'Imagen',
      'multiEnum' => 'Lista Múltiple',
      'attachmentMultiple' => 'Adjuntos',
      'rangeInt' => 'Rango Entero',
      'rangeFloat' => 'Rango Numérico',
      'rangeCurrency' => 'Rango de Moneda',
      'wysiwyg' => 'Wysiwyg',
      'map' => 'Mapa',
      'number' => 'Número (auto-incremeto)',
      'colorpicker' => 'Selector de Colores',
      'checklist' => 'Checklist',
      'barcode' => 'Barcode',
      'jsonArray' => 'Arreglo Json',
      'jsonObject' => 'Objeto Json',
      'inlineRelationList' => 'Inline Relation List'
    ],
    'fields' => [
      'type' => 'Tipo',
      'name' => 'Nombre',
      'label' => 'Etiqueta',
      'tooltipText' => 'Texto de Ayuda',
      'required' => 'Requerido',
      'default' => 'Default',
      'maxLength' => 'Longitud máxima',
      'options' => 'Opciones',
      'optionsReference' => 'Options Reference',
      'after' => 'Posterior al Campo',
      'before' => 'Anterior al Campo',
      'link' => 'Enlace',
      'field' => 'Campo',
      'min' => 'Mínimo',
      'max' => 'Máximo',
      'translation' => 'Traducción',
      'previewSize' => 'Tamaño de Vista Previa',
      'listPreviewSize' => 'Preview Size in List View',
      'noEmptyString' => 'No se permite el campo vacío',
      'defaultType' => 'Tipo Default',
      'seeMoreDisabled' => 'Desactivar cortar texto',
      'cutHeight' => 'Cut Height (px)',
      'entityList' => 'Lista de Entidades',
      'isSorted' => 'Esta ordenado (alfabeticamente)',
      'audited' => 'Auditada',
      'trim' => 'Recortado',
      'height' => 'Altura (px)',
      'minHeight' => 'Altura Min (px)',
      'provider' => 'Proveedor',
      'typeList' => 'Lista de Tipos',
      'rows' => 'Num. de renglones del área de texto',
      'lengthOfCut' => 'Longitud del recorte',
      'sourceList' => 'Lista de Fuentes',
      'prefix' => 'Prefijo',
      'nextNumber' => 'Siguiente Número',
      'padLength' => 'Longitud del Panel',
      'disableFormatting' => 'Desactivar Formateo',
      'dynamicLogicVisible' => 'Condiciones que hacen visible al campo',
      'dynamicLogicReadOnly' => 'Condiciones que hacen el campo de solo-lectura',
      'dynamicLogicRequired' => 'Condiciones que hacen el campo obligatorio',
      'dynamicLogicOptions' => 'Opciones condicionales',
      'dynamicLogicInvalid' => 'Conditions making field invalid',
      'probabilityMap' => 'Probabilidades de la Etapa (%)',
      'notActualOptions' => 'Not Actual Options',
      'activeOptions' => 'Active Options',
      'readOnly' => 'Solo-lectura',
      'readOnlyAfterCreate' => 'Read-only After Create',
      'preview' => 'Preview',
      'attachmentField' => 'Attachment Field',
      'maxFileSize' => 'Tamaño máximo (Mb)',
      'isPersonalData' => 'Son Datos Personales',
      'useIframe' => 'Usar iFrame',
      'useNumericFormat' => 'Use Formato numérico ',
      'strip' => 'Limpiar',
      'minuteStep' => 'Minutes Step',
      'inlineEditDisabled' => 'Deshabilitar edición en linea',
      'allowCustomOptions' => 'Allow Custom Options',
      'displayAsLabel' => 'Mostrar como etiqueta',
      'displayAsList' => 'Display as List',
      'labelType' => 'Label Type',
      'maxCount' => 'Max Item Count',
      'accept' => 'Accept',
      'viewMap' => 'View Map Button',
      'codeType' => 'Code Type',
      'lastChar' => 'Last Character',
      'onlyDefaultCurrency' => 'Only default currency',
      'decimal' => 'Decimal',
      'displayRawText' => 'Display raw text (no markdown)',
      'conversionDisabled' => 'Disable Conversion',
      'decimalPlaces' => 'Decimal Places',
      'pattern' => 'Pattern',
      'globalRestrictions' => 'Global Restrictions',
      'copyToClipboard' => 'Copy to clipboard button',
      'createButton' => 'Create Button',
      'autocompleteOnEmpty' => 'Autocomplete on empty input',
      'relateOnImport' => 'Relate on Import',
      'aclScope' => 'ACL Scope',
      'onlyAdmin' => 'Only for Admin',
      'enableForm' => 'Enable Form',
      'rowActionItems' => 'Row Action Items',
      'buttonsPosition' => 'Buttons Position (Add & Select)',
      'enableSelect' => 'Enable Select Button',
      'enableAdd' => 'Enable Add Row Button',
      'enableCreateInModal' => 'Enable Create In Modal Button',
      'enableAddMultiple' => 'Enable Add Multiple Button',
      'footerSumFields' => 'Footer Sum Fields',
      'footerSumFieldsMap' => 'Footer Sum Fields Map',
      'middleLink' => 'Middle Link (Act As Middle Entity)',
      'isMiddleLinkUnique' => 'Is Middle Link Unique',
      'layout' => 'Detail Layout',
      'editLayout' => 'Edit Layout',
      'customLayout' => 'Custom Layout',
      'editLayoutLink' => 'Custom Edit Layout',
      'readOnlyFields' => 'Readonly Fields',
      'noEditAccessRequiredForUnLink' => 'No Child Edit Access Required for Link/Unlink',
      'copyFields' => 'Copy Fields',
      'orderBy' => 'Order By',
      'useAutoincrement' => 'Auto-Increment',
      'copyFieldList' => 'Fields to Copy'
    ],
    'strings' => [
      'rebuildRequired' => 'Rebuild is required'
    ],
    'messages' => [
      'cacheIsDisabled' => 'Cache is disabled, the application will run slow. Enable cache in the [settings](#Admin/settings).',
      'formulaFunctions' => 'More functions can be found in [documentation]({documentationUrl}).',
      'rebuildRequired' => 'You need to run rebuild from CLI.',
      'upgradeVersion' => 'Synnex se actualizará a la versión <strong>{version}</strong>.  Por favor espere unos minutos.',
      'upgradeDone' => 'Synnex fué actualizado a la versión <strong>{version}</strong>.',
      'upgradeBackup' => 'Le recomendamos hacer un respaldo de sus datos y sistema Synnex antes de actualizarlo.',
      'thousandSeparatorEqualsDecimalMark' => 'El caracter separador de miles no puede ser el mismo que el separador decimal.',
      'userHasNoEmailAddress' => 'Este usuario no tiene correo de contacto.',
      'selectEntityType' => 'Seleccione el tipo de entidad en el menú de la izquierda.',
      'selectUpgradePackage' => 'Seleccione el Paquete de Actualización',
      'downloadUpgradePackage' => 'Descargue los paquetes de actualización desde <a href="{url}">aquí</a>.',
      'selectLayout' => 'Seleccione el diseño en el menú de la izquierda, para editarlo.',
      'selectExtensionPackage' => 'Seleccionar extensión del paquete',
      'extensionInstalled' => 'La Extensión {name} {version} ha sido instalada',
      'installExtension' => 'La Extensión {name} {version} está lista para instalar.',
      'cronIsDisabled' => 'Cron is disabled, the application is not fully functional. Enable cron in the [settings](#Admin/settings).',
      'cronIsNotConfigured' => 'No se están ejecutando las tareas programadas. Por lo cual los correos enviados, notificaciones y alarmas no están funcionando.  Por favor siga las {instructions}
(https://www.espocrm.com/documentation/administration/server-configuration/#user-content-setup-a-crontab) para activar los cron jobs. ',
      'newVersionIsAvailable' => 'Hay una nueva versión disponible de Synnex. ({latestVersion}).',
      'newExtensionVersionIsAvailable' => 'Nueva versión {latestVersion} disponible para {extensionName}. ',
      'uninstallConfirmation' => '¿Realmente quiere desinstalar esta extensión?',
      'upgradeInfo' => 'Check the [documentation]({url}) about how to upgrade your TD SYNNEX MCA instance.',
      'upgradeRecommendation' => 'This way of upgrading is not recommended. It\'s better to upgrade from CLI.',
      'newAdvancedPackVersionIsAvailable' => 'New Advanced Pack version {latestVersion} is available. It can be downloaded on the customer portal.'
    ],
    'descriptions' => [
      'settings' => 'Configuración del sistema de aplicación.',
      'scheduledJob' => 'Trabajos que se ejecutan automáticamente (cron Jobs).',
      'jobs' => 'Jobs execute tasks in the background.',
      'upgrade' => 'Actualizar Synnex.',
      'clearCache' => 'Borrar Cache del Servidor.',
      'rebuild' => 'Borrar y regenerar el Cache del Servidor.',
      'users' => 'Administración de Usuarios.',
      'teams' => 'Administración de Equipos',
      'roles' => 'Administración de Roles',
      'portals' => 'Manejo de Portales',
      'portalRoles' => 'Roles en el Portal',
      'portalUsers' => 'Usuarios del portal.',
      'outboundEmails' => 'Opciones SMTP para correo saliente.',
      'groupEmailAccounts' => 'Grupo de Cuentas Correo IMAP, importación de correos y correos por caso.',
      'personalEmailAccounts' => 'Cuentas de correo de Usuarios',
      'emailTemplates' => 'Plantillas para mensajes de Correo de salida.',
      'import' => 'Importar desde archivo CSV.',
      'layoutManager' => 'Personalizar diseños (listas, detalles, editar, buscar, actualización masiva).',
      'entityManager' => 'Crear y editar entidades personalizadas.  Administrar campos y relaciones.',
      'userInterface' => 'Configurar la Interfaz del Usuario',
      'authTokens' => 'Sesiones certificas activas. Direcciones IP y última fecha de acceso',
      'authentication' => 'Opciones de autorización',
      'currency' => 'Opciones y tarifas de Moneda',
      'extensions' => 'Instalar o desinstalar extensiones',
      'integrations' => 'Integración con servicios de terceros.',
      'notifications' => 'Ajustes de notificaciones del correo y la aplicación.',
      'inboundEmails' => 'Configuración de cuentas de Correo de entrada.',
      'emailFilters' => 'Los mensajes de correo que cumplan con el filtro indicado, no se importarán.',
      'groupEmailFolders' => 'Email folders shared for teams.',
      'actionHistory' => 'Historial de acciones del usuario.',
      'labelManager' => 'Personalizar etiquetas de aplicación',
      'templateManager' => 'Personalizar plantillas de mensajes.',
      'authLog' => 'Historial de Ingresos',
      'appLog' => 'Application log.',
      'appSecrets' => 'Store sensitive information like API keys, passwords, and other secrets.',
      'leadCapture' => 'Puntos de entrada de la API para Web-a-Ref',
      'attachments' => 'Todos los archivos adjuntos fueron guardados en el sistema. ',
      'systemRequirements' => 'Requerimientos del Sistema para Synnex.',
      'apiUsers' => 'Separar usuarios para integración de grupos.',
      'webhooks' => 'Manage webhooks.',
      'authenticationProviders' => 'Additional authentication providers for portals.',
      'emailAddresses' => 'All email addresses stored in the system.',
      'phoneNumbers' => 'All phone numbers stored in the system.',
      'dashboardTemplates' => 'Deploy dashboards to users.',
      'layoutSets' => 'Collections of layouts that can be assigned to teams & portals.',
      'workingTimeCalendars' => 'Working schedule.',
      'jobsSettings' => 'Job processing settings. Jobs execute tasks in the background.',
      'sms' => 'SMS settings.',
      'pdfTemplates' => 'Templates for printing to PDF.',
      'formulaSandbox' => 'Write and test formula scripts.',
      'addressCountries' => 'Countries available for address fields.',
      'workflowManager' => 'Configure Workflow rules.',
      'bpmnFlowcharts' => 'Definitions of business processes.',
      'bpmnProcesses' => 'Instances of business processes.',
      'reportFilters' => 'Custom list view filters based on reports.',
      'reportPanels' => 'Detail view panels showing report results.',
      'salesPackSettings' => 'Parameters for sales & purchase functionality.',
      'priceRuleConditions' => 'Formula conditions for price rules.'
    ],
    'keywords' => [
      'settings' => 'system',
      'userInterface' => 'ui,theme,tabs,logo,dashboard',
      'authentication' => 'password,security,ldap',
      'scheduledJob' => 'cron,jobs',
      'integrations' => 'google,maps,google maps',
      'authLog' => 'log,history',
      'authTokens' => 'history,access,log',
      'entityManager' => 'fields,relations,relationships',
      'templateManager' => 'notifications',
      'jobs' => 'cron',
      'labelManager' => 'language,translation',
      'appSecrets' => 'key,keys,password',
      'leadCapture' => 'web forms',
      'bpmnFlowcharts' => 'bpm',
      'bpmnProcesses' => 'bpm',
      'salesPack' => 'price,price book,price books'
    ],
    'options' => [
      'previewSize' => [
        '' => 'Default',
        'x-small' => 'Muy Pequeño',
        'small' => 'Pequeño',
        'medium' => 'Mediano',
        'large' => 'Grande'
      ],
      'labelType' => [
        'state' => 'State',
        'regular' => 'Regular'
      ],
      'order' => [
        'asc' => 'Ascending',
        'desc' => 'Descending'
      ],
      'buttonsPosition' => [
        'top' => 'Top',
        'bottom' => 'Bottom'
      ],
      'rowActionItems' => [
        'edit' => 'Edit',
        'view' => 'View',
        'remove' => 'Remove',
        'unlink' => 'Unlink'
      ]
    ],
    'logicalOperators' => [
      'and' => 'Y',
      'or' => 'O',
      'not' => 'NO'
    ],
    'systemRequirements' => [
      'requiredPhpVersion' => 'Versión PHP',
      'requiredMysqlVersion' => 'Versión MySQL',
      'requiredMariadbVersion' => 'MariaDB version',
      'requiredPostgresqlVersion' => 'PostgreSQL version',
      'host' => 'Nombre del Hospedaje',
      'dbname' => 'Nombre de la Base de Datos',
      'user' => 'Nombre del Usuario',
      'writable' => 'Permite grabar',
      'readable' => 'Permite leer'
    ],
    'templates' => [
      'twoFactorCode' => '2FA Code',
      'accessInfo' => 'Información de Acceso',
      'accessInfoPortal' => 'Información de Acceso a Portales',
      'assignment' => 'Asignación',
      'mention' => 'Mención',
      'noteEmailReceived' => 'Nota sobre el Correo Recibido',
      'notePost' => 'Nota sobre la Publicación',
      'notePostNoParent' => 'Nota sobre la Publicación (No el Padre)',
      'noteStatus' => 'Nota sobre el Estado de la Actualización',
      'passwordChangeLink' => 'Liga para Cambiar Contraseña',
      'invitation' => 'Invitación',
      'cancellation' => 'Cancellation',
      'reminder' => 'Recordatorio',
      'reportSendingGrid1' => 'Report Grid-1',
      'reportSendingGrid2' => 'Report Grid-2',
      'reportSendingList' => 'Report List',
      'salesEmailPdf' => 'Email PDF (Sales)'
    ]
  ],
  'ApiUser' => [
    'labels' => [
      'Create ApiUser' => 'Crear Usuario de la API'
    ]
  ],
  'AppLogRecord' => [
    'fields' => [
      'message' => 'Message',
      'code' => 'Code',
      'level' => 'Level',
      'exceptionClass' => 'Exception Class',
      'file' => 'File',
      'line' => 'Line',
      'requestMethod' => 'Request Method',
      'requestResourcePath' => 'Request Resource Path'
    ],
    'presetFilters' => [
      'errors' => 'Errors'
    ]
  ],
  'AppSecret' => [
    'labels' => [
      'Create AppSecret' => 'Create Secret'
    ],
    'fields' => [
      'value' => 'Value'
    ],
    'tooltips' => [
      'name' => 'Allowed characters:
* `[a-z]`
* `[A-Z]`
* `[0-9]`
* `_`'
    ]
  ],
  'Attachment' => [
    'fields' => [
      'role' => 'Rol',
      'related' => 'Relacionado ',
      'file' => 'Archivo ',
      'type' => 'Tipo ',
      'field' => 'Campo ',
      'sourceId' => 'ID Origen',
      'storage' => 'Almacenamiento ',
      'size' => 'Tamaño ',
      'isBeingUploaded' => 'Is Being Uploaded'
    ],
    'options' => [
      'role' => [
        'Attachment' => 'Adjunto ',
        'Inline Attachment' => 'Adjunto inmediato ',
        'Import File' => 'Importar Archivo',
        'Export File' => 'Exportar Archivo',
        'Mail Merge' => 'Generar Correos',
        'Mass Pdf' => 'PDF Masivo'
      ]
    ],
    'insertFromSourceLabels' => [
      'Document' => 'Insertar documento'
    ],
    'presetFilters' => [
      'orphan' => 'Huérfano '
    ]
  ],
  'AuthLogRecord' => [
    'fields' => [
      'username' => 'Nombre del Usuario',
      'ipAddress' => 'Dirección IP',
      'requestTime' => 'Hr. de la Solicitud',
      'createdAt' => 'Fecha de la Solicitud',
      'isDenied' => 'Fue denegado',
      'denialReason' => 'Razón de denegación',
      'portal' => 'Portal',
      'user' => 'Usuario',
      'authToken' => 'Clave de Aut. creada',
      'requestUrl' => 'URL de la Solicitud',
      'requestMethod' => 'Método de la Solicitud',
      'authTokenIsActive' => 'La clave de aut. está activa',
      'authenticationMethod' => 'Método de Autenticación'
    ],
    'links' => [
      'authToken' => 'Clave de aut. creada',
      'user' => 'Usuario',
      'portal' => 'Portal',
      'actionHistoryRecords' => 'Historial de Acciones'
    ],
    'presetFilters' => [
      'denied' => 'Denegado',
      'accepted' => 'Aceptado'
    ],
    'options' => [
      'denialReason' => [
        'CREDENTIALS' => 'Credenciales inválidas',
        'WRONG_CODE' => 'Wrong code',
        'INACTIVE_USER' => 'Usuario inactivo',
        'IS_PORTAL_USER' => 'Usuario del Portal',
        'IS_NOT_PORTAL_USER' => 'No es un usuario del portal',
        'USER_IS_NOT_IN_PORTAL' => 'El usuario no se relaciona con el portal',
        'IS_SYSTEM_USER' => 'Is system user',
        'FORBIDDEN' => 'Forbidden'
      ]
    ]
  ],
  'AuthToken' => [
    'fields' => [
      'user' => 'Usuario',
      'ipAddress' => 'Dirección IP',
      'lastAccess' => 'Fecha Último Acceso',
      'createdAt' => 'Fecha de Creación',
      'isActive' => 'Está Activo',
      'portal' => 'Portal'
    ],
    'links' => [
      'actionHistoryRecords' => 'Historial'
    ],
    'presetFilters' => [
      'active' => 'Activo',
      'inactive' => 'Inactivo'
    ],
    'labels' => [
      'Set Inactive' => 'Activar'
    ],
    'massActions' => [
      'setInactive' => 'Desactivar'
    ]
  ],
  'AuthenticationProvider' => [
    'fields' => [
      'method' => 'Method'
    ],
    'labels' => [
      'Create AuthenticationProvider' => 'Create Provider'
    ]
  ],
  'Currency' => [
    'names' => [
      'AED' => 'United Arab Emirates Dirham',
      'AFN' => 'Afghan Afghani',
      'ALL' => 'Albanian Lek',
      'AMD' => 'Armenian Dram',
      'ANG' => 'Netherlands Antillean Guilder',
      'AOA' => 'Angolan Kwanza',
      'ARS' => 'Argentine Peso',
      'AUD' => 'Australian Dollar',
      'AWG' => 'Aruban Florin',
      'AZN' => 'Azerbaijani Manat',
      'BAM' => 'Bosnia-Herzegovina Convertible Mark',
      'BBD' => 'Barbadian Dollar',
      'BDT' => 'Bangladeshi Taka',
      'BGN' => 'Bulgarian Lev',
      'BHD' => 'Bahraini Dinar',
      'BIF' => 'Burundian Franc',
      'BMD' => 'Bermudan Dollar',
      'BND' => 'Brunei Dollar',
      'BOB' => 'Bolivian Boliviano',
      'BOV' => 'Bolivian Mvdol',
      'BRL' => 'Brazilian Real',
      'BSD' => 'Bahamian Dollar',
      'BTN' => 'Bhutanese Ngultrum',
      'BWP' => 'Botswanan Pula',
      'BYN' => 'Belarusian Ruble',
      'BZD' => 'Belize Dollar',
      'CAD' => 'Canadian Dollar',
      'CDF' => 'Congolese Franc',
      'CHE' => 'WIR Euro',
      'CHF' => 'Swiss Franc',
      'CHW' => 'WIR Franc',
      'CLF' => 'Chilean Unit of Account (UF)',
      'CLP' => 'Chilean Peso',
      'CNH' => 'Chinese Yuan (offshore)',
      'CNY' => 'Chinese Yuan',
      'COP' => 'Colombian Peso',
      'COU' => 'Colombian Real Value Unit',
      'CRC' => 'Costa Rican Colón',
      'CUC' => 'Cuban Convertible Peso',
      'CUP' => 'Cuban Peso',
      'CVE' => 'Cape Verdean Escudo',
      'CZK' => 'Czech Koruna',
      'DJF' => 'Djiboutian Franc',
      'DKK' => 'Danish Krone',
      'DOP' => 'Dominican Peso',
      'DZD' => 'Algerian Dinar',
      'EGP' => 'Egyptian Pound',
      'ERN' => 'Eritrean Nakfa',
      'ETB' => 'Ethiopian Birr',
      'EUR' => 'Euro',
      'FJD' => 'Fijian Dollar',
      'FKP' => 'Falkland Islands Pound',
      'GBP' => 'British Pound',
      'GEL' => 'Georgian Lari',
      'GHS' => 'Ghanaian Cedi',
      'GIP' => 'Gibraltar Pound',
      'GMD' => 'Gambian Dalasi',
      'GNF' => 'Guinean Franc',
      'GTQ' => 'Guatemalan Quetzal',
      'GYD' => 'Guyanaese Dollar',
      'HKD' => 'Hong Kong Dollar',
      'HNL' => 'Honduran Lempira',
      'HRK' => 'Croatian Kuna',
      'HTG' => 'Haitian Gourde',
      'HUF' => 'Hungarian Forint',
      'IDR' => 'Indonesian Rupiah',
      'ILS' => 'Israeli New Shekel',
      'INR' => 'Indian Rupee',
      'IQD' => 'Iraqi Dinar',
      'IRR' => 'Iranian Rial',
      'ISK' => 'Icelandic Króna',
      'JMD' => 'Jamaican Dollar',
      'JOD' => 'Jordanian Dinar',
      'JPY' => 'Japanese Yen',
      'KES' => 'Kenyan Shilling',
      'KGS' => 'Kyrgystani Som',
      'KHR' => 'Cambodian Riel',
      'KMF' => 'Comorian Franc',
      'KPW' => 'North Korean Won',
      'KRW' => 'South Korean Won',
      'KWD' => 'Kuwaiti Dinar',
      'KYD' => 'Cayman Islands Dollar',
      'KZT' => 'Kazakhstani Tenge',
      'LAK' => 'Laotian Kip',
      'LBP' => 'Lebanese Pound',
      'LKR' => 'Sri Lankan Rupee',
      'LRD' => 'Liberian Dollar',
      'LSL' => 'Lesotho Loti',
      'LYD' => 'Libyan Dinar',
      'MAD' => 'Moroccan Dirham',
      'MDL' => 'Moldovan Leu',
      'MGA' => 'Malagasy Ariary',
      'MKD' => 'Macedonian Denar',
      'MMK' => 'Myanmar Kyat',
      'MNT' => 'Mongolian Tugrik',
      'MOP' => 'Macanese Pataca',
      'MRO' => 'Mauritanian Ouguiya',
      'MUR' => 'Mauritian Rupee',
      'MWK' => 'Malawian Kwacha',
      'MXN' => 'Mexican Peso',
      'MXV' => 'Mexican Investment Unit',
      'MYR' => 'Malaysian Ringgit',
      'MZN' => 'Mozambican Metical',
      'NAD' => 'Namibian Dollar',
      'NGN' => 'Nigerian Naira',
      'NIO' => 'Nicaraguan Córdoba',
      'NOK' => 'Norwegian Krone',
      'NPR' => 'Nepalese Rupee',
      'NZD' => 'New Zealand Dollar',
      'OMR' => 'Omani Rial',
      'PAB' => 'Panamanian Balboa',
      'PEN' => 'Peruvian Sol',
      'PGK' => 'Papua New Guinean Kina',
      'PHP' => 'Philippine Piso',
      'PKR' => 'Pakistani Rupee',
      'PLN' => 'Polish Zloty',
      'PYG' => 'Paraguayan Guarani',
      'QAR' => 'Qatari Rial',
      'RON' => 'Romanian Leu',
      'RSD' => 'Serbian Dinar',
      'RUB' => 'Russian Ruble',
      'RWF' => 'Rwandan Franc',
      'SAR' => 'Saudi Riyal',
      'SBD' => 'Solomon Islands Dollar',
      'SCR' => 'Seychellois Rupee',
      'SDG' => 'Sudanese Pound',
      'SEK' => 'Swedish Krona',
      'SGD' => 'Singapore Dollar',
      'SHP' => 'St. Helena Pound',
      'SLL' => 'Sierra Leonean Leone',
      'SOS' => 'Somali Shilling',
      'SRD' => 'Surinamese Dollar',
      'SSP' => 'South Sudanese Pound',
      'STN' => 'São Tomé & Príncipe Dobra (2018)',
      'SYP' => 'Syrian Pound',
      'SZL' => 'Swazi Lilangeni',
      'SVC' => 'Salvadoran Colón',
      'THB' => 'Thai Baht',
      'TJS' => 'Tajikistani Somoni',
      'TND' => 'Tunisian Dinar',
      'TOP' => 'Tongan Paʻanga',
      'TRY' => 'Turkish Lira',
      'TTD' => 'Trinidad & Tobago Dollar',
      'TWD' => 'New Taiwan Dollar',
      'TZS' => 'Tanzanian Shilling',
      'UAH' => 'Ukrainian Hryvnia',
      'UGX' => 'Ugandan Shilling',
      'USD' => 'US Dollar',
      'USN' => 'US Dollar (Next day)',
      'UYI' => 'Uruguayan Peso (Indexed Units)',
      'UYU' => 'Uruguayan Peso',
      'UZS' => 'Uzbekistani Som',
      'VEF' => 'Venezuelan Bolívar',
      'VND' => 'Vietnamese Dong',
      'VUV' => 'Vanuatu Vatu',
      'WST' => 'Samoan Tala',
      'XAF' => 'Central African CFA Franc',
      'XCD' => 'East Caribbean Dollar',
      'XOF' => 'West African CFA Franc',
      'XPF' => 'CFP Franc',
      'YER' => 'Yemeni Rial',
      'ZAR' => 'South African Rand',
      'ZMW' => 'Zambian Kwacha',
      'ZWL' => 'Zimbabwe Dollar'
    ]
  ],
  'DashboardTemplate' => [
    'fields' => [
      'layout' => 'Layout',
      'append' => 'Append (don\'t remove user\'s tabs)'
    ],
    'links' => [],
    'labels' => [
      'Create DashboardTemplate' => 'Create Template',
      'Deploy to Users' => 'Deploy to Users',
      'Deploy to Team' => 'Deploy to Team'
    ]
  ],
  'DashletOptions' => [
    'fields' => [
      'title' => 'Título',
      'dateFrom' => 'Fecha desde',
      'dateTo' => 'Fecha hasta',
      'autorefreshInterval' => 'Intervalo de actualización',
      'displayRecords' => 'Mostrar Registros',
      'isDoubleHeight' => 'Altitud 2x',
      'mode' => 'Modo',
      'enabledScopeList' => 'Qué mostrar',
      'users' => 'Usuarios',
      'entityType' => 'Tipo de Entidad',
      'primaryFilter' => 'Filtro Primario',
      'boolFilterList' => 'Filtros Adicionales',
      'sortBy' => 'Campo para Ordenar',
      'sortDirection' => 'Ordenar (dirección)',
      'expandedLayout' => 'Formato',
      'skipOwn' => 'Don\'t show own records',
      'url' => 'URL',
      'dateFilter' => 'Filtro de Fecha',
      'text' => 'Text',
      'folder' => 'Folder',
      'includeShared' => 'Include Shared',
      'team' => 'Team',
      'futureDays' => 'Siguientes \'n\' Días',
      'useLastStage' => 'Agrupar por la última etapa lograda',
      'report' => 'Report',
      'column' => 'Summation Column',
      'displayOnlyCount' => 'Display Only Total',
      'displayTotal' => 'Display Total',
      'useSiMultiplier' => 'SI Multiplier',
      'displayType' => 'What to display',
      'includeOwn' => 'Include Owned'
    ],
    'options' => [
      'mode' => [
        'agendaWeek' => 'Semana (agenda)',
        'basicWeek' => 'Semana',
        'month' => 'Mes',
        'basicDay' => 'Día',
        'agendaDay' => 'Día (agenda)',
        'timeline' => 'Cronograma'
      ],
      'sortDirection' => [
        'asc' => 'Ascending',
        'desc' => 'Descending'
      ]
    ],
    'messages' => [
      'selectEntityType' => 'Seleccionar el Tipo de Entidad en las opciones del panel.'
    ],
    'tooltips' => [
      'skipOwn' => 'Actions made by your user account won\'t be displayed.'
    ]
  ],
  'DynamicLogic' => [
    'labels' => [
      'Field' => 'Campo'
    ],
    'options' => [
      'operators' => [
        'equals' => 'Igual a',
        'notEquals' => 'Diferente de',
        'greaterThan' => 'Mayor que',
        'lessThan' => 'Menor que',
        'greaterThanOrEquals' => 'Mayor o igual a',
        'lessThanOrEquals' => 'Menor o igual que',
        'in' => 'En',
        'notIn' => 'No en',
        'inPast' => 'En Pasado',
        'inFuture' => 'Es Futuro',
        'isToday' => 'Es Hoy',
        'isTrue' => 'Es Verdadero',
        'isFalse' => 'Es Falso',
        'isEmpty' => 'Está Vacío',
        'isNotEmpty' => 'No está vacío',
        'contains' => 'Contiene',
        'notContains' => 'No Contiene',
        'has' => 'Contiene',
        'notHas' => 'No Contiene',
        'startsWith' => 'Starts With',
        'endsWith' => 'Ends With',
        'matches' => 'Matches (reg exp)'
      ]
    ]
  ],
  'Email' => [
    'fields' => [
      'name' => 'Nombre (Sujeto)',
      'parent' => 'Padre',
      'status' => 'Estátus',
      'dateSent' => 'Enviado',
      'from' => 'De',
      'to' => 'Para',
      'cc' => 'CC',
      'bcc' => 'BCC',
      'replyTo' => 'Responder a',
      'replyToString' => 'Responder a (String)',
      'personStringData' => 'Person String Data',
      'isHtml' => 'Es Html',
      'body' => 'Cuerpo',
      'bodyPlain' => 'Cuerpo (plano)',
      'subject' => 'Asunto',
      'attachments' => 'Adjuntos',
      'selectTemplate' => 'Seleccione una Plantilla',
      'fromEmailAddress' => 'From Address (link)',
      'emailAddress' => 'Dirección de Correo',
      'deliveryDate' => 'Fecha Entrega',
      'account' => 'Cuenta',
      'users' => 'Usuarios',
      'replied' => 'Respondió',
      'replies' => 'Respuestas',
      'isRead' => 'Fue leído',
      'isNotRead' => 'No Leído',
      'isImportant' => 'Es Importante',
      'isReplied' => 'Tiene Respuesta',
      'isNotReplied' => 'No Tiene Respuesta',
      'isUsers' => 'Es del Usuario',
      'isUsersSent' => 'Is User\'s Sent',
      'inTrash' => 'En el Basurero',
      'inArchive' => 'In Archive',
      'folder' => 'Carpeta',
      'inboundEmails' => 'Cuentas de Grupo',
      'emailAccounts' => 'Cuentas Personales',
      'hasAttachment' => 'Tiene Adjuntos',
      'assignedUsers' => 'Usuarios Asignados',
      'sentBy' => 'Enviado por',
      'toEmailAddresses' => 'Direcciones (Para)',
      'ccEmailAddresses' => 'Direcciones CC',
      'bccEmailAddresses' => 'Direcciones (CCO)',
      'replyToEmailAddresses' => 'Direcciones (Responder)',
      'messageId' => 'Id del Mensaje',
      'messageIdInternal' => 'Id del Mensaje (Interna)',
      'folderId' => 'Id de la Carpeta',
      'folderString' => 'Folder',
      'fromName' => 'Nombre (De)',
      'fromString' => 'String (De)',
      'fromAddress' => 'De la dirección',
      'replyToName' => 'Reply-To Name',
      'replyToAddress' => 'Reply-To Address',
      'isSystem' => 'Es del Sistema',
      'icsContents' => 'ICS Contents',
      'icsEventData' => 'ICS Event Data',
      'icsEventUid' => 'ICS Event UID',
      'createdEvent' => 'Created Event',
      'event' => 'Event',
      'icsEventDateStart' => 'ICS Event Date Start',
      'groupFolder' => 'Group Folder',
      'groupStatusFolder' => 'Group Status Folder',
      'sendAt' => 'Send At',
      'tasks' => 'Tasks',
      'emailContent' => 'Email Content'
    ],
    'links' => [
      'replied' => 'Respondió',
      'replies' => 'Respuestas',
      'inboundEmails' => 'Cuentas de Grupo',
      'emailAccounts' => 'Cuentas Personales',
      'assignedUsers' => 'Usuarios Asignados',
      'sentBy' => 'Enviado por',
      'attachments' => 'Adjuntos',
      'fromEmailAddress' => 'Cuentas de Correo (De)',
      'toEmailAddresses' => 'Cuentas de Correo (Para)',
      'ccEmailAddresses' => 'Cuentas de Correo (CC)',
      'bccEmailAddresses' => 'Cuentas de Correo (CCO)',
      'replyToEmailAddresses' => 'Direcciones (Responder)',
      'createdEvent' => 'Created Event',
      'groupFolder' => 'Group Folder',
      'emailContent' => 'Email Content'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Borrador',
        'Sending' => 'Enviando',
        'Sent' => 'Enviado',
        'Archived' => 'Archivado',
        'Received' => 'Recibido',
        'Failed' => 'Falló'
      ],
      'groupStatusFolder' => [
        'Archive' => 'Archive',
        'Trash' => 'Trash'
      ]
    ],
    'labels' => [
      'Create Email' => 'Archivar Correo',
      'Archive Email' => 'Archivar Correo',
      'Import EML' => 'Import EML',
      'Compose' => 'Nuevo',
      'Reply' => 'Responder',
      'Reply to All' => 'Responder a Todos',
      'Forward' => 'Reenviar',
      'Insert Field' => 'Insert Field',
      'Original message' => 'Mensaje Original',
      'Forwarded message' => 'Mensaje reenviado',
      'Email Accounts' => 'Cuentas de Correo Personales',
      'Inbound Emails' => 'Agrupar Cuentas de Correo',
      'Email Templates' => 'Plantillas de Correo',
      'Send Test Email' => 'Enviar Correo de Prueba',
      'Send' => 'Enviar',
      'Email Address' => 'Correo',
      'Mark Read' => 'Marcar como Leído',
      'Sending...' => 'Enviando...',
      'Save Draft' => 'Guardar Borrador',
      'Mark all as read' => 'Marcar todos como leídos',
      'Show Plain Text' => 'Ver en texto plano',
      'Mark as Important' => 'Marcar como Importante',
      'Unmark Importance' => 'Marcar como No Importante',
      'Move to Trash' => 'Mover al Basurero',
      'Retrieve from Trash' => 'Recuperar del Basurero',
      'Move to Folder' => 'Mover a la Carpeta',
      'Moved to Archive' => 'Moved to Archive',
      'No Records Moved' => 'No Records Moved',
      'Filters' => 'Filtros',
      'Folders' => 'Carpetas',
      'Group Folders' => 'Group Folders',
      'No Subject' => 'No Subject',
      'View Users' => 'View Users',
      'Event' => 'Event',
      'View Attachments' => 'View Attachments',
      'Moved to Trash' => 'Moved to Trash',
      'Retrieved from Trash' => 'Retrieved from Trash',
      'Schedule Send' => 'Schedule Send',
      'Create Lead' => 'Crear Referencia',
      'Create Contact' => 'Crear Contacto',
      'Add to Contact' => 'Agregar a Contactos',
      'Add to Lead' => 'Agregar a Referencias',
      'Create Task' => 'Crear Tarea',
      'Create Case' => 'Crear Caso'
    ],
    'strings' => [
      'sendingFailed' => 'Email sending failed',
      'group' => 'Group'
    ],
    'messages' => [
      'confirmSend' => 'Send the email?',
      'couldNotSentScheduledEmail' => 'Could not send scheduled [email]({link})',
      'notEditAccess' => 'No edit access to email.',
      'groupFolderNoAccess' => 'No access to group folder.',
      'groupMoveOutNoEditAccess' => 'Cannot move out from group folder. No edit access to email.',
      'groupMoveToNoEditAccess' => 'Cannot move to group folder. No edit access to email.',
      'groupMoveToTrashNoEditAccess' => 'Cannot move email from group folder to trash. No edit access to email.',
      'groupMoveToArchiveNoEditAccess' => 'Cannot move from group folder to Archive. No edit access to email.',
      'alreadyImported' => 'The [email]({link}) already exists in the system.',
      'invalidCredentials' => 'Invalid credentials.',
      'unknownError' => 'Unknown error.',
      'recipientAddressRejected' => 'Recipient address rejected.',
      'noSmtpSetup' => 'No está configurado el SMTP. {link}.',
      'testEmailSent' => 'Correo de prueba enviado',
      'emailSent' => 'Correo enviado',
      'savedAsDraft' => 'Guardado como borrador',
      'sendConfirm' => 'Send the email?',
      'removeSelectedRecordsConfirmation' => 'Are you sure you want to remove selected emails?

They will be removed for other users too.',
      'removeRecordConfirmation' => 'Are you sure you want to remove the email?

It will be removed for other users too.',
      'confirmInsertTemplate' => 'El cuerpo del correo se perderá. ¿Realmente desea insertar la plantilla?'
    ],
    'presetFilters' => [
      'sent' => 'Enviado',
      'archived' => 'Archivado',
      'inbox' => 'Bandeja de Entrada',
      'drafts' => 'Borradores',
      'trash' => 'Basurero',
      'archive' => 'Archive',
      'important' => 'Importante'
    ],
    'actions' => [
      'moveToArchive' => 'Archive'
    ],
    'massActions' => [
      'markAsRead' => 'Mark as Read',
      'markAsNotRead' => 'Marcar como No Leído',
      'markAsImportant' => 'Marcar como Importante',
      'markAsNotImportant' => 'Marcar como No Importante',
      'moveToTrash' => 'Mover al Basurero',
      'moveToFolder' => 'Mover a la Carpeta',
      'moveToArchive' => 'Archive',
      'retrieveFromTrash' => 'Recuperar del Basurero'
    ],
    'otherFields' => [
      'file' => 'File'
    ]
  ],
  'EmailAccount' => [
    'fields' => [
      'name' => 'Nombre',
      'status' => 'Estado',
      'host' => 'Servidor',
      'username' => 'Nombre de Usuario',
      'password' => 'Contraseña',
      'port' => 'Puerto',
      'monitoredFolders' => 'Carpetas Supervisadas',
      'security' => 'Security',
      'fetchSince' => 'Obtener Desde',
      'emailAddress' => 'Dirección de Correo',
      'sentFolder' => 'Carpeta de Enviados',
      'storeSentEmails' => 'Almacenar Correos Enviados',
      'keepFetchedEmailsUnread' => 'Mantener los correos obtenidos sin leer',
      'emailFolder' => 'Poner en la Carpeta',
      'connectedAt' => 'Connected At',
      'useImap' => 'Obtener Correos',
      'useSmtp' => 'Use SMTP',
      'smtpHost' => 'Servidor SMTP',
      'smtpPort' => 'Puerto SMTP',
      'smtpAuth' => 'Cuenta SMTP',
      'smtpSecurity' => 'Seguridad SMTP',
      'smtpAuthMechanism' => 'SMTP Auth Mechanism',
      'smtpUsername' => 'Usuario SMTP',
      'smtpPassword' => 'Contraseña SMTP'
    ],
    'links' => [
      'filters' => 'Filtros',
      'emails' => 'Correos'
    ],
    'options' => [
      'status' => [
        'Active' => 'Activo',
        'Inactive' => 'Inactivo'
      ],
      'smtpAuthMechanism' => [
        'plain' => 'PLAIN',
        'login' => 'LOGIN',
        'crammd5' => 'CRAM-MD5'
      ]
    ],
    'labels' => [
      'Create EmailAccount' => 'Crear Cuenta de Correo',
      'IMAP' => 'IMAP',
      'Main' => 'Principal',
      'Test Connection' => 'Probar conexión',
      'Send Test Email' => 'Enviar Correo de Prueba',
      'SMTP' => 'SMTP'
    ],
    'presetFilters' => [
      'active' => 'Active'
    ],
    'messages' => [
      'couldNotConnectToImap' => 'No se pudo conectar con el servidor IMAP',
      'connectionIsOk' => 'Conexión correcta',
      'imapNotConnected' => 'Could not connect to [IMAP account](#EmailAccount/view/{id}).'
    ],
    'tooltips' => [
      'useSmtp' => 'The ability to send emails.',
      'emailAddress' => 'The user record (assigned user) should have the same email address to be able to use this email account for sending.',
      'monitoredFolders' => 'Si usa varias carpetas, debe separarlas con coma',
      'storeSentEmails' => 'Los correos enviados serán guardados en el servidor IMAP.  El campo de  dirección del correo deberá coincidir con las direcciones de los correos que serán enviados.'
    ]
  ],
  'EmailAddress' => [
    'labels' => [
      'Primary' => 'Primario',
      'Opted Out' => 'Rechazado',
      'Invalid' => 'Inválido'
    ],
    'fields' => [
      'optOut' => 'Opted Out',
      'invalid' => 'Invalid'
    ],
    'presetFilters' => [
      'orphan' => 'Orphan'
    ]
  ],
  'EmailFilter' => [
    'fields' => [
      'from' => 'De',
      'to' => 'Para',
      'subject' => 'Asunto',
      'bodyContains' => 'Contenido del Cuerpo',
      'bodyContainsAll' => 'Body Contains All',
      'action' => 'Acción',
      'isGlobal' => 'Es Global',
      'emailFolder' => 'Carpeta',
      'groupEmailFolder' => 'Group Email Folder',
      'markAsRead' => 'Mark as Read',
      'skipNotification' => 'Skip Notification'
    ],
    'links' => [
      'emailFolder' => 'Folder',
      'groupEmailFolder' => 'Group Email Folder'
    ],
    'labels' => [
      'Create EmailFilter' => 'Crear Filtro de Correo',
      'Emails' => 'Correos'
    ],
    'options' => [
      'action' => [
        'None' => 'None',
        'Skip' => 'Ignorar',
        'Move to Folder' => 'Carpeta',
        'Move to Group Folder' => 'Put in Group Folder'
      ]
    ],
    'tooltips' => [
      'name' => 'Indique un nombre descriptivo del filtro.',
      'subject' => 'Use el comodín *:

texto*  - inicia con \'texto\',
*texto* - contiene \'texto\',
*texto  - termina en \'text\'.',
      'bodyContains' => 'El cuerpo del correo contiene alguna de la palabras o frases especificadas.',
      'bodyContainsAll' => 'An email body contains all specified words or phrases.',
      'from' => 'Los correos enviados desde la dirección especificada. Dejar en blanco si no es necesario.',
      'to' => 'Los correos electrónicos que se envían a la dirección especificada. Dejar en blanco si no es necesario.',
      'isGlobal' => 'Aplicar este filtro a todos los correos entrantes del sistema.'
    ]
  ],
  'EmailFolder' => [
    'fields' => [
      'skipNotifications' => 'Saltar Notificaciones'
    ],
    'labels' => [
      'Create EmailFolder' => 'Crear Carpeta',
      'Manage Folders' => 'Carpetas',
      'Emails' => 'Correos'
    ]
  ],
  'EmailTemplate' => [
    'fields' => [
      'name' => 'Nombre',
      'status' => 'Estado',
      'isHtml' => 'Es HTML',
      'body' => 'Cuerpo',
      'subject' => 'Asunto',
      'attachments' => 'Adjuntos',
      'oneOff' => 'Único',
      'category' => 'Categoría',
      'insertField' => 'Insertar Campo'
    ],
    'links' => [],
    'labels' => [
      'Create EmailTemplate' => 'Crear Plantilla de Correo',
      'Info' => 'Información',
      'Available placeholders' => 'Marcadores disponibles'
    ],
    'messages' => [
      'infoText' => 'Marcadores disponibles:

{optOutUrl} &#8211; Dirección URL para deslistarse;

{optOutLink} &#8211; una liga para deslistarse.'
    ],
    'tooltips' => [
      'oneOff' => 'Compruebe si usted va a utilizar esta plantilla sólo una vez. Por ejemplo: para Correo Masivo.'
    ],
    'presetFilters' => [
      'actual' => 'Actuales'
    ],
    'placeholderTexts' => [
      'today' => 'Fecha de hoy',
      'now' => 'Fecha y hora actual',
      'currentYear' => 'Año actual',
      'optOutUrl' => 'Dirección URL para deslistarse',
      'optOutLink' => 'una liga para deslistarse'
    ]
  ],
  'EmailTemplateCategory' => [
    'labels' => [
      'Create EmailTemplateCategory' => 'Crear Categoría',
      'Manage Categories' => 'Administrar Categorías',
      'EmailTemplates' => 'Formatos de Correo'
    ],
    'fields' => [
      'order' => 'Ordenar',
      'childList' => 'Lista de Hijos'
    ],
    'links' => [
      'emailTemplates' => 'Formatos de Correo'
    ]
  ],
  'EntityManager' => [
    'labels' => [
      'Fields' => 'Campos',
      'Relationships' => 'Relaciones',
      'Layouts' => 'Layouts',
      'Schedule' => 'Agenda',
      'Log' => 'Historial',
      'Formula' => 'Fórmula',
      'Parameters' => 'Parameters'
    ],
    'fields' => [
      'name' => 'Nombre',
      'type' => 'Tipo',
      'labelSingular' => 'Etiqueta en Singular',
      'labelPlural' => 'Etiqueta en Plural',
      'stream' => 'Flujo',
      'label' => 'Etiqueta',
      'linkType' => 'Tipo de enlace',
      'entity' => 'Entity',
      'entityForeign' => 'Entidad Foránea',
      'linkForeign' => 'Enlace Foráneo',
      'link' => 'Enlace',
      'labelForeign' => 'Etiqueta Foránea',
      'sortBy' => 'Orden Default (campo)',
      'sortDirection' => 'Orden Default (dirección)',
      'relationName' => 'Nombre de la Tabla Intermedia',
      'linkMultipleField' => 'Ligar Varios Campos',
      'linkMultipleFieldForeign' => 'Ligar Varios Campos Foráneos',
      'disabled' => 'Desactivado',
      'textFilterFields' => 'Campos de Filtros de Texto',
      'audited' => 'Auditado',
      'auditedForeign' => 'Auditado Externamente',
      'statusField' => 'Campo de Estátus',
      'beforeSaveCustomScript' => 'Antes de Guardar el Código Personalizado',
      'beforeSaveApiScript' => 'API Before Save Script',
      'color' => 'Color',
      'kanbanViewMode' => 'Vista por Tarjetas',
      'kanbanStatusIgnoreList' => 'Grupos ignorados en la vista por Tarjetas',
      'iconClass' => 'Icono',
      'countDisabled' => 'Disable record count',
      'fullTextSearch' => 'Búsqueda por Texto',
      'parentEntityTypeList' => 'Parent Entity Types',
      'foreignLinkEntityTypeList' => 'Foreign Links',
      'optimisticConcurrencyControl' => 'Optimistic concurrency control',
      'preserveAuditLog' => 'Preserve Audit Log',
      'updateDuplicateCheck' => 'Duplicate check on update',
      'duplicateCheckFieldList' => 'Duplicate check fields',
      'stars' => 'Stars',
      'layout' => 'Layout',
      'selectFilter' => 'Select Filter',
      'author' => 'Author',
      'module' => 'Module',
      'version' => 'Version',
      'primaryFilters' => 'Primary Filters',
      'assignedUsers' => 'Multiple Assigned Users',
      'collaborators' => 'Collaborators',
      'aclContactLink' => 'ACL Contact Link',
      'aclAccountLink' => 'ACL Account Link',
      'activityStatusList' => 'Activity Statuses',
      'historyStatusList' => 'History Statuses',
      'completedStatusList' => 'Completed Statuses',
      'canceledStatusList' => 'Canceled Statuses',
      'variantSyncFieldList' => 'Variant sync fields',
      'doneStatusList' => 'Done Statuses',
      'softReserveStatusList' => 'Soft Reserve Statuses',
      'reserveStatusList' => 'Reserve Statuses',
      'failedStatusList' => 'Failed Statuses',
      'deliveryRequiredStatusList' => 'Delivery Required Statuses',
      'lockableFieldList' => 'Lock Fields'
    ],
    'options' => [
      'type' => [
        '' => '(vacío)',
        'Base' => 'Base',
        'Person' => 'Persona',
        'CategoryTree' => 'Árbol de Categorías',
        'Event' => 'Evento',
        'BasePlus' => 'Base Plus',
        'Company' => 'Empresa'
      ],
      'linkType' => [
        'manyToMany' => 'Muchos-a-Muchos',
        'oneToMany' => 'Uno-a-Muchos',
        'manyToOne' => 'Muchos-a-uno',
        'oneToOneRight' => 'One-to-One Right',
        'oneToOneLeft' => 'One-to-One Left',
        'parentToChildren' => 'Padres-a-Hijos',
        'childrenToParent' => 'Hijos-a-Padres'
      ],
      'sortDirection' => [
        'asc' => 'Ascendente',
        'desc' => 'Descendente'
      ],
      'module' => [
        'Custom' => 'Custom'
      ]
    ],
    'messages' => [
      'urlHashCopiedToClipboard' => 'A URL fragment for the *{name}* filter is copied to the clipboard. You can add it to the navbar.',
      'confirmRemoveLink' => 'Are you sure you want to remove the *{link}* relationship?',
      'nameIsAlreadyUsed' => 'Name \'{name}\' is already used.',
      'nameIsNotAllowed' => 'Name \'{name}\' is not allowed.',
      'nameIsTooLong' => 'Name is too long.',
      'confirmRemove' => 'Are you sure you want to remove the entity type from the system?',
      'entityCreated' => 'La entidad ha sido creada',
      'linkAlreadyExists' => 'Conflicto de nombres en el enlace.',
      'linkConflict' => 'Ya existe un enlace con el mismo nombra.',
      'beforeSaveCustomScript' => 'A script called every time before an entity is saved. Use for setting calculated fields.',
      'beforeSaveApiScript' => 'A script called on create and update API requests before an entity is saved. Use for custom validation and duplicate checking.'
    ],
    'tooltips' => [
      'aclContactLink' => 'The link with Contact to use when applying access control for portal users.',
      'aclAccountLink' => 'The link with Account to use when applying access control for portal users.',
      'collaborators' => 'The ability to share records with specific users.',
      'assignedUsers' => 'The ability to assign multiple users to a record.

Note that after enabling the parameter, existing assigned users won\'t be transferred to the new *Assigned Users* field.',
      'duplicateCheckFieldList' => 'Which fields to check when performing checking for duplicates.',
      'updateDuplicateCheck' => 'Perform checking for duplicates when updating a record.',
      'optimisticConcurrencyControl' => 'Prevents writing conflicts.',
      'preserveAuditLog' => 'Disables cleanup of the audit log. This parameter is applicable only if Stream is disabled. As if Stream is enabled, audit log records are not being deleted.',
      'stars' => 'The ability to star records. Stars can be used by users to bookmark records.',
      'statusField' => 'Los cambios en este campo serán registrados en su flujo',
      'textFilterFields' => 'Campos usados por la búsqueda de texto',
      'stream' => 'Si la entidad tiene Flujo.',
      'disabled' => 'Verifique si ya no necesita esta entidad en su sistema.',
      'linkAudited' => 'La creación de registros relacionados y su liga con con registros existentes se registrará en su flujo.',
      'linkMultipleField' => 'El campo \'Multi-Ligas\' es una forma fácil de editar relaciones.  No lo uses si tienes muchos registros.',
      'linkSelectFilter' => 'A primary filter to apply by default when selecting a record.',
      'entityType' => 'Base Plus - tiene páneles de Actividades, Historial y Tareas.

Evento - disponible en los páneles de Calendario y Actividades',
      'countDisabled' => 'Total number won\'t be displayed on the list view. Can decrease loading time when the DB table is big.',
      'fullTextSearch' => 'Se requiere regenerar',
      'linkParamReadOnly' => 'A read-only link cannot be edited via the *link* and *unlink* API requests. It won\'t be possible to relate and unrelate records via the relationship panel. It still possible to edit read-only links via link and link-multiple fields.',
      'activityStatusList' => 'Status values determining that an activity record should be displayed in the Activity panel and considered as actual.',
      'historyStatusList' => 'Status values determining that an activity record should be displayed in the History panel.',
      'completedStatusList' => 'Status values determining that an activity is completed.',
      'canceledStatusList' => 'Status values determining that an activity is canceled and won\'t be taken into account in free/busy ranges.',
      'lockableFieldList' => 'Fields that become read-only when an order is locked.',
      'productVariantSyncFieldList' => 'Fields that are synced from a template to product variants.',
      'salesOrderSoftReserveStatusList' => 'Statuses on which inventory is soft reserved.',
      'salesOrderDoneStatusList' => 'Statuses indicating that a sales order is done.',
      'purchaseOrderDoneStatusList' => 'Statuses indicating that a purchase order is done.',
      'purchaseOrderCanceledStatusList' => 'Statuses indicating that an order is canceled.',
      'receiptOrderDoneStatusList' => 'Statuses indicating that a receipt order is done.',
      'receiptOrderCanceledStatusList' => 'Statuses indicating that a receipt order is canceled.',
      'salesOrderCanceledStatusList' => 'Statuses indicating that an order is canceled.',
      'invoiceDoneStatusList' => 'Statuses indicating that an invoice is done.',
      'invoiceCanceledStatusList' => 'Statuses indicating that an invoice is canceled.',
      'quoteDoneStatusList' => 'Statuses indicating that a quote is done.',
      'quoteCanceledStatusList' => 'Statuses indicating that a quote is canceled.',
      'deliveryRequiredStatusList' => 'Statuses on which a delivery order should be created.',
      'deliveryOrderCanceledStatusList' => 'Statuses indicating that a delivery order is canceled. Inventory is automatically returned to stock.',
      'deliveryOrderReserveStatusList' => 'Statuses on which inventory is reserved.',
      'deliveryOrderSoftReserveStatusList' => 'Statuses on which inventory is soft reserved.',
      'deliveryOrderFailedStatusList' => 'Statuses indicating that a delivery order could not be delivered. Inventory is not automatically returned to stock. Manual intervention might be required.',
      'deliveryOrderDoneStatusList' => 'Statuses indicating that a delivery order is done.',
      'transferOrderCanceledStatusList' => 'Statuses indicating that a transfer order is canceled. Inventory is automatically returned to stock.',
      'transferOrderReserveStatusList' => 'Statuses on which inventory is reserved.',
      'transferOrderSoftReserveStatusList' => 'Statuses on which inventory is soft reserved.',
      'transferOrderFailedStatusList' => 'Statuses indicating that a transfer order could not be delivered. Inventory is not automatically returned to stock. Manual intervention might be required.',
      'transferOrderDoneStatusList' => 'Statuses indicating that a transfer order is done.',
      'returnOrderDoneStatusList' => 'Statuses indicating that a return order is done.',
      'returnOrderCanceledStatusList' => 'Statuses indicating that a return order is canceled.'
    ]
  ],
  'Export' => [
    'fields' => [
      'exportAllFields' => 'Exportar todos los campos',
      'fieldList' => 'Lista de Campos',
      'format' => 'Formato',
      'status' => 'Status',
      'xlsxLite' => 'Lite',
      'xlsxRecordLinks' => 'Record Links',
      'xlsxTitle' => 'Title'
    ],
    'options' => [
      'format' => [
        'csv' => 'CSV',
        'xlsx' => 'XLSX (Excel)'
      ],
      'status' => [
        'Pending' => 'Pending',
        'Running' => 'Running',
        'Success' => 'Success',
        'Failed' => 'Failed'
      ]
    ],
    'tooltips' => [
      'xlsxLite' => 'Consumes much less memory. Recommended if a big number of records is exported.',
      'xlsxTitle' => 'Print a title and current date in the header.'
    ],
    'messages' => [
      'exportProcessed' => 'Export has been processed. Download the [file]({url}).',
      'infoText' => 'The export is being processed in idle by cron. It can take some time to finish. Closing this modal dialog won\'t affect the execution process.'
    ]
  ],
  'Extension' => [
    'fields' => [
      'name' => 'Nombre',
      'version' => 'Version',
      'description' => 'Descripción',
      'isInstalled' => 'Instalado',
      'checkVersionUrl' => 'URL para buscar nuevas versiones '
    ],
    'labels' => [
      'Uninstall' => 'Desinstalar',
      'Install' => 'Instalar'
    ],
    'messages' => [
      'uninstalled' => 'La extension {name} ha sido desinstalada',
      'fileExceedsMaxUploadSize' => 'The file size exceeds the max upload size {maxSize}. Consider increasing `post_max_size` or install the extension via CLI.'
    ]
  ],
  'ExternalAccount' => [
    'labels' => [
      'Connect' => 'Conectar',
      'Disconnect' => 'Disconnect',
      'Disconnected' => 'Disconnected',
      'Connected' => 'Conectado'
    ],
    'help' => [],
    'messages' => [
      'externalAccountNoConnectDisabled' => 'External account for integration \'{integration}\' has been disabled due not being able to connect.'
    ]
  ],
  'FieldManager' => [
    'labels' => [
      'Dynamic Logic' => 'Lógica Dinámica',
      'Name' => 'Nombre',
      'Label' => 'Etiqueta',
      'Type' => 'Tipo'
    ],
    'options' => [
      'dateTimeDefault' => [
        '' => 'Ninguno',
        'javascript: return this.dateTime.getNow(1);' => 'Hoy',
        'javascript: return this.dateTime.getNow(5);' => 'Hoy (5m)',
        'javascript: return this.dateTime.getNow(15);' => 'Hoy (15 m)',
        'javascript: return this.dateTime.getNow(30);' => 'Hoy (30 m)',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(1, \'hours\', 15);' => '+1 hora',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(2, \'hours\', 15);' => '+2 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(3, \'hours\', 15);' => '+3 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(4, \'hours\', 15);' => '+4 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(5, \'hours\', 15);' => '+5 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(6, \'hours\', 15);' => '+6 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(7, \'hours\', 15);' => '+7 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(8, \'hours\', 15);' => '+8 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(9, \'hours\', 15);' => '+9 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(10, \'hours\', 15);' => '+10 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(11, \'hours\', 15);' => '+11 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(12, \'hours\', 15);' => '+12 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(1, \'days\', 15);' => '+1 día',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(2, \'days\', 15);' => '+2 días',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(3, \'days\', 15);' => '+3 días',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(4, \'days\', 15);' => '+4 días',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(5, \'days\', 15);' => '+5 días',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(6, \'days\', 15);' => '+6 días',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(1, \'week\', 15);' => '+1 semana'
      ],
      'dateDefault' => [
        '' => 'Ninguno',
        'javascript: return this.dateTime.getToday();' => 'Hoy',
        'javascript: return this.dateTime.getDateShiftedFromToday(1, \'days\');' => '+1 día',
        'javascript: return this.dateTime.getDateShiftedFromToday(2, \'days\');' => '+2 días',
        'javascript: return this.dateTime.getDateShiftedFromToday(3, \'days\');' => '+3 días',
        'javascript: return this.dateTime.getDateShiftedFromToday(4, \'days\');' => '+4 días',
        'javascript: return this.dateTime.getDateShiftedFromToday(5, \'days\');' => '+5 días',
        'javascript: return this.dateTime.getDateShiftedFromToday(6, \'days\');' => '+6 días',
        'javascript: return this.dateTime.getDateShiftedFromToday(7, \'days\');' => '+7 días',
        'javascript: return this.dateTime.getDateShiftedFromToday(8, \'days\');' => '+8 días',
        'javascript: return this.dateTime.getDateShiftedFromToday(9, \'days\');' => '+9 días',
        'javascript: return this.dateTime.getDateShiftedFromToday(10, \'days\');' => '+10 días',
        'javascript: return this.dateTime.getDateShiftedFromToday(1, \'weeks\');' => '+1 semana',
        'javascript: return this.dateTime.getDateShiftedFromToday(2, \'weeks\');' => '+2 semanas',
        'javascript: return this.dateTime.getDateShiftedFromToday(3, \'weeks\');' => '+3 semanas',
        'javascript: return this.dateTime.getDateShiftedFromToday(1, \'months\');' => '+1 mes',
        'javascript: return this.dateTime.getDateShiftedFromToday(2, \'months\');' => '+2 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(3, \'months\');' => '+3 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(4, \'months\');' => '+4 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(5, \'months\');' => '+5 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(6, \'months\');' => '+6 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(7, \'months\');' => '+7 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(8, \'months\');' => '+8 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(9, \'months\');' => '+9 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(10, \'months\');' => '+10 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(11, \'months\');' => '+11 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(1, \'year\');' => '+1 año'
      ],
      'barcodeType' => [
        'EAN13' => 'EAN-13',
        'EAN8' => 'EAN-8',
        'EAN5' => 'EAN-5',
        'EAN2' => 'EAN-2',
        'UPC' => 'UPC (A)',
        'UPCE' => 'UPC (E)',
        'pharmacode' => 'Pharmacode',
        'QRcode' => 'QR code'
      ],
      'globalRestrictions' => [
        'forbidden' => 'Forbidden',
        'internal' => 'Internal',
        'onlyAdmin' => 'Admin-only',
        'readOnly' => 'Read-only',
        'nonAdminReadOnly' => 'Non-admin read-only'
      ]
    ],
    'tooltips' => [
      'optionsReference' => 'Re-use options from another field.',
      'currencyDecimal' => 'Use the Decimal DB type. In the app, values will be represented as strings. Check this parameter if precision is required.',
      'cutHeight' => 'A text higher then a specified value will be cut with a \'show more\' button displayed.',
      'urlStrip' => 'Strip a protocol and a trailing slash.',
      'audited' => 'Las actualizaciones se registrarán en el Flujo',
      'required' => 'El campo será obligatorio.  No puede ir vacío.',
      'default' => 'Se asignará el valor default al crearlo.',
      'min' => 'Valor mínimo permitido.',
      'max' => 'Valor máximo permitido.',
      'seeMoreDisabled' => 'Si no se marca, los textos largos serán recortados.',
      'lengthOfCut' => 'Que tan largo puede ser el texto antes de ser recortado.',
      'maxLength' => 'Tamaño máximo acepable del texto.',
      'before' => 'La fecha capturada debe ser anterior a la del campo que indique aquí.',
      'after' => 'La fecha capturada debe ser posterior a la del campo que indique aquí',
      'readOnly' => 'El valor del campo no puede ser especificado por el usuario.  Pero puede ser calculado por formula.',
      'readOnlyAfterCreate' => 'The field value can be specified when creating a new record. After that, the field becomes read-only. It can still be calculated by formula.',
      'preview' => 'Show the preview button. Applicable if Markdown is enabled.',
      'fileAccept' => 'Which file types to accept. It\'s possible to add custom items.',
      'barcodeLastChar' => 'For EAN-13 type.',
      'maxFileSize' => 'Vacío o es 0, ilimitado.',
      'conversionDisabled' => 'The currency conversion action won\'t be applied to this field.',
      'pattern' => 'A regular expression to check a field value against. Define an expression or select a predefined one.',
      'options' => 'A list of possible values and their labels.',
      'optionsArray' => 'A list of possible values and their labels. If empty, the field will allow entering custom values.',
      'maxCount' => 'Maximum number of items allowed to be selected.',
      'displayAsList' => 'Each item in a new line.',
      'optionsVarchar' => 'A list of autocomplete values.',
      'linkReadOnly' => 'Field value can\'t be specified by user. But can be calculated by formula.

It will also disable the ability to create a related record from relationship panels.',
      'relateOnImport' => 'When importing with this field, it will automatically relate a record with a matching foreign record. Use this functionality only if the foreign field is considered as unique.'
    ],
    'fieldParts' => [
      'address' => [
        'street' => 'Calle',
        'city' => 'Ciudad',
        'state' => 'Estado',
        'country' => 'País',
        'postalCode' => 'Código Postal',
        'map' => 'Mapa'
      ],
      'personName' => [
        'salutation' => 'Saludo',
        'first' => 'Nombre',
        'middle' => 'Middle',
        'last' => 'Apellido'
      ],
      'currency' => [
        'converted' => '(Convertido)',
        'currency' => '(Moneda)'
      ],
      'datetimeOptional' => [
        'date' => 'Fecha'
      ]
    ],
    'fieldInfo' => [
      'varchar' => 'A single-line text.',
      'enum' => 'Selectbox, only one value can be selected.',
      'text' => 'A multiline text with markdown support.',
      'date' => 'Date w/o time.',
      'datetime' => 'Date and time',
      'currency' => 'A currency value. A float number with a currency code.',
      'int' => 'A whole number.',
      'float' => 'A number with a decimal part.',
      'bool' => 'A checkbox. Two possible values: true and false.',
      'multiEnum' => 'A list of values, multiple values can be selected. The list is ordered.',
      'checklist' => 'A list of checkboxes.',
      'array' => 'A list of values, similar to Multi-Enum field.',
      'address' => 'An address with street, city, state, postal code and country.',
      'url' => 'For storing links.',
      'urlMultiple' => 'Multiple links.',
      'wysiwyg' => 'A text with HTML support.',
      'file' => 'For file uploading.',
      'image' => 'For image uploading.',
      'attachmentMultiple' => 'Allows to upload multiple files.',
      'number' => 'An auto-incrementing number of string type with a possible prefix and specific length.',
      'autoincrement' => 'A generated read-only auto-incrementing integer number.',
      'barcode' => 'A barcode. Can be printed to PDF.',
      'email' => 'A set of email addresses with their parameters: Opted-out, Invalid, Primary.',
      'phone' => 'A set of phone numbers with their parameters: Type, Opted-out, Invalid, Primary.',
      'foreign' => 'A field of a related record. Read-only.',
      'link' => 'A record related through Belongs-To (many-to-one or one-to-one) relationship.',
      'linkParent' => 'A record related through Belongs-To-Parent relationship. Can be of different entity types.',
      'linkMultiple' => 'A set of records related through Has-Many (many-to-many or one-to-many) relationship. Not all relationships have their link-multiple fields. Only those do, where Link-Multiple parameter(s) is enabled.'
    ],
    'messages' => [
      'fieldCreatedAddToLayouts' => 'Field has been created. Now, you can add it to [layouts]({link})',
      'confirmRemove' => 'Are you sure you want to remove the *{field}* field?

Field removal does not remove data from the database. Data from the database will be removed if you run hard rebuild.',
      'fieldNameIsNotAllowed' => 'Field name \'{field}\' is not allowed.',
      'fieldAlreadyExists' => 'Field \'{field}\' already exists in \'{entityType}\'.',
      'linkWithSameNameAlreadyExists' => 'Link with the name \'{field}\' already exists in \'{entityType}\'.',
      'namingFieldLinkConflict' => 'Name \'{field}\' conflicts with link.'
    ]
  ],
  'Formula' => [
    'labels' => [
      'Check Syntax' => 'Check Syntax',
      'Run' => 'Run'
    ],
    'fields' => [
      'target' => 'Target',
      'targetType' => 'Target Type',
      'script' => 'Script',
      'output' => 'Output',
      'error' => 'Error'
    ],
    'messages' => [
      'runSuccess' => 'Executed successfully.',
      'runError' => 'Error.',
      'checkSyntaxSuccess' => 'Syntax is correct.',
      'checkSyntaxError' => 'Syntax error.',
      'emptyScript' => 'Script is empty.'
    ],
    'tooltips' => [
      'output' => 'Print values with the function `output\\printLine`.'
    ]
  ],
  'Global' => [
    'scopeNames' => [
      'Note' => 'Note',
      'Email' => 'Correo electrónico',
      'User' => 'Usuario',
      'Team' => 'Equipo',
      'Role' => 'Rol',
      'EmailTemplate' => 'Plantilla de Correo',
      'EmailTemplateCategory' => 'Categorías de Formatos de Correo',
      'EmailAccount' => 'Cuenta de Correo',
      'EmailAccountScope' => 'Cuenta de Correo',
      'OutboundEmail' => 'Correo Saliente',
      'ScheduledJob' => 'Tarea Agendada',
      'ExternalAccount' => 'Cuenta Externa',
      'Extension' => 'Extension',
      'Dashboard' => 'Tablero',
      'InboundEmail' => 'Correo Entrante',
      'Stream' => 'Flujo',
      'Import' => 'Importar',
      'ImportError' => 'Import Error',
      'Template' => 'Plantilla',
      'Job' => 'Trabajo',
      'EmailFilter' => 'Filtro de correo',
      'Portal' => 'Portal',
      'PortalRole' => 'Rol del Portal',
      'Attachment' => 'Datos adjuntos',
      'EmailFolder' => 'Carpeta del Correo',
      'GroupEmailFolder' => 'Group Email Folder',
      'PortalUser' => 'Portal del Usuario',
      'ApiUser' => 'Usuario de la API',
      'ScheduledJobLogRecord' => 'Historial de Tareas Agendadas',
      'PasswordChangeRequest' => 'Solicitar Cambio de Contraseña',
      'ActionHistoryRecord' => 'Historial de Acciones',
      'AuthToken' => 'Clave de Autorización',
      'UniqueId' => 'ID Único',
      'LastViewed' => 'Ultimo Visto',
      'Settings' => 'Configuración',
      'FieldManager' => 'Campos',
      'Integration' => 'Integración',
      'LayoutManager' => 'Formatos',
      'EntityManager' => 'Entidades',
      'Export' => 'Exportar',
      'DynamicLogic' => 'Lógica Dinámica',
      'DashletOptions' => 'Opciones del Panel',
      'Admin' => 'Admin',
      'Global' => 'Global',
      'Preferences' => 'Preferencias',
      'EmailAddress' => 'Dirección de Correo',
      'PhoneNumber' => 'Teléfono',
      'AppLogRecord' => 'App Log Record',
      'AuthLogRecord' => 'Registro en Hist. de Aut.',
      'AuthFailLogRecord' => 'Registro en Hist. de Fallos de Aut.',
      'LeadCapture' => 'Punto de Entrada para Captura de Referencias',
      'LeadCaptureLogRecord' => 'Historial de Captura de Referencias',
      'ArrayValue' => 'Valor del Arreglo ',
      'DashboardTemplate' => 'Dashboard Template',
      'Currency' => 'Currency',
      'LayoutSet' => 'Layout Set',
      'Webhook' => 'Webhook',
      'WebhookQueueItem' => 'Webhook Queue Item',
      'Mass Action' => 'Mass Action',
      'WorkingTimeCalendar' => 'Working Time Calendar',
      'WorkingTimeRange' => 'Working Time Exception',
      'AuthenticationProvider' => 'Authentication Provider',
      'GlobalStream' => 'Global Stream',
      'AddressCountry' => 'Address Country',
      'AppSecret' => 'App Secret',
      'Account' => 'Cuenta',
      'Contact' => 'Contacto',
      'Lead' => 'Lead',
      'Target' => 'Interés',
      'Opportunity' => 'Oportunidad',
      'Meeting' => 'Presentación',
      'Calendar' => 'Calendario',
      'Call' => 'Llamada',
      'Task' => 'Tarea',
      'Case' => 'Soporte',
      'Document' => 'Documento',
      'DocumentFolder' => 'Carpeta de Documento',
      'Campaign' => 'Campaña',
      'TargetList' => 'Lista de Intereses',
      'MassEmail' => 'Correo Masivo',
      'EmailQueueItem' => 'Item en Cola de Correo',
      'CampaignTrackingUrl' => 'Seguimiento de URLs',
      'Activities' => 'Actividades',
      'KnowledgeBaseArticle' => 'Artículo de la Base de Conocimientos',
      'KnowledgeBaseCategory' => 'Categoría de la Base de Conocimientos',
      'CampaignLogRecord' => 'Historial de Campañas',
      'Workflow' => 'Workflow',
      'Report' => 'Report',
      'ReportCategory' => 'Report Category',
      'WorkflowLogRecord' => 'Workflow Log Record',
      'WorkflowCategory' => 'Workflow Category',
      'BpmnFlowchart' => 'Process Flowchart',
      'BpmnProcess' => 'Process',
      'BpmnUserTask' => 'Process User Task',
      'ReportFilter' => 'Report Filter',
      'ReportPanel' => 'Report Panel',
      'Product' => 'Product',
      'ProductCategory' => 'Product Category',
      'ProductBrand' => 'Product Brand',
      'ProductAttribute' => 'Product Attribute',
      'ProductAttributeOption' => 'Product Attribute Option',
      'Quote' => 'Quote',
      'QuoteItem' => 'Quote Item',
      'SalesOrder' => 'Sales Order - Lista',
      'SalesOrderItem' => 'Sales Order Item',
      'Invoice' => 'Invoice',
      'InvoiceItem' => 'Invoice Item',
      'DeliveryOrder' => 'Delivery Order',
      'DeliveryOrderItem' => 'Delivery Order Item',
      'ReceiptOrder' => 'Receipt Order',
      'ReceiptOrderItem' => 'Receipt Order Item',
      'TransferOrder' => 'Transfer Order',
      'TransferOrderItem' => 'Transfer Order Item',
      'Tax' => 'Tax',
      'ShippingProvider' => 'Shipping Provider',
      'OpportunityItem' => 'Opportunity Item',
      'PurchaseOrder' => 'Purchase Order',
      'PurchaseOrderItem' => 'Purchase Order Item',
      'ReturnOrder' => 'Return Order',
      'ReturnOrderItem' => 'Return Order Item',
      'Supplier' => 'Supplier',
      'ProductPrice' => 'Product Price',
      'SupplierProductPrice' => 'Supplier Product Price',
      'PriceBook' => 'PriceBook',
      'PriceRule' => 'Price Rule',
      'PriceRuleCondition' => 'Price Rule Condition',
      'Warehouse' => 'Warehouse',
      'InventoryTransaction' => 'Inventory Transaction',
      'InventoryNumber' => 'Inventory Number',
      'InventoryAdjustment' => 'Inventory Adjustment',
      'InventoryAdjustmentItem' => 'Inventory Adjustment Item',
      'DashboardSet' => 'Dashboard Set',
      'Service' => 'Service',
      'ServiceItem' => 'Service Item',
      'Project' => 'Project',
      'ProjectTask' => 'Project Task',
      'ProjectBoard' => 'Project Board',
      'ProjectGroup' => 'Project Group',
      'ProjectColumn' => 'Project Board Column',
      'ProjectRole' => 'Project Role',
      'Analytics' => 'Analytics',
      'LeadsPartnerCenter' => 'Leads Partner Center',
      'PartnerID' => 'Partner ID',
      'Surestep' => 'Partner Program - Lista',
      'Portfolio' => 'Calculator',
      'AssesmentCompany' => 'AssesmentCompany',
      'NurturingForm' => 'Nurturing Form',
      'CloudConsumption' => 'Cloud Consumption',
      'CPB' => 'CPB - Lista',
      'GooglePartnerAdvantage' => 'Google Partner Advantage',
      'Program' => 'Programa',
      'AWS' => 'Partner Program - AWS',
      'DsetAws' => 'DSET AWS',
      'DataAnalyticsReport' => 'Data Analytics Report',
      'PartnersGoogleCloud' => 'Partner Program - Lista',
      'ExternalFormPost' => 'ExternalFormPost',
      'Distributor' => 'Distributor',
      'VendorContract' => 'VendorContract',
      'Earn' => 'Earn',
      'Contract' => 'Contrato',
      'Orders' => 'Orders',
      'Notifications' => 'Notification',
      'DSET' => 'DSET',
      'VendorCloudConsumption' => 'Cloud Consumption Revenue',
      'DashboardSet5' => 'Canales - General',
      'DashboardSet6' => 'Rocket - Dashboard',
      'DashboardSet7' => 'Rocket - Dashboard',
      'DashboardSet9' => 'Canales  - General',
      'DashboardSet13' => 'Oportunidades - Dash',
      'DashboardSet14' => 'Canales - Google',
      'DashboardSet15' => 'Oportunidades - General',
      'DashboardSet16' => 'Canales - AWS',
      'PBGeral' => 'Practice Builder High Growth - Lista',
      'DashboardSet28' => 'Oportunidades - Dash',
      'DashboardSet33' => 'Oportunidades - General',
      'DashboardSet34' => 'Canales - General',
      'DashboardSet35' => 'Canales - Microsoft',
      'DashboardSet36' => 'Rocket - Argentina - Dashboard',
      'DashboardSet37' => 'Rocket - Brasil - Dashboard',
      'DashboardSet38' => 'Rocket - CCA - Dashboard',
      'DashboardSet39' => 'Rocket - Chile - Dashboard.',
      'DashboardSet40' => 'Rocket - Colombia - Dashboard',
      'DashboardSet41' => 'Rocket - Ecuador - Dashboard',
      'DashboardSet42' => 'Rocket - Mexico - Dashboard',
      'DashboardSet43' => 'Rocket - Peru - Dashboard',
      'DashboardSet44' => 'High Growth',
      'AWSVersions' => 'AWS Versions',
      'Marketing' => 'Marketing',
      'VendorSubscription' => 'VendorSubscription',
      'Importer' => 'Importador',
      'DashboardSet47' => 'Oportunidades - Dash',
      'DashboardSet48' => 'Oportunidades - General',
      'DashboardSet50' => 'Rocket - Uruguay - Dashboard',
      'DashboardSet53' => 'Entrenamientos - Dash',
      'VendorAccount' => 'VendorAccount',
      'Country' => 'Country',
      'DashboardAccess' => 'Dashboard Access',
      'DashboardSet56' => 'Facturación Canales',
      'DashboardSet57' => 'DSET AWS',
      'TourContent' => 'TourContent',
      'EmailContent' => 'Email Content',
      'DashboardSet58' => 'Cloud',
      'ContractGoals' => 'Meta',
      'AccountVMB' => 'Account VMB',
      'AccountVBM' => 'Cuentas VBM',
      'TechnicalSupport' => 'TechnicalSupport',
      'RocketMargins' => 'Margens Rocket',
      'DashboardSet62' => 'Destination AI',
      'Migrations' => 'Migration',
      'BucketTimer' => 'Duração do Bucket',
      'Messenger' => 'Messenger',
      'PatchNotes' => 'Patch Notes',
      'Sources' => 'Sources',
      'OpportunityAWS' => 'Opportunity AWS',
      'OpportunityGoogle' => 'Opportunity Google',
      'DashboardSet70' => 'Google',
      'Renewals' => 'Renewal',
      'CAccountEndCustomer' => 'Account End Customer',
      'DashboardSet79' => 'Oportunidades - Dashboard v2025',
      'DashboardSet80' => 'Cybersecurity'
    ],
    'scopeNamesPlural' => [
      'Note' => 'Notes',
      'Email' => 'Correos',
      'User' => 'Usuarios',
      'Team' => 'Equipos',
      'Role' => 'Roles',
      'EmailTemplate' => 'Plantillas de Correo',
      'EmailTemplateCategory' => 'Categorías de Formatos de Correo',
      'EmailAccount' => 'Cuentas de Correo Electrónico',
      'EmailAccountScope' => 'Cuentas de Correo Electrónico',
      'OutboundEmail' => 'Correos Salientes',
      'ScheduledJob' => 'Tareas Agendadas',
      'ExternalAccount' => 'Cuentas Externas',
      'Extension' => 'Extensiones',
      'Dashboard' => 'Tablero',
      'InboundEmail' => 'Grupo de Cuentas de Correo',
      'EmailAddress' => 'Email Addresses',
      'PhoneNumber' => 'Phone Numbers',
      'Stream' => 'Flujo',
      'Import' => 'Importar ',
      'ImportError' => 'Import Errors',
      'Template' => 'Plantillas',
      'Job' => 'Trabajos',
      'EmailFilter' => 'Filtros de Correo',
      'Portal' => 'Portales',
      'PortalRole' => 'Roles del Portal',
      'Attachment' => 'Datos adjuntos',
      'EmailFolder' => 'Carpetas del Correo',
      'GroupEmailFolder' => 'Group Email Folders',
      'PortalUser' => 'Usuarios del Portal',
      'ApiUser' => 'Usuarios de la API',
      'ScheduledJobLogRecord' => 'Historial de Tareas Agendadas',
      'PasswordChangeRequest' => 'Solicitudes de Cambio de contraseña',
      'ActionHistoryRecord' => 'Historial de Acciones',
      'AuthToken' => 'Clave de Autorización',
      'UniqueId' => 'IDs Unicos',
      'LastViewed' => 'Ultimos Revisados',
      'AppLogRecord' => 'App Log',
      'AuthLogRecord' => 'Historial de Autorizaciones',
      'AuthFailLogRecord' => 'Hist. de Fallos de Aut.
',
      'LeadCapture' => 'Capturar Referencia',
      'LeadCaptureLogRecord' => 'Historial de Captura de Referencias',
      'ArrayValue' => 'Valores del Arreglo',
      'DashboardTemplate' => 'Dashboard Templates',
      'Currency' => 'Currency',
      'LayoutSet' => 'Layout Sets',
      'Webhook' => 'Webhooks',
      'WebhookQueueItem' => 'Webhook Queue Items',
      'WorkingTimeCalendar' => 'Working Time Calendars',
      'WorkingTimeRange' => 'Working Time Exceptions',
      'AuthenticationProvider' => 'Authentication Providers',
      'GlobalStream' => 'Global Stream',
      'AddressCountry' => 'Address Countries',
      'AppSecret' => 'App Secrets',
      'Account' => 'Cuentas',
      'Contact' => 'Contactos',
      'Lead' => 'Leads',
      'Target' => 'Intereses',
      'Opportunity' => 'Oportunidades',
      'Meeting' => 'Presentaciones',
      'Calendar' => 'Calendario',
      'Call' => 'Llamadas',
      'Task' => 'Tareas',
      'Case' => 'Soporte',
      'Document' => 'Documentos',
      'DocumentFolder' => 'Carpetas de Documentos',
      'Campaign' => 'Campañas',
      'TargetList' => 'Listas de Intereses',
      'MassEmail' => 'Correos Masivos',
      'EmailQueueItem' => 'Items en Cola de Correo',
      'CampaignTrackingUrl' => 'URLs de Seguimiento',
      'Activities' => 'Actividades',
      'KnowledgeBaseArticle' => 'Base de Conocimientos',
      'KnowledgeBaseCategory' => 'Categorías de la Base de Conocimientos',
      'CampaignLogRecord' => 'Historial de Campañas',
      'Workflow' => 'Workflows',
      'Report' => 'Reports',
      'ReportCategory' => 'Report Categories',
      'WorkflowLogRecord' => 'Workflows Log',
      'WorkflowCategory' => 'Workflow Categories',
      'BpmnFlowchart' => 'Process Flowcharts',
      'BpmnProcess' => 'Processes',
      'BpmnUserTask' => 'Process User Tasks',
      'ReportFilter' => 'Report Filters',
      'ReportPanel' => 'Report Panels',
      'Product' => 'Products',
      'ProductCategory' => 'Product Categories',
      'ProductBrand' => 'Product Brands',
      'ProductAttribute' => 'Product Attributes',
      'ProductAttributeOption' => 'Product Attribute Options',
      'OpportunityItem' => 'Opportunity Items',
      'Quote' => 'Quotes',
      'QuoteItem' => 'Quote Items',
      'SalesOrder' => 'Sales Orders - Lista',
      'SalesOrderItem' => 'Sales Order Items',
      'Invoice' => 'Invoices',
      'InvoiceItem' => 'Invoice Items',
      'PurchaseOrder' => 'Purchase Orders',
      'PurchaseOrderItem' => 'Purchase Order Items',
      'ReturnOrder' => 'Return Orders',
      'ReturnOrderItem' => 'Return Order Items',
      'DeliveryOrder' => 'Delivery Orders',
      'DeliveryOrderItem' => 'Delivery Order Items',
      'ReceiptOrder' => 'Receipt Orders',
      'ReceiptOrderItem' => 'Receipt Order Items',
      'TransferOrder' => 'Transfer Orders',
      'TransferOrderItem' => 'Transfer Order Items',
      'Tax' => 'Taxes',
      'ShippingProvider' => 'Shipping Providers',
      'Supplier' => 'Suppliers',
      'ProductPrice' => 'Product Prices',
      'SupplierProductPrice' => 'Supplier Product Prices',
      'PriceBook' => 'PriceBooks',
      'PriceRule' => 'Price Rules',
      'PriceRuleCondition' => 'Price Rule Conditions',
      'Warehouse' => 'Warehouses',
      'InventoryTransaction' => 'Inventory Transactions',
      'InventoryNumber' => 'Inventory Numbers',
      'InventoryAdjustment' => 'Inventory Adjustments',
      'InventoryAdjustmentItem' => 'Inventory Adjustment Items',
      'DashboardSet' => 'Dashboard Sets',
      'Service' => 'Services',
      'ServiceItem' => 'Service Items',
      'Project' => 'Projects',
      'ProjectTask' => 'Project Tasks',
      'ProjectBoard' => 'Project Boards',
      'ProjectGroup' => 'Project Groups',
      'ProjectColumn' => 'Project Board Stages',
      'ProjectRole' => 'Project Roles',
      'Analytics' => 'Analytics',
      'LeadsPartnerCenter' => 'Leads Partner Center',
      'PartnerID' => 'Partner ID',
      'Surestep' => 'Partner Program - Lista',
      'Portfolio' => 'Calculator',
      'AssesmentCompany' => 'AssesmentCompanies',
      'NurturingForm' => 'Nurturing Forms',
      'CloudConsumption' => 'Cloud Consumptions',
      'CPB' => 'Cloud Practice Builder - Lista',
      'GooglePartnerAdvantage' => 'Google Partner Advantage',
      'Program' => 'Programas',
      'AWS' => 'Partner Program - Lista',
      'DsetAws' => 'DSET AWS',
      'DataAnalyticsReport' => 'Data Analytics Report',
      'PartnersGoogleCloud' => 'Partner Program - Lista',
      'ExternalFormPost' => 'ExternalFormPosts',
      'Distributor' => 'Distributors',
      'VendorContract' => 'VendorContracts',
      'Earn' => 'Earns',
      'Contract' => 'Contratos',
      'Orders' => 'Orderses',
      'Notifications' => 'Notifications',
      'DSET' => 'DSETs',
      'VendorCloudConsumption' => 'Cloud Consumptions Revenue',
      'DashboardSet5' => 'Canales - General',
      'DashboardSet6' => 'Rocket - Dashboard',
      'DashboardSet7' => 'Rocket - Dashboard',
      'DashboardSet9' => 'Canales  - General',
      'DashboardSet13' => 'Oportunidades - Dash',
      'DashboardSet14' => 'Canales - Google',
      'DashboardSet15' => 'Oportunidades - General',
      'DashboardSet16' => 'Canales - AWS',
      'PBGeral' => 'Practice Builder General - Lista',
      'DashboardSet28' => 'Oportunidades - Dash',
      'DashboardSet33' => 'Oportunidades - General',
      'DashboardSet34' => 'Canales - General',
      'DashboardSet35' => 'Canales - Microsoft',
      'DashboardSet36' => 'Rocket - Argentina - Dashboard',
      'DashboardSet37' => 'Rocket - Brasil - Dashboard',
      'DashboardSet38' => 'Rocket - CCA - Dashboard',
      'DashboardSet39' => 'Rocket - Chile - Dashboard.',
      'DashboardSet40' => 'Rocket - Colombia - Dashboard',
      'DashboardSet41' => 'Rocket - Ecuador - Dashboard',
      'DashboardSet42' => 'Rocket - Mexico - Dashboard',
      'DashboardSet43' => 'Rocket - Peru - Dashboard',
      'DashboardSet44' => 'High Growth',
      'AWSVersions' => 'AWS Versions',
      'Marketing' => 'Marketing',
      'VendorSubscription' => 'VendorSubscriptions',
      'Importer' => 'Importador',
      'DashboardSet47' => 'Oportunidades - Dash',
      'DashboardSet48' => 'Oportunidades - General',
      'DashboardSet50' => 'Rocket - Uruguay - Dashboard',
      'DashboardSet53' => 'Entrenamientos - Dash',
      'VendorAccount' => 'VendorAccounts',
      'Country' => 'Countries',
      'DashboardAccess' => 'Dashboard Access',
      'DashboardSet56' => 'Facturación Canales',
      'DashboardSet57' => 'DSET AWS',
      'TourContent' => 'TourContents',
      'EmailContent' => 'Email Content',
      'DashboardSet58' => 'Cloud',
      'ContractGoals' => 'Metas',
      'AccountVMB' => 'Account VMBs',
      'AccountVBM' => 'Cuentas VBMs',
      'TechnicalSupport' => 'TechnicalSupports',
      'RocketMargins' => 'Margens Rocket',
      'DashboardSet62' => 'Destination AI',
      'Migrations' => 'Migrations',
      'BucketTimer' => 'Duração do Bucket',
      'Messenger' => 'Mensageria',
      'PatchNotes' => 'Patch Notes',
      'Sources' => 'Sources',
      'OpportunityAWS' => 'Opportunity AWS',
      'OpportunityGoogle' => 'Opportunity Google',
      'DashboardSet70' => 'Google',
      'Renewals' => 'Renewals',
      'CAccountEndCustomer' => 'Account End Customers',
      'DashboardSet79' => 'Oportunidades - Dashboard v2025',
      'DashboardSet80' => 'Cybersecurity'
    ],
    'labels' => [
      'Previous Page' => 'Previous Page',
      'Next Page' => 'Next Page',
      'First Page' => 'First Page',
      'Last Page' => 'Last Page',
      'Page' => 'Page',
      'Sort' => 'Sort',
      'Column Resize' => 'Column Resize',
      'Misc' => 'Misceláneos',
      'General' => 'General',
      'Merge' => 'Generar',
      'None' => '(vacío)',
      'Home' => 'Inicio',
      'by' => 'por',
      'Proceed' => 'Proceed',
      'Saved' => 'Guardado',
      'Error' => 'Error',
      'Select' => 'Seleccionar',
      'Not valid' => 'No válido',
      'Please wait...' => 'Por favor espere...',
      'Please wait' => 'Por favor espere',
      'Attached' => 'Adjunto',
      'Loading...' => 'Cargando...',
      'Uploading...' => 'Subiendo...',
      'Sending...' => 'Enviando...',
      'Send' => 'Send',
      'Merged' => 'Generado',
      'Removed' => 'Eliminado',
      'Posted' => 'Publicado',
      'Linked' => 'Ligado',
      'Unlinked' => 'Desligado',
      'Done' => 'Hecho',
      'Access denied' => 'Acceso denegado',
      'Not found' => 'No encontrado',
      'Access' => 'Acceso',
      'Timeout' => 'Timeout',
      'No internet' => 'No internet',
      'Are you sure?' => '¿Está seguro?',
      'Record has been removed' => 'Registro Eliminado',
      'Wrong username/password' => 'Nombre de usuario/contraseña incorrectos',
      'Post cannot be empty' => 'La entrada no puede estar vacia',
      'Username can not be empty!' => '¡El nombre del usuario no puede estar vacío!',
      'Cache is not enabled' => 'El Cache no está habilitado',
      'Cache has been cleared' => 'Se borró el Cache correctamente',
      'Rebuild has been done' => 'Se ha reconstruido',
      'Return to Application' => 'Regresar a la Aplicación',
      'Modified' => 'Modificado',
      'Created' => 'Creado(a)',
      'Create' => 'Crear',
      'create' => 'crear ',
      'Scheduled' => 'Scheduled',
      'Overview' => 'Vista',
      'Details' => 'Detalles',
      'Add Field' => 'Agregar Campo',
      'Add Dashlet' => 'Agregar Panel',
      'Filter' => 'Filtro',
      'Edit Dashboard' => 'Editar Tablero',
      'Add' => 'Agregar',
      'Add Item' => 'Agregar Elemento',
      'Reset' => 'Restablecer',
      'Menu' => 'Menú',
      'More' => 'Más',
      'Search' => 'Buscar',
      'Only My' => 'Sólo míos',
      'Open' => 'Abiertos',
      'Admin' => 'Administrador',
      'About' => 'Acerca de TD SYNNEX MCA',
      'Refresh' => 'Actualizar',
      'Remove' => 'Eliminar',
      'Restore' => 'Restore',
      'Options' => 'Opciones',
      'Username' => 'Nombre de Usuario (E-mail)',
      'Password' => 'Contraseña',
      'Login' => 'Entrar',
      'Log Out' => 'Salir',
      'Log in' => 'Log in',
      'Log in as' => 'Log in as',
      'Sign in' => 'Sign in',
      'Preferences' => 'Preferencias',
      'State' => 'Estado/Distrito',
      'Street' => 'Calle',
      'Country' => 'País',
      'City' => 'Ciudad',
      'PostalCode' => 'Código Postal',
      'Star' => 'Star',
      'Unstar' => 'Unstar',
      'Starred' => 'Starred',
      'Followed' => 'Con Seguimiento',
      'Follow' => 'Seguir',
      'Followers' => 'Seguidores',
      'Clear Local Cache' => 'Borrar Cache Local',
      'Actions' => 'Acciones',
      'Delete' => 'Borrar',
      'Update' => 'Guardar',
      'Save' => 'Guardar',
      'Edit' => 'Editar',
      'View' => 'Ver',
      'Cancel' => 'Cancelar',
      'Apply' => 'Aplicar',
      'Unlink' => 'Desligar',
      'Mass Update' => 'Actualización Masiva',
      'Export' => 'Exportar',
      'No Data' => '(vacío)',
      'No Access' => 'Sin Acceso',
      'All' => 'Todos',
      'Active' => 'Activo',
      'Inactive' => 'Inactivo',
      'Write your comment here' => 'Escriba su comentario aquí',
      'Post' => 'Guardar',
      'Stream' => 'Flujo',
      'Show more' => 'Mostrar mas',
      'Dashlet Options' => 'Opciones del Panel',
      'Full Form' => 'Formulario Completo',
      'Insert' => 'Insertar',
      'Person' => 'Persona',
      'First Name' => 'Nombre',
      'Last Name' => 'Apellidos',
      'Middle Name' => 'Middle Name',
      'Original' => 'Original',
      'You' => 'Tu',
      'you' => 'tu',
      'change' => 'cambiar',
      'Change' => 'Cambiar',
      'Primary' => 'Primario',
      'Save Filter' => 'Guardar Filtro',
      'Remove Filter' => 'Remove Filter',
      'Ready' => 'Ready',
      'Administration' => 'Administración',
      'Run Import' => 'Ejecutar Importación',
      'Duplicate' => 'Duplicar',
      'Notifications' => 'Notificaciones',
      'Mark all read' => 'Marcar todos como leído',
      'See more' => 'Ver más',
      'Today' => 'Hoy',
      'Tomorrow' => 'Mañana',
      'Yesterday' => 'Ayer',
      'Now' => 'Now',
      'Submit' => 'Enviar',
      'Close' => 'Cerrar',
      'Yes' => 'Si',
      'No' => 'No',
      'Select All Results' => 'Seleccionar Todos',
      'Value' => 'Valor',
      'Current version' => 'Version Actual',
      'List View' => 'Vista de Lista',
      'Tree View' => 'Vista de árbol',
      'Unlink All' => 'Desligar todo',
      'Total' => 'Total',
      'Print' => 'Print',
      'Print to PDF' => 'Imprimir PDF',
      'Default' => 'Default',
      'Number' => 'Número',
      'From' => 'De',
      'To' => 'Para',
      'Create Post' => 'Crear Entrada',
      'Previous Entry' => 'Entrada Previa',
      'Next Entry' => 'Siguiente Entrada',
      'View List' => 'Ver Lista',
      'Attach File' => 'Adjuntar archivo',
      'Skip' => 'Saltar',
      'Attribute' => 'Atributo',
      'Function' => 'Función',
      'Self-Assign' => 'Auto-Asignar',
      'Self-Assigned' => 'Auto-Asignado',
      'Expand' => 'Expander',
      'Collapse' => 'Cerrar',
      'Expanded' => 'Expanded',
      'Collapsed' => 'Collapsed',
      'Top Level' => 'Top Level',
      'New notifications' => 'Nuevas notificaciones',
      'Manage Categories' => 'Administrar Categorías',
      'Manage Folders' => 'Administrar Carpetas',
      'Convert to' => 'Convertir a',
      'View Personal Data' => 'Ver Datos Personales',
      'Personal Data' => 'Datos Personales',
      'Erase' => 'Borrar',
      'View Followers' => 'View Followers',
      'Convert Currency' => 'Convert Currency',
      'View on Map' => 'View on Map',
      'Preview' => 'Preview',
      'Move Over' => 'Mover',
      'Up' => 'Up',
      'Save & Continue Editing' => 'Save & Continue Editing',
      'Save & New' => 'Save & New',
      'Field' => 'Field',
      'Fields' => 'Fields',
      'Resolution' => 'Resolution',
      'Resolve Conflict' => 'Resolve Conflict',
      'Download' => 'Download',
      'Global Search' => 'Global Search',
      'Navigation Panel' => 'Show Navigation Panel',
      'Copy to Clipboard' => 'Copy to Clipboard',
      'Copied to clipboard' => 'Copied to clipboard',
      'Audit Log' => 'Audit Log',
      'View Audit Log' => 'View Audit Log',
      'View User Access' => 'View User Access',
      'Reacted' => 'Reacted',
      'Reaction Removed' => 'Reaction Removed',
      'Reactions' => 'Reactions',
      'Create In Modal' => 'Create In Modal',
      'Add row' => 'Add Row',
      'Schedule' => 'Schedule',
      'Log' => 'Log',
      'Scheduler' => 'Programador',
      'Create InboundEmail' => 'Crear Correo Entrante',
      'Activities' => 'Actividades',
      'History' => 'Historial',
      'Attendees' => 'Asistentes',
      'Schedule Meeting' => 'Agendar Presentación',
      'Schedule Call' => 'Agendar LLamada',
      'Compose Email' => 'Escribir Correo',
      'Log Meeting' => 'Registrar Presentación',
      'Log Call' => 'Registrar Llamada',
      'Archive Email' => 'Archivar Correo',
      'Create Task' => 'Crear Tarea',
      'Tasks' => 'Tareas',
      'Start Process' => 'Start Process',
      'Lock' => 'Lock',
      'Unlock' => 'Unlock',
      'kanbanStatusFields' => 'Kanban Status Fields',
      'Merging...' => 'Fusionando...',
      'Removing...' => 'Removiendo...',
      'Unlinking...' => 'Desligando...',
      'Posting...' => 'Publicando...',
      'Saving...' => 'Guardando...'
    ],
    'messages' => [
      'pleaseWait' => 'Por favor espere...',
      'loading' => 'Cargando...',
      'saving' => 'Guardando...',
      'confirmLeaveOutMessage' => '¿Realmente desea salir del formulario?',
      'notModified' => 'No ha modificado el registro',
      'duplicate' => 'El registro que estás creando ya puede existir.',
      'dropToAttach' => 'Haga drop para adjuntar',
      'pageNumberIsOutOfBound' => 'Page number is out of bound',
      'fieldUrlExceedsMaxLength' => 'Encoded URL exceeds max length of {maxLength}',
      'fieldNotMatchingPattern' => '{field} does not match the pattern `{pattern}`',
      'fieldNotMatchingPattern$noBadCharacters' => '{field} contains not allowed characters',
      'fieldNotMatchingPattern$noAsciiSpecialCharacters' => '{field} should not contain ASCII special characters',
      'fieldNotMatchingPattern$latinLetters' => '{field} can contain only latin letters',
      'fieldNotMatchingPattern$latinLettersDigits' => '{field} can contain only latin letters and digits',
      'fieldNotMatchingPattern$latinLettersDigitsWhitespace' => '{field} can contain only latin letters, digits and whitespace',
      'fieldNotMatchingPattern$latinLettersWhitespace' => '{field} can contain only latin letters and whitespace',
      'fieldNotMatchingPattern$digits' => '{field} can contain only digits',
      'fieldNotMatchingPattern$uriOptionalProtocol' => '{field} must be a valid URL',
      'fieldNotMatchingPattern$phoneNumberLoose' => '{field} contains characters not allowed in a phone number',
      'fieldInvalid' => '{field} is invalid',
      'fieldIsRequired' => '{field} es requerido',
      'fieldPhoneInvalid' => '{field} is invalid',
      'fieldPhoneInvalidCode' => 'Invalid country code',
      'fieldPhoneTooShort' => '{field} is too short',
      'fieldPhoneTooLong' => '{field} is too long',
      'fieldPhoneInvalidCharacters' => 'Only digits, latin letters and characters `-+_@:#().` are allowed',
      'fieldPhoneExtensionTooLong' => 'Extension should not be longer than {maxLength}',
      'fieldShouldBeEmail' => '{field} debería ser un correo válido',
      'fieldShouldBeFloat' => '{field} debería ser un número válido',
      'fieldShouldBeInt' => '{field} debería ser un entero válido',
      'fieldShouldBeNumber' => '{field} should be a valid number',
      'fieldShouldBeDate' => '{field} debería ser una fecha válida',
      'fieldShouldBeDatetime' => '{field} deber{ia ser una fecha/hr válida',
      'fieldShouldAfter' => '{field} debe estar después de {otherField}',
      'fieldShouldBefore' => '{field} debe estar antes de {otherField}',
      'fieldShouldBeBetween' => '{field} debe estar entre {min} y {max}',
      'fieldShouldBeLess' => '{field} no debe ser mayor a {value}',
      'fieldShouldBeGreater' => '{field} no debe ser menor que {value}',
      'fieldBadPasswordConfirm' => '{field} confirmado de forma incorrecta',
      'fieldMaxFileSizeError' => 'El archivo no debe exceder {max} Mb',
      'fieldValueDuplicate' => 'Duplicate value',
      'fieldIsUploading' => 'Carga en prograso',
      'fieldExceedsMaxCount' => 'Count exceeds max allowed {maxCount}',
      'barcodeInvalid' => '{field} is not valid {type}',
      'arrayItemMaxLength' => 'Item shouldn\'t be longer than {max} characters',
      'resetPreferencesDone' => 'Se han restablecido las preferencias default',
      'confirmation' => '¿Está seguro?',
      'unlinkAllConfirmation' => '¿Realmente desea desvincular todos los registros relacionados?',
      'resetPreferencesConfirmation' => '¿Realmente desea restablecer las preferencias default?',
      'removeRecordConfirmation' => '¿Realmente desea eliminar registros?',
      'unlinkRecordConfirmation' => '¿Realmente quiere desligar este registro?',
      'removeSelectedRecordsConfirmation' => '¿Realmente desea eliminar los registros seleccionados?',
      'unlinkSelectedRecordsConfirmation' => 'Estas seguro que deseas desligar los registros seleccionados ?',
      'massUpdateResult' => '{count} registro(s) actualizado(s)',
      'massUpdateResultSingle' => '{count} registro actualizado',
      'recalculateFormulaConfirmation' => 'Are you sure you want to recalculate formula for selected records?',
      'noRecordsUpdated' => 'Ningún registro fue actualizado',
      'massRemoveResult' => '{count} registro(s) eliminado(s)',
      'massRemoveResultSingle' => '{count} registro eliminado',
      'noRecordsRemoved' => 'Ningún registro fue eliminado',
      'clickToRefresh' => 'Clic para actualizar',
      'writeYourCommentHere' => 'Escriba su comentario aquí',
      'writeMessageToUser' => 'Escribir un mensaje a {user}',
      'writeMessageToSelf' => 'Escribe un mensaje en tu flujo',
      'typeAndPressEnter' => 'Teclear y oprimir enter',
      'checkForNewNotifications' => 'Ver si hay nuevas notificaciones',
      'checkForNewNotes' => 'Verificar si hay nuevos flujos',
      'internalPost' => 'La publicación sólo será vista por los usuarios internos',
      'internalPostTitle' => 'Lo publicado sólo lo verán los usuarios internos',
      'done' => 'Enviados',
      'notUpdated' => 'Not updated',
      'confirmMassUpdate' => 'Are you sure you want to mass-update selected records?',
      'confirmMassFollow' => '¿Realmente quieres marcar con seguimiento a los registros seleccionados?',
      'confirmMassUnfollow' => '¿Realmente quieres marcar sin seguimiento a los registros seleccionados?',
      'massFollowResult' => '{count} registro(s) ahora tienen seguimento',
      'massUnfollowResult' => '{count} registro(s) ya no tienen seguimiento',
      'massFollowResultSingle' => '{count} nuevo(s) registro(s) tienen seguimiento',
      'massUnfollowResultSingle' => 'El registro {count} ya no tiene seguimiento',
      'massFollowZeroResult' => 'Nada tiene seguimiento',
      'massUnfollowZeroResult' => 'A nada se le quitó el seguimiento',
      'erasePersonalDataConfirmation' => '¿Realmente desea borrar permanentemente los campos seleccionados?',
      'maintenanceModeError' => 'The application currently is in maintenance mode.',
      'maintenanceMode' => 'The application currently is in maintenance mode. Only admin users have access.

Maintenance mode can be disabled at Administration → Settings.',
      'resolveSaveConflict' => 'The record has been modified. You need to resolve the conflict before you can save the record.',
      'massPrintPdfMaxCountError' => 'No se pueden imprimir mas de {maxCount} registros.',
      'massActionProcessed' => 'Mass action has been processed.',
      'validationFailure' => 'Backend validation failure.

Field: `{field}`
Validation: `{type}`',
      'extensionLicenseInvalid' => 'Invalid \'{name}\' extension license.',
      'extensionLicenseExpired' => 'The \'{name}\' extension license subscription has expired.',
      'extensionLicenseSoftExpired' => 'The \'{name}\' extension license subscription has expired.',
      'confirmAppRefresh' => 'The application has been updated. It is recommended to refresh the page to ensure the proper functioning.',
      'loggedOutLeaveOut' => 'Logged out. The session is inactive. You may lose unsaved form data after page refresh. You may need to make a copy.',
      'noAccessToRecord' => 'Operation requires `{action}` access to record.',
      'noAccessToForeignRecord' => 'Operation requires `{action}` access to foreign record.',
      'noLinkAccess' => 'Can\'t relate with {foreignEntityType} record through the link \'{link}\'. No access.',
      'cannotUnrelateRequiredLink' => 'Can\'t unrelate required link.',
      'cannotRelateNonExisting' => 'Can\'t relate with non-existing {foreignEntityType} record.',
      'cannotRelateForbidden' => 'Can\'t relate with forbidden {foreignEntityType} record. `{action}` access required.',
      'cannotRelateForbiddenLink' => 'No access to link \'{link}\'.',
      'cannotLinkAlreadyLinked' => 'Cannot link an already linked record.',
      'error404' => 'The url you requested can\'t be handled.',
      'error403' => 'You don\'t have access to this area.',
      'emptyMassUpdate' => 'No fields available for Mass Update.',
      'attemptIntervalFailure' => 'The operation is not allowed during a specific time interval. Wait for some time before the next attempt.',
      'confirmRestoreFromAudit' => 'The previous values will be set in a form. Then you can save the record to restore the previous values.',
      'starsLimitExceeded' => 'The number of stars exceeded the limit.',
      'select2OrMoreRecords' => 'Select 2 or more records',
      'selectNotMoreThanNumberRecords' => 'Select not more than {number} records',
      'selectAtLeastOneRecord' => 'Select at least one record',
      'duplicateConflict' => 'A record already exists.',
      'cannotRemoveCategoryWithChildCategory' => 'Cannot remove a category that has a child category.',
      'cannotRemoveNotEmptyCategory' => 'Cannot remove a non-empty category.',
      'posting' => 'Publicando...',
      'streamPostInfo' => 'Escriba <strong>@username</strong> para indicar los usuarios de esta publicación.

Sintaxis disponible para los marcadores:
`<code>código</code>`
**<strong>texto en negrita</strong>**
*<em>texto en itálica</em>*
~<del>texto eliminado</del>~
> marcador de bloque
[texto de la liga](url) '
    ],
    'boolFilters' => [
      'onlyMy' => 'Sólo míos',
      'onlyMyTeam' => 'My Team',
      'followed' => 'Con Seguimiento',
      'shared' => 'Shared'
    ],
    'presetFilters' => [
      'followed' => 'Con Seguimiento',
      'all' => 'Todos',
      'starred' => 'Starred'
    ],
    'massActions' => [
      'delete' => 'Delete',
      'remove' => 'Eliminar',
      'merge' => 'Generar',
      'update' => 'Update',
      'massUpdate' => 'Actualización Masiva',
      'unlink' => 'Desligar',
      'export' => 'Exportar',
      'follow' => 'Dar seguimiento',
      'unfollow' => 'Quitar seguimiento',
      'convertCurrency' => 'Convertir Moneda',
      'recalculateFormula' => 'Recalculate Formula',
      'printPdf' => 'Imprimir a PDF',
      'lock' => 'Lock',
      'unlock' => 'Unlock'
    ],
    'fields' => [
      'name' => 'Nombre',
      'firstName' => 'Nombre',
      'lastName' => 'Apellidos',
      'middleName' => 'Middle Name',
      'salutationName' => 'Saludo',
      'assignedUser' => 'Usuario Asignado',
      'assignedUsers' => 'Usuarios Asignados',
      'collaborators' => 'Collaborators',
      'emailAddress' => 'Correo electrónico',
      'emailAddressData' => 'Datos de la Dirección de Correo',
      'emailAddressIsOptedOut' => 'La dirección de correo está Confirmada',
      'emailAddressIsInvalid' => 'Email Address is Invalid',
      'assignedUserName' => 'Nombre de Usuario Asignado',
      'teams' => 'Equipos',
      'users' => 'Users',
      'createdAt' => 'Creado en',
      'modifiedAt' => 'Modificado el',
      'createdBy' => 'Creado por',
      'modifiedBy' => 'Modificado Por',
      'streamUpdatedAt' => 'Stream Updated At',
      'description' => 'Descripción',
      'address' => 'Dirección',
      'phoneNumber' => 'Teléfono',
      'phoneNumberMobile' => 'Teléfono (Móvil)',
      'phoneNumberHome' => 'Teléfono (Casa)',
      'phoneNumberFax' => 'Teléfono (Fax)',
      'phoneNumberOffice' => 'Teléfono (Oficina)',
      'phoneNumberOther' => 'Teléfono (Otro)',
      'phoneNumberData' => 'Datos del Número de Teléfono',
      'phoneNumberIsOptedOut' => 'Phone Number is Opted-Out',
      'phoneNumberIsInvalid' => 'Phone Number is Invalid',
      'order' => 'Orden',
      'parent' => 'Padre',
      'children' => 'Hijos',
      'id' => 'ID',
      'ids' => 'ID\'s',
      'type' => 'Tipo',
      'names' => 'Nombres',
      'types' => 'Tipos',
      'targetListIsOptedOut' => 'Se ha Excluido (De la Lista)',
      'childList' => 'Child List',
      'billingAddressCity' => 'Ciudad',
      'billingAddressCountry' => 'País',
      'billingAddressPostalCode' => 'Código Postal',
      'billingAddressState' => 'Estado/Distrito',
      'billingAddressStreet' => 'Calle',
      'billingAddressMap' => 'Mapa',
      'addressCity' => 'Ciudad',
      'addressStreet' => 'Calle',
      'addressCountry' => 'País',
      'addressState' => 'Estado/Distrito',
      'addressPostalCode' => 'Código Postal',
      'addressMap' => 'Mapa',
      'shippingAddressCity' => 'Ciudad (Entrega)',
      'shippingAddressStreet' => 'Calle (Entrega)',
      'shippingAddressCountry' => 'País (Entrega)',
      'shippingAddressState' => 'Estado (Entrega)',
      'shippingAddressPostalCode' => 'Código Postal (Entrega)',
      'shippingAddressMap' => 'Mapa (Entrega)',
      'products' => 'Products',
      'inventoryNumbers' => 'Inventory Numbers',
      'allowFractionalQuantity' => 'Allow Fractional Quantity',
      'productType' => 'Product Type',
      'isDone' => 'Is Done',
      'isNotActual' => 'Is Not Actual',
      'isLocked' => 'Locked',
      'isHardLocked' => 'Hard-Locked',
      'KanbanViewFields' => 'Kanban Status Fields'
    ],
    'links' => [
      'assignedUser' => 'Usuario Asignado',
      'assignedUsers' => 'Assigned Users',
      'collaborators' => 'Collaborators',
      'createdBy' => 'Creado por',
      'modifiedBy' => 'Modificado Por',
      'team' => 'Equipo',
      'roles' => 'Roles',
      'teams' => 'Equipos',
      'users' => 'Usuarios',
      'parent' => 'Padre',
      'children' => 'Hijos',
      'contacts' => 'Contactos',
      'opportunities' => 'Oportunidades',
      'leads' => 'Referencias',
      'meetings' => 'Presentaciones',
      'calls' => 'Llamadas',
      'tasks' => 'Tareas',
      'emails' => 'Correos',
      'accounts' => 'Cuentas',
      'cases' => 'Soporte',
      'documents' => 'Documentos',
      'account' => 'Cuenta',
      'opportunity' => 'Oportunidad',
      'contact' => 'Contacto'
    ],
    'dashlets' => [
      'Stream' => 'Flujo',
      'Emails' => 'Mi Bandeja de Entrada',
      'Iframe' => 'Iframe',
      'Records' => 'Lista de Registros',
      'Memo' => 'Memo',
      'Leads' => 'Mis Referencias',
      'Opportunities' => 'Mis Oportunidades',
      'Tasks' => 'Mis Tareas',
      'Cases' => 'Mis Casos',
      'Calendar' => 'Calendario',
      'Calls' => 'Mis Llamadas',
      'Meetings' => 'Mis Presentaciones',
      'OpportunitiesByStage' => 'Oportunidades por Etapa',
      'OpportunitiesByLeadSource' => 'Oportunidades de Fuente de Referencias',
      'SalesByMonth' => 'Ventas por Mes',
      'SalesPipeline' => 'Canalización de Ventas',
      'Activities' => 'Mis Actividades',
      'Report' => 'Report',
      'BpmnUserTasks' => 'Process User Tasks',
      'ProjectTask' => 'My Project Tasks'
    ],
    'notificationMessages' => [
      'assign' => '{entityType} {entity} ha sido asignado a usted',
      'emailReceived' => 'Correo recibido de {from}',
      'entityRemoved' => '{user} ha eliminado {entityType} {entity}',
      'emailInbox' => '{user} added email {entity} to your inbox',
      'userPostReaction' => '{user} reacted to your {post}',
      'userPostInParentReaction' => '{user} reacted to your {post} in {entityType} {entity}',
      'eventAttendee' => '{user} added you to {entityType} {entity}'
    ],
    'streamMessages' => [
      'post' => '{user} a publicado en {entityType} {entity}',
      'attach' => '{user} adjuntado en {entityType} {entity}',
      'status' => '{user} ha actualizado {field} en {entityType} {entity}',
      'update' => '{user} ha actualizado {entityType} {entity}',
      'postTargetTeam' => '{user} publicó en equipo {target}',
      'postTargetTeams' => '{user} publicó en equipos {target}',
      'postTargetPortal' => '{user} publicó en el portal {target}',
      'postTargetPortals' => '{user} publicó en los portales {target}',
      'postTarget' => '{user} publicó en {target}',
      'postTargetYou' => '{user} publicado por usted',
      'postTargetYouAndOthers' => '{user} envió a {target} y a usted',
      'postTargetAll' => '{user} envió a todos',
      'postTargetSelf' => '{user} auto-publicado',
      'postTargetSelfAndOthers' => '{user} publicó en {target} con copia a si mismo',
      'mentionInPost' => '{user} mencionado {mentioned} en {entityType} {entity}',
      'mentionYouInPost' => '{user} te ha mencionado en {entityType} {entity}',
      'mentionInPostTarget' => '{user} mencionó a {mentioned} en el post',
      'mentionYouInPostTarget' => '{user} te ha mencionado en post para {target}',
      'mentionYouInPostTargetAll' => '{user} te ha mencionado en post para todos',
      'mentionYouInPostTargetNoTarget' => '{user} te menciona en el post',
      'create' => '{user} creó {entityType} {entity}',
      'createThis' => '{user} Creó un(a) nuevo(a) {entityType}',
      'createAssignedThis' => '{user} creó este(a) {entityType} asignado(a) a {assignee}',
      'createAssigned' => '{user} creó {entityType} {entity} asignado(a) a {assignee}',
      'createAssignedYou' => '{user} creó {entityType} {entity} y te la asignó',
      'createAssignedThisSelf' => '{user} creó este(a) {entityType} auto-asignado(a)',
      'createAssignedSelf' => '{user} creó {entityType} {entity} auto-asignado(a)',
      'assign' => '{user} ha asignado {entityType} {entity} a {assignee}',
      'assignThis' => '{user} asignar este {entityType} a {assignee}',
      'assignYou' => '{user} te asignó {entityType} {entity}',
      'assignThisVoid' => '{user} desasignó esta {entityType}',
      'assignVoid' => '{user} desasignó {entityType} {entity}',
      'assignThisSelf' => '{user} auto-asignó esta {entityType}',
      'assignSelf' => '{user} auto-asignó {entityType} {entity}',
      'assignMultiAdd' => '{user} assigned {entity} to {assignee}',
      'assignMultiRemove' => '{user} unassigned {entity} from {removedAssignee}',
      'assignMultiAddRemove' => '{user} assigned {entity} to {assignee} and unassigned from {removedAssignee}',
      'assignMultiAddThis' => '{user} assigned this {entityType} to {assignee}',
      'assignMultiRemoveThis' => '{user} unassigned this {entityType} from {removedAssignee}',
      'assignMultiAddRemoveThis' => '{user} assigned this {entityType} to {assignee} and unassigned from {removedAssignee}',
      'postThis' => '{user} publicado',
      'attachThis' => '{user} adjunto',
      'statusThis' => '{user} actualizado {field}',
      'updateThis' => '{user} actualizado a este {entityType}',
      'createRelatedThis' => '{user} creó {relatedEntityType} {relatedEntity} ligado a este(a) {entityType}',
      'createRelated' => '{user} creó un(a) {relatedEntityType} {relatedEntity} ligado(a) a {entityType} {entity}',
      'relate' => '{user} ligó {relatedEntityType} {relatedEntity} con {entityType} {entity}',
      'relateThis' => '{user} ligó {relatedEntityType} {relatedEntity} con este {entityType}',
      'unrelate' => '{user} unlinked {relatedEntityType} {relatedEntity} from {entityType} {entity}',
      'unrelateThis' => '{user} unlinked {relatedEntityType} {relatedEntity} from this {entityType}',
      'emailReceivedFromThis' => 'Correo recibido de {from}',
      'emailReceivedInitialFromThis' => 'Correo recibido de {from}, este(a) {entityType} creado(a)',
      'emailReceivedThis' => 'El correo {email} ha sido recibido',
      'emailReceivedInitialThis' => 'Correo recibido, este(a) {entityType} ha sido creado(a)',
      'emailReceivedFrom' => 'Correo recibido de {from}, relacionado a {entityType} {entity}',
      'emailReceivedFromInitial' => 'Correo recibido de {from}, {entityType} {entity} creado(a)',
      'emailReceived' => 'Se recibió el correo {email} para su {entityType} {entity}',
      'emailReceivedInitial' => 'Correo recibido: {entityType} {entity} creado(a)',
      'emailReceivedInitialFrom' => 'Correo recibido de {from}, {entityType} {entity} creado(a)',
      'emailSent' => '{by} envió un correo relacionado a {entityType} {entity}',
      'emailSentThis' => '{by} envió un correo',
      'eventConfirmationAccepted' => '{invitee} accepted participation in {entityType} {entity}',
      'eventConfirmationDeclined' => '{invitee} declined participation in {entityType} {entity}',
      'eventConfirmationTentative' => '{invitee} is tentative about participation in {entityType} {entity}',
      'eventConfirmationAcceptedThis' => '{invitee} accepted participation',
      'eventConfirmationDeclinedThis' => '{invitee} declined participation',
      'eventConfirmationTentativeThis' => '{invitee} is tentative about participation'
    ],
    'streamMessagesMale' => [
      'postTargetSelfAndOthers' => '{user} publicó a {target} con copia para sí mismo'
    ],
    'streamMessagesFemale' => [
      'postTargetSelfAndOthers' => '{user} publicó a {target} y a sí mismo'
    ],
    'lists' => [
      'monthNames' => [
        0 => 'Enero',
        1 => 'Febrero',
        2 => 'Marzo',
        3 => 'Abril',
        4 => 'Mayo',
        5 => 'Junio',
        6 => 'Julio',
        7 => 'Agosto',
        8 => 'Septiembre',
        9 => 'Octubre',
        10 => 'Noviembre',
        11 => 'Diciembre'
      ],
      'monthNamesShort' => [
        0 => 'Ene',
        1 => 'Feb',
        2 => 'Mar',
        3 => 'Abr',
        4 => 'May',
        5 => 'Jun',
        6 => 'Jul',
        7 => 'Ago',
        8 => 'Sep',
        9 => 'Oct',
        10 => 'Nov',
        11 => 'Dic'
      ],
      'dayNames' => [
        0 => 'Domingo',
        1 => 'Lunes',
        2 => 'Martes',
        3 => 'Miércoles',
        4 => 'Jueves',
        5 => 'Viernes',
        6 => 'Sábado'
      ],
      'dayNamesShort' => [
        0 => 'Dom',
        1 => 'Lun',
        2 => 'Mar',
        3 => 'Mie',
        4 => 'Jue',
        5 => 'Vie',
        6 => 'Sab'
      ],
      'dayNamesMin' => [
        0 => 'Do',
        1 => 'Lu',
        2 => 'Ma',
        3 => 'Mi',
        4 => 'Ju',
        5 => 'Vi',
        6 => 'Sa'
      ]
    ],
    'durationUnits' => [
      'd' => 'd',
      'h' => 'h',
      'm' => 'm',
      's' => 's'
    ],
    'options' => [
      'salutationName' => [
        'Mr.' => 'Sr.',
        'Mrs.' => 'Sra.',
        'Ms.' => 'Srta.',
        'Dr.' => 'Dr.'
      ],
      'language' => [
        'ar_AR' => 'Arabic',
        'af_ZA' => 'Afrikáans',
        'az_AZ' => 'Azerbaiyán',
        'be_BY' => 'Bielorruso',
        'bg_BG' => 'Bulgaro',
        'bn_IN' => 'Bengalí',
        'bs_BA' => 'Bosnio',
        'ca_ES' => 'Catalán',
        'cs_CZ' => 'Checo',
        'cy_GB' => 'Galés',
        'da_DK' => 'Danés',
        'de_DE' => 'Alemán',
        'el_GR' => 'Griego',
        'en_GB' => 'Inglés (UK)',
        'es_MX' => 'Español (México)',
        'en_US' => 'Inglés (US)',
        'es_ES' => 'Español (España)',
        'et_EE' => 'Estonio',
        'eu_ES' => 'Vasco',
        'fa_IR' => 'Persa',
        'fi_FI' => 'Finlandés',
        'fo_FO' => 'Feroés',
        'fr_CA' => 'Francés (Canada)',
        'fr_FR' => 'Francés (Francia)',
        'ga_IE' => 'Irlandés',
        'gl_ES' => 'Gallego',
        'gn_PY' => 'Guaraní',
        'he_IL' => 'Hebreo',
        'hi_IN' => 'Hindi',
        'hr_HR' => 'Croata',
        'hu_HU' => 'Hungaro',
        'hy_AM' => 'Armenio',
        'id_ID' => 'Indonesio',
        'is_IS' => 'Islandés',
        'it_IT' => 'Italiano',
        'ja_JP' => 'Japonés',
        'ka_GE' => 'Georgiano',
        'km_KH' => 'Camboyano',
        'ko_KR' => 'Coreano',
        'ku_TR' => 'Kurdo',
        'lt_LT' => 'Lituano',
        'lv_LV' => 'Latón',
        'mk_MK' => 'Macedonio',
        'ml_IN' => 'Malabar',
        'ms_MY' => 'Malayo',
        'nb_NO' => 'Noruego Bokmål',
        'nn_NO' => 'Noruego Nynorsk',
        'ne_NP' => 'Nepalí',
        'nl_NL' => 'Holandés',
        'pa_IN' => 'Punyabí',
        'pl_PL' => 'Polaco',
        'ps_AF' => 'Pastún',
        'pt_BR' => 'Portugués (Brasil)',
        'pt_PT' => 'Portugués (Portugal)',
        'ro_RO' => 'Rumano',
        'ru_RU' => 'Ruso',
        'sk_SK' => 'Eslovaco',
        'sl_SI' => 'Esloveno',
        'sq_AL' => 'Albanés',
        'sr_RS' => 'Serbio',
        'sv_SE' => 'Sueco',
        'sw_KE' => 'Suajili',
        'ta_IN' => 'Tamil',
        'te_IN' => 'Télugu',
        'th_TH' => 'Tailandés',
        'tl_PH' => 'Tagalo',
        'tr_TR' => 'Turco',
        'uk_UA' => 'Ucraniano',
        'ur_PK' => 'Urdu',
        'vi_VN' => 'Vietnamita',
        'zh_CN' => 'Chino Simplificado (China)',
        'zh_HK' => 'Chino Tradicional (Hong Kong)',
        'zh_TW' => 'Chino Traditional (Taiwán)'
      ],
      'dateSearchRanges' => [
        'on' => 'En',
        'notOn' => 'No está en',
        'after' => 'Después',
        'before' => 'Antes',
        'between' => 'Entre',
        'today' => 'Hoy',
        'past' => 'Pasado',
        'future' => 'Futuro',
        'currentMonth' => 'Mes Actual',
        'lastMonth' => 'Mes Pasado',
        'nextMonth' => 'Siguiente mes',
        'currentQuarter' => 'Trimestre Actual',
        'lastQuarter' => 'Trimestre Pasado',
        'currentYear' => 'Año Actual',
        'lastYear' => 'Año Pasado',
        'lastSevenDays' => 'Últimos 7 Días',
        'lastXDays' => 'Últimos X Días',
        'nextXDays' => 'Próximos X Días',
        'ever' => 'Nunca',
        'isEmpty' => 'Está Vacío',
        'olderThanXDays' => 'Mayor de "X" Días',
        'afterXDays' => 'Después de "X" Días',
        'currentFiscalYear' => 'Año Fiscal Actual',
        'lastFiscalYear' => 'Último Año Fiscal',
        'currentFiscalQuarter' => 'Trimestre Fiscal Actual',
        'lastFiscalQuarter' => 'Último Trimestre Fiscal'
      ],
      'searchRanges' => [
        'is' => 'Es',
        'isEmpty' => 'Está vacío',
        'isNotEmpty' => 'No Está Vacío',
        'isOneOf' => 'Cualquiera',
        'isFromTeams' => 'Es del Equipo',
        'isNot' => 'No Es',
        'isNotOneOf' => 'Ninguno De',
        'anyOf' => 'Cualquiera',
        'allOf' => 'All Of',
        'noneOf' => 'Ninguno De',
        'any' => 'Any'
      ],
      'varcharSearchRanges' => [
        'equals' => 'Equivale',
        'like' => 'Es Como (%)',
        'notLike' => 'No es como (%)',
        'startsWith' => 'Comienza con',
        'endsWith' => 'Termina Con',
        'contains' => 'Contiene',
        'notContains' => 'No Contiene',
        'isEmpty' => 'Está vacío',
        'isNotEmpty' => 'No Está Vacío',
        'notEquals' => 'No es Igual a'
      ],
      'intSearchRanges' => [
        'equals' => 'Equivale',
        'notEquals' => 'Diferentes',
        'greaterThan' => 'Mayor que',
        'lessThan' => 'Menor que',
        'greaterThanOrEquals' => 'Mayor o igual que',
        'lessThanOrEquals' => 'Menor o igual que',
        'between' => 'Entre',
        'isEmpty' => 'Está vacío',
        'isNotEmpty' => 'No está vacío'
      ],
      'autorefreshInterval' => [
        0 => 'Ninguno',
        '0.5' => '30 segundos',
        1 => '1 minuto',
        2 => '2 minutos',
        5 => '5 minutos',
        10 => '10 minutos'
      ],
      'phoneNumber' => [
        'Mobile' => 'Teléfono móvil',
        'Office' => 'Oficina',
        'Fax' => 'Fax',
        'Home' => 'Hogar',
        'Other' => 'Otro'
      ],
      'saveConflictResolution' => [
        'current' => 'Current',
        'actual' => 'Actual',
        'original' => 'Original'
      ],
      'reminderTypes' => [
        'Popup' => 'Ventana emergente',
        'Email' => 'Correo electrónico'
      ],
      'inventoryStatus' => [
        'Available' => 'Available',
        'On Hand' => 'On Hand',
        'Not Available' => 'Not Available'
      ]
    ],
    'sets' => [
      'summernote' => [
        'NOTICE' => 'Usted puede encontrar aquí la traducción: https://github.com/HackerWins/summernote/tree/master/lang',
        'font' => [
          'bold' => 'Negrita',
          'italic' => 'Itálico',
          'underline' => 'Subrayado',
          'strike' => 'Tachado',
          'clear' => 'Quitar Estilo de Fuente',
          'height' => 'Alto de línea',
          'name' => 'Familia de Fuente',
          'size' => 'Tamaño de Fuente'
        ],
        'image' => [
          'image' => 'Visualización',
          'insert' => 'Insertar Imagen',
          'resizeFull' => 'Cambiar el tamaño a completo',
          'resizeHalf' => 'Cambiar el tamaño a la mitad',
          'resizeQuarter' => 'Cambiar el tamaño a un cuarto',
          'floatLeft' => 'Flotante (izq)',
          'floatRight' => 'Flotante (der)',
          'floatNone' => 'Sin Flotar',
          'dragImageHere' => 'Arrastre la imagen aquí',
          'selectFromFiles' => 'Seleccionar desde Archivo',
          'url' => 'Url de Imagen',
          'remove' => 'Eliminar Imagen'
        ],
        'link' => [
          'link' => 'Enlace',
          'insert' => 'Insertar Enlace',
          'unlink' => 'Desligar',
          'edit' => 'Editar',
          'textToDisplay' => 'Texto a mostrar',
          'url' => '¿A que URL debería ir este enlace?',
          'openInNewWindow' => 'Abrir en nueva ventana'
        ],
        'video' => [
          'video' => 'Video',
          'videoLink' => 'Enlace al Video',
          'insert' => 'Insertar Video',
          'url' => '¿URL del Video?',
          'providers' => '(YouTube, Vimeo, Vine, Instagram, or DailyMotion)'
        ],
        'table' => [
          'table' => 'Tabla'
        ],
        'hr' => [
          'insert' => 'Insertar regla horizontal'
        ],
        'style' => [
          'style' => 'Estilo',
          'normal' => 'Normal',
          'blockquote' => 'Cita',
          'pre' => 'Código',
          'h1' => 'Encabezado 1',
          'h2' => 'Encabezado 2',
          'h3' => 'Encabezado 3',
          'h4' => 'Encabezado 4',
          'h5' => 'Encabezado 5',
          'h6' => 'Encabezado 6'
        ],
        'lists' => [
          'unordered' => 'Lista sin Ordenar',
          'ordered' => 'Lista Ordenada'
        ],
        'options' => [
          'help' => 'Ayuda',
          'fullscreen' => 'Pantalla Completa',
          'codeview' => 'Ver Código'
        ],
        'paragraph' => [
          'paragraph' => 'Párrafo',
          'outdent' => 'Anular sangría',
          'indent' => 'Sangría',
          'left' => 'Alinear Izquierda',
          'center' => 'Alinear Centro',
          'right' => 'Alinear Derecha',
          'justify' => 'Justificado'
        ],
        'color' => [
          'recent' => 'Color Reciente',
          'more' => 'Mas Colores',
          'background' => 'Color de Fondo',
          'foreground' => 'Color de Fuente',
          'transparent' => 'Transparente',
          'setTransparent' => 'Definir como transparente',
          'reset' => 'Restablecer',
          'resetToDefault' => 'Restablecer el original'
        ],
        'shortcut' => [
          'shortcuts' => 'Atajos de teclado',
          'close' => 'Cerrar',
          'textFormatting' => 'Formato de texto',
          'action' => 'Acción',
          'paragraphFormatting' => 'Formato de párrafo',
          'documentStyle' => 'Estilo de Documento'
        ],
        'history' => [
          'undo' => 'Deshacer',
          'redo' => 'Rehacer'
        ]
      ]
    ],
    'listViewModes' => [
      'list' => 'Lista',
      'kanban' => 'Tarjetas'
    ],
    'themes' => [
      'Dark' => 'Dark',
      'Light' => 'Light',
      'Espo' => 'Espo',
      'EspoRtl' => 'RTL',
      'Sakura' => 'Sakura',
      'Violet' => 'Violet',
      'Hazyblue' => 'Hazyblue',
      'Glass' => 'Glass'
    ],
    'themeNavbars' => [
      'side' => 'Side Navbar',
      'top' => 'Top Navbar'
    ],
    'fieldValidations' => [
      'required' => 'Required',
      'maxCount' => 'Max Count',
      'maxLength' => 'Max Length',
      'pattern' => 'Pattern Matching',
      'emailAddress' => 'Valid Email Address',
      'phoneNumber' => 'Valid Phone Number',
      'array' => 'Array',
      'arrayOfString' => 'Array of Strings',
      'valid' => 'Validity',
      'noEmptyString' => 'No Empty String',
      'max' => 'Max Value',
      'min' => 'Min Value'
    ],
    'fieldValidationExplanations' => [
      'valid' => 'Invalid value.',
      'maxLength' => 'Value length exceeds maximum value.',
      'phone_valid' => 'Phone number is not valid. May be caused by a wrong or empty country code.',
      'url_valid' => 'Invalid URL value.',
      'currency_valid' => 'Invalid amount value.',
      'currency_validCurrency' => 'The currency code value is invalid or not allowed.',
      'varchar_pattern' => 'Likely, the value contains not allowed characters.',
      'email_emailAddress' => 'Invalid email address value.',
      'phone_phoneNumber' => 'Invalid phone number value.',
      'datetimeOptional_valid' => 'Invalid date-time value.',
      'datetime_valid' => 'Invalid date-time value.',
      'date_valid' => 'Invalid date value.',
      'enum_valid' => 'Invalid enum value. The value must be one of defined enum options. An empty value is allowed only if the field has an empty option.',
      'int_valid' => 'Invalid integer number value.',
      'float_valid' => 'Invalid number value.',
      'multiEnum_valid' => 'Invalid multi-enum value. Values must be one of defined field options.'
    ],
    'navbarTabs' => [
      'Business' => 'Business',
      'Marketing' => 'Marketing',
      'Support' => 'Support',
      'CRM' => 'CRM',
      'Activities' => 'Activities',
      'SalesPack' => 'Sales & Purchase'
    ],
    'wysiwygLabels' => [
      'cell' => 'Cell',
      'align' => 'Align',
      'width' => 'Width',
      'height' => 'Height',
      'borderWidth' => 'Border Width',
      'borderColor' => 'Border Color',
      'cellPadding' => 'Cell Padding',
      'backgroundColor' => 'Background Color',
      'verticalAlign' => 'Vertical Align'
    ],
    'wysiwygOptions' => [
      'align' => [
        'left' => 'Left',
        'center' => 'Center',
        'right' => 'Right'
      ],
      'verticalAlign' => [
        'top' => 'Top',
        'middle' => 'Middle',
        'bottom' => 'Bottom'
      ]
    ],
    'detailViewModes' => [
      'detail' => 'Detail'
    ],
    'strings' => [
      'yesterdayShort' => 'Yest'
    ],
    'reactions' => [
      'Smile' => 'Smile',
      'Surprise' => 'Surprise',
      'Laugh' => 'Laugh',
      'Meh' => 'Meh',
      'Sad' => 'Sad',
      'Love' => 'Love',
      'Like' => 'Like',
      'Dislike' => 'Dislike'
    ],
    'recordActions' => [
      'create' => 'Create',
      'read' => 'Read',
      'edit' => 'Edit',
      'delete' => 'Delete',
      'stream' => 'Stream'
    ],
    'tabs' => [
      'Stream' => 'Stream'
    ],
    'featureEnableInfo' => [
      'PriceBooks' => 'The *Price Books* feature is not enabled. You can enable it at Administration > Sales Pack > [Settings](#Admin/salesPackSettings).',
      'Warehouses' => 'The *Warehouses* feature is not enabled. You can enable it at Administration > Sales Pack > [Settings](#Admin/salesPackSettings).',
      'InventoryTransactions' => 'The *Inventory Transactions* feature is not enabled. You can enable it at Administration > Sales Pack > [Settings](#Admin/salesPackSettings).'
    ]
  ],
  'GroupEmailFolder' => [
    'links' => [
      'emails' => 'Emails'
    ],
    'labels' => [
      'Create GroupEmailFolder' => 'Create Folder'
    ]
  ],
  'Import' => [
    'labels' => [
      'New import with same params' => 'New import with same params',
      'Revert Import' => 'Revertir Importación',
      'Return to Import' => 'Regresar a Importación',
      'Run Import' => 'Ejecutar Importación',
      'Back' => 'Anterior',
      'Field Mapping' => 'Mapeo de Campo',
      'Default Values' => 'Valores Default',
      'Add Field' => 'Agregar Campo',
      'Created' => 'Creado(a)',
      'Updated' => 'Actualizado',
      'Result' => 'Resultado',
      'Show records' => 'Mostrar registros',
      'Remove Duplicates' => 'Eliminar Duplicados	',
      'importedCount' => 'Importado (recuento)',
      'duplicateCount' => 'Duplicados (recuento)',
      'updatedCount' => 'Actualizado (recuento)',
      'Create Only' => 'Sólo Crear',
      'Create and Update' => 'Crear y Actualizar',
      'Update Only' => 'Sólo Actualizar',
      'Update by' => 'Actualizado por',
      'Set as Not Duplicate' => 'Establecer como No Duplicado',
      'File (CSV)' => 'Archivo (CSV)',
      'First Row Value' => 'Valor del Primer Renglón',
      'Skip' => 'Saltar',
      'Header Row Value' => 'Valor del Encabezado',
      'Field' => 'Campo',
      'What to Import?' => '¿Qué va a importar?',
      'Entity Type' => 'Tipo de Entidad',
      'What to do?' => '¿Qué hacer?',
      'Properties' => 'Propiedades',
      'Header Row' => 'Renglón de Encabezado',
      'Person Name Format' => 'Formato del Nombre de la Persona',
      'John Smith' => 'Pedro Pérez',
      'Smith John' => 'Pérez Pedro',
      'Smith, John' => 'Perez, Pedro',
      'Field Delimiter' => 'Delimitante del Campo',
      'Date Format' => 'Formato de la Fecha',
      'Decimal Mark' => 'Separador Decimal',
      'Text Qualifier' => 'Calificador del Texto',
      'Time Format' => 'Formato de Hora',
      'Currency' => 'Moneda',
      'Preview' => 'Vista previa',
      'Next' => 'Siguiente',
      'Step 1' => 'Paso 1',
      'Step 2' => 'Paso 2',
      'Double Quote' => 'Comillas dobles',
      'Single Quote' => 'Comillas sencillas',
      'Imported' => 'Importado',
      'Duplicates' => 'Duplicados',
      'Skip searching for duplicates' => 'No buscar duplicados',
      'Timezone' => 'Zona horaria',
      'Remove Import Log' => 'Eliminar Historial de Importaciones',
      'New Import' => 'Nueva Importación',
      'Import Results' => 'Resultados de la Importación',
      'Run Manually' => 'Run Manually',
      'Silent Mode' => 'Modo silencioso',
      'Export' => 'Export'
    ],
    'messages' => [
      'importRunning' => 'Import running...',
      'noErrors' => 'No errors',
      'utf8' => 'Debe ser codificado en UTF-8',
      'duplicatesRemoved' => 'Duplicados removidos',
      'inIdle' => 'Ejecutar fuera de la sesión (para grandes volúmenes de datos, vía cron-job)',
      'revert' => 'Esta acción eliminará permanentemente todos los registros importados.',
      'removeDuplicates' => 'Esta acción eliminará permanentemente todos los registros importados que sean duplicados.',
      'confirmRevert' => '¿Realmente desea eliminar permanentemente todos los registros importados?',
      'confirmRemoveDuplicates' => '¿Realmente desea eliminar permanentemente todos los registros importados que sean duplicados?',
      'confirmRemoveImportLog' => 'Esta acción eliminará el historial de importación. Todos los registros importados se conservarán, pero ya no podrá deshacer la importación. ¿Realmente desea hacerlo?',
      'removeImportLog' => 'Esta acción eliminará el historial de importación. Todos los registros importados se conservarán.  Hágalo sólo si la importación fue correcta.'
    ],
    'params' => [
      'phoneNumberCountry' => 'Telephone country code'
    ],
    'fields' => [
      'file' => 'Archivo',
      'entityType' => 'Tipo de Entidad',
      'imported' => 'Registros Importados',
      'duplicates' => 'registros Duplicados',
      'updated' => 'registros Actualizados',
      'status' => 'Estátus'
    ],
    'links' => [
      'errors' => 'Errors'
    ],
    'options' => [
      'status' => [
        'Failed' => 'Falló',
        'Standby' => 'Standby',
        'Pending' => 'Pending',
        'In Process' => 'En Proceso',
        'Complete' => 'Terminó'
      ],
      'personNameFormat' => [
        'f l' => 'First Last',
        'l f' => 'Last First',
        'f m l' => 'First Middle Last',
        'l f m' => 'Last First Middle',
        'l, f' => 'Last, First'
      ]
    ],
    'strings' => [
      'commandToRun' => 'Command to run (from CLI)',
      'saveAsDefault' => 'Save as default'
    ],
    'tooltips' => [
      'manualMode' => 'If checked, you will need to run import manually from CLI. Command will be shown after setting up the import.',
      'silentMode' => 'A majority of after-save scripts will be skipped, stream notes won\'t be created. Import will run faster.'
    ]
  ],
  'ImportError' => [
    'fields' => [
      'type' => 'Type',
      'validationFailures' => 'Validation Failures',
      'import' => 'Import',
      'rowIndex' => 'Row Index',
      'exportRowIndex' => 'Export Row Index',
      'lineNumber' => 'Line Number',
      'exportLineNumber' => 'Export Line Number',
      'row' => 'Row',
      'entityType' => 'Entity Type'
    ],
    'options' => [
      'type' => [
        'Validation' => 'Validation',
        'Access' => 'Access',
        'Not-Found' => 'Not-Found'
      ]
    ],
    'tooltips' => [
      'lineNumber' => 'A line number in the original CSV.',
      'exportLineNumber' => 'A line number in the export CSV.'
    ]
  ],
  'InboundEmail' => [
    'fields' => [
      'name' => 'Nombre',
      'emailAddress' => 'Correo Electrónico',
      'team' => 'Equipo del Interés',
      'status' => 'Estado',
      'assignToUser' => 'Asignar al Usuario',
      'host' => 'Servidor',
      'username' => 'Nombre de Usuario',
      'password' => 'Contraseña',
      'port' => 'Puerto',
      'monitoredFolders' => 'Carpetas supervisadas',
      'trashFolder' => 'Carpeta del Basurero',
      'security' => 'Security',
      'createCase' => 'Crear Caso',
      'reply' => 'Respuesta Automática',
      'caseDistribution' => 'Distribución de Caso',
      'replyEmailTemplate' => 'Plantilla de Respuesta de Correo',
      'replyFromAddress' => 'Respuesta de la Dirección',
      'replyToAddress' => 'Responder a la Dirección',
      'replyFromName' => 'Respuesta de Nombre',
      'targetUserPosition' => 'Interés Posición Usuario',
      'fetchSince' => 'Obtener Desde',
      'addAllTeamUsers' => 'Para todos los usuarios del equipo',
      'teams' => 'Equipos',
      'sentFolder' => 'Carpeta Enviada',
      'storeSentEmails' => 'Guardar correos enviados',
      'keepFetchedEmailsUnread' => 'Keep Fetched Emails Unread',
      'connectedAt' => 'Connected At',
      'excludeFromReply' => 'Exclude from Reply',
      'useImap' => 'Obtener Correos',
      'useSmtp' => 'Usar SMTP',
      'smtpHost' => 'Servidor SMTP',
      'smtpPort' => 'Puerto SMTP',
      'smtpAuth' => 'Configuración SMTP',
      'smtpSecurity' => 'Seguridad SMTP',
      'smtpAuthMechanism' => 'SMTP Auth Mechanism',
      'smtpUsername' => 'Nombre SMTP',
      'smtpPassword' => 'Contraseña SMTP',
      'fromName' => 'Remitente',
      'smtpIsShared' => 'SMTP es compartido',
      'smtpIsForMassEmail' => 'SMTP es para correo masivo',
      'groupEmailFolder' => 'Group Email Folder',
      'isSystem' => 'Is System'
    ],
    'tooltips' => [
      'isSystem' => 'Is the system email account.',
      'useSmtp' => 'The ability to send emails.',
      'reply' => 'Notifique a los remitentes de correo que han recibido sus mensajes.

 Sólo un correo será enviado a un destinatario particular durante un período de tiempo para evitar bucles.',
      'createCase' => 'Crear un caso automaticamente, al recibir correos entrantes.',
      'replyToAddress' => 'Especifique la dirección de correo de este buzón para hacer que las respuestas vegan aquí.',
      'caseDistribution' => '¿Cómo serán asignados a los casos? Asignados directamente a un usuario o al equipo.',
      'assignToUser' => 'Los casos del usuario serán reasignados.',
      'team' => 'Los casos del equipo serán reasignados.',
      'teams' => 'Los correos del equipo serán reasignados.',
      'targetUserPosition' => 'Los Usuarios con una posición específica serán distribuidos en los casos.',
      'addAllTeamUsers' => 'Los correos aparecerán en el buzón de entrada de todos los usuarios de los equipos especificados.',
      'monitoredFolders' => 'Si usa varias carpetas, sepárelas con coma',
      'smtpIsShared' => 'Si está marcado, los usuarios podrán enviar correos usando este servicio de SMTP.  La disponibilidad se controla con los Roles, a través de los permisos de Grupos de Cuentas de Correo.',
      'smtpIsForMassEmail' => 'Si lo marca, el SMTP estará disponible para envíos masivos de correo.',
      'storeSentEmails' => 'Los correos enviados serán guardados en el servidor IMAP.',
      'groupEmailFolder' => 'Put incoming emails in a group folder.',
      'excludeFromReply' => 'When replying on emails sent to this account\'s email address, its email address won\'t be added to CC.

Note that by enabling this parameter, the email address of this account will be exposed to users who have access to send Emails.'
    ],
    'links' => [
      'filters' => 'Filtros',
      'emails' => 'Correos',
      'assignToUser' => 'Asignar a Usuario',
      'groupEmailFolder' => 'Group Email Folder'
    ],
    'options' => [
      'status' => [
        'Active' => 'Activo',
        'Inactive' => 'Inactivo'
      ],
      'caseDistribution' => [
        '' => 'Ninguno',
        'Direct-Assignment' => 'Asignación directa',
        'Round-Robin' => 'Round-Robin',
        'Least-Busy' => 'Menos Ocupado'
      ],
      'smtpAuthMechanism' => [
        'plain' => 'PLAIN',
        'login' => 'LOGIN',
        'crammd5' => 'CRAM-MD5'
      ]
    ],
    'labels' => [
      'Create InboundEmail' => 'Crear Cuenta de Correo',
      'IMAP' => 'IMAP',
      'Actions' => 'Acciones',
      'Main' => 'Principal'
    ],
    'messages' => [
      'couldNotConnectToImap' => 'No se pudo conectar con el servidor IMAP',
      'imapNotConnected' => 'Could not connect to group [IMAP account](#InboundEmail/view/{id}).'
    ]
  ],
  'Integration' => [
    'fields' => [
      'enabled' => 'Activado',
      'clientId' => 'ID Cliente',
      'clientSecret' => 'Secreto Cliente',
      'redirectUri' => 'Redireccionar URI',
      'apiKey' => 'Llave API',
      'siteKey' => 'Site Key',
      'secretKey' => 'Secret Key',
      'scoreThreshold' => 'Score Threshold'
    ],
    'titles' => [
      'GoogleMaps' => 'Mapas de Google',
      'GoogleReCaptcha' => 'Google reCAPTCHA'
    ],
    'messages' => [
      'selectIntegration' => 'Seleccionar una integración en menú',
      'noIntegrations' => 'No hay integraciones disponibles'
    ],
    'help' => [
      'GoogleReCaptcha' => 'Obtain the Site Key and Secret Key from [Google](https://www.google.com/recaptcha/).',
      'Google' => '<p><b>Obtener las credenciales de  OAuth 2.0 desde la Consola de Google Developers.</b></p><p>Visita <a href="https://console.developers.google.com/project">Consola Google Developers</a> para obtener las credenciales de  OAuth 2.0 tales como  ID Cliente y Secreto de Cliente que son conocidos por ambos Google y la aplicación Synnex.</p>',
      'GoogleMaps' => '
 <p>Obtenga la llave API <a href="https://developers.google.com/maps/documentation/javascript/get-api-key">aquí</a>.</p> '
    ]
  ],
  'Job' => [
    'fields' => [
      'status' => 'Estado',
      'executeTime' => 'Ejecutar a',
      'executedAt' => 'Executed At',
      'startedAt' => 'Started At',
      'attempts' => 'Intentos Izquierda',
      'failedAttempts' => 'Intentos Fallidos',
      'serviceName' => 'Servicio',
      'method' => 'Método (obsoleto)',
      'methodName' => 'Método',
      'scheduledJob' => 'Tarea Agendada',
      'scheduledJobJob' => 'Nombre del Trabajo Agendado',
      'data' => 'Datos',
      'targetType' => 'Target Type',
      'targetId' => 'Target ID',
      'number' => 'Number',
      'queue' => 'Queue',
      'group' => 'Group',
      'className' => 'Class Name',
      'targetGroup' => 'Target Group',
      'job' => 'Job'
    ],
    'options' => [
      'status' => [
        'Pending' => 'Pendiente',
        'Success' => 'Correcto',
        'Running' => 'en ejecución...',
        'Failed' => 'Falló'
      ]
    ]
  ],
  'LayoutManager' => [
    'fields' => [
      'width' => 'Ancho (%)',
      'link' => 'Enlace',
      'notSortable' => 'No ordenable',
      'align' => 'Alinear',
      'panelName' => 'Nombre del Panel',
      'style' => 'Estilo',
      'sticked' => 'Pegado',
      'isMuted' => 'Muted color',
      'isLarge' => 'Tamaño de fuente grande',
      'hidden' => 'Hidden',
      'noLabel' => 'No Label',
      'dynamicLogicVisible' => 'Condiciones que hacen visible el panel',
      'dynamicLogicStyled' => 'Conditions making style applied',
      'tabLabel' => 'Tab Label',
      'tabBreak' => 'Tab-Break',
      'noteText' => 'Note Text',
      'noteStyle' => 'Note Style'
    ],
    'options' => [
      'align' => [
        'left' => 'Izquierda',
        'right' => 'Derecha'
      ],
      'style' => [
        'default' => 'Default',
        'success' => 'Correcto',
        'danger' => 'Peligro',
        'info' => 'Info',
        'warning' => 'Precaución',
        'primary' => 'Primario'
      ]
    ],
    'labels' => [
      'New panel' => 'Nuevo panel',
      'Layout' => 'Formato'
    ],
    'messages' => [
      'alreadyExists' => 'Layout `{name}` already exists.',
      'createInfo' => 'Custom list layouts can be used by relationship panels.',
      'cantBeEmpty' => 'Layout can\'t be empty.',
      'fieldsIncompatible' => 'Fields can\'t be on the layout together: {fields}.'
    ],
    'tooltips' => [
      'noteText' => 'A text to be displayed in the panel. Markdown is supported.',
      'tabBreak' => 'A separate tab for the panel and all following panels until the next tab-break.',
      'noLabel' => 'Don\'t display a column label in the header.',
      'notSortable' => 'Disables the ability to sort by the column.',
      'width' => 'A column width. It\'s recommended to have one column without specified width, usually it should be the *Name* field.',
      'sticked' => 'The panel will be sticked to the panel above. No gap between panels.',
      'hiddenPanel' => 'Need to click \'show more\' to see the panel.',
      'panelStyle' => 'A color of the panel.',
      'dynamicLogicVisible' => 'If set, the panel will be hidden unless the condition is met.',
      'dynamicLogicStyled' => 'A color will be applied if a specific condition is met . The color is defined by the *Style* parameter.',
      'link' => 'If checked, then a field value will be displayed as a link pointing to the detail view of the record. Usually it is used for *Name* fields.'
    ]
  ],
  'LayoutSet' => [
    'fields' => [
      'layoutList' => 'Layouts'
    ],
    'labels' => [
      'Create LayoutSet' => 'Create Layout Set',
      'Edit Layouts' => 'Edit Layouts'
    ],
    'tooltips' => []
  ],
  'LeadCapture' => [
    'fields' => [
      'name' => 'Nombre',
      'campaign' => 'Campaña',
      'isActive' => 'Está Activo',
      'subscribeToTargetList' => 'Suscribirse a Lista de Intereses',
      'subscribeContactToTargetList' => 'Suscribirse al Contacto, si existe',
      'targetList' => 'Lista de Intereses',
      'fieldList' => 'Campos de Propiedades',
      'optInConfirmation' => 'Doble Opt-In',
      'optInConfirmationEmailTemplate' => 'Plantilla de correo para confirmar Opt-In',
      'optInConfirmationLifetime' => 'Rango de Validez (en horas) de la confirmación Opt-In',
      'optInConfirmationSuccessMessage' => 'Texto para mostrar después de la confirmación Opt-In',
      'leadSource' => 'Referencia Orígen',
      'apiKey' => 'Llave API',
      'targetTeam' => 'Equipo Interesante',
      'exampleRequestMethod' => 'Método',
      'exampleRequestUrl' => 'URL',
      'exampleRequestPayload' => 'Propiedades',
      'exampleRequestHeaders' => 'Headers',
      'createLeadBeforeOptInConfirmation' => 'Create Lead before confirmation',
      'skipOptInConfirmationIfSubscribed' => 'Skip confirmation if lead is already in target list',
      'smtpAccount' => 'SMTP Account',
      'inboundEmail' => 'Group Email Account',
      'duplicateCheck' => 'Duplicate Check',
      'phoneNumberCountry' => 'Telephone country code',
      'fieldParams' => 'Field Params',
      'formId' => 'Form ID',
      'formEnabled' => 'Web Form',
      'formUrl' => 'Form URL',
      'formSuccessText' => 'Text to display after form submission',
      'formText' => 'Text to display on form',
      'formSuccessRedirectUrl' => 'URL to redirect to after form submission',
      'formLanguage' => 'Language used on form',
      'formFrameAncestors' => 'Allowed hosts for form embedding',
      'formCaptcha' => 'Use Captcha'
    ],
    'links' => [
      'targetList' => 'Lista de Intereses',
      'campaign' => 'Campaña',
      'optInConfirmationEmailTemplate' => 'Plantilla de confirmación de Opt-In',
      'targetTeam' => 'Equipo Interesante',
      'inboundEmail' => 'Group Email Account',
      'logRecords' => 'Historial'
    ],
    'labels' => [
      'Create LeadCapture' => 'Crear Punto de Entrada',
      'Generate New API Key' => 'Generar Nueva Llave API',
      'Request' => 'Solicitud',
      'Confirm Opt-In' => 'Confirmar Opt-In',
      'Generate New Form ID' => 'Generate New Form ID',
      'Web Form' => 'Web Form'
    ],
    'messages' => [
      'generateApiKey' => 'Crear Nueva Llave API',
      'optInConfirmationExpired' => 'La liga para confirmación de Opt-In ha expirado.',
      'optInIsConfirmed' => 'El Opt-In se ha confirmado.'
    ],
    'tooltips' => [
      'formCaptcha' => 'To be able to use Captcha, you need to configure it under **Administration** > **Integrations**.',
      'optInConfirmationSuccessMessage' => 'Soporta Reducción'
    ]
  ],
  'LeadCaptureLogRecord' => [
    'fields' => [
      'number' => 'Número',
      'data' => 'Dato',
      'target' => 'Interés',
      'leadCapture' => 'Capturar Referencia',
      'createdAt' => 'Ingresado el',
      'isCreated' => 'La Referencia fue creada'
    ],
    'links' => [
      'leadCapture' => 'Capturar Referencia',
      'target' => 'Interés'
    ]
  ],
  'MassAction' => [
    'fields' => [
      'status' => 'Status',
      'processedCount' => 'Processed Count'
    ],
    'options' => [
      'status' => [
        'Pending' => 'Pending',
        'Running' => 'Running',
        'Success' => 'Success',
        'Failed' => 'Failed'
      ]
    ],
    'messages' => [
      'infoText' => 'The mass action is being processed in idle by cron. It can take some time to finish. Closing this modal dialog won\'t affect the execution process.'
    ]
  ],
  'Note' => [
    'fields' => [
      'post' => 'Guardar',
      'attachments' => 'Adjuntos',
      'targetType' => 'Interés',
      'teams' => 'Equipos',
      'users' => 'Usuarios',
      'portals' => 'Portales',
      'type' => 'Tipo',
      'isGlobal' => 'Es Global',
      'isInternal' => 'Es interno (para usuarios internos)',
      'isPinned' => 'Is Pinned',
      'related' => 'Relacionada',
      'createdByGender' => 'Creado(a) por Género',
      'data' => 'Datos',
      'number' => 'Número'
    ],
    'filters' => [
      'all' => 'Todos',
      'posts' => 'Entradas',
      'updates' => 'Actualizaciones',
      'activity' => 'Activity'
    ],
    'options' => [
      'targetType' => [
        'self' => 'a mi mismo',
        'users' => 'a usuario(s) en particular',
        'teams' => 'a equipo(s) en particular',
        'all' => 'a todos los usuarios internos',
        'portals' => 'a los usuarios del portal'
      ],
      'type' => [
        'Post' => 'Publicar',
        'Create' => 'Create',
        'CreateRelated' => 'Create Related',
        'Update' => 'Update',
        'Status' => 'Status',
        'Assign' => 'Assign',
        'Relate' => 'Relate',
        'Unrelate' => 'Unrelate',
        'EmailReceived' => 'Email Received',
        'EmailSent' => 'Email Sent'
      ]
    ],
    'labels' => [
      'View Posts' => 'View Posts',
      'View Activity' => 'View Activity',
      'Pin' => 'Pin',
      'Unpin' => 'Unpin',
      'Pinned' => 'Pinned',
      'Quote Reply' => 'Quote Reply'
    ],
    'messages' => [
      'writeMessage' => 'Escriba su mensaje aquí',
      'pinnedMaxCountExceeded' => 'Cannot pin more notes. Max allowed number is {count}.'
    ],
    'links' => [
      'portals' => 'Portals',
      'attachments' => 'Attachments',
      'superParent' => 'Super Padre',
      'related' => 'Relacionado'
    ]
  ],
  'PhoneNumber' => [
    'fields' => [
      'type' => 'Type',
      'optOut' => 'Opted Out',
      'invalid' => 'Invalid',
      'numeric' => 'Numeric Value'
    ],
    'presetFilters' => [
      'orphan' => 'Orphan'
    ]
  ],
  'Portal' => [
    'fields' => [
      'name' => 'Nombre',
      'logo' => 'Logo',
      'url' => 'URL',
      'portalRoles' => 'Roles',
      'isActive' => 'Está Activo',
      'isDefault' => 'Es Default',
      'tabList' => 'Lista de Tabuladores',
      'applicationName' => 'Application Name',
      'quickCreateList' => 'Crear Lista Rápida',
      'companyLogo' => 'Logo',
      'theme' => 'Tema',
      'language' => 'Idioma',
      'dashboardLayout' => 'Diseño del Tablero',
      'dateFormat' => 'Formato de Fecha',
      'timeFormat' => 'Formato de Hora',
      'timeZone' => 'Zona Horaria',
      'weekStart' => 'Primer Día de la Semana',
      'defaultCurrency' => 'Moneda Default',
      'layoutSet' => 'Layout Set',
      'authenticationProvider' => 'Authentication Provider',
      'customUrl' => 'URL Personalizado',
      'customId' => 'ID Personalizado',
      'authTokenLifetime' => 'Auth Token Lifetime (hours)',
      'authTokenMaxIdleTime' => 'Auth Token Max Idle Time (hours)'
    ],
    'links' => [
      'users' => 'Usuarios',
      'portalRoles' => 'Roles',
      'layoutSet' => 'Layout Set',
      'authenticationProvider' => 'Authentication Provider',
      'notes' => 'Notas',
      'articles' => 'Artículos de la Base de Conocimientos'
    ],
    'tooltips' => [
      'layoutSet' => 'Provides the ability to have layouts that differ from standard ones.',
      'portalRoles' => 'Los Roles del Portal indicados se aplicarán a todos los usuarios del portal'
    ],
    'labels' => [
      'Create Portal' => 'Crear Portal',
      'User Interface' => 'Interfaz del Usuario',
      'General' => 'General',
      'Settings' => 'Configuración'
    ]
  ],
  'PortalRole' => [
    'fields' => [
      'exportPermission' => 'Permisos de Exportación',
      'massUpdatePermission' => 'Permiso de Actualización Masiva',
      'data' => 'Data',
      'fieldData' => 'Field Data'
    ],
    'links' => [
      'users' => 'Usuarios'
    ],
    'labels' => [
      'Access' => 'Acceder',
      'Create PortalRole' => 'Crear Rol del Portal',
      'Scope Level' => 'Alcance',
      'Field Level' => 'Nivel del Campo'
    ],
    'tooltips' => [
      'exportPermission' => 'Define si los usuarios del portal pueden exportar registros.',
      'massUpdatePermission' => 'Define si los usuarios del portal pueden hacer actualizaciones masivas de registros.'
    ]
  ],
  'PortalUser' => [
    'labels' => [
      'Create PortalUser' => 'Crear un Usuario del Portal'
    ]
  ],
  'Preferences' => [
    'fields' => [
      'dateFormat' => 'Formato de fecha',
      'timeFormat' => 'Formato de tiempo',
      'timeZone' => 'Zona Horaria',
      'weekStart' => 'Primer día de la semana',
      'thousandSeparator' => 'Separador de miles',
      'decimalMark' => 'Separador decimal',
      'defaultCurrency' => 'Moneda Default',
      'currencyList' => 'Lista de Moneda',
      'language' => 'Idioma',
      'exportDelimiter' => 'Exportar Delimitador',
      'receiveAssignmentEmailNotifications' => 'Notificaciones por correo sobre asignaciones',
      'receiveMentionEmailNotifications' => 'Notificaciones por correo sobre menciones en publicaciones',
      'receiveStreamEmailNotifications' => 'Notificar por correo las publicaciones y actualizaciones de estátus',
      'assignmentNotificationsIgnoreEntityTypeList' => 'In-app assignment notifications',
      'assignmentEmailNotificationsIgnoreEntityTypeList' => 'Email assignment notifications',
      'reactionNotifications' => 'In-app notifications about reactions',
      'autoFollowEntityTypeList' => 'Seguimiento-automático Global',
      'signature' => 'Firma de correo',
      'dashboardTabList' => 'Lista de Pestañas',
      'defaultReminders' => 'Recordatorios Default',
      'defaultRemindersTask' => 'Default Reminders for Tasks',
      'theme' => 'Tema',
      'useCustomTabList' => 'Lista de Pestañas Personalizada',
      'addCustomTabs' => 'Add Custom Tabs',
      'tabList' => 'Lista de Pestañas',
      'emailReplyToAllByDefault' => 'Responder a todos por default',
      'dashboardLayout' => 'Formato del Tablero',
      'dashboardLocked' => 'Lock Dashboard',
      'emailReplyForceHtml' => 'Responder correo en HTML',
      'doNotFillAssignedUserIfNotRequired' => 'No pre-llenar el campo de usuario al crear un registro',
      'followEntityOnStreamPost' => 'Seguimiento-automático del registro al publicarlo en el Flujo',
      'followCreatedEntities' => 'Seguimiento-automático de los registros creados',
      'followCreatedEntityTypeList' => 'Seguimiento-automático de los registros de tipos de entidad específicos',
      'emailUseExternalClient' => 'Use un cliente externo de correo',
      'textSearchStoringDisabled' => 'Disable text filter storing',
      'calendarSlotDuration' => 'Calendar Slot Duration',
      'calendarScrollHour' => 'Calendar Scroll to Hour',
      'smtpServer' => 'Servidor',
      'smtpPort' => 'Puerto',
      'smtpAuth' => 'Autorizar',
      'smtpSecurity' => 'Seguridad',
      'smtpUsername' => 'Nombre de Usuario',
      'emailAddress' => 'Correo Electrónico',
      'smtpPassword' => 'Contraseña',
      'smtpEmailAddress' => 'Correo Electrónico',
      'scopeColorsDisabled' => 'Desactivar colores en alcance',
      'tabColorsDisabled' => 'Desactivar colores en pestañas'
    ],
    'links' => [],
    'options' => [
      'weekStart' => [
        0 => 'Domingo',
        1 => 'Lunes'
      ]
    ],
    'labels' => [
      'Notifications' => 'Notificaciones',
      'User Interface' => 'Interfaz de Usuario',
      'Misc' => 'Misceláneos',
      'Locale' => 'Localización',
      'Reset Dashboard to Default' => 'Restaurar el Tablero default'
    ],
    'tooltips' => [
      'addCustomTabs' => 'If checked, custom tabs will be appended to default tabs. Otherwise, custom tabs will be used instead of default tabs.',
      'autoFollowEntityTypeList' => 'Seguir automáticamente TODOS los nuevos registros (de cualquier usuario) de los tipos de entidad seleccionados.  Así podrá ver información del flujo y recibir notificaciones sobre todo lo registrado en el sistema.',
      'doNotFillAssignedUserIfNotRequired' => 'El registro creado por el usuario asignado no será llenado con el propio usuario, a menos que el campo sea requerido.',
      'followCreatedEntities' => 'Cuando se creen nuevos registros, se seguirán automáticamente, aunque sean asignados a otro usuario.',
      'followCreatedEntityTypeList' => 'Cuando se creen nuevos registros de cierto tipo de entidades, se seguirán automáticamente, aunque sean asignados a otro usuario.'
    ],
    'tabFields' => [
      'label' => 'Label',
      'iconClass' => 'Icon',
      'color' => 'Color'
    ]
  ],
  'Role' => [
    'fields' => [
      'name' => 'Nombre',
      'roles' => 'Roles',
      'assignmentPermission' => 'Asignación de permisos',
      'userPermission' => 'Permisos de Usuario',
      'messagePermission' => 'Message Permission',
      'portalPermission' => 'Permisos del Portal',
      'groupEmailAccountPermission' => 'Permisos de Grupos de Cuentas de Correo',
      'exportPermission' => 'Permisos de exportación',
      'massUpdatePermission' => 'Permiso de Actualización Masiva',
      'followerManagementPermission' => 'Follower Management Permission',
      'dataPrivacyPermission' => 'Permiso de Datos Privados',
      'auditPermission' => 'Audit Permission',
      'mentionPermission' => 'Mention Permission',
      'userCalendarPermission' => 'User Calendar Permission',
      'data' => 'Data',
      'fieldData' => 'Field Data'
    ],
    'links' => [
      'users' => 'Usuarios',
      'teams' => 'Equipos'
    ],
    'tooltips' => [
      'messagePermission' => 'Allows to send messages to other users.

* all – can send to all
* team – can send only to teammates
* no – cannot send',
      'assignmentPermission' => 'Permite restringir la habilidad para asignar registros y enviar mensajes a otros usuarios.

todos - sin restricción

equipo - sólo a sus compañeros

no - sólo a sí mismo',
      'userPermission' => 'Permite restringir la capacidad de los usuarios para ver tareas, calendarios y el flujo de otros usuarios.

todos  - pueden ver todo

equipo - pueden ver las actividades de su equipo

no - sólo las propias',
      'userCalendarPermission' => 'Allows to view calendars of other users.',
      'portalPermission' => 'Define un acceso a la información del portal, permitiendo enviar mensajes a los usuarios del portal',
      'groupEmailAccountPermission' => 'Define el acceso a los grupos de cuentas de corros, la capacida de enviar correos desde grupos SMTP.',
      'exportPermission' => 'Define si los usuarios pueden exportar registros.',
      'massUpdatePermission' => 'Define si los usuarios pueden hacer actualizaciones masivas de registros.',
      'followerManagementPermission' => 'Allows to manage followers of specific records.',
      'dataPrivacyPermission' => 'Permite ver y borrar datos personales.',
      'auditPermission' => 'Allows to view the audit log.',
      'mentionPermission' => 'Allows to mention other users in the Stream.

* all – can mention all
* team – can mention only teammates
* no – cannot mention'
    ],
    'labels' => [
      'Access' => 'Acceso',
      'Create Role' => 'Crear Rol',
      'Scope Level' => 'Alcance',
      'Field Level' => 'Nivel del Campo'
    ],
    'options' => [
      'accessList' => [
        'not-set' => 'sin definir',
        'enabled' => 'activado',
        'disabled' => 'desactivado'
      ],
      'levelList' => [
        'all' => 'todos',
        'team' => 'equipo',
        'account' => 'cuenta',
        'contact' => 'contacto',
        'own' => 'propio',
        'no' => 'no',
        'yes' => 'si',
        'not-set' => 'sin definir'
      ]
    ],
    'actions' => [
      'read' => 'Leer',
      'edit' => 'Editar',
      'delete' => 'Borrar',
      'stream' => 'Flujo',
      'create' => 'Crear'
    ],
    'messages' => [
      'changesAfterClearCache' => 'Los cambios al Control de Acceso serán aplicados después de borrar el Cache'
    ]
  ],
  'ScheduledJob' => [
    'fields' => [
      'name' => 'Nombre',
      'status' => 'Estátus',
      'job' => 'Trabajo',
      'scheduling' => 'Agendar'
    ],
    'links' => [
      'log' => 'Historial'
    ],
    'labels' => [
      'As often as possible' => 'As often as possible',
      'Create ScheduledJob' => 'Crear Tarea Agendada'
    ],
    'options' => [
      'job' => [
        'Cleanup' => 'Limpiar',
        'CheckInboundEmails' => 'Comprobar Correos Entrantes',
        'CheckEmailAccounts' => 'Compruebe cuentas de correo personales',
        'SendEmailReminders' => 'Enviar Recordatorios por Correo',
        'AuthTokenControl' => 'Control de la Clave de Autorización',
        'SendEmailNotifications' => 'Enviar Notificaciones por Correo',
        'CheckNewVersion' => 'Verificar Nueva Versión',
        'ProcessWebhookQueue' => 'Process Webhook Queue',
        'SendScheduledEmails' => 'Send Scheduled Emails',
        'ProcessMassEmail' => 'Enviar Correo Masivo',
        'ControlKnowledgeBaseArticleStatus' => 'Controlar Estátus de la Base de Conocimientos',
        'ReportTargetListSync' => 'Sync Target Lists with Reports',
        'ScheduleReportSending' => 'Schedule Report Sending',
        'RunScheduledWorkflows' => 'Run Scheduled Workflows',
        'ProcessPendingProcessFlows' => 'Process Pending Flows',
        'InventoryCompress' => 'Inventory Transaction Compress',
        'NotActualOrderLocking' => 'Lock Not Actual Orders',
        'InventoryDetach' => 'Inventory Transaction Detaching'
      ],
      'cronSetup' => [
        'linux' => '<b>Nota</b>: Agregue esta línea al archivo crontab de su servidor para que ejecute los trabajos agendados de Synnex:',
        'mac' => '<b>Nota</b>: Agregue esta línea al archivo crontab de su servidor para que ejecute los trabajos agendados de Synnex:',
        'windows' => '<b>Nota</b>: Genere un archivo por lotes con los siguientes comandos para ejecutar trabajos programados de Synnex mediante el Programador de Tareas de Windows:',
        'default' => 'Nota: Agregue este comando a su CronJob (Tarea Agendada):'
      ],
      'status' => [
        'Active' => 'Activo',
        'Inactive' => 'Inactivo'
      ]
    ],
    'tooltips' => [
      'scheduling' => 'Notación CRONTAB.  Indica la frecuencia de ejecución.

`*/5 * * * *` - cada 5 minutos

`0 */2 * * *` - cada 2 horas

`30 1 * * *` - a la 01:30 diariamente

`0 0 1 * *` - el primer día del mes'
    ]
  ],
  'ScheduledJobLogRecord' => [
    'fields' => [
      'status' => 'Estátus',
      'executionTime' => 'Tiempo de Ejecución',
      'target' => 'Interés'
    ]
  ],
  'Settings' => [
    'fields' => [
      'useCache' => 'Usar Cache',
      'dateFormat' => 'Formato de Fecha',
      'timeFormat' => 'Formato de Hora',
      'timeZone' => 'Zona Horaria',
      'weekStart' => 'Primer día de la semana',
      'thousandSeparator' => 'Separador de miles',
      'decimalMark' => 'Separador Decimal',
      'defaultCurrency' => 'Moneda Default',
      'baseCurrency' => 'Moneda Base',
      'currencyRates' => 'Valores Tarifa',
      'currencyList' => 'Lista de Moneda',
      'language' => 'Idioma',
      'companyLogo' => 'Logo Compañia',
      'smsProvider' => 'SMS Provider',
      'outboundSmsFromNumber' => 'SMS From Number',
      'smtpServer' => 'Servidor',
      'smtpPort' => 'Puerto',
      'smtpAuth' => 'Autorizar',
      'smtpSecurity' => 'Seguridad',
      'smtpUsername' => 'Nombre de Usuario',
      'emailAddress' => 'Correo electrónico',
      'smtpPassword' => 'Contraseña',
      'outboundEmailFromName' => 'De (Nombre)',
      'outboundEmailFromAddress' => 'De (Dirección)',
      'outboundEmailIsShared' => 'Es Compartido',
      'emailAddressLookupEntityTypeList' => 'Email address look-up scopes',
      'emailAddressSelectEntityTypeList' => 'Email address select scopes',
      'recordsPerPage' => 'Registros por Página',
      'recordsPerPageSmall' => 'Registros Por Página (Pequeño)',
      'recordsPerPageSelect' => 'Records Per Page (Select)',
      'recordsPerPageKanban' => 'Records Per Page (Kanban)',
      'tabList' => 'Lista de Pestañas',
      'quickCreateList' => 'Crear Lista Rápida',
      'exportDelimiter' => 'Exportar Delimitador',
      'globalSearchEntityList' => 'Lista Búsqueda Global Entidad',
      'authenticationMethod' => 'Método de Autorización',
      'ldapHost' => 'Servidor',
      'ldapPort' => 'Puerto',
      'ldapAuth' => 'Autorizar',
      'ldapUsername' => 'Nombre Completo del Usuario ND',
      'ldapPassword' => 'Contraseña',
      'ldapBindRequiresDn' => 'Requiere ND para relacionarse',
      'ldapBaseDn' => 'ND Base',
      'ldapAccountCanonicalForm' => 'Forma Canónica de la Cuenta',
      'ldapAccountDomainName' => 'Nombre de Dominio de la Cuenta',
      'ldapTryUsernameSplit' => 'Intentar dividir el nombre de Usuario',
      'ldapPortalUserLdapAuth' => 'Usar Autenticación LDAP para Usuarios del Portal',
      'ldapCreateEspoUser' => 'Crear Usuario en Synnex',
      'ldapSecurity' => 'Seguridad',
      'ldapUserLoginFilter' => 'Filtro de Entrada del Usuario',
      'ldapAccountDomainNameShort' => 'Nombre Dominio Corto para la Cuenta',
      'ldapOptReferrals' => 'Referencias validadas',
      'ldapUserNameAttribute' => 'Atributo "Nombre Del Usuario"',
      'ldapUserObjectClass' => 'ObjectClass del Usuario',
      'ldapUserTitleAttribute' => 'Atributo "Título del Usuario"',
      'ldapUserFirstNameAttribute' => 'Atributo "Nombre del Usuario"',
      'ldapUserLastNameAttribute' => 'Atributo "Apellido del Usuario"',
      'ldapUserEmailAddressAttribute' => 'Atributo "Correo del Usuario"',
      'ldapUserTeams' => 'Equipos del Usuario',
      'ldapUserDefaultTeam' => 'Equipo default del Usuario',
      'ldapUserPhoneNumberAttribute' => 'Atributo "Teléfono del Usuario"',
      'ldapPortalUserPortals' => 'Portales Default del Usuario de Portal',
      'ldapPortalUserRoles' => 'Roles Default del Usuario de Portal',
      'exportDisabled' => 'Desactivar Exportación (Solo admin)',
      'assignmentNotificationsEntityList' => 'Entidades a las que se notificará sobre la asignación',
      'assignmentEmailNotifications' => 'Notificaciones sobre la asignación',
      'assignmentEmailNotificationsEntityList' => 'Alcances de las notificaciones por correo de la asignación',
      'streamEmailNotifications' => 'Notificaciones sobre actualizaciones en el flujo para usuarios internos',
      'portalStreamEmailNotifications' => 'Notificaciones de actualizaciones en el flujo para los usuarios del portal',
      'streamEmailNotificationsEntityList' => 'Alcances de las notificaciones por correo del flujo',
      'streamEmailNotificationsTypeList' => 'Que cosa notificar',
      'streamEmailWithContentEntityTypeList' => 'Entities with email body in stream notes',
      'emailNotificationsDelay' => 'Delay of email notifications (in seconds)',
      'b2cMode' => 'Modo B2C',
      'avatarsDisabled' => 'Desactivar Avatars',
      'followCreatedEntities' => 'Seguir los registros creados',
      'displayListViewRecordCount' => 'Mostrar el Total de Registros (en las vistas tipo lista)',
      'theme' => 'Tema',
      'userThemesDisabled' => 'Desactivar Temas de Usuarios',
      'attachmentUploadMaxSize' => 'Upload Max Size (Mb)',
      'attachmentUploadChunkSize' => 'Upload Chunk Size (Mb)',
      'emailMessageMaxSize' => 'Tamaño máximo del Correo (MB)',
      'massEmailMaxPerHourCount' => 'Número mäximo de correos enviados por hora',
      'massEmailMaxPerBatchCount' => 'Max number of emails sent per batch',
      'personalEmailMaxPortionSize' => 'Porción máxima recuperable de correo de cuentas personales',
      'inboundEmailMaxPortionSize' => 'Porción máxima recuperable de correo de cuentas de grupo',
      'maxEmailAccountCount' => 'Máximo número de cuentas de correo personal por usuario',
      'emailScheduledBatchCount' => 'Max number of scheduled emails sent per batch',
      'authTokenLifetime' => 'Vida de la Clave de Autorización (horas)',
      'authTokenMaxIdleTime' => 'Máximo tiempo de inactividad de la Clave de Autorización (horas)',
      'dashboardLayout' => 'Diseño del Tablero (default)',
      'siteUrl' => 'URL del Sitio',
      'addressPreview' => 'Vista previa de la Dirección',
      'addressFormat' => 'Formato de la Dirección',
      'personNameFormat' => 'Person Name Format',
      'notificationSoundsDisabled' => 'Desactivar las Notificaciones con Sonido',
      'newNotificationCountInTitle' => 'Display new notification number in page title',
      'applicationName' => 'Nombre de la Aplicación',
      'calendarEntityList' => 'Lista de Entidades del Calendario',
      'busyRangesEntityList' => 'Free/Busy Entity List',
      'mentionEmailNotifications' => 'Enviar correos de notificación sobre comentarios publicados',
      'massEmailDisableMandatoryOptOutLink' => 'Desactivar liga de confirmación obligatoria',
      'massEmailOpenTracking' => 'Email Open Tracking',
      'massEmailVerp' => 'Use VERP',
      'activitiesEntityList' => 'Lista de Entidades de Actividades',
      'historyEntityList' => 'Lista de Entidades del Historial',
      'currencyFormat' => 'Formato Moneda',
      'currencyDecimalPlaces' => 'Decimales en Moneda',
      'aclAllowDeleteCreated' => 'Permitir la eliminación de registros creados',
      'adminNotifications' => 'Notificaciones del sistema en el panel de administración',
      'adminNotificationsNewVersion' => 'Notificar cuando haya una nueva versión disponible de Synnex',
      'adminNotificationsNewExtensionVersion' => 'Notificar cuando haya nuevas versiones disponibles de extensiones',
      'textFilterUseContainsForVarchar' => 'Use el operador \'contiene\' para filtrar campos alfanuméricos',
      'phoneNumberNumericSearch' => 'Numeric phone number search',
      'phoneNumberInternational' => 'International phone numbers',
      'phoneNumberExtensions' => 'Phone number extensions',
      'phoneNumberPreferredCountryList' => 'Preferred telephone country codes',
      'authTokenPreventConcurrent' => 'Sólo se puede una clave de aut. por usuario',
      'scopeColorsDisabled' => 'Desactivar colores en alcance',
      'tabColorsDisabled' => 'Desactivar Colores en Pestañas',
      'tabIconsDisabled' => 'Desactivar Iconos en Pestañas',
      'emailAddressIsOptedOutByDefault' => 'Marcar direcciones como confirmadas',
      'outboundEmailBccAddress' => 'Direcciones CCO para clientes externos',
      'cleanupDeletedRecords' => 'Eliminar los registros borrados',
      'addressCityList' => 'Address City Autocomplete List',
      'addressStateList' => 'Address State Autocomplete List',
      'fiscalYearShift' => 'Inicio del Año Fiscal',
      'jobRunInParallel' => 'Jobs Run in Parallel',
      'jobMaxPortion' => 'Jobs Max Portion',
      'jobPoolConcurrencyNumber' => 'Jobs Pool Concurrency Number',
      'jobForceUtc' => 'Force UTC Time Zone',
      'daemonInterval' => 'Daemon Interval',
      'daemonMaxProcessNumber' => 'Daemon Max Process Number',
      'daemonProcessTimeout' => 'Daemon Process Timeout',
      'cronDisabled' => 'Disable Cron',
      'maintenanceMode' => 'Modo de Mantenimiento',
      'useWebSocket' => 'Use WebSocket',
      'passwordRecoveryDisabled' => 'Disable password recovery',
      'passwordRecoveryForAdminDisabled' => 'Disable password recovery for admin users',
      'passwordRecoveryForInternalUsersDisabled' => 'Disable password recovery for internal users',
      'passwordRecoveryNoExposure' => 'Prevent email address exposure on password recovery form',
      'passwordGenerateLength' => 'Length of generated passwords',
      'passwordStrengthLength' => 'Minimum password length',
      'passwordStrengthLetterCount' => 'Number of letters required in password',
      'passwordStrengthNumberCount' => 'Number of digits required in password',
      'passwordStrengthBothCases' => 'Password must contain letters of both upper and lower case',
      'passwordStrengthSpecialCharacterCount' => 'Number of special character required in password',
      'auth2FA' => 'Enable 2-Factor Authentication',
      'auth2FAForced' => 'Force regular users to set up 2FA',
      'auth2FAMethodList' => 'Available 2FA methods',
      'auth2FAInPortal' => 'Allow 2FA in portals',
      'workingTimeCalendar' => 'Working Time Calendar',
      'oidcClientId' => 'OIDC Client ID',
      'oidcClientSecret' => 'OIDC Client Secret',
      'oidcAuthorizationRedirectUri' => 'OIDC Authorization Redirect URI',
      'oidcAuthorizationEndpoint' => 'OIDC Authorization Endpoint',
      'oidcTokenEndpoint' => 'OIDC Token Endpoint',
      'oidcJwksEndpoint' => 'OIDC JSON Web Key Set Endpoint',
      'oidcJwtSignatureAlgorithmList' => 'OIDC JWT Allowed Signature Algorithms',
      'oidcScopes' => 'OIDC Scopes',
      'oidcGroupClaim' => 'OIDC Group Claim',
      'oidcCreateUser' => 'OIDC Create User',
      'oidcUsernameClaim' => 'OIDC Username Claim',
      'oidcTeams' => 'OIDC Teams',
      'oidcSync' => 'OIDC Sync',
      'oidcSyncTeams' => 'OIDC Sync Teams',
      'oidcFallback' => 'OIDC Fallback Login',
      'oidcAllowRegularUserFallback' => 'OIDC Allow fallback login for regular users',
      'oidcAllowAdminUser' => 'OIDC Allow OIDC login for admin users',
      'oidcLogoutUrl' => 'OIDC Logout URL',
      'oidcAuthorizationPrompt' => 'OIDC Authorization Prompt',
      'pdfEngine' => 'PDF Engine',
      'quickSearchFullTextAppendWildcard' => 'Append wildcard in quick search',
      'authIpAddressCheck' => 'Restrict access by IP address',
      'authIpAddressWhitelist' => 'IP Address Whitelist',
      'authIpAddressCheckExcludedUsers' => 'Users excluded from check',
      'availableReactions' => 'Available Reactions',
      'priceBooksEnabled' => 'Price Books',
      'defaultPriceBook' => 'Default Price Book',
      'inventoryTransactionsEnabled' => 'Inventory Transactions',
      'warehousesEnabled' => 'Warehouses',
      'deliveryOrdersEnabled' => 'Delivery Orders',
      'receiptOrdersEnabled' => 'Receipt Orders',
      'eInvoiceFormat' => 'Default Format',
      'sellerCompanyName' => 'Company Name',
      'sellerElectronicAddressScheme' => 'Electronic Address Scheme',
      'sellerElectronicAddressIdentifier' => 'Electronic Address Identifier',
      'sellerVatNumber' => 'VAT Number',
      'sellerTaxRegistrationScheme' => 'Tax Registration Scheme',
      'sellerTaxRegistrationIdentifier' => 'Tax Registration Identifier',
      'sellerAddress' => 'Company Address',
      'sellerContactName' => 'Contact Name',
      'sellerContactEmailAddress' => 'Contact Email Address',
      'sellerContactPhoneNumber' => 'Contact Phone Number',
      'salesForbidOrderUnlock' => 'Forbid order unlocking',
      'aclStrictMode' => 'Modo estricto ACL',
      'addressCountryList' => 'Lista para Autocompletar Direcciones de Países'
    ],
    'options' => [
      'authenticationMethod' => [
        'Oidc' => 'OIDC'
      ],
      'currencyFormat' => [
        1 => '10 MXP'
      ],
      'personNameFormat' => [
        'firstLast' => 'First Last',
        'lastFirst' => 'Last First',
        'firstMiddleLast' => 'First Middle Last',
        'lastFirstMiddle' => 'Last First Middle'
      ],
      'streamEmailNotificationsTypeList' => [
        'Post' => 'Publicaciones',
        'Status' => 'Actualizaciones de Estátus',
        'EmailReceived' => 'Correos recibidos'
      ],
      'auth2FAMethodList' => [
        'Totp' => 'TOTP',
        'Email' => 'Email',
        'Sms' => 'SMS'
      ],
      'weekStart' => [
        0 => 'Domingo',
        1 => 'Lunes'
      ]
    ],
    'tooltips' => [
      'authIpAddressCheckExcludedUsers' => 'Users that will be able to log in regardless whether their IP address is in the whitelist.',
      'authIpAddressWhitelist' => 'A list of IP addresses or ranges in CIDR notation.

Portals are not affected by restriction.',
      'workingTimeCalendar' => 'A working time calendar that will be applied to all users by default.',
      'displayListViewRecordCount' => 'A total number of records will be shown on the list view.',
      'currencyList' => 'What currencies will be available in the system.',
      'activitiesEntityList' => 'What records will be available in the Activities panel.',
      'historyEntityList' => 'What records will be available in the History panel.',
      'calendarEntityList' => 'What records will be available in the Calendar.',
      'addressStateList' => 'State suggestions for address fields.',
      'addressCityList' => 'City suggestions for address fields.',
      'addressCountryList' => 'Country suggestions for address fields.',
      'exportDisabled' => 'Users won\'t be able to export records. Only admin will be allowed.',
      'globalSearchEntityList' => 'What records can be searched with Global Search.',
      'siteUrl' => 'A URL of this TD SYNNEX MCA instance. You need to change it if you move to another domain.',
      'useCache' => 'Not recommended to disable, unless for development purpose.',
      'useWebSocket' => 'WebSocket enables two-way interactive communication between a server and a browser. Requires setting up the WebSocket daemon on your server. Check the documentation for more info.',
      'passwordRecoveryForInternalUsersDisabled' => 'Only portal users will be able to recover password.',
      'passwordRecoveryNoExposure' => 'It won\'t be possible to determine whether a specific email address is registered in the system.',
      'emailAddressLookupEntityTypeList' => 'For email address autocomplete.',
      'emailAddressSelectEntityTypeList' => 'Entity types available when searching for an email address from a modal.',
      'emailNotificationsDelay' => 'A message can be edited within the specified timeframe before the notification is sent.',
      'outboundEmailFromAddress' => 'The system email address.',
      'smtpServer' => 'If empty, then Group Email Account with the corresponding email address will be used.',
      'busyRangesEntityList' => 'What will be taken into account when showing busy time ranges in scheduler & timeline.',
      'massEmailVerp' => 'Variable envelope return path. For better handling of bounced messages. Make sure that your SMTP provider supports it.',
      'recordsPerPage' => 'Número de registros a desplegar inicialmente en las vistas',
      'recordsPerPageSmall' => 'Contador de registros en los paneles de información',
      'recordsPerPageSelect' => 'Number of records initially displayed when selecting records.',
      'recordsPerPageKanban' => 'Number of records initially displayed in kanban columns.',
      'outboundEmailIsShared' => 'Permitir a los usuarios enviar correos desde esta dirección',
      'followCreatedEntities' => 'Los usuarios seguirán automáticamente los registros que ellos hayan creado.',
      'emailMessageMaxSize' => 'Los correos de entrada que excedan el máximo sólo tendrán asunto (sin texto ni adjuntos).',
      'authTokenLifetime' => 'Define cuanto duran las claves de aut.
0 - significa que no caduca.',
      'authTokenMaxIdleTime' => 'Define cuándo caduca la clave luego del último acceso.
0 - significa que no caduca.',
      'userThemesDisabled' => 'Si está marcado, los usuarios no podrán seleccionar otro tema',
      'ldapUsername' => 'The full system user DN which allows to search other users. E.g. "CN=LDAP System User,OU=users,OU=espocrm, DC=test,DC=lan". ',
      'ldapPassword' => 'Contraseña de acceso al servidor LDAP.',
      'ldapAuth' => 'Credenciales de acceso al servidor LDAP.',
      'ldapUserNameAttribute' => 'El atributo para identificar el usuario.  Por ejemplo, "userPrincipalName" o "sAMAcountName" para Active Directory.  "uid" en OpenLDAP.',
      'ldapUserObjectClass' => 'Atributo ObjectClass para buscar usuarios.  Por ejemplo, "person" para AD, "inetOrgPerson" para OpenLDAP.',
      'ldapAccountCanonicalForm' => 'The type of your account canonical form. There are 4 options:

- \'Dn\' - the form in the format \'CN=tester,OU=espocrm,DC=test, DC=lan\'.

- \'Username\' - the form \'tester\'.

- \'Backslash\' - the form \'COMPANY\\tester\'.

- \'Principal\' - the form \'tester@company.com\'.',
      'ldapBindRequiresDn' => 'La opción para formatear el nombre del usuario en forma ND.',
      'ldapBaseDn' => 'La base de datos default DN usada para buscar usuarios.  Por ejemplo, "OU=users,OU=espocrm,DC=test, DC=lan".',
      'ldapTryUsernameSplit' => 'Opción para separar el nombre de usuario del dominio.',
      'ldapOptReferrals' => 'si deben seguirse las referencias del cliente LDAP.',
      'ldapPortalUserLdapAuth' => 'Permitir a los usuarios del portal utilizar autenticación LDAP en vez de la de Synnex.',
      'ldapCreateEspoUser' => 'Esta opción permite que Synnex genere un usuario del LDAP.',
      'ldapUserFirstNameAttribute' => 'Atributo LDAP utilizado para determinar el nombre del usuario.  Por ejemplo, "givenname".',
      'ldapUserLastNameAttribute' => 'Atributo LDAP usado para determinar el apellido del usuario.  Por ejemplo, "sn".',
      'ldapUserTitleAttribute' => 'Atributo LDAP usado para determinar el título del usuario.  Por ejemplo, "title".',
      'ldapUserEmailAddressAttribute' => 'El atributo LDAP usado para indicar la dirección de correo del usuario.  Por ejemplo, "mail".',
      'ldapUserPhoneNumberAttribute' => 'El atributo LDAP usado para indicar el número de teléfono del usuario.  Por ejemplo, "telephoneNumber".',
      'ldapUserLoginFilter' => 'Filtro que permite restringir los usuarios que pueden usar Synnex.  Por ejemplo, "memberOf=CN=espoGroup, OU=groups,OU=espocrm, DC=test,DC=lan". ',
      'ldapAccountDomainName' => 'Dominio utilizado para acceder al servidor LDAP.',
      'ldapAccountDomainNameShort' => 'El dominio corto usado para acceder al servidor LDAP.',
      'ldapUserTeams' => 'Equipos creados por el usuario.  Para ver más, consulte el perfil del usuario.',
      'ldapUserDefaultTeam' => 'Equipo default creado por el Usuario.  Si requiere más información, consulte el perfil del Usuario.',
      'ldapPortalUserPortals' => 'Portales Default para el Usuario de Portal creado',
      'ldapPortalUserRoles' => 'Roles Default para el Usuario de Portal creado',
      'b2cMode' => 'Synnex viene configurado para B2B por default.  Puede cambiarlo a B2C.',
      'currencyDecimalPlaces' => 'Posiciones decimales. Si está vacío, se mostrarán todos los decimales',
      'aclStrictMode' => 'Activado: El acceso a los alcances estará prohibido si no se especifica en los roles
Desactivado: El acceso a los alcances será permitido si no se especifica en los roles',
      'aclAllowDeleteCreated' => 'Los usuarios podrán eliminar los registros que hayan creado, aunque no tengan permiso de borrado.',
      'textFilterUseContainsForVarchar' => 'Si no lo marca, se usará el operador \'starts with\' (inicia con).  Puede utilizar el comodín \'%\'.',
      'streamEmailNotificationsEntityList' => 'Notificaciones de actualización de registros del flujo.  Los Usuarios recibirán notificaciones por correo sólo para los tipos de entidad especificados.',
      'authTokenPreventConcurrent' => 'Los usuarios no podrán ingresar en distintos dispositivos al mismo tiempo',
      'emailAddressIsOptedOutByDefault' => 'Las nuevas direcciones de correo serán marcadas como confirmadas.',
      'cleanupDeletedRecords' => 'Los registros borrados serán eliminados de la base de datos después de un tiempo.',
      'jobRunInParallel' => 'Las tareas serán ejecutadas en paralelo',
      'jobPoolConcurrencyNumber' => 'Max número de procesos ejecutados simultaneamente',
      'jobMaxPortion' => 'Max número de tareas por ejecución',
      'jobForceUtc' => 'Use the UTC time zone for scheduled jobs. Otherwise, the time zone set in settings will be used.',
      'daemonInterval' => 'Interval between process cron runs in seconds.',
      'daemonMaxProcessNumber' => 'Max number of cron processes run simultaneously.',
      'daemonProcessTimeout' => 'Max execution time (in seconds) allocated for a single cron process.',
      'cronDisabled' => 'Cron will not run.',
      'maintenanceMode' => 'Unicamente administradores pueden accesar el sistema',
      'oidcGroupClaim' => 'A claim to use for team mapping.',
      'oidcFallback' => 'Allow login by username/password.',
      'oidcCreateUser' => 'Create a new user in Espo when no matching user found.',
      'oidcSync' => 'Sync user data (on every login).',
      'oidcSyncTeams' => 'Sync user teams (on every login).',
      'oidcUsernameClaim' => 'A claim to use for a username (for user matching and creation).',
      'oidcTeams' => 'Espo teams mapped against groups/teams/roles of the identity provider. Teams with an empty mapping value will be always assigned to a user (when creating or syncing).',
      'oidcLogoutUrl' => 'An URL the browser will redirect to after logging out from Espo. Intended for clearing the session information in the browser and doing logging out on the provider side. Usually the URL contains a redirect-URL parameter, to return back to Espo.

Available placeholders:
* `{siteUrl}`
* `{clientId}`',
      'quickSearchFullTextAppendWildcard' => 'Append a wildcard to an autocomplete search query when Full-Text search is enabled. Reduces search performance.',
      'salesForbidOrderUnlock' => 'Once an order is locked, it can only be unlocked by an administrator.'
    ],
    'labels' => [
      'Group Tab' => 'Group Tab',
      'Divider' => 'Divider',
      'System' => 'Sistema',
      'Locale' => 'Localización',
      'Search' => 'Busqueda',
      'Misc' => 'Miscelaneos',
      'SMTP' => 'SMTP',
      'General' => 'General',
      'Phone Numbers' => 'Phone Numbers',
      'Navbar' => 'Navbar',
      'Dashboard' => 'Dashboard',
      'Configuration' => 'Configuración',
      'In-app Notifications' => 'Notificaciones del CRM',
      'Email Notifications' => 'Notificaciones por Correo',
      'Currency Settings' => 'Configuración Moneda',
      'Currency Rates' => 'Tipo de Cambio por Divisa',
      'Mass Email' => 'Correo Masivo',
      'Scheduled Send' => 'Scheduled Send',
      'Test Connection' => 'Probar Conexión',
      'Connecting' => 'Conectando...',
      'Activities' => 'Actividades',
      'Admin Notifications' => 'Notificaciones al Administrador',
      'Passwords' => 'Passwords',
      '2-Factor Authentication' => '2-Factor Authentication',
      'Attachments' => 'Attachments',
      'IdP Group' => 'IdP Group',
      'Access' => 'Access',
      'Strength' => 'Strength',
      'Recovery' => 'Recovery',
      'Electronic Invoicing' => 'Electronic Invoicing',
      'Seller Information' => 'Seller Information'
    ],
    'messages' => [
      'ldapTestConnection' => 'La conexión se ha establecido satisfactoriamente'
    ]
  ],
  'Stream' => [
    'messages' => [
      'infoMention' => 'Type **@username** to mention user in the post.',
      'infoSyntax' => 'Available markdown syntax',
      'couldNotAddFollowerUserHasNoAccessToStream' => 'Could not add the user \'{userName}\' to the followers. The user does not have \'stream\' access to the record.'
    ],
    'syntaxItems' => [
      'code' => 'code',
      'multilineCode' => 'multiline code',
      'strongText' => 'strong text',
      'emphasizedText' => 'emphasized text',
      'deletedText' => 'deleted text',
      'blockquote' => 'blockquote',
      'link' => 'link text'
    ]
  ],
  'Team' => [
    'fields' => [
      'name' => 'Nombre',
      'roles' => 'Roles',
      'layoutSet' => 'Layout Set',
      'workingTimeCalendar' => 'Working Time Calendar',
      'positionList' => 'Lista de Posiciones',
      'userRole' => 'User Role',
      'country' => 'Country',
      'subTeams' => 'Sub Time',
      'brand' => 'Brand'
    ],
    'links' => [
      'users' => 'Usuarios',
      'notes' => 'Notas',
      'roles' => 'Roles',
      'layoutSet' => 'Layout Set',
      'workingTimeCalendar' => 'Working Time Calendar',
      'inboundEmails' => 'Agrupar Cuentas de Correo',
      'groupEmailFolders' => 'Group Email Folders'
    ],
    'tooltips' => [
      'workingTimeCalendar' => 'A calendar will be applied to users who have this team set as a Default Team.',
      'layoutSet' => 'Provides the ability to have layouts that differ from standard ones. Layout Set will be applied to users who have this team set as Default Team.',
      'roles' => 'Todos los usuarios de este equipo tendrán acceso a la configuración desde los roles seleccionados',
      'positionList' => 'Posiciones disponibles en este equipo. Por ejemplo Vendedor, Gerente.'
    ],
    'labels' => [
      'Create Team' => 'Crear Equipo'
    ],
    'options' => [
      'country' => [
        '' => '',
        'Argentina' => 'Argentina',
        'Brasil' => 'Brasil',
        'Caribe' => 'Caribe',
        'CALA' => 'CALA',
        'Colombia' => 'Colombia',
        'Chile' => 'Chile',
        'Ecuador' => 'Ecuador',
        'Mexico' => 'Mexico',
        'Peru' => 'Peru',
        'CCA' => 'CCA',
        'Bolivia' => 'Bolivia',
        'Paraguay' => 'Paraguay',
        'Uruguay' => 'Uruguay',
        'Panama' => 'Panama'
      ],
      'brand' => [
        '' => '',
        'AWS' => 'AWS',
        'Google' => 'Google',
        'Microsoft' => 'Microsoft'
      ]
    ]
  ],
  'Template' => [
    'fields' => [
      'name' => 'Nombre',
      'body' => 'Cuerpo',
      'entityType' => 'Tipo de Entidad',
      'header' => 'Encabezado',
      'footer' => 'Pié',
      'leftMargin' => 'Margen Izquierdo',
      'topMargin' => 'Margen Superior',
      'rightMargin' => 'Margen Derecho',
      'bottomMargin' => 'Margen Inferior',
      'printFooter' => 'Imprimir Pié',
      'printHeader' => 'Print Header',
      'footerPosition' => 'Posición del Pié',
      'headerPosition' => 'Header Position',
      'variables' => 'Marcadores Disponibles',
      'pageOrientation' => 'Orientación de la Página',
      'pageFormat' => 'Formato de Papel',
      'pageWidth' => 'Page Width (mm)',
      'pageHeight' => 'Page Height (mm)',
      'fontFace' => 'Fuente',
      'title' => 'Title',
      'style' => 'Style'
    ],
    'links' => [],
    'labels' => [
      'Create Template' => 'Crear Plantilla'
    ],
    'options' => [
      'pageOrientation' => [
        'Portrait' => 'Vertical',
        'Landscape' => 'Horizontal'
      ],
      'pageFormat' => [
        'Custom' => 'Custom'
      ],
      'placeholders' => [
        'pagebreak' => 'Page break',
        'today' => 'Hoy (fecha)',
        'now' => 'Ahora (fecha-hr)'
      ],
      'fontFace' => [
        'dejavusans' => 'DejaVuSans',
        'dejavusansextralight' => 'DejaVu Sans Condensed'
      ]
    ],
    'tooltips' => [
      'footer' => 'Use {pageNumber} para imprimir el número de página.',
      'variables' => 'Copiar/Pegar necesita un marcador para el Encabezado, Cuerpo o Pie.'
    ]
  ],
  'User' => [
    'fields' => [
      'name' => 'Nombre',
      'userName' => 'Nombre Usuario',
      'title' => 'Título',
      'type' => 'Tipo',
      'isAdmin' => 'Es Administrador',
      'defaultTeam' => 'Equipo Default',
      'emailAddress' => 'Correo electrónico',
      'phoneNumber' => 'Teléfono',
      'roles' => 'Roles',
      'portals' => 'Portales',
      'portalRoles' => 'Roles del Portal',
      'teamRole' => 'Posición',
      'password' => 'Contraseña',
      'currentPassword' => 'Contraseña Actual',
      'passwordConfirm' => 'Confirmar Contraseña',
      'newPassword' => 'Nueva Contraseña',
      'newPasswordConfirm' => 'Confirmar Contraseña Nueva',
      'yourPassword' => 'Your current password',
      'avatar' => 'Avatar',
      'avatarColor' => 'Avatar Color',
      'isActive' => 'Está Activo',
      'isPortalUser' => 'Es Usuario del Portal',
      'contact' => 'Contacto',
      'accounts' => 'Cuentas',
      'account' => 'Cuenta (principal)',
      'sendAccessInfo' => 'Enviar al Usuario un correo con su Información de Acceso',
      'portal' => 'Portal',
      'gender' => 'Género',
      'position' => 'Puesto en el equipo',
      'ipAddress' => 'Dirección IP',
      'passwordPreview' => 'Contraseña Generada:',
      'isSuperAdmin' => 'Es Super-Administrador',
      'lastAccess' => 'Ultimo Acceso',
      'apiKey' => 'Llave API',
      'secretKey' => 'Llave Secreta',
      'dashboardTemplate' => 'Dashboard Template',
      'workingTimeCalendar' => 'Working Time Calendar',
      'auth2FA' => '2FA',
      'authMethod' => 'Método de Autenticación',
      'auth2FAEnable' => 'Enable 2-Factor Authentication',
      'auth2FAMethod' => '2FA Method',
      'auth2FATotpSecret' => '2FA TOTP Secret',
      'layoutSet' => 'Layout Set',
      'acceptanceStatus' => 'Estatus de Aprobación',
      'acceptanceStatusMeetings' => 'Estatus de Aceptación (Presentaciones)',
      'acceptanceStatusCalls' => 'Estátus de Aceptación (Llamadas)',
      'projects' => 'Projects',
      'projectRole' => 'Project Role',
      'projectRoleId' => 'Project Role ID',
      'country' => 'Country',
      'userType' => 'User Type',
      'partner' => 'Account',
      'clientid' => 'Rocket Client ID',
      'clientsecret' => 'Rocket Client Secret',
      'lead' => 'Lead',
      'contact1' => 'Contacto',
      'productBrand' => 'Product Brand',
      'awsClientId' => 'AwsClientId',
      'awsClientSecret' => 'AwsClientSecret',
      'lastAccessDate' => 'Last Access Date',
      'teamCountry' => 'Team Country',
      'countryList' => 'Country List',
      'vbmAccount' => 'Account',
      'opportunities' => 'Opportunities',
      'userPosition' => 'Cargo',
      'accountVMB' => 'Account VMB',
      'mobileApp' => 'Mobile App',
      'configApp' => 'ConfigApp',
      'accountbdm' => 'Account',
      'accounts1' => 'Accounts',
      'accountsBdms' => 'Carteira de Clientes - BDMs',
      'salesTerritory' => 'Sales Territory',
      'bDM' => 'VBA/BDR/BDM',
      'migrationsaccountManager' => 'Migrações (Account Manager)',
      'migrations' => 'Migrações (BDM Cloud)',
      'processOwnerMigrations' => 'Migrações (Process Owner)',
      'cAccountSales' => 'Carteira de Clientes - AMs',
      'firstName' => 'Primer Nombre'
    ],
    'links' => [
      'defaultTeam' => 'Equipo default',
      'teams' => 'Equipos',
      'roles' => 'Roles',
      'notes' => 'Notas',
      'portals' => 'Portales',
      'portalRoles' => 'Roles del Portal',
      'contact' => 'Contacto',
      'accounts' => 'Cuentas',
      'account' => 'Cuenta (principal)',
      'tasks' => 'Tareas',
      'userData' => 'User Data',
      'dashboardTemplate' => 'Dashboard Template',
      'workingTimeCalendar' => 'Working Time Calendar',
      'workingTimeRanges' => 'Working Time Exceptions',
      'layoutSet' => 'Layout Set',
      'targetLists' => 'Listas de Intereses',
      'projects' => 'Projects',
      'partner' => 'Account',
      'lead' => 'Lead',
      'contact1' => 'Contacto',
      'vbmAccount' => 'Account',
      'opportunities' => 'Opportunities',
      'accountVMB' => 'Account VMB',
      'accountbdm' => 'Account',
      'accounts1' => 'Accounts',
      'accountsBdms' => 'Carteira de Clientes - BDMs',
      'migrationsaccountManager' => 'Migrações (Account Manager)',
      'migrations' => 'Migrações (BDM Cloud)',
      'processOwnerMigrations' => 'Migrações (Process Owner)',
      'cAccountSales' => 'Carteira de Clientes - AMs'
    ],
    'labels' => [
      'Create User' => 'Crear Usuario',
      'Generate' => 'Generar',
      'Access' => 'Acceso',
      'Preferences' => 'Preferencias',
      'Change Password' => 'Cambiar Contraseña',
      'Teams and Access Control' => 'Equipos y Control de Acceso',
      'Forgot Password?' => '¿Olvidó la Contraseña?',
      'Password Change Request' => 'Solicitar Cambio de Contraseña',
      'Email Address' => 'Correo Electrónico',
      'External Accounts' => 'Cuentas Externas',
      'Email Accounts' => 'Cuentas de Correo',
      'Portal' => 'Portal',
      'Create Portal User' => 'Crear Usuario del Portal',
      'Proceed w/o Contact' => 'Proceder sin Contacto',
      'Generate New API Key' => 'Generar Nueva Llave API',
      'Generate New Password' => 'Generate New Password',
      'Send Password Change Link' => 'Send Password Change Link',
      'Back to login form' => 'Back to login form',
      'Requirements' => 'Requirements',
      'Security' => 'Security',
      'Reset 2FA' => 'Reset 2FA',
      'Code' => 'Code',
      'Secret' => 'Secret',
      'Send Code' => 'Send Code',
      'Login Link' => 'Login Link'
    ],
    'tooltips' => [
      'defaultTeam' => 'Todos los registros creados por este usuario serán relacionados a este equipo default.',
      'userName' => 'Letras a-z, números 0-9 y guiones bajos están permitidos',
      'isAdmin' => 'El usuario administrador puede tener acceso a todo.',
      'isActive' => 'Si lo desmarca, el usuario no podrá iniciar sesión.',
      'teams' => 'Equipos a los que este usuario pertenece. Nivel de control de acceso se hereda de los roles de equipo.',
      'roles' => 'Roles de acceso adicionales. Úselo si el usuario no pertenece a ningún equipo o si necesita ampliar el nivel de control de acceso sólo para este usuario.',
      'portalRoles' => 'Roles adicionales del portal.  Utilícelos para extender el nivel de acceso exclusivamente para este Usuario',
      'portals' => 'Portales a los que este Usuario tiene acceso',
      'layoutSet' => 'Layouts from a specified set will be applied for the user instead of default ones.',
      'productBrand' => 'Determines which manufacturers the user will access on the opportunities and leads screens.'
    ],
    'messages' => [
      '2faMethodNotConfigured' => 'The 2FA method is not fully configured in the system.',
      'loginAs' => 'Open the login link in an incognito window to preserve your current session. Use your admin credentials to log in.',
      'sendPasswordChangeLinkConfirmation' => 'An email with a unique link will be sent to the user allowing them to change their password. The link will expire after a specific amount of time.',
      'passwordRecoverySentIfMatched' => 'Assuming the entered data matched any user account.',
      'passwordStrengthLength' => 'Must be at least {length} characters long.',
      'passwordStrengthLetterCount' => 'Must contain at least {count} letter(s).',
      'passwordStrengthNumberCount' => 'Must contain at least {count} digit(s).',
      'passwordStrengthSpecialCharacterCount' => 'Must contain at least {count} special character(s).',
      'passwordStrengthBothCases' => 'Must contain letters of both upper and lower case.',
      'passwordWillBeSent' => 'La Contraseña será enviada al correo electrónico del usuario',
      'passwordChanged' => 'La Contraseña ha sido cambiada',
      'userCantBeEmpty' => 'El nombre de usuario no puede estar vacío',
      'wrongUsernamePassword' => 'Nombre de usuario/contraseña incorrectos',
      'failedToLogIn' => 'Failed to log in',
      'emailAddressCantBeEmpty' => 'La dirección de correo no puede estar vacía',
      'userNameEmailAddressNotFound' => 'Nombre de Usuario/Correo no encontrado',
      'forbidden' => 'Prohibido, por favor intente después',
      'uniqueLinkHasBeenSent' => 'El enlace único ha sido enviado a la dirección de correo electrónico especificada.',
      'passwordChangedByRequest' => 'La contraseña ha sido cambiada.',
      'setupSmtpBefore' => 'Necesita configurar correctamente su <a href="{url}">Servicio SMTP</a> para que el sistema pueda enviarle su contraseña por correo.',
      'userNameExists' => 'Ese Usuario ya existe',
      'loginError' => 'Error occurred',
      'wrongCode' => 'Wrong code',
      'codeIsRequired' => 'Code is required',
      'yourAuthenticationCode' => 'Your authentication code: {code}.',
      'choose2FaSmsPhoneNumber' => 'Select a phone number that will be used for 2FA.',
      'choose2FaEmailAddress' => 'Select an email address that will be used for 2FA. It\'s highly recommended to use a non-primary email address.',
      'enterCodeSentInEmail' => 'Enter the code sent to your email address.',
      'enterCodeSentBySms' => 'Enter the code sent by SMS to your phone number.',
      'enterTotpCode' => 'Enter a code from your authenticator app.',
      'verifyTotpCode' => 'Scan the QR-code with your mobile authenticator app. If you have a trouble with scanning, you can enter the secret manually. After that you will see a 6-digit code in your application. Enter this code in the field below.',
      'generateAndSendNewPassword' => 'A new password will be generated and sent to the user\'s email address.',
      'security2FaResetConfirmation' => 'Are you sure you want to reset the current 2FA settings?',
      'auth2FARequiredHeader' => '2 factor authentication required',
      'auth2FARequired' => 'You need to set up 2 factor authentication. Use an authenticator application on your mobile phone (e.g. Google Authenticator).',
      'ldapUserInEspoNotFound' => 'User is not found in TD SYNNEX MCA. Contact your administrator to create the user.',
      'passwordChangeRequestNotFound' => 'The password change request is not found. It might be expired. Try to initiate a new password recovery from the [login page]({url}).',
      'defaultTeamIsNotUsers' => 'Default Team should be one of user\'s Teams'
    ],
    'options' => [
      'gender' => [
        '' => 'No Definido',
        'Male' => 'Masculino',
        'Female' => 'Femenino',
        'Neutral' => 'Neutral'
      ],
      'type' => [
        'regular' => 'Regular',
        'admin' => 'Administrador',
        'portal' => 'Portal',
        'system' => 'Sistema',
        'super-admin' => 'Super-Administrador',
        'api' => 'API'
      ],
      'authMethod' => [
        'ApiKey' => 'Llave API',
        'Hmac' => 'HMAC'
      ],
      'projectRole' => [
        '' => 'Member',
        'Editor' => 'Editor',
        'Owner' => 'Owner'
      ],
      'userType' => [
        'Reseller' => 'Reseller',
        'Customer' => 'Customer',
        'Internal team' => 'Internal team',
        ' ' => ' ',
        'Synnex Staff' => 'TD SYNNEX'
      ],
      'productBrand' => [
        'AWS' => 'AWS',
        'Cisco' => 'Cisco',
        'Enterprise' => 'Enterprise',
        'Fortinet' => 'Fortinet',
        'IBM' => 'IBM',
        'Microsoft' => 'Microsoft',
        'Google' => 'Google',
        'IBM Cloud' => 'IBM Cloud'
      ],
      'countryList' => [
        'Brasil' => 'Brasil',
        'Argentina' => 'Argentina',
        'Bolivia' => 'Bolivia',
        'Colombia' => 'Colombia',
        'Ecuador' => 'Ecuador',
        'Mexico' => 'Mexico',
        'Uruguay' => 'Uruguay',
        'Peru' => 'Peru',
        'Caribe' => 'Caribe',
        'Chile' => 'Chile',
        'Panama' => 'Panama',
        'Paraguay' => 'Paraguay'
      ],
      'configApp' => [
        'AWS' => 'AWS',
        'GCP' => 'GCP',
        'Azure' => 'Azure'
      ],
      'salesTerritory' => [
        'Accelerate' => 'Accelerate',
        'CA&A' => 'CA&A',
        'Cisco Solutions 1' => 'Cisco Solutions 1',
        'Cisco Solutions 2' => 'Cisco Solutions 2',
        'Cloud XaaS' => 'Cloud XaaS',
        'Infra' => 'Infra',
        'Marketing Cloud' => 'Marketing Cloud',
        'Sales Support Cloud' => 'Sales Support Cloud',
        'Security' => 'Security',
        'Service Providers 1' => 'Service Providers 1',
        'Service Providers 2' => 'Service Providers 2',
        'Specialized Solutions - IBM/Oracle' => 'Specialized Solutions - IBM/Oracle',
        'Specialized Solutions - Regional' => 'Specialized Solutions - Regional',
        'VBM Cloud' => 'VBM Cloud',
        'VP, General Manager' => 'VP, General Manager'
      ]
    ],
    'boolFilters' => [
      'onlyMyTeam' => 'Sólo mi equipo',
      'onlyMe' => 'OnlyMe'
    ],
    'presetFilters' => [
      'active' => 'Activo',
      'activePortal' => 'Portal Activo',
      'activeApi' => 'API Active',
      'reportFilter669ab1ec9e2cc5afe' => 'BDM Users: AWS',
      'reportFilter669ab1fb8382eba48' => 'BDM Users: Microsoft',
      'reportFilter669ab2078ca7cc670' => 'BDM Users: Google'
    ],
    'actions' => [
      'changePosition' => 'Change Position'
    ]
  ],
  'Webhook' => [
    'labels' => [
      'Create Webhook' => 'Create Webhook'
    ],
    'fields' => [
      'event' => 'Event',
      'url' => 'URL',
      'isActive' => 'Is Active',
      'user' => 'API User',
      'entityType' => 'Entity Type',
      'field' => 'Field',
      'secretKey' => 'Secret Key'
    ],
    'links' => [
      'user' => 'User'
    ]
  ],
  'WebhookQueueItem' => [
    'fields' => [
      'event' => 'Event',
      'webhook' => 'Webhook',
      'target' => 'Target',
      'data' => 'Data',
      'status' => 'Status',
      'processedAt' => 'Processed At',
      'attempts' => 'Attempts',
      'processAt' => 'Process At'
    ],
    'links' => [
      'webhook' => 'Webhook'
    ],
    'options' => [
      'status' => [
        'Pending' => 'Pending',
        'Success' => 'Success',
        'Failed' => 'Failed'
      ]
    ]
  ],
  'WorkingTimeCalendar' => [
    'labels' => [
      'Create WorkingTimeCalendar' => 'Create Calendar'
    ],
    'fields' => [
      'timeZone' => 'Time Zone',
      'timeRanges' => 'Workday Schedule',
      'weekday0' => 'Sun',
      'weekday1' => 'Mon',
      'weekday2' => 'Tue',
      'weekday3' => 'Wed',
      'weekday4' => 'Thu',
      'weekday5' => 'Fri',
      'weekday6' => 'Sat',
      'weekday0TimeRanges' => 'Sun Schedule',
      'weekday1TimeRanges' => 'Mon Schedule',
      'weekday2TimeRanges' => 'Tue Schedule',
      'weekday3TimeRanges' => 'Wed Schedule',
      'weekday4TimeRanges' => 'Thu Schedule',
      'weekday5TimeRanges' => 'Fri Schedule',
      'weekday6TimeRanges' => 'Sat Schedule'
    ],
    'links' => [
      'ranges' => 'Exceptions'
    ]
  ],
  'WorkingTimeRange' => [
    'labels' => [
      'Create WorkingTimeRange' => 'Create Exception',
      'Calendars' => 'Calendars'
    ],
    'fields' => [
      'timeRanges' => 'Schedule',
      'dateStart' => 'Date Start',
      'dateEnd' => 'Date End',
      'type' => 'Type',
      'calendars' => 'Calendars',
      'users' => 'Users'
    ],
    'links' => [
      'calendars' => 'Calendars',
      'users' => 'Users'
    ],
    'options' => [
      'type' => [
        'Non-working' => 'Non-working',
        'Working' => 'Working'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Actual'
    ],
    'tooltips' => [
      'calendars' => 'Calendars to apply the exception to. The exception will be applied to all users of selected calendars.

Leave the field empty if you need to apply the exception only for specific users.',
      'users' => 'Specific users to apply the exception to.'
    ]
  ],
  'Account' => [
    'fields' => [
      'name' => 'Nombre',
      'emailAddress' => 'Correo electrónico',
      'website' => 'Dominio',
      'phoneNumber' => 'Teléfono',
      'billingAddress' => 'Dirección de Facturación',
      'shippingAddress' => 'Dirección de Entrega',
      'description' => 'Descripción',
      'sicCode' => 'Número de identificación fiscal: (TAX ID / NIT / RUC / CNPJ)',
      'industry' => 'Industria',
      'type' => 'Tipo',
      'contactRole' => 'Título',
      'contactIsInactive' => 'Inactivo',
      'campaign' => 'Campaña',
      'targetLists' => 'Listas de Intereses',
      'targetList' => 'Lista de Intereses',
      'originalLead' => 'Referencia Original',
      'priceBook' => 'Price Book',
      'electronicAddressScheme' => 'Electronic Address Scheme',
      'electronicAddressIdentifier' => 'Electronic Address Identifier',
      'updateField' => 'Update Field',
      'leads' => 'Leads',
      'logo' => 'Logo',
      'renewalresponsible' => 'Renewal Responsible',
      'companyID' => 'TD SYNNEX ID',
      'country' => 'País',
      'partnerIDs' => 'Partner IDs',
      'surestep' => 'Surestep',
      'surestepLevel1' => 'Surestep Level',
      'ciscoJourney' => 'Cisco Journey',
      'opps' => 'Oportunidades',
      'partnerPrograms' => 'Partner Programs',
      'cloudConsumptions' => 'Cloud consumption',
      'cpb' => 'Cloud Practice Builder',
      'programs1' => 'Program',
      'typeOfBusiness' => 'Business Type',
      'aWS' => 'AWS Cuentas',
      'googlePartnerAdvantage' => 'Google Partner Advantage',
      'googleClouds' => 'Google Clouds',
      'partnersGoogleClouds' => 'Google Cloud',
      'statusCPB' => 'Status CPB',
      'dSETAWS' => 'DSET AWS',
      'programaGoogleCloud' => 'Program - Google Cloud',
      'region' => 'Region',
      'progresspartner' => 'Progreso del Partner',
      'partnersGoogleCloud' => 'Progreso del Partner',
      'programaCloudPracticeBuilder' => 'Cloud Practice Builder',
      'programSurestep' => 'Programa - Surestep',
      'iSVExperience1' => 'Programa ISV Experience',
      'consumoSurestep' => 'Consumo Surestep',
      'cPBs' => 'CPBs',
      'updated' => 'Updated',
      'externalIDcdp' => 'External ID cdp',
      'events' => 'Events',
      'sPMSID' => 'SPMSID',
      'aWSs' => 'AWS',
      'aws' => 'Partner Program',
      'dSETs' => 'DSET',
      'cpbIoTFinancial' => 'CPB IoT Financial',
      'cpbIoTStrategy' => 'CPB IoT Strategy',
      'cPBIoTAnalytic' => 'CPB IoT Analytic',
      'cPBIoTMarketing' => 'CPB IoT Marketing',
      'cPBIoTTechnology' => 'CPB IoT Technology',
      'pBGeral' => 'PBGeral',
      'vendorSubscriptions' => 'Vendor Subscriptions',
      'accountParent' => 'Matriz',
      'accounts' => 'Sucursal',
      'typeOfCompany' => 'Tipo de Empresa',
      'services1' => 'Opportunities (Services) - End Customer',
      'vendorAccounts' => 'Vendor Accounts',
      'dSAStartDate' => 'DSA start date',
      'user' => 'VBM User',
      'isv' => 'ISV',
      'unity' => 'Unity',
      'dSAStatus' => 'DSA Status',
      'reports' => 'Reports',
      'renewals' => 'Microsoft Renewals - next 90 days',
      'emailContent' => 'Email Content',
      'accountVMB' => 'Cuenta VMB',
      'accountVBM' => 'Cuenta VBM',
      'emailContents' => 'Email Contents',
      'top5Customers' => 'Top 5 Customers',
      'reservedInstances' => 'Reserved Instances',
      'bdm' => 'VBA/BDR/BDM',
      'cloudsolvSSAID' => 'CloudsolvSSAID',
      'hasRenewals' => 'hasRenewals',
      'cisCode' => 'CIS Code',
      'dataAIAssessment' => 'Data AI Assessment',
      'salesOrdersRecommendations' => 'Microsoft Recommendations - next 90 days',
      'accountContent' => 'Account Content',
      'messenger' => 'Messenger',
      'messengers' => 'Mensageria',
      'renewalsMicrosoft' => 'Microsoft Renewals',
      'cUserSales' => 'AM',
      'cRenewalsMicrosoft' => 'Microsoft Renewals',
      'cPartnerAssessmentCategory' => 'Categoria do Parceiro',
      'billingAddressCountry' => 'billingAddressCountry',
      'renewalsAutoOff15Days' => 'No. de Licencias con Auto Renovación OFF - Next 15 days',
      'renewalsAutoOff45Days' => 'No. de Licencias con Auto Renovación OFF - From 15 to 45 days',
      'renewalsAutoOff90Days' => 'No. de Licencias con Auto Renovación OFF - From 45 to 90 days',
      'renewalsEndCustomers15Days' => 'No. de Clientes Finales - Next 15 days',
      'renewalsEndCustomers45Days' => 'No. de Clientes Finales - From 15 to 45 days',
      'renewalsEndCustomers90Days' => 'No. de Clientes Finales - From 45 to 90 days',
      'renewalsLicenses15Days' => 'No. de Licencias - Next 15 days',
      'renewalsLicenses45Days' => 'No. de Licencias - From 15 to 45 days',
      'renewalsLicenses90Days' => 'No. de Licencias - From 45 to 90 days',
      'renewalsRecommendations90Days' => 'No. de Recomendaciones Microsoft - Next 90 days',
      'renewalsRecommendationsCopilot90Days' => 'No. de Recomendaciones Copilot - Next 90 days',
      'renewalsReservedInstances90Days' => 'No. de Instancias Reservadas - Next 90 days',
      'renewalTop3' => 'Clientes Top - Next 90 days'
    ],
    'links' => [
      'contacts' => 'Contactos',
      'contactsPrimary' => 'Contactos (primary)',
      'opportunities' => 'Oportunidades',
      'cases' => 'Casos',
      'documents' => 'Documentos',
      'meetingsPrimary' => 'Presentaciones (ampliado)',
      'callsPrimary' => 'Llamadas (ampliado)',
      'tasksPrimary' => 'Tareas (ampliado)',
      'emailsPrimary' => 'Correos (ampliado)',
      'targetLists' => 'Listas de Intereses',
      'campaignLogRecords' => 'Historial de Campañas',
      'campaign' => 'Campaña',
      'portalUsers' => 'Usuarios del Portal',
      'originalLead' => 'Referencia Original',
      'priceBook' => 'Price Book',
      'supplier' => 'Supplier',
      'quotes' => 'Quotes',
      'quoteItems' => 'Quote Items',
      'salesOrders' => 'Ordenes de Venta',
      'salesOrderItems' => 'Ordenes de Venta Items',
      'invoices' => 'Invoices',
      'invoiceItems' => 'Invoice Items',
      'purchaseOrders' => 'Purchase Orders',
      'purchaseOrderItems' => 'Purchase Order Items',
      'deliveryOrders' => 'Delivery Orders',
      'deliveryOrderItems' => 'Delivery Order Items',
      'receiptOrders' => 'Receipt Orders',
      'receiptOrderItems' => 'Receipt Order Items',
      'returnOrders' => 'Return Orders',
      'returnOrderItems' => 'Return Order Items',
      'leads' => 'Leads',
      'renewalresponsible' => 'Renewal Responsible',
      'partnerIDs' => 'Partner IDs',
      'surestep' => 'Surestep',
      'ciscoJourney' => 'Cisco Journey',
      'opps' => 'Opportunities',
      'partnerPrograms' => 'Partner Programs',
      'cloudConsumptions' => 'Cloud Consumptions',
      'cpb' => 'Cloud Practice Builder',
      'programs1' => 'Program',
      'aWS' => 'AWS Cuentas',
      'googlePartnerAdvantage' => 'Google Partner Advantage',
      'googleClouds' => 'Google Clouds',
      'partnersGoogleClouds' => 'Google Cloud',
      'programaGoogleCloud' => 'Program Google Cloud',
      'region' => 'Region',
      'country' => 'Pais',
      'progresspartner' => 'Progreso del Partner',
      'partnersGoogleCloud' => 'Progreso del Partner',
      'programaAWS' => 'Programa - AWS',
      'programaCloudPracticeBuilder' => 'Cloud Practice Builder',
      'programSurestep' => 'Programa - Surestep',
      'iSVExperience1' => 'Programa ISV Experience',
      'cPBs' => 'CPBs',
      'events' => 'Events',
      'aWSs' => 'AWS',
      'aws' => 'AWS',
      'dSETs' => 'DSET',
      'cpbIoTFinancial' => 'CPB IoT Financial',
      'cpbIoTStrategy' => 'CPB IoT Strategy',
      'cPBIoTAnalytic' => 'CPB IoT Analytic',
      'cPBIoTMarketing' => 'CPB IoT Marketing',
      'cPBIoTTechnology' => 'CPB IoT Technology',
      'pBGeral' => 'PBGeneral',
      'vendorSubscriptions' => 'Vendor Subscriptions',
      'accountParent' => 'Headquarters',
      'accounts' => 'Sucursal',
      'services1' => 'Oportunidades (Servicios) - Cliente Final',
      'vendorAccounts' => 'Vendor Accounts',
      'user' => 'VBM User',
      'reports' => 'Reports',
      'renewals' => 'Renewals',
      'emailContent' => 'Email Content',
      'accountVMB' => 'Cuenta VMB',
      'accountVBM' => 'Cuenta VBM',
      'emailContents' => 'Email Contents',
      'top5Customers' => 'Top 5 Customers',
      'reservedInstances' => 'Reserved Instances',
      'bdm' => 'BDMs',
      'users' => 'BDMs',
      'dataAIAssessment' => 'Data AI Assessment',
      'salesOrdersRecommendations' => 'Microsoft Recommendations',
      'accountContent' => 'Account Content',
      'messenger' => 'Messenger',
      'messengers' => 'Messaging',
      'renewalsMicrosoft' => 'Microsoft Renewals',
      'cUserSales' => 'AM',
      'cRenewalsMicrosoft' => 'Microsoft Renewals'
    ],
    'options' => [
      'type' => [
        'Customer' => 'Cliente',
        'Investor' => 'Inversor',
        'Partner' => 'Socio',
        'Reseller' => 'Revendedor',
        '' => '',
        'ISV' => 'ISV',
        'Enterprise' => 'Enterprise',
        'Consulting' => 'Consulting',
        'Technology' => 'Technology',
        'Socio	' => 'Socio	',
        'Service Provider' => 'Service Provider',
        'Manufacturer' => 'Manufacturer'
      ],
      'industry' => [
        'Aerospace' => 'Aeroespacial',
        'Agriculture' => 'Agricultura',
        'Advertising' => 'Publicidad',
        'Apparel & Accessories' => 'Ropa y Accesorios',
        'Architecture' => 'Arquitectura',
        'Automotive' => 'Automotriz',
        'Banking' => 'Banca',
        'Biotechnology' => 'Biotecnolodía',
        'Building Materials & Equipment' => 'Materiales de construcción y equipamiento',
        'Chemical' => 'Química',
        'Construction' => 'Construcción',
        'Computer' => 'Computación',
        'Defense' => 'Defensa',
        'Creative' => 'Creativo',
        'Culture' => 'Cultura',
        'Consulting' => 'Consultando',
        'Education' => 'Educación',
        'Electronics' => 'Electrónicos',
        'Electric Power' => 'Energía eléctrica',
        'Energy' => 'Energía',
        'Entertainment & Leisure' => 'Entretenimiento y Ocio',
        'Finance' => 'Finanzas',
        'Food & Beverage' => 'Alimentación y bebidas',
        'Grocery' => 'Comestibles',
        'Hospitality' => 'Hospitalidad',
        'Healthcare' => 'Cuidado de la Salud',
        'Insurance' => 'Seguros',
        'Legal' => 'Jurídico',
        'Manufacturing' => 'Fabricación',
        'Mass Media' => 'Medios masivos',
        'Mining' => 'Minería',
        'Music' => 'Música',
        'Marketing' => 'Marketing',
        'Publishing' => 'Publicaciones',
        'Petroleum' => 'Petróleo',
        'Real Estate' => 'Bienes Raices',
        'Retail' => 'Menudeo',
        'Shipping' => 'Entrega',
        'Service' => 'Servicio',
        'Support' => 'Soporte',
        'Sports' => 'Deportes',
        'Software' => 'Software',
        'Technology' => 'Tecnología',
        'Telecommunications' => 'Telecomunicaciones',
        'Television' => 'Televisión',
        'Testing, Inspection & Certification' => 'Prueba, Inspección y Certificación',
        'Transportation' => 'Transporte',
        'Travel' => 'Viaje',
        'Venture Capital' => 'Capital de Riesgo',
        'Wholesale' => 'Compra Total',
        'Water' => 'Agua'
      ],
      'country' => [
        '' => '',
        'Argentina' => 'Argentina',
        'Brasil' => 'Brasil',
        'CALA' => 'CALA',
        'Caribe' => 'Caribe',
        'Centro' => 'Centro',
        'Chile' => 'Chile',
        'Colombia' => 'Colombia',
        'Equador' => 'Ecuador',
        'México' => 'Mexico',
        'Perú' => 'Peru',
        'South' => 'Sul',
        'Amer.Virgin Is.' => 'Amer.Virgin Is.',
        'Antigua/Barbuda' => 'Antigua/Barbuda',
        'Aruba' => 'Aruba',
        'Bahamas' => 'Bahamas',
        'Barbados' => 'Barbados',
        'Bermuda' => 'Bermuda',
        'Bolivia' => 'Bolivia',
        'BQ' => 'BQ',
        'Brit.Virgin Is.' => 'Brit.Virgin Is.',
        'Cayman Islands' => 'Cayman Islands',
        'Costa Rica' => 'Costa Rica',
        'CW' => 'CW',
        'Dominican Republic' => 'Dominican Republic',
        'El Salvador' => 'El Salvador',
        'Grenada' => 'Grenada',
        'Guadeloupe' => 'Guadeloupe',
        'Guyana' => 'Guyana',
        'Honduras' => 'Honduras',
        'Jamaica' => 'Jamaica',
        'Nicaragua' => 'Nicaragua',
        'Panama' => 'Panama',
        'St. Lucia' => 'St. Lucia',
        'St. Vincent' => 'St. Vincent',
        'Suriname' => 'Suriname',
        'SX' => 'SX',
        'Trinidad Tobago' => 'Trinidad Tobago',
        'USA' => 'USA',
        'CCA' => 'CCA',
        'Ecuador' => 'Ecuador',
        'Mexico' => 'Mexico',
        'Peru' => 'Peru',
        'Brazil' => 'Brazil',
        'Guadelouope' => 'Guadelouope',
        'Guatemala' => 'Guatemala',
        'Paraguay' => 'Paraguay',
        'Puerto Rico' => 'Puerto Rico',
        'Uruguay' => 'Uruguay',
        'Venezuela' => 'Venezuela',
        'Ecuador ' => 'Ecuador',
        'Santa Lucía' => 'Santa Lucía',
        'San vicente y las Granadinas' => 'San vicente y las Granadinas',
        'San Cristóbal y Nieves' => 'San Cristóbal y Nieves',
        'Belice' => 'Belice',
        'Haití' => 'Haití',
        'Granada' => 'Granada',
        'Cuba' => 'Cuba',
        'Antigua y barbuda' => 'Antigua y barbuda',
        'United States' => 'United States',
        'Brasil (teste)' => 'Brazil (teste)'
      ],
      'statusCPB' => [
        '' => '',
        'Concluido' => 'Concluido',
        'Desenvolvimento' => 'Desenvolvimento',
        'Iniciado' => 'Iniciado'
      ],
      'dSETAWS' => [
        '' => '',
        'Principiante' => 'Principiante',
        'Intermedio' => 'Intermedio',
        'Avanzado' => 'Avanzado'
      ],
      'region' => [
        '' => '',
        'Brasil' => 'Brasil',
        'CCA' => 'CCA',
        'Mexico' => 'Mexico',
        'NOLA' => 'NOLA',
        'SOLA' => 'SOLA',
        'None LAC' => 'None LAC'
      ],
      'typeOfCompany' => [
        '' => '',
        'Matriz' => 'Matriz',
        'Filial' => 'Sucursal'
      ],
      'isv' => [
        '' => 'No',
        'Sim' => 'Si'
      ],
      'unity' => [
        '' => '',
        'Velocity' => 'Velocity',
        'Valor' => 'Value',
        'Telco' => 'Telco'
      ],
      'dSAStatus' => [
        '' => '',
        'Cancelled' => 'Cancelled',
        'Executed' => 'Executed',
        'In Progress' => 'In Progress',
        'Inactive' => 'Inactive',
        'Pending DSA Signature' => 'Pending DSA Signature',
        'Rejected' => 'Rejected'
      ],
      'contractStatusCisco' => [
        '' => '',
        'Ativo' => 'Ativo',
        'Em Renovação' => 'Em Renovacion'
      ],
      'msftProgram' => [
        '' => 'No Aplica',
        'CSU' => 'CSU',
        'CSU e TCO' => 'CSU y TCO'
      ]
    ],
    'labels' => [
      'Create Account' => 'Crear Cuenta',
      'Copy Billing' => 'Copia Facturación',
      'Set Primary' => 'Es Primario'
    ],
    'presetFilters' => [
      'customers' => 'Clientes',
      'partners' => 'Socios',
      'recentlyCreated' => 'Recientemente Creado(a)',
      'reportFilter6660add1bf8c29edd' => 'Renewals Notification: Account',
      'reportFilter67c9a61c38980f876' => 'Contas - Brasil'
    ],
    'tabs' => [
      'Account' => 'Account',
      'Support' => 'Support'
    ]
  ],
  'Calendar' => [
    'modes' => [
      'month' => 'Mes',
      'week' => 'Semana',
      'day' => 'Día',
      'agendaWeek' => 'Semana',
      'agendaDay' => 'Día',
      'timeline' => 'Cronograma'
    ],
    'labels' => [
      'Today' => 'Hoy',
      'Create' => 'Crear',
      'Shared' => 'Compartido',
      'Add User' => 'Agregar Usuario',
      'current' => 'actual',
      'time' => 'hora',
      'User List' => 'Lista de Usuarios',
      'Manage Users' => 'Usuarios',
      'View Calendar' => 'Ver Calendario',
      'Create Shared View' => 'Crear Vista Compartida'
    ]
  ],
  'Call' => [
    'fields' => [
      'name' => 'Nombre',
      'parent' => 'Padre',
      'status' => 'Estátus',
      'dateStart' => 'Fecha de Comienzo',
      'dateEnd' => 'Fecha de Finalización',
      'direction' => 'Dirección',
      'duration' => 'Duración',
      'description' => 'Descripción',
      'users' => 'Usuarios',
      'contacts' => 'Contactos',
      'leads' => 'Referencias',
      'reminders' => 'Recordatorios',
      'account' => 'Cuenta',
      'acceptanceStatus' => 'Estátus de Aprobación',
      'uid' => 'UID',
      'insideSales' => 'Inside Sales?',
      'impossibleContact' => 'Impossible to Contact',
      'leads1' => 'Leads',
      'lead' => 'Lead',
      'solution' => 'Solution',
      'source' => 'Source',
      'leadCountry' => 'Lead Country'
    ],
    'links' => [
      'leads1' => 'Leads',
      'lead' => 'Lead'
    ],
    'options' => [
      'status' => [
        'Planned' => 'Planeadas',
        'Held' => 'Retenida',
        'Not Held' => 'Pendiente'
      ],
      'direction' => [
        'Outbound' => 'Saliente',
        'Inbound' => 'Entrante'
      ],
      'acceptanceStatus' => [
        'None' => 'Ninguno',
        'Accepted' => 'Aprobado',
        'Declined' => 'Rechazado',
        'Tentative' => 'Tentativa'
      ],
      'insideSales' => [
        'Yes' => 'Si',
        'No' => 'No',
        ' ' => ' '
      ],
      'impossibleContact' => [
        '' => '',
        'No number' => 'No number',
        'Invalid number' => 'Invalid number'
      ],
      'source' => [
        'Microsoft Surestep' => 'Microsoft Surestep',
        'Security' => 'Security',
        'Modern Workplace' => 'Modern Workplace',
        '' => '',
        'Other' => 'Other'
      ]
    ],
    'massActions' => [
      'setHeld' => 'Marcar como Retenida',
      'setNotHeld' => 'Marcar como Pendiente'
    ],
    'labels' => [
      'Create Call' => 'Crear Llamada',
      'Set Held' => 'Marcar como Retenida',
      'Set Not Held' => 'Marcar como Pendiente',
      'Send Invitations' => 'Enviar Invitaciones'
    ],
    'presetFilters' => [
      'planned' => 'Planeadas',
      'held' => 'Retenida',
      'todays' => 'De Hoy'
    ]
  ],
  'Campaign' => [
    'fields' => [
      'name' => 'Nombre',
      'description' => 'Descripción',
      'status' => 'Estátus',
      'type' => 'Tipo',
      'startDate' => 'Fecha de Inicio',
      'endDate' => 'Fecha de Fin',
      'targetLists' => 'Lista de Intereses',
      'excludingTargetLists' => 'Listas de Intereses Excluidas',
      'sentCount' => 'Enviado',
      'openedCount' => 'Abierto',
      'clickedCount' => 'Leídos',
      'optedOutCount' => 'Rechazado',
      'bouncedCount' => 'Rebotados',
      'optedInCount' => 'Opt-In aceptado',
      'hardBouncedCount' => 'No Existen',
      'softBouncedCount' => 'No Aceptados',
      'leadCreatedCount' => 'Referencias Creadas',
      'revenue' => 'Ingresos',
      'revenueConverted' => 'ingresos (convertido)',
      'budget' => 'Presupuesto',
      'budgetConverted' => 'Presupuesto (convertido)',
      'budgetCurrency' => 'Budget Currency',
      'contactsTemplate' => 'Formato de Contactos',
      'leadsTemplate' => 'Formato de Referencias',
      'accountsTemplate' => 'Formato de Cuentas',
      'usersTemplate' => 'Formato de Usuarios',
      'mailMergeOnlyWithAddress' => 'Saltar registros sin dirección capturada'
    ],
    'links' => [
      'targetLists' => 'Listas de Intereses',
      'excludingTargetLists' => 'Listas de Intereses Excluidas',
      'accounts' => 'Cuentas',
      'contacts' => 'Contactos',
      'leads' => 'Referencias',
      'opportunities' => 'Oportunidades',
      'campaignLogRecords' => 'Historial',
      'massEmails' => 'Correos Masivos',
      'trackingUrls' => 'Seguimiento a URLs',
      'contactsTemplate' => 'Formato de Contactos',
      'leadsTemplate' => 'Formato de Referencias',
      'accountsTemplate' => 'Formato de Cuentas',
      'usersTemplate' => 'Formato de Usuarios'
    ],
    'options' => [
      'type' => [
        'Email' => 'Correo electrónico',
        'Web' => 'Web',
        'Television' => 'Televisión',
        'Radio' => 'Radio',
        'Newsletter' => 'Periódico',
        'Mail' => 'Correo'
      ],
      'status' => [
        'Planning' => 'Planificación',
        'Active' => 'Activo',
        'Inactive' => 'Inactivo',
        'Complete' => 'Completada'
      ]
    ],
    'labels' => [
      'Create Campaign' => 'Crear Campaña',
      'Target Lists' => 'Listas de Intereses',
      'Statistics' => 'Estadísticas',
      'hard' => 'duro',
      'soft' => 'suave',
      'Unsubscribe' => 'Cancelar suscripción',
      'Mass Emails' => 'Correos Masivos',
      'Email Templates' => 'Correo Modelo',
      'Unsubscribe again' => 'Cancelar otra vez la suscripción',
      'Subscribe again' => 'Volverse a suscribir',
      'Create Target List' => 'Crear Lista de Obejtivos',
      'Mail Merge' => 'Generar Correos',
      'Generate Mail Merge PDF' => 'Generar PDF para Correos'
    ],
    'presetFilters' => [
      'active' => 'Activo'
    ],
    'messages' => [
      'unsubscribed' => 'Usted ha cancelado la suscripción a nuestra lista de correo.',
      'subscribedAgain' => 'Usted se ha vuelto a suscribir.'
    ],
    'tooltips' => [
      'targetLists' => 'Intereses que deben recibir mensajes.',
      'excludingTargetLists' => 'Los intereses que no deben recibir mensajes.'
    ]
  ],
  'CampaignLogRecord' => [
    'fields' => [
      'action' => 'Acción',
      'actionDate' => 'Fecha',
      'data' => 'Datos',
      'campaign' => 'Campaña',
      'parent' => 'Interés',
      'object' => 'Objeto',
      'application' => 'Aplicacion',
      'queueItem' => 'Item de la Lista',
      'stringData' => 'Datos Alfanuméricos',
      'stringAdditionalData' => 'Datos Alfanuméricos Adicionales',
      'isTest' => 'Es una prueba'
    ],
    'links' => [
      'queueItem' => 'Elemento de la Cola',
      'parent' => 'Padre',
      'object' => 'Objeto',
      'campaign' => 'Campaña'
    ],
    'options' => [
      'action' => [
        'Sent' => 'Enviado',
        'Opened' => 'Abierto',
        'Opted Out' => 'Rechazado',
        'Bounced' => 'Rebotados',
        'Clicked' => 'Leído',
        'Lead Created' => 'Referencias Creadas',
        'Opted In' => 'Opt-In aceptado'
      ]
    ],
    'labels' => [
      'All' => 'Todos'
    ],
    'presetFilters' => [
      'sent' => 'Enviado',
      'opened' => 'Abierto',
      'optedOut' => 'Rechazado',
      'optedIn' => 'Opt-In aceptado',
      'bounced' => 'Rebotados',
      'clicked' => 'Leído',
      'leadCreated' => 'Referencia Creada'
    ]
  ],
  'CampaignTrackingUrl' => [
    'fields' => [
      'url' => 'URL',
      'action' => 'Action',
      'urlToUse' => 'Código para insertar en lugar de la URL',
      'message' => 'Message',
      'campaign' => 'Campaña'
    ],
    'links' => [
      'campaign' => 'Campaña'
    ],
    'labels' => [
      'Create CampaignTrackingUrl' => 'Crear Seguimiento a URLs'
    ],
    'options' => [
      'action' => [
        'Redirect' => 'Redirect',
        'Show Message' => 'Show Message'
      ]
    ],
    'tooltips' => [
      'url' => 'The recipient will be redirected to this location after they follow the link.',
      'message' => 'The message will be shown to the recipient after they follow the link. Markdown is supported.'
    ]
  ],
  'Case' => [
    'fields' => [
      'name' => 'Nombre',
      'number' => 'Número',
      'status' => 'Estado',
      'account' => 'Cuenta',
      'contact' => 'Contacto',
      'contacts' => 'Contactos',
      'priority' => 'Prioridad',
      'type' => 'Tipo',
      'description' => 'Descripción',
      'inboundEmail' => 'Cuenta de Correo de Grupo',
      'lead' => 'Referencia',
      'attachments' => 'Adjuntos',
      'originalEmail' => 'Original Email',
      'isInternal' => 'Hidden from Portal',
      'solicitationType' => 'Mi solicitud es sobre:',
      'solicitationEntity' => 'Entidad solicitada',
      'testField' => 'Campo de prueba',
      'other' => 'Especifique a Entidad',
      'url' => 'URL del registro',
      'slaPrediction' => 'Previsión (SLA)',
      'cRegion' => 'Region'
    ],
    'links' => [
      'inboundEmail' => 'Cuenta de Correo de Grupo',
      'account' => 'Cuenta',
      'contact' => 'Contacto (Primario)',
      'Contacts' => 'Contactos',
      'meetings' => 'Presentaciones',
      'calls' => 'Llamadas',
      'tasks' => 'Tareas',
      'emails' => 'Correos',
      'articles' => 'Artículos de la Base de Conocimientos',
      'lead' => 'Referencia',
      'attachments' => 'Adjuntos'
    ],
    'options' => [
      'status' => [
        'New' => 'Nuevo',
        'Assigned' => 'Asignado',
        'Pending' => 'Pendiente',
        'Closed' => 'Cerrados',
        'Rejected' => 'Rechazado',
        'Duplicate' => 'Duplicar'
      ],
      'priority' => [
        'Low' => 'Baja',
        'Normal' => 'Normal',
        'High' => 'Alta',
        'Urgent' => 'Urgente'
      ],
      'type' => [
        'Question' => 'Pregunta',
        'Incident' => 'Incidente',
        'Problem' => 'Problema'
      ],
      'solicitationType' => [
        'Select an option.' => 'Selecciona una opción.',
        'Trouble with 404 error.' => 'Problema con el error 404.',
        'Trouble with 500 error.' => 'Problema con el error 500.',
        'I need help with one or more fields.' => 'Necesito ayuda con uno o más campos.',
        'My data is not updated.' => 'Mis datos no están actualizados.',
        'My data is wrong.' => 'Mis datos son incorrectos.',
        'My list is outdated.' => 'Mi lista está desactualizada.',
        'I can\'t create reports.' => '"No puedo crear reportes',
        'I can\'t create calls.' => 'No puedo crear llamadas.',
        'I can\'t create meetings.' => 'No puedo crear reuniones.',
        'I can\'t create tasks.' => 'No puedo crear tareas.',
        'I can\'t create reminders.' => 'No puedo crear recordatorios.',
        'I can\'t make edits.' => 'No puedo hacer ediciones.',
        'I can\'t make updates.' => 'No puedo hacer actualizaciones.',
        'I can\'t access the Kanban view.' => 'No puedo acceder a la vista Kanban.',
        'I can\'t see my data in the list.' => 'No puedo ver mis datos en la lista.',
        'I can\'t see my data in the dashboards.' => 'No puedo ver mis datos en los dashboards.',
        'I couldn\'t understand a tutorial.' => 'No pude entender un tutorial.',
        'There is no tutorials for my specific need.' => 'No hay tutoriales para mi necesidad específica.',
        'I am not finding a specific data/information (Requires description).' => 'No estoy encontrando un dato/información específica (Se requiere descripción).',
        'I can\'t see my history.' => 'No puedo ver mi historial.',
        'I can\'t see my activities.' => 'No puedo ver mis actividades.',
        'I can\'t see my tasks.' => 'No puedo ver mis tareas.',
        'I can\'t see my dashboards.' => '\'No puedo ver mis dashboards.',
        'Other.' => 'Otro'
      ],
      'solicitationEntity' => [
        'Select an option.' => 'Selecione uma opção',
        'Accounts' => 'Cuentas',
        'Calls' => 'Llamadas',
        'Contacts' => 'Contactos',
        'Leads' => 'Leads',
        'Meetings' => 'Reuniones',
        'Opportunities' => 'Oportunidades',
        'Reports' => 'Reportes',
        'Tasks' => 'Tareas',
        'Users' => 'Usuários',
        'Quotes' => 'Cotizaciones',
        '' => '',
        'Other' => 'Otro',
        'Partner Program' => 'Partner Program'
      ],
      'cRegion' => [
        '' => '',
        'Brasil' => 'Brasil',
        'MCA' => 'MCA'
      ]
    ],
    'labels' => [
      'Create Case' => 'Crear Caso',
      'Close' => 'Cerrar',
      'Reject' => 'Rechazar',
      'Closed' => 'Cerrados',
      'Rejected' => 'Rechazado'
    ],
    'presetFilters' => [
      'open' => 'Abiertos',
      'closed' => 'Cerrados'
    ],
    'tooltips' => [
      'solicitationType' => 'Aquí encontrarás algunas opciones para abrir un ticket. Si no encuentras la que necesitas, selecciona la opción: \'Otro\' y descríbelo en el campo \'Descripción\'.',
      'solicitationEntity' => 'Para abrir una solicitud de soporte, por favor selecciona con qué entidad necesitas ayuda.',
      'url' => 'Inserte la URL del registro.'
    ]
  ],
  'Contact' => [
    'fields' => [
      'name' => 'Nombre',
      'emailAddress' => 'Correo electrónico',
      'title' => 'Título de la Cuenta Primaria',
      'account' => 'Cuenta',
      'accounts' => 'Cuentas',
      'phoneNumber' => 'Teléfono',
      'accountType' => 'Tipo de Cuenta',
      'doNotCall' => 'No Llamar',
      'address' => 'Dirección',
      'opportunityRole' => 'Rol de Oportunidad',
      'accountRole' => 'Título',
      'description' => 'Descripción',
      'campaign' => 'Campaña',
      'targetLists' => 'Listas de Intereses',
      'targetList' => 'Lista de Intereses',
      'portalUser' => 'Usuario del Portal',
      'hasPortalUser' => 'Has Portal User',
      'originalLead' => 'Referencia Original',
      'acceptanceStatus' => 'Estatus de Aprobación',
      'accountIsInactive' => 'Cuenta Inactiva',
      'acceptanceStatusMeetings' => 'Estatus de Aceptación (Presentaciones)',
      'acceptanceStatusCalls' => 'Estátus de Aceptación (Llamadas)',
      'originalEmail' => 'Original Email',
      'analytics' => 'Analytics',
      'customerID' => 'Customer ID',
      'partnerID' => 'Partner ID',
      'type' => 'Tipo',
      'updateField' => 'Update Field',
      'user' => 'BDM User',
      'bdmuser' => 'BDM User',
      'requestedContact' => 'Requested contact',
      'nurturingProfile' => 'Nurturing Profile',
      'nurturingLinkProfile' => 'Nurturing Link profile',
      'archivosDeIntereses' => 'Archivos de intereses',
      'partnersGoogleCloud' => 'Partners Google Cloud',
      'partnersGoogleClouds' => 'Program Google Clouds',
      'programGoogleCloud' => 'Program Google Cloud',
      'programGoogleClouds' => 'Program Google Clouds',
      'cPB' => 'CPB',
      'dSET' => 'DSET',
      'position' => 'Position',
      'quotes' => 'Quotes',
      'opportunity' => 'Opportunity',
      'billingContactOpportunities' => 'Opportunities',
      'accountVBM' => 'Account VBM',
      'source' => 'Source',
      'externalIDcdp' => 'ExternalIDcdp',
      'emailContents' => 'Email Contents',
      'hasRenewals' => 'Contact Renewals',
      'dataAIAssessment' => 'Data AI Assessment',
      'salesContact' => 'Sales Contact',
      'accountCountry' => 'Account Country',
      'cMarketing' => 'Especifique el origen',
      'cAccountEndCustomer' => 'Account End Customer'
    ],
    'links' => [
      'opportunities' => 'Oportunidades',
      'cases' => 'Casos',
      'targetLists' => 'Listas de Intereses',
      'campaignLogRecords' => 'Registrar Campaña',
      'campaign' => 'Campaña',
      'account' => 'Cuenta (Primaria)',
      'accounts' => 'Cuentas',
      'casesPrimary' => 'Casos (Primario)',
      'tasksPrimary' => 'Tareas (extendidas)',
      'opportunitiesPrimary' => 'Opportunities (Primary)',
      'portalUser' => 'Usuario del Portal',
      'originalLead' => 'Referencia Original',
      'documents' => 'Documentos',
      'quotesBilling' => 'Quotes (Billing)',
      'quotesShipping' => 'Quotes (Shipping)',
      'salesOrdersBilling' => 'Sales Orders (Billing)',
      'salesOrdersShipping' => 'Sales Orders (Shipping)',
      'invoicesBilling' => 'Invoices (Billing)',
      'invoicesShipping' => 'Invoices (Shipping)',
      'purchaseOrdersBilling' => 'Purchase Orders (Billing)',
      'purchaseOrdersShipping' => 'Purchase Orders (Shipping)',
      'deliveryOrdersShipping' => 'Delivery Orders (Shipping)',
      'returnOrdersBilling' => 'Return Orders (Billing)',
      'returnOrdersShipping' => 'Return Orders (Shipping)',
      'receiptOrdersShipping' => 'Receipt Orders (Shipping)',
      'analytics' => 'Analytics',
      'user' => 'BDM User',
      'bdmuser' => 'BDM User',
      'partnersGoogleCloud' => 'Partners Google Cloud',
      'partnersGoogleClouds' => 'Program Google Clouds',
      'programGoogleCloud' => 'Programa Google Cloud',
      'programGoogleClouds' => 'Programa Google Clouds',
      'cPB' => 'CPB',
      'dSET' => 'DSET',
      'quotes' => 'Quotes',
      'opportunity' => 'Opportunity',
      'billingContactOpportunities' => 'Opportunities',
      'accountVBM' => 'Account VBM',
      'emailContents' => 'Email Contents',
      'dataAIAssessment' => 'Data AI Assessment',
      'cMarketing' => 'Marketing',
      'cAccountEndCustomer' => 'Account End Customer'
    ],
    'labels' => [
      'Create Contact' => 'Crear Contacto'
    ],
    'options' => [
      'opportunityRole' => [
        '' => '',
        'Decision Maker' => 'Tomador de Desiciones',
        'Evaluator' => 'Evaluador',
        'Influencer' => 'Factor de Influencia'
      ],
      'type' => [
        '' => '',
        'Revenda' => 'Revenda',
        'Cliente Final' => 'Cliente Final',
        'ISV' => 'ISV',
        'Renewal' => 'Renewal',
        'Customer' => 'Customer',
        'Reseller' => 'Reseller',
        'Primary' => 'Primary Contact',
        'Finance' => 'Finance',
        'Sales' => 'Sales'
      ],
      'archivosDeIntereses' => [
        'SMB Sales Scenarios - FY22' => 'SMB Sales Scenarios - FY22',
        'Azure App Modernization PDF' => 'Azure App Modernization PDF',
        'Azure Open Source PDF' => 'Azure Open Source PDF',
        'Azure Virtual Desktop PDF' => 'Azure Virtual Desktop PDF',
        'Azure Analytics PDF' => 'Azure Analytics PDF',
        'Azure Migration PDF' => 'Azure Migration PDF',
        'Azure Fundamental Guide PDF' => 'Azure Fundamental Guide PDF',
        'SPA Security PDF' => 'SPA Security PDF',
        'Latam Partner One :: Step by Step' => 'Latam Partner One :: Step by Step'
      ],
      'source' => [
        '' => '',
        'CloudSolv' => 'CloudSolv',
        'Campaign' => 'Campaign',
        'Commercial Portfolio' => 'Commercial Portfolio',
        'Manufacturer' => 'Manufacturer',
        'Meetings' => 'Meetings'
      ]
    ],
    'presetFilters' => [
      'portalUsers' => 'Usuarios del Portal',
      'notPortalUsers' => 'No son Usuarios del Portal',
      'accountActive' => 'Activo'
    ]
  ],
  'Document' => [
    'labels' => [
      'Create Document' => 'Crear Documento',
      'Details' => 'Detalles'
    ],
    'fields' => [
      'name' => 'Nombre',
      'status' => 'Estátus',
      'file' => 'Archivo',
      'type' => 'Tipo',
      'publishDate' => 'Publicar Fecha',
      'expirationDate' => 'Fecha de Expiración',
      'description' => 'Descripción',
      'accounts' => 'Cuentas',
      'folder' => 'Carpeta',
      'service' => 'Service',
      'importers' => 'Importers',
      'quote' => 'Quote',
      'quotes' => 'Quotes',
      'avisoEstimativa' => 'Notice'
    ],
    'links' => [
      'accounts' => 'Cuentas',
      'opportunities' => 'Oportunidades',
      'folder' => 'Carpeta',
      'leads' => 'Referencias',
      'contacts' => 'Contactos',
      'service' => 'Service',
      'importers' => 'Importers',
      'quote' => 'Quote',
      'quotes' => 'Quotes'
    ],
    'options' => [
      'status' => [
        'Active' => 'Activo',
        'Draft' => 'Borrador',
        'Expired' => 'Expirado',
        'Canceled' => 'Cancelado'
      ],
      'type' => [
        '' => 'Ninguno',
        'Contract' => 'Contrato',
        'NDA' => 'AdC',
        'EULA' => 'EULA',
        'License Agreement' => 'Contrato de Licencia',
        'Cotação' => 'Quote',
        'Estimativa' => 'Estimate'
      ]
    ],
    'presetFilters' => [
      'active' => 'Activo',
      'draft' => 'Borrador'
    ]
  ],
  'DocumentFolder' => [
    'labels' => [
      'Create DocumentFolder' => 'Crear Carpeta de Documentos',
      'Manage Categories' => 'Carpetas',
      'Documents' => 'Documentos'
    ],
    'links' => [
      'documents' => 'Documentos'
    ]
  ],
  'EmailQueueItem' => [
    'fields' => [
      'name' => 'Nombre',
      'status' => 'Estátus',
      'target' => 'Interés',
      'sentAt' => 'Enviado',
      'attemptCount' => 'Intentos',
      'emailAddress' => 'Correo Electrónico',
      'massEmail' => 'Correo Masivo',
      'isTest' => 'Es una prueba'
    ],
    'links' => [
      'target' => 'Interés',
      'massEmail' => 'Correo Masivo'
    ],
    'options' => [
      'status' => [
        'Pending' => 'Pendiente',
        'Sent' => 'Enviado',
        'Failed' => 'Falló',
        'Sending' => 'Enviando'
      ]
    ],
    'presetFilters' => [
      'pending' => 'Pendiente',
      'sent' => 'Enviado',
      'failed' => 'Falló'
    ]
  ],
  'KnowledgeBaseArticle' => [
    'labels' => [
      'Create KnowledgeBaseArticle' => 'Crear Artículo',
      'Any' => 'Cualquiera',
      'Send in Email' => 'Enviar por Correo',
      'Move Up' => 'Mover Arriba',
      'Move Down' => 'Mover Abajo',
      'Move to Top' => 'Mover al Principio',
      'Move to Bottom' => 'Mover al Final'
    ],
    'fields' => [
      'name' => 'Nombre',
      'status' => 'Estátus',
      'type' => 'Tipo',
      'attachments' => 'Datos adjuntos',
      'publishDate' => 'Fecha de Publicación',
      'expirationDate' => 'Fecha de Expiración',
      'description' => 'Descripción',
      'body' => 'Cuerpo',
      'categories' => 'Categorías',
      'language' => 'Idioma',
      'portals' => 'Portales'
    ],
    'links' => [
      'cases' => 'Casos',
      'opportunities' => 'Oportunidades',
      'categories' => 'Categorías',
      'portals' => 'Portales'
    ],
    'options' => [
      'status' => [
        'In Review' => 'En Revisión',
        'Draft' => 'Borrador',
        'Archived' => 'Arcivado',
        'Published' => 'Publicado'
      ],
      'type' => [
        'Article' => 'Artículo'
      ]
    ],
    'tooltips' => [
      'portals' => 'El Artículo estará disponible sólo en algunos portales.'
    ],
    'presetFilters' => [
      'published' => 'Publicado'
    ]
  ],
  'KnowledgeBaseCategory' => [
    'labels' => [
      'Create KnowledgeBaseCategory' => 'Crear Categoría',
      'Manage Categories' => 'Categorías',
      'Articles' => 'Artículos'
    ],
    'links' => [
      'articles' => 'Artículos'
    ]
  ],
  'Lead' => [
    'labels' => [
      'Converted To' => 'Convertido a',
      'Create Lead' => 'Crear Lead',
      'Convert' => 'Convertir',
      'convert' => 'Convertir'
    ],
    'fields' => [
      'name' => 'Nombre',
      'emailAddress' => 'Correo electrónico',
      'title' => 'Título',
      'website' => 'Sito Web',
      'phoneNumber' => 'Teléfono',
      'accountName' => 'Nombre de Cuenta',
      'doNotCall' => 'No Llamar',
      'address' => 'Dirección',
      'status' => 'Estado',
      'source' => 'Source',
      'opportunityAmount' => 'Costo de Oportunidad',
      'opportunityAmountConverted' => 'Costo de Oportunidad (convertido)',
      'description' => 'Descripción',
      'createdAccount' => 'Cuenta',
      'createdContact' => 'Contacto',
      'createdOpportunity' => 'Oportunidad',
      'convertedAt' => 'Convertido en',
      'campaign' => 'Campaña',
      'targetLists' => 'Listas de Intereses',
      'targetList' => 'Lista de Intereses',
      'industry' => 'Industria',
      'acceptanceStatus' => 'Estado de Aprobación',
      'opportunityAmountCurrency' => 'Importe de la Oportunidad',
      'acceptanceStatusMeetings' => 'Estado de Aceptación (Presentaciones)',
      'acceptanceStatusCalls' => 'Estado de Aceptación (Llamadas)',
      'originalEmail' => 'Original Email',
      'parceiros' => 'Company (OLD)',
      'type' => 'Tipo',
      'countryList' => 'País',
      'user' => 'BDM User',
      'externalId' => 'ExternalId',
      'engagementId' => 'EngagementId',
      'expirationDateTime' => 'Expira en:',
      'calls1' => 'Llamadas',
      'industria' => 'MX Industry',
      'nurturingProfile' => 'Nurturing Profile',
      'createSurestep' => 'Convert Lead and Create Surestep',
      'surestep' => 'Surestep',
      'iDSynnex' => 'ID SYNNEX',
      'ciscoProjectWon' => 'Proyecto cerrado?',
      'ciscoPrograms' => 'Programa Cisco',
      'alreadyContacted' => 'Contacted?',
      'cnpj' => 'Número de identificación fiscal: (TAX ID / NIT / RUC / CNPJ)',
      'brand' => 'Product Brand',
      'brands' => 'Marcas',
      'opportunities' => 'Opportunities',
      'googlePartnerAdvantage' => 'Google Partner Advantage',
      'createdAtVendor' => 'CreatedAtVendor',
      'conversionForecast' => 'Predicción de conversión de clientes potenciales',
      'marketings' => 'Specify the origin',
      'edgeType' => 'Edge for Cloud - Tipo de Fabricante',
      'brandInfra' => 'Fabricantes - Infraestructura',
      'brandsecurity' => 'Fabricantes - Seguridad',
      'lastName' => 'Apellido',
      'middleName' => 'Segundo nombre',
      'phoneNumberIsOptedOut' => 'El número de teléfono está excluido'
    ],
    'links' => [
      'targetLists' => 'Listas de Intereses',
      'campaignLogRecords' => 'Registrar Campaña',
      'campaign' => 'Campaña',
      'createdAccount' => 'Cuenta',
      'createdContact' => 'Contacto',
      'createdOpportunity' => 'Oportunidad',
      'cases' => 'Casos',
      'documents' => 'Documentos',
      'parceiros' => 'Empresa (OLD)',
      'user' => 'BDM User',
      'calls1' => 'Calls',
      'surestep' => 'Surestep',
      'ciscoPrograms' => 'Cisco Programs',
      'brand' => 'Product Brands',
      'brands' => 'Brands',
      'opportunities' => 'Opportunities',
      'googlePartnerAdvantage' => 'Google Partner Advantage',
      'marketings' => 'Marketings'
    ],
    'options' => [
      'status' => [
        'New' => 'Novo',
        'Assigned' => 'Asignado',
        'In Process' => 'En Proceso',
        'Converted' => 'Convertido',
        'Recycled' => 'Reciclado',
        'Dead' => 'Perdido',
        'Ready to contact' => 'Listo para Contactar',
        'Approved to follow' => 'Listo para Seguimiento',
        'Approved to Follow' => 'Listo para Seguimiento'
      ],
      'source' => [
        'Call' => 'Llamada',
        'Email' => 'E-mail',
        'Existing Customer' => 'Cliente',
        'Partner' => 'Canal',
        'Public Relations' => 'Relacionamiento',
        'Web Site' => 'Website',
        'Campaign' => 'Campaña',
        'Other' => 'Otro',
        '' => 'None',
        'Microsoft' => 'Microsoft',
        'MICROSOFT | Projeto Social Selling ISV\'s (Data to Go)' => 'MICROSOFT | Projeto Social Selling ISV\'s (Data to Go)',
        'IBM | Projeto Social Selling (Data to Go)' => 'IBM | Projeto Social Selling (Data to Go)',
        'Microsoft MPC' => 'Microsoft MPC',
        'Social Selling Microsoft CSP' => 'Social Selling Microsoft CSP',
        'Microsoft | Captação novos canais Linkedin' => 'Microsoft | Captação novos canais Linkedin',
        'SYNNEX' => 'SYNNEX',
        'EDGE for Cloud' => 'EDGE for Cloud',
        'ISV Experience' => 'ISV Experience',
        'MSFTPartnerCenter' => 'MSFTPartnerCenter',
        'Geração de Oportunidade - F5' => 'Geração de Oportunidade - F5',
        'Campanha LGPD - 2022' => 'Campanha LGPD - 2022',
        'Microsoft Surestep Recruitment' => 'Surestep Recruitment',
        'Derivaciones Leads Microsoft Argentina - FY21' => 'Derivaciones Leads Microsoft Argentina - FY21',
        'DG Partner Acquisition Banner IT Sitio Q3FY21' => 'DG Partner Acquisition Banner IT Sitio Q3FY21',
        'Partner Acquisition ISV Q2FY22' => 'Partner Acquisition ISV Q2FY22',
        'CISCO' => 'CISCO',
        'K.NOW' => 'K.NOW',
        'Accelerate' => 'Accelerate',
        'DMP' => 'DMP Cisco',
        'Levantamiento de datos de clientes finales de DATA/IA Segmento corportate' => 'Levantamiento de datos de clientes finales de DATA/IA Segmento corportate',
        'Lean Sales - Cisco' => 'Lean Sales - Cisco',
        'Telemarketing - Cisco' => 'Telemarketing - Cisco',
        'Select - Cisco' => 'Select - Cisco',
        'Cisco Radius LATAM Q1FY22 Comstor BRA' => 'Cisco Radius LATAM Q1FY22 Comstor BRA',
        'Cisco Radius LATAM Q2FY22 Comstor BRA' => 'Cisco Radius LATAM Q2FY22 Comstor BRA',
        'Cisco Radius LATAM Q3FY22 Comstor BRA' => 'Cisco Radius LATAM Q3FY22 Comstor BRA',
        'Download Content - Surestep' => 'Download Content - Surestep',
        'Submit Form - Surestep' => 'Surestep - Submit Form',
        'Surestep - Activate Campaign' => 'Surestep - Activate Campaign',
        'Surestep - Azure Development' => 'Surestep - Azure Development',
        'Surestep - Azure Recruitment' => 'Surestep - Azure Recruitment',
        'Surestep - Inspire Campaign' => 'Surestep - Inspire Campaign',
        'Surestep - Skyrocket Campaign' => 'Surestep - Skyrocket Campaign',
        'Evento - Terça nas Nuvens' => 'Evento - Terça nas Nuvens',
        'Surestep Recruitment' => 'Surestep Recruitment',
        'Cisco Radius' => 'Cisco Radius',
        'Cisco - Synnex Westcon Comstor - Cisco & Pure Storage' => 'Cisco - Synnex Westcon Comstor - Cisco & Pure Storage',
        'Cisco - HYPE Solutions & TD Synnex' => 'Cisco - HYPE Solutions & TD Synnex',
        'Cisco - DAP: Goahead Demand Generation' => 'Cisco - DAP: Goahead Demand Generation',
        'Cisco - DAP: Think Digital Demand Generation' => 'Cisco - DAP: Think Digital Demand Generation',
        'Cisco - Social Selling ' => 'Cisco - Social Selling ',
        'Cisco - SCALE: Demand Generation Collaboration' => 'Cisco - SCALE: Demand Generation Collaboration',
        'Cisco - DAP: Cisco Unified Campaign Demand Generation' => 'Cisco - DAP: Cisco Unified Campaign Demand Generation',
        'Cisco - DAP: HYPE & Cisco Hyperflex Tech Experience ' => 'Cisco - DAP: HYPE & Cisco Hyperflex Tech Experience ',
        'Cisco - DAP: Evento 12 CIOs Interatell ' => 'Cisco - DAP: Evento 12 CIOs Interatell ',
        'Cisco - DAP: Plano de ações ND&C ' => 'Cisco - DAP: Plano de ações ND&C ',
        'Cisco - DAP: Plano de Ações da NEXA ' => 'Cisco - DAP: Plano de Ações da NEXA ',
        'Cisco & Synnex Comstor - Secure Remote Work' => 'Cisco & Synnex Comstor - Secure Remote Work',
        'Cisco & Synnex Comstor - MIT SLOAN' => 'Cisco & Synnex Comstor - MIT SLOAN',
        'Cisco & Veeam Synnex - Pós Evento' => 'Cisco & Veeam Synnex - Pós Evento',
        'Cisco & Veeam & Synnex Westcon Comstor' => 'Cisco & Veeam & Synnex Westcon Comstor',
        'Cisco & Synnex Comstor - MVC' => 'Cisco & Synnex Comstor - MVC',
        'Cisco & TD Synnex - Lead Gen' => 'Cisco & TD Synnex - Lead Gen',
        'MW - Assessment de Migración' => 'MW - Assessment de Migración',
        'MW - Incentivos de venta para cierres de MS365' => 'MW - Incentivos de venta para cierres de MS365',
        'MW - Incentivo a la primera venta' => 'MW - Incentivo a la primera venta',
        'MW - XPND (Azure & MWP)' => 'MW - XPND (Azure & MWP)',
        'MW - Capacitación Herramientas colaborativas' => 'MW - Capacitación Herramientas colaborativas',
        'Azure - Pruebas de concepto' => 'Azure - Pruebas de concepto',
        'Azure - Incentivos para nuevos NACs' => 'Azure - Incentivos para nuevos NACs',
        'Azure - Webinar AZURE' => 'Azure - Webinar AZURE',
        'MW - Webinar MW' => 'MW - Webinar MW',
        'Azure - Referido Microsoft ' => 'Azure - Referido Microsoft ',
        'Azure - Partner Center' => 'Azure - Partner Center',
        'Azure - Alianza ruta N' => 'Azure - Alianza ruta N',
        'Azure - Alianza Rockstart' => 'Azure - Alianza Rockstart',
        'Azure - Evento StartCo' => 'Azure - Evento StartCo',
        'Azure - Base Edtech/Legaltech/Proptech' => 'Azure - Base Edtech/Legaltech/Proptech',
        'Azure / MW - Partner' => 'Azure / MW - Partner',
        'Microsoft AR - Agencia Novaz' => 'Microsoft AR - Agencia Novaz',
        'Microsoft AR - Agencia Marco Marketing' => 'Microsoft AR - Agencia Marco Marketing',
        'Microsoft AR - Leads Generados Mediaware (Enfasys)' => 'Microsoft AR - Leads Generados Mediaware (Enfasys)',
        'Microsoft AR - Webinars' => 'Microsoft AR - Webinars',
        'Microsoft AR - SureStep Programs' => 'Microsoft AR - SureStep Programs',
        'Microsoft AR – Prensa' => 'Microsoft AR – Prensa',
        'Microsoft AR – IT SITIO' => 'Microsoft AR – IT SITIO',
        'Microsoft AR – Corefone' => 'Microsoft AR – Corefone',
        'CO-MW-Assessment de Migración' => 'CO-MW-Assessment de Migración',
        'CO-MW-Incentivo venta para cierres MW' => 'CO-MW-Incentivo venta para cierres MW',
        'CO-MW-Incentivo ventas mensuales MW' => 'CO-MW-Incentivo ventas mensuales MW',
        'CO-MW-Incentivo primera Venta' => 'CO-MW-Incentivo primera Venta',
        'CO-MW-Capacitación Herramientas colaborativas' => 'CO-MW-Capacitación Herramientas colaborativas',
        'EC-MW-Incentivo venta para cierres MW' => 'EC-MW-Incentivo venta para cierres MW',
        'EC-MW-Incentivo ventas mensuales MW' => 'EC-MW-Incentivo ventas mensuales MW',
        'EC-MW-Incentivo primera Venta' => 'EC-MW-Incentivo primera Venta',
        'Atividades de Marketing' => 'Marketing Activities',
        'Microsoft – Evento CCE (FIESP)' => 'Microsoft – CCE Event (FIESP)',
        'Microsoft CCE - Comunicação ' => 'Microsoft CCE - Communication',
        'Nuvens Carregadas Opp' => 'Opp Storm Clouds',
        'Microsoft AR – Spinnel' => 'Microsoft AR – Spinnel',
        'Campanha de Captação | Canais Cloud' => 'Campanha de Captação | Canais Cloud',
        'Digital Campaign 7748' => 'Digital Campaign 7748',
        'Campaigns' => 'Campaigns',
        'Commercial Portfolio' => 'Commercial Portfolio',
        'Manufacturer' => 'Manufacturer',
        'Meetings' => 'Meetings'
      ],
      'type' => [
        '' => '',
        'Customer' => 'Customer',
        'Reseller' => 'Reseller',
        'ISV' => 'ISV',
        'Operadora/ISP' => 'Operator/ISP',
        'Fabricante' => 'Product Brand',
        'TD SYNNEX' => 'TD SYNNEX',
        'ISV / Startup Parceira TD SYNNEX' => 'ISV / Startup Parceira TD SYNNEX',
        'ISV / Startup não Parceira TD SYNNEX' => 'ISV / Startup não Parceira TD SYNNEX',
        'Revenda de TI Parceira TD SYNNEX' => 'Revenda de TI Parceira TD SYNNEX',
        'Revenda de TI não Parceira TD SYNNEX' => 'Revenda de TI não Parceira TD SYNNEX'
      ],
      'countryList' => [
        '' => '',
        'Argentina' => 'Argentina',
        'Brasil' => 'Brazil',
        'Caribe' => 'Caribe',
        'CALA' => 'CALA',
        'Centro' => 'Centro',
        'Colombia' => 'Colombia',
        'Chile' => 'Chile',
        'Ecuador' => 'Ecuador',
        'Perú' => 'Perú',
        'Mexico' => 'Mexico',
        'Dominican Republic' => 'Dominican Republic',
        'Bolivia' => 'Bolivia',
        'CCA' => 'CCA',
        'Peru' => 'Peru',
        'Paraguay' => 'Paraguay',
        'Uruguay' => 'Uruguay'
      ],
      'industria' => [
        'Aeroespacial' => 'Aerospace',
        'Agricultura' => 'Agriculture',
        'Agua' => 'Water',
        'Alimentación y bebidas' => 'Food and beverages',
        'Arquitectura' => 'Architecture',
        'Automotriz' => 'Automotive',
        'Banca' => 'Banking',
        'Bienes Raices' => 'Real estate',
        'Biotecnología' => 'Biotechnology',
        'Capital de Riesgo' => 'Venture Capital',
        'Comestibles' => 'Groceries',
        'Compra Total' => 'Purchasing',
        'Computación' => 'Computing',
        'Construcción' => 'Construction',
        'Consultando' => 'Consulting',
        'Creativo' => 'Creative',
        'Cuidado de la Salud' => 'Health Care',
        ' Cultura' => ' Cultura',
        'Defensa' => 'Defense',
        'Deportes' => 'Sports',
        'Educación' => 'Education',
        'Electrónicos' => 'Electronics',
        'Energía' => 'Energy',
        'Energía Eléctrica' => 'Electrical energy',
        'Entrega' => 'Delivery',
        'Entretenimiento y Ocio' => 'Entertainment and Leisure',
        ' Fabricación' => 'Manufacturing',
        ' Finanzas' => 'Finance',
        'Hospitalidad' => 'Hospitality',
        'Jurídico' => 'Legal',
        'Marketing' => 'Marketing',
        'Materiales de construcción y equipamiento' => 'Construction materials and equipment',
        'Medios masivos' => 'Mass media',
        'Menudeo' => 'Retail',
        'Minería' => 'Mining',
        ' Música' => 'Music',
        'Petróleo' => 'Petroleum',
        'Prueba, Inspección y Certificación' => 'Testing, Inspection and Certification',
        'Publicaciones' => 'Publications',
        'Publicidad' => 'Advertising',
        ' Química' => 'Chemistry',
        'Ropa y Accesorios' => 'Clothing and Accessories',
        'Seguros' => 'Insurance',
        'Servicios' => 'Services',
        'Software' => 'Software',
        'Soporte' => 'Support',
        'Tecnología' => 'Technology',
        'Telecomunicaciones' => 'Telecommunications',
        'Televisión' => 'Television',
        'Transporte' => 'Transport',
        'Viaje' => 'ViajeTransport',
        '' => ''
      ],
      'ciscoProjectWon' => [
        'Não' => 'No',
        'Sim' => 'Yes'
      ],
      'alreadyContacted' => [
        '' => '',
        'No' => 'No',
        'Si' => 'Yes',
        'En Curso' => 'In Progress'
      ],
      'conversionForecast' => [
        '' => 'Sem previsão',
        'Immediate' => 'Immediate',
        '1 Month' => '1 Month',
        '3 Months' => '3 Months',
        '6 Months' => '6 Months',
        '2 Months' => '2 Months',
        '4 Months' => '4 Months',
        '5 Months' => '5 Months'
      ],
      'edgeType' => [
        '' => '',
        'Infraestrutura' => 'Infraestructura',
        'Segurança' => 'Seguridad'
      ],
      'brandInfra' => [
        'AWS' => 'AWS',
        'IBM Cloud' => 'IBM Cloud',
        'Microsoft' => 'Microsoft'
      ],
      'brandsecurity' => [
        '' => '',
        'Arcserve' => 'Arcserve',
        'Bitglass' => 'Bitglass',
        'Check Point' => 'Check Point',
        'Cisco' => 'Cisco',
        'Commvault' => 'Commvault',
        'Fortinet ' => 'Fortinet ',
        'Veeam' => 'Veeam'
      ]
    ],
    'presetFilters' => [
      'active' => 'Activo',
      'actual' => 'Actuales',
      'converted' => 'Convertidos'
    ],
    'tooltips' => [
      'createSurestep' => 'This button allows the user to create data in the Surestep Entity. This also converts the Lead into a Contact and creates the Account in both entities. Please, make sure that this Contact or Account does not exist before continuing.

This action can not be undone.'
    ]
  ],
  'MassEmail' => [
    'fields' => [
      'name' => 'Nombre',
      'status' => 'Estado',
      'storeSentEmails' => 'Almacenar Correos Enviados',
      'startAt' => 'Fecha de Comienzo',
      'fromAddress' => 'De (Dirección)',
      'fromName' => 'De (Nombre)',
      'replyToAddress' => 'Responder a la dirección',
      'replyToName' => 'Responder al Nombre',
      'campaign' => 'Campaña',
      'emailTemplate' => 'Plantilla de Correo',
      'inboundEmail' => 'Cuenta de correo',
      'targetLists' => 'Lista de Intereses',
      'excludingTargetLists' => 'Listas de Intereses Excluídos',
      'optOutEntirely' => 'Confirmación Completada',
      'smtpAccount' => 'Cuenta SMTP'
    ],
    'links' => [
      'targetLists' => 'Listas de Intereses',
      'excludingTargetLists' => 'Listas de Intereses Excluídos',
      'queueItems' => 'Items en cola',
      'campaign' => 'Campaña',
      'emailTemplate' => 'Plantilla de Correo',
      'inboundEmail' => 'Cuenta de correo'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Borrador',
        'Pending' => 'Pendiente',
        'In Process' => 'En Proceso',
        'Complete' => 'Completado',
        'Canceled' => 'Cancelado',
        'Failed' => 'Falló'
      ]
    ],
    'labels' => [
      'Create MassEmail' => 'Crear correo masivo',
      'Send Test' => 'Enviar prueba',
      'System SMTP' => 'Sistema SMTP',
      'system' => 'sistema',
      'group' => 'grupo'
    ],
    'messages' => [
      'selectAtLeastOneTarget' => 'Seleccione al menos un interés',
      'testSent' => 'Correo(s) de prueba que se enviarán'
    ],
    'tooltips' => [
      'optOutEntirely' => 'Los correos de destinatarios que cancelaron su suscripción serán marcados como rechazados y ya no recibirán correos masivos.',
      'targetLists' => 'Los intereses que deben recibir los mensajes.',
      'excludingTargetLists' => 'Los intereses que no deben recibir mensajes.',
      'storeSentEmails' => 'Los correos se guardarán en el CRM.'
    ],
    'presetFilters' => [
      'actual' => 'Actual',
      'complete' => 'Completo'
    ]
  ],
  'Meeting' => [
    'fields' => [
      'name' => 'Nombre',
      'parent' => 'Padre',
      'status' => 'Estatus',
      'dateStart' => 'Fecha de Comienzo',
      'dateEnd' => 'Fecha de Finalización',
      'duration' => 'Duración',
      'description' => 'Descripción',
      'users' => 'Usuarios',
      'contacts' => 'Contactos',
      'leads' => 'Referencias',
      'reminders' => 'Recordatorios',
      'account' => 'Cuenta',
      'acceptanceStatus' => 'Estátus de aprobación',
      'dateStartDate' => 'Date Start (all day)',
      'dateEndDate' => 'Date End (all day)',
      'isAllDay' => 'Is All-Day',
      'sourceEmail' => 'Source Email',
      'uid' => 'UID',
      'joinUrl' => 'Join URL',
      'Acceptance' => 'Aceptación'
    ],
    'links' => [],
    'options' => [
      'status' => [
        'Planned' => 'Planeadas',
        'Held' => 'Retenida',
        'Not Held' => 'Pendiente'
      ],
      'acceptanceStatus' => [
        'None' => 'Ninguno',
        'Accepted' => 'Aprobado',
        'Declined' => 'Rechazado',
        'Tentative' => 'Tentativa'
      ]
    ],
    'massActions' => [
      'setHeld' => 'Marcar como Retenida',
      'setNotHeld' => 'Marcar como Pendiente'
    ],
    'labels' => [
      'Create Meeting' => 'Crear Presentación',
      'Set Held' => 'Marcar como Retenida',
      'Set Not Held' => 'Marcar como Pendiente',
      'Send Invitations' => 'Enviar Invitaciones',
      'Send Cancellation' => 'Send Cancellation',
      'on time' => 'a tiempo',
      'before' => 'antes',
      'All-Day' => 'All-Day',
      'Acceptance' => 'Acceptance'
    ],
    'presetFilters' => [
      'planned' => 'Planeadas',
      'held' => 'Retenidas',
      'todays' => 'De Hoy'
    ],
    'messages' => [
      'sendInvitationsToSelectedAttendees' => 'Invitation emails will be sent to the selected attendees.',
      'sendCancellationsToSelectedAttendees' => 'Cancellation emails will be sent to the selected attendees.',
      'selectAcceptanceStatus' => 'Set your acceptance status.',
      'nothingHasBeenSent' => 'No se ha enviado nada'
    ]
  ],
  'Opportunity' => [
    'fields' => [
      'name' => 'Nombre',
      'account' => 'Cuenta',
      'stage' => 'Etapa',
      'amount' => 'Valor',
      'probability' => 'Probabilidad, %',
      'leadSource' => 'Orígen de la Referencia',
      'doNotCall' => 'No Llamar',
      'closeDate' => 'Fecha de cierre',
      'contacts' => 'Contactos',
      'contact' => 'Contacto',
      'description' => 'Descripción',
      'amountConverted' => 'Valor (Convertido)',
      'amountWeightedConverted' => 'Valor Ponderada',
      'campaign' => 'Campaña',
      'originalLead' => 'Referencia original',
      'amountCurrency' => 'Importe en Moneda',
      'contactRole' => 'Rol del Contacto',
      'lastStage' => 'Última Etapa',
      'itemList' => 'Lista de Ítems',
      'priceBook' => 'Price Book',
      'licenseType' => 'Tipo de Licencia',
      'partnerResponsible' => 'Responsable del Canal',
      'customerType' => 'Tipo de Cliente',
      'productBrand' => 'Fabricante',
      'country' => 'País',
      'solutionType' => 'Facturación',
      'quarter' => 'Quarter',
      'endUser' => 'Cliente Final',
      'customer' => 'Cliente',
      'sources' => 'Fuente',
      'oppSource' => 'Origen',
      'dollarIBM' => 'Dólar IBM',
      'dollarIBMCurrency' => 'Dólar IBM (Currency)',
      'dollarIBMConverted' => 'Dólar IBM (Convertido)',
      'dollarCIS' => 'Dólar CIS',
      'dollarCISCurrency' => 'Dólar CIS (Currency)',
      'dollarCISConverted' => 'Dólar CIS (Converted)',
      'dollarAmount' => 'Total (USD)',
      'dollarAmountCurrency' => 'Total (Dólar) (Currency)',
      'dollarAmountConverted' => 'Total (Dólar) (Converted)',
      'dollarType' => 'Tipo de Dolar',
      'requests' => 'Pedidos',
      'technicalSupports' => 'Apoyo Técnico',
      'technicalSupport' => 'Apoyo Técnico',
      'techSupportDescription' => 'Descripcion (Apoio Técnico)',
      'endDate' => 'Fecha de Vencimiento de la Licencia',
      'accountEmail' => 'Email de la Cuenta',
      'lead' => 'Lead',
      'leadCountry' => 'Pais (Lead)',
      'leadEmail' => 'Email (Lead)',
      'googlePartnerAdvantage' => 'Google Partner Advantage',
      'externalId' => 'ExternalId',
      'region' => 'Region',
      'partnerGoogleCloud' => 'Canales - Google Cloud',
      'amountDiscount' => 'Valor con Descuento',
      'amountDiscountCurrency' => 'Valor con Descuento (Divisa)',
      'amountDiscountConverted' => 'Valor con Descuento (Convertido)',
      'partnersGoogleClouds' => 'Canales - Google Cloud',
      'partnersGoogleCloud' => 'Progreso del Canal',
      'partnerLevel' => 'Nivel del Canal',
      'products' => 'Productos',
      'statusSynced' => 'Estado Synced',
      'customerEmail' => 'Email del Cliente',
      'countryCustomer' => 'Pais del Cliente',
      'progresoPartner' => 'Progreso del Canal',
      'googleCalculator' => 'Link de calculadora de Google',
      'cdpOpportunityID' => 'Oportunidad ID (CDP)',
      'lostReason' => 'Motivo de cancelación',
      'amountproxconsumo' => 'Monto Aproximado de Consumo anual',
      'reason' => 'Razón de Cancelación',
      'externalIDcdp' => 'ExternalIDcdp',
      'cpb' => 'CPB',
      'submissionID' => 'Submission ID',
      'marketing' => 'Especifique el origen',
      'sourceNew' => 'Origen',
      'aws' => 'AWS - Partner Program',
      'emailEndUser' => 'Email del Cliente final',
      'paisDelClienteFinal' => 'Pais del Cliente final',
      'newcustomer' => 'Nuevo Cliente Final',
      'priceBooks' => 'Lista de Precios',
      'stageUpdateAWS' => 'Actualización de Etapa AWS',
      'connectedAreasStatus' => 'Status (Connected Areas)',
      'commercialTerms' => 'Condiciones Comerciales',
      'users' => 'VBA/BDR/BDM',
      'discountValue' => 'Valor de Descuento',
      'discountValueCurrency' => 'Valor de Descuento (Currency)',
      'discountValueConverted' => 'Valor de Descuento (Converted)',
      'billingContact' => 'Billing Contact',
      'addEndUser' => 'Añadir Cliente Final',
      'quoteDateReview' => 'Fecha de Revisión',
      'avisoItens' => 'Aviso',
      'quoteApprovalDate' => 'Quote Approval Date',
      'messengers' => 'Mensajería',
      'opportunityAWS' => 'Opportunity AWS',
      'useCase' => 'Use Case',
      'opportunityID' => 'Opportunity ID AWS',
      'aWSAccountID' => 'AWS Account ID',
      'sPMSID' => 'SPMS ID',
      'stageAWS' => 'Stage AWS',
      'statusAWS' => 'Status AWS',
      'partnerTypeAWS' => 'Partner Type',
      'segment' => 'Segment',
      'estimatedRevenue' => 'Estimated Monthly Revenue',
      'marketplace' => 'Marketplace',
      'cOpportunityGoogle' => 'Opportunity Google',
      'cNDealRegistration' => 'N° Deal Registration (Si aplica)',
      'cCategoryGoogle' => 'Category',
      'DR' => 'Deal Registration (DR)',
      'source' => 'Origen',
      'discountGoogle' => 'Descuento %',
      'quotePage' => 'Página de Cotización',
      'tipoDeProyectoGoogle' => 'Tipo de Oportunidad',
      'techSupportStatus' => 'Estado (Technical Support)'
    ],
    'links' => [
      'contacts' => 'Contactos',
      'contact' => 'Contact (Primary)',
      'documents' => 'Documentos',
      'campaign' => 'Campaña',
      'originalLead' => 'Referencia original',
      'quotes' => 'Cotizacion',
      'salesOrders' => 'Órdenes de Venta',
      'invoices' => 'Facturas',
      'items' => 'Items',
      'priceBook' => 'Price Book',
      'productBrand' => 'Product Brand',
      'customer' => 'Cliente',
      'sources' => 'Origen',
      'oppSource' => 'Origen',
      'technicalSupports' => 'Soportes Tecnicos',
      'technicalSupport' => 'Soporte Tecnico',
      'lead' => 'Lead',
      'googlePartnerAdvantage' => 'Google Partner Advantage',
      'regiones' => 'Region',
      'partnerGoogleCloud' => 'Canal - Google Cloud',
      'partnersGoogleClouds' => 'Canales - Google Cloud',
      'partnersGoogleCloud' => 'Canal - Google Cloud',
      'products' => 'Productos',
      'progresoPartner' => 'Progreso Canal',
      'cpb' => 'CPB',
      'marketing' => 'Seleccione la campaña',
      'aws' => 'AWS - Partner Program',
      'priceBooks' => 'Price Books',
      'users' => 'BDM User',
      'billingContact' => 'Billing Contact',
      'messengers' => 'Mensajeria',
      'opportunityAWS' => 'Opportunity AWS',
      'cOpportunityGoogle' => 'Opportunity Google',
      'account' => 'Cuenta'
    ],
    'options' => [
      'stage' => [
        'Prospecting' => 'Prospección',
        'Qualification' => 'Calificación',
        'Proposal' => 'Cotización con Propuesta',
        'Negotiation' => 'Negociación',
        'Needs Analysis' => 'Análisis de Necesidades',
        'Value Proposition' => 'Propuesta de Valor',
        'Id. Decision Makers' => 'Id. Tomadores de Decisiones',
        'Perception Analysis' => 'Análisis de la Percepción',
        'Proposal/Price Quote' => 'Cotización con Propuesta/Precio',
        'Negotiation/Review' => 'Negociación/Revisión',
        'Closed Won' => 'Cerrado Ganado',
        'Closed Lost' => 'Cerrado Perdido',
        'Opportunity Technical Feasibility' => 'Opportunity Technical Feasibility',
        'Opportunity Commercial Qualification' => 'Opportunity Commercial Qualification',
        'Implementation' => 'Implementacion',
        'Cancelada' => 'Cancelado',
        'Migration' => 'Migracion'
      ],
      'licenseType' => [
        '' => '',
        'CSP' => 'CSP',
        'Open' => 'Open',
        'AWS' => 'AWS',
        'Azure' => 'Azure',
        'M365' => 'M365 Mensual',
        'Renewal' => 'Renewal',
        'Services' => 'Servicios',
        'Dynamics 365' => 'Dynamics 365',
        'Software Subscription' => 'Software Subscription',
        'Software Perpetual' => 'Software Perpetual',
        'M365 Annual' => 'M365 Anual',
        'Modern Workplace' => 'Modern Workplace',
        'Azure IR' => 'Azure IR',
        'NCE' => 'NCE',
        'Open Value SA' => 'Open Value SA',
        'Open Value Subscription 1 Ano' => 'Open Value Subscription 1 Año',
        'Open Value Subscription 3 Anos' => 'Open Value Subscription 3 Años',
        'Open Value' => 'Open Value',
        'Open Value Perpetual' => 'Open Value Perpetual',
        'Renovações' => 'Renovaciones',
        'SPLA' => 'SPLA',
        'SW Perpetual' => 'SW Perpetual',
        'SW Subscription 1 Ano' => 'SW Subscription 1  Año',
        'SW Subscription 3 Anos' => 'SW Subscription 3  Años',
        'ESA' => 'ESA',
        'Marketplace' => 'Marketplace',
        'Pay As You Go' => 'Pay As You Go',
        'New Business' => 'New Business',
        'Upgrade' => 'Upgrade',
        'Google Cloud Platform' => 'Google Cloud Platform',
        'Google Workspace' => 'Google Workspace',
        'Commit - GCP' => 'Commit - GCP',
        'Commit - WS' => 'Commit - WS',
        'Google Workspace Starter' => 'Google Workspace Starter',
        'Google Workspace Business (1-300 Seats)' => 'Google Workspace Business (1-300 Seats)',
        'Google Workspace Essentials' => 'Google Workspace Essentials',
        'Google Workspace Standard' => 'Google Workspace Standard',
        'Google Workspace Plus' => 'Google Workspace Plus',
        'Google Workspace AppSheet' => 'Google Workspace AppSheet',
        'Cloud Identity' => 'Cloud Identity',
        'Google Vault' => 'Google Vault',
        'Google Voice' => 'Google Voice',
        'Google Workspace Business' => 'Google Workspace Business',
        'Google Workspace Enterprise' => 'Google Workspace Enterprise'
      ],
      'customerType' => [
        'Enterprise' => 'Enterprise',
        'ISV' => 'ISV',
        'SMB' => 'SMB',
        '' => '',
        'Public' => 'Public',
        'Corporate' => 'Corporativo',
        'Government' => 'Governo'
      ],
      'solutionType' => [
        '' => '',
        'Modern Workplace (Annual)' => 'Modern Workplace (Annual)',
        'Modern Workplace (Monthly)' => 'Modern Workplace (Monthly)',
        'Software (Perpetual)' => 'Software (Perpetual)',
        'Software (Subscription)' => 'Software (Subscription)',
        'Modern Workplace (3 Years)' => 'Modern Workplace (3 Years)',
        'Reserved Instances (1 Year)' => 'Reserved Instances (1 Year)',
        'Reserved Instances (3 Years)' => 'Reserved Instances (3 Years)',
        'Monthly' => 'Menusal',
        'Annual' => 'Anual - 1 Año',
        '3 Years' => '3 Años',
        'Perpetual' => 'Una vez',
        'Annual - 3 Years' => 'Anual - 3 Años',
        'One Time' => 'One Time',
        'Open Value Perpetual' => 'Open Value Perpetual',
        'Open Value Subscription 1 Year' => 'Open Value Subscription 1 Year',
        'Open Value Subscription 3 Years' => 'Open Value Subscription 3 Years',
        'SW Perpétuo' => 'SW Perpétuo',
        'SW Subscription 1 ano' => 'SW Subscription 1 ano',
        '2 Years' => '2 Años',
        'Annual - Monthly Payment' => 'Anual - Pago Mensual',
        'Flexible' => 'Flexible',
        'Trial' => 'Trial',
        'Pay as you go' => 'Pay as you go',
        'Upfront' => 'Upfront'
      ],
      'quarter' => [
        '' => '',
        'Q1' => 'Q1',
        'Q2' => 'Q2',
        'Q3' => 'Q3',
        'Q4' => 'Q4'
      ],
      'dollarType' => [
        '' => '',
        'Dólar CIS' => 'Dólar CIS',
        'Dólar IBM' => 'Dólar IBM'
      ],
      'requests' => [
        '' => '',
        'VBM Enterprise' => 'VBM Enterprise',
        'Cloud' => 'Cloud',
        'On Premise' => 'On Premise'
      ],
      'lostReason' => [
        '' => '',
        'Otro proveedor' => 'Otro proveedor',
        'Otro partner de Google' => 'Otro Partner de Google',
        'Tiempo de vigencia de propuestaPrecio' => 'Tiempo de vigencia de propuesta Precio',
        'Más adelante' => 'Más adelante',
        'Licitación perdida' => 'Licitación perdida',
        'Concorrente Tier 1' => 'Concorrente Tier 1',
        'Concorrente MOSP' => 'Concorrente MOSP',
        'Concorrente (Outro Distribuidor)' => 'Concorrente (Outro Distribuidor)',
        'Concorrente EA' => 'Concorrente EA',
        'Concorrente (Outro Fabricante)' => 'Concorrente (Outro Fabricante)',
        'WO' => 'WO',
        'Cadastro Reprovado' => 'Registro Reprobado',
        'Crédito Reprovado' => 'Crédito Reprovado',
        'Concorrente MPSA' => 'Concorrente MPSA',
        'Concorrente ESD' => 'Concorrente ESD',
        'Prazo de Pagamento' => 'Plazo de Pago',
        'Cliente final desistiu da compra' => 'Cliente final desistiu da compra',
        'Opp Duplicada' => 'Opp Duplicada',
        'Fechado com outro Revendedor' => 'Closed with another Reseller',
        'Sem retorno do Revendedor / Cliente final' => 'No return from Reseller / End Customer',
        'Contrato não efetivado (Stellr)' => 'Contract not executed (Stellr)',
        'Cancelada por falta de atualização interna' => 'Canceled due to lack of internal update'
      ],
      'reason' => [
        'O cliente não tinha um orçamento' => 'El cliente no tenía presupuesto',
        'Cliente/oportunidade muito pequena' => 'Cliente/Oportunidade Muy Pequeña',
        'O cliente não respondeu' => 'El cliente no respondió',
        'O cliente escolheu outro fornecedor' => 'El cliente eligió otro proveedor.',
        'Minha solução ou serviços não é um ajuste' => 'Mi solución o servicios no son adecuados',
        'Não é cliente' => 'No es Cliente',
        'Linha de tempo proposta muito curta' => 'Cronograma propuesto muy corto',
        'Relatar como abuso, phishing' => 'Relatar como abuso, phishing',
        'Outro' => 'Otro'
      ],
      'sourceNew' => [
        '' => '',
        'Campanhas' => 'Campañas',
        'Meetings' => 'Reuniones',
        'Carteira do BDM' => 'Carteira do BDM',
        'Fabricante' => 'Fabricante',
        'Carteira Comercial ' => 'Portafolio Comercial'
      ],
      'newcustomer' => [
        'New customer' => 'New End User '
      ],
      'connectedAreasStatus' => [
        '' => '',
        'Envolvido' => 'Envolvido',
        'Pendente' => 'Pendiente',
        'Respondido' => 'Respondido',
        'Aguardando Retorno' => 'Esperando respuesta',
        'BDM' => 'BDM',
        'Movimentação' => 'Movimentação',
        'N/A' => 'N/A'
      ],
      'source' => [
        '' => '',
        'Form | Google WorkSpace ' => 'Form | Google WorkSpace ',
        'Form | Google GCP' => 'Form | Google GCP',
        'Programa SMB Security ' => 'Programa SMB Security ',
        'Fortinet | Cloud for Enterprise' => 'Fortinet | Cloud for Enterprise',
        'Fortinet | BR Digital' => 'Fortinet | BR Digital',
        'Fortinet | Ger. Demanda Canais ' => 'Fortinet | Ger. Demanda Canais ',
        'Fortinet | Born in cloud' => 'Fortinet | Born in cloud',
        'Fortinet | DCIT' => 'Fortinet | DCIT',
        'Fortinet | NSB' => 'Fortinet | NSB',
        'Google Partner Advantage' => 'Google Partner Advantage',
        'Nuvens carregadas de Opp' => 'Nuvens carregadas de Opp',
        'MSFTPartnerCenter' => 'MSFTPartnerCenter',
        'Outro' => 'Otro',
        'Cloud Practice Builder ' => 'Cloud Practice Builder ',
        'AWS' => 'AWS',
        'Fortinet | Born in The Cloud' => 'Fortinet | Born in The Cloud',
        'Roadshow' => 'Roadshow'
      ],
      'baseMsft' => [
        '' => '',
        'Sim' => 'Si',
        'Não' => 'No'
      ],
      'renewal' => [
        '' => '',
        'Sim' => 'Si',
        'Não' => 'No'
      ],
      'tipoDeProyecto' => [
        '' => '',
        'ACR' => 'ACR',
        'CSP Anual' => 'CSP Anual',
        'CSP Mensual' => 'CSP Mensual',
        'CSP Perpetuo' => 'Perpetual CSP'
      ],
      'tipoDeProyectoGoogle' => [
        '' => '',
        'New Business' => 'New Business',
        'Upgrade de licencias' => 'Upgrade de licencias',
        'Renovación de Licencias' => 'Renovación de Licencias'
      ]
    ],
    'labels' => [
      'Create Opportunity' => 'Crear Oportunidad',
      'Items' => 'Items',
      'Select Product' => 'Selecionar Producto',
      'Add Item' => 'Adicionar item',
      'Add Products' => 'Add Products'
    ],
    'presetFilters' => [
      'open' => 'Abiertos',
      'won' => 'Ganados',
      'lost' => 'Perdido'
    ],
    'panels' => [
      'items' => 'Items'
    ],
    'tooltips' => [
      'discountValue' => '(PT-BR) \\nThe value entered must be zero or negative. If this value is not updated after saving the opportunity, please reload the page (Press F5). (Spanish) The value entered must be zero or negative. If this value is not updated after saving the opportunity, please Reload the page (Press F5).'
    ]
  ],
  'TargetList' => [
    'fields' => [
      'name' => 'Nombre',
      'description' => 'Descripción',
      'entryCount' => 'Contador de entradas',
      'optedOutCount' => 'Contador de Exclusiones',
      'campaigns' => 'Campañas',
      'endDate' => 'Fecha de Fin',
      'targetLists' => 'Listas de Intereses',
      'includingActionList' => 'Incluyendo',
      'excludingActionList' => 'Excluyendo',
      'targetStatus' => 'Status del Interés',
      'isOptedOut' => 'Se ha Excluido',
      'sourceCampaign' => 'Source Campaign',
      'syncWithReports' => 'Reports',
      'syncWithReportsEnabled' => 'Enabled',
      'syncWithReportsUnlink' => 'Unlink'
    ],
    'links' => [
      'accounts' => 'Cuentas',
      'contacts' => 'Contactos',
      'leads' => 'Referencias',
      'campaigns' => 'Campañas',
      'massEmails' => 'Correos Masivos',
      'syncWithReports' => 'Sync with Reports'
    ],
    'options' => [
      'type' => [
        'Email' => 'Correo electrónico',
        'Web' => 'Web',
        'Television' => 'Televisión',
        'Radio' => 'Radio',
        'Newsletter' => 'Newsletter'
      ],
      'targetStatus' => [
        'Opted Out' => 'Excluido',
        'Listed' => 'Listado'
      ]
    ],
    'labels' => [
      'Create TargetList' => 'Crear lista de Intereses',
      'Opted Out' => 'Rechazado',
      'Cancel Opt-Out' => 'Cancelar Confirmación',
      'Opt-Out' => 'Confirmar',
      'Sync with Reports' => 'Sync with Reports'
    ],
    'tooltips' => [
      'syncWithReportsEnabled' => 'Enable auto-sync with a list report.',
      'syncWithReportsUnlink' => 'Entries which are not contained in report results will be unlinked from Target List.',
      'syncWithReports' => 'Target List will be synced with results of selected reports.'
    ]
  ],
  'Task' => [
    'fields' => [
      'name' => 'Nombre',
      'parent' => 'Padre',
      'status' => 'Estado',
      'dateStart' => 'Fecha de Comienzo',
      'dateEnd' => 'Fecha de vencimiento',
      'dateStartDate' => 'Fecha de Inicio (todo el día)',
      'dateEndDate' => 'Fecha de fin (todo el día)',
      'priority' => 'Prioridad',
      'description' => 'Descripción',
      'isOverdue' => 'Atrasado',
      'account' => 'Cuenta',
      'dateCompleted' => 'Fecha de completado',
      'attachments' => 'Adjuntos',
      'reminders' => 'Recordatorios',
      'contact' => 'Contacto',
      'originalEmail' => 'Original Email',
      'emailUser' => 'Email del Usuario',
      'tarea' => 'Tarea',
      'productBrands' => 'Product Brand',
      'country' => 'Pais',
      'region' => 'Region',
      'fabricante' => 'Fabricante',
      'productBrand' => 'Fabricante',
      'tag' => 'Tag',
      'countryTask' => 'Country'
    ],
    'links' => [
      'attachments' => 'Adjuntos',
      'account' => 'Cuenta',
      'contact' => 'Contacto',
      'email' => 'Email',
      'productBrands' => 'Fabricantes',
      'fabricante' => 'Fabricante',
      'productBrand' => 'Fabricante'
    ],
    'options' => [
      'status' => [
        'Not Started' => 'Sin Empezar',
        'Started' => 'Comenzada',
        'Completed' => 'Completada',
        'Canceled' => 'Cancelada',
        'Deferred' => 'Diferida',
        'Recibida' => 'Recibida'
      ],
      'priority' => [
        'Low' => 'Baja',
        'Normal' => 'Normal',
        'High' => 'Alta',
        'Urgent' => 'Urgente'
      ],
      'tarea' => [
        1 => '1',
        '' => ''
      ],
      'tag' => [
        '' => '',
        'Ready for test' => 'Listo para probar',
        'Ready for deploy' => 'Listo para producción',
        'Stand-by' => 'En espera',
        'Blocked' => 'Bloqueado',
        'In Approval' => 'En aprovación',
        'Recurrent' => 'Recorrente'
      ],
      'countryTask' => [
        '' => '',
        'Brasil' => 'Brazil',
        'MCA' => 'MCA'
      ]
    ],
    'labels' => [
      'Create Task' => 'Crear Tarea',
      'Complete' => 'Completada',
      'overdue' => 'overdue'
    ],
    'presetFilters' => [
      'actual' => 'Actuales',
      'completed' => 'Completado',
      'deferred' => 'Diferida',
      'todays' => 'De Hoy',
      'overdue' => 'Atrazadas'
    ],
    'nameOptions' => [
      'replyToEmail' => 'Reply to email'
    ]
  ],
  'BpmnFlowNode' => [
    'labels' => [
      'Reset' => 'Reset'
    ],
    'fields' => [
      'status' => 'Status',
      'processedAt' => 'Processed At',
      'elementType' => 'Element Type',
      'element' => 'Element'
    ],
    'options' => [
      'status' => [
        'Created' => 'Created',
        'Pending' => 'Pending',
        'In Process' => 'In Process',
        'Standby' => 'Standby',
        'Processed' => 'Processed',
        'Rejected' => 'Rejected',
        'Failed' => 'Failed',
        'Interrupted' => 'Interrupted'
      ]
    ]
  ],
  'BpmnFlowchart' => [
    'labels' => [
      'Create BpmnFlowchart' => 'Create Flowchart',
      'Hand tool' => 'Hand tool',
      'Create Event tool' => 'Create Event tool',
      'Create Gateway tool' => 'Create Event tool',
      'Create Activity tool' => 'Create Activity tool',
      'Connect tool' => 'Connect tool',
      'Erase tool' => 'Erase tool',
      'Full Screen' => 'Full Screen',
      'Processes' => 'Processes',
      'data' => 'Data',
      'Zoom In' => 'Zoom In',
      'Zoom Out' => 'Zoom Out',
      'Error' => 'Error',
      'Events' => 'Events',
      'Activities' => 'Activities',
      'Gateways' => 'Gateways'
    ],
    'fields' => [
      'isActive' => 'Is Active',
      'targetType' => 'Target Entity Type',
      'data' => 'Data',
      'hasNoneStartEvent' => 'Has Start Event of None type'
    ],
    'links' => [
      'processes' => 'Processes'
    ],
    'elements' => [
      'eventStartConditional' => 'Conditional Start Event',
      'eventStartTimer' => 'Timer Start Event',
      'eventStartError' => 'Error Start Event',
      'eventStartEscalation' => 'Escalation Start Event',
      'eventStartSignal' => 'Signal Start Event',
      'eventStart' => 'Start Event',
      'eventStartCompensation' => 'Compensation Start Event',
      'eventStartConditionalEventSubProcess' => 'Sub-Process Conditional Start Event',
      'eventStartTimerEventSubProcess' => 'Sub-Process Timer Start Event',
      'eventStartSignalEventSubProcess' => 'Sub-Process Signal Start Event',
      'eventIntermediateTimerCatch' => 'Timer Intermediate Event (Catching)',
      'eventIntermediateConditionalCatch' => 'Conditional Intermediate Event (Catching)',
      'eventIntermediateEscalationThrow' => 'Escalation Intermediate Event (Throwing)',
      'eventIntermediateSignalThrow' => 'Signal Intermediate Event (Throwing)',
      'eventIntermediateCompensationThrow' => 'Compensation Intermediate Event (Throwing)',
      'eventIntermediateSignalCatch' => 'Signal Intermediate Event (Catching)',
      'eventIntermediateMessageCatch' => 'Message Intermediate Event (Catching)',
      'eventEnd' => 'End Event',
      'eventEndTerminate' => 'Terminate End Event',
      'eventEndError' => 'Error End Event',
      'eventEndEscalation' => 'Escalation End Event',
      'eventEndSignal' => 'Signal End Event',
      'eventEndCompensation' => 'Compensation End Event',
      'eventIntermediateErrorBoundary' => 'Error Intermediate Event (Boundary)',
      'eventIntermediateTimerBoundary' => 'Timer Intermediate Event (Boundary)',
      'eventIntermediateConditionalBoundary' => 'Conditional Intermediate Event (Boundary)',
      'eventIntermediateEscalationBoundary' => 'Escalation Intermediate Event (Boundary)',
      'eventIntermediateSignalBoundary' => 'Signal Intermediate Event (Boundary)',
      'eventIntermediateMessageBoundary' => 'Message Intermediate Event (Boundary)',
      'eventIntermediateCompensationBoundary' => 'Compensation Intermediate Event (Boundary)',
      'gatewayExclusive' => 'Exclusive Gateway',
      'gatewayInclusive' => 'Inclusive Gateway',
      'gatewayParallel' => 'Parallel Gateway',
      'gatewayEventBased' => 'Event Based Gateway',
      'taskSendMessage' => 'Send Message Task',
      'taskScript' => 'Script Task',
      'taskBusinessRule' => 'Business Rule Task',
      'taskUser' => 'User Task',
      'task' => 'Task',
      'callActivity' => 'Call Activity',
      'subProcess' => 'Sub-Process',
      'eventSubProcess' => 'Event Sub-Process',
      'flow' => 'Sequence Flow'
    ],
    'presetFilters' => [
      'isManuallyStartable' => 'Manually Startable',
      'activeHasNoneStartEvent' => 'Active w/ None Start Event',
      'active' => 'Active'
    ]
  ],
  'BpmnFlowchartElement' => [
    'fields' => [
      'text' => 'Text',
      'triggerType' => 'Trigger Type',
      'timer' => 'Timer Parameters',
      'defaultFlowId' => 'Default Flow',
      'from' => 'From',
      'to' => 'To',
      'replyTo' => 'Reply-To',
      'cc' => 'CC',
      'fromEmailAddress' => 'From Email Address',
      'toEmailAddress' => 'To Email Address',
      'replyToEmailAddress' => 'Reply-To Email Address',
      'ccEmailAddress' => 'CC Email Address',
      'toSpecifiedTeams' => 'To Teams',
      'toSpecifiedUsers' => 'To Users',
      'toSpecifiedContacts' => 'To Contacts',
      'attachmentsVariable' => 'Attachments Variable',
      'emailTemplate' => 'Email Template',
      'doNotStore' => 'Do not store sent email',
      'actions' => 'Actions',
      'formula' => 'Formula (script)',
      'actionType' => 'Action Type',
      'targetUser' => 'Target User',
      'assignmentType' => 'Assignment',
      'targetTeam' => 'Target Team',
      'targetUserPosition' => 'Target User Position',
      'startDirection' => 'Start Direction',
      'targetReport' => 'Target Report',
      'scheduling' => 'Scheduling',
      'schedulingApplyTimezone' => 'Apply timezone',
      'messageType' => 'Message Type',
      'canBeFailed' => 'Can be Failed',
      'target' => 'Target',
      'callableType' => 'Callable Type',
      'errorCode' => 'Error Code',
      'escalationCode' => 'Escalation Code',
      'cancelActivity' => 'Is Interrupting',
      'isInterrupting' => 'Is Interrupting',
      'targetType' => 'Target Entity Type',
      'flowchartVisualization' => 'Flowchart',
      'flowchart' => 'Flowchart',
      'signal' => 'Signal',
      'returnVariableList' => 'Return Variables',
      'returnCollectionVariable' => 'Return Collection Variable',
      'repliedTo' => 'Reply To',
      'relatedTo' => 'Related To',
      'instructions' => 'Instructions',
      'conditionsFormula' => 'Conditions Formula',
      'optOutLink' => 'Opt-Out Link',
      'isMultiInstance' => 'Multi-Instance',
      'isSequential' => 'Sequential',
      'loopCollectionExpression' => 'Collection Expression',
      'targetIdExpression' => 'Target ID Expression',
      'activityId' => 'Activity ID'
    ],
    'labels' => [
      'Conditions' => 'Conditions',
      'Actions' => 'Actions',
      'Field' => 'Field',
      'Flows Conditions' => 'Flows Conditions'
    ],
    'tooltips' => [
      'compensateActivityId' => 'An ID of an activity to compensate. If omitted, all completed compensable activities will be compensated.',
      'targetIdExpression' => 'The expression defining an ID of the target record.',
      'returnCollectionVariable' => 'Specify a variable name for data that will be returned from the multi-instance sub-process. The variable will contain an array of objects. Each object will contain return-variables of each sub-process instance.',
      'loopCollectionExpression' => 'The expression defining a list of values. Each value will instantiate a separate sub-process. The value will be available in the variable `$inputItem`.',
      'taskSendMessageEmailAddress' => 'Available placeholders:

* `{$$variable}`',
      'targetReport' => 'Records from the list report will be passed to the new process.',
      'target' => 'Select which record will be used as a target.',
      'userTaskName' => 'A name of User Task record that will be created.

Available placeholders:
* `{$attribute}`
* `{$$variable}`',
      'userTaskInstructions' => 'Instructions for a user. Markdown is supported.

Available placeholders:
* `{$attribute}`
* `{$$variable}`',
      'returnVariableList' => 'Specify formula variables that will be copied from the sub-process to the parent process once the sub-process successfully ends.',
      'scheduling' => 'Crontab notation. Defines frequency.

`*/5 * * * *` – every 5 minutes

`0 */2 * * *` – every 2 hours

`30 1 * * *` – at 01:30 once a day

`0 0 1 * *` – on the first day of the month',
      'schedulingApplyTimezone' => 'Apply the system default timezone to scheduling. Otherwise, UTC will be used.'
    ],
    'options' => [
      'emailAddress' => [
        'system' => 'System',
        'currentUser' => 'Current User',
        'specifiedEmailAddress' => 'Specified Email Address',
        'assignedUser' => 'Assigned User',
        'followers' => 'Followers',
        'specifiedContacts' => 'Specified Contacts',
        'specifiedUsers' => 'Specified Users',
        'specifiedTeams' => 'Specified Teams',
        'followersExcludingAssignedUser' => 'Followers excluding Assigned User',
        'processAssignedUser' => 'User assigned to Process',
        'targetEntity' => 'Target Record',
        '' => 'None'
      ],
      'triggerType' => [
        'afterRecordCreated' => 'After record created',
        'afterRecordSaved' => 'After record saved',
        'afterRecordUpdated' => 'After record updated',
        'sequential' => 'Sequential'
      ],
      'timerShiftOperator' => [
        'plus' => 'plus',
        'minus' => 'minus'
      ],
      'timerShiftUnits' => [
        'minutes' => 'minutes',
        'hours' => 'hours',
        'days' => 'days',
        'months' => 'months',
        'seconds' => 'seconds'
      ],
      'timerBase' => [
        'moment' => 'Moment when event triggered',
        'formula' => 'Calculated by formula'
      ],
      'actionType' => [
        'Approve' => 'Approve',
        'Review' => 'Review'
      ],
      'assignmentType' => [
        '' => 'None',
        'processAssignedUser' => 'User assigned to Process',
        'specifiedUser' => 'Specified User',
        'rule:Round-Robin' => 'Round-Robin',
        'rule:Least-Busy' => 'Least-Busy'
      ],
      'startDirection' => [
        '' => 'Auto',
        'r' => 'Right',
        'd' => 'Down',
        'u' => 'Up',
        'l' => 'Left'
      ],
      'messageType' => [
        'Email' => 'Email'
      ]
    ]
  ],
  'BpmnProcess' => [
    'labels' => [
      'Create BpmnProcess' => 'Start Process',
      'Stop Process' => 'Stop Process',
      'User Tasks' => 'User Tasks',
      'Flowcharts' => 'Flowcharts',
      'Interrupt' => 'Interrupt',
      'Reject' => 'Reject',
      'Start flow from here' => 'Start flow from here',
      'Reactivate' => 'Reactivate',
      'View Variables' => 'View Variables',
      'View Error' => 'View Error',
      'Error Message' => 'Error Message'
    ],
    'fields' => [
      'status' => 'Status',
      'targetType' => 'Target Entity Type',
      'target' => 'Target',
      'createdEntitiesData' => 'Created Entities Data',
      'flowchartData' => 'Flowchart Data',
      'flowchart' => 'Flowchart',
      'flowchartVisualization' => 'Flowchart (visualization)',
      'flowchartElementsDataHash' => 'Flowchart Elements',
      'variables' => 'Variables',
      'endedAt' => 'Ended At',
      'startElementId' => 'Start Element',
      'workflowId' => 'Workflow ID',
      'parentProcess' => 'Parent Process',
      'parentProcessFlowNode' => 'Parent Process Flow Node',
      'rootProcess' => 'Root Process'
    ],
    'links' => [
      'flowchart' => 'Flowchart',
      'target' => 'Target',
      'flowNodes' => 'Flow Log',
      'userTasks' => 'Process User Tasks',
      'childProcesses' => 'Child Processes',
      'parentProcess' => 'Parent Process',
      'parentProcessFlowNode' => 'Parent Process Flow Node',
      'rootProcess' => 'Root Process'
    ],
    'options' => [
      'status' => [
        'Created' => 'Created',
        'Started' => 'Started',
        'Ended' => 'Ended',
        'Paused' => 'Paused',
        'Stopped' => 'Stopped',
        'Interrupted' => 'Interrupted'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Active',
      'ended' => 'Ended'
    ]
  ],
  'BpmnUserTask' => [
    'labels' => [
      'Resolve' => 'Resolve'
    ],
    'fields' => [
      'actionType' => 'Action Type',
      'resolution' => 'Resolution',
      'target' => 'Target',
      'process' => 'Process',
      'isResolved' => 'Is Resolved',
      'resolutionNote' => 'Resolution Note',
      'instructions' => 'Instructions',
      'isCanceled' => 'Is Canceled'
    ],
    'links' => [
      'process' => 'Process',
      'target' => 'Target',
      'flowNode' => 'Flow Node'
    ],
    'options' => [
      'actionType' => [
        'Approve' => 'Approve',
        'Review' => 'Review',
        'Accomplish' => 'Accomplish'
      ],
      'resolution' => [
        '' => 'None',
        'Approved' => 'Approved',
        'Rejected' => 'Rejected',
        'Reviewed' => 'Reviewed',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'resolved' => 'Resolved',
      'canceled' => 'Canceled'
    ]
  ],
  'Report' => [
    'labels' => [
      'Create Report' => 'Create Report',
      'Run' => 'Run',
      'Total' => 'Total',
      'Group Total' => 'Group Total',
      '-Empty-' => '-Empty-',
      'Parameters' => 'Parameters',
      'Filters' => 'Filters',
      'Chart' => 'Chart',
      'List Report' => 'List Report',
      'Grid Report' => 'Grid Report',
      'days' => 'days',
      'never' => 'never',
      'Get Csv' => 'Get Csv',
      'EmailSending' => 'Email Sending',
      'View Report' => 'View Report',
      'Report' => 'Report',
      'AND' => 'AND',
      'OR' => 'OR',
      'NOT' => 'NOT IN',
      'IN' => 'IN',
      'Complex expression' => 'Complex expression',
      'Having' => 'Having',
      'Add AND group' => 'Add AND group',
      'Add OR group' => 'Add OR group',
      'Add NOT group' => 'Add NOT group',
      'Add IN group' => 'Add IN group',
      'Add Having group' => 'Add Having group',
      'Add Complex expression' => 'Add Complex expression',
      'Columns' => 'Columns',
      'Send Email' => 'Send Email',
      'Results View' => 'Results View',
      'Create Joint Grid Report' => 'Create Joint Grid Report',
      'Label' => 'Label',
      'Type' => 'Type',
      'Decimal Places' => 'Decimal Places'
    ],
    'fields' => [
      'type' => 'Type',
      'entityType' => 'Entity Type',
      'description' => 'Description',
      'groupBy' => 'Group by',
      'columns' => 'Columns',
      'orderBy' => 'Order by',
      'filters' => 'Filters',
      'runtimeFilters' => 'Runtime Filters',
      'chartType' => 'Chart Type',
      'emailSendingInterval' => 'Interval',
      'emailSendingTime' => 'Time',
      'emailSendingUsers' => 'Users',
      'emailSendingSettingDay' => 'Day',
      'emailSendingSettingMonth' => 'Month',
      'emailSendingSettingWeekdays' => 'Days',
      'emailSendingDoNotSendEmptyReport' => 'Don\'t send if report is empty',
      'chartColorList' => 'Colors',
      'chartColor' => 'Color',
      'chartOneColumns' => 'Chart Columns',
      'chartOneY2Columns' => 'Chart Secondary Axis Columns',
      'orderByList' => 'List Order',
      'column' => 'Column',
      'exportFormat' => 'Format',
      'category' => 'Category',
      'applyAcl' => 'Apply ACL',
      'portals' => 'Portals',
      'joinedReports' => 'Sub-Reports',
      'joinedReportLabel' => 'Sub-Report Label',
      'filtersDataList' => 'Filters Data List',
      'columnsData' => 'Columns Data',
      'filtersData' => 'Filters Data',
      'accounts' => 'Accounts'
    ],
    'tooltips' => [
      'emailSendingUsers' => 'Users report result will be sent to',
      'chartColorList' => 'Custom colors for specific groups.',
      'applyAcl' => 'Report results will depend on the user\'s access.',
      'groupBy' => 'Data will be aggregated by one or two groups. If empty, then data will not be aggregated, only totals will be displayed.

[Complex expressions](https://www.espocrm.com/documentation/user-guide/complex-expressions/) can be used.',
      'columns' => 'What data to display. 

[Complex expressions](https://www.espocrm.com/documentation/user-guide/complex-expressions/) can be used.',
      'runtimeFilters' => 'Additional filters that will be available on the report view.',
      'portals' => 'Report will be available only in specified portals.'
    ],
    'functions' => [
      'COUNT' => 'Count',
      'SUM' => 'Sum',
      'AVG' => 'Avg',
      'MIN' => 'Min',
      'MAX' => 'Max',
      'YEAR' => 'Year',
      'QUARTER' => 'Quarter',
      'MONTH' => 'Month',
      'DAY' => 'Day',
      'WEEK' => 'Week',
      'YEAR_FISCAL' => 'Fiscal Year',
      'QUARTER_FISCAL' => 'Fiscal Quarter'
    ],
    'orders' => [
      'ASC' => 'ASC',
      'DESC' => 'DESC',
      'LIST' => 'LIST'
    ],
    'options' => [
      'dashletDisplayType' => [
        '' => '',
        'Chart' => 'Chart',
        'List' => 'List',
        'Chart-Total' => 'Chart & Total',
        'Total' => 'Total',
        'Table' => 'Table'
      ],
      'chartType' => [
        'BarHorizontal' => 'Bar (horizontal)',
        'BarVertical' => 'Bar (vertical)',
        'BarGroupedHorizontal' => 'Bar Grouped (horizontal)',
        'BarGroupedVertical' => 'Bar Grouped (vertical)',
        'Pie' => 'Pie',
        'Line' => 'Line',
        'Radar' => 'Radar'
      ],
      'emailSendingInterval' => [
        '' => 'None',
        'Daily' => 'Daily',
        'Weekly' => 'Weekly',
        'Monthly' => 'Monthly',
        'Yearly' => 'Yearly'
      ],
      'emailSendingSettingDay' => [
        32 => 'Last day of month'
      ],
      'type' => [
        'Grid' => 'Grid',
        'List' => 'List',
        'JointGrid' => 'Joint Grid'
      ],
      'function' => [
        '' => 'No Function',
        'custom' => 'Expression',
        'customWithOperator' => 'Expression w/ Operator',
        'DATE_NUMBER' => 'DATE',
        'MONTH_NUMBER' => 'MONTH',
        'YEAR_NUMBER' => 'YEAR',
        'QUARTER_NUMBER' => 'QUARTER',
        'DAYOFWEEK_NUMBER' => 'DAYOFWEEK',
        'HOUR_NUMBER' => 'HOUR',
        'MINUTE_NUMBER' => 'MINUTE',
        'LOWER' => 'LOWER',
        'UPPER' => 'UPPER',
        'TRIM' => 'TRIM',
        'LENGTH' => 'LENGTH',
        'WEEK_NUMBER_0' => 'WEEK (Sunday)',
        'WEEK_NUMBER_1' => 'WEEK (Monday)',
        'COUNT' => 'COUNT',
        'SUM' => 'SUM',
        'AVG' => 'AVG',
        'MAX' => 'MAX',
        'MIN' => 'MIN'
      ],
      'operator' => [
        'equals' => 'Equals',
        'notEquals' => 'Not Equals',
        'greaterThan' => 'Greater Than',
        'lessThan' => 'Less Than',
        'greaterThanOrEquals' => 'Greater Than or Equals',
        'lessThanOrEquals' => 'Less Than or Equals',
        'in' => 'In',
        'notIn' => 'Not In',
        'isTrue' => 'Is True',
        'isFalse' => 'Is False',
        'isNull' => 'Is Null',
        'isNotNull' => 'Is Not Null',
        'like' => 'Like'
      ],
      'exportFormat' => [
        'csv' => 'CSV',
        'xlsx' => 'XLSX (Excel)'
      ],
      'layoutAlign' => [
        'left' => 'Left',
        'right' => 'Right'
      ],
      'columnType' => [
        '' => 'Auto',
        'Summary' => 'Summary'
      ]
    ],
    'messages' => [
      'emailTemplateParsingError' => 'Error while parsing template `{template}`.',
      'executionError' => 'Could not run the report. Check the report parameters. Find more details in the log file.',
      'emptyStringGroupExcluded' => 'A group with an empty string value is excluded from the results.',
      'notAllowedFormulaInFilter' => 'Formula expression in filters contains a not allowed function.',
      'validateMaxCount' => 'Count should not be greater than {maxCount}',
      'havingFilterWithoutGroupByError' => 'Having filter can\'t be used without Group-By.',
      'gridReportDescription' => 'Group by one or two columns and see summations. Can be displayed as a chart.',
      'listReportDescription' => 'Simple list of records which meet filters criteria.',
      'invalidColumnError' => 'Invalid column name. Check the report parameters.',
      'sqlSyntaxError' => 'Could not compose a valid SQL from report parameters.',
      'onlyFullGroupByError' => 'Unsupported report parameters. Either change parameters or disable `ONLY_FULL_GROUP_BY` SQL mode in the database config.'
    ],
    'presetFilters' => [
      'list' => 'List',
      'grid' => 'Grid',
      'listTargets' => 'List (Targets)',
      'listAccounts' => 'List (Accounts)',
      'listContacts' => 'List (Contacts)',
      'listLeads' => 'List (Leads)',
      'listUsers' => 'List (Users)'
    ],
    'errorMessages' => [
      'error' => 'Error',
      'noChart' => 'No chart selected for the report.',
      'selectReport' => 'Select a report in the dashlet options.'
    ],
    'filtersGroupTypes' => [
      'or' => 'OR',
      'and' => 'AND',
      'not' => 'NOT IN',
      'subQueryIn' => 'IN',
      'having' => 'Having'
    ],
    'layoutFields' => [
      'link' => 'Link',
      'width' => 'Width',
      'notSortable' => 'Not Sortable',
      'exportOnly' => 'Export Only',
      'align' => 'Align'
    ],
    'links' => [
      'accounts' => 'Accounts'
    ]
  ],
  'ReportCategory' => [
    'labels' => [
      'Create ReportCategory' => 'Create Category',
      'Manage Categories' => 'Manage Categories',
      'Reports' => 'Reports'
    ],
    'fields' => [
      'order' => 'Order'
    ],
    'links' => [
      'reports' => 'Reports'
    ]
  ],
  'ReportFilter' => [
    'labels' => [
      'Create ReportFilter' => 'Create Filter',
      'Rebuild Filters' => 'Rebuild Filters'
    ],
    'fields' => [
      'order' => 'Order',
      'report' => 'Report',
      'entityType' => 'Entity Type',
      'isActive' => 'Is Enabled'
    ],
    'links' => [
      'report' => 'Report'
    ],
    'tooltips' => [
      'teams' => 'Teams the filter will be available for. If no teams specified then no restriction by team will be applied.',
      'report' => 'List Report that will be used for the filter.'
    ]
  ],
  'ReportPanel' => [
    'labels' => [
      'Create ReportPanel' => 'Create Panel',
      'Rebuild Panels' => 'Rebuild Panels'
    ],
    'fields' => [
      'report' => 'Report',
      'entityType' => 'Entity Type',
      'isActive' => 'Is Enabled',
      'type' => 'Type',
      'reportType' => 'Report Type',
      'displayTotal' => 'Display Total',
      'displayOnlyTotal' => 'Display Only Total',
      'column' => 'Column',
      'reportEntityType' => 'Report Entity Type',
      'columnList' => 'Column List',
      'dynamicLogicVisible' => 'Conditions making panel visible',
      'order' => 'Order',
      'displayType' => 'What to display',
      'useSiMultiplier' => 'SI Multiplier'
    ],
    'links' => [
      'report' => 'Report'
    ],
    'tooltips' => [
      'teams' => 'Teams the panel will be displayed for. If no teams specified then no restriction by team will be applied.',
      'report' => 'Report that will be used for the panel.',
      'order' => '[0..1] - before Stream panel;
[3..4] - before relationship panels;
[6..] - after relationship panels.'
    ],
    'options' => [
      'type' => [
        'side' => 'Side',
        'bottom' => 'Bottom'
      ]
    ]
  ],
  'Workflow' => [
    'fields' => [
      'Name' => 'Name',
      'entityType' => 'Target Entity',
      'type' => 'Trigger Type',
      'isActive' => 'Active',
      'description' => 'Description',
      'usersToMakeToFollow' => 'Users to make to follow the record',
      'whatToFollow' => 'What to follow',
      'portalOnly' => 'Portal Only',
      'portal' => 'Portal',
      'targetReport' => 'Target Report',
      'scheduling' => 'Scheduling',
      'schedulingApplyTimezone' => 'Apply timezone',
      'methodName' => 'Service Method',
      'assignmentRule' => 'Assignment Rule',
      'targetTeam' => 'Target Team',
      'targetUserPosition' => 'Target User Position',
      'listReport' => 'List Report',
      'linkList' => 'Link with Target Entity through relationships',
      'linkListShort' => 'Links',
      'target' => 'Target',
      'whoFollow' => 'Who make to follow',
      'signalName' => 'Signal',
      'requestType' => 'Request Type',
      'requestUrl' => 'URL',
      'requestContentType' => 'Content Type',
      'requestContent' => 'Payload',
      'requestContentVariable' => 'Payload from variable',
      'optOutLink' => 'Opt-Out Link',
      'headers' => 'Headers',
      'manualLabel' => 'Manual Label',
      'manualDynamicLogic' => 'Manual Dynamic-Logic',
      'manualTeams' => 'Manual Teams',
      'manualAccessRequired' => 'Manual Access Required',
      'manualElementType' => 'Manual Element Type',
      'manualElementTypeInForm' => 'Element Type',
      'manualLabelInForm' => 'Label',
      'manualAccessRequiredInForm' => 'Access Required',
      'manualTeamsInForm' => 'For Teams',
      'manualDynamicLogicInForm' => 'Conditions',
      'manualConfirmation' => 'Manual Confirmation',
      'manualConfirmationInForm' => 'Confirmation Dialog',
      'manualConfirmationText' => 'Manual Confirmation Text',
      'manualConfirmationTextInForm' => 'Confirmation Text',
      'manualStyle' => 'Manual Button Style',
      'manualStyleInForm' => 'Button Style',
      'category' => 'Category',
      'conditionsAll' => 'Conditions All',
      'conditionsAny' => 'Conditions Any',
      'conditionsFormula' => 'Conditions Formula',
      'actions' => 'Actions',
      'processOrder' => 'Process Order',
      'attachmentsVariable' => 'Attachments Variable'
    ],
    'links' => [
      'portal' => 'Portal',
      'targetReport' => 'Target Report',
      'workflowLogRecords' => 'Log',
      'category' => 'Category'
    ],
    'tooltips' => [
      'processOrder' => 'Multiple workflow rules for the same target will be processed according their order. The lower the order value, the sooner a rule runs.',
      'manualConfirmation' => 'To display a confirmation dialog before running the workflow.',
      'manualConfirmationText' => 'A text to show to a user when confirming workflow start.',
      'schedulingApplyTimezone' => 'Apply the system default timezone to scheduling. Otherwise, UTC will be used.',
      'manualDynamicLogic' => 'Conditions making the workflow available for a record.',
      'manualTeams' => 'Teams who will have access to run the workflow. If empty, only admin will have access.',
      'manualAccessRequired' => 'Access to a record required to be able run the workflow.',
      'manualLabel' => 'A UI element label text.',
      'requestUrl' => 'Available placeholders:
* `{$attribute}`
* `{$$variable}`',
      'requestHeaders' => 'Additional headers.

Format:
```key: value```

Available placeholders:
* `{$attribute}`
* `{$$variable}`
* `{#secrets.name}`',
      'requestContent' => 'In JSON format.

Available placeholders:
* `{$attribute}`
* `{$$variable}`',
      'requestContentVariable' => 'A variable name. If specified, payload will be taken from the variable.',
      'portalOnly' => 'If checked workflow will be triggered only in portal.',
      'portal' => 'Specific portal where workflow will be triggered. Leave empty if you need it to work in any portal.',
      'scheduling' => 'Crontab notation. Defines frequency of workflow rule runs.

`*/5 * * * *` – every 5 minutes

`0 */2 * * *` – every 2 hours

`30 1 * * *` – at 01:30 once a day

`0 0 1 * *` – on the first day of the month'
    ],
    'labels' => [
      'Create Workflow' => 'Create Rule',
      'General' => 'General',
      'Manual Trigger' => 'Manual Trigger',
      'Conditions' => 'Conditions',
      'Actions' => 'Actions',
      'All' => 'All',
      'Any' => 'Any',
      'Formula' => 'Formula',
      'Email Address' => 'Email Address',
      'Email Template' => 'Email Template',
      'From' => 'From',
      'To' => 'To',
      'immediately' => 'Immediately',
      'Reply-To' => 'Reply-To',
      'CC' => 'CC',
      'later' => 'Later',
      'today' => 'today',
      'plus' => 'plus',
      'minus' => 'minus',
      'days' => 'days',
      'hours' => 'hours',
      'months' => 'months',
      'minutes' => 'minutes',
      'Link' => 'Link',
      'Add Field' => 'Add Field',
      'equals' => 'equals',
      'wasEqual' => 'was equal',
      'notEquals' => 'not equals',
      'wasNotEqual' => 'was not equal',
      'changed' => 'changed',
      'notChanged' => 'not changed',
      'notEmpty' => 'not empty',
      'isEmpty' => 'empty',
      'value' => 'value',
      'field' => 'field',
      'true' => 'true',
      'false' => 'false',
      'greaterThan' => 'greater than',
      'lessThan' => 'less than',
      'greaterThanOrEquals' => 'greater than or equals',
      'lessThanOrEquals' => 'less than or equals',
      'between' => 'between',
      'on' => 'on',
      'before' => 'before',
      'after' => 'after',
      'beforeToday' => 'before today',
      'afterToday' => 'after today',
      'recipient' => 'Recipient',
      'has' => 'has',
      'notHas' => 'not has',
      'contains' => 'contains',
      'notContains' => 'not contains',
      'messageTemplate' => 'Message Template',
      'users' => 'Users',
      'Target Entity' => 'Target Entity',
      'Current' => 'Current',
      'Workflow' => 'Workflow',
      'Workflows Log' => 'Workflows Log',
      'methodName' => 'Service Method',
      'additionalParameters' => 'Additional Parameters (JSON format)',
      'doNotStore' => 'Do not store sent email',
      'Related' => 'Related',
      'Entity Type' => 'Entity Type',
      'Workflow Rule' => 'Workflow Rule',
      'Add Condition' => 'Add Condition',
      'Add Action' => 'Add Action',
      'Created' => 'Created',
      'Field' => 'Field',
      'Entity' => 'Entity',
      'Process' => 'Process'
    ],
    'emailAddressOptions' => [
      '' => 'None',
      'currentUser' => 'Current user',
      'specifiedEmailAddress' => 'Specified email address',
      'assignedUser' => 'Assigned user',
      'targetEntity' => 'Target record',
      'specifiedUsers' => 'Specified users',
      'specifiedContacts' => 'Specified contacts',
      'teamUsers' => 'Users of teams related to target record',
      'followers' => 'Followers of target record',
      'followersExcludingAssignedUser' => 'Followers excluding assigned user',
      'specifiedTeams' => 'Users of specified teams',
      'system' => 'System',
      'fromOrReplyTo' => 'From/Reply-To address'
    ],
    'options' => [
      'type' => [
        'afterRecordSaved' => 'After record saved (created or updated)',
        'afterRecordCreated' => 'After record created',
        'afterRecordUpdated' => 'After record updated',
        'manual' => 'Manual',
        'scheduled' => 'Scheduled',
        'sequential' => 'Sequential',
        'signal' => 'Signal'
      ],
      'subjectType' => [
        'value' => 'value',
        'field' => 'field',
        'today' => 'today/now',
        'typeOf' => 'type of'
      ],
      'assignmentRule' => [
        'Round-Robin' => 'Round-Robin',
        'Least-Busy' => 'Least-Busy'
      ],
      'manualAccessRequired' => [
        'read' => 'read',
        'edit' => 'edit',
        'admin' => 'admin'
      ],
      'manualElementType' => [
        'Button' => 'Button',
        'Dropdown-Item' => 'Dropdown Item'
      ]
    ],
    'actionTypes' => [
      'sendEmail' => 'Send Email',
      'createEntity' => 'Create Record',
      'createRelatedEntity' => 'Create Related Record',
      'updateEntity' => 'Update Target Record',
      'updateRelatedEntity' => 'Update Related Record',
      'relateWithEntity' => 'Link with Another Record',
      'unrelateFromEntity' => 'Unlink from Another Record',
      'makeFollowed' => 'Make Followed',
      'createNotification' => 'Create Notification',
      'triggerWorkflow' => 'Trigger Another Workflow Rule',
      'runService' => 'Run Service Action',
      'applyAssignmentRule' => 'Apply Assignment Rule',
      'updateCreatedEntity' => 'Update Created Record',
      'updateProcessEntity' => 'Update Process Record',
      'startBpmnProcess' => 'Start BPM Process',
      'sendRequest' => 'Send HTTP Request',
      'executeFormula' => 'Execute Formula Script'
    ],
    'texts' => [
      'allMustBeMet' => 'All must be met',
      'atLeastOneMustBeMet' => 'At least one must be met',
      'formulaInfo' => 'Conditions of any complexity in espo-formula language'
    ],
    'messages' => [
      'jsonInvalid' => 'Is not valid JSON.',
      'loopNotice' => 'Be careful about a possible looping through two or more workflow rules continuously.',
      'messageTemplateHelpText' => 'Available placeholders:

* `{entity}` – target record
* `{user}` – current user
* `{$$variable}` – formula variable'
    ],
    'serviceActions' => [
      'sendEventInvitations' => 'Send Invitations',
      'addQuoteItemList' => 'Add Quote Items',
      'addInvoiceItemList' => 'Add Invoice Items',
      'addSalesOrderItemList' => 'Add Sales Order Items',
      'convertCurrency' => 'Convert Currency',
      'sendInEmail' => 'Send In Email',
      'optOut' => 'Opt-out',
      'generateAndSendPassword' => 'Generate Password'
    ],
    'serviceActionsHelp' => [
      'generateAndSendPassword' => 'A new password will be generated and sent to the user\'s email address.',
      'optOut' => 'Optional parameter: targetListId. If not specified, then marks an email address opted-out.

 Example:
```{"targetListId": "TARGET_LIST_ID"}```',
      'convertCurrency' => 'Optional parameter: targetCurrency. If not specified, then it will convert to the default currency.',
      'sendInEmail' => 'Parameters:
* templateId - ID of PDF template
* emailTemplateId - ID of email template
* to - recipient (optional parameter); by default will be sent to billing contact or account; example: `link:account.assignedUser`

Example:

```{
    "templateId": "TEMPLATE_ID",
    "emailTemplateId": "EMAIL_TEMPLATE_ID",
    "to": "link:billingContact"
}```',
      'addQuoteItemList' => 'Example: 

```{
  "itemList": [
     {
      "quantity": 1, "procuctId": "productId", "name": "Product Name", "listPrice": 100, "unitPrice": 100
     }
  ]
}```',
      'addInvoiceItemList' => 'Example: 

```{
  "itemList": [
     {
      "quantity": 1, "procuctId": "productId", "name": "Product Name", "listPrice": 100, "unitPrice": 100
     }
  ]
}```',
      'addSalesOrderItemList' => 'Example: 

```{
  "itemList": [
     {
      "quantity": 1, "procuctId": "productId", "name": "Product Name", "listPrice": 100, "unitPrice": 100
     }
  ]
}```'
    ],
    'presetFilters' => [
      'active' => 'Active'
    ]
  ],
  'WorkflowCategory' => [
    'labels' => [
      'Create WorkflowCategory' => 'Create Category'
    ],
    'fields' => [
      'order' => 'Order'
    ],
    'links' => [
      'workflows' => 'Workflows'
    ]
  ],
  'WorkflowLogRecord' => [
    'labels' => [],
    'fields' => [
      'target' => 'Target',
      'workflow' => 'Workflow'
    ]
  ],
  'DeliveryOrder' => [
    'labels' => [
      'Create DeliveryOrder' => 'Create Delivery Order',
      'Add Item' => 'Add Item',
      'Items' => 'Items',
      'Valid' => 'Valid',
      'Invalid' => 'Invalid',
      'Show Availability' => 'Show Availability',
      'Availability' => 'Availability',
      'Total' => 'Total'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'account' => 'Account',
      'salesOrder' => 'Sales Order',
      'shippingAddress' => 'Shipping Address',
      'shippingContact' => 'Shipping Contact',
      'shippingCost' => 'Shipping Cost',
      'amount' => 'Amount',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'amountCurrency' => 'Amount Currency',
      'shippingProvider' => 'Shipping Provider',
      'taxAmount' => 'Tax Amount',
      'itemList' => 'Item List',
      'dateOrdered' => 'Date Ordered',
      'shippingDate' => 'Shipping Date',
      'deliveryDate' => 'Delivery Date',
      'weight' => 'Weight',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'currency' => 'Currency',
      'inventoryData' => 'Inventory Data',
      'inventoryStatus' => 'Inventory Status',
      'warehouse' => 'Warehouse',
      'isDone' => 'Is Done'
    ],
    'links' => [
      'items' => 'Items',
      'shippingContact' => 'Shipping Contact',
      'shippingProvider' => 'Shipping Provider',
      'salesOrder' => 'Sales Order',
      'account' => 'Account',
      'tax' => 'Tax',
      'inventoryTransactions' => 'Inventory Transactions',
      'warehouse' => 'Warehouse'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Ready' => 'Ready',
        'In Progress' => 'In Progress',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled',
        'Failed' => 'Failed'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ],
    'messages' => [
      'inventoryIsInAdjustment' => 'Can\'t save as inventory is currently in a started adjustment.',
      'notAvailableInventory' => 'Not enough inventory is available.',
      'notAvailableInventoryStatusChanged' => 'Not enough inventory is available. Cannot change the status.'
    ],
    'texts' => [
      'itemTooMany' => '{number} extra needs to be removed.',
      'itemTooFew' => '{number} more needs to be added.'
    ]
  ],
  'DeliveryOrderItem' => [
    'fields' => [
      'name' => 'Name',
      'qty' => 'Qty',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'product' => 'Product',
      'order' => 'Line Number',
      'deliveryOrder' => 'Delivery Order',
      'weight' => 'Weight',
      'unitWeight' => 'Unit Weight',
      'description' => 'Description',
      'account' => 'Account',
      'deliveryOrderStatus' => 'Delivery Order Status',
      'inventoryNumber' => 'Inventory Number',
      'inventoryNumberType' => 'Inventory Number Type',
      'isInventory' => 'Is Inventory'
    ],
    'links' => [
      'deliveryOrder' => 'Delivery Order',
      'product' => 'Product',
      'account' => 'Account',
      'inventoryNumber' => 'Inventory Number'
    ]
  ],
  'InventoryAdjustment' => [
    'labels' => [
      'Create InventoryAdjustment' => 'Create Adjustment',
      'Add Item' => 'Add Item',
      'Items' => 'Items'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'amount' => 'Amount',
      'itemList' => 'Item List',
      'date' => 'Date',
      'reason' => 'Reason',
      'warehouse' => 'Warehouse',
      'isDone' => 'Is Done',
      'doneAt' => 'Done At'
    ],
    'links' => [
      'items' => 'Items',
      'inventoryTransactions' => 'Inventory Transactions',
      'warehouse' => 'Warehouse'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Started' => 'Started',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled'
      ],
      'reason' => [
        'Stocktaking' => 'Stocktaking',
        'Write-off' => 'Write-off',
        'Waste' => 'Waste',
        'Shrinkage' => 'Shrinkage',
        'Damage' => 'Damage',
        'Internal' => 'Internal'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ],
    'messages' => [
      'itemProductIsNotInventory' => 'Product {name} is not inventory.',
      'emptyNewQuantityInItem' => 'On-hand quantity is not specified for an item.',
      'sameItemsInAnotherAdjustment' => 'The same items are in another started adjustment.',
      'duplicateItems' => 'Can\'t have the same items in an adjustment.'
    ]
  ],
  'InventoryAdjustmentItem' => [
    'fields' => [
      'name' => 'Name',
      'newQtyOnHand' => 'On-Hand Qty',
      'qty' => 'Adjusted',
      'newQuantityOnHand' => 'New On-Hand Quantity ',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'product' => 'Product',
      'order' => 'Line Number',
      'inventoryAdjustment' => 'Adjustment',
      'description' => 'Description',
      'inventoryAdjustmentStatus' => 'Inventory Adjustment Status',
      'inventoryNumber' => 'Inventory Number',
      'inventoryNumberType' => 'Inventory Number Type',
      'isInventory' => 'Is Inventory',
      'warehouse' => 'Warehouse'
    ],
    'links' => [
      'inventoryAdjustment' => 'Adjustment',
      'product' => 'Product',
      'inventoryNumber' => 'Inventory Number'
    ],
    'presetFilters' => [
      'completed' => 'Completed'
    ]
  ],
  'InventoryNumber' => [
    'labels' => [
      'Create InventoryNumber' => 'Create Number',
      'Quantity' => 'Quantity',
      'Warehouses' => 'Warehouses',
      'Inventory History' => 'Inventory History',
      'View History' => 'View History',
      'Received' => 'Received',
      'Shipped' => 'Shipped'
    ],
    'fields' => [
      'type' => 'Type',
      'product' => 'Product',
      'quantityOnHand' => 'On Hand',
      'quantityReserved' => 'Reserved',
      'quantityInTransit' => 'In Transit',
      'incomingDate' => 'Incoming Date',
      'productionDate' => 'Production Date',
      'expirationDate' => 'Expiration Date',
      'warehousesOnHand' => 'Warehouses (On Hand)',
      'deleteId' => 'Delete ID',
      'number' => 'Internal Number',
      'orderFifo' => 'Order FIFO',
      'orderFefo' => 'Order FEFO',
      'orderLifo' => 'Order LIFO',
      'quantityWarehouseOnHand' => 'On Hand in Warehouse',
      'quantityWarehouseReserved' => 'Reserved in Warehouse'
    ],
    'links' => [
      'product' => 'Product',
      'inventoryTransactions' => 'Inventory Transactions'
    ],
    'presetFilters' => [
      'onHand' => 'On Hand',
      'notOnHand' => 'Not On Hand'
    ],
    'messages' => [
      'alreadyExists' => 'The same inventory number already exists.'
    ]
  ],
  'InventoryTransaction' => [
    'labels' => [
      'Create InventoryTransaction' => 'Create Transaction'
    ],
    'fields' => [
      'number' => 'Number',
      'type' => 'Type',
      'parent' => 'Parent',
      'quantity' => 'Quantity',
      'product' => 'Product',
      'warehouse' => 'Warehouse',
      'inventoryNumber' => 'Inventory Number'
    ],
    'links' => [
      'parent' => 'Parent',
      'product' => 'Product',
      'warehouse' => 'Warehouse',
      'inventoryNumber' => 'Inventory Number'
    ],
    'options' => [
      'type' => [
        'Transfer' => 'Transfer',
        'Reserve' => 'Reserve',
        'Soft Reserve' => 'Soft Reserve'
      ]
    ]
  ],
  'Invoice' => [
    'labels' => [
      'Create Invoice' => 'Create Invoice',
      'Taxes' => 'Taxes',
      'Shipping Providers' => 'Shipping Providers',
      'Add Item' => 'Add Item',
      'Templates' => 'Templates',
      'Items' => 'Items',
      'Invoice Items' => 'Invoice Items',
      'E-Invoice' => 'E-Invoice',
      'Validate' => 'Validate'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'account' => 'Account',
      'opportunity' => 'Opportunity',
      'quote' => 'Quote',
      'salesOrder' => 'Sales Order',
      'billingAddress' => 'Billing Address',
      'shippingAddress' => 'Shipping Address',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'tax' => 'Tax',
      'taxRate' => 'Tax Rate',
      'shippingCost' => 'Shipping Cost',
      'shippingProvider' => 'Shipping Provider',
      'taxAmount' => 'Tax Amount',
      'discountAmount' => 'Discount Amount',
      'amount' => 'Amount',
      'preDiscountedAmount' => 'Pre-Discount Amount',
      'grandTotalAmount' => 'Grand Total Amount',
      'itemList' => 'Item List',
      'dateInvoiced' => 'Date Invoiced',
      'dateDue' => 'Due Date',
      'weight' => 'Weight',
      'amountConverted' => 'Amount (converted)',
      'taxAmountConverted' => 'Tax Amount (converted)',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'preDiscountedAmountConverted' => 'Pre-Discount Amount (converted)',
      'discountAmountConverted' => 'Discount Amount (converted)',
      'grandTotalAmountConverted' => 'Grand Total Amount (converted)',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'taxAmountCurrency' => 'Tax Amount Currency',
      'discountAmountCurrency' => 'Discount Amount Currency',
      'amountCurrency' => 'Amount Currency',
      'preDiscountedAmountCurrency' => 'Pre-Discount Amount Currency',
      'grandTotalAmountCurrency' => 'Grand Total Amount Currency',
      'currency' => 'Currency',
      'priceBook' => 'Price Book',
      'buyerReference' => 'Buyer Reference'
    ],
    'links' => [
      'items' => 'Items',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'shippingProvider' => 'Shipping Provider',
      'opportunity' => 'Opportunity',
      'account' => 'Account',
      'tax' => 'Tax',
      'quote' => 'Quote',
      'salesOrder' => 'Sales Order',
      'priceBook' => 'Price Book'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Sent' => 'Sent',
        'In Review' => 'In Review',
        'Confirmed' => 'Confirmed',
        'Paid' => 'Paid',
        'Rejected' => 'Rejected',
        'Canceled' => 'Canceled'
      ],
      'eInvoiceFormats' => [
        'CiusRo' => 'CIUS-RO e-Factura',
        'CiusIt' => 'CIUS-IT',
        'CiusAtGov' => 'CIUS-AT-GOV',
        'CiusAtNat' => 'CIUS-AT-NAT',
        'Peppol' => 'PEPPOL BIS Billing 3.0',
        'CiusEsFace' => 'CIUS-ES-FACE',
        'Nlcius' => 'NLCIUS',
        'XRechnung' => 'XRechnung'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'paid' => 'Paid'
    ],
    'messages' => [
      'invoiceIsValid' => 'Invoice is valid',
      'ublRuleValidationFailure' => 'Invalid invoice.

Failed rule ID: `{ruleId}`

{message}'
    ],
    'eInvoiceFields' => [
      'eInvoiceFormat' => 'E-Invoice Format',
      'format' => 'Format'
    ]
  ],
  'InvoiceItem' => [
    'fields' => [
      'name' => 'Nombre',
      'qty' => 'Cantidad',
      'quantity' => 'Cantidad',
      'quantityInt' => 'Cantidad(Int)',
      'listPrice' => 'Precio de lista',
      'unitPrice' => 'Precio unitario',
      'amount' => 'Valor',
      'taxRate' => 'Tax Rate',
      'product' => 'Producto',
      'order' => 'Número de Línea',
      'invoice' => 'Factura',
      'weight' => 'Peso',
      'unitWeight' => 'Unidad de Peso',
      'description' => 'Descripcion',
      'discount' => 'Descuento (%)',
      'amountConverted' => 'Valor (Convertido)',
      'unitPriceConverted' => 'Precio Unitario (Convertido)',
      'listPriceConverted' => 'Precio de lista (Convertido)',
      'account' => 'Cuenta',
      'listPriceCurrency' => 'Precio de lista (Divisa)',
      'unitPriceCurrency' => 'Precio Unitario Divisa',
      'amountCurrency' => 'Valor Divisa',
      'invoiceStatus' => 'Estado de la Factura'
    ],
    'links' => [
      'invoice' => 'Factura',
      'product' => 'Producto',
      'account' => 'Cuenta'
    ],
    'labels' => [
      'Invoices' => 'Facturas',
      'Create InvoiceItem' => 'Crear Iten de Facturas'
    ]
  ],
  'OpportunityItem' => [
    'fields' => [
      'name' => 'Nombre',
      'qty' => 'Cant.',
      'quantity' => 'Cant.',
      'quantityInt' => 'Cantidad (Int)',
      'unitPrice' => 'Valor Ajustado',
      'amount' => 'Valor Total',
      'amountCurrency' => 'Valor (Divisa)',
      'unitPriceCurrency' => 'Valor Ajustado (Divisa)',
      'product' => 'Producto',
      'order' => 'Número de Línea',
      'opportunity' => 'Opportunidad',
      'description' => 'Descripcion',
      'discount' => 'Descuento (%)',
      'amountConverted' => 'Valor (Convertido)',
      'unitPriceConverted' => 'Valor Ajustado (Convertido)',
      'listPrice' => 'List Price',
      'listPriceConverted' => 'List Price (Converted)',
      'listPriceCurrency' => 'List Price (Currency)',
      'opportunityStage' => 'Etapa',
      'licenseType' => 'Tipo de Licencia',
      'services' => 'Oportunidad de Servicios',
      'brand' => 'Marca',
      'timeContract' => 'Tiempo de Contrato',
      'productBrand' => 'Marca del producto',
      'amountDiscountItem' => 'Valor con descuento',
      'amountDiscountItemCurrency' => 'Unit Discounted (Currency)',
      'amountDiscountItemConverted' => 'Unit Discounted (Converted)',
      'contractType' => 'Tipo de contrato',
      'region' => 'Region',
      'priceBooks' => 'Lista de Precios',
      'update' => 'Reprocess',
      'editAmount' => 'Edit Value',
      'margin' => 'Margin',
      'productSKU' => 'SKU',
      'cSolutionType' => 'Facturación',
      'cItem1' => 'Item1',
      'solutionType' => 'Facturación',
      'cLicenseTypeGoogle' => 'License Type',
      'cLicenseTypeAWS' => 'License Type AWS',
      'categoryType' => 'Tipo de categoría'
    ],
    'links' => [
      'opportunity' => 'Opportunidad',
      'product' => 'Producto',
      'services' => 'Oportunidad de Servicios',
      'productBrand' => 'Marca del producto',
      'priceBooks' => 'Lista de Precios'
    ],
    'labels' => [
      'Opportunities' => 'Oportunidades',
      'Create OpportunityItem' => 'Crear - Item de Oportunidad'
    ],
    'options' => [
      'licenseType' => [
        '' => '',
        'Azure' => 'Azure',
        'Microsoft 365 - Montlhy' => 'Microsoft 365 - Mensual',
        'Microsoft 365 - Annual' => 'Microsoft 365 - Anual',
        'Dynamics 365' => 'Dynamics 365',
        'Software Subscription' => 'Software Subscription',
        'Software Perpetual' => 'Software Perpetual',
        'CSP' => 'CSP',
        'AWS' => 'AWS',
        'NCE' => 'NCE',
        'Azure IR' => 'Azure IR',
        'Open' => 'Open',
        'Open Value Perpetual' => 'Open Value Perpetual',
        'Open Valeu SA' => 'Open Value SA',
        'Open Valeu Subscription 1 Ano' => 'Open Value Subscription 1 Año',
        'Open Valeu Subscription 3 Anos' => 'Open Value Subscription 3 Años',
        'SW Perpetual' => 'SW Perpetual',
        'SW Subscription 1 Ano' => 'SW Subscription 1 Ano',
        'SW Subscription 3 Anos' => 'SW Subscription 3 Anos',
        'ESA' => 'ESA',
        'Marketplace' => 'Marketplace',
        'Subscription' => 'Subscription',
        'Google Cloud Platform' => 'Google Cloud Platform',
        'Google Workspace' => 'Google Workspace',
        'New Business' => 'New Business',
        'Renewal' => 'Renewal',
        'Upgrade' => 'Upgrade',
        'M365' => 'M365',
        'Services' => 'Services',
        'Open Value ' => 'Open Value ',
        'D365' => 'D365',
        'Power Platform' => 'Power Platform',
        'Open Value Subscription' => 'Open Value Subscription',
        'OVS-ES' => 'OVS-ES',
        'School' => 'School',
        'O365/M365' => 'O365/M365'
      ],
      'brand' => [
        'Google' => 'Google',
        'Microsoft' => 'Microsoft',
        'IBM' => 'IBM',
        'Cisco' => 'Cisco',
        'AWS' => 'AWS',
        '' => ''
      ],
      'timeContract' => [
        '' => '',
        '1 Month' => '1 Mes',
        '1 Year' => '1 Año',
        '2 Years' => '2 Años',
        '3 Years' => '3 Años',
        'Perpetual' => 'Perpetual',
        'Pay as you go' => 'Pay as you go',
        '1 month' => '1 Mes'
      ],
      'contractType' => [
        '' => '',
        'Open' => 'Open',
        'SPLA' => 'SPLA',
        'Services Pofesionals' => 'Services Pofesionals',
        'CSP' => 'CSP',
        'Professional Services' => 'Professional Services',
        'NCE' => 'NCE',
        'CSP NCE' => 'CSP NCE',
        'Open Value' => 'Open Value'
      ],
      'region' => [
        '' => '',
        'BRA' => 'BRA',
        'MCA' => 'MCA'
      ],
      'cSolutionType' => [
        '' => '',
        'Monthly' => 'Monthly',
        'Annual' => 'Annual',
        'Flexible' => 'Flexible',
        'Pay as you go' => 'Pay as you go',
        'Trial version' => 'Trial version',
        'One time' => 'One time'
      ],
      'solutionType' => [
        '' => '',
        'Flexible' => 'Flexível',
        'Pay as you go' => 'Pay as you go',
        'Trial version' => 'Trial version',
        'onetime' => 'One Time',
        'annually' => 'Anual',
        'monthly' => 'Mensal',
        'Monthly' => 'Monthly',
        'Annual' => 'Annual'
      ],
      'cLicenseTypeGoogle' => [
        '' => '',
        'New Business' => 'New Business',
        'Renewal' => 'Renewal',
        'Upgrade' => 'Upgrade'
      ],
      'cLicenseTypeAWS' => [
        '' => '',
        'AWS' => 'AWS'
      ]
    ]
  ],
  'PriceBook' => [
    'labels' => [
      'Create PriceBook' => 'Crear Lista de Precios'
    ],
    'fields' => [
      'parentPriceBook' => 'Parent Price Book',
      'status' => 'Status',
      'country' => 'País',
      'opportunity' => 'Oportunidad',
      'opportunityItem' => 'Oportunidad Item',
      'product' => 'Producto',
      'unitPrice' => 'Precio unitario',
      'unitPriceCurrency' => 'UnitPrice (Currency)',
      'unitPriceConverted' => 'UnitPrice (Converted)',
      'countryLabel' => 'Etiqueta de País',
      'productUnitPrice' => 'ProductUnitPrice',
      'productUnitPriceCurrency' => 'ProductUnitPrice (Moeda)',
      'productUnitPriceConverted' => 'ProductUnitPrice (Convertido)',
      'modifiedBy' => 'Modificado por'
    ],
    'links' => [
      'products' => 'Products',
      'parentPriceBook' => 'Parent Price Book',
      'accounts' => 'Accounts',
      'prices' => 'Prices',
      'rules' => 'Rules',
      'childPriceBooks' => 'Child Price Books',
      'country' => 'País',
      'opportunity' => 'Oportunidad',
      'opportunityItem' => 'Oportunidad Item',
      'product' => 'Producto',
      'modifiedBy' => 'Modificado por'
    ],
    'presetFilters' => [
      'active' => 'Active'
    ],
    'options' => [
      'status' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ]
    ]
  ],
  'PriceRule' => [
    'labels' => [
      'Create PriceRule' => 'Create Rule'
    ],
    'fields' => [
      'priceBook' => 'Price Book',
      'status' => 'Status',
      'productCategory' => 'Product Category',
      'minQuantity' => 'Min. Quantity',
      'price' => 'Price',
      'dateStart' => 'Date Start',
      'dateEnd' => 'Date End',
      'minQty' => 'Min. Qty',
      'percentage' => 'Percentage',
      'discount' => 'Discount',
      'target' => 'Target',
      'condition' => 'Condition',
      'conditionSelect' => 'Condition Select',
      'roundingMethod' => 'Rounding Method',
      'roundingFactor' => 'Rounding Factor',
      'surcharge' => 'Surcharge',
      'currency' => 'Currency',
      'basedOn' => 'Based On',
      'supplier' => 'Supplier'
    ],
    'links' => [
      'supplier' => 'Supplier',
      'productCategory' => 'Product Category',
      'condition' => 'Condition',
      'priceBook' => 'Price Book',
      'product' => 'Product'
    ],
    'options' => [
      'status' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ],
      'basedOn' => [
        'Unit' => 'Unit',
        'Price Book' => 'Price Book',
        'Supplier' => 'Supplier',
        'Cost' => 'Cost'
      ],
      'basedOnShort' => [
        'Unit' => 'U',
        'Price Book' => 'PB',
        'Supplier' => 'S',
        'Cost' => 'C'
      ],
      'target' => [
        'All' => 'All',
        'Product Category' => 'Product Category',
        'Conditional' => 'Conditional'
      ],
      'percentageType' => [
        'Discount' => 'Discount',
        'Markup' => 'Markup'
      ],
      'roundingFactor' => [
        'Half Up' => 'Half Up',
        'Up' => 'Up',
        'Down' => 'Down'
      ]
    ],
    'tooltips' => [
      'minQuantity' => 'The rule will be applied only if the quantity of items being sold exceeds the specified value.',
      'currency' => 'The amount will be converted to the specified currency before rounding. Also defines the currency of the surcharge.',
      'basedOn' => 'What to use as a base price.

* Unit – the unit price defined in the Price Book or defined in the Product record; Price Book rules are not applied;
* Price Book – is obtained from the same Price Book; rules are applied;
* Supplier – the price of the Supplier;
* Cost – the cost specified in the Product record.',
      'surcharge' => 'An amount to add after percentage and rounding are applied. Use a negative number to subtract.',
      'roundingFactor' => 'The amount will be round off to the multiple of the specified value.',
      'percentage' => 'A percentage of the standard price to deduct or add.'
    ],
    'presetFilters' => [
      'active' => 'Active'
    ]
  ],
  'PriceRuleCondition' => [
    'labels' => [
      'Create PriceRuleCondition' => 'Create Condition'
    ],
    'fields' => [
      'condition' => 'Condition'
    ],
    'tooltips' => [
      'condition' => 'A formula expression. Should return true or false.'
    ]
  ],
  'Product' => [
    'labels' => [
      'Create Product' => 'Crear Producto',
      'Price' => 'Precio',
      'Brands' => 'Fabricantes',
      'Categories' => 'Categorias',
      'Price Books' => 'Price Books',
      'Quantity' => 'Quantity',
      'Warehouses' => 'Warehouses',
      'Generate' => 'Generate',
      'Orders' => 'Orders',
      'Select Variant' => 'Select Variant',
      'Select Variants' => 'Select Variants',
      'Select Template' => 'Select Template',
      'View Price' => 'View Price'
    ],
    'fields' => [
      'status' => 'Estados',
      'brand' => 'Fabricante',
      'partNumber' => 'Número de parte',
      'category' => 'Categoria',
      'pricingType' => 'Tipo de Factor',
      'pricingFactor' => 'Factor de precio',
      'costPrice' => 'Precio de coste',
      'listPrice' => 'Precio de lista',
      'unitPrice' => 'Precio unitario',
      'costPriceCurrency' => 'Precio de coste Divisa',
      'listPriceCurrency' => 'Precio de lista Divisa',
      'unitPriceCurrency' => 'Precio unitario Divisa',
      'costPriceConverted' => 'Precio de coste (Convertido)',
      'listPriceConverted' => 'Precio de lista (Convertido)',
      'unitPriceConverted' => 'Precio unitario (Convertido)',
      'url' => 'URL',
      'isTaxFree' => 'Libre de impuestos',
      'weight' => 'Peso',
      'suppliers' => 'Suppliers',
      'unitPriceSelect' => 'Unit Price (Select)',
      'unitPriceSelectCurrency' => 'Unit Price (Select) (Currency)',
      'allowFractionalQuantity' => 'Allow Fractional Quantity',
      'quantity' => 'Available',
      'quantityReserved' => 'Reserved',
      'quantitySoftReserved' => 'Soft-Reserved',
      'quantityOnHand' => 'On Hand',
      'quantityInTransit' => 'In Transit',
      'quantityOnOrder' => 'On Order',
      'quantityWarehouse' => 'Available in Warehouse',
      'quantityWarehouseOnHand' => 'On Hand in Warehouse',
      'quantityWarehouseReserved' => 'Reserved in Warehouse',
      'qty' => 'Qty',
      'isInventory' => 'Is Inventory',
      'inventoryNumberType' => 'Inventory Number Type',
      'warehousesOnHand' => 'Warehouses (On Hand)',
      'type' => 'Type',
      'template' => 'Template',
      'attributes' => 'Attributes',
      'variantAttributeOptions' => 'Attribute Values',
      'variantOrder' => 'Variant Order',
      'expirationDays' => 'Expiration Days',
      'removalStrategy' => 'Removal Strategy',
      'ciscoArchitecture' => 'Arquitectura (Cisco)',
      'sku' => 'SKU#',
      'offerModel' => 'Modelo de oferta',
      'enduserType' => 'Usuario final (Tipo)',
      'billingType' => 'Modelo de facturación',
      'subCategory' => 'Subcategoria',
      'partNumberDescription' => 'Número de parte (Descripcion)',
      'categoryType' => 'Tipo de Categoria',
      'opportunitiesProduct' => 'Oportunidades de productos',
      'opportunitys' => 'Oportunidad',
      'isnewcommerce' => 'Es nuevo comercio',
      'billingCycle' => 'Ciclo de facturación',
      'offerID' => 'OfferID',
      'formID' => 'FormID',
      'skuID' => 'SkuID',
      'identityID' => 'IdentityID',
      'lastUpdate' => 'Última actualización',
      'duration' => 'Duración',
      'region' => 'Region',
      'instanceKey' => 'Clave de instancia',
      'isReservedInstances' => 'Son instancias reservadas',
      'culture' => 'Culture',
      'bestSeller' => 'Más vendido',
      'licenseType' => 'Tipo de licencia',
      'timeContract' => 'Tiempo del contrato',
      'termDuration' => 'Duración del término',
      'priceBooks' => 'Libros de precios',
      'sku2' => 'SKU#2',
      'sku3' => 'SKU#3',
      'productCategory' => 'Categoría de producto',
      'update' => 'Actualizar'
    ],
    'links' => [
      'brand' => 'Fabricantes',
      'category' => 'Categoria',
      'prices' => 'Prices',
      'supplierPrices' => 'Supplier Prices',
      'inventoryNumbers' => 'Inventory Numbers',
      'inventoryTransactions' => 'Inventory Transactions',
      'attributes' => 'Attributes',
      'attributeOptions' => 'Attribute Options',
      'variantAttributeOptions' => 'Variant Attribute Options',
      'template' => 'Template',
      'variants' => 'Variants',
      'variantInventoryNumbers' => 'Variant Inventory Numbers',
      'inventoryAdjustmentItems' => 'Adjustments',
      'opportunitiesProduct' => 'Oportunidades de productos',
      'opportunitys' => 'Oportunidades',
      'priceBooks' => 'Libros de precios'
    ],
    'options' => [
      'pricingType' => [
        'Same as List' => 'Same as List',
        'Fixed' => 'Fixed',
        'Discount from List' => 'Descuento de la lista',
        'Markup over Cost' => 'Markup over Cost',
        'Profit Margin' => 'Profit Margin'
      ],
      'inventoryNumberType' => [
        'Batch' => 'Batch',
        'Serial' => 'Serial'
      ],
      'type' => [
        'Regular' => 'Regular',
        'Template' => 'Template',
        'Variant' => 'Variant'
      ],
      'removalStrategy' => [
        'FIFO' => 'FIFO',
        'FEFO' => 'FEFO',
        'LIFO' => 'LIFO'
      ],
      'ciscoArchitecture' => [
        '' => '',
        'Collab' => 'Collab',
        'Data Center' => 'Data Center',
        'Enterprise' => 'Enterprise',
        'Meraki' => 'Meraki',
        'Security' => 'Security'
      ],
      'enduserType' => [
        '' => '',
        'Charity' => 'Charity',
        'Educational' => 'Educational',
        'Corporate' => 'Corporate',
        'Commercial' => 'Commercial'
      ],
      'billingType' => [
        '' => '',
        'Anual (Pagamento Anual)' => 'Anual (Pago Anual)',
        'Anual (Pagamento Mensal)' => 'Anual (Pago Mensal)',
        'Anual (Pagamento Upfront)' => 'Anual (Pago Upfront)',
        'Mensal' => 'Mensual',
        'One Time' => 'One Time',
        'Trianual (Pagamento Upfront)' => 'Trianual (Pago Upfront)',
        'Único' => 'Único',
        'Upfront' => 'Upfront',
        'License' => 'License'
      ],
      'subCategory' => [
        '' => '',
        'Access' => 'Access',
        'BizTalk Server' => 'BizTalk Server',
        'Excel' => 'Excel',
        'Exchange Server' => 'Exchange Server',
        'Office' => 'Office',
        'Outlook' => 'Outlook',
        'PowerPoint' => 'PowerPoint',
        'Project' => 'Project',
        'Publisher' => 'Publisher',
        'SharePoint' => 'SharePoint',
        'Skype for Business Server' => 'Skype for Business Server',
        'SQL Server' => 'SQL Server',
        'Visio' => 'Visio',
        'Visual Studio' => 'Visual Studio',
        'Windows' => 'Windows',
        'Windows GGWA' => 'Windows GGWA',
        'Windows Server' => 'Windows Server',
        'Word' => 'Word',
        'Azure SQL Edge' => 'Azure SQL Edge',
        'Power Platform' => 'Power Platform',
        'Connectivity & Sharing' => 'Connectivity & Sharing',
        'Windows Server 2022' => 'Windows Server 2022',
        'Windows 7 Extended Security' => 'Windows 7 Extended Security',
        'Productivity & End user computing' => 'Productivity & End User Computing'
      ],
      'categoryType' => [
        '' => '',
        'O365/M365' => 'O365/M365',
        'D365/Power Platform' => 'D365/Power Platform',
        'Software Subscription' => 'Software Subscription',
        'Software Perpetuo' => 'Software Perpetuo',
        'CSP' => 'CSP',
        'Open' => 'Open',
        'SPLA' => 'SPLA',
        'CSP NCE' => 'CSP NCE',
        'Open Value - 1 Ano' => 'Open Value - 1 Ano',
        'Open Value - 2 Anos' => 'Open Value - 2 Anos',
        'Open Value - 3 Anos' => 'Open Value - 3 Anos',
        'Open Value' => 'Open Value'
      ],
      'billingCycle' => [
        'monthly' => 'Mensualmente',
        'annually' => 'Anualmente',
        'onetime' => 'One Time'
      ],
      'licenseType' => [
        'M365' => 'M365',
        'Software Subscription' => 'Software Subscription',
        'Software Perpetual' => 'Software Perpetual',
        'Open Value' => 'Open Value',
        'Azure' => 'Azure',
        '' => '',
        'D365' => 'D365',
        'Power Platform' => 'Power Platform',
        'Open Value Subscription' => 'Open Value Subscription',
        'OVS-ES' => 'OVS-ES',
        'O365/M365' => 'O365/M365',
        'School' => 'School'
      ],
      'timeContract' => [
        '' => '',
        '1 Month' => '1 Month',
        '1 Year' => '1 Year',
        '2 Years' => '2 Years',
        '3 Years' => '3 Years',
        'Perpetual' => 'Perpetual',
        'Pay as you go' => 'Pay as you go'
      ],
      'productCategory' => [
        '' => '',
        'Charity' => 'Charity',
        'Education' => 'Education',
        'Commercial' => 'Commercial',
        'Government' => 'Government',
        'Corporate' => 'Corporate',
        'Academic' => 'Academic'
      ]
    ],
    'presetFilters' => [
      'available' => 'Disponible',
      'inventory' => 'Inventory',
      'allVariants' => 'All Variants',
      'availableVariants' => 'Available Variants'
    ],
    'tabs' => [
      'inventory' => 'Inventory',
      'prices' => 'Prices',
      'variants' => 'Variants',
      'template' => 'Template',
      'orders' => 'Orders'
    ],
    'messages' => [
      'generateVariantsConfirmation' => 'Generate all possible variant combinations?',
      'variantsGenerated' => 'Done. {count} variants generated.',
      'attributesRequired' => 'At least one attribute is required',
      'optionsRequired' => 'Options are required'
    ],
    'massActions' => [
      'updatePrice' => 'Update Price'
    ]
  ],
  'ProductAttribute' => [
    'labels' => [
      'Create ProductAttribute' => 'Create Attribute',
      'Move to Top' => 'Move to Top',
      'Move Up' => 'Move Up',
      'Move Down' => 'Move Down',
      'Move to Bottom' => 'Move to Bottom'
    ],
    'fields' => [
      'order' => 'Order',
      'options' => 'Options'
    ],
    'links' => [
      'options' => 'Options',
      'products' => 'Products'
    ]
  ],
  'ProductAttributeOption' => [
    'labels' => [
      'Create ProductAttributeOption' => 'Create Option'
    ],
    'fields' => [
      'order' => 'Order',
      'attribute' => 'Attribute',
      'color' => 'Color',
      'attributeOrder' => 'Attribute Order'
    ],
    'links' => [
      'attribute' => 'Attribute',
      'products' => 'Products',
      'productVariants' => 'Product Variants'
    ]
  ],
  'ProductBrand' => [
    'labels' => [
      'Create ProductBrand' => 'Crear Brand'
    ],
    'fields' => [
      'website' => 'Website',
      'opportunities' => 'Oportunidades',
      'partnerIDs' => 'Partner IDs',
      'sources' => 'Origen',
      'lead' => 'Lead',
      'leads' => 'Leads',
      'partnerPrograms' => 'Programa de Socios',
      'cpb' => 'Cloud Practice Builder',
      'googlePartnerAdvantage' => 'Google Partner Advantage',
      'programs' => 'Program',
      'aWSs' => 'AWS',
      'events' => 'Events',
      'task' => 'Task',
      'dSET' => 'DSET',
      'vendorCloudConsumption' => 'Vendor Cloud Consumption',
      'tasks' => 'Tareas',
      'campanas' => 'Campañas',
      'marketing' => 'Campañas',
      'marketings' => 'Marketings',
      'opportunityItem' => 'Opportunity Item',
      'service' => 'Services',
      'vendorAccounts' => 'Vendor Accounts'
    ],
    'links' => [
      'products' => 'Products',
      'opportunities' => 'Opportunities',
      'partnerIDs' => 'Partner IDs',
      'sources' => 'Sources',
      'lead' => 'Lead',
      'leads' => 'Leads',
      'partnerPrograms' => 'Partner Programs',
      'cpb' => 'Cloud Practice Builder',
      'googlePartnerAdvantage' => 'Google Partner Advantage',
      'programs' => 'Program',
      'aWSs' => 'AWS',
      'events' => 'Events',
      'task' => 'Task',
      'dSET' => 'DSET',
      'vendorCloudConsumption' => 'Vendor Cloud Consumption',
      'tasks' => 'Tareas',
      'campanas' => 'Campañas',
      'marketing' => 'Campañas',
      'marketings' => 'Marketings',
      'opportunityItem' => 'Opportunity Item',
      'service' => 'Service',
      'vendorAccounts' => 'Vendor Accounts'
    ]
  ],
  'ProductCategory' => [
    'labels' => [
      'Create ProductCategory' => 'Create Category',
      'Manage Categories' => 'Manage Categories',
      'Products' => 'Products'
    ],
    'fields' => [
      'order' => 'Order',
      'childList' => 'Child List'
    ],
    'links' => [
      'products' => 'Products'
    ]
  ],
  'ProductPrice' => [
    'labels' => [
      'Create ProductPrice' => 'Create Price'
    ],
    'fields' => [
      'priceBook' => 'Price Book',
      'status' => 'Status',
      'product' => 'Product',
      'minQuantity' => 'Min. Quantity',
      'price' => 'Price',
      'priceCurrency' => 'Price Currency',
      'dateStart' => 'Date Start',
      'dateEnd' => 'Date End',
      'minQty' => 'Min. Qty',
      'partNumber' => 'Part Number',
      'priceConverted' => 'Price Converted'
    ],
    'links' => [
      'priceBook' => 'Price Book',
      'product' => 'Product'
    ],
    'options' => [
      'status' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ]
    ],
    'presetFilters' => [
      'active' => 'Active'
    ],
    'tooltips' => [
      'minQuantity' => 'The price will be used only when the quantity of items being sold exceeds the specified value.'
    ],
    'messages' => [
      'priceMassUpdated' => 'Prices updated, count: {count}'
    ],
    'massActions' => [
      'updatePrice' => 'Update Price'
    ]
  ],
  'PurchaseOrder' => [
    'labels' => [
      'Create PurchaseOrder' => 'Create Purchase Order',
      'Add Item' => 'Add Item',
      'Items' => 'Items',
      'Purchase Order Items' => 'Purchase Order Items',
      'Create Receipt' => 'Create Receipt'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'account' => 'Account',
      'billingAddress' => 'Billing Address',
      'shippingAddress' => 'Shipping Address',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'supplierAddress' => 'Supplier Address',
      'supplierAddressStreet' => 'Street (Supplier)',
      'supplierAddressCity' => 'City (Supplier)',
      'supplierAddressState' => 'State (Supplier)',
      'supplierAddressCountry' => 'Country (Supplier)',
      'supplierAddressPostalCode' => 'Postal Code (Supplier)',
      'tax' => 'Tax',
      'taxRate' => 'Tax Rate',
      'shippingCost' => 'Shipping Cost',
      'shippingProvider' => 'Shipping Provider',
      'taxAmount' => 'Tax Amount',
      'discountAmount' => 'Discount Amount',
      'amount' => 'Amount',
      'preDiscountedAmount' => 'Pre-Discount Amount',
      'grandTotalAmount' => 'Grand Total Amount',
      'itemList' => 'Item List',
      'dateOrdered' => 'Date Ordered',
      'deliveryDate' => 'Delivery Date',
      'weight' => 'Weight',
      'amountConverted' => 'Amount (converted)',
      'taxAmountConverted' => 'Tax Amount (converted)',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'preDiscountedAmountConverted' => 'Pre-Discount Amount (converted)',
      'discountAmountConverted' => 'Discount Amount (converted)',
      'grandTotalAmountConverted' => 'Grand Total Amount (converted)',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'taxAmountCurrency' => 'Tax Amount Currency',
      'discountAmountCurrency' => 'Discount Amount Currency',
      'amountCurrency' => 'Amount Currency',
      'preDiscountedAmountCurrency' => 'Pre-Discount Amount Currency',
      'grandTotalAmountCurrency' => 'Grand Total Amount Currency',
      'currency' => 'Currency',
      'supplier' => 'Supplier',
      'warehouse' => 'Ship to Warehouse',
      'isReceiptFullyCreated' => 'Receipt Fully Created',
      'hasInventoryItems' => 'Has Inventory Items',
      'isDone' => 'Is Done'
    ],
    'links' => [
      'items' => 'Items',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'shippingProvider' => 'Shipping Provider',
      'account' => 'Account',
      'tax' => 'Tax',
      'supplier' => 'Supplier',
      'inventoryTransactions' => 'Inventory Transactions',
      'receiptOrders' => 'Receipt Orders',
      'warehouse' => 'Warehouse'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Released' => 'Released',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ],
    'messages' => [
      'cannotCreateReceiptInEditMode' => 'Cannot create receipt orders while in edit mode.'
    ]
  ],
  'PurchaseOrderItem' => [
    'fields' => [
      'name' => 'Name',
      'qty' => 'Qty',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'listPrice' => 'List Price',
      'unitPrice' => 'Unit Price',
      'amount' => 'Amount',
      'taxRate' => 'Tax Rate',
      'product' => 'Product',
      'order' => 'Line Number',
      'purchaseOrder' => 'Purchase Order',
      'weight' => 'Weight',
      'unitWeight' => 'Unit Weight',
      'description' => 'Description',
      'discount' => 'Discount (%)',
      'amountConverted' => 'Amount (Converted)',
      'unitPriceConverted' => 'Unit Price (Converted)',
      'listPriceConverted' => 'List Price (Converted)',
      'account' => 'Account',
      'listPriceCurrency' => 'List Price Currency',
      'unitPriceCurrency' => 'Unit Price Currency',
      'amountCurrency' => 'Amount Currency',
      'purchaseOrderStatus' => 'Purchase Order Status',
      'inventoryNumberType' => 'Inventory Number Type'
    ],
    'links' => [
      'purchaseOrder' => 'Purchase Order',
      'product' => 'Product',
      'account' => 'Account'
    ],
    'labels' => [
      'Purchase Orders' => 'Purchase Orders'
    ]
  ],
  'Quote' => [
    'labels' => [
      'Create Quote' => 'Create Quote',
      'Taxes' => 'Taxes',
      'Shipping Providers' => 'Shipping Providers',
      'Add Item' => 'Add Item',
      'Templates' => 'Templates',
      'Items' => 'Items',
      'Quote Items' => 'Quote Items',
      'Apply Price Book' => 'Apply Price Book',
      'Locked' => 'Locked',
      'Unlocked' => 'Unlocked',
      'Send in Email' => 'Send in Email'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Quote Number',
      'numberA' => 'Quote Number (auto-incremented)',
      'invoiceNumber' => 'Invoice Number',
      'account' => 'Account',
      'opportunity' => 'Opportunity',
      'billingAddress' => 'Billing Address',
      'shippingAddress' => 'Shipping Address',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'tax' => 'Tax',
      'taxRate' => 'Tax Rate',
      'shippingCost' => 'Shipping Cost',
      'shippingProvider' => 'Shipping Provider',
      'taxAmount' => 'Tax Amount',
      'discountAmount' => 'Discount Amount',
      'amount' => 'Amount',
      'preDiscountedAmount' => 'Pre-Discount Amount',
      'grandTotalAmount' => 'Grand Total Amount',
      'itemList' => 'Item List',
      'dateQuoted' => 'Date Quoted',
      'dateOrdered' => 'Date Ordered',
      'dateInvoiced' => 'Date Invoiced',
      'weight' => 'Weight',
      'amountConverted' => 'Amount (converted)',
      'taxAmountConverted' => 'Tax Amount (converted)',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'preDiscountedAmountConverted' => 'Pre-Discount Amount (converted)',
      'discountAmountConverted' => 'Discount Amount (converted)',
      'grandTotalAmountConverted' => 'Grand Total Amount (converted)',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'taxAmountCurrency' => 'Tax Amount Currency',
      'discountAmountCurrency' => 'Discount Amount Currency',
      'amountCurrency' => 'Amount Currency',
      'preDiscountedAmountCurrency' => 'Pre-Discount Amount Currency',
      'grandTotalAmountCurrency' => 'Grand Total Amount Currency',
      'currency' => 'Currency',
      'priceBook' => 'Price Book',
      'inventoryStatus' => 'Inventory Status',
      'isDone' => 'Is Done',
      'amountDiscounted' => 'Total Discounted Amount',
      'amountDiscountedCurrency' => 'Total Discounted Amount (Currency)',
      'amountDiscountedConverted' => 'Total Discounted Amount (Converted)',
      'quoteAccessKey' => 'Quotation Access Key',
      'receipt' => 'Tax Invoice',
      'quotePage' => 'Quote Page',
      'reply' => 'Quote Review',
      'billingContactEmail' => 'Billing Contact Email',
      'oppStage' => 'Opportunity Stage',
      'commercialConditions' => 'Commercial Conditions',
      'contacts' => 'Contacts',
      'documents' => 'Documents',
      'sendEmail' => 'Send Email to Billing Contact',
      'reviewDate' => 'Review Date',
      'amountWithDiscount' => 'Total Amount (With Discount)',
      'amountWithDiscountCurrency' => 'Total Amount (With Discount) (Currency)',
      'amountWithDiscountConverted' => 'Total Amount (With Discount) (Converted)',
      'quotes' => 'Versions',
      'quoteParent' => 'Price',
      'version' => 'Version'
    ],
    'links' => [
      'items' => 'Items',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'shippingProvider' => 'Shipping Provider',
      'opportunity' => 'Opportunity',
      'account' => 'Account',
      'tax' => 'Tax',
      'salesOrders' => 'Sales Orders',
      'invoices' => 'Invoices',
      'priceBook' => 'Price Book',
      'inventoryData' => 'Inventory Data',
      'contacts' => 'Contacts',
      'documents' => 'Documents',
      'quotes' => 'Versions',
      'quoteParent' => 'Quote'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'In Review' => 'In Review',
        'Presented' => 'Presented',
        'Approved' => 'Approved',
        'Rejected' => 'Rejected',
        'Canceled' => 'Canceled'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'approved' => 'Approved'
    ],
    'messages' => [
      'cannotRemoveLockedRecord' => 'Cannot remove the locked record.',
      'massLockDone' => '{count} locked',
      'massUnlockDone' => '{count} unlocked',
      'confirmMassLock' => 'Are you sure you want to lock selected records?',
      'confirmMassUnlock' => 'Are you sure you want to unlock selected records?',
      'cantModifyLocked' => 'Cannot modify *{field}* in the locked record.',
      'productTemplateCannotBeSelected' => 'A product template cannot be selected in an item. *{name}* is a template.',
      'fieldCannotBeFractional' => 'Quantity cannot be fractional for this product',
      'invalidItems' => 'Invalid items.',
      'requiredInventoryNumber' => 'Inventory Number is required.',
      'requiredQuantityReceived' => 'Quantity Received is required.',
      'notEnoughQuantity' => 'Not enough quantity is available.',
      'enoughQuantity' => 'Enough quantity is available.',
      'softNotEnoughQuantity' => 'Enough quantity is on hand but some items are soft-reserved.',
      'applyNewPriceConfirmation' => 'A different price is available for the specified quantity. Would you like to apply it?',
      'cannotUnlockByRegularUser' => 'Cannot unlock. Only an administrator is permitted.'
    ],
    'texts' => [
      'onHandQuantityInfo' => 'On hand',
      'availableQuantityInfo' => 'Available',
      'lackingQuantityInfo' => 'Lacking',
      'totalAvailableQuantityInfo' => 'In all warehouses',
      'totalOnHandQuantityInfo' => 'On hand in all warehouses',
      'onHandInventoryNumberInfo' => 'Inv. number on hand',
      'onHandBatchInfo' => 'On hand in batch',
      'onHandSerialInfo' => 'Serial on hand'
    ],
    'tooltips' => [
      'quoteAccessKey' => 'To generate an Access Key, please select "Billing Contact".'
    ]
  ],
  'QuoteItem' => [
    'fields' => [
      'name' => 'Name',
      'qty' => 'Qty',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'listPrice' => 'List Price',
      'unitPrice' => 'Unit Price',
      'amount' => 'Amount',
      'taxRate' => 'Tax Rate',
      'product' => 'Product',
      'order' => 'Line Number',
      'quote' => 'Quote',
      'weight' => 'Weight',
      'unitWeight' => 'Unit Weight',
      'description' => 'Description',
      'discount' => 'Discount (%)',
      'amountConverted' => 'Amount (Converted)',
      'unitPriceConverted' => 'Unit Price (Converted)',
      'listPriceConverted' => 'List Price (Converted)',
      'account' => 'Account',
      'listPriceCurrency' => 'List Price Currency',
      'unitPriceCurrency' => 'Unit Price Currency',
      'amountCurrency' => 'Amount Currency',
      'quoteStatus' => 'Quote Status',
      'discountAmount' => 'Value with Discount',
      'discountAmountCurrency' => 'Total Amount (With Discount) (Currency)',
      'discountAmountConverted' => 'Total Amount (With Discount) (Converted)',
      'timeContract' => 'Time Contract',
      'solutionType' => 'Billing',
      'discountItem' => 'Discount (%)'
    ],
    'links' => [
      'quote' => 'Quote',
      'product' => 'Product',
      'account' => 'Account'
    ],
    'labels' => [
      'Quotes' => 'Quotes'
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ],
    'options' => [
      'timeContract' => [
        '' => '',
        '1 Month' => '1 Month',
        '1 Year' => '1 Year',
        '2 Years' => '2 Years',
        '3 Years' => '3 Years',
        'Perpetual' => 'Perpetual',
        'Pay as you go' => 'Pay as you go'
      ],
      'solutionType' => [
        '' => '',
        '1 Month' => '1 Month',
        '1 Year' => '1 Year',
        'Monthly' => 'Monthly',
        'Annual' => 'Anual',
        'Up Front' => 'Up Front',
        '2 Years' => '2 Years',
        '3 Years' => '3 Years',
        'Flexible' => 'Flexible',
        'Perpetual' => 'Perpetual',
        'Pay as you go' => 'Pay as you go',
        'Quote' => 'Quote',
        'Annual - Monthly Payment' => 'Annual - Monthly Payment',
        'Trial Version' => 'Trial '
      ]
    ]
  ],
  'ReceiptOrder' => [
    'labels' => [
      'Create ReceiptOrder' => 'Create Receipt Order',
      'Add Item' => 'Add Item',
      'Items' => 'Items',
      'Received Inventory' => 'Received Inventory',
      'Import Serial Numbers' => 'Import Serial Numbers',
      'CSV File' => 'CSV File'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'account' => 'Account',
      'supplier' => 'Supplier',
      'purchaseOrder' => 'Purchase Order',
      'returnOrder' => 'Return Order',
      'shippingContact' => 'Shipping Contact',
      'shippingCost' => 'Shipping Cost',
      'amount' => 'Amount',
      'shippingProvider' => 'Shipping Provider',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'amountCurrency' => 'Amount Currency',
      'itemList' => 'Item List',
      'receivedItemList' => 'Received Item List',
      'dateOrdered' => 'Date Ordered',
      'dateReceived' => 'Date Received',
      'weight' => 'Weight',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'currency' => 'Currency',
      'isDone' => 'Is Done',
      'warehouse' => 'Warehouse',
      'fieldDelimiter' => 'Field Delimiter',
      'textQualifier' => 'Text Qualifier',
      'headerRow' => 'Header Row',
      'columnNumber' => 'Column Number',
      'preview' => 'Preview'
    ],
    'links' => [
      'items' => 'Items',
      'receivedItems' => 'Received Items',
      'shippingContact' => 'Shipping Contact',
      'shippingProvider' => 'Shipping Provider',
      'purchaseOrder' => 'Purchase Order',
      'returnOrder' => 'Return Order',
      'account' => 'Account',
      'supplier' => 'Supplier',
      'inventoryTransactions' => 'Inventory Transactions',
      'warehouse' => 'Warehouse'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Ready' => 'Ready',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ],
    'messages' => [
      'inventoryIsInAdjustment' => 'Can\'t save as inventory is currently in a started adjustment.',
      'serialNumbersExists' => 'Some serial numbers already exists.

{numbers}',
      'serialNumberImportLimitExceeded' => 'Cannot import more than {maxSize} serial numbers.',
      'serialNumberAlreadyInStock' => 'Serial number already in stock.

{numbers}',
      'receivedSerialNumberNotOne' => 'Quantity of a received item with a serial number should be one.',
      'receivedInventoryNumberProductMismatch' => 'Inventory number does not correspond to the product.',
      'receivedInventoryNumberIsEmpty' => 'Not specified inventory number.',
      'receivedQuantityMismatch' => 'Received quantity mismatch.',
      'emptyQuantityReceived' => 'Need to specify Quantity Received before completing the order.'
    ]
  ],
  'ReceiptOrderItem' => [
    'fields' => [
      'name' => 'Name',
      'qty' => 'Qty',
      'qtyReceived' => 'Qty Rcv',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'quantityReceived' => 'Quantity Received',
      'quantityReceivedInt' => 'Quantity Received (Int)',
      'product' => 'Product',
      'order' => 'Line Number',
      'receiptOrder' => 'Receipt Order',
      'weight' => 'Weight',
      'unitWeight' => 'Unit Weight',
      'description' => 'Description',
      'account' => 'Account',
      'receiptOrderStatus' => 'Receipt Order Status',
      'inventoryNumberType' => 'Inventory Number Type',
      'isInventory' => 'Is Inventory'
    ],
    'links' => [
      'receiptOrder' => 'Receipt Order',
      'product' => 'Product',
      'account' => 'Account'
    ]
  ],
  'ReturnOrder' => [
    'labels' => [
      'Create ReturnOrder' => 'Create Return Order',
      'Add Item' => 'Add Item',
      'Items' => 'Items',
      'Create Receipt' => 'Create Receipt'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'account' => 'Account',
      'salesOrder' => 'Sales Order',
      'billingAddress' => 'Billing Address',
      'fromAddress' => 'Ship from Address',
      'shippingAddress' => 'Shipping Address',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'fromAddressStreet' => 'Street (from)',
      'fromAddressCity' => 'City (from)',
      'fromAddressState' => 'State (from)',
      'fromAddressCountry' => 'Country (from)',
      'fromAddressPostalCode' => 'Postal Code (from)',
      'tax' => 'Tax',
      'taxRate' => 'Tax Rate',
      'shippingCost' => 'Shipping Cost',
      'shippingProvider' => 'Shipping Provider',
      'taxAmount' => 'Tax Amount',
      'discountAmount' => 'Discount Amount',
      'amount' => 'Amount',
      'preDiscountedAmount' => 'Pre-Discount Amount',
      'grandTotalAmount' => 'Grand Total Amount',
      'itemList' => 'Item List',
      'dateOrdered' => 'Date Ordered',
      'deliveryDate' => 'Delivery Date',
      'weight' => 'Weight',
      'amountConverted' => 'Amount (converted)',
      'taxAmountConverted' => 'Tax Amount (converted)',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'preDiscountedAmountConverted' => 'Pre-Discount Amount (converted)',
      'discountAmountConverted' => 'Discount Amount (converted)',
      'grandTotalAmountConverted' => 'Grand Total Amount (converted)',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'taxAmountCurrency' => 'Tax Amount Currency',
      'discountAmountCurrency' => 'Discount Amount Currency',
      'amountCurrency' => 'Amount Currency',
      'preDiscountedAmountCurrency' => 'Pre-Discount Amount Currency',
      'grandTotalAmountCurrency' => 'Grand Total Amount Currency',
      'currency' => 'Currency',
      'supplier' => 'Supplier',
      'warehouse' => 'Ship to Warehouse',
      'isReceiptFullyCreated' => 'Receipt Fully Created',
      'hasInventoryItems' => 'Has Inventory Items',
      'isDone' => 'Is Done'
    ],
    'links' => [
      'items' => 'Items',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'shippingProvider' => 'Shipping Provider',
      'account' => 'Account',
      'salesOrder' => 'Sales Order',
      'tax' => 'Tax',
      'supplier' => 'Supplier',
      'receiptOrders' => 'Receipt Orders',
      'warehouse' => 'Warehouse'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Released' => 'Released',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ],
    'messages' => [
      'cannotCreateReceiptInEditMode' => 'Cannot create receipt orders while in edit mode.'
    ]
  ],
  'ReturnOrderItem' => [
    'fields' => [
      'name' => 'Name',
      'qty' => 'Qty',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'listPrice' => 'List Price',
      'unitPrice' => 'Unit Price',
      'amount' => 'Amount',
      'taxRate' => 'Tax Rate',
      'product' => 'Product',
      'inventoryNumber' => 'Inventory Number',
      'order' => 'Line Number',
      'returnOrder' => 'Return Order',
      'weight' => 'Weight',
      'unitWeight' => 'Unit Weight',
      'description' => 'Description',
      'discount' => 'Discount (%)',
      'amountConverted' => 'Amount (Converted)',
      'unitPriceConverted' => 'Unit Price (Converted)',
      'listPriceConverted' => 'List Price (Converted)',
      'account' => 'Account',
      'listPriceCurrency' => 'List Price Currency',
      'unitPriceCurrency' => 'Unit Price Currency',
      'amountCurrency' => 'Amount Currency',
      'returnOrderStatus' => 'Return Order Status',
      'inventoryNumberType' => 'Inventory Number Type'
    ],
    'links' => [
      'returnOrder' => 'Return Order',
      'product' => 'Product',
      'account' => 'Account'
    ]
  ],
  'SalesOrder' => [
    'labels' => [
      'Create SalesOrder' => 'Crear Sales Order - Lista',
      'Taxes' => 'Impuestos',
      'Shipping Providers' => 'Proveedores de transporte',
      'Add Item' => 'Añadir artículo',
      'Templates' => 'Plantillas',
      'Items' => 'Items',
      'Sales Order Items' => 'Sales Order Items',
      'Create Delivery' => 'Create Delivery',
      'Add Delivery' => 'Add Delivery',
      'Not Created' => 'Not Created'
    ],
    'fields' => [
      'status' => 'Estado',
      'number' => 'Número',
      'numberA' => 'Número (incrementado automáticamente)',
      'account' => 'Cuenta',
      'opportunity' => 'Oportunidad',
      'quote' => 'Cotización',
      'billingAddress' => 'Dirección',
      'shippingAddress' => 'Dirección de envío',
      'billingContact' => 'Contacto de Facturación',
      'shippingContact' => 'Contacto de envío',
      'tax' => 'Impuesto',
      'taxRate' => 'Tasa de impuesto',
      'shippingCost' => 'Costo de envío',
      'shippingProvider' => 'Proveedor de envío',
      'taxAmount' => 'Importe del impuesto',
      'discountAmount' => 'Cantidad de Descuento',
      'amount' => 'Monto (FOB)',
      'preDiscountedAmount' => 'Monto previo al descuento',
      'grandTotalAmount' => 'Monto total general',
      'itemList' => 'Lista de ítems',
      'dateOrdered' => 'Fecha del Pedido',
      'dateInvoiced' => 'Fecha de Facturación',
      'weight' => 'Peso',
      'amountConverted' => 'Monto (convertido)',
      'taxAmountConverted' => 'Importe del impuesto (converted)',
      'shippingCostConverted' => 'Costo de envío (converted)',
      'preDiscountedAmountConverted' => 'Monto previo al descuento (converted)',
      'discountAmountConverted' => 'Cantidad de Descuento (convertido)',
      'grandTotalAmountConverted' => 'Monto total general (converted)',
      'shippingCostCurrency' => 'Costo de envío Currency',
      'taxAmountCurrency' => 'Importe del impuesto Currency',
      'discountAmountCurrency' => 'Cantidad de Descuento Moneda',
      'amountCurrency' => 'Monto de Dinero',
      'preDiscountedAmountCurrency' => 'Monto previo al descuento Currency',
      'grandTotalAmountCurrency' => 'Monto total general Currency',
      'currency' => 'Moneda',
      'priceBook' => 'Price Book',
      'inventoryData' => 'Inventory Data',
      'inventoryStatus' => 'Inventory Status',
      'isDeliveryCreated' => 'Delivery Created',
      'hasInventoryItems' => 'Has Inventory Items',
      'isDone' => 'Is Done',
      'partnerID' => 'Partner ID',
      'quantity' => 'Cantidad',
      'cloudsolvSSAID' => 'CloudSolv SSA ID',
      'contractEndDateVendor' => 'Fin del Contrato',
      'subscriptionAutomaticRenew' => 'Renovación Automática',
      'orderDetail' => 'Detalle de la Orden',
      'subscriptionID' => 'ID de suscripción',
      'billingCycle' => 'Ciclo de Facturación',
      'endUserAmount' => 'Valor Cliente Final',
      'endUserAmountCurrency' => 'Valor Cliente Final (Moneda)',
      'endUserAmountConverted' => 'Valor Cliente Final (Convertido)',
      'subscriptionAmount' => 'Valor Reventa',
      'subscriptionAmountCurrency' => 'Monto de la suscripción (Currency)',
      'subscriptionAmountConverted' => 'Monto de la suscripción (Converted)',
      'listPrice' => 'Lista de Precio',
      'discountPricingRules' => 'Reglas de precios de descuento',
      'markupPricingRules' => 'Reglas de precios de Markup',
      'pricingInfo' => 'Información de precios',
      'contractIdExternal' => 'ID de Contrato Externo',
      'directbilling' => 'Facturación Directa',
      'contractLastRenovation' => 'Contrato Última Renovación',
      'termDuration' => 'Plazo Duración',
      'profit' => 'Ganancia',
      'profitCurrency' => 'Ganancia (Moneda)',
      'profitConverted' => 'Ganancia (Convertida)',
      'countryExternal' => 'País',
      'accountNameExternal' => 'Cliente Final',
      'accountParentNameExternal' => 'Revendedor',
      'vendorCloudConsumption' => 'Consumo de la nube por parte del proveedor',
      'vendorAccountName' => 'Nombre de cuenta del proveedor',
      'cloudConsumption' => 'Cloud Consumption',
      'productSSA' => 'Producto (de CloudsolvSSA)',
      'reseller' => 'Revendedor',
      'microsoftRecommendations' => 'Recomendaciones Microsoft',
      'microsoftRecommendationsText' => 'Recomendaciones',
      'top5Customers' => 'Cliente Top 5',
      'accountTop5' => 'Cuenta',
      'accountReservedInstances' => 'Cuenta',
      'accountRecommendation' => 'Recomendaciones de cuenta',
      'product' => 'Producto',
      'converterQuantity' => 'Qtd.',
      'microsoftRecommendationsEmail' => 'Recomendación (Correo electrónico)',
      'contractEndDateDays' => 'Expiración en (días)',
      'service' => 'Servicio'
    ],
    'links' => [
      'items' => 'Items',
      'billingContact' => 'Contacto de facturación',
      'shippingContact' => 'Contacto de envío',
      'shippingProvider' => 'Proveedor de envío',
      'opportunity' => 'Oportunidad',
      'account' => 'Cuenta',
      'tax' => 'Impuesto',
      'quote' => 'Cita',
      'invoices' => 'Facturas',
      'deliveryOrders' => 'Delivery Orders',
      'returnOrders' => 'Return Orders',
      'priceBook' => 'Price Book',
      'inventoryTransactions' => 'Inventory Transactions',
      'partnerID' => 'Partner ID',
      'vendorCloudConsumption' => 'Consumo de la nube por parte del proveedor',
      'cloudConsumption' => 'Cloud Consumption',
      'reseller' => 'Revendedor',
      'accountTop5' => 'Cuenta',
      'accountReservedInstances' => 'Cuenta',
      'accountRecommendation' => 'Recomendaciones de cuenta',
      'service' => 'Servicio'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Borrador',
        'Ready' => 'Ready',
        'Active' => 'Activado',
        'Approved' => 'Approved',
        'Completed' => 'Completed',
        'Rejected' => 'Rechazado',
        'Canceled' => 'Cancelado',
        'Pending' => 'Pendiente',
        'Suspended' => 'Suspendido',
        'under analysis' => 'bajo análisis'
      ],
      'billingCycle' => [
        'Monthly' => 'Mensual',
        'Annualy' => 'Annualy',
        'Annually' => 'Anual',
        'OneTime' => 'OneTime',
        '' => 'Empty'
      ],
      'countryExternal' => [
        'BR' => 'BR',
        'CL' => 'CL',
        'CO' => 'CO',
        'AR' => 'AR',
        'EC' => 'EC',
        'CH' => 'CH',
        'PE' => 'PE',
        'PA' => 'PA',
        '' => '',
        'MX' => 'MX'
      ],
      'microsoftRecommendations' => [
        'Copilot M365' => 'Copilot M365',
        'EMS E3' => 'EMS E3',
        'EMS E5' => 'EMS E5',
        'Microsoft 365 Business Premium' => 'Microsoft 365 Business Premium',
        'Microsoft 365 Business Standard' => 'Microsoft 365 Business Standard',
        'Microsoft 365 A3' => 'Microsoft 365 A3',
        'Microsoft 365 A5' => 'Microsoft 365 A5',
        'Office 365 E1' => 'Office 365 E1',
        'Office 365 E3' => 'Office 365 E3',
        'Office 365 E5' => 'Office 365 E5',
        'Windows E3' => 'Windows E3',
        'Windows E5' => 'Windows E5',
        'None' => 'Ninguno',
        'Microsoft 365 Business Standard + Copilot M365' => 'Microsoft 365 Business Standard + Copilot M365',
        'Office 365 E3 + Copilot M365' => 'Office 365 E3 + Copilot M365'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completado',
      'reportFilter664d0b06517450b14' => 'Renovaciones - 15 days',
      'reportFilter664d0e340882520f7' => 'Renovaciones - 45 days',
      'reportFilter664d0e6ceb98d29e4' => 'Renovaciones - 90 days',
      'reportFilter664d0eba732cf5106' => 'Renovaciones Instancia reservada - 90 days',
      'reportFilter664d0fd3e3ead8274' => 'Renovaciones  Auto OFF - 15 days',
      'reportFilter664d101ecb1f34383' => 'Renovaciones  Auto OFF - 45 days',
      'reportFilter664d1038e67c31c3c' => 'Renovaciones Auto OFF - 90 days',
      'reportFilter664dfdebb84637a58' => 'Renovaciones  - Proximos 90 days',
      'reportFilter664e33d0e85544c6c' => 'Recomendaciones de renovaciones Copilot M365',
      'reportFilter66831cbe23b6204fe' => 'Conteo Recomendación de renovaciones Microsoft',
      'reportFilter669153f230b85ba6a' => 'Renovaciones - Top 5 Clientes',
      'reportFilter66916dc409c1b86f7' => 'Renovaciones - Instancia reservada'
    ],
    'messages' => [
      'cannotCreateDeliveryInEditMode' => 'Cannot create delivery orders while in edit mode.'
    ]
  ],
  'SalesOrderItem' => [
    'fields' => [
      'name' => 'Nombre',
      'qty' => 'Qty',
      'quantity' => 'Cantidad',
      'quantityInt' => 'Cantidad(Int)',
      'listPrice' => 'Lista de Precio',
      'unitPrice' => 'Precio Unitario',
      'amount' => 'Valor',
      'taxRate' => 'Tasa de impuesto',
      'product' => 'Producto',
      'order' => 'Número de línea',
      'salesOrder' => 'Sales Order',
      'weight' => 'Peso',
      'unitWeight' => 'Unidad de peso',
      'description' => 'Descripcion',
      'discount' => 'Descuento (%)',
      'amountConverted' => 'Valor (Converted)',
      'unitPriceConverted' => 'Precio Unitario (Converted)',
      'listPriceConverted' => 'Lista de Precio (Converted)',
      'account' => 'Cuenta',
      'listPriceCurrency' => 'Lista de Precio Currency',
      'unitPriceCurrency' => 'Precio Unitario Currency',
      'amountCurrency' => 'Valor Currency',
      'salesOrderStatus' => 'Sales Order Estado',
      'inventoryNumberType' => 'Inventory Number Type',
      'isInventory' => 'Is Inventory',
      'services' => 'Servicios'
    ],
    'links' => [
      'salesOrder' => 'Sales Order',
      'product' => 'Producto',
      'account' => 'Cuenta',
      'services' => 'Servicios'
    ],
    'labels' => [
      'Sales Orders' => 'Sales Orders',
      'Create SalesOrderItem' => 'Crear Sales Order Item'
    ]
  ],
  'ShippingProvider' => [
    'labels' => [
      'Create ShippingProvider' => 'Create Shipping Provider'
    ],
    'fields' => [
      'website' => 'Website'
    ]
  ],
  'Supplier' => [
    'labels' => [
      'Create Supplier' => 'Create Supplier'
    ],
    'fields' => [
      'account' => 'Account',
      'status' => 'Status'
    ],
    'links' => [
      'account' => 'Account',
      'prices' => 'Prices',
      'purchaseOrders' => 'Purchase Orders'
    ],
    'presetFilters' => [
      'active' => 'Active'
    ],
    'options' => [
      'status' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ]
    ]
  ],
  'SupplierProductPrice' => [
    'labels' => [
      'Create SupplierProductPrice' => 'Create Supplier Price'
    ],
    'fields' => [
      'supplier' => 'Supplier',
      'status' => 'Status',
      'product' => 'Product',
      'minQuantity' => 'Min. Quantity',
      'price' => 'Price',
      'priceCurrency' => 'Price Currency',
      'dateStart' => 'Date Start',
      'dateEnd' => 'Date End',
      'minQty' => 'Min. Qty',
      'partNumber' => 'Part Number',
      'priceConverted' => 'Price Converted'
    ],
    'links' => [
      'supplier' => 'Supplier',
      'product' => 'Product'
    ],
    'options' => [
      'status' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ]
    ],
    'presetFilters' => [
      'active' => 'Active'
    ],
    'massActions' => [
      'updatePrice' => 'Update Price'
    ]
  ],
  'Tax' => [
    'labels' => [
      'Create Tax' => 'Create Tax'
    ],
    'fields' => [
      'rate' => 'Rate'
    ]
  ],
  'TransferOrder' => [
    'labels' => [
      'Create TransferOrder' => 'Create Transfer Order',
      'Add Item' => 'Add Item',
      'Items' => 'Items',
      'Valid' => 'Valid',
      'Invalid' => 'Invalid',
      'Show Availability' => 'Show Availability',
      'Availability' => 'Availability',
      'Total' => 'Total'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'fromWarehouse' => 'From Warehouse',
      'toWarehouse' => 'To Warehouse',
      'fromAddress' => 'Ship from Address',
      'toAddress' => 'Ship to Address',
      'shippingCost' => 'Shipping Cost',
      'amount' => 'Amount',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'amountCurrency' => 'Amount Currency',
      'shippingProvider' => 'Shipping Provider',
      'itemList' => 'Item List',
      'dateOrdered' => 'Date Ordered',
      'shippingDate' => 'Shipping Date',
      'deliveryDate' => 'Delivery Date',
      'weight' => 'Weight',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'currency' => 'Currency',
      'inventoryData' => 'Inventory Data',
      'inventoryStatus' => 'Inventory Status',
      'isDone' => 'Is Done'
    ],
    'links' => [
      'items' => 'Items',
      'shippingContact' => 'Shipping Contact',
      'shippingProvider' => 'Shipping Provider',
      'inventoryTransactions' => 'Inventory Transactions',
      'fromWarehouse' => 'From Warehouse',
      'toWarehouse' => 'To Warehouse'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Ready' => 'Ready',
        'In Progress' => 'In Progress',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled',
        'Failed' => 'Failed'
      ],
      'inventoryStatus' => [
        'Available' => 'Available',
        'On Hand' => 'On Hand',
        'Not Available' => 'Not Available'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ],
    'messages' => [
      'warehousesAreSame' => 'Warehouses must be different'
    ]
  ],
  'TransferOrderItem' => [
    'fields' => [
      'name' => 'Name',
      'qty' => 'Qty',
      'qtyReceived' => 'Qty Rcv',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'quantityReceived' => 'Quantity Received',
      'quantityReceivedInt' => 'Quantity Received (Int)',
      'product' => 'Product',
      'order' => 'Line Number',
      'transferOrder' => 'Transfer Order',
      'weight' => 'Weight',
      'unitWeight' => 'Unit Weight',
      'description' => 'Description',
      'transferOrderStatus' => 'Transfer Order Status',
      'inventoryNumber' => 'Inventory Number',
      'inventoryNumberType' => 'Inventory Number Type',
      'isInventory' => 'Is Inventory'
    ],
    'links' => [
      'transferOrder' => 'Transfer Order',
      'product' => 'Product',
      'inventoryNumber' => 'Inventory Number'
    ]
  ],
  'Warehouse' => [
    'labels' => [
      'Create Warehouse' => 'Create Warehouse'
    ],
    'fields' => [
      'status' => 'Status',
      'isAvailableForStock' => 'Available for Stock',
      'isStock' => 'Stock'
    ],
    'links' => [
      'inventoryTransactions' => 'Inventory Transactions',
      'products' => 'Products',
      'inventoryNumbers' => 'Inventory Numbers'
    ],
    'options' => [
      'status' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ]
    ],
    'presetFilters' => [
      'active' => 'Active'
    ]
  ],
  'DashboardSet' => [
    'fields' => [
      'dashboardTemplate' => 'Dashboard Template',
      'iconClass' => 'Icon',
      'number' => 'Number'
    ],
    'labels' => [
      'Create DashboardSet' => 'Create Dashboard Set'
    ],
    'links' => [
      'dashboardTemplate' => 'Dashboard Template'
    ]
  ],
  'Service' => [
    'fields' => [
      'account' => 'Account',
      'amount' => 'Amount',
      'amountConverted' => 'Amount (converted)',
      'amountCurrency' => 'Amount Currency',
      'description' => 'Description',
      'itemList' => 'Item List',
      'name' => 'Name',
      'billingSituation' => 'Situação Financeira',
      'billingType' => 'Tipo de Faturamento',
      'cancelReason' => 'Motivo de Cancelamento',
      'stage' => 'Status',
      'consumptionEstimate' => 'Estimativa de Consumo (Mensal)',
      'consumptionEstimateCurrency' => 'Estimativa de Consumo (Mensal) (Currency)',
      'consumptionEstimateConverted' => 'Estimativa de Consumo (Mensal) (Converted)',
      'costVSReceipt' => 'Lucro',
      'costVSReceiptCurrency' => 'Lucro (Currency)',
      'costVSReceiptConverted' => 'Lucro (Converted)',
      'custo' => 'Custo',
      'custoCurrency' => 'Custo (Currency)',
      'custoConverted' => 'Custo (Converted)',
      'custoUSD' => 'Custo (Convertido)',
      'custoUSDCurrency' => 'Custo (Convertido) (Currency)',
      'custoUSDConverted' => 'Custo (Convertido) (Converted)',
      'documents' => 'Documentos',
      'productBrand' => 'Fabricante',
      'servicesVersionses' => 'Service Versions',
      'dollarAmount' => 'Cotação do Dólar',
      'endDate' => 'Data de Conclusão',
      'endUserEmail' => 'Cliente Final (E-mail)',
      'faturamento' => 'Faturamento',
      'followup' => 'Follow Up',
      'installationCost' => 'Custo de Instalação',
      'installationCostCurrency' => 'Custo de Instalação (Currency)',
      'installationCostConverted' => 'Custo de Instalação (Converted)',
      'serviceType' => 'Tipo de Serviço',
      'installationMarkupPercentage' => 'Markup Instalação / Implementação (%)',
      'installationRevenue' => 'Receita em Instalação / Implementação',
      'installationRevenueCurrency' => 'Receita em Instalação / Implementação (Currency)',
      'installationRevenueConverted' => 'Receita em Instalação / Implementação (Converted)',
      'margem' => 'Margem (%)',
      'mso' => 'MSO',
      'nfParceiro' => 'NF Parceiro',
      'nfSYNNEX' => 'NF TD SYNNEX',
      'netRevenueCloud' => 'Receita Líquida (Com Impostos)',
      'netRevenueCloudCurrency' => 'Receita Líquida (Com Impostos) (Currency)',
      'netRevenueCloudConverted' => 'Receita Líquida (Com Impostos) (Converted)',
      'notes' => 'Observações',
      'number' => 'Número',
      'opportunityType' => 'Tipo de Oportunidade',
      'order' => 'Order',
      'pO' => 'PO',
      'pOID' => 'PO ID',
      'partnerCommission' => 'Comissão da Revenda',
      'partnerCommissionCurrency' => 'Comissão da Revenda (Currency)',
      'partnerCommissionConverted' => 'Comissão da Revenda (Converted)',
      'operadoraRevendaEmail' => 'Operadora / Revenda (Email)',
      'partnerNumber' => 'Partner Number',
      'projectType' => 'Tipo do Projeto',
      'receita' => 'Receita',
      'receitaCurrency' => 'Receita (Currency)',
      'receitaConverted' => 'Receita (Converted)',
      'revenue' => 'Revenue',
      'revenueCurrency' => 'Revenue (Currency)',
      'revenueConverted' => 'Revenue (Converted)',
      'revenueNet' => 'Revenue Net',
      'revenueNetCurrency' => 'Revenue Net (Currency)',
      'revenueNetConverted' => 'Revenue Net (Converted)',
      'sellingDate' => 'Data de Venda',
      'sendingDate' => 'Data de Envio',
      'serviceActivity' => 'Atividade do Serviço',
      'serviceAmountTotal' => 'Valor Bruto do Serviço (BRL)',
      'serviceAmountTotalCurrency' => 'Valor Bruto do Serviço (BRL) (Currency)',
      'serviceAmountTotalConverted' => 'Valor Bruto do Serviço (BRL) (Converted)',
      'serviceAmountTotalUSD' => 'Valor Bruto do Serviço (USD)',
      'serviceAmountTotalUSDCurrency' => 'Valor Bruto do Serviço (USD) (Currency)',
      'serviceAmountTotalUSDConverted' => 'Valor Bruto do Serviço (USD) (Converted)',
      'servicePartnerValue' => 'Valor do Parceiro de Serviço',
      'servicePartnerValueCurrency' => 'Valor do Parceiro de Serviço (Currency)',
      'servicePartnerValueConverted' => 'Valor do Parceiro de Serviço (Converted)',
      'serviceProviderVarchar' => 'Prestador de Serviços',
      'solicitationDate' => 'Data da Solicitação do Serviço',
      'startDate' => 'Data de Início',
      'supportCost' => 'Custo de Suporte',
      'supportCostCurrency' => 'Custo de Suporte (Currency)',
      'supportCostConverted' => 'Custo de Suporte (Converted)',
      'supportMarkupPercentage' => 'Markup Suporte (%)',
      'supportRevenue' => 'Receita em Suporte',
      'supportRevenueCurrency' => 'Receita em Suporte (Currency)',
      'supportRevenueConverted' => 'Receita em Suporte (Converted)',
      'ticket' => 'Ticket',
      'accountType' => 'Tipo de Parceiro',
      'totalCost' => 'Custo Total',
      'totalCostCurrency' => 'Custo Total (Currency)',
      'totalCostConverted' => 'Custo Total (Converted)',
      'totalRevenue' => 'Receita Total',
      'totalRevenueCurrency' => 'Receita Total (Currency)',
      'totalRevenueConverted' => 'Receita Total (Converted)',
      'type' => 'Serviços Prestados',
      'update' => 'Update',
      'version' => 'Versão',
      'winProbability' => 'Probabilidade de Fechamento',
      'tax' => 'Impostos (%)',
      'proposalDueDate' => 'Data Limite (Envio da Proposta)',
      'createVersion' => 'Criar Versão',
      'requester' => 'Solicitante',
      'createBilling' => 'Criar Faturamento',
      'billing' => 'Faturamento'
    ],
    'labels' => [
      'Add Item' => 'Add Item',
      'Add Products' => 'Add Products',
      'Create Service' => 'Create Service',
      'Items' => 'Items',
      'Select Product' => 'Select Product'
    ],
    'links' => [
      'invoices' => 'Invoices',
      'items' => 'Items',
      'quotes' => 'Quotes',
      'salesOrders' => 'Sales Orders',
      'documents' => 'Documentos',
      'productBrand' => 'Fabricante',
      'servicesVersionses' => 'Service Versions'
    ],
    'options' => [
      'billingSituation' => [
        'Aguardando para Faturar' => 'Aguardando para Faturar',
        'Em Faturamento' => 'Em Faturamento',
        'Faturado' => 'Faturado',
        'Serviço Free' => 'Free'
      ],
      'billingType' => [
        '' => '',
        'Cliente' => 'Cliente',
        'Revenda' => 'Revenda'
      ],
      'stage' => [
        '' => '',
        'Pendente de informação' => 'Pendente de informação',
        'Enviada' => 'Enviada',
        'Possível' => 'Em negociação',
        'Revisado' => 'Revisado',
        'Em vias de fechamento' => 'Em vias de fechamento',
        'Ganho' => 'Ganho',
        'Perdido / Cancelado' => 'Perdido / Cancelado',
        'Criação Indevida' => 'Criação Indevida',
        'Ainda temos chance' => 'Ainda temos chance',
        'Faturado' => 'Faturado',
        'A faturar' => 'A faturar',
        'Aguardando Checklist' => 'Aguardando Checklist',
        'Pré Vendas' => 'Pré Vendas',
        'Serviço WIP' => 'Serviço WIP',
        'Serviço Finalizado' => 'Serviço Finalizado'
      ],
      'faturamento' => [
        '' => '',
        'Faturado' => 'Faturado',
        'Será Faturado' => 'Será Faturado',
        'Aguardando Pedido' => 'Aguardando Pedido',
        'Em negociação' => 'Em negociação'
      ],
      'serviceType' => [
        '' => '',
        'Serviços Profissionais' => 'Serviços Profissionais',
        'Serviços Cloud' => 'Serviços Cloud',
        'Treinamento' => 'Treinamentos'
      ],
      'opportunityType' => [
        '' => '',
        'Pagamento' => 'Pagamento',
        'Recebimento (Venda)' => 'Recebimento (Venda)'
      ],
      'projectType' => [
        '' => '',
        'Partner to Partner' => 'Partner to Partner',
        'Ficha de Oferta' => 'Ficha de Oferta',
        'MOSP para CSP' => 'MOSP para CSP'
      ],
      'serviceActivity' => [
        '' => '',
        'Serviço de DNS' => 'Serviço de DNS',
        'Migração de recursos do Azure entre Tenants' => 'Migração de recursos do Azure entre Tenants',
        'Migração de VM' => 'Migração de VM',
        'Suporte' => 'Suporte',
        'Implementação de Serviço de DLP' => 'Implementação de Serviço de DLP',
        'Implementação' => 'Implementação'
      ],
      'type' => [
        'Cloud' => 'Cloud',
        'Serviços Profissionais' => 'Serviços Profissionais',
        'Treinamento' => 'Treinamento',
        'Suporte' => 'Suporte',
        'Educação' => 'Educação'
      ],
      'winProbability' => [
        0 => '0',
        10 => '10%',
        20 => '20%',
        40 => '40%',
        80 => '80%',
        100 => '100%'
      ]
    ],
    'presetFilters' => [],
    'tooltips' => [
      'installationMarkupPercentage' => 'Valores entre 0-100.'
    ]
  ],
  'ServiceItem' => [
    'fields' => [
      'amount' => 'Amount',
      'amountConverted' => 'Amount (Converted)',
      'amountCurrency' => 'Amount (Currency)',
      'description' => 'Description',
      'name' => 'Name',
      'order' => 'Line Number',
      'product' => 'Product',
      'qty' => 'Qty',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'service' => 'Servicio',
      'unitPrice' => 'Unit Price',
      'unitPriceConverted' => 'Unit Price (Converted)',
      'unitPriceCurrency' => 'Unit Price (Currency)'
    ],
    'labels' => [
      'Services' => 'Services'
    ],
    'links' => [
      'product' => 'Product',
      'service' => 'Service'
    ]
  ],
  'Project' => [
    'labels' => [
      'Create Project' => 'Create Project',
      'Boards' => 'Boards',
      'Roles' => 'Roles',
      'Select Role' => 'Select Role',
      'Settings' => 'Settings',
      'Show Completed' => 'Show Completed',
      'Clone' => 'Clone'
    ],
    'fields' => [
      'board' => 'Board',
      'status' => 'Status',
      'dateStart' => 'Date Start',
      'dateEnd' => 'Date End',
      'account' => 'Account',
      'activeGroup' => 'Active Group',
      'members' => 'Members',
      'memberRole' => 'Member Role',
      'ganttView' => 'Gantt View'
    ],
    'links' => [
      'board' => 'Board',
      'tasks' => 'Tasks',
      'groups' => 'Groups',
      'activeGroup' => 'Active Group',
      'account' => 'Account',
      'meetings' => 'Meetings',
      'calls' => 'Calls',
      'emails' => 'Emails',
      'members' => 'Members',
      'memberRole' => 'Member Role'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Active' => 'Active',
        'Closed' => 'Closed',
        'Paused' => 'Paused',
        'Canceled' => 'Canceled'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'closed' => 'Closed'
    ],
    'boolFilters' => [
      'own' => 'Owned',
      'member' => 'Participating In'
    ],
    'messages' => [
      'cloned' => 'Cloned project [{name}]({link}) has been created.',
      'ganttViewDisabled' => 'Gantt view is disabled for the project.',
      'holdCtrlToSelectMultiple' => 'Hold CTRL to select multiple tasks',
      'cannotRemoveUsedInTask' => 'Cannot remove the project as there are related tasks.'
    ],
    'detailViewModes' => [
      'plan' => 'Plan',
      'board' => 'Board',
      'gantt' => 'Gantt'
    ],
    'tabs' => [
      'stream' => 'Stream',
      'team' => 'Team',
      'tasks' => 'Tasks'
    ],
    'otherPanels' => [
      'include' => 'Include'
    ],
    'otherFields' => [
      'role' => 'Role',
      'withTasks' => 'Tasks',
      'withMembers' => 'Members',
      'withOwners' => 'Task Owners',
      'withAssignees' => 'Task Assignees',
      'withAttachments' => 'Attachments'
    ],
    'actions' => [
      'changeRole' => 'Change Role'
    ],
    'ganttScales' => [
      'week' => 'Week',
      'twoWeeks' => 'Two Weeks',
      'month' => 'Month',
      'twoMonths' => 'Two Months',
      'sixMonths' => 'Six Months',
      'year' => 'Year'
    ]
  ],
  'ProjectBoard' => [
    'labels' => [
      'Create ProjectBoard' => 'Create Board'
    ],
    'fields' => [
      'status' => 'Status'
    ],
    'links' => [
      'columns' => 'Stages',
      'projects' => 'Projects'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ]
    ],
    'messages' => [
      'cannotRemoveUsed' => 'Cannot remove the board as it\'s used in a project.',
      'cannotRemoveUsedInTask' => 'Cannot remove the board as there are tasks that use it.'
    ],
    'presetFilters' => [
      'actual' => 'Open'
    ]
  ],
  'ProjectColumn' => [
    'labels' => [
      'Create ProjectColumn' => 'Create Stage',
      'Move Up' => 'Move Up',
      'Move Down' => 'Move Down'
    ],
    'fields' => [
      'board' => 'Board',
      'order' => 'Order',
      'mappedStatus' => 'Mapped Status'
    ],
    'links' => [
      'board' => 'board',
      'tasks' => 'Tasks'
    ],
    'options' => [
      'name' => [
        'To Do' => 'To Do',
        'In Progress' => 'In Progress',
        'Review' => 'Review',
        'Done' => 'Done'
      ]
    ],
    'messages' => [
      'cannotRemoveUsedInTask' => 'Cannot remove the column as there are tasks that use it.'
    ]
  ],
  'ProjectGroup' => [
    'labels' => [
      'Create ProjectGroup' => 'Create Group',
      'Edit Group' => 'Edit Group',
      'Remove Group' => 'Remove Group',
      'Reorder Groups' => 'Reorder Groups'
    ],
    'fields' => [
      'project' => 'Project',
      'order' => 'Order',
      'color' => 'Color',
      'taskPlacement' => 'New Task Placement'
    ],
    'links' => [
      'project' => 'Project',
      'tasks' => 'Tasks'
    ],
    'strings' => [
      'defaultGroupName' => 'Group'
    ],
    'messages' => [
      'cannotRemoveUsedInTask' => 'Cannot remove a group with tasks in it.'
    ]
  ],
  'ProjectRole' => [
    'labels' => [
      'Create ProjectRole' => 'Create Project Role',
      'Task' => 'Task'
    ],
    'fields' => [
      'taskCreate' => 'Task Create',
      'taskRead' => 'Task Read',
      'taskStream' => 'Task Stream',
      'taskEdit' => 'Task Edit',
      'taskColumnEdit' => 'Task Stage Edit',
      'taskDelete' => 'Task Delete',
      'taskAssignment' => 'Task Assignment',
      'create' => 'Create',
      'read' => 'Read',
      'stream' => 'Stream',
      'edit' => 'Edit',
      'columnEdit' => 'Stage Edit',
      'delete' => 'Delete',
      'cancel' => 'Cancel',
      'assignment' => 'Assignment'
    ],
    'options' => [
      'levelList' => [
        'yes' => 'yes',
        'assigned' => 'assigned',
        'own' => 'own',
        'no' => 'no'
      ]
    ]
  ],
  'ProjectTask' => [
    'labels' => [
      'Create ProjectTask' => 'Create Task',
      'Create Milestone' => 'Create Milestone',
      'Complete' => 'Complete',
      'Cancel' => 'Cancel',
      'Change Column' => 'Change Stage',
      'Moving' => 'Moving',
      'Moved to Group' => 'Moved to Group',
      'Moved' => 'Moved',
      'Add Dependency' => 'Add Dependency',
      'Remove Dependency' => 'Remove Dependency',
      'Sub-Task' => 'Sub-Task',
      'Completed' => 'Completed'
    ],
    'fields' => [
      'project' => 'Project',
      'fromTasks' => 'Dependent On',
      'parentTask' => 'Parent Task',
      'subTasks' => 'Sub-Tasks',
      'dependencyTaskType' => 'Dependency Type',
      'group' => 'Group',
      'groupColor' => 'Group Color',
      'groupOrder' => 'Group Order',
      'status' => 'Status',
      'column' => 'Stage',
      'priority' => 'Priority',
      'order' => 'Order',
      'dateStart' => 'Date Start',
      'dateEnd' => 'Date End',
      'points' => 'Points',
      'hours' => 'Hours',
      'attachments' => 'Attachments',
      'timeline' => 'Timeline',
      'owner' => 'Owner',
      'combinedOrder' => 'Combined Order',
      'boardOrder' => 'Board Order',
      'type' => 'Type',
      'completedAt' => 'Completed At',
      'assignedUser' => 'Assignee',
      'actualSubTaskCount' => 'Number of actual sub-tasks',
      'cCountry' => 'Pais',
      'cTag' => 'Etiqueta',
      'cTeam' => 'Equipo'
    ],
    'links' => [
      'project' => 'Project',
      'fromTasks' => 'From Tasks',
      'toTasks' => 'To Tasks',
      'parentTask' => 'Parent Task',
      'subTasks' => 'Sub-Tasks',
      'group' => 'Group',
      'column' => 'Stage',
      'owner' => 'Owner'
    ],
    'options' => [
      'status' => [
        'Not Started' => 'Not Started',
        'Started' => 'Started',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled',
        'Deferred' => 'Deferred'
      ],
      'priority' => [
        'Low' => 'Low',
        'Normal' => 'Normal',
        'High' => 'High',
        'Urgent' => 'Urgent'
      ],
      'dependencyTaskType' => [
        'fs' => 'Finish to Start',
        'ss' => 'Start to Start',
        'ff' => 'Finish to Finish',
        'sf' => 'Start to Finish'
      ],
      'dependencyTaskTypeShort' => [
        'fs' => 'FS',
        'ss' => 'SS',
        'ff' => 'FF',
        'sf' => 'SF'
      ],
      'type' => [
        'Task' => 'Task',
        'Milestone' => 'Milestone'
      ],
      'cCountry' => [
        'LAC' => 'LAC',
        'Brasil' => 'Brasil'
      ],
      'cTag' => [
        'Ready to deploy' => 'Ready to deploy',
        'Ready to test' => 'Ready to test',
        'Blocked' => 'Bloqueado',
        'Recurring' => 'Recurrente'
      ],
      'cTeam' => [
        'Microsoft' => 'Microsoft',
        'AWS' => 'AWS',
        'Google' => 'Google'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed',
      'actualParent' => 'Open Parent-Level',
      'completedParent' => 'Completed Parent-Level',
      'planParent' => 'Plan Parent-Level',
      'todays' => 'Today\'s',
      'overdue' => 'Overdue'
    ],
    'boolFilters' => [
      'own' => 'Owned'
    ],
    'actions' => [
      'complete' => 'Complete',
      'changeColumn' => 'Change Stage',
      'moveToTop' => 'Move to Top',
      'moveToBottom' => 'Move to Bottom'
    ],
    'massActions' => [
      'complete' => 'Complete'
    ],
    'messages' => [
      'movedToTop' => 'Moved to Top',
      'movedToBottom' => 'Moved to Bottom',
      'massCompleteDone' => '{count} tasks completed',
      'massCompleteConfirmation' => 'Are you sure you want to complete selected tasks?',
      'noEditAccess' => 'No edit access.',
      'cancelConfirmation' => 'Are you sure you want to cancel the task?',
      'cannotCreateSubTaskInCompletedTask' => 'Cannot create a sub-task in a completed task.',
      'cannotCreateSubTaskInCanceledTask' => 'Cannot create a sub-task in a canceled task.',
      'cannotChangeSubTaskGroup' => 'A sub-task\'s group cannot be changed without a parent task.',
      'cannotDeleteSubTaskNotCompleted' => 'Cannot delete a task with non-completed sub-tasks.',
      'cannotCompleteSubTaskNotCompleted' => 'Cannot complete a task without completing all sub-tasks.',
      'cannotCompleteAlreadyCompleted' => 'The task is already completed.',
      'cannotCompleteAlreadyCanceled' => 'The task is already canceled.',
      'cannotCompleteFromTaskNotStarted' => '[{fromName}](#ProjectTask/view/{fromId}) needs to be **started** before this task can be completed.',
      'cannotCompleteFromTaskNotCompleted' => '[{fromName}](#ProjectTask/view/{fromId}) needs to be **completed** before this task can be completed.',
      'cannotStartFromTaskNotStarted' => '[{fromName}](#ProjectTask/view/{fromId}) needs to be **started** before this task can be started.',
      'cannotStartFromTaskNotCompleted' => '[{fromName}](#ProjectTask/view/{fromId}) needs to be **completed** before this task can be started.'
    ],
    'strings' => [
      'hasSubTasks' => 'Has Sub-Tasks'
    ]
  ],
  'AWS' => [
    'fields' => [
      'tier' => 'Nivel',
      'account' => 'Cuenta',
      'productBrand' => 'Product Brand',
      'sumSelect' => 'SumSelect',
      'partnerType' => 'Tipo de Partner',
      'competency' => 'Competencia',
      'partnerBusinessPlan' => 'Partner Business Plan',
      'launchedOppsAmount' => 'Launched Opps Amount',
      'launchedOppsAmountCurrency' => 'Launched Opps Amount (Currency)',
      'launchedOppsAmountConverted' => 'Launched Opps Amount (Converted)',
      'accountCountry' => 'Pais de la Cuenta',
      'city' => 'Ciudad',
      'region' => 'Region',
      'country' => 'Pais',
      'levelCheck' => 'Level Check',
      'accounts' => 'Cuentas',
      'aWSAccreditedProfessionalsBussines' => 'Accredited Professionals - Bussines',
      'aWSAccreditedProfessionalsTechnical' => 'Accredited Professionals - Technical',
      'aWSFoundationalCertifiedIndividuals' => 'Foundational Certified individuals',
      'aWSTechnicalCertifiedIndividuals' => 'Technical Certified individuals',
      'aWSTechnicalCertifiedIndividualsAssociate' => 'Technical Certified Individuals - Associate',
      'aWSTechnicalCertifiedIndividualsProOrSpecialty' => 'Technical Certified Individuals - Pro or Specialt',
      'customerSatisfactionResponses' => 'Customer Satisfaction Responses',
      'launchedOppsCount' => 'Launched Opps Count',
      'publiclyReferenceableCustomers' => 'Publicly Referenceable Customers',
      'account1' => 'Cuentas',
      'specialities' => 'Especialidades',
      'countCompetency' => 'Conteo de Competencias',
      'countEspecialidades' => 'Conteo de Especialidades',
      'lastupdate' => 'AVT Report',
      'awsVersions' => 'AWS Versions',
      'technicalprogram' => 'Technical Program Validations',
      'opportunities' => 'Opportunities',
      'update' => 'Crear Version',
      'accountsAWS' => 'Cuentas AWS',
      'levelCheckCustomerSuccessThinkBig' => 'Level Check - Customer Success (Think Big)',
      'levelCheckExperienceThinkBig' => 'Level Check - Experience (Think Big)',
      'levelCheckKnowledgeThinkBig' => 'Level Check - Knowledge (Think Big)',
      'levelCheckThinkBig' => 'Level Check (Think Big)',
      'levelCheckCustomerSuccess' => 'LevelCheck -  Customer Success',
      'levelCheckExperience' => 'LevelCheck - Experience',
      'levelCheckKnowledge' => 'LevelCheck - Knowledge',
      'sumselectCustomerSuccess' => 'Sumselect - Customer Success',
      'sumselectExperience' => 'Sumselect - Experience',
      'sumselectKnowledge' => 'Sumselect - Knowledge',
      'dataAnalytics' => 'Data & Analytics',
      'oracle' => 'Oracle',
      'devOps' => 'DevOps',
      'security' => 'Security',
      'networkingConsultingCompetency' => 'Networking Consulting Competency',
      'government' => 'Government',
      'education' => 'Education',
      'sAP' => 'SAP',
      'financialServices' => 'Financial Services',
      'storage' => 'Storage',
      'migration' => 'Migration',
      'machineLearningConsultingPartner' => 'Machine Learning Consulting Partner',
      'publicSafetyServicesCompetency' => 'Public Safety Services Competency',
      'cloudOperationsServicesCompetency' => 'Cloud Operations Services Competency',
      'travelAndHospitality' => 'Travel and Hospitality',
      'resilienceServicesCompetency' => 'Resilience Services Competency',
      'level1MSSP' => 'Level 1 MSSP',
      'retail' => 'Retail',
      'advertisingAndMarketingTechnologyServicesCompetency' => 'Advertising and Marketing Technology Services Competency',
      'ioTConsulting' => 'IoT Consulting',
      'microsoftWorkloads' => 'Microsoft Workloads',
      'nonprofit' => 'Nonprofit',
      'migrationAndModernizationISVPartner' => 'Migration and Modernization ISV Partner',
      'digitalWorkplace' => 'Digital Workplace',
      'smallAndMediumBusinessServicesCompetency' => 'Small and Medium Business Services Competency',
      'amazonEC2ForWindowsServer' => 'Amazon EC2 for Windows Server',
      'amazonCloudFront' => 'Amazon CloudFront',
      'amazonEKSDelivery' => 'Amazon EKS Delivery',
      'amazonRedshift' => 'Amazon Redshift',
      'amazonRDS' => 'Amazon RDS',
      'aWSWAF' => 'AWS WAF',
      'amazonAPIGateway' => 'Amazon API Gateway',
      'aWSGlueDelivery' => 'AWS Glue Delivery',
      'amazonEC2SystemsManager' => 'Amazon EC2 Systems Manager',
      'aWSControlTowerDelivery' => 'AWS Control Tower Delivery',
      'amazonEMR' => 'Amazon EMR',
      'amazonQuickSight' => 'Amazon QuickSight',
      'aWSCloudFormation' => 'AWS CloudFormation',
      'amazonConnect' => 'Amazon Connect',
      'aWSLambda' => 'AWS Lambda',
      'aWSServerMigrationService' => 'AWS Server Migration Service',
      'amazonKinesis' => 'Amazon Kinesis',
      'aWSConfig' => 'AWS Config',
      'amazonDynamoDB' => 'Amazon DynamoDB',
      'aWSDirectConnect' => 'AWS Direct Connect',
      'aWSDatabaseMigrationService' => 'AWS Database Migration Service',
      'noLevel' => 'Without level',
      'accountsdSA' => 'Tiene DSA',
      'sPMSID' => 'SPMS ID',
      'sPMSIDCountry' => 'SPMS ID Pais',
      'aWSGravitonDelivery' => 'AWS Graviton Delivery',
      'amazonECSDelivery' => 'Amazon ECS Delivery',
      'amazonMSKDelivery' => 'Amazon MSK Delivery',
      'amazonOpenSearchServiceDelivery' => 'Amazon OpenSearch Service Delivery',
      'saaS' => 'SaaS',
      'mediaEntertainmentServicesCompetency' => 'Media & Entertainment Services Competency',
      'generativeAIServicesCompetency' => 'Generative AI Services Competency',
      'consumerGoodsServicesCompetency' => 'Consumer Goods Services Competency',
      'aWSTransferFamilyDelivery' => 'AWS Transfer Family Delivery',
      'segment' => 'Segmento',
      'focus' => 'Focus'
    ],
    'links' => [
      'meetings' => 'Presentaciones',
      'calls' => 'Llamadas',
      'tasks' => 'Tareas',
      'account' => 'Cuenta',
      'productBrand' => 'Product Brand',
      'accountCountry' => 'Pais de la Cuenta',
      'accounts' => 'Cuentas',
      'account1' => 'Cuentas',
      'awsVersions' => 'AWS Versions',
      'opportunities' => 'Opportunities',
      'accountsAWS' => 'Cuentas AWS'
    ],
    'labels' => [
      'Create AWS' => 'Crear Partner Program - Lista'
    ],
    'options' => [
      'tier' => [
        '' => '',
        'Select' => 'Select',
        'Advanced' => 'Advanced',
        'Premier' => 'Premier',
        'Registered' => 'Registered',
        'Sin Nivel' => 'Sin Nivel'
      ],
      'competency' => [
        'Vacio' => 'Vacio',
        'Data & Analytics' => 'Data & Analytics',
        'Networking Consulting Competency' => 'Networking Consulting Competency',
        'Oracle' => 'Oracle',
        'DevOps' => 'DevOps',
        'Security' => 'Security',
        'Government' => 'Government',
        'Education' => 'Education',
        'SAP' => 'SAP',
        'Financial Services' => 'Financial Services',
        'Storage' => 'Storage',
        'Migration' => 'Migration',
        'Machine Learning Consulting Partner' => 'Machine Learning Consulting Partner',
        'Public Safety Services Competency' => 'Public Safety Services Competency',
        'Cloud Operations Services Competency' => 'Cloud Operations Services Competency',
        'Travel and Hospitality' => 'Travel and Hospitality',
        'Resilience Services Competency' => 'Resilience Services Competency',
        'Level 1 MSSP' => 'Level 1 MSSP',
        'Retail' => 'Retail',
        'Advertising and Marketing Technology Services Competency' => 'Advertising and Marketing Technology Services Competency',
        'IoT Consulting' => 'IoT Consulting',
        'Microsoft Workloads' => 'Microsoft Workloads',
        'Nonprofit' => 'Nonprofit',
        'Migration and Modernization ISV Partner' => 'Migration and Modernization ISV Partner',
        'Digital Workplace' => 'Digital Workplace',
        'Small and Medium Business Services Competency' => 'Small and Medium Business Services Competency',
        'SaaS' => 'SaaS',
        'Media & Entertainment Services Competency' => 'Media & Entertainment Services Competency',
        'Generative AI Services Competency' => 'Generative AI Services Competency',
        'Consumer Goods Services Competency' => 'Consumer Goods Services Competency',
        'AWS Database Migration Service' => 'AWS Database Migration Service'
      ],
      'partnerBusinessPlan' => [
        0 => '0',
        1 => '1'
      ],
      'levelCheck' => [
        'Ready to Select' => 'Ready to Select',
        'Ready to Advanced' => 'Ready to Advanced',
        'Ready to Premier' => 'Ready to Premier'
      ],
      'specialities' => [
        'Amazon EC2 for Windows Server' => 'Amazon EC2 for Windows Server',
        'Amazon CloudFront' => 'Amazon CloudFront',
        'Amazon EKS Delivery' => 'Amazon EKS Delivery',
        'Amazon Redshift' => 'Amazon Redshift',
        'Amazon RDS' => 'Amazon RDS',
        'AWS WAF' => 'AWS WAF',
        'Amazon API Gateway' => 'Amazon API Gateway',
        'AWS Glue Delivery' => 'AWS Glue Delivery',
        'Amazon EC2 Systems Manager' => 'Amazon EC2 Systems Manager',
        'AWS Control Tower Delivery' => 'AWS Control Tower Delivery',
        'Amazon EMR' => 'Amazon EMR',
        'Amazon QuickSight' => 'Amazon QuickSight',
        'AWS CloudFormation' => 'AWS CloudFormation',
        'Amazon Connect' => 'Amazon Connect',
        'AWS Lambda' => 'AWS Lambda',
        'AWS Server Migration Service' => 'AWS Server Migration Service',
        'Amazon Kinesis' => 'Amazon Kinesis',
        'AWS Config' => 'AWS Config',
        'Amazon DynamoDB' => 'Amazon DynamoDB',
        'AWS Direct Connect' => 'AWS Direct Connect',
        'AWS Database Migration Service' => 'AWS Database Migration Service',
        'AWS Graviton Delivery' => 'AWS Graviton Delivery',
        'AWS Transfer Family Delivery' => 'AWS Transfer Family Delivery',
        ' Amazon ECS Delivery' => ' Amazon ECS Delivery',
        'Amazon MSK Delivery' => 'Amazon MSK Delivery',
        'Amazon OpenSearch Service Delivery' => 'Amazon OpenSearch Service Delivery'
      ],
      'levelCheckCustomerSuccessThinkBig' => [
        'Think Big for Select' => 'Think Big for Select',
        'Think Big for Advanced' => 'Think Big for Advanced'
      ],
      'levelCheckExperienceThinkBig' => [
        'Think Big for Select' => 'Think Big for Select',
        'Think Big for Advanced' => 'Think Big for Advanced'
      ],
      'levelCheckKnowledgeThinkBig' => [
        'Think Big for Select' => 'Think Big for Select',
        'Think Big for Advanced' => 'Think Big for Advanced'
      ],
      'levelCheckThinkBig' => [
        'Think Big for Select' => 'Think Big for Select',
        'Think Big for Advanced' => 'Think Big for Advanced'
      ],
      'levelCheckCustomerSuccess' => [
        'Think Big for Advanced' => 'Think Big for Advanced',
        'Ready to Advanced' => 'Ready to Advanced',
        'Ready to Premier' => 'Ready to Premier',
        'Ready to Select' => 'Ready to Select'
      ],
      'levelCheckExperience' => [
        'Ready to Select' => 'Ready to Select',
        'Ready to Advanced' => 'Ready to Advanced',
        'Ready to Premium' => 'Ready to Premium'
      ],
      'levelCheckKnowledge' => [
        'Ready to Select' => 'Ready to Select',
        'Ready to Advanced' => 'Ready to Advanced',
        'Ready to Premier' => 'Ready to Premier'
      ],
      'segment' => [
        '' => '',
        'PS' => 'PS',
        'CS' => 'CS'
      ]
    ],
    'tooltips' => [
      'update' => '(PT-BR) Após selecionar esta opção, clique em "Salvar" ou "Atualizar" e atualize a sua página (F5) para que a versão apareça na aba de registro de versões.

(Español) Después de seleccionar esta opción, haga clic en "Guardar" o "Actualizar" y actualice su página (F5) para que la versión aparezca en la pestaña de registro de versiones.

(English)After selecting this option, click "Save" or "Update" and refresh your page (F5) to have the version appear in the version log tab.',
      'noLevel' => '(English) After selecting this option, click "Save" to update the level.',
      'accountsdSA' => '(PT-BR) Selecione se a conta tem DSA

(Español) Seleccione si la cuenta tiene DSA

(English) Select if the account has DSA',
      'levelCheck' => '(PT-BR) Verificação para saber se você está pronto para avançar para o próximo nível.

(Español) Verificación para saber si esta listo para avanzar de nivel.

(English) Check to see if you are ready to advance to the next level.',
      'levelCheckCustomerSuccess' => '(PT-BR) Verificação para saber se você está pronto para avançar para o próximo nível.

(Español) Verificación para saber si esta listo para avanzar de nivel.

(English) Check to see if you are ready to advance to the next level.',
      'levelCheckExperience' => '(PT-BR) Verificação para saber se você está pronto para avançar para o próximo nível.

(Español) Verificación para saber si esta listo para avanzar de nivel.

(English) Check to see if you are ready to advance to the next level.',
      'levelCheckKnowledge' => '(PT-BR) Verificação para saber se você está pronto para avançar para o próximo nível.

(Español) Verificación para saber si esta listo para avanzar de nivel.

(English) Check to see if you are ready to advance to the next level.'
    ]
  ],
  'AWSVersions' => [
    'links' => [
      'aws' => 'AWS Partner Program'
    ],
    'labels' => [
      'Create AWSVersions' => 'Crear AWS Versions'
    ],
    'fields' => [
      'awsAccreditedProfessionalsBussines' => 'AWS Accredited Professionals - Business',
      'awsAccreditedProfessionalsTechnical' => 'AWS Accredited Professionals - Technical',
      'awsFoundationalCertifiedIndividuals' => 'AWS Foundational Certified individuals',
      'awsTechnicalCertifiedIndividuals' => 'AWS Technical Certified individuals',
      'awsTechnicalCertifiedIndividualsAssociate' => 'Technical Certified Individuals - Associate',
      'awsTechnicalCertifiedIndividualsProOrSpecialty' => 'Technical Certified Individuals - Pro or Specialt',
      'competency' => 'Competency',
      'countCompetency' => 'Quantity of Skills',
      'countEspecialidades' => 'Quantity of Specialties',
      'customerSatisfactionResponses' => 'Customer Satisfaction Responses',
      'lastupdate' => 'AVT Report',
      'launchedOppsAmount' => 'Launched Opps Amount',
      'launchedOppsAmountCurrency' => 'Launched Opps Amount (Currency)',
      'launchedOppsAmountConverted' => 'Launched Opps Amount (Converted)',
      'launchedOppsCount' => 'Launched Opps Count',
      'partnerBusinessPlan' => 'Partner Business Plan',
      'partnerType' => 'Partner Type',
      'publiclyReferenceableCustomers' => 'Publicly Referenceable Customers',
      'tier' => 'Tier',
      'specialities' => 'Specialties',
      'aws' => 'AWS Partner Program',
      'technicalprogram' => 'Technical Program Validations',
      'dSA' => 'DSA',
      'dataCompetencias' => 'Fecha Competencias',
      'dataEspecialidades' => 'Fecha Especialidades',
      'sPMSID' => 'SPMS ID'
    ],
    'options' => [
      'competency' => [
        'Data & Analytics' => 'Data & Analytics',
        'Oracle' => 'Oracle',
        'DevOps' => 'DevOps',
        'Security' => 'Security',
        'Networking Consulting Competency' => 'Networking Consulting Competency',
        'Government' => 'Government',
        'Education' => 'Education',
        'SAP' => 'SAP',
        'Financial Services' => 'Financial Services',
        'Storage' => 'Storage',
        'Migration' => 'Migration',
        'Machine Learning Consulting Partner' => 'Machine Learning Consulting Partner',
        'Public Safety Services Competency' => 'Public Safety Services Competency'
      ],
      'partnerBusinessPlan' => [
        0 => '0',
        1 => '1'
      ],
      'tier' => [
        '' => '',
        'Registered' => 'Registered',
        'Select' => 'Select',
        'Advanced' => 'Advanced',
        'Premier' => 'Premier'
      ],
      'specialities' => [
        'Amazon EC2 for Windows Server' => 'Amazon EC2 for Windows Server',
        'Amazon CloudFront' => 'Amazon CloudFront',
        'Amazon EKS Delivery' => 'Amazon EKS Delivery',
        'Amazon Redshift' => 'Amazon Redshift',
        'Amazon RDS' => 'Amazon RDS',
        'AWS WAF' => 'AWS WAF',
        'Amazon API Gateway' => 'Amazon API Gateway',
        'AWS Glue Delivery' => 'AWS Glue Delivery',
        'Amazon EC2 Systems Manager' => 'Amazon EC2 Systems Manager',
        'AWS Control Tower Delivery' => 'AWS Control Tower Delivery',
        'Amazon EMR' => 'Amazon EMR',
        'Amazon QuickSight' => 'Amazon QuickSight',
        'AWS CloudFormation' => 'AWS CloudFormation',
        'Amazon Connect' => 'Amazon Connect',
        'AWS Lambda' => 'AWS Lambda',
        'AWS Server Migration Service' => 'AWS Server Migration Service',
        'Amazon Kinesis' => 'Amazon Kinesis',
        'AWS Config' => 'AWS Config',
        'Amazon DynamoDB' => 'Amazon DynamoDB',
        'AWS Direct Connect' => 'AWS Direct Connect',
        'AWS Database Migration Service' => 'AWS Database Migration Service'
      ],
      'dSA' => [
        'Si' => 'Si'
      ]
    ]
  ],
  'AccountContent' => [
    'fields' => [
      'account' => 'Account',
      'sourceContent' => 'Source Content'
    ],
    'links' => [
      'account' => 'Account'
    ],
    'labels' => [
      'Create AccountContent' => 'Crear Account content'
    ],
    'options' => [
      'sourceContent' => [
        '' => '',
        'Renewals' => 'Renewals',
        'AI Content' => 'AI Content'
      ]
    ]
  ],
  'AccountVBM' => [
    'fields' => [
      'account' => 'Cuenta',
      'contact' => 'Contacto',
      'contracts' => 'Contratos',
      'iSV' => 'ISV',
      'msftProgram' => 'Programa Microsoft',
      'unity' => 'Unidad',
      'reseller' => 'Reseller',
      'country' => 'Pais',
      'paises' => 'País'
    ],
    'links' => [
      'account' => 'Cuenta',
      'contact' => 'Contacto',
      'contracts' => 'Contratos'
    ],
    'labels' => [
      'Create AccountVBM' => 'Crear Cuenta VBM'
    ],
    'options' => [
      'iSV' => [
        '' => 'No',
        'Yes' => 'Si'
      ],
      'msftProgram' => [
        '' => 'Not apply',
        'CSU' => 'CSU',
        'CSU y TCO' => 'CSU y TCO',
        'CSU & TCO' => 'CSU & TCO'
      ],
      'unity' => [
        '' => '',
        'Velocity' => 'Velocity',
        'Worth' => 'Valor',
        'Telco' => 'Telco'
      ]
    ]
  ],
  'Analytics' => [
    'fields' => [
      'url' => 'Url',
      'contacts' => 'Contacts',
      'name' => 'Name',
      'appId' => 'App ID',
      'clientId' => 'Client Id',
      'clientsecret' => 'Client Secret',
      'params' => 'Parametros',
      'ratio' => 'Aspect Ratio',
      'reportId' => 'Report Id',
      'rocket' => 'Rocket',
      'workspace' => 'Workspace',
      'iframerate' => 'Iframe Rate',
      'embedParamCheck' => 'Embed Parameters Check'
    ],
    'links' => [
      'contacts' => 'Contactos'
    ],
    'labels' => [
      'Create Analytics' => 'Crear Analytics'
    ]
  ],
  'AssesmentCompany' => [
    'fields' => [
      'billingAddress' => 'Dirección de Facturación',
      'shippingAddress' => 'Dirección de Entrega',
      'website' => 'Sitio Web',
      'domain' => 'Domain',
      'assesmentStep' => 'AssesmentStep',
      'language' => 'Language'
    ],
    'links' => [
      'meetings' => 'Presentaciones',
      'calls' => 'Llamadas',
      'tasks' => 'Tareas'
    ],
    'labels' => [
      'Create AssesmentCompany' => 'Crear AssesmentCompany'
    ],
    'options' => [
      'assesmentStep' => [
        '' => '',
        'organizational' => 'organizational',
        'financial' => 'financial',
        'strategy' => 'strategy',
        'technology' => 'technology',
        'salesandmarketing' => 'salesandmarketing',
        'contact' => 'contact'
      ]
    ]
  ],
  'Aws' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create Aws' => 'Crear AWS'
    ]
  ],
  'BucketTimer' => [
    'fields' => [
      'migrations' => 'Migração',
      'bucket' => 'Bucket',
      'duration' => 'Duração',
      'endDate' => 'Data Final',
      'startDate' => 'Data de InÍcio',
      'label' => 'Rótulo'
    ],
    'links' => [
      'migrations' => 'Migração'
    ],
    'labels' => [
      'Create BucketTimer' => 'Crear Duração do Bucket'
    ],
    'options' => [
      'bucket' => [
        'Upside Pipeline' => 'Upside | Pipeline',
        'Sales | BDM' => 'Sales | BDM (Pendências)',
        'Pre - Sales' => 'Pre - Sales',
        'CSC | SSCloud' => 'CSC | SSCloud',
        'Geração Consumo' => 'Geração Consumo',
        'Consumo Estimado Concluído' => 'Consumo Estimado Concluído',
        'Cancelado' => 'Cancelado',
        'Fechado | Movimentação de Billing' => 'Fechado | Movimentação de Billing',
        'Validação Pré-vendas | CoE' => 'Validação Pré-vendas | CoE',
        'Jira | SSCLOUD' => 'Jira | SSCLOUD (Criação / Migração Organization)',
        'Acompanhamento | Consumo' => 'Acompanhamento | Consumo'
      ]
    ]
  ],
  'CAccountEndCustomer' => [
    'fields' => [
      'billingAddress' => 'Dirección de Facturación',
      'shippingAddress' => 'Dirección de Entrega',
      'website' => 'Sitio Web',
      'country' => 'Country',
      'sicCode' => 'Número de identificación fiscal: (TAX ID / NIT / RUC / CNPJ)',
      'region' => 'Region',
      'contacts' => 'Contacts',
      'billingAddressCountry' => 'billingAddressCountry',
      'shippingAddressCountry' => 'shippingAddressCountry'
    ],
    'links' => [
      'meetings' => 'Presentaciones',
      'calls' => 'Llamadas',
      'tasks' => 'Tareas',
      'contacts' => 'Contacts'
    ],
    'labels' => [
      'Create CAccountEndCustomer' => 'Crear Account End Customer'
    ],
    'options' => [
      'country' => [
        '' => '',
        'Argentina' => 'Argentina',
        'Bolivia' => 'Bolivia',
        'Brasil' => 'Brasil',
        'Costa Rica' => 'Costa Rica',
        'Chile' => 'Chile',
        'Colombia' => 'Colombia',
        'Dominican Republic' => 'Dominican Republic',
        'Ecuador' => 'Ecuador',
        'El Salvador' => 'El Salvador',
        'Guadelouope' => 'Guadelouope',
        'Guatemala' => 'Guatemala',
        'Honduras' => 'Honduras',
        'Mexico' => 'Mexico',
        'Panama' => 'Panama',
        'Paraguay' => 'Paraguay',
        'Peru' => 'Peru',
        'Puerto Rico' => 'Puerto Rico',
        'Uruguay' => 'Uruguay',
        'Venezuela' => 'Venezuela',
        'CCA' => 'CCA',
        'Caribe' => 'Caribe',
        'Santa Lucía' => 'Santa Lucía',
        'San vicente y las Granadinas' => 'San vicente y las Granadinas',
        'San Cristóbal y Nieves' => 'San Cristóbal y Nieves',
        'Jamaica' => 'Jamaica',
        'United States' => 'United States',
        'Belice' => 'Belice',
        'Haití' => 'Haití',
        'Guyana' => 'Guyana',
        'Granada' => 'Granada',
        'Cuba' => 'Cuba',
        'Barbados' => 'Barbados',
        'Bahamas' => 'Bahamas',
        'Antigua y barbuda' => 'Antigua y barbuda',
        'Nicaragua' => 'Nicaragua'
      ],
      'region' => [
        '' => '',
        'NOLA' => 'NOLA',
        'SOLA' => 'SOLA',
        'Brasil' => 'Brasil',
        'Mexico' => 'Mexico',
        'CCA' => 'CCA',
        'None LAC' => 'None LAC'
      ]
    ]
  ],
  'CDPSecurity' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create CDPSecurity' => 'Crear CDP Security'
    ]
  ],
  'CPB' => [
    'fields' => [
      'account' => 'Cuenta',
      'suresteps' => 'Suresteps',
      'productBrands' => 'Product Brand',
      'accounts' => 'Cuentas',
      'categoriaCPB' => 'Categoria CPB',
      'statusCPB' => 'Estado CPB',
      'dSETAWS' => 'DSET AWS',
      'vendor' => 'Fabricante',
      'country' => 'Pais',
      'region' => 'Region',
      'contacts' => 'Contactos',
      'accountsCPB' => 'Cuentas CPB',
      'contact' => 'Contacto',
      'submissionID' => 'Submission ID',
      'language' => 'Lenguaje',
      'oportunidad' => 'Oportunidades'
    ],
    'links' => [
      'account' => 'Cuenta',
      'suresteps' => 'Suresteps',
      'productBrands' => 'Brands',
      'accounts' => 'Cuentas',
      'contacts' => 'Contactos',
      'accountsCPB' => 'Cuentas CPB',
      'contact' => 'Contacto',
      'oportunidad' => 'Oportunidades'
    ],
    'labels' => [
      'Create CPB' => 'Crear Cloud Practice Builder - Lista'
    ],
    'options' => [
      'categoriaCPB' => [
        'Accelerator' => 'Accelerator',
        'Starter' => 'Starter',
        'Transformer' => 'Transformer',
        '' => '',
        '	Sem Categoria' => 'Sin Categoria'
      ],
      'statusCPB' => [
        'Concluido' => 'Concluido',
        'No Concluido ' => 'No Concluido '
      ],
      'dSETAWS' => [
        'Concluido ' => 'Concluido ',
        'No Concluido ' => 'No Concluido '
      ],
      'vendor' => [
        '' => '',
        'AWS' => 'AWS',
        'Google' => 'Google',
        'Microsoft' => 'Microsoft'
      ],
      'country' => [
        'Argentina ' => 'Argentina ',
        'Colombia ' => 'Colombia ',
        '' => '',
        'Bolivia' => 'Bolivia',
        'Brasil' => 'Brasil',
        'Chile' => 'Chile',
        'Costa Rica ' => 'Costa Rica ',
        'Dominican Republic' => 'Dominican Republic',
        'Ecuador' => 'Ecuador',
        'Guadeloupe' => 'Guadeloupe',
        'Guatemala' => 'Guatemala',
        'Honduras' => 'Honduras',
        'El Salvador' => 'El Salvador',
        'Mexico' => 'Mexico',
        'Panama ' => 'Panama ',
        'Paraguay ' => 'Paraguay ',
        'Peru' => 'Peru',
        'Puerto Rico ' => 'Puerto Rico ',
        'Uruguay' => 'Uruguay',
        'Venezuela' => 'Venezuela',
        'Colombia' => 'Colombia',
        'Caribe' => 'Caribe'
      ],
      'region' => [
        '' => '',
        'NOLA' => 'NOLA',
        'SOLA' => 'SOLA',
        'CCA' => 'CCA',
        'Brasil' => 'Brasil',
        'Mexico' => 'Mexico'
      ],
      'language' => [
        'Português' => 'pt',
        'English' => 'en',
        'Español' => 'es',
        '' => '',
        'pt' => 'Portugues',
        'en' => 'Ingles',
        'es' => 'Español'
      ]
    ]
  ],
  'CPBIoTAnalytic' => [
    'fields' => [
      'revenueIoTDigitisation' => '1. What percentage of your revenue accounts for IoT / Digitisation?',
      'revenueanalytics' => '2. What percentage of your revenue accounts for analytics?',
      'practiceforIoTData' => '3. How would you describe the position of your practice for IoT/Data?',
      'technologystack' => '4. In a typical IoT/analytics customer discussion or solution delivery, which vendors would be included in the technology stack?',
      'organisationdelivered' => '5. In a typical IoT/analytics solution delivery, which technologies and/or services has your organisation delivered?',
      'relationtoIoTdigitization' => '6. Which of the following are in progress or completed at your organisation in relation to IoT/digitization adoption activities?',
      'supportdevelopcapability' => '7. Please indicate which data solution components, your organisation needs support develop capability for. (select all that apply)',
      'businessmostbenefit' => '8. Where would your business most benefit from support to enable your IoT/Data strategy? (select all that apply)',
      'investinAnalytics' => '9. To meet your strategy, in what timeframe are you currently expecting to invest in Analytics?',
      'drivesyoursales' => '10. What drives your sales strategy for IoT/Digitisation?',
      'partoftheirecosystem' => '11. Are you engaging with any organisations who specialise in IoT with the aim of becoming part of their eco-system?',
      'solutionsinIoTDigitisation' => '12. Within your organisation is what is the sales pipeline stage for the majority of solutions in IoT/Digitisation?',
      'sizeforIoTdigitisation' => '13. What is your average deal size for IoT/digitisation?',
      'solutiondeliveryforIoT' => '14. In what areas have you established case studies that evidence your organisation\'s solution delivery for IoT?',
      'consultancyservicesforAnalytics' => '15. How do you deliver your professional consultancy services for Analytics & IoT/ Digitisation Solutions?',
      'designservicesforIoTDigitisation' => '16. How would you rate your design services for IoT/Digitisation?',
      'servicesforAnalytics' => '17. How would you rate your design services for Analytics?',
      'proofofconceptservicesforIoTDigitisation' => '18. How would you rate your proof of concept services for IoT/Digitisation?',
      'conceptservicesforAnalytics' => '19. How would you rate your proof of concept services for Analytics?',
      'implementationservicesforIoTDigitisation' => '20. How would you rate your implementation services for IoT/Digitisation?',
      'implementationservicesforAnalytics' => '21. How would you rate your implementation services for Analytics?',
      'solutionbyyourselfforIoT' => '22. In a typical solution delivery are you able to deliver the entire solution by yourself for IoT?',
      'resourceorganisationforIoTdata' => '23. Please indicate what resource you currently have in your organisation for IoT/data.',
      'analyticsadoptionactivities' => '24. Which of the following are in progress or completed at your organisation in relation to analytics adoption activities?',
      'dataintegrationqualitygovernancemarket' => '25. How would describe your organisation\'s awareness and knowledge of the data integration/quality/governance market?',
      'customersengagementIoTdigitisation' => '26. How would you describe your customers\' engagement with IoT/digitisation?',
      'account' => 'Account'
    ],
    'links' => [
      'account' => 'Account'
    ],
    'labels' => [
      'Create CPBIoTAnalytic' => 'Crear CPB IoT Analytic'
    ],
    'options' => [
      'revenueIoTDigitisation' => [
        '' => '',
        '>50%' => '>50%',
        '26% to 50%' => '26% to 50%',
        '11% to 25%' => '11% to 25%',
        '1% to 10%' => '1% to 10%',
        '0%' => '0%',
        'Prefer not to disclose' => 'Prefer not to disclose'
      ],
      'revenueanalytics' => [
        '' => '',
        '>50%' => '>50%',
        '26% to 50%' => '26% to 50%',
        '11% to 25%' => '11% to 25%',
        '1% to 10%' => '1% to 10%',
        '0%' => '0%',
        'Prefer not to disclose' => 'Prefer not to disclose'
      ],
      'practiceforIoTData' => [
        '' => '',
        'At inception' => 'At inception',
        'Developing strategy' => 'Developing strategy',
        'Investment budgeted' => 'Investment budgeted',
        'Developing' => 'Developing',
        'Optimising' => 'Optimising',
        'Mature' => 'Mature',
        'Not planning to have one' => 'Not planning to have one'
      ],
      'technologystack' => [
        '' => '',
        'Advantech' => 'Advantech',
        'Panduit' => 'Panduit',
        'Keonn' => 'Keonn',
        'Relayr' => 'Relayr',
        'Episensor' => 'Episensor',
        'Nexiona' => 'Nexiona',
        'IFM' => 'IFM',
        'Worldsensing' => 'Worldsensing',
        'Actility' => 'Actility',
        'Schneider Electric' => 'Schneider Electric',
        'Siemens' => 'Siemens',
        'Sigfox' => 'Sigfox',
        'Vodafone' => 'Vodafone',
        'Dell' => 'Dell',
        'Microsoft' => 'Microsoft',
        'IBM' => 'IBM',
        'HPE' => 'HPE',
        'Cisco' => 'Cisco',
        'AWS' => 'AWS',
        'Oracle' => 'Oracle',
        'Other' => 'Other'
      ],
      'organisationdelivered' => [
        '' => '',
        'Device connectivity' => 'Device connectivity',
        'Data forwarding' => 'Data forwarding',
        'Real-time monitoring' => 'Real-time monitoring',
        'GPS' => 'GPS',
        'Security' => 'Security',
        'Communication gateways' => 'Communication gateways',
        'Cloud management' => 'Cloud management',
        'Data design' => 'Data design',
        'Data analytics' => 'Data analytics',
        'Automation' => 'Automation',
        'Machine learning' => 'Machine learning',
        'Business intelligence' => 'Business intelligence',
        'Design' => 'Design',
        'Proof of concepts' => 'Proof of concepts',
        'Hosting' => 'Hosting',
        'Consultancy' => 'Consultancy',
        'Service management' => 'Service management',
        'Support' => 'Support'
      ],
      'relationtoIoTdigitization' => [
        '' => '',
        'Exploring' => 'Exploring',
        'Early stage set-up' => 'Early stage set-up',
        'Building resource' => 'Building resource',
        'Training & skills development' => 'Training & skills development',
        'Leveraging internally' => 'Leveraging internally',
        'Defining value proposition' => 'Defining value proposition',
        'Developing sales strategy' => 'Developing sales strategy',
        'Going to market' => 'Going to market',
        'Delivering solutions' => 'Delivering solutions',
        'Reviewing & refining' => 'Reviewing & refining'
      ],
      'supportdevelopcapability' => [
        '' => '',
        'IoT sensors' => 'IoT sensors',
        'Edge compute' => 'Edge compute',
        'Connectivity' => 'Connectivity',
        'IoT Platforms' => 'IoT Platforms',
        'Data Integration' => 'Data Integration',
        'Data Repository' => 'Data Repository',
        'Data Quality' => 'Data Quality',
        'Data Governance' => 'Data Governance',
        'Business Intelligence Reporting/Visualisation' => 'Business Intelligence Reporting/Visualisation',
        'Business Logic/Workflow' => 'Business Logic/Workflow',
        'AI/Cognitive/ML' => 'AI/Cognitive/ML',
        'Data Security' => 'Data Security'
      ],
      'businessmostbenefit' => [
        '' => '',
        'Sales & marketing' => 'Sales & marketing',
        'Expert to join visits' => 'Expert to join visits',
        'Lead generation' => 'Lead generation',
        'Lead qualification' => 'Lead qualification',
        'Recruitment' => 'Recruitment',
        'Training' => 'Training',
        'Finance & billing' => 'Finance & billing',
        'Solution design' => 'Solution design',
        'Solution implementation' => 'Solution implementation'
      ],
      'investinAnalytics' => [
        '' => '',
        'Underway' => 'Underway',
        '1-3 months' => '1-3 months',
        '4-6 months' => '4-6 months',
        '7-9 months' => '7-9 months',
        '10-12 months' => '10-12 months',
        '>12 months' => '>12 months',
        'None' => 'None'
      ],
      'drivesyoursales' => [
        '' => '',
        'New revenue streams through diversification' => 'New revenue streams through diversification',
        'New sales growth' => 'New sales growth',
        'Replace legacy business' => 'Replace legacy business'
      ],
      'partoftheirecosystem' => [
        '' => '',
        'Yes' => 'Yes',
        'Planned' => 'Planned',
        'No' => 'No'
      ],
      'solutionsinIoTDigitisation' => [
        '' => '',
        'Tentative discussions' => 'Tentative discussions',
        'Pre-sales or earlier' => 'Pre-sales or earlier',
        'At qualification or earlier' => 'At qualification or earlier',
        'At solution design or earlier' => 'At solution design or earlier',
        'At evaluation or earlier' => 'At evaluation or earlier',
        'At negotiation or earlier' => 'At negotiation or earlier',
        'At final stage or earlier' => 'At final stage or earlier',
        'No pipeline in place' => 'No pipeline in place'
      ],
      'sizeforIoTdigitisation' => [
        '' => '',
        '£0' => '£0',
        '<£10k' => '<£10k',
        '£10k-£50k' => '£10k-£50k',
        '£51k-100k' => '£51k-100k',
        '£101k-£200k' => '£101k-£200k',
        '£201k-£300k' => '£201k-£300k',
        '>£300k' => '>£300k'
      ],
      'solutiondeliveryforIoT' => [
        '' => '',
        'POC' => 'POC',
        'Pilots' => 'Pilots',
        'End-to-end' => 'End-to-end',
        'Design' => 'Design',
        'Implementation' => 'Implementation',
        'Meeting business outcomes' => 'Meeting business outcomes',
        'Others' => 'Others',
        'None' => 'None'
      ],
      'consultancyservicesforAnalytics' => [
        '' => '',
        'Outsourced' => 'Outsourced',
        'Vendor support' => 'Vendor support',
        'Through partnerships' => 'Through partnerships',
        'With associates/contractors' => 'With associates/contractors',
        'Business unit' => 'Business unit',
        'Department in house' => 'Department in house',
        'Not providing' => 'Not providing'
      ],
      'designservicesforIoTDigitisation' => [
        '' => '',
        'Not offered' => 'Not offered',
        'Good' => 'Good',
        'Market Leading' => 'Market Leading'
      ],
      'servicesforAnalytics' => [
        '' => '',
        'Not offered' => 'Not offered',
        'Good' => 'Good',
        'Market Leading' => 'Market Leading'
      ],
      'proofofconceptservicesforIoTDigitisation' => [
        '' => '',
        'Not offered' => 'Not offered',
        'Good' => 'Good',
        'Market Leading' => 'Market Leading'
      ],
      'conceptservicesforAnalytics' => [
        '' => '',
        'Not offered' => 'Not offered',
        'Good' => 'Good',
        'Market Leading' => 'Market Leading'
      ],
      'implementationservicesforIoTDigitisation' => [
        '' => '',
        'Not offered' => 'Not offered',
        'Good' => 'Good',
        'Market Leading' => 'Market Leading'
      ],
      'implementationservicesforAnalytics' => [
        '' => '',
        'Not offered' => 'Not offered',
        'Good' => 'Good',
        'Market Leading' => 'Market Leading'
      ],
      'solutionbyyourselfforIoT' => [
        '' => '',
        'Yes' => 'Yes',
        'No' => 'No',
        'Yes through partnerships' => 'Yes through partnerships'
      ],
      'resourceorganisationforIoTdata' => [
        '' => '',
        'Solutions Architecture' => 'Solutions Architecture',
        'Sales & marketing' => 'Sales & marketing',
        'Finance & billing' => 'Finance & billing',
        'Installation' => 'Installation',
        'Implementation' => 'Implementation',
        'Configuration' => 'Configuration',
        'Technical support' => 'Technical support'
      ],
      'analyticsadoptionactivities' => [
        '' => '',
        'Exploring' => 'Exploring',
        'Early stage set-up' => 'Early stage set-up',
        'Building resource' => 'Building resource',
        'Training & skills development' => 'Training & skills development',
        'Leveraging internally' => 'Leveraging internally',
        'Defining value proposition' => 'Defining value proposition',
        'Developing sales strategy' => 'Developing sales strategy',
        'Going to market' => 'Going to market',
        'Delivering solutions' => 'Delivering solutions',
        'Reviewing & refining' => 'Reviewing & refining'
      ],
      'dataintegrationqualitygovernancemarket' => [
        '' => '',
        'Not started' => 'Not started',
        'Early stages' => 'Early stages',
        'Developing' => 'Developing',
        'Expert' => 'Expert',
        'Not part of our strategy' => 'Not part of our strategy'
      ],
      'customersengagementIoTdigitisation' => [
        '' => '',
        'Early adopter' => 'Early adopter',
        'Exploring' => 'Exploring',
        'Actively engaged' => 'Actively engaged',
        'Disengaging' => 'Disengaging',
        'Not engaged' => 'Not engaged'
      ]
    ]
  ],
  'CPBIoTFinancial' => [
    'fields' => [
      'businessDescription' => '1. How would your customers describe your business?',
      'keyAreas' => '2. What are the key areas that make up your solution offerings? (select all that apply)',
      'threeYearStrategy' => '3. Does your organisation have a 3 year strategy and defined goals?',
      'businessLength' => '4. How long have you been in business?',
      'numberOfEmployees' => '5. How many employees do you have?',
      'firstStatement' => '6. To what extent do you agree with the following statement: "All senior leaders and executives are aligned with a 3 year strategy and goals."',
      'secondStatement' => '7. To what extent do you agree with the following statement: "We have already presented our vision to our employees and have their buy-in."',
      'businessPlanRate' => '8. How would you rate your organisation\'s ability to execute on a business plan or transition plan?',
      'organisationGaps' => '10. What are your organisation\'s biggest gaps/challenges to building the solutions practice you would like to build? (select all that apply)',
      'preSalesRate' => '9. How would you rate your organisation\'s pre-sales function and relevant technical expertise to support your transition?',
      'organisationRevenue' => '11. What was your organisation\'s total revenue for your last Fiscal Year?',
      'organisationGrowth' => '12. What was your organisation\'s Year Over Year revenue growth for your last Fiscal year?',
      'grossProfit' => '13. How does your current gross profit figure compare to the past 3 years?',
      'organisationFinancialPerformance' => '14. Considering the last 3 Fiscal Years, which areas have contributed most to your organisation\'s financial performance? (select all that apply)',
      'hardwareRevenuePercentage' => '15. In the last financial year, what percentage of your organisation\'s overall sales revenue came from Hardware?',
      'softwareRevenuePercentage' => '16. In the last financial year, what percentage of your organisation\'s overall sales revenue came from Software?',
      'servicesRevenuePercentage' => '17. In the last financial year, what percentage of your organisation\'s overall sales revenue came from Professional Services?',
      'recurringRevenueStreamsPercentage' => '18. What percentage of your revenue was from recurring revenue streams in the last financial year?',
      'mostProfitableArea' => '19. Considering your entire business, what area was most profitable in the last financial year?',
      'averageProductGrossMargin' => '20. What is the average product gross margin retained by your organisation, excluding rebates and other incentives, from the resale of hardware/software?',
      'organisationCombinedGrossMargin' => '21. What is your organisation\'s combined gross margin, including services?',
      'servicesMarginOverview' => '22. Looking at your current Fiscal Year, how would you describe your Services margin compared to previous years?',
      'organisationEBIT' => '23. What was your organisation\'s Operating Profit (EBIT) during the last Fiscal Year?',
      'account' => 'Account'
    ],
    'links' => [
      'account' => 'Account'
    ],
    'labels' => [
      'Create CPBIoTFinancial' => 'Crear CPB IoT Financial'
    ],
    'options' => [
      'businessDescription' => [
        '' => '',
        'Solution Provider' => 'Solution Provider',
        'Managed Service Provider' => 'Managed Service Provider',
        'Independent Software Vendor' => 'Independent Software Vendor',
        'Systems Integrator' => 'Systems Integrator',
        'Hybrid Cloud Enabler/Provider' => 'Hybrid Cloud Enabler/Provider',
        'Reseller/VAR' => 'Reseller/VAR',
        'IT Supplier' => 'IT Supplier',
        'Direct Market Reseller' => 'Direct Market Reseller'
      ],
      'keyAreas' => [
        '' => '',
        'Cloud/Hybrid Cloud' => 'Cloud/Hybrid Cloud',
        'Data Analytics' => 'Data Analytics',
        'IoT' => 'IoT',
        'Security' => 'Security',
        'Hardware / Infrastructure' => 'Hardware / Infrastructure',
        'Back up & Data Recovery' => 'Back up & Data Recovery',
        'Managed Services' => 'Managed Services',
        'Professional Services' => 'Professional Services'
      ],
      'threeYearStrategy' => [
        '' => '',
        'Yes' => 'Yes',
        'Being Developed' => 'Being Developed',
        'No' => 'No'
      ],
      'businessLength' => [
        '' => '',
        'Less than 1 year' => 'Less than 1 year',
        '1 - 2 years' => '1 - 2 years',
        '3 - 5 years' => '3 - 5 years',
        '6 - 10 years' => '6 - 10 years',
        'Over 10 years' => 'Over 10 years'
      ],
      'numberOfEmployees' => [
        '' => '',
        'Less than 5 employees' => 'Less than 5 employees',
        '5 - 9 employees' => '5 - 9 employees',
        '10 - 49 employees' => '10 - 49 employees',
        '50+ employees' => '50+ employees'
      ],
      'firstStatement' => [
        '' => '',
        'Strongly Agree' => 'Strongly Agree',
        'Agree' => 'Agree',
        'Undecided' => 'Undecided',
        'Disagree' => 'Disagree',
        'Strongly Disagree' => 'Strongly Disagree'
      ],
      'secondStatement' => [
        '' => '',
        'Strongly Agree' => 'Strongly Agree',
        'Agree' => 'Agree',
        'Undecided' => 'Undecided',
        'Disagree' => 'Disagree',
        'Strongly Disagree' => 'Strongly Disagree'
      ],
      'businessPlanRate' => [
        '' => '',
        'Excellent' => 'Excellent',
        'Good' => 'Good',
        'Acceptable' => 'Acceptable',
        'Poor' => 'Poor',
        'Very Poor' => 'Very Poor'
      ],
      'organisationGaps' => [
        'Capabilities' => 'Capabilities',
        'Skills' => 'Skills',
        'Training' => 'Training',
        'Domain expertise' => 'Domain expertise',
        'Lead Generation' => 'Lead Generation',
        'Sales' => 'Sales',
        'Other' => 'Other'
      ],
      'preSalesRate' => [
        '' => '',
        'Excellent' => 'Excellent',
        'Good' => 'Good',
        'Acceptable' => 'Acceptable',
        'Poor' => 'Poor',
        'Very Poor' => 'Very Poor'
      ],
      'organisationRevenue' => [
        '' => '',
        '$10 million +' => '$10 million +',
        '$5 million +' => '$5 million +',
        '$1 million +' => '$1 million +',
        '< $1 million' => '< $1 million'
      ],
      'organisationGrowth' => [
        '' => '',
        'More than 10%' => 'More than 10%',
        '5% to 10%' => '5% to 10%',
        '0% to 5%' => '0% to 5%',
        'Flat' => 'Flat',
        'Decreasing' => 'Decreasing'
      ],
      'grossProfit' => [
        '' => '',
        'Increasing' => 'Increasing',
        'Flat' => 'Flat',
        'Decreasing' => 'Decreasing'
      ],
      'organisationFinancialPerformance' => [
        'Cloud/Hybrid' => 'Cloud/Hybrid',
        'Services' => 'Services',
        'IoT, Big Data, Mobility, Social Business' => 'IoT, Big Data, Mobility, Social Business',
        'Company Acquisition/Merger' => 'Company Acquisition/Merger',
        'Software' => 'Software',
        'Hardware' => 'Hardware',
        'Other' => 'Other'
      ],
      'hardwareRevenuePercentage' => [
        '' => '',
        'More than 50%' => 'More than 50%',
        '25% to 50%' => '25% to 50%',
        '10% to 25%' => '10% to 25%',
        '1% to 10%' => '1% to 10%',
        '0%' => '0%'
      ],
      'softwareRevenuePercentage' => [
        '' => '',
        'More than 50%' => 'More than 50%',
        '25% to 50%' => '25% to 50%',
        '10% to 25%' => '10% to 25%',
        '1% to 10%' => '1% to 10%',
        '0%' => '0%'
      ],
      'servicesRevenuePercentage' => [
        '' => '',
        'More than 50%' => 'More than 50%',
        '25% to 50%' => '25% to 50%',
        '10% to 25%' => '10% to 25%',
        '1% to 10%' => '1% to 10%',
        '0%' => '0%'
      ],
      'recurringRevenueStreamsPercentage' => [
        '' => '',
        'More than 60%' => 'More than 60%',
        '40% to 60%' => '40% to 60%',
        '20% to 40%' => '20% to 40%',
        '10% to 20%' => '10% to 20%',
        '1% to 10%' => '1% to 10%',
        '0%' => '0%'
      ],
      'mostProfitableArea' => [
        '' => '',
        'Hardware' => 'Hardware',
        'Software' => 'Software',
        'Services' => 'Services',
        'IoT, Big Data, Mobility, Social Business' => 'IoT, Big Data, Mobility, Social Business',
        'Cloud/Consumption' => 'Cloud/Consumption',
        'None of the above' => 'None of the above'
      ],
      'averageProductGrossMargin' => [
        '' => '',
        '25%+' => '25%+',
        '15% to 25%' => '15% to 25%',
        '10% to 15%' => '10% to 15%',
        '5% to 10%' => '5% to 10%',
        'Less than 5%' => 'Less than 5%'
      ],
      'organisationCombinedGrossMargin' => [
        '' => '',
        '25%+' => '25%+',
        '15% to 25%' => '15% to 25%',
        '10% to 15%' => '10% to 15%',
        '5% to 10%' => '5% to 10%',
        'Less than 5%' => 'Less than 5%'
      ],
      'servicesMarginOverview' => [
        '' => '',
        'Increasing' => 'Increasing',
        'Flat' => 'Flat',
        'Decreasing' => 'Decreasing'
      ],
      'organisationEBIT' => [
        '' => '',
        'More than 10%' => 'More than 10%',
        '5% to 10%' => '5% to 10%',
        '0% to 5%' => '0% to 5%',
        'Flat' => 'Flat',
        'Decreasing' => 'Decreasing'
      ]
    ]
  ],
  'CPBIoTMarketing' => [
    'fields' => [
      'linesofBusiness' => '1. Can your sales team effectively sell to Lines of Business within your end user customers?',
      'salesreps' => '2. How many sales reps do you have?',
      'salesrepscarryServices' => '3. Do your sales reps carry Services quotas or accelerators?',
      'describeyouorganisation' => '4. How would you describe you organisation\'s ability to successfully implement a marketing strategy?',
      'areaofyourbusiness' => '5. What is an area of your business in which you could use marketing support? (please select all that apply)',
      'solutionsthatyoursales' => '6. Select all solutions that your sales team typically propose to your customers. (select all that apply)',
      'salesgeneratedHardware' => '7. Considering all of your sales generated in the past 12 months, what percentage was led by Hardware?',
      'salesgeneratedSoftware' => '8. Considering all of your sales generated in the past 12 months, what percentage was led by Software?',
      'salesgeneratedServices' => '9. Considering all of your sales generated in the past 12 months, what percentage was led by Services?',
      'salesteamleadgeneration' => '10. How would you rate your sales team\'s lead generation engine?',
      'businessoutcomes' => '11. Do you have a detailed sales approach that shows how your offerings achieve customers\' desired business outcomes?',
      'monthlyRecurringRevenue' => '13. Does your organisation have an employee compensation plan that supports Monthly Recurring Revenue (MRR)?',
      'newbusinesstargets' => '14. Do you have new business targets that include new technologies and/or customers?',
      'horizontalsegments' => '15. What horizontal segments do you sell into?',
      'typicalsalesengagement' => '16. In a typical sales engagement, which departments do you currently involve in the decision making process?',
      'verticalssell' => '17. What verticals do you sell into?',
      'deployyoursolutions' => '18. In regards to the environment on which your end users deploy your solutions - which is the most relevant?',
      'account' => 'Account',
      'servicesversusproductsales' => '12. Does your organisation have an employee compensation plan for services versus product sales?'
    ],
    'links' => [
      'account' => 'Account'
    ],
    'labels' => [
      'Create CPBIoTMarketing' => 'Crear CPB IoT Marketing'
    ],
    'options' => [
      'linesofBusiness' => [
        '' => '',
        'Yes' => 'Yes',
        'No' => 'No',
        'Not Sure' => 'Not Sure'
      ],
      'salesreps' => [
        '' => '',
        'Less than 3 reps' => 'Less than 3 reps',
        '3 - 5 reps' => '3 - 5 reps',
        '6 - 10 reps' => '6 - 10 reps',
        '11 - 49 reps' => '11 - 49 reps',
        'More than 50 reps' => 'More than 50 reps'
      ],
      'salesrepscarryServices' => [
        '' => '',
        'Yes' => 'Yes',
        'No' => 'No'
      ],
      'describeyouorganisation' => [
        '' => '',
        'Excellent' => 'Excellent',
        'Good' => 'Good',
        'Needs Improvement' => 'Needs Improvement',
        'Poor' => 'Poor',
        'Not Sure' => 'Not Sure'
      ],
      'areaofyourbusiness' => [
        '' => '',
        'Digital/Online Presence' => 'Digital/Online Presence',
        'Content Creation' => 'Content Creation',
        'Value Proposition Creation' => 'Value Proposition Creation',
        'Lead Generation' => 'Lead Generation',
        'Marketing Plan Creation' => 'Marketing Plan Creation',
        'Outsource Marketing' => 'Outsource Marketing',
        'Not Sure' => 'Not Sure',
        'We\'ve Mastered Our Marketing Engine' => 'We\'ve Mastered Our Marketing Engine'
      ],
      'solutionsthatyoursales' => [
        '' => '',
        'IoT' => 'IoT',
        'Managed Services' => 'Managed Services',
        'Public Cloud' => 'Public Cloud',
        'Private / Hybrid Cloud' => 'Private / Hybrid Cloud',
        'Software' => 'Software',
        'Hardware / Infrastructure' => 'Hardware / Infrastructure',
        'Back up & Data Recovery' => 'Back up & Data Recovery',
        'Maintenance Services' => 'Maintenance Services',
        'Professional Services' => 'Professional Services',
        'Other' => 'Other'
      ],
      'salesgeneratedHardware' => [
        '' => '',
        '50% or above' => '50% or above',
        '40% - 49%' => '40% - 49%',
        '20% - 39%' => '20% - 39%',
        '10% - 19%' => '10% - 19%',
        'Less than 10%' => 'Less than 10%'
      ],
      'salesgeneratedSoftware' => [
        '' => '',
        '50% or above' => '50% or above',
        '40% - 49%' => '40% - 49%',
        '20% - 39%' => '20% - 39%',
        '10% - 19%' => '10% - 19%',
        'Less than 10%' => 'Less than 10%'
      ],
      'salesgeneratedServices' => [
        '' => '',
        '50% or above' => '50% or above',
        '40% - 49%' => '40% - 49%',
        '20% - 39%' => '20% - 39%',
        '10% - 19%' => '10% - 19%',
        'Less than 10%' => 'Less than 10%'
      ],
      'salesteamleadgeneration' => [
        '' => '',
        'Excellent' => 'Excellent',
        'Good' => 'Good',
        'Acceptable' => 'Acceptable',
        'Poor' => 'Poor',
        'Very Poor' => 'Very Poor'
      ],
      'businessoutcomes' => [
        '' => '',
        'Yes' => 'Yes',
        'In progress' => 'In progress',
        'No' => 'No'
      ],
      'monthlyRecurringRevenue' => [
        '' => '',
        'Yes' => 'Yes',
        'No' => 'No'
      ],
      'newbusinesstargets' => [
        '' => '',
        'Yes' => 'Yes',
        'Planned' => 'Planned',
        'No' => 'No'
      ],
      'horizontalsegments' => [
        '' => '',
        'Large (500+ employed)' => 'Large (500+ employed)',
        'Mid (100 to 499 employed)' => 'Mid (100 to 499 employed)',
        'Small (1 to 99 employed)' => 'Small (1 to 99 employed)'
      ],
      'typicalsalesengagement' => [
        '' => '',
        'IT' => 'IT',
        'Digital/Innovation' => 'Digital/Innovation',
        'Finance' => 'Finance',
        'Operations' => 'Operations',
        'Procurement' => 'Procurement',
        'HR' => 'HR',
        'Sales & Marketing' => 'Sales & Marketing',
        'Customer Service' => 'Customer Service',
        'Other' => 'Other'
      ],
      'verticalssell' => [
        '' => '',
        'Manufacturing' => 'Manufacturing',
        'Legal' => 'Legal',
        'Retail' => 'Retail',
        'Healthcare' => 'Healthcare',
        'Finance' => 'Finance',
        'Banking' => 'Banking',
        'Education' => 'Education',
        'Government' => 'Government',
        'Smart Space' => 'Smart Space',
        'Logistics' => 'Logistics',
        'Transport' => 'Transport',
        'Energy' => 'Energy',
        'Utilities' => 'Utilities',
        'Pharmaceutical' => 'Pharmaceutical',
        'Other' => 'Other'
      ],
      'deployyoursolutions' => [
        '' => '',
        'On premise' => 'On premise',
        'Hybrid' => 'Hybrid',
        'Single Tenant Platform' => 'Single Tenant Platform',
        'Multi Tenant Platform' => 'Multi Tenant Platform'
      ],
      'servicesversusproductsales' => [
        '' => '',
        'Yes' => 'Yes',
        'No' => 'No'
      ]
    ]
  ],
  'CPBIoTStrategy' => [
    'fields' => [
      'account' => 'Account',
      'analystConsulting' => '1. Do you regularly consult with analysts (in-house or externally) in order to realise your organisation\'s goals and transition business models?',
      'organisationBenchmark' => '2. Does your organisation benchmark itself against other partners in your field?',
      'cashFlowManagePlan' => '3. If change is involved in your business goals, do you have a plan to manage your cash flow?',
      'organisationInvestingAreas' => '4. Select the areas in which you see your organisation investing over the next 3 years. (select all that apply)',
      'asAServiceSolutions' => '5. Do you provide any Software/Infrastucture as a Service offerings, or do you have any solutions that will move to SaaS/IaaS based in the future?',
      'ownSolutionEngagement' => '6. Are you engaging with any vendors, partners or solution providers to build out your own solution stack?',
      'highestGrowthAreas' => '7. Which areas do you see as the highest growth potential in the next 12 months?',
      'dataLifecycle' => '8. Where in the data lifecycle are your focus points?'
    ],
    'links' => [
      'account' => 'Account'
    ],
    'labels' => [
      'Create CPBIoTStrategy' => 'Crear CPB IoT Strategy'
    ],
    'options' => [
      'analystConsulting' => [
        '' => '',
        'Yes' => 'Yes',
        'Planned' => 'Planned',
        'No' => 'No'
      ],
      'organisationBenchmark' => [
        '' => '',
        'Frequently' => 'Frequently',
        'Occasionally' => 'Occasionally',
        'Unsure how' => 'Unsure how',
        'Not interested' => 'Not interested'
      ],
      'cashFlowManagePlan' => [
        '' => '',
        'Yes' => 'Yes',
        'Planned' => 'Planned',
        'No' => 'No'
      ],
      'organisationInvestingAreas' => [
        '' => '',
        'Data center' => 'Data center',
        'Employees' => 'Employees',
        'Service offerings' => 'Service offerings',
        'Technology development' => 'Technology development',
        'Systems' => 'Systems',
        'Other' => 'Other',
        'No funds to invest' => 'No funds to invest'
      ],
      'asAServiceSolutions' => [
        '' => '',
        'Yes, we currently offer SaaS/IaaS' => 'Yes, we currently offer SaaS/IaaS',
        'Solutions identified for move to SaaS/IaaS' => 'Solutions identified for move to SaaS/IaaS',
        'No, we do not intend to offer SaaS solutions' => 'No, we do not intend to offer SaaS solutions'
      ],
      'ownSolutionEngagement' => [
        '' => '',
        'Yes' => 'Yes',
        'Planned' => 'Planned',
        'No' => 'No'
      ],
      'highestGrowthAreas' => [
        '' => '',
        'IoT' => 'IoT',
        'Analytics' => 'Analytics',
        'Managed Workspace' => 'Managed Workspace',
        'Cyber Security' => 'Cyber Security',
        'Social Platforms' => 'Social Platforms',
        'Big Data' => 'Big Data',
        'Mobile' => 'Mobile',
        'Cloud/Hybrid' => 'Cloud/Hybrid',
        'Physical Infrastructure' => 'Physical Infrastructure',
        'Automation & Orchestration ' => 'Automation & Orchestration ',
        'Business Intelligence' => 'Business Intelligence',
        'Consumption-as-a-Service' => 'Consumption-as-a-Service',
        'Other' => 'Other'
      ],
      'dataLifecycle' => [
        '' => '',
        'Generate' => 'Generate',
        'Collect' => 'Collect',
        'Analyse' => 'Analyse',
        'React' => 'React',
        'Predict' => 'Predict'
      ]
    ]
  ],
  'CPBIoTTechnology' => [
    'fields' => [
      'salesrevenue' => '1. In the last financial year, what percentage of your organisation\'s overall sales revenue came from Managed Services?',
      'managedservicessolution' => '2. Have you hired specialised managed services/solution sales expertise or retrained product focused sales people to sell services and solutions?',
      'documentedstrategy' => '3. Do you have a well defined and documented strategy for your managed services?',
      'managedServicesprocesses' => '4. How would you rate your Managed Services processes, systems, tools and SLA\'s?',
      'transformAndhost' => '5. For your managed services do you offer a standard catalogue that includes monitor, operate, optimise, transform and host, or equivalent?',
      'deliverypractice' => '6. Do you have a scalable and repeatable delivery practice for your managed services?',
      'consumptionbased' => '7. Do you have a consumption-based billing capability, either internally or externally?',
      'hardwaresaleschanging' => '8. How do you see the percentage of your hardware sales changing in the next 12 - 24 months?',
      'softwaresaleschanging' => '9. How do you see the percentage of your software sales changing in the next 12 - 24 months?',
      'servicessaleschanging' => '10. How do you see the percentage of your services sales changing in the next 12 - 24 months?',
      'account' => 'Account'
    ],
    'links' => [
      'account' => 'Account'
    ],
    'labels' => [
      'Create CPBIoTTechnology' => 'Crear CPB IoT Technology'
    ],
    'options' => [
      'salesrevenue' => [
        '' => '',
        'More than 50%' => 'More than 50%',
        '25% to 50%' => '25% to 50%',
        '10% to 25%' => '10% to 25%',
        '1% to 10%' => '1% to 10%',
        '0%' => '0%'
      ],
      'managedservicessolution' => [
        '' => '',
        'Yes' => 'Yes',
        'Training in progress' => 'Training in progress',
        'Recruitment in progress' => 'Recruitment in progress',
        'No' => 'No'
      ],
      'documentedstrategy' => [
        '' => '',
        'Yes' => 'Yes',
        'No' => 'No',
        'We do not have Managed Services' => 'We do not have Managed Services'
      ],
      'managedServicesprocesses' => [
        '' => '',
        'Good' => 'Good',
        'Acceptable' => 'Acceptable',
        'Poor' => 'Poor',
        'Managed Services being developed' => 'Managed Services being developed',
        'We don\'t provide Managed Services' => 'We don\'t provide Managed Services'
      ],
      'transformAndhost' => [
        '' => '',
        'Yes' => 'Yes',
        'No' => 'No',
        'We do not have Managed Services' => 'We do not have Managed Services'
      ],
      'deliverypractice' => [
        '' => '',
        'Yes' => 'Yes',
        'No' => 'No',
        'We do not have Managed Services' => 'We do not have Managed Services'
      ],
      'consumptionbased' => [
        '' => '',
        'Yes' => 'Yes',
        'In Progress' => 'In Progress',
        'No' => 'No'
      ],
      'hardwaresaleschanging' => [
        '' => '',
        'Increasing' => 'Increasing',
        'No change' => 'No change',
        'Decreasing' => 'Decreasing'
      ],
      'softwaresaleschanging' => [
        '' => '',
        'Increasing' => 'Increasing',
        'No change' => 'No change',
        'Decreasing' => 'Decreasing'
      ],
      'servicessaleschanging' => [
        '' => '',
        'Increasing' => 'Increasing',
        'No change' => 'No change',
        'Decreasing' => 'Decreasing'
      ]
    ]
  ],
  'CalendrioseEventos' => [
    'fields' => [
      'status' => 'Status',
      'dataHora' => 'Data/Hora do Evento',
      'publicoAlvo' => 'Público Alvo'
    ],
    'links' => [],
    'labels' => [
      'Create CalendrioseEventos' => 'Crear Calendários e Eventos'
    ],
    'options' => [
      'status' => [
        'Planejado' => 'Planejado',
        'Confirmado' => 'Confirmado',
        'Realizado' => 'Realizado'
      ],
      'publicoAlvo' => [
        'TD Synnex' => 'TD Synnex',
        'Revenda' => 'Revenda',
        'CF' => 'CF',
        'ISVs' => 'ISVs',
        'ISP' => 'ISP'
      ]
    ]
  ],
  'CiscoJourney' => [
    'fields' => [
      'kNOW' => 'KNOW',
      'videos1and2' => 'Videos 1 e 2',
      'videos3And4' => 'Videos 3 e 4',
      'video5' => 'Vídeo 5',
      'vdeos67And8' => 'Vídeos 6, 7 e 8',
      'account' => 'Account'
    ],
    'links' => [
      'meetings' => 'Presentaciones',
      'calls' => 'Llamadas',
      'tasks' => 'Tareas',
      'account' => 'Account'
    ],
    'labels' => [
      'Create CiscoJourney' => 'Crear Cisco Journey'
    ],
    'options' => [
      'kNOW' => [
        '' => '',
        'Sim' => 'Sim',
        'Não' => 'Não'
      ],
      'videos1and2' => [
        '' => '',
        'Sim' => 'Sim',
        'Não' => 'Não'
      ],
      'videos3And4' => [
        '' => '',
        'Sim' => 'Sim',
        'Não' => 'Não'
      ],
      'video5' => [
        '' => '',
        'Sim' => 'Sim',
        'Não' => 'Não'
      ],
      'vdeos67And8' => [
        '' => '',
        'Sim' => 'Sim',
        'Não' => 'Não'
      ]
    ],
    'tooltips' => [
      'videos1and2' => 'Sim: Registro Synnex / Registro CISCO
Não: Comunicação de Engajamento para continuar a jornada e registrar-se na Cisco.',
      'kNOW' => 'Sim:	Jornada de vídeos Velocity Accelerate.
Não:	Comunicação de engajamento e divulgação da jornada.',
      'videos3And4' => 'Sim: Inscrição no Evento Cisco Select e material de apoio das certificações.
Não: Comunicação de Engajamento para continuar a jornada e registrar-se na Cisco.',
      'video5' => 'Sim: Inscrição nos cursos K.NOW / Black Belt - Envio de material de apoio.
Não: Comunicação de Engajamento para continuar a jornada.',
      'vdeos67And8' => 'Sim: Ao terminar a jornada, encaminhar comunicação de boas vindas e direcionar o contato de vendas e o time de produto entrar em contato.
Não: Comunicação de Engajamento para continuar a jornada e registrar-se na Cisco.'
    ]
  ],
  'CloudConsumption' => [
    'fields' => [
      'partnerID' => 'Partner ID',
      'billingPeriod' => 'Data da medição',
      'amount' => 'Valor',
      'amountCurrency' => 'Valor (Currency)',
      'amountConverted' => 'Valor (Converted)',
      'status' => 'Status',
      'account' => 'Conta',
      'salesOrder' => 'Sales Order',
      'lastupdate' => 'Last Update'
    ],
    'links' => [
      'partnerID' => 'Partner ID',
      'account' => 'Conta',
      'salesOrder' => 'Sales Order'
    ],
    'labels' => [
      'Create CloudConsumption' => 'Crear Cloud Consumption'
    ],
    'tooltips' => [
      'billingPeriod' => 'Data da medição do consumo. Quando a data for o último dia do mês, este registro reflete o valor do consumo no mês. Atenção: este valor poderá ser atualizado até o quinto dia do mês seguinte devido a variações no envio das informações pelo próprio fabricante.'
    ],
    'options' => [
      'status' => [
        'In progress' => 'In progress',
        'Complete' => 'Complete'
      ]
    ]
  ],
  'Contract' => [
    'links' => [
      'contractGoals' => 'Metas',
      'accountVBM' => 'Cuenta VBM'
    ],
    'labels' => [
      'Create Contract' => 'Crear Contrato'
    ],
    'fields' => [
      'paises' => 'Country',
      'periodoImportado' => 'Período Importado',
      'contratoMs' => 'contrato_ms',
      'tipo' => 'Type',
      'fornecedor' => 'Fornecedor',
      'nomefornecedor' => 'nomefornecedor',
      'fatcfourv' => 'fat_cf_ou_rv',
      'clienteParaFaturamento' => 'cliente_para_faturamento',
      'descricaoCliente' => 'Cliente Final',
      'revendedor' => 'Reventa',
      'descricaoRevendedor' => 'Reventa',
      'codItem' => 'cod_item',
      'descricaoItem' => 'descricao_item',
      'chargeType' => 'charge_type',
      'syndicationpartnersubscriptionnumber' => 'ERP Orden de Venta',
      'inicioDaCobranca' => 'inicio_da_cobranca',
      'fimDaCobranca' => 'fim_da_cobranca',
      'orderId' => 'Orden ID',
      'invoice' => 'invoice',
      'dataAprovManual' => 'data_aprov_manual',
      'usuarioAprovManual' => 'usuario_aprov_manual',
      'usuario' => 'user',
      'horaAprov' => 'hora_aprov',
      'ordenDeCompra' => 'Orden de Compra',
      'log' => 'log',
      'nfGerada' => 'nf_gerada',
      'subcategoria' => 'subcategoria',
      'quantidade' => 'Cuantidad',
      'precoUnitario' => 'Precio Unitario',
      'valorTotal' => 'Valor de Costo',
      'descContrato' => 'desc_contrato',
      'acresContrato' => 'acres_contrato',
      'descRevenda' => 'Descripción Reventa',
      'vlrPercentualComissao' => 'vlr_percentual_comissao',
      'valorComissao' => 'valor_comissao',
      'resellerunitprice' => 'Precio Unitario Reventa',
      'totalRv' => 'Valor de Venta',
      'enduserunitprice' => 'enduserunitprice',
      'totalCf' => 'total_cf',
      'tblpreco' => 'tblpreco',
      'lucro' => 'Margen (US$)',
      'date' => 'Data (Período Importado)',
      'quarter' => 'Quarter',
      'month' => 'Mês',
      'margem' => 'Margen (%)',
      'facturadeVenta' => 'Factura_de_Venta',
      'facturaDeVenta' => 'FacturaDeVenta',
      'statusDoContrato' => 'Status Contrato',
      'totalsales' => 'Ventas Totales',
      'credit' => 'Crédito',
      'lastupdate' => 'Last Update',
      'contractGoals' => 'Metas',
      'accountVBM' => 'Cuenta VBM',
      'soldByCountry' => 'SoldByCountry',
      'emisionVenta' => 'EmisionVenta',
      'spla' => 'Spla',
      'termDuration' => 'TermDuration',
      'billingCycle' => 'BillingCycle',
      'modifiedBy' => 'Modificado por'
    ],
    'options' => [
      'quarter' => [
        '' => '',
        'Q1' => 'Q1',
        'Q2' => 'Q2',
        'Q3' => 'Q3',
        'Q4' => 'Q4'
      ],
      'statusDoContrato' => [
        'FATURADO' => 'FATURADO',
        'Faturado' => 'Facturado',
        'NF Devolvida	' => 'NF Devolvida	',
        'Crédito Vinculado	' => 'Crédito Vinculado	',
        'Validado' => 'Validado',
        'NF Devolvida' => 'NF Devuelto',
        'Cr\\u00e9dito Vinculado' => 'Cr\\u00e9dito Vinculado',
        '' => '',
        'Crédito Vinculado' => 'Crédito Vinculado',
        'Não Validado' => 'No Validado'
      ]
    ],
    'presetFilters' => [
      'reportFilter6686eac9c5a60065c' => 'Contratos Q1',
      'reportFilter6686ead1b861b28d9' => 'Contratos Q2',
      'reportFilter6686eae14885b6a3a' => 'Contratos Q3',
      'reportFilter6686eae8f245d4139' => 'Contratos Q4'
    ]
  ],
  'ContractGoals' => [
    'fields' => [
      'contracts' => 'Contratos',
      'q1' => 'Q1 - Dic/Ene/Feb',
      'q1Currency' => 'Q1 (Currency)',
      'q1Converted' => 'Q1 (Converted)',
      'q2' => 'Q2 - Mar/Abr/May',
      'q2Currency' => 'Q2 (Currency)',
      'q2Converted' => 'Q2 (Converted)',
      'amountGoal' => 'Meta',
      'amountGoalCurrency' => 'Meta (Moneda)',
      'amountGoalConverted' => 'Meta (Convertido)',
      'newResellers' => 'Nuevas Reventas',
      'q1goal' => 'Q1 - Meta',
      'q1goalCurrency' => 'Q1 - Meta (Moneda)',
      'q1goalConverted' => 'Q1 - Meta (Convertido)',
      'year' => 'Año',
      'type' => 'Tipo',
      'sync' => 'Sync',
      'roi' => 'Diferencia / Lucro',
      'roiCurrency' => 'Diferencia / Lucro (Moneda)',
      'roiConverted' => 'Diferencia / Lucro (Convertido)',
      'revendedorID' => 'Reventa ID',
      'region' => 'Region',
      'q4goal' => 'Q4 - Meta',
      'q4goalCurrency' => 'Q4 - Meta (Moneda)',
      'q4goalConverted' => 'Q4 - Meta (Convertido)',
      'q4diff' => 'Q4 - Diferencia',
      'q4diffCurrency' => 'Q4 - Diferencia (Moneda)',
      'q4diffConverted' => 'Q4 - Diferencia (Convertido)',
      'q4' => 'Q4 - Sep/Oct/Nov',
      'q4Currency' => 'Q4 - Sep/Oct/Nov (Moneda)',
      'q4Converted' => 'Q4 - Sep/Oct/Nov (Convertido)',
      'q3goal' => 'Q3 - Meta',
      'q3goalCurrency' => 'Q3 - Meta (Moneda)',
      'q3goalConverted' => 'Q3 - Meta (Convertido)',
      'q3diff' => 'Q3 - Diferencia',
      'q3diffCurrency' => 'Q3 - Diferencia (Moneda)',
      'q3diffConverted' => 'Q3 - Diferencia (Convertido)',
      'q3' => 'Q3 - Jun/Jul/Ago',
      'q3Currency' => 'Q3 - Jun/Jul/Ago (Moneda)',
      'q3Converted' => 'Q3 - Jun/Jul/Ago (Convertido)',
      'q2goal' => 'Q2 - Meta',
      'q2goalCurrency' => 'Q2 - Meta (Moneda)',
      'q2goalConverted' => 'Q2 - Meta (Convertido)',
      'q2diff' => 'Q2 - Diferencia',
      'q2diffCurrency' => 'Q2 - Diferencia (Moneda)',
      'q2diffConverted' => 'Q2 - Diferencia (Convertido)',
      'q1diff' => 'Q1 - Diferencia',
      'q1diffCurrency' => 'Q1 - Diferencia (Moneda)',
      'q1diffConverted' => 'Q1 - Diferencia (Convertido)',
      'country' => 'País'
    ],
    'links' => [
      'contracts' => 'Contratos'
    ],
    'labels' => [
      'Create ContractGoals' => 'Crear Meta'
    ],
    'options' => [
      'year' => [
        2023 => '2023',
        2024 => '2024',
        2025 => '2025',
        2026 => '2026',
        2027 => '2027',
        2028 => '2028',
        2029 => '2029',
        2030 => '2030',
        '' => ''
      ],
      'type' => [
        '' => '',
        'Licenciamento' => 'Licenciamento',
        'Consumo' => 'Consumo',
        'Licença' => 'Licença'
      ],
      'region' => [
        '' => '',
        'NOLA' => 'NOLA',
        'SOLA' => 'SOLA',
        'Brasil' => 'Brasil',
        'CCA' => 'CCA'
      ],
      'country' => [
        '' => '',
        'Argentina' => 'Argentina',
        'Bolivia' => 'Bolivia',
        'Brasil' => 'Brasil',
        'Costa Rica' => 'Costa Rica',
        'Chile' => 'Chile',
        'Colombia' => 'Colombia',
        'Dominican Republic' => 'Dominican Republic',
        'Ecuador' => 'Ecuador',
        'El Salvador' => 'El Salvador',
        'Guadelouope' => 'Guadelouope',
        'Guatemala' => 'Guatemala',
        'Honduras' => 'Honduras',
        'Mexico' => 'Mexico',
        'Panama' => 'Panama',
        'Paraguay' => 'Paraguay',
        'Peru' => 'Peru',
        'Puerto Rico' => 'Puerto Rico',
        'Uruguay' => 'Uruguay',
        'Venezuela' => 'Venezuela',
        'CCA' => 'CCA',
        'Caribe' => 'Caribe',
        'Santa Lucía' => 'Santa Lucía',
        'San vicente y las Granadinas' => 'San vicente y las Granadinas',
        'San Cristóbal y Nieves' => 'San Cristóbal y Nieves',
        'Jamaica' => 'Jamaica',
        'Belice' => 'Belice',
        'Haití' => 'Haití',
        'Guyana' => 'Guyana',
        'Granada' => 'Granada',
        'Cuba' => 'Cuba',
        'Barbados' => 'Barbados',
        'Bahamas' => 'Bahamas',
        'Antigua y barbuda' => 'Antigua y barbuda',
        'Nicaragua' => 'Nicaragua',
        'United States' => 'United States',
        'CALA' => 'CALA'
      ]
    ]
  ],
  'Country' => [
    'fields' => [
      'countryLabel' => 'CountryLabel',
      'priceBooks' => 'Price Books'
    ],
    'links' => [
      'priceBooks' => 'Price Books'
    ],
    'labels' => [
      'Create Country' => 'Crear Country'
    ],
    'options' => [
      'countryLabel' => [
        'Argentina' => 'Argentina',
        'Colombia' => 'Colombia',
        'Brasil' => 'Brasil',
        'Chile' => 'Chile',
        'Peru' => 'Peru',
        'Ecuador' => 'Ecuador',
        'Cala' => 'Cala',
        'Mexico' => 'Mexico',
        'Uruguai' => 'Uruguai',
        '' => ''
      ]
    ]
  ],
  'CuentasVBM' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create CuentasVBM' => 'Crear Cuentas VBM'
    ]
  ],
  'DSET' => [
    'fields' => [
      'account' => 'Account',
      'contact' => 'Contact',
      'productBrands' => 'Brands',
      'categoriaCPB' => 'CPB Category',
      'country' => 'País',
      'dSETAWS' => 'DSET AWS',
      'language' => 'Idioma',
      'region' => 'Region',
      'statusCPB' => 'CPB status',
      'submissionID' => 'Submission ID',
      'vendor' => 'Vendor'
    ],
    'links' => [
      'account' => 'Account',
      'contact' => 'Contact',
      'productBrands' => 'Brands'
    ],
    'labels' => [
      'Create DSET' => 'Crear DSET'
    ],
    'options' => [
      'categoriaCPB' => [
        '' => '',
        'Sem Categoria' => 'Without category',
        'Starter' => 'Starter',
        'Transformer' => 'Transformer',
        'Accelerator' => 'Accelerator'
      ],
      'country' => [
        '' => '',
        'Argentina ' => 'Argentina ',
        'Bolivia' => 'Bolivia',
        'Brasil' => 'Brasil',
        'Chile' => 'Chile',
        'Colombia ' => 'Colombia ',
        'Costa Rica ' => 'Costa Rica ',
        'Dominican Republic' => 'Dominican Republic',
        'Ecuador' => 'Ecuador',
        'Guadeloupe' => 'Guadeloupe',
        'Guatemala' => 'Guatemala',
        'Honduras' => 'Honduras',
        'El Salvador' => 'El Salvador',
        'Mexico' => 'Mexico',
        'Panama ' => 'Panama ',
        'Paraguay ' => 'Paraguay ',
        'Peru' => 'Peru',
        'Puerto Rico ' => 'Puerto Rico ',
        'Uruguay' => 'Uruguay',
        'Venezuela' => 'Venezuela'
      ],
      'dSETAWS' => [
        'No Concluído' => 'Not Concluded',
        'Concluído' => 'Concluded'
      ],
      'language' => [
        '' => '',
        'pt' => 'Português',
        'en' => 'English',
        'es' => 'Espanõl'
      ],
      'region' => [
        '' => '',
        'NOLA' => 'NOLA',
        'SOLA' => 'SOLA',
        'CCA' => 'CCA',
        'Brasil' => 'Brasil',
        'México' => 'México'
      ],
      'statusCPB' => [
        'No Concluído' => 'Not Concluded',
        'Concluído' => 'Concluded'
      ],
      'vendor' => [
        '' => '',
        'AWS' => 'AWS',
        'Google' => 'Google',
        'Microsoft' => 'Microsoft'
      ]
    ]
  ],
  'DashboardAccess' => [
    'fields' => [
      'accessTime' => 'Access Time',
      'tabName' => 'Tab Name'
    ],
    'links' => [],
    'labels' => [
      'Create DashboardAccess' => 'Crear Dashboard Access'
    ]
  ],
  'DataAIAssessment' => [
    'fields' => [
      'category' => 'Category',
      'account' => 'Conta',
      'contact' => 'Contato',
      'contacts' => 'Contatos',
      'country' => 'Pais'
    ],
    'links' => [
      'account' => 'Conta',
      'contact' => 'Contato',
      'contacts' => 'Contatos'
    ],
    'labels' => [
      'Create DataAIAssessment' => 'Crear Data AI - Lista'
    ],
    'options' => [
      'category' => [
        '' => '',
        'Aware' => 'Aware',
        'Ready' => 'Ready',
        'Expert' => 'Expert'
      ]
    ]
  ],
  'DataAnalytics' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create DataAnalytics' => 'Crear Data Analytics'
    ]
  ],
  'DataAnalyticsReport' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create DataAnalyticsReport' => 'Crear Data Analytics Report'
    ]
  ],
  'Distributor' => [
    'fields' => [
      'accessToken' => 'AccessToken',
      'accountId' => 'AccountId',
      'appId' => 'AppId',
      'clientId' => 'ClientId',
      'clientSecret' => 'ClientSecret',
      'codErp' => 'CodErp',
      'culture' => 'Culture',
      'domain' => 'Domain',
      'expireToken' => 'ExpireToken',
      'mpnId' => 'MpnId',
      'refreshToken' => 'RefreshToken',
      'scope' => 'Scope',
      'countryCode' => 'Country Code'
    ],
    'links' => [],
    'labels' => [
      'Create Distributor' => 'Crear Distributor'
    ],
    'options' => [
      'scope' => [
        'api.partner.microsoft.com' => 'api.partner.microsoft.com',
        'management.azure.com' => 'management.azure.com',
        'graph.microsoft.com' => 'graph.microsoft.com',
        'api.partnercenter.microsoft.com' => 'api.partnercenter.microsoft.com'
      ]
    ]
  ],
  'DsetAws' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create DsetAws' => 'Crear DSET AWS'
    ]
  ],
  'Earn' => [
    'fields' => [
      'earningId' => 'earningId',
      'participantId' => 'participantId',
      'participantIdType' => 'participantIdType',
      'participantName' => 'participantName',
      'programName' => 'programName',
      'transactionId' => 'transactionId',
      'transactionCurrency' => 'transactionCurrency',
      'lever' => 'lever',
      'engagementName' => 'engagementName',
      'engagementId' => 'engagementId',
      'earningType' => 'earningType',
      'claimId' => 'claimId',
      'paymentId' => 'paymentId',
      'paymentStatusDescription' => 'paymentStatusDescription',
      'customerId' => 'customerId',
      'customerName' => 'customerName',
      'partNumber' => 'partNumber',
      'productName' => 'productName',
      'productId' => 'productId',
      'parentProductId' => 'parentProductId',
      'parentProductName' => 'parentProductName',
      'productType' => 'productType',
      'invoiceNumber' => 'invoiceNumber',
      'subscriptionId' => 'subscriptionId',
      'resellerId' => 'resellerId',
      'resellerName' => 'resellerName',
      'distributorId' => 'distributorId',
      'distributorName' => 'distributorName',
      'agreementNumber' => 'agreementNumber',
      'agreementStartDate' => 'agreementStartDate',
      'agreementEndDate' => 'agreementEndDate',
      'workload' => 'workload',
      'transactionType' => 'transactionType',
      'localProviderSeller' => 'localProviderSeller',
      'taxRemitModel' => 'taxRemitModel',
      'storeFee' => 'storeFee',
      'transactionPaymentMethod' => 'transactionPaymentMethod',
      'tpan' => 'tpan',
      'purchaseTypeCode' => 'purchaseTypeCode',
      'purchaseOrderType' => 'purchaseOrderType',
      'purchaseOrderCoverageStartDate' => 'purchaseOrderCoverageStartDate',
      'purchaseOrderCoverageEndDate' => 'purchaseOrderCoverageEndDate',
      'externalReferenceId' => 'externalReferenceId',
      'externalReferenceIdLabel' => 'externalReferenceIdLabel',
      'licensingProgramName' => 'licensingProgramName',
      'taxCountry' => 'taxCountry',
      'taxState' => 'taxState',
      'taxCity' => 'taxCity',
      'taxZipCode' => 'taxZipCode',
      'programCode' => 'programCode',
      'lastPaymentCurrency' => 'lastPaymentCurrency',
      'assetId' => 'assetId',
      'orderId' => 'orderId',
      'lineItemId' => 'lineItemId',
      'resellerCountry' => 'resellerCountry',
      'customerCountry' => 'customerCountry',
      'customerEmail' => 'customerEmail',
      'skuId' => 'skuId',
      'customerTenantId' => 'customerTenantId',
      'invoiceDate' => 'invoiceDate',
      'fundCategory' => 'fundCategory',
      'categoryId' => 'categoryId',
      'reasonCode' => 'reasonCode',
      'bucketSize' => 'bucketSize',
      'milestone' => 'milestone',
      'billingGroupId' => 'billingGroupId',
      'quantityType' => 'quantityType',
      'topParentPartNumber' => 'topParentPartNumber',
      'productFamily' => 'productFamily',
      'topParentProductFamily' => 'topParentProductFamily',
      'agreementType' => 'agreementType',
      'userCount' => 'userCount',
      'desktopCount' => 'desktopCount',
      'baseline' => 'baseline',
      'baselineType' => 'baselineType',
      'isPrivateOffer' => 'isPrivateOffer',
      'transactionExchangeRate' => 'transactionExchangeRate',
      'transactionAmount' => 'transactionAmount',
      'earningRate' => 'earningRate',
      'quantity' => 'quantity',
      'earningAmount' => 'earningAmount',
      'earningExchangeRate' => 'earningExchangeRate',
      'taxRemitted' => 'taxRemitted',
      'earningAmountInLastPaymentCurrency' => 'earningAmountInLastPaymentCurrency',
      'instantRebateAmount' => 'instantRebateAmount',
      'transactionDate' => 'transactionDate',
      'paymentStatus' => 'PaymentStatus',
      'transactionCountryCode' => 'TransactionCountryCode',
      'calculationDate' => 'CalculationDate',
      'exchangeRateDate' => 'ExchangeRateDate',
      'subscriptionStartDate' => 'SubscriptionStartDate',
      'subscriptionEndDate' => 'SubscriptionEndDate',
      'earningAmountUSD' => 'earningAmountUSD',
      'earningAmountUSDCurrency' => 'Earning Amount (USD) (Currency)',
      'earningAmountUSDConverted' => 'Earning Amount (USD) (Converted)',
      'transactionAmountUSD' => 'transactionAmountUSD',
      'transactionAmountUSDCurrency' => 'Transaction Amount (USD) (Currency)',
      'transactionAmountUSDConverted' => 'Transaction Amount (USD) (Converted)',
      'estimatedPaymentMonth' => 'estimatedPaymentMonth',
      'earningDate' => 'EarningDate',
      'partnerCountryCode' => 'partnerCountryCode',
      'earningDate2' => 'Earning Date'
    ],
    'links' => [],
    'labels' => [
      'Create Earn' => 'Crear Earn'
    ],
    'options' => [
      'paymentStatus' => [
        'UNPROCESSED' => 'UNPROCESSED',
        'PROCESSED' => 'PROCESSED',
        'Sent' => 'Sent',
        'Reprocessing' => 'Reprocessing',
        'Upcoming' => 'Upcoming',
        'Sent:Payout Profile Not Available' => 'Sent - Payout Profile Not Available'
      ],
      'transactionCountryCode' => [
        '' => '',
        'BR' => 'BR',
        'MX' => 'MX',
        'EC' => 'EC',
        'AR' => 'AR',
        'CO' => 'CO',
        'CA' => 'CA',
        'CH' => 'CH',
        'BO' => 'BO',
        'PE' => 'PE'
      ],
      'estimatedPaymentMonth' => [
        'Apr-2023' => 'Apr-2023',
        'Mar-2023' => 'Mar-2023',
        'May-2023' => 'May-2023',
        'Jul-2023' => 'Jul-2023',
        'Not applicable' => 'Not applicable'
      ],
      'partnerCountryCode' => [
        'BR' => 'BR',
        'CO' => 'CO',
        'MX' => 'MX',
        'CL' => 'CL',
        'PA' => 'PA',
        'EC' => 'EC',
        'AR' => 'AR',
        'PE' => 'PE'
      ]
    ]
  ],
  'EmailContent' => [
    'fields' => [
      'attachments' => 'Archivos Adjuntos',
      'done' => 'Listo',
      'scheduled' => 'Programado',
      'status' => 'Estado',
      'country' => 'Pais',
      'sendExample' => 'Enviar ejemplo',
      'accounts' => 'Cuentas',
      'content' => 'Mensaje Dinamico',
      'startDate' => 'Fecha de Inicio',
      'endDate' => 'Fecha de Fin',
      'active' => 'Activo',
      'promoContent' => 'Contenido de Promocion',
      'title' => 'Titulo Mensaje dinamico',
      'promoTitle' => 'Titulo de Promocion',
      'emails' => 'Emails',
      'emailAddress' => 'E-mail',
      'accountsList' => 'Lista de Cuentas',
      'contactsList' => 'Lista de Contactos'
    ],
    'links' => [
      'accounts' => 'Cuentas',
      'emails' => 'Emails',
      'accountsList' => 'Lista de Cuentas',
      'contactsList' => 'Lista de Contactos',
      'attachments' => 'Archivos Adjuntos'
    ],
    'labels' => [
      'Create EmailContent' => 'Crear Email Content'
    ],
    'options' => [
      'status' => [
        'Created' => 'Creada',
        'Started' => 'Iniciado/ En Revisión',
        'Completed' => 'Completado',
        'Canceled' => 'Cancelado',
        'Sent' => 'Enviado',
        'Scheduled' => 'Programado'
      ],
      'country' => [
        'Ecuador' => 'Ecuador',
        'Colombia' => 'Colombia',
        'Chile' => 'Chile',
        'Argentina' => 'Argentina',
        'Paraguay' => 'Paraguay',
        'Uruguay' => 'Uruguay',
        'Peru' => 'Peru',
        'Mexico' => 'Mexico',
        'Venezuela' => 'Venezuela',
        'El Salvador' => 'El Salvador',
        'Costa Rica' => 'Costa Rica',
        'Bolivia' => 'Bolivia',
        'Dominican Republic' => 'Dominican Republic',
        'Panama' => 'Panama',
        'Guatemala' => 'Guatemala',
        'Honduras' => 'Honduras',
        'Nicaragua' => 'Nicaragua',
        'Puerto Rico' => 'Puerto Rico',
        'Jamaica' => 'Jamaica',
        'Barbados' => 'Barbados',
        'Guadeloupe' => 'Guadeloupe',
        'Brasil (teste)' => 'Brasil (teste)'
      ]
    ],
    'tooltips' => [
      'sendExample' => 'Haga clic aquí para enviar un correo electrónico de muestra a su dirección de correo electrónico. Asegúrese de agregar su dirección de correo electrónico en el campo que aparece a continuación.',
      'content' => 'Define el contenido del correo electrónico. Puedes insertar texto e imágenes. Asegúrate de que el ancho máximo de la imagen sea de 559 píxeles.',
      'scheduled' => 'Establezca cuándo se debe enviar el correo electrónico a la lista de Cuentas que aparece a continuación. Luego, cambie el estado a "Completado" y marque la casilla "Listo" si el correo electrónico está listo para enviarse en la fecha programada.',
      'country' => 'Seleccione el país para recibir esta comunicación.',
      'attachments' => 'Si hay algún Assest para enviar, por favor adjúntelo aquí.',
      'active' => 'Fecha de rango: Promoción activa',
      'done' => 'Marque la casilla "Listo" si el correo electrónico está listo para enviarse en la fecha programada.',
      'status' => 'Cambie el estado a "Completado" y marque la casilla "Listo" si el correo electrónico está listo para enviarse en la fecha programada.',
      'promoContent' => 'Define el contenido del correo electrónico. Puedes insertar texto e imágenes. Asegúrate de que el ancho máximo de la imagen sea de 559 píxeles.',
      'startDate' => 'Fecha de inicio de la promoción.',
      'endDate' => 'Fecha final de la promoción.',
      'title' => 'Establezca el título para la sección de correo electrónico de promoción.',
      'promoTitle' => 'Establezca el título para la sección de correo electrónico de promoción.',
      'emailAddress' => 'Asegúrese de agregar su dirección de correo electrónico en el campo que se encuentra a continuación y luego haga clic en "Enviar ejemplo". Se le enviará un correo electrónico de muestra a su dirección de correo electrónico registrada.'
    ]
  ],
  'Events' => [
    'fields' => [
      'parent' => 'Padre',
      'dateStart' => 'Fecha de incio',
      'dateEnd' => 'Fecha final',
      'duration' => 'Duracion',
      'status' => 'Estátus',
      'reminders' => 'Recordatorios',
      'dateStartDate' => 'Date Start (all day)',
      'dateEndDate' => 'Date End (all day)',
      'isAllDay' => 'Is All-Day',
      'productBrands' => 'Fabricantes',
      'accounts' => 'Parceiros'
    ],
    'links' => [
      'parent' => 'Padre',
      'productBrands' => 'Fabricantes',
      'accounts' => 'Parceiros'
    ],
    'options' => [
      'status' => [
        'Planned' => 'Planeado',
        'Held' => 'Retenidas',
        'Not Held' => 'Pendientes'
      ]
    ],
    'labels' => [
      'Create Events' => 'Crear Event',
      'Schedule Events' => 'Agendar Event',
      'Log Events' => 'Registrar Event',
      'Set Held' => 'Marcar como Retenida',
      'Set Not Held' => 'Marcar como Pendiente'
    ],
    'massActions' => [
      'setHeld' => 'Marcar como Retenida',
      'setNotHeld' => 'Marcar como Pendiente'
    ],
    'presetFilters' => [
      'planned' => 'Planeado',
      'held' => 'Retenida',
      'todays' => 'Hoy'
    ]
  ],
  'ExternalFormPost' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create ExternalFormPost' => 'Crear ExternalFormPost'
    ]
  ],
  'GoogleCloud' => [
    'fields' => [
      'account' => 'Cuenta',
      'product' => 'Producto',
      'subProduct' => 'Sub Product',
      'amount' => 'Valor',
      'amountCurrency' => 'Valor (Currency)',
      'amountConverted' => 'Valor (Converted)',
      'stage' => 'Etapa',
      'discount' => 'Descuento (%)',
      'googleClouds' => 'Google Cloud',
      'googleCloudParent' => 'Google Cloud Parent',
      'tipodeoportunidad' => 'Tipo de Oportunidad',
      'cantidadDeLicencias' => 'Cantidad de Licencias',
      'contratoATiempo' => 'Contrato a Tiempo',
      'nombreDelProyecto' => 'Nombre del Proyecto',
      'productosAConsumir' => 'Producto/s a consumir',
      'amountProxConsumo' => 'Valor Aproximado de Consumo',
      'amountProxConsumoCurrency' => 'Valor Aproximado Consumo (Divisa)',
      'amountProxConsumoConverted' => 'Valor Aproximado Consumo (Convertido)',
      'edicinDeWorkspace1' => 'Edicion de Workspace',
      'partner' => 'Partner',
      'partnersGoogleCloud' => 'Canal Google Cloud',
      'rebates' => 'Rebates',
      'backend' => 'Backend %',
      'region' => 'Region',
      'country' => 'Pais',
      'oportunidadesGoogle' => 'Oportunidades Google',
      'contratoATiempoList' => 'Contrato a Tiempo'
    ],
    'links' => [
      'meetings' => 'Presentaciones',
      'calls' => 'Llamadas',
      'tasks' => 'Tareas',
      'account' => 'Cuenta',
      'googleClouds' => 'Google Clouds',
      'googleCloudParent' => 'Google Cloud Parent',
      'partner' => 'Partner',
      'partnersGoogleCloud' => 'Canal - Google Cloud',
      'oportunidadesGoogle' => 'Oportunidades Google'
    ],
    'labels' => [
      'Create GoogleCloud' => 'Crear Canal - Google Cloud'
    ],
    'options' => [
      'product' => [
        '' => '',
        'Google Workspace' => 'Google Workspace',
        'Google Cloud Platform' => 'Google Cloud Platform'
      ],
      'subProduct' => [
        '' => '',
        'License Type' => 'Tipo de Licencia',
        'GCP Service' => 'GCP Service'
      ],
      'stage' => [
        'Prospecting' => 'prospección',
        'Proposal' => 'Propuesta',
        'Negotiation' => 'Negociación',
        'Closed Won' => 'Cerrado Ganado',
        'Closed Lost' => 'Cerrado Perdido'
      ],
      'tipodeoportunidad' => [
        '' => '',
        'Upgrade de licencias' => 'Upgrade de licencias',
        'New Business' => 'New Business',
        'Renovación de Licencias' => 'Renovación de Licencias'
      ],
      'nombreDelProyecto' => [
        '' => '',
        'Almacenamiento Cloud' => 'Almacenamiento Cloud',
        'Servidores Web' => 'Servidores Web',
        'AGFA Healthcare as a services' => 'AGFA Healthcare as a services',
        'Recaptcha' => 'Recaptcha'
      ],
      'productosAConsumir' => [
        '' => '',
        'Cloud Storage' => 'Cloud Storage',
        'VM' => 'VM',
        'GCP' => 'GCP',
        'Recaptcha' => 'Recaptcha'
      ],
      'edicinDeWorkspace1' => [
        '' => '',
        'Business Starter' => 'Business Starter',
        'Business Standard' => 'Business Standard',
        'Business Plus' => 'Business Plus',
        'Enterprise Starter' => 'Enterprise Starter',
        'Enterprise Standard ' => 'Enterprise Standard ',
        'Enterprise Plus' => 'Enterprise Plus',
        'Frontline' => 'Frontline'
      ],
      'rebates' => [
        '' => '',
        'Si' => 'Si',
        'No' => 'No'
      ],
      'contratoATiempoList' => [
        '' => '',
        'Plan Flexible' => 'Plan Flexible',
        'Plan a 12 meses de contrato' => 'Plan a 12 meses de contrato',
        'Plan a 24 meses de contrato' => 'Plan a 24 meses de contrato',
        'Plan a 36 meses de contrato' => 'Plan a 36 meses de contrato',
        'Versión de prueba' => 'Versión de prueba'
      ]
    ]
  ],
  'GooglePartnerAdvantage' => [
    'fields' => [
      'productBrand' => 'Product Brand',
      'stage' => 'Stage',
      'qualify' => 'Qualify',
      'refine' => 'Refine',
      'techEvalSolutionDev' => 'Tech Evaluation | Solution Dev',
      'proposalNegotiation' => 'Proposal | Negotiation',
      'lead' => 'Lead',
      'opportunities' => 'Opportunities',
      'amount' => 'Value',
      'amountCurrency' => 'Opportunity Value (Currency)',
      'amountConverted' => 'Opportunity Value (Converted)',
      'update' => 'Update',
      'account' => 'Account Name',
      'opportunityOwner' => 'Opportunity Owner',
      'productFamily' => 'Product Family',
      'email' => 'E-mail',
      'phone' => 'Phone',
      'domain' => 'Client Domain',
      'oppIDGoogle' => 'Opportunity ID',
      'lostReason' => 'Reason for Cancellation/Loss',
      'closeDate' => 'Closing/Loss Date',
      'country' => 'Country',
      'reason' => 'Reason'
    ],
    'links' => [
      'meetings' => 'Presentaciones',
      'calls' => 'Llamadas',
      'tasks' => 'Tareas',
      'productBrand' => 'Product Brand',
      'lead' => 'Lead',
      'opportunities' => 'Opportunities',
      'account' => 'Account Name'
    ],
    'labels' => [
      'Create GooglePartnerAdvantage' => 'Crear Google Partner Advantage'
    ],
    'options' => [
      'stage' => [
        'Qualify' => 'Qualify',
        'Refine' => 'Refine',
        'Tech Evaluation | Solution Dev' => 'Tech Evaluation | Solution Dev',
        'Proposal | Negotiation' => 'Proposal | Negotiation',
        'Closed' => 'Closed',
        '' => 'Nenhum',
        'Lost' => 'Lost'
      ],
      'qualify' => [
        'At least one meeting with C-level, Co- Founder or C-1 level business sponsor.' => 'At least one meeting with C-level, Co- Founder or C-1 level business sponsor.',
        '[Select/Enterprise only] Completed Cloud Account Plan (go/cloudaccountplan)' => '[Select/Enterprise only] Completed Cloud Account Plan (go/cloudaccountplan)',
        'Accept/Reject opportunity in SFDC and progress to Stage 1 (30 day SLA)' => 'Accept/Reject opportunity in SFDC and progress to Stage 1 (30 day SLA)'
      ],
      'refine' => [
        '[Select/Enterprise only] Mutual Evaluation Plan (go/cloud-mep) is recommended.' => '[Select/Enterprise only] Mutual Evaluation Plan (go/cloud-mep) is recommended.',
        'Completed Cloud Project Discovery (go/cloud-pdg)' => 'Completed Cloud Project Discovery (go/cloud-pdg)',
        'Partner Attach' => 'Partner Attach',
        'Solution Tagging' => 'Solution Tagging',
        'Site Selection' => 'Site Selection'
      ],
      'techEvalSolutionDev' => [
        'Decision Maker Signoff on Technical Win' => 'Decision Maker Signoff on Technical Win',
        'Technical Proposal & Architecture (go/cloudtp)' => 'Technical Proposal & Architecture (go/cloudtp)',
        'Technical Deal Blockers Identified' => 'Technical Deal Blockers Identified',
        'Capacity Plan (go/getonering)' => 'Capacity Plan (go/getonering)',
        'Populate Term (Months)' => 'Populate Term (Months)',
        'AI/ML and Business Need (If AI/ML is Yes) are required' => 'AI/ML and Business Need (If AI/ML is Yes) are required'
      ],
      'proposalNegotiation' => [
        'Partner and/or PSO SOW' => 'Partner and/or PSO SOW',
        'Executed Contract' => 'Executed Contract',
        'Countersigned MSA and order form' => 'Countersigned MSA and order form',
        'Commercial Proposal' => 'Commercial Proposal'
      ],
      'productFamily' => [
        '' => '',
        'Google Cloud Platform' => 'Google Cloud Platform',
        'Google Workspace' => 'Google Workspace'
      ],
      'lostReason' => [
        '' => '',
        'SLA' => 'SLA',
        'Cliente não retornou contato' => 'Customer did not return contact',
        'Cliente escolheu outro fornecedor' => 'Customer chose another supplier',
        'Cliente não tem interesse na solução ofertada' => 'Client is not interested in the solution offered',
        'Preços' => 'Prices',
        'Outro' => 'Other'
      ]
    ],
    'tooltips' => [
      'qualify' => 'Indetify initial problem and desire to adress with key Stakeholders.',
      'refine' => 'Problems uncovered and align solution to critical business need.',
      'techEvalSolutionDev' => 'Customer confirmed their required capabilities. Final Solution and POC confirmed.',
      'proposalNegotiation' => 'Technical validation complete and customer agreed to pricing signature date.'
    ]
  ],
  'Importer' => [
    'fields' => [
      'status' => 'Status',
      'inputFile' => 'Arquivo de Entrada',
      'outputFile' => 'Arquivo de Saída',
      'type' => 'Tipo de Dados',
      'detailOppCIS' => 'Detalhes',
      'templateURL' => 'Template URL - Cloud Brasil',
      'documents' => 'Documents'
    ],
    'links' => [
      'documents' => 'Documents'
    ],
    'labels' => [
      'Create Importer' => 'Crear Importador'
    ],
    'options' => [
      'status' => [
        '' => '',
        'Created' => 'Created',
        'Processing' => 'Processing',
        'Done' => 'Done',
        'Error' => 'Error'
      ],
      'type' => [
        '' => '',
        'Oportunidades Brasil' => 'Oportunidades Brasil',
        'Canais AWS LAC' => 'Partner Program AWS MCA ',
        'Oportunidades AWS LAC' => 'Oportunidades AWS MCA',
        'opp_partner_program_aws' => 'Oportunidades AWS MCA'
      ]
    ]
  ],
  'LeadsPartnerCenter' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create LeadsPartnerCenter' => 'Crear Leads Partner Center'
    ]
  ],
  'Marketing' => [
    'fields' => [
      'vendor' => 'Fabricante',
      'startDate' => 'Fecha Inicio',
      'endingDate' => 'Fecha Fin',
      'productBrands' => 'Fabricantes',
      'country' => 'Pais',
      'noExpiration' => 'Sin caducidad',
      'productBrand' => 'Fabricante',
      'category' => 'Category',
      'status' => 'Estado',
      'opportunities' => 'Oportunidades',
      'opportunity' => 'Oportunidad',
      'oportunidade' => 'Oportunidade',
      'investment' => 'Inversión',
      'investmentCurrency' => 'Inversión (Currency)',
      'investmentConverted' => 'Inversión (Converted)',
      'roi' => 'ROI',
      'roiCurrency' => 'ROI (Currency)',
      'roiConverted' => 'ROI (Converted)',
      'profit' => 'Profit',
      'profitCurrency' => 'Ganancia (Currency)',
      'profitConverted' => 'Ganancia (Converted)',
      'profitReal' => 'Profit (BRL)',
      'profitRealCurrency' => 'Profit (BRL) (Currency)',
      'profitRealConverted' => 'Profit (BRL) (Converted)',
      'leads' => 'Leads',
      'contacts' => 'Contacts',
      'name' => 'Nombre de la campaña'
    ],
    'links' => [
      'vendor' => 'Fabricante',
      'productBrands' => 'Fabricante',
      'productBrand' => 'Fabricante',
      'opportunities' => 'Oportunidades',
      'opportunity' => 'Oportunidad',
      'oportunidade' => 'Oportunidade',
      'leads' => 'Leads',
      'contacts' => 'Contacts'
    ],
    'labels' => [
      'Create Marketing' => 'Crear Origen'
    ],
    'options' => [
      'country' => [
        '' => '',
        'Argentina' => 'Argentina',
        'Bolivia' => 'Bolivia',
        'Brasil' => 'Brasil',
        'CCA' => 'CCA',
        'Costa Rica' => 'Costa Rica',
        'Chile' => 'Chile',
        'Colombia' => 'Colombia',
        'Ecuador ' => 'Ecuador ',
        'Dominican Republic' => 'Dominican Republic',
        'El Salvador' => 'El Salvador',
        'Guatemala' => 'Guatemala',
        'Honduras' => 'Honduras',
        'Mexico' => 'Mexico',
        'Panama' => 'Panama',
        'Guadelouope' => 'Guadelouope',
        'Paraguay' => 'Paraguay',
        'Peru' => 'Peru',
        'Puerto Rico' => 'Puerto Rico',
        'Uruguay' => 'Uruguay',
        'Venezuela' => 'Venezuela',
        'Ecuador' => 'Ecuador'
      ],
      'noExpiration' => [
        ' ' => ' '
      ],
      'category' => [
        'Incentivo' => 'Incentive',
        'Digital' => 'Digital',
        '' => ''
      ],
      'status' => [
        '' => '',
        'Activo' => 'Activo',
        'Inactivo ' => 'Inactivo '
      ]
    ],
    'tooltips' => [
      'roi' => 'Suma de los valores de las oportunidades ganadas.\\nSuma de los valores de las oportunidades ganadas.',
      'profit' => 'ROI - Inversión = Ganancia\\nSi el campo no está actualizado, complete cualquier valor para que la plataforma pueda volver a calcular en función de las oportunidades obtenidas.',
      'profitReal' => 'ROI - Inversión = Beneficio\\nSi el campo no está actualizado, complete cualquier valor para que la plataforma rehaga el cálculo en función de las oportunidades obtenidas.'
    ]
  ],
  'Messenger' => [
    'fields' => [
      'account' => 'Account',
      'sendMessage' => 'Send Message',
      'type' => 'Tipo',
      'origin' => 'Origem',
      'channel' => 'Canal',
      'opportunity' => 'Oportunidade',
      'contentAI' => 'Content AI',
      'status' => 'Status',
      'contentReseller' => 'Institucional Revenda',
      'contentClient' => 'Institucional Cliente Final',
      'salesPitch' => 'Benefícios Produto'
    ],
    'links' => [
      'account' => 'Account',
      'opportunity' => 'Oportunidade'
    ],
    'labels' => [
      'Create Messenger' => 'Crear Messenger'
    ],
    'options' => [
      'type' => [
        'Account' => 'Account'
      ],
      'origin' => [
        'AI' => 'AI'
      ],
      'channel' => [
        'Email' => 'Email'
      ],
      'status' => [
        'Sent' => 'Enviado',
        'Error' => 'Erro',
        '' => '',
        'Created' => 'Solicitado'
      ]
    ]
  ],
  'Migrations' => [
    'fields' => [
      'parent' => 'Padre',
      'dateStart' => 'Fecha de incio',
      'dateEnd' => 'Fecha final',
      'duration' => 'Duracion',
      'status' => 'estado',
      'reminders' => 'Recordatorios',
      'dateStartDate' => 'Fecha de inicio (todo el día)',
      'dateEndDate' => 'Fecha de finalización (todo el día)',
      'isAllDay' => 'Es todo el día',
      'accountManager' => 'Gerente de Cuenta / Ventas Internas',
      'bdmCloud' => 'BDM Cloud',
      'bucketTimers' => 'Bucket Duration',
      'processOwner' => 'Propietario del proceso',
      'accountIDAWS' => 'AWS Account ID',
      'bucket' => 'Bucket AWS',
      'cancellationReason' => 'Motivo de Cancelación',
      'checklistConsumo' => 'Lista de Verificación de Consumo',
      'checklistMigration' => 'Lista de Verificación de Ventas | BDM | Movimiento de Facturación',
      'checklistPreSales' => 'Lista de Verificación de Preventa | CoE',
      'completedIn' => 'Completado el',
      'dueDate' => 'Retrasado',
      'estimateAmount' => 'Valor estimado',
      'externalID' => 'External ID',
      'jiraCSC' => 'Jira CSC',
      'jiraEngenharia' => 'Jira de ingeniería',
      'label' => 'Etiqueta',
      'priority' => 'Prioridad',
      'checklistCSC' => 'Lista de Verificación Jira | SSCLOUD',
      'lostReason' => 'Justificación (Oportunidad)',
      'migrationOrigin' => 'Tipo de migración',
      'partialAmount' => 'Valor parcial',
      'partialAmountCurrency' => 'Valor parcial (moneda)',
      'partialAmountConverted' => 'Valor parcial (convertido)',
      'bucketMicrosoft' => 'Bucket Microsoft',
      'checklistMicrosoft1' => 'Identificação e proposta (MOSP/EA/T1/DIST)',
      'checklistMicrosoft2' => 'Sequência após aprovação do cliente (MOSP/EA/T1/DIST)',
      'checklistMicrosoft3' => 'Somente para Migração de T1/DIST',
      'checklistMicrosoft4' => 'Somente para Migração MOSP/EA',
      'checklistMicrosoft5' => 'Sequência após aprovação do cliente (MOSP/EA)',
      'checklistMicrosoft' => 'Identificação e proposta (MOSP/EA)',
      'opportunityStage' => 'Estágio da Oportunidade'
    ],
    'links' => [
      'parent' => 'Padre',
      'accountManager' => 'Gerente de cuentas / Ventas internas',
      'bdmCloud' => 'BDM Cloud',
      'bucketTimers' => 'Bucket Duration',
      'processOwner' => 'Propietario del proceso'
    ],
    'options' => [
      'status' => [
        'Planned' => 'Planeado',
        'Held' => 'Retenidas',
        'Not Held' => 'Pendientes',
        'Cancelled' => 'Cancelado'
      ],
      'accountIDAWS' => [
        'Digite' => 'Escribe y presiona enter'
      ],
      'bucket' => [
        'Upside Pipeline' => 'Upside | Canal de ventas',
        'Fechado | Movimentação de Billing' => 'Cerrado | Movimiento de facturación',
        'Sales | BDM (pendências)' => 'Sales | BDM (pendências)',
        'Validação Pré-vendas | CoE' => 'Validación previa a la venta | CoE (Centro de Excelencia)',
        'Jira | SSCLOUD (criação/migração de org)' => 'Jira | SSCLOUD (criação/migração de org)',
        'Acompanhamento Consumo' => 'Acompanhamento Consumo',
        'Consumo Estimado Concluído' => 'Consumo estimado completado',
        'Cancelado' => 'Cancelado',
        'Jira | SSCLOUD' => 'Jira | SSCLOUD (Creación / Migración de organización)',
        'Acompanhamento | Consumo' => 'Seguimiento | Consumo',
        'Sales | BDM' => 'Ventas | BDM (Elementos pendientes)',
        '' => ''
      ],
      'checklistConsumo' => [
        'Primeiro billing parcial' => 'Primera facturación parcial',
        'Billing completo' => 'Facturación completada'
      ],
      'checklistMigration' => [
        'Validação sobre tipo de conta do Cliente Final (Standalone, Service Prov)' => 'Validación del tipo de cuenta del cliente final (independiente, proveedor de servicios)',
        'Validação sobre de acordo do Parceiro em Proposta / Condições Comerciais' => 'Validación del acuerdo con el socio en la propuesta / Términos comerciales',
        'Validação sobre aprovação de Crédito para Cliente Final' => 'Validación de la aprobación de crédito para el cliente final',
        'Validação sobre existência de créditos do Hyperscaler para Cliente Final' => 'Validación de la disponibilidad de crédito de hyperscaler para el cliente final',
        'Validação sobre plano de suporte contratado na conta' => 'Validación del plan de soporte contratado para la cuenta',
        'Criação do documento "Cloud Check-up" / Abertura de chamado Pré-Vendas' => 'Criação do documento "Cloud Check-up" / Abertura de chamado Pré-Vendas',
        'Criação do documento Cloud Check-up / Abertura de chamado Pré-Vendas' => 'Creación del documento de revisión en la nube / Apertura de ticket de preventa',
        'Validação sobre tipo de conta do Cliente Final (Standalone / Service Prov)' => 'Validação sobre tipo de conta do Cliente Final (Standalone / Service Prov)'
      ],
      'checklistPreSales' => [
        'Validação da estrutura do ambiente do Cliente Final' => 'Validación de la estructura del entorno del cliente final',
        'Validação sobre existência Workloads/Consumo na conta Payer' => 'Validación de la existencia de cargas de trabajo/consumo en la cuenta del pagador',
        'Validação sobre arquivamento de reports de billing anteriores' => 'Validación del archivo de los informes de facturación anteriores',
        'Validação sobre nível de segurança e aderência à Políticas TD Synnex' => 'Validación del nivel de seguridad y cumplimiento de las políticas de TD Synnex',
        'Validação sobre existência Instância Reservadas / Saving Plans' => 'Validación de la existencia de instancias reservadas / planes de ahorro',
        'Validação sobre existência Políticas de Controle de Serviço (SCPs)' => 'Validación de la existencia de políticas de control de servicio (SCPs)',
        'Validação sobre existência Cost Tags Allocations' => 'Validación de la existencia de asignaciones de etiquetas de costo',
        'Validação sobre capacidades de Serviço (Parceiro/Cliente Final)' => 'Validación de las capacidades del servicio (socio/cliente final)',
        'Atualização do documento "Cloud Check-up" / Abertura de chamado CSC' => 'Atualização do documento "Cloud Check-up" / Abertura de chamado CSC',
        'Atualização do documento Cloud Check-up / Abertura de chamado CSC' => 'Actualización del documento de revisión en la nube / Apertura de ticket de CSC'
      ],
      'label' => [
        'AWS' => 'AWS',
        '' => 'Selecione',
        'Microsoft' => 'Microsoft'
      ],
      'priority' => [
        '' => '',
        'Low' => 'Baja',
        'Medium' => 'Media',
        'High' => 'Alta',
        'Urgent' => 'Urgente',
        'Important' => 'Importante'
      ],
      'checklistCSC' => [
        'Abertura do processo administrativo de movimentação' => 'Apertura del proceso administrativo para el movimiento',
        'Validação sobre conclusão do processo administrativo de movimentação' => 'Validación de la finalización del proceso administrativo para el movimiento',
        'Validação dos contatos principais de acesso ao ambiente' => 'Validación de contactos clave de acceso al entorno'
      ],
      'bucketMicrosoft' => [
        'Upside | Pipeline' => 'Upside | Pipeline',
        'Pré-migração' => 'Pré-migração',
        'Execução T1/DIST (Time SSCLOUD JIRA)' => 'Execução T1/DIST (Time SSCLOUD JIRA)',
        'Execução MOSP/EA (Time Serviços)' => 'Execução MOSP/EA (Time Serviços)',
        'Acompanhamento | Consumo' => 'Acompanhamento | Consumo',
        'Consumo Estimado Concluído' => 'Consumo Estimado Concluído',
        'Cancelado' => 'Cancelado',
        '' => ''
      ],
      'checklistMicrosoft1' => [
        'Identificar origem da migração (MOSP/EA ou Dist/T1)' => 'Identificar origem da migração (MOSP/EA ou Dist/T1)',
        'Parceiro/Cliente baixar o CSV para assessment (Somente MOSP/EA)' => 'Parceiro/Cliente baixar o CSV para assessment (Somente MOSP/EA)',
        'Parceiro/Ciente baixar o relatório de consumo detalhado para estimativa' => 'Parceiro/Ciente baixar o relatório de consumo detalhado para estimativa',
        'Enviar ao time de engenharia os relatórios para assessment (Somente MOSP/EA)' => 'Enviar ao time de engenharia os relatórios para assessment (Somente MOSP/EA)',
        'Enviar ao time de engenharia o relatório de consumo detalhado para estimativa' => 'Enviar ao time de engenharia o relatório de consumo detalhado para estimativa',
        'Devolução para o parceiro com resultado do assessment (MOSP/EA)' => 'Devolução para o parceiro com resultado do assessment (MOSP/EA)',
        'Devolução para o parceiro com resultado da estimativa' => 'Devolução para o parceiro com resultado da estimativa',
        'Aprovação do cliente e andamento no fluxo' => 'Aprovação do cliente e andamento no fluxo',
        'Identificar origem da migração' => 'Identificar origem da migração'
      ],
      'checklistMicrosoft2' => [
        'Realizar a administração delegada (MOSP/EA/T1/DIST)' => 'Realizar a administração delegada (MOSP/EA/T1/DIST)',
        'Cadastrar o cliente na plataforma StreamOne Stellr (MOSP/EA/T1/DIST)' => 'Cadastrar o cliente na plataforma StreamOne Stellr (MOSP/EA/T1/DIST)',
        'Incluir um pedido de Azure para o cliente (MOSP/EA/T1/DIST)' => 'Incluir um pedido de Azure para o cliente (MOSP/EA/T1/DIST)',
        'Solicitar ao parceiro/cliente um usuário no modelo tdsynnex@dominiocliente.com.br (Somente MOSP/EA)' => 'Solicitar ao parceiro/cliente um usuário no modelo tdsynnex@dominiocliente.com.br (Somente MOSP/EA)',
        'Permissão do usuário como contribuidor na assinatura de origem e destino (Somente MOSP/EA)' => 'Permissão do usuário como contribuidor na assinatura de origem e destino (Somente MOSP/EA)',
        'Enviar todos os dados para o time de serviços dar inicio a movimentação (Somente MOSP/EA)' => 'Enviar todos os dados para o time de serviços dar inicio a movimentação (Somente MOSP/EA)',
        'Time de serviços realiza a pré-migração (Somente MOSP/EA)' => 'Time de serviços realiza a pré-migração (Somente MOSP/EA)',
        'Relatório de pré-migração enviado ao parceiro/cliente para aprovação final (Somente MOSP/EA)' => 'Relatório de pré-migração enviado ao parceiro/cliente para aprovação final (Somente MOSP/EA)'
      ],
      'checklistMicrosoft3' => [
        'AM abrir solicitação de migração para o time de SSCLOUD (somente T1/DIST)' => 'AM abrir solicitação de migração para o time de SSCLOUD (somente T1/DIST)',
        'Time de SSCLOUD executa a solicitação via Partner Center (somente T1/DIST)' => 'Time de SSCLOUD executa a solicitação via Partner Center (somente T1/DIST)',
        'Migração aprovada verificação TD SYNNEX se a migração foi concluída (somente T1/DIST)' => 'Migração aprovada verificação TD SYNNEX se a migração foi concluída (somente T1/DIST)',
        'Migração concluída (somente T1/DIST)' => 'Migração concluída (somente T1/DIST)',
        'Sincronização da assinatura migrada com o contrato no StreamOne Stellr (somente T1/DIST)' => 'Sincronização da assinatura migrada com o contrato no StreamOne Stellr (somente T1/DIST)',
        'Envio do comando Powershell para o cliente (somente T1/DIST)' => 'Envio do comando Powershell para o cliente (somente T1/DIST)',
        'Retorno do cliente que o comando foi executado com sucesso (somente T1/DIST)' => 'Retorno do cliente que o comando foi executado com sucesso (somente T1/DIST)'
      ],
      'checklistMicrosoft4' => [
        'Agendamento com o cliente para a melhor data (somente MOSP/EA)' => 'Agendamento com o cliente para a melhor data (somente MOSP/EA)',
        'Início da movimentação (somente MOSP/EA)' => 'Início da movimentação (somente MOSP/EA)',
        'Conclusão da movimentação (somente MOSP/EA)' => 'Conclusão da movimentação (somente MOSP/EA)'
      ],
      'checklistMicrosoft5' => [
        'Solicitar ao parceiro/cliente um usuário no modelo tdsynnex@dominiocliente.com.br (Somente MOSP/EA)' => 'Solicitar ao parceiro/cliente um usuário no modelo tdsynnex@dominiocliente.com.br (Somente MOSP/EA)',
        'Permissão do usuário como contribuidor na assinatura de origem e destino (Somente MOSP/EA)' => 'Permissão do usuário como contribuidor na assinatura de origem e destino (Somente MOSP/EA)',
        'Enviar todos os dados para o time de serviços dar inicio a movimentação (Somente MOSP/EA)' => 'Enviar todos os dados para o time de serviços dar inicio a movimentação (Somente MOSP/EA)',
        'Time de serviços realiza a pré-migração (Somente MOSP/EA)' => 'Time de serviços realiza a pré-migração (Somente MOSP/EA)',
        'Relatório de pré-migração enviado ao parceiro/cliente para aprovação final (Somente MOSP/EA)' => 'Relatório de pré-migração enviado ao parceiro/cliente para aprovação final (Somente MOSP/EA)'
      ],
      'checklistMicrosoft' => [
        'Parceiro/Cliente baixar o CSV para assessment (Somente MOSP/EA)' => 'Parceiro/Cliente baixar o CSV para assessment (Somente MOSP/EA)',
        'Enviar ao time de engenharia os relatórios para assessment (Somente MOSP/EA)' => 'Enviar ao time de engenharia os relatórios para assessment (Somente MOSP/EA)',
        'Devolução para o parceiro com resultado do assessment (Somente MOSP/EA)' => 'Devolução para o parceiro com resultado do assessment (Somente MOSP/EA)'
      ]
    ],
    'labels' => [
      'Create Migrations' => 'Crear Migración',
      'Schedule Migrations' => 'Agendar Migración',
      'Log Migrations' => 'Registrar Migración',
      'Set Held' => 'Marcar como Retenida',
      'Set Not Held' => 'Marcar como Pendiente'
    ],
    'massActions' => [
      'setHeld' => 'Marcar como Retenida',
      'setNotHeld' => 'Marcar como Pendiente'
    ],
    'presetFilters' => [
      'planned' => 'Planeado',
      'held' => 'Retenida',
      'todays' => 'Hoy'
    ],
    'tooltips' => [
      'checklistConsumo' => 'Acompanhamento de consumo pós migração.',
      'checklistMicrosoft1' => 'Oportunidade criada pelo time de vendas.',
      'checklistMicrosoft2' => 'Início do processo pré-migração.',
      'checklistMicrosoft3' => 'Abertura pelo AM para o time de SSCLOUD para migrações de T1/DIST.',
      'checklistMicrosoft4' => 'Após aprovação do cliente e todos os pré-requisitos de migração inicia-se a migração de fato.',
      'checklistMicrosoft5' => 'Início do processo pré-migração.',
      'checklistMicrosoft' => 'Oportunidade criada pelo time de vendas.'
    ]
  ],
  'Notifications' => [
    'fields' => [
      'type' => 'Tipo',
      'language' => 'Idioma',
      'banner' => 'Banner'
    ],
    'links' => [],
    'labels' => [
      'Create Notifications' => 'Crear Notification'
    ],
    'options' => [
      'type' => [
        'Information' => 'Information',
        'Notification' => 'Notification',
        '' => ''
      ],
      'language' => [
        '' => '',
        'Português' => 'Português',
        'Espanhol' => 'Espanhol',
        'Español' => 'Español'
      ]
    ]
  ],
  'NurturingForm' => [
    'fields' => [
      'formID' => 'ID do Form',
      'formData' => 'Resultados do Form',
      'nurturingPrefix' => 'Prefixo da instância',
      'nurturingCountry' => 'País da instância',
      'pushContactToIntegration' => 'Enviar leads para integração',
      'formSource' => 'Origem do formulário'
    ],
    'links' => [],
    'labels' => [
      'Create NurturingForm' => 'Crear NurturingForm'
    ],
    'tooltips' => [
      'formID' => 'ID do form o qual deseja buscar os resultados. Apenas o número que pode ser visualizado na URL da instância após clicar no formulário.',
      'nurturingPrefix' => 'Prefixo utilizado no banco de dados da instância. Normalmente é composto de 3 caracteres seguidos da _. Ex: abc_
Em caso de dúvidas, consulte equipe técnica.',
      'pushContactToIntegration' => 'Ao marcar este campo, os resultados deste formulário serão adicionados à entidade de Leads. Atenção: caso o lead já exista no CDP, os dados serão atualizados COM EXCEÇÃO DA ORIGEM.',
      'formSource' => 'Nome da campanha da qual este formulário faz parte. É utilizado internamente para análise de performance e resultados das oportunidades geradas.'
    ],
    'options' => [
      'nurturingCountry' => [
        'Selecione' => 'Selecione',
        'Argentina' => 'westconarg',
        'Brasil' => 'westconbra',
        'CCA' => 'westconcca',
        'Colômbia' => 'westconcol',
        'Chile' => 'westconchi',
        'Equador' => 'westconecu',
        'México' => 'westconmex',
        'Peru' => 'westconpex',
        'westconarg' => 'Argentina',
        'westconbra' => 'Brasil',
        'westconcca' => 'CCA',
        'westconcol' => 'Colômbia',
        'westconchi' => 'Chile',
        'westconecu' => 'Ecuador',
        'westconmex' => 'México',
        'westconper' => 'Peru'
      ]
    ]
  ],
  'OpportunityAWS' => [
    'fields' => [
      'opportunityID' => 'Opportunity ID',
      'aWSAccountID' => 'AWS Account ID',
      'stageAWS' => 'Stage AWS',
      'statusAWS' => 'Status AWS',
      'partnerTypeAWS' => 'Partner Type',
      'useCase' => 'Use Case',
      'segment' => 'Segment',
      'estimatedRevenue' => 'estimated Monthly Recurring Revenue',
      'estimatedRevenueCurrency' => 'estimated Monthly Recurring Revenue (Moneda)',
      'estimatedRevenueConverted' => 'estimated Monthly Recurring Revenue (Convertido)',
      'marketplace' => 'Marketplace',
      'sPMSID' => 'SPMS ID',
      'opportunity' => 'Opportunity'
    ],
    'links' => [
      'opportunity' => 'Opportunity'
    ],
    'labels' => [
      'Create OpportunityAWS' => 'Crear Opportunity AWS'
    ],
    'options' => [
      'stageAWS' => [
        '' => '',
        'Committed' => 'Committed',
        'Qualified' => 'Qualified',
        'Prospect' => 'Prospect',
        'Technical Validation' => 'Technical Validation',
        'Business Validation' => 'Business Validation',
        'Closed Lost' => 'Closed Lost',
        'Canceled' => 'Canceled',
        'Launched' => 'Launched',
        'Completed' => 'Completed'
      ],
      'statusAWS' => [
        '' => '',
        'Approved' => 'Approved',
        'Submitted' => 'Submitted',
        'Action Required' => 'Action Required',
        'Rejected' => 'Rejected'
      ],
      'partnerTypeAWS' => [
        '' => '',
        'ISV' => 'ISV',
        'Consulting' => 'Consulting'
      ],
      'useCase' => [
        '' => '',
        'AI/Machine Learning' => 'AI/Machine Learning',
        'Archiving' => 'Archiving',
        'Big Data' => 'Big Data',
        'Business Applications' => 'Business Applications',
        'Cloud Management Tools & DevOps' => 'Cloud Management Tools & DevOps',
        'Containers & Serverless' => 'Containers & Serverless',
        'Database' => 'Database',
        'End User Computing' => 'End User Computing',
        'Energy' => 'Energy',
        'Financial Services' => 'Financial Services',
        'Healthcare & Life Sciences' => 'Healthcare & Life Sciences',
        'Hybrid application platform' => 'Hybrid application platform',
        'Industrial Software' => 'Industrial Software',
        'IOT' => 'IOT',
        'Media & High performance computing (HPC)' => 'Media & High performance computing (HPC)',
        'Migration' => 'Migration',
        'Monitoring, logging and performance' => 'Monitoring, logging and performance',
        'Networking' => 'Networking',
        'Security' => 'Security',
        'Storage' => 'Storage',
        'Training' => 'Training',
        'Web development & DevOps' => 'Web development & DevOps'
      ],
      'segment' => [
        '' => '',
        'AGS' => 'AGS',
        'CS' => 'CS',
        'PS' => 'PS',
        'SUP' => 'SUP'
      ]
    ]
  ],
  'OpportunityGoogle' => [
    'fields' => [
      'nDealRegistration' => 'N° Deal Registration (Si aplica)',
      'categoryGoogle' => 'Category Google',
      'rebates' => 'Rebates',
      'customerSolution' => 'Necesidad/proyecto que tiene el cliente',
      'decisionMakingAuthority' => 'Autoridad para la toma de decisión',
      'clientbudget' => 'Presupuesto con el que cuenta el cliente (Budget)',
      'dR' => 'DR',
      'backend' => 'Backend',
      'googleCalculator' => 'Link de calculadora de Google',
      'amountproxconsumo' => 'Monto Aproximado de Consumo anual',
      'submissionID' => 'Submission ID',
      'opportunity' => 'Opportunity',
      'nameProject' => 'Nombre del Proyecto'
    ],
    'links' => [
      'opportunity' => 'Opportunity'
    ],
    'labels' => [
      'Create OpportunityGoogle' => 'Crear Opportunity Google'
    ],
    'options' => [
      'categoryGoogle' => [
        '' => '',
        'Google Workspace' => 'Google Workspace',
        'Google Cloud Platform' => 'Google Cloud Platform'
      ]
    ]
  ],
  'Orders' => [
    'fields' => [
      'billingCycle' => 'BillingCycle',
      'contractIdExternal' => 'ContractIdExternal',
      'contractType' => 'ContractType',
      'directbilling' => 'Directbilling',
      'discountPricingRules' => 'DiscountPricingRules',
      'discountPricingRulesCurrency' => 'DiscountPricingRules (Currency)',
      'discountPricingRulesConverted' => 'DiscountPricingRules (Converted)',
      'listPrice' => 'ListPrice',
      'listPriceCurrency' => 'ListPrice (Currency)',
      'listPriceConverted' => 'ListPrice (Converted)',
      'markupPricingRules' => 'MarkupPricingRules',
      'pricingType' => 'PricingType',
      'status' => 'Status',
      'subscriptionID' => 'SubscriptionID',
      'subscriptionName' => 'SubscriptionName',
      'subscriptionQuantity' => 'SubscriptionQuantity',
      'subscriptionAmount' => 'SubscriptionAmount',
      'subscriptionAmountCurrency' => 'SubscriptionAmount (Currency)',
      'subscriptionAmountConverted' => 'SubscriptionAmount (Converted)',
      'orderAmount' => 'OrderAmount',
      'orderAmountCurrency' => 'OrderAmount (Currency)',
      'orderAmountConverted' => 'OrderAmount (Converted)',
      'subscriptionAutomaticRenew' => 'SubscriptionAutomaticRenew',
      'endUserAmount' => 'EndUserAmount',
      'endUserAmountCurrency' => 'EndUserAmount (Currency)',
      'endUserAmountConverted' => 'EndUserAmount (Converted)',
      'orderDiscountOnly' => 'OrderDiscountOnly',
      'cancellationAllowedUntilDate' => 'CancellationAllowedUntilDate',
      'termDuration' => 'TermDuration',
      'assignedUserNameExternal' => 'AssignedUserNameExternal',
      'productName' => 'ProductName',
      'accountName' => 'AccountName',
      'vendorAccountName' => 'VendorAccountName',
      'pricingInfo' => 'PricingInfo',
      'estimate' => 'Estimate',
      'processQueue' => 'ProcessQueue',
      'contractStartDate' => 'ContractStartDate',
      'contractEndDate' => 'ContractEndDate',
      'region' => 'Region',
      'externalId' => 'ExternalId'
    ],
    'links' => [],
    'labels' => [
      'Create Orders' => 'Crear Orders'
    ],
    'options' => [
      'status' => [],
      'processQueue' => [],
      'region' => []
    ]
  ],
  'PBGeral' => [
    'fields' => [
      'account' => 'Cuenta',
      'trilhaCloud' => 'Assessment Cloud',
      'trilhaIOT' => 'Assessment IOT',
      'trilhaSegurana' => 'Assessment Seguridad',
      'technologyStatus' => 'Technology Estado',
      'analyticStatus' => 'Analytic Estado',
      'financialStatus' => 'Financial Estado',
      'marketingStatus' => 'Marketing Estado',
      'strategyStatus' => 'Strategy Estado',
      'country' => 'País',
      'financialStatusCloud' => 'Financial Cloud Estado',
      'organizationalStatusCloud' => 'Organizational Cloud Estado',
      'salesAndMarketingStatusCloud' => 'Sales And Marketing Cloud Estado',
      'strategyStatusCloud' => 'Strategy Cloud Estado',
      'technologystatusCloud' => 'Technology Cloud Estado',
      'cloudCategory' => 'Categoria Cloud',
      'module' => 'Módulo',
      'percepiumID' => 'Percepium ID',
      'percepiumStatus' => 'Percepium estado',
      'cybersolvsStatus' => 'Cybersolvs estado',
      'networksStatus' => 'Networks estado',
      'endpointStatus' => 'Endpoint estado',
      'mobilesecStatus' => 'Mobilesec estado',
      'dataStatus' => 'Data estado',
      'peopleStatus' => 'People estado',
      'securityStatus' => 'Security estado',
      'cloudStatus' => 'Cloud estado',
      'fraudStatus' => 'Fraud estado',
      'assesmentStatus' => 'Assesment Estado',
      'complianceStatus' => 'Compliance estado',
      'policyStatus' => 'Policy estado',
      'trilhaDataAI' => 'Assessment Data IA',
      'dataAICategory' => 'Categoria Data AI'
    ],
    'links' => [
      'account' => 'Cuenta'
    ],
    'labels' => [
      'Create PBGeral' => 'Crear Practice Builder High Growth - Lista'
    ],
    'options' => [
      'technologyStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'analyticStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'financialStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'marketingStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'strategyStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'financialStatusCloud' => [
        '' => 'Incomplete',
        'Finished' => 'Finalizado',
        'Complete' => 'Completo'
      ],
      'organizationalStatusCloud' => [
        '' => 'Incomplete',
        'Finished' => 'Finalizado',
        'Complete' => 'Completo'
      ],
      'salesAndMarketingStatusCloud' => [
        '' => 'Incomplete',
        'Finished' => 'Finalizado',
        'Complete' => 'Completo'
      ],
      'strategyStatusCloud' => [
        '' => 'Incomplete',
        'Finished' => 'Finalizado',
        'Complete' => 'Completo'
      ],
      'technologystatusCloud' => [
        '' => 'Incomplete',
        'Finished' => 'Finalizado',
        'Complete' => 'Completo'
      ],
      'cloudCategory' => [
        '' => '',
        'Starter' => 'Starter',
        'Transformer' => 'Transformer',
        'Accelerator' => 'Accelerator',
        'AWS Onboard the Practice' => 'AWS Onboard the Practice',
        'AWS Startups' => 'AWS Startups',
        'MCPP Transition Path' => 'MCPP Transition Path',
        'Google Cloud Practice Startups' => 'Google Cloud Practice Startups',
        'Google Workspace' => 'Google Workspace',
        'Grow Your HPE GreenLake Practice' => 'Grow Your HPE GreenLake Practice',
        'Develop Your Security Practice' => 'Develop Your Security Practice',
        'Grow Your Security Sales' => 'Grow Your Security Sales'
      ],
      'module' => [
        '' => '',
        'Cloud Practice Builder' => 'Cloud Practice Builder',
        'AWS' => 'AWS',
        'Microsoft' => 'Microsoft',
        'Google' => 'Google',
        'HPE Greenlake' => 'HPE Greenlake',
        'Security' => 'Security'
      ],
      'percepiumStatus' => [
        '' => '',
        'Started' => 'Started',
        'Finished' => 'Finished'
      ],
      'cybersolvsStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'networksStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'endpointStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'mobilesecStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'dataStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'peopleStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'securityStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'cloudStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'fraudStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'assesmentStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'complianceStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'policyStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'dataAICategory' => [
        '' => '',
        'Aware' => 'Aware',
        'Ready' => 'Ready',
        'Expert' => 'Expert'
      ]
    ]
  ],
  'PartnerID' => [
    'fields' => [
      'account' => 'Conta',
      'productBrand' => 'Vendor',
      'surestep' => 'Surestep',
      'surestepLevel' => 'Surestep Level',
      'billing' => 'Billing',
      'name' => 'MPN ID',
      'cloudConsumptions' => 'Cloud Consumptions',
      'salesOrders' => 'Sales Orders',
      'type' => 'Tipo',
      'partnerPrograms' => 'Programas de parceiro',
      'partnerProgram' => 'Programa de parceiro',
      'idType' => 'Tipo de ID',
      'source' => 'Source'
    ],
    'links' => [
      'account' => 'Conta',
      'productBrand' => 'Vendor',
      'surestep' => 'Surestep',
      'cloudConsumptions' => 'Cloud Consumptions',
      'salesOrders' => 'Sales Orders',
      'partnerPrograms' => 'Programas de parceiro',
      'partnerProgram' => 'Programa de parceiro'
    ],
    'labels' => [
      'Create PartnerID' => 'Crear Partner ID'
    ],
    'options' => [
      'billing' => [
        'Azure' => 'Azure',
        'Office' => 'Office',
        'Cisco' => 'Cisco',
        'AWS' => 'AWS'
      ],
      'type' => [
        'Customer' => 'Customer',
        'Reseller' => 'Reseller',
        'ISVs' => 'ISVs',
        'Service Provider' => 'Service Provider'
      ],
      'idType' => [
        '' => '',
        'MPN ID' => 'MPN ID',
        'Tier 2 MPN ID' => 'Tier 2 MPN ID',
        'Tenant' => 'Tenant',
        'Organization' => 'Organization',
        'Unit Organization' => 'Unit Organization',
        'Account ID' => 'Account ID'
      ],
      'source' => [
        'CIS' => 'CIS',
        'Cloudsolv' => 'Cloudsolv',
        'Microsoft_Partner_Center' => 'Microsoft_Partner_Center',
        '' => ''
      ]
    ]
  ],
  'PartnerProgram' => [
    'fields' => [
      'productBrand' => 'Partner Product Brand',
      'partnerIDs' => 'Partner ID',
      'account' => 'Account'
    ],
    'links' => [
      'productBrand' => 'Partner Product Brand',
      'partnerIDs' => 'Partner ID',
      'account' => 'Account'
    ],
    'labels' => [
      'Create PartnerProgram' => 'Crear Programa de parceiro'
    ]
  ],
  'PartnersGoogleCloud' => [
    'fields' => [
      'partnerLevel' => 'Nivel',
      'account' => 'Cuenta',
      'partner' => 'Canal',
      'partnersGoogleClouds' => 'Canal Google Clouds',
      'googleClouds' => 'Google Clouds',
      'email' => 'Email',
      'fechaefectivaHandshake' => 'Handshake Effective Date',
      'lineaDeCredito' => 'Linea de Credito',
      'opportunities' => 'Oportunidades',
      'partnerGoogleCloud' => 'Canal - Google Cloud',
      'contact' => 'Contacto',
      'opportunity' => 'Oportunidad',
      'contacts' => 'Contactos',
      'progresoGoogle' => 'Progreso Google',
      'progresoTDSYNNEX' => 'Progreso TD SYNNEX',
      'emailContact' => 'Email del Contacto',
      'emailPartner' => 'Email del Partner',
      'documentsSends' => 'Documentos Enviados',
      'opportunitys' => 'Oportunidades',
      'accounts' => 'Cuentas',
      'accountS' => 'Cuentas',
      'expertise' => 'Expertise',
      'sector' => 'Sector',
      'cloudID' => 'Cloud ID',
      'formGCP' => 'Form - GCP',
      'formWorkspace' => 'Form - Workspace',
      'dadoDeAltaConTDSYNNEX' => 'Dado de Alta con TD SYNNEX',
      'gws' => 'Google Workspace',
      'gcp' => 'Google Cloud Platform',
      'gcpLevel' => 'Google Cloud Platform - Level',
      'gwsLevel' => 'Google Workspace - Level',
      'countryAccount' => 'Pais',
      'region' => 'Region',
      'phoneContact' => 'Telefono del Contacto'
    ],
    'links' => [
      'meetings' => 'Presentaciones',
      'calls' => 'Llamadas',
      'tasks' => 'Tareas',
      'account' => 'Cuenta',
      'partner' => 'Canal',
      'partnersGoogleClouds' => 'Canal Google Clouds',
      'googleClouds' => 'Google Cloud',
      'opportunities' => 'Oportunidades',
      'partnerGoogleCloud' => 'Canal Google Cloud',
      'contact' => 'Contacto',
      'opportunity' => 'Oportunidad',
      'contacts' => 'Contactos',
      'opportunitys' => 'Oportunidades',
      'accounts' => 'Cuentas',
      'accountS' => 'Cuentas',
      'documentsSends' => 'Documentos Enviados'
    ],
    'labels' => [
      'Create PartnersGoogleCloud' => 'Crear Partner Program - Lista'
    ],
    'options' => [
      'partnerLevel' => [
        'Member' => 'Member',
        'Partner' => 'Partner',
        'Premier Partner' => 'Premier Partner',
        'Onboarding' => 'Onboarding'
      ],
      'progresoGoogle' => [
        'Primer  Contacto' => 'Primer  Contacto',
        'Primera  Reunión' => 'Primera  Reunión',
        'Proceso Enviado Onboarding' => 'Proceso Enviado Onboarding',
        'ID Cloud Enviado' => 'ID Cloud Enviado',
        'Listo Handshake' => 'Listo Handshake'
      ],
      'progresoTDSYNNEX' => [
        'Documentos Enviados' => 'Documentos Enviados',
        'Linea  Credito' => 'Linea  Credito',
        'Streamone Google' => 'Streamone Google',
        'CloudSolv' => 'CloudSolv',
        'GWS' => 'GWS',
        'GCP' => 'GCP',
        'Dado de Alta con TDSYNNEX' => 'Dado de Alta con TDSYNNEX',
        'Dado de Alta con TD SYNNEX' => 'Dado de Alta con TD SYNNEX'
      ],
      'expertise' => [
        '' => '',
        'Application Modernization' => 'Application Modernization',
        'Artificial Intelligence' => 'Artificial Intelligence',
        'Data Management' => 'Data Management',
        'Infraestructure Modernization' => 'Infraestructure Modernization',
        'Productivity & Collaboration' => 'Productivity & Collaboration',
        'Security' => 'Security',
        'Smart Analytics' => 'Smart Analytics'
      ],
      'sector' => [
        '' => '',
        'SMB' => 'SMB',
        'Corporate' => 'Corporate',
        'Enterprise' => 'Enterprise',
        'Public Sector ' => 'Public Sector ',
        'Education' => 'Education'
      ],
      'dadoDeAltaConTDSYNNEX' => [
        'Dado de Alta con TD SYNNEX' => 'Dado de Alta con TD SYNNEX',
        'Si ' => 'Si ',
        ' ' => ' Si'
      ],
      'gcpLevel' => [
        'Onboarding' => 'Onboarding',
        'Member' => 'Member',
        'Partner' => 'Partner',
        'Premier Partner' => 'Premier Partner',
        '' => ''
      ],
      'gwsLevel' => [
        'Onboarding' => 'Onboarding',
        'Member' => 'Member',
        'Partner' => 'Partner',
        'Premier Partner' => 'Premier Partner',
        '' => ''
      ]
    ]
  ],
  'PatchNotes' => [
    'fields' => [
      'releasedate' => 'Release Date',
      'version' => 'Version',
      'updatetype' => 'Update Type',
      'updatestatus' => 'Update Status',
      'description' => 'Detailed Description',
      'name' => 'Update Title'
    ],
    'links' => [],
    'labels' => [
      'Create PatchNotes' => 'Crear Patch Notes'
    ],
    'tooltips' => [
      'releasedate' => 'Indicate when the update will be available.',
      'version' => 'For example, v1.0.1, v2.3, etc.',
      'description' => 'Describe the changes, improvements, or fixes that were implemented.',
      'name' => 'describe the purpose or name of the update.'
    ],
    'options' => [
      'updatetype' => [
        '' => '',
        'New Feature' => 'New Feature',
        'Improvements' => 'Improvements',
        'Bug Fixes' => 'Bug Fixes',
        'Minor Changes' => 'Minor Changes'
      ],
      'updatestatus' => [
        '' => '',
        'Planned' => 'Planned',
        'In Progress' => 'In Progress',
        'Released' => 'Released'
      ]
    ]
  ],
  'Platformaccess' => [
    'fields' => [
      'link' => 'Link'
    ],
    'links' => [],
    'labels' => [
      'Create Platformaccess' => 'Crear Platformaccess'
    ]
  ],
  'Portfolio' => [
    'fields' => [
      'target' => 'Target',
      'url' => 'URL'
    ],
    'links' => [],
    'labels' => [
      'Create Portfolio' => 'Crear Portfolio'
    ]
  ],
  'Progama' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create Progama' => 'Crear Progama'
    ]
  ],
  'Program' => [
    'fields' => [
      'nivel' => 'Nivel',
      'productBrand' => 'Fabricante',
      'account' => 'Conta'
    ],
    'links' => [
      'productBrand' => 'Product Brand',
      'account' => 'Conta'
    ],
    'labels' => [
      'Create Program' => 'Crear Programa'
    ],
    'options' => [
      'nivel' => [
        'Transformer ' => 'Transformer',
        'Starter ' => 'Starter'
      ]
    ]
  ],
  'ProgramaCloudPracticeBuilder' => [
    'fields' => [],
    'links' => [
      'meetings' => 'Presentaciones',
      'calls' => 'Llamadas',
      'tasks' => 'Tareas'
    ],
    'labels' => [
      'Create ProgramaCloudPracticeBuilder' => 'Crear Programa - Cloud Practice Builder'
    ]
  ],
  'ProgramaGoogleCloud' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create ProgramaGoogleCloud' => 'Crear Canal - Google Cloud'
    ]
  ],
  'Renewals' => [
    'fields' => [
      'account' => 'Account',
      'hasRenewals' => 'has Renewals',
      'renewalsAutoOff30Days' => 'No. of Auto-Renew OFF - Next 30 days',
      'renewalsAutoOff60Days' => 'No. of Auto-Renew OFF - From 31 to 60 days',
      'renewalsAutoOff90Days' => 'No. of Auto-Renew OFF - From 61 to 90 days',
      'renewalsEndCustomers30Days' => 'No. of End Customers - Next 30 days',
      'renewalsEndCustomers60Days' => 'No. of End Customers - From 31 to 60 days',
      'renewalsEndCustomers90Days' => 'No. of End Customers - From 61 to 90 days',
      'renewalsLicenses30Days' => 'No. of Licenses - Next 30 days',
      'renewalsLicenses60Days' => 'No. of Licenses - From 31 to 60 days',
      'renewalsLicenses90Days' => 'No. of Licenses - From 61 to 90 days',
      'renewalsRecommendations90Days' => 'No. of Microsoft Recommendations - Next 90 days',
      'renewalsRecommendationsCopilot90Days' => 'No. of Copilot for M365 Recommendations - Next 90 days',
      'renewalsReservedInstances90Days' => 'No. of Reserved Instances - Next 90 days',
      'renewals90Days' => 'Total Renewals - Next 90 Days',
      'accountRenewals' => 'Conta (Renewals)',
      'accountType' => 'Tipo'
    ],
    'links' => [
      'account' => 'Account',
      'accountRenewals' => 'Conta (Renewals)'
    ],
    'labels' => [
      'Create Renewals' => 'Crear Renewal'
    ]
  ],
  'ResultadosFormulariosGoogle' => [
    'fields' => [],
    'links' => [
      'meetings' => 'Presentaciones',
      'calls' => 'Llamadas',
      'tasks' => 'Tareas'
    ],
    'labels' => [
      'Create ResultadosFormulariosGoogle' => 'Crear Resultados Formularios Google'
    ]
  ],
  'RocketMargins' => [
    'fields' => [],
    'links' => [
      'meetings' => 'Presentaciones',
      'calls' => 'Llamadas',
      'tasks' => 'Tareas'
    ],
    'labels' => [
      'Create RocketMargins' => 'Crear Margens Rocket'
    ]
  ],
  'Source' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create Source' => 'Crear Source'
    ]
  ],
  'Sources' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create Sources' => 'Crear Sources'
    ]
  ],
  'Surestep' => [
    'fields' => [
      'newPartner' => 'New Partner to Activate',
      'activateToInspire' => 'Activate to Inspire',
      'inspireToSkyrocketNominee' => 'Inspire to Skyrocket Nominee',
      'skyrocketNomineeToSkyrocket' => 'Skyrocket Nominee to Skyrocket',
      'account' => 'Account',
      'country' => 'Pais',
      'readyToInspire' => 'Ready to Inspire',
      'readyToSkyrocketNominee' => 'Ready to Skyrocket Nominee',
      'readyToSkyrocket' => 'Ready to Skyrocket',
      'readyToActivate' => 'Ready to Activate',
      'surestepLevel' => 'Surestep Level',
      'partnerID' => 'Partner ID',
      'partnerIDs' => 'Partner IDs',
      'mpnNumber' => 'MPN ID Number',
      'accountNumber' => 'Account Number',
      'lead' => 'Lead',
      'levelVerification' => 'LevelVerification',
      'consumptionDate' => 'Consumption Date',
      'cPB' => 'CPB',
      'account1' => 'Account',
      'countrySurestep' => 'Country - Surestep',
      'description' => 'Aviso'
    ],
    'links' => [
      'meetings' => 'Presentaciones',
      'calls' => 'Llamadas',
      'tasks' => 'Tareas',
      'account' => 'Account',
      'partnerID' => 'Partner ID',
      'partnerIDs' => 'Partner IDs',
      'lead' => 'Lead',
      'cPB' => 'CPB',
      'account1' => 'Account'
    ],
    'labels' => [
      'Create Surestep' => 'Crear Partner Program - Lista'
    ],
    'options' => [
      'newPartner' => [
        'Contact Form Completed' => 'Contact Form Completed',
        '1:1 Meeting with Surestep Ambassador' => '1:1 Meeting with Surestep Ambassador',
        'Skill Mapping (Assessment)' => 'Skill Mapping (Assessment)'
      ],
      'activateToInspire' => [
        'TD / SYNNEX Account Number' => 'TD / SYNNEX Account Number',
        'MPN ID' => 'MPN ID',
        'Partner Center Complete Training' => 'Partner Center Complete Training',
        'One Consumption (Last 3 Months)' => 'One Consumption (Last 3 Months)',
        'One Fundamental Certification' => 'One Fundamental Certification',
        '1Q Business Plan Approval and Execution' => '1Q Business Plan Approval and Execution'
      ],
      'inspireToSkyrocketNominee' => [
        'Action Pack Acquisition' => 'Action Pack Acquisition',
        'Silver or Gold Competency' => 'Silver or Gold Competency',
        'Recurrent Consumption (Last Quarter)' => 'Recurrent Consumption (Last Quarter)',
        '1H Business Plan Approval and Execution' => '1H Business Plan Approval and Execution'
      ],
      'skyrocketNomineeToSkyrocket' => [
        'Approval and Nomination (Microsoft Team)' => 'Approval and Nomination (Microsoft Team)',
        'Approval' => 'Approval',
        'Nomination' => 'Nomination'
      ],
      'surestepLevel' => [
        'New Partner' => 'New Partner',
        'Activate' => 'Activate',
        'Inspire' => 'Inspire',
        'SKR' => 'SKR',
        'TopSKR' => 'TopSKR',
        '' => '',
        'In Process' => 'In Process to Activate'
      ],
      'levelVerification' => [
        'New Partner' => 'New Partner',
        'Activate' => 'Activate',
        'Inspire' => 'Inspire',
        'SKR' => 'SKR',
        'TopSKR' => 'TopSKR'
      ],
      'countrySurestep' => []
    ],
    'tooltips' => [
      'readyToActivate' => 'Please, confirm to follow to the next step. You won\'t be able to revert this action after saving, if you don\'t want to go to the next step, please cancel.',
      'readyToInspire' => 'Please, confirm to follow to the next step. You won\'t be able to revert this action after saving, if you don\'t want to go to the next step, please cancel.',
      'readyToSkyrocket' => 'Please, confirm to end the Surestep Process. You won\'t be able to revert this action after saving, if you don\'t want to go to the next step, please cancel.',
      'readyToSkyrocketNominee' => 'Please, confirm to follow to the next step. You won\'t be able to revert this action after saving, if you don\'t want to go to the next step, please cancel.'
    ]
  ],
  'TechnicalSupport' => [
    'fields' => [
      'opportunities' => 'Opportunities'
    ],
    'links' => [
      'opportunities' => 'Opportunities'
    ],
    'labels' => [
      'Create TechnicalSupport' => 'Crear TechnicalSupport'
    ]
  ],
  'TourContent' => [
    'fields' => [
      'content' => 'Content',
      'entity' => 'Entity',
      'language' => 'Language',
      'selector' => 'Selector',
      'step' => 'Step',
      'title' => 'Title'
    ],
    'links' => [],
    'labels' => [
      'Create TourContent' => 'Crear TourContent'
    ],
    'options' => [
      'language' => [
        'en_US' => 'en_US',
        'pt_BR' => 'pt_BR',
        'es_MX' => 'es_MX',
        'select' => 'Select'
      ]
    ]
  ],
  'VendorAccount' => [
    'fields' => [
      'partnershipType' => 'PartnershipType',
      'productBrand' => 'Product Brand',
      'account' => 'Account',
      'source' => 'Source'
    ],
    'links' => [
      'productBrand' => 'Product Brand',
      'account' => 'Account'
    ],
    'labels' => [
      'Create VendorAccount' => 'Crear VendorAccount'
    ],
    'options' => [
      'partnershipType' => [
        'Distributor' => 'Distributor',
        'Reseller' => 'Reseller',
        'Customer' => 'Customer'
      ],
      'source' => [
        'CIS' => 'CIS',
        'Cloudsolv' => 'Cloudsolv',
        'Microsoft_Partner_Center' => 'Microsoft_Partner_Center',
        '' => ''
      ]
    ]
  ],
  'VendorCloudConsumption' => [
    'fields' => [
      'productBrands' => 'Product Brands',
      'category' => 'Category',
      'region' => 'Region',
      'resellerName' => 'Partner',
      'usageperiod' => 'Billing Period',
      'subscriptionId' => 'SubscriptionId',
      'cost' => 'Cost',
      'costCurrency' => 'Cost (Currency)',
      'costConverted' => 'Cost (Converted)',
      'price' => 'Price',
      'priceCurrency' => 'Price (Currency)',
      'priceConverted' => 'Price (Converted)',
      'lastDay1' => 'D-1',
      'lastDay2' => 'D-2',
      'lastDay3' => 'D-3',
      'alertLevel' => 'Alert Level',
      'budgetAlert' => 'Budget Alert',
      'forecast' => 'Forecast',
      'forecastCurrency' => 'Forecast (Currency)',
      'forecastConverted' => 'Forecast (Converted)',
      'endCustomer' => 'End Customer',
      'lastUpdated' => 'Last Updated',
      'description' => 'Updated at:',
      'rocketURL' => 'Rocket',
      'salesOrder' => 'Sales Order',
      'top10' => 'Top 10',
      'customerId' => 'CustomerId',
      'country' => 'Country',
      'billingPeriodConverted' => 'BillingPeriodConverted',
      'resellerId' => 'ResellerId',
      'usage' => 'Usage (Quantity)',
      'invoiceId' => 'InvoiceId',
      'vendorSubscription' => 'Vendor Subscription',
      'partnerName' => 'Partner Name',
      'partnerId' => 'PartnerId',
      'lastUpdate' => 'Last Update'
    ],
    'links' => [
      'productBrands' => 'Product Brands',
      'salesOrder' => 'Sales Order',
      'vendorSubscription' => 'Vendor Subscription'
    ],
    'labels' => [
      'Create VendorCloudConsumption' => 'Crear VendorCloudConsumption'
    ],
    'options' => [
      'category' => [
        'AWS' => 'AWS',
        'GCP' => 'GCP',
        'AZURE' => 'AZURE',
        'LICENSE' => 'LICENSE',
        '' => '',
        'OFFICE' => 'NCE',
        'OFFICE-USAGE' => 'Legacy'
      ],
      'alertLevel' => [
        'None' => 'None',
        'Yellow' => 'Yellow',
        'Orange' => 'Orange',
        'Red' => 'Red'
      ],
      'country' => [
        'COL' => 'COL',
        'CCA' => 'CCA',
        'ECU' => 'ECU',
        'ARG' => 'ARG',
        'PER' => 'PER',
        'CHI' => 'CHI',
        'BRA' => 'BRA',
        '' => '',
        'MEX' => 'MEX'
      ]
    ]
  ],
  'VendorContract' => [
    'fields' => [
      'periodoImportado' => 'periodoImportado',
      'contratoMs' => 'contratoMs',
      'tipo' => 'tipo',
      'fornecedor' => 'fornecedor',
      'nomeFornecedor' => 'nomeFornecedor',
      'directBilling' => 'directBilling',
      'clienteFaturamento' => 'clienteFaturamento',
      'descricaoCliente' => 'descricaoCliente',
      'descricaoRevendedor' => 'descricaoRevendedor',
      'codItem' => 'codItem',
      'descricaoItem' => 'descricaoItem',
      'chargeType' => 'chargeType',
      'syndicationPartnerSubscriptionNumber' => 'syndicationPartnerSubscriptionNumber',
      'quantidade' => 'quantidade',
      'precoUnitario' => 'precoUnitario',
      'valorTotal' => 'valorTotal',
      'descContrato' => 'descContrato',
      'acresContrato' => 'acresContrato',
      'descRevenda' => 'descRevenda',
      'vlrPercentualComissao' => 'vlrPercentualComissao',
      'valorComissao' => 'valorComissao',
      'resellerUnitPrice' => 'resellerUnitPrice',
      'totalRV' => 'totalRV',
      'endUserUnitPrice' => 'endUserUnitPrice',
      'totalCF' => 'totalCF',
      'tblPreco' => 'tblPreco',
      'orderId' => 'orderId',
      'invoice' => 'invoice',
      'dataAprovManual' => 'dataAprovManual',
      'usuarioAprovManual' => 'usuarioAprovManual',
      'usuario' => 'usuario',
      'horaAprov' => 'horaAprov',
      'facturaVenta' => 'facturaVenta',
      'ordenCompra' => 'ordenCompra',
      'log' => 'log',
      'nfGerada' => 'nfGerada',
      'subCategoria' => 'subCategoria',
      'inicioCobranca' => 'InicioCobranca',
      'fimCobranca' => 'FimCobranca',
      'statusContrato' => 'StatusContrato',
      'paises' => 'Paises',
      'revendedor' => 'revendedor'
    ],
    'links' => [],
    'labels' => [
      'Create VendorContract' => 'Crear VendorContract'
    ],
    'options' => [
      'statusContrato' => [
        'Faturado' => 'Faturado',
        'Crédito Vinculado' => 'Crédito Vinculado',
        'Não Validado' => 'Não Validado',
        'NF Devolvida' => 'NF Devolvida',
        'Validado' => 'Validado',
        '' => ''
      ],
      'paises' => [
        'TD SYNNEX CALA, INC' => 'TD SYNNEX CALA, INC',
        'TD SYNNEX CHILE LIMITADA' => 'TD SYNNEX CHILE LIMITADA',
        'TD SYNNEX COLOMBIA' => 'TD SYNNEX COLOMBIA',
        'TD SYNNEX ECUADOR CIA. LTDA.' => 'TD SYNNEX ECUADOR CIA. LTDA.',
        'TD SYNNEX PERU S.A.C.' => 'TD SYNNEX PERU S.A.C.',
        'WESTCON ARGENTINA' => 'WESTCON ARGENTINA'
      ]
    ]
  ],
  'VendorSubscription' => [
    'fields' => [
      'account' => 'Account',
      'vendorSubscriptionId' => 'VendorSubscriptionId',
      'status' => 'Status',
      'quantity' => 'Quantity',
      'offerId' => 'OfferId',
      'unitType' => 'UnitType',
      'hasPurchasableAddons' => 'HasPurchasableAddons',
      'creationDate' => 'CreationDate',
      'effectiveStartDate' => 'EffectiveStartDate',
      'commitmentEndDate' => 'CommitmentEndDate',
      'commitmentEndDateTime' => 'CommitmentEndDateTime',
      'cancellationAllowedUntilDate' => 'CancellationAllowedUntilDate',
      'billingCycleEndDate' => 'BillingCycleEndDate',
      'billingCycleEndDateTime' => 'BillingCycleEndDateTime',
      'autoRenewEnabled' => 'AutoRenewEnabled',
      'billingType' => 'BillingType',
      'billingCycle' => 'BillingCycle',
      'termDuration' => 'TermDuration',
      'renewalTermDuration' => 'RenewalTermDuration',
      'isMicrosoftProduct' => 'IsMicrosoftProduct',
      'partnerId' => 'PartnerId',
      'contractType' => 'ContractType',
      'orderId' => 'OrderId',
      'partnerName' => 'PartnerName',
      'vendorCloudConsumptions' => 'Vendor Cloud Consumptions',
      'publisherName' => 'PublisherName',
      'isTrial' => 'IsTrial',
      'country' => 'Country',
      'offerName' => 'OfferName',
      'externalIDcdp' => 'ExternalIDcdp'
    ],
    'links' => [
      'account' => 'Account',
      'vendorCloudConsumptions' => 'Vendor Cloud Consumptions'
    ],
    'labels' => [
      'Create VendorSubscription' => 'Crear VendorSubscription'
    ],
    'options' => [
      'status' => [
        'active' => 'Active',
        'deleted' => 'Deleted',
        'suspended' => 'Suspended',
        'disabled' => 'Disabled',
        'expired' => 'Expired'
      ],
      'country' => [
        'UR' => 'UR',
        'MX' => 'MX',
        'BR' => 'BR',
        'CO' => 'CO',
        'PA' => 'PA',
        'AR' => 'AR',
        'EC' => 'EC',
        'CL' => 'CL',
        'PE' => 'PE',
        '' => ''
      ]
    ]
  ]
];
