<?php
/*********************************************************************************
 * The contents of this file are subject to the TD SYNNEX MCA Advanced Pack
 * Agreement ("License") which can be viewed at
 * https://www.espocrm.com/advanced-pack-agreement.
 * By installing or using this file, You have unconditionally agreed to the
 * terms and conditions of the License, and You may not use this file except in
 * compliance with the License.  Under the terms of the license, You shall not,
 * sublicense, resell, rent, lease, distribute, or otherwise  transfer rights
 * or usage to the software.
 * 
 * Copyright (C) 2015-2020 Letrium Ltd.
 * 
 * License ID: 17e980fb90b374d15b20258de2855b7b
 ***********************************************************************************/

namespace Espo\Modules\Advanced\Core;

use Espo\ORM\EntityManager;
use Espo\ORM\Entity;
use Espo\Core\Utils\Config;

class SignalManager
{
    protected $entityManager;
    protected $workflowManager;
    protected $config;

    public function __construct(EntityManager $entityManager, WorkflowManager $workflowManager, Config $config)
    {
        $this->entityManager = $entityManager;
        $this->workflowManager = $workflowManager;
        $this->config = $config;
    }

    public function trigger($signal, ?Entity $entity = null, array $options = [])
    {
        if (is_array($signal))
            $signal = implode('.', $signal);

        if ($this->config->get('signalsDisabled')) return null;

        if ($entity) {
            $this->workflowManager->process($entity, '$' . $signal, $options);
        } else {
            if ($this->config->get('signalsRegularDisabled')) return;

            $listenerList = $this->entityManager->getRepository('BpmnSignalListener')
                ->select(['id'])
                ->order('number')
                ->where([
                    'name' => $signal,
                    'isTriggered' => false,
                ])->find();

            foreach ($listenerList as $item) {
                $item->set('isTriggered', true);
                $item->set('triggeredAt', date('Y-m-d H:i:s'));
                $this->entityManager->saveEntity($item);
            }
        }
    }

    public function subscribe(string $signal, string $flowNodeId) : string
    {
        if ($this->config->get('signalsDisabled')) return null;
        if ($this->config->get('signalsRegularDisabled')) return null;

        $item = $this->entityManager->createEntity('BpmnSignalListener', [
            'name' => $signal,
            'flowNodeId' => $flowNodeId,
        ]);

        return $item->id;
    }

    public function unsubscribe(string $id)
    {
        $this->entityManager->getRepository('SignalListener')->deleteFromDb($id);
    }
}
