<?php
/*
 * This file is part of the extension: Ebla Kanban Multiple
 * Copyright (c) Eblasoft Bilişim Ltd.
 *
 * This Software is the property of Eblasoft Bilişim Ltd. and is protected
 * by copyright law - it is NOT Freeware and can be used only in one project
 * under a proprietary license, which is delivered along with this program.
 * If not, see <http://eblasoft.com.tr/eula>.
 *
 * This Software is distributed as is, with LIMITED WARRANTY AND LIABILITY.
 * Any unauthorised use of this Software without a valid license is
 * a violation of the License Agreement.
 *
 * According to the terms of the license you shall not resell, sublicense,
 * rent, lease, distribute or otherwise transfer rights or usage of this
 * Software or its derivatives. You may modify the code of this Software
 * for your own needs, if source code is provided.
 */

namespace Espo\Modules\EblaKanbanMultiple\Controllers;

use Espo\Controllers\EntityManager;
use Espo\Core\Api\Request;
use Espo\Core\DataManager;
use Espo\Core\Exceptions\BadRequest;
use Espo\Core\Exceptions\Error;
use Espo\Core\Exceptions\Forbidden;
use Espo\Core\InjectableFactory;
use Espo\Core\Utils\Metadata;
use Espo\Entities\User;
use Espo\Tools\EntityManager\EntityManager as EntityManagerTool;
use Espo\Tools\LinkManager\LinkManager;

class EblaKanbanMultiple extends EntityManager
{

    /**
     * @throws Forbidden
     */
    public function __construct(
        private User $user,
        private Metadata $metadata,
        private DataManager $dataManager,
        EntityManagerTool $entityManagerTool,
        LinkManager $linkManager,
        InjectableFactory $injectableFactory
    ) {
        if (!$this->user->isAdmin()) {
            throw new Forbidden();
        }

        parent::__construct($user, $entityManagerTool, $linkManager, $injectableFactory);
    }

    /**
     * @throws BadRequest
     */
    public function postActionIgnoredStatusFieldsOptions(Request $request): bool
    {
        $data = $request->getParsedBody();

        if (empty($data->scope) || !$data->data) {
            throw new BadRequest();
        }

        if (!property_exists($data, 'data')) {
            throw new BadRequest();
        }

        $clientDefs = $this->metadata->get(['clientDefs', $data->scope]);

        if (array_key_exists('eblaKanbanMultipleIgnoreOptions', $clientDefs)) {
            $clientDefs['eblaKanbanMultipleIgnoreOptions'] = $data->data;
            $this->metadata->set('clientDefs', $data->scope, $clientDefs);

        } else {
            $this->metadata->set('clientDefs', $data->scope, [
                "eblaKanbanMultipleIgnoreOptions" => (object)[
                    $data->statusField => $data->data->statusIgnoredOptions,
                ]
            ]);

        }

        $this->metadata->save();
        $this->dataManager->updateCacheTimestamp();

        return true;
    }

    /**
     * @throws BadRequest
     * @throws Error
     */
    public function postActionKanban(Request $request): bool
    {
        $data = $request->getParsedBody();

        if (empty($data->scope) || !$data->data) {
            throw new BadRequest();
        }

        if (!property_exists($data, 'data')) {
            throw new BadRequest();
        }

        $this->metadata->set('clientDefs', $data->scope, [
            'eblaKanbanMultipleFields' => $data->data->listActionButtons ? $data->data->listActionButtons : null,
        ]);

        $this->metadata->save();

        $this->dataManager->updateCacheTimestamp();

        return true;
    }
}
