<?php

namespace Espo\Modules\EblaKanbanMultiple\Tools\Kanban;


use Espo\Core\ORM\EntityManager;
use Espo\Core\Utils\Id\RecordIdGenerator;
use Espo\Core\Utils\Metadata;
use Espo\Modules\EblaKanbanMultiple\Tools\Kanban\OrdererProcessor as EblaOrdererProcessor;
use Espo\Tools\Kanban\Orderer as EspoOrderer;
use Espo\Tools\Kanban\OrdererProcessor;

class Orderer extends EspoOrderer
{
    private $entityManager;

    private $metadata;
    private RecordIdGenerator $idGenerator;

    public function __construct(EntityManager $entityManager, Metadata $metadata , RecordIdGenerator $idGenerator)
    {
        $this->entityManager = $entityManager;
        $this->metadata = $metadata;
        $this->idGenerator = $idGenerator;

        parent::__construct($entityManager, $metadata, $idGenerator);
    }

    public function createProcessor(): OrdererProcessor
    {
        return new EblaOrdererProcessor(
            $this->entityManager,
            $this->metadata,
            $this->idGenerator
        );
    }
}
