<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2015-2025 Letrium Ltd.
 *
 * License ID: a67be8f75bc1974a987315ddc1024a78
 ************************************************************************************/

use Espo\Core\Container;
use Espo\Entities\Extension;
use Espo\ORM\EntityManager;

class BeforeInstall
{
    /**
     * @throws \Espo\Core\Exceptions\Error
     */
    public function run(Container $container)
    {
        /** @var EntityManager $entityManager */
        $entityManager = $container->get('entityManager');

        $extension = $entityManager
            ->getRDBRepository(Extension::ENTITY_TYPE)
            ->where(['name' => 'Advanced Pack'])
            ->findOne();

        if ($extension && version_compare($extension->get('version'), '2.0.0', '<')) {
            throw new \Espo\Core\Exceptions\Error('You need to uninstall the old version of Advanced Pack first.');
        }
    }
}
