const STATUS = {
    IN_REVIEW: "In Review",
    APPROVED: "Approved",
    PRESENTED: "Presented"
}

function getParams() {
    let billingContactId;
    if (localStorage.getItem('debug') == 'on') {
        billingContactId = "661ec5182301a80de"
    } else {
        billingContactId = prompt("Por favor, insira sua chave de acesso:", "");

    }
    return billingContactId
}
getClientId(getParams())

var currentQuote = ""
var totalProduct = 0
var quotesId = []

function getClientId(billingContactId) {
    var myHeaders = new Headers();
    myHeaders.append("Authorization", "Basic bWF0aGV1c2w6VHViYXJAMDE=");
    var requestOptions = {
        method: 'GET',
        headers: myHeaders,
        redirect: 'manual'
    };

    fetch(`https://cdp.cloudanalytics.me/api/v1/Quote?maxSize=200&offset=0&orderBy=status&where[0][type]=equals&where[0][attribute]=billingContactId&where[0][value]=${billingContactId}`, requestOptions)
        .then(response => response.json())
        .then(data => {

            yepnope({
                test: Modernizr.csstransforms,
                yep: ['assets/turnjs4/lib/turn.js'],
                nope: ['assets/turnjs4/lib/turn.html4.min.js'],
                both: ['css/basic.css'],
                complete: appLoad
            })
            // $('h2').text(data.list[0].billingContactName)
            var aprovedArray = data.list.filter((data) => data.status == STATUS.APPROVED)
            var reviewArray = data.list.filter((data) => data.status == STATUS.IN_REVIEW)
            var presentedArray = data.list.filter((data) => data.status == STATUS.PRESENTED)
            presentedArray.forEach((element, index) => {
                quotesId.push('.' + element.id)
                let total = 0
                switch (element.id) {
                    case '61e5b28830e0c8841':
                        total = 'USD 55.038,95'
                        break;
                    case '61e090aa1171e2625':
                        total = 'USD 47.802,79'
                        break;

                    case '61e73ce63da97fa3f':
                        total = `USD ${element.amountConverted.toFixed(2)}`
                        break;
                    default:
                        total = `${element.amount.toLocaleString('pt-br', { style: 'currency', currency: 'BRL' })}`
                }
                loadQuotes(element.id, function (response) {
                    var formattedDate = response.dateQuoted;
                    formattedDate = formattedDate.split('-')
                    formattedDate = `${formattedDate[2]}/${formattedDate[1]}/${formattedDate[0]}`
                    $('.list-quotes').append(`
                    <div class="row g-0 align-items-center">
                        <a href="#" data-sample="${element.id}" class="col-md-6" >
                            <div class="row g-0 row g-0 align-items-center">
                                <div class="col-md-6 title-quote text-blue">${response.name}</div>
                                <div class="col-md-6 budget">${total}</div>
                            </div>
                        </a>
                        <div class="col-md-6 text-center">
                            <div class="row g-0 align-items-center">
                                <div class="col-md-4 text-center">
                                    <button type="button" style="width:90%; background-color: #08BED5; border: 0;" class="btn btn-primary visualize-button" data-sample="${element.id}" data-bs-toggle="modal" data-bs-target="#modalView" >
                                        Visualizar
                                    </button>
                                </div>
                                <div class="col-md-4 text-center">
                                    <button type="button" style="width:90%; background-color: #2D9F88; border: 0;" class="btn btn-primary accept-button">
                                        Aceitar
                                    </button>
                                </div>
                                <div class="col-md-4 text-center">
                                    <button type="button" style="width:90%; background-color: #63666A; border: 0;" class="btn btn-primary review-button" data-bs-toggle="modal" data-bs-target="#modalQuote" >
                                        Revisar
                                    </button>
                                </div>
                            </div>
                            <div class="row g-0 align-items-center">
                                <p style="margin: 10px 0 0 0;"><strong>Data da Cotação: </strong>${formattedDate}</p>
                            </div>
                        </div>
                        
                    </div>
                `)
                })

            });
            setTimeout(function () {
                reviewArray.forEach((element, index) => {
                    quotesId.push('.' + element.id)
                    let total = 0
                    switch (element.id) {
                        case '61e5b28830e0c8841':
                            total = 'USD 55.038,95'
                            break;
                        case '61e090aa1171e2625':
                            total = 'USD 47.802,79'
                            break;

                        case '61e73ce63da97fa3f':
                            total = `USD ${element.amountConverted.toFixed(2)}`
                            break;
                        default:
                            total = `${element.amount.toLocaleString('pt-br', { style: 'currency', currency: 'BRL' })}`
                    }
                    loadQuotes(element.id, function (response) {
                        $('.list-quotes').append(`
                    <div class="row g-0 align-items-center">
                        <a href="#" data-sample="${element.id}" class="col-md-6" >
                            <div class="row g-0 row g-0 align-items-center">
                                <div class="col-md-6 title-quote text-blue">${response.name}</div>
                                <div class="col-md-6 budget">${total}</div>
                            </div>
                        </a>
                        <div class="col-md-6 text-center" style="color: #525f7f">
                            Em revisão
                        </div>
                    </div>
                `)
                    })

                });
            }, 100)
            setTimeout(function () {
                aprovedArray.forEach((element, index) => {
                    quotesId.push('.' + element.id)
                    let total = 0
                    switch (element.id) {
                        case '61e5b28830e0c8841':
                            total = 'USD 55.038,95'
                            break;
                        case '61e090aa1171e2625':
                            total = 'USD 47.802,79'
                            break;

                        case '61e73ce63da97fa3f':
                            total = `USD ${element.amountConverted.toFixed(2)}`
                            break;
                        default:
                            total = `${element.amount.toLocaleString('pt-br', { style: 'currency', currency: 'BRL' })}`
                    }
                    loadQuotes(element.id, function (response) {
                        $('.list-quotes').append(`
                    <div class="row g-0 align-items-center">
                    <a href="#" data-sample="${element.id}" class="col-md-6" >
                        <div class="row g-0 row g-0 align-items-center">
                            <div class="col-md-6 title-quote text-blue">${response.name}</div>
                            <div class="col-md-6 budget">${total}</div>
                        </div>
                    </a>
                    <div class="col-md-6 text-center">
                    <div class="col-md-12 budget" style="color: #525f7f">Aprovado em: ${response.dateInvoiced.split("-")[0]}/${response.dateInvoiced.split("-")[1]}/${response.dateInvoiced.split("-")[2]}</div>
                    </div>
                </div>
                `)
                    })

                });
            }, 300)




            setTimeout(() => {
                var sendReviewButton = document.querySelector('.send-review');
                var reviewContent = document.querySelector('#review-content');

                var acceptButtons = document.querySelectorAll('.accept-button');
                var reviewButtons = document.querySelectorAll('.review-button');
                acceptButtons.forEach(function (button) {
                    button.addEventListener('click', function () {
                        var x = button.parentElement
                        var y = x.previousElementSibling
                        UpdateQuote(y.dataset.sample, { "status": STATUS.APPROVED })
                    })
                })

                reviewButtons.forEach(function (button) {
                    button.addEventListener('click', function () {
                        var x = button.parentElement
                        var y = x.previousElementSibling.previousElementSibling
                        sendReviewButton.addEventListener('click', function () {
                            console.log(reviewContent.value);
                            var payload = {
                                "status": STATUS.IN_REVIEW,
                                "reply": reviewContent.value
                            }
                            UpdateQuote(y.dataset.sample, payload)
                        })
                    })
                })
                clickQuote()
            }, 1000);
        })
        .catch(error => {
            console.log(error)
        });

}

function clickQuote() {
    $('[data-sample]').on('click', function (e) {

        e.preventDefault();
        $('#book-zoom').empty()
        $('.samples').hide()
        className = '.' + $(this).attr('data-sample')
        let id = $(this).attr('data-sample');
        document.querySelector(".open-book").addEventListener('click', function () {
            loadQuotes(id, function (response) {
                mountQuotes(response)
            })
        })

    })
    $('.quit').on('click', function () {
        $('.samples').hide()
        $('#book-zoom').empty()
    })
}

function loadQuotes(id, callback) {
    var myHeaders = new Headers();
    myHeaders.append("Authorization", "Basic bWF0aGV1c2w6VHViYXJAMDE=");
    var requestOptions = {
        method: 'GET',
        headers: myHeaders,
        redirect: 'manual'
    };
    fetch(`https://cdp.cloudanalytics.me/api/v1/Quote/${id}`, requestOptions)
        .then(response => response.json())
        .then(data => {
            callback(data)
        })
        .catch(error => {
            console.log(error)
        });

}
function loadBrands(callback) {
    var myHeaders = new Headers();
    myHeaders.append("Authorization", "Basic bWF0aGV1c2w6VHViYXJAMDE=");
    var requestOptions = {
        method: 'GET',
        headers: myHeaders,
        redirect: 'manual'
    };
    fetch(`https://cdp.cloudanalytics.me/api/v1/ProductBrand`, requestOptions)
        .then(response => response.json())
        .then(response => {
            var count = response.list.length;
            var quantityFirst = Math.round(count / 2) - 1
            response.list.map((item, index) => {
                id = item.id

                var list = `<a href="/brand?id=${id}" target="_blank" title="As informações do Fabricante serão abertas em uma nova guia.">
            <div class="row no-gutters">
            ${item.brandLogoId !== null && `<div class="col-md-8"><img src="https://cdp.cloudanalytics.me/?entryPoint=DubasPublicAttachment&id=${item.brandLogoId}" alt="Logo ${item.name}" class="img-custom"></div>`}
            <div class="col-md-4 title-quote text-blue">${item.name}</div>
            
            </div></a>`;
                $('.product-info.brand-1 .list-brand ').append(list)

            })
        })
        .catch(error => {
            console.log(error)
        });

}

function getAgent(id, callback) {
    var myHeaders = new Headers();
    myHeaders.append("Authorization", "Basic bWF0aGV1c2w6VHViYXJAMDE=");
    var requestOptions = {
        method: 'GET',
        headers: myHeaders,
        redirect: 'manual'
    };
    fetch(`https://cdp.cloudanalytics.me/api/v1/User/${id}`, requestOptions)
        .then(response => response.json())
        .then(data => {
            callback(data)
        })
        .catch(error => {
            console.log(error)
        });
}


function mountQuotes(data) {
    var tpl = '';
    var user = ''
    let total = 0
    currentQuote = data.id
    switch (data.id) {
        case '61e5b28830e0c8841':
            total = 'USD 55.038,95'
            break;
        case '61e090aa1171e2625':
            total = 'USD 47.802,79'
            break;
        case '61e73ce63da97fa3f':
            total = `USD ${data.amountConverted.toFixed(2)}`
            break;
        default:
            total = `${data.amount.toLocaleString('pt-br', { style: 'currency', currency: 'BRL' })}`
    }

    getAgent(data.assignedUserId, function (response) {
        var desc = ""
        let total = 0
        switch (currentQuote) {
            case '61e5b28830e0c8841':
                total = 'USD 55.038,95'
                break;
            case '61e090aa1171e2625':
                total = 'USD 47.802,79'
                break;
            case '61e73ce63da97fa3f':
                total = `USD ${data.amountConverted.toFixed(2)}`
                break;
            default:
                total = data.amount.toLocaleString('pt-br', { style: 'currency', currency: 'BRL' })
        }
        user = response
        if (data.commercialConditions == null) {
            var email = ""
            console.log(user.emailAddress)
            if (user.emailAddress != "") {
                email = user.emailAddress
            }
            desc = `Em caso de dúvidas sobre essa cotação, entre em contato conosco via email ${email}`
        } else {
            desc = data.commercialConditions.replaceAll('\n', '<br/>')
        }
        user = response
        tpl = `<div class="flipbook-viewport">
                <div class="holder">
                    <div class="${data.id} page-quote">
                        <div class="page capa"></div>
                        <div class="page content grey">
                            <div class="info">
                                <h2 class="title">Em nossa essência, somos uma empresa que se importa</h2>
                                <h3 class="sub-title">Quem Somos</h3>
                                <p>Nosso programa de cidadania corporativa é uma extensão natural de nossos valores compartilhados. Assim como mantemos os mais altos padrões todos os dias, nossos parceiros em todo o mundo também o fazem. É por isso que a TD SYNNEX tem compromissos claros para reduzir nossa pegada de carbono e promover um ambiente de trabalho diversificado, equitativo e inclusivo.</p>
                            </div>
                            <div class="blue d-flex justify-content-end flex-column">
                                <div class="address">
                                    <div class="row">
                                        <div class="col-7 col-sm-7 border-right">
                                            <p>Av. Alfredo Egídio de Souza Aranha, 100 <br>
                                            Chácara Santo Antônio<br>
                                            SP, 04726-170</p>
                                        </div>
                                        <div class="col-5 col-sm-5 text-center">
                                            <img src="./assets/images/logo.png" alt="">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="footer">01 | TD SYNNEX</div>
                        </div>
                        <div class="page content bg d-flex justify-content-end flex-column">
                            <div class="blue agent">
                                <div class="row infos">
                                    <div class="col-md-12 proposal">
                                        <h2>${data.accountName}</h2>
                                        <h3>${data.name}</h3>
                                    </div>
                                    <div class="col-md-5 info-proposal address">
                                        <p><strong>Data: </strong> ${data.dateQuoted}</p>
                                        <p><strong>Número: </strong> ${data.number}</p>
                                        <p><strong>Valor: </strong> ${total}</p>
                                    </div>
                                    
                                    <div class="col-md-7 info-proposal address">
                                        <div class="row">
                                            ${user.avatarId !== null ? `<div class="col-md-3 col-4">
                                            <img src="https://cdp.cloudanalytics.me/?entryPoint=DubasPublicAttachment&id=${user.avatarId}" alt="" width="60">
                                        </div>` : ''}
                                            
                                            <div class="col-md-9 col-8">
                                                <p><strong>Agente: </strong> ${user.name}</p>
                                            </div>
                                        </div>
                                        
                                    </div>
                                    
                                </div>
                                
                            </div>
                            <div class="footer">TD SYNNEX | 02</div>
                        </div>
                        <div class="page content grey">
                            <div class="info">
                                <h2 class="title">Informações para Faturamento</h2>
                                <h3 class="sub-title"> ${data.name} | ${data.number}</h3>
                            </div>
                            <div class="box-info">
                                <h4>Dados da Revenda</h4>
                                <div class="row">
                                    <div class="form-fake col-md-12">
                                        <p class="label">Nome</p>
                                        <p class="input">${data.accountName}</p>
                                    </div>
                                    <div class="form-fake col-md-6">
                                        <p class="label">Data da Cotação</p>
                                        <p class="input">${data.dateQuoted}</p>
                                    </div>
                                    <div class="form-fake col-md-6">
                                        <p class="label">Numero da Cotação</p>
                                        <p class="input">${data.number}</p>
                                    </div>
                                </div>
                                <hr>
                                <h4>Endereço de Entrega</h4>
                                <div class="row">
                                    <div class="form-fake col-md-12">
                                        <p class="label">Logradouro</p>
                                        <p class="input">${data.shippingAddressStreet !== "" ? data.shippingAddressStreet : data.billingAddressStreet}</p>
                                    </div>
                                    
                                    <div class="form-fake col-md-4">
                                        <p class="label">Cidade</p>
                                        <p class="input">${data.shippingAddressCity !== "" ? data.shippingAddressCity : data.billingAddressCity}</p>
                                    </div>
                                    <div class="form-fake col-md-2">
                                        <p class="label">Estado</p>
                                        <p class="input">${data.shippingAddressState !== "" ? data.shippingAddressState : data.billingAddressState}</p>
                                    </div>
                                    <div class="form-fake col-md-3">
                                        <p class="label">CEP</p>
                                        <p class="input">${data.shippingAddressPostalCode !== "" ? data.shippingAddressPostalCode : data.billingAddressPostalCode}</p>
                                    </div>
                                </div>
                            </div>
                            <div class="footer border-top">03 | TD SYNNEX</div>
                        </div>
                        <div class="page content grey">
                            <div class="info">
                                <h2 class="title">Informação do Produto</h2>
                                <h3 class="sub-title"> ${data.name} | ${data.number}</h3>
                            </div>
                            <div class="box-info product-info">
                                <div class="list-products">
                                </div>
                                <div class="row flex-row-reverse ">
                                    <div class="col-md-3 pt-2 pb-4">
                                        <button type="button" class="btn btn-primary" onclick="download('${data.id}')">Download</button>
                                    </div>
                                </div>
                            </div>
                            <div class="footer border-top" style="text-align:right;">TD SYNNEX | 04</div>
                        </div>
                        <div class="page content grey">
                            <div class="info">
                                <h2 class="title">Fabricantes</h2>
                            </div>
                            <div class="box-info product-info brand-1">
                                <div class="list-brand">
                                <div id="gallery-1" class="gallery galleryid-79 gallery-columns-5 gallery-size-full" style="text-align: center;">
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/01-a10.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/02-Aerohive.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/03-appgate.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/04-appviewx.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/05-arcserve.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/06-Arista.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/aruba.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/08-audiocodes-1.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/09-avaya.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/10-aws.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/11-backbox_logo.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/12-barracuda.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/13-bigswitch.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2023/02/logo-cisco.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/14-cylance.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/15-bluecat.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/16-brocade.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img width="250" height="250"
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/carbon.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        >
                                    </div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/18-checkpoint.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/ciena.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/citrix.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/22-commscope.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/23-commvault2.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/24-cumulus.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/cyberark_GS.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/Cyberpower.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/dell.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/27-eaton.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/28-ekahau.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/29-erwin.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/30-exabeam.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/31-exagrid.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/32-ExtraHop.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/extreme.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/34-f5.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/35-fidelis.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/36-fireeye.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/37-Firemon.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/38-Forcepoint.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/39-forescout.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/40-Fortinet.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/41-gfi.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/42-gigamon_n.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/google.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/43-hpe.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/hitachi.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/44-ibm.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/45-idaptive.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/46-imperva.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/47-infoblox.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/48-infovista.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/integraoptics_GS.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/50-ivanti.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/51-ixia.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/52-Jabra.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/53-juniper.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/54-kemp.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/55-Lenovo-1.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/56-lifesize.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/57-logrhytm.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/58-logitech.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/microfocus.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/59-microsoft.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/60-netap.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/NFBlueBG_GS.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/62-netscout.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/Netwitness.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/63-niagara.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/64-nokia.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/65-nozomi.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/nvidia.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/66-opengear-n.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/67-oracle.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/68-paloalto-n.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/69-poly.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/70-pulse.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/71-purestorage.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/72-purple.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/73-qnap.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/74-quantum.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/75-rackamount.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/76-radware.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/RedHat.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/77-rsa.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/78-Rubrik.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/ruckus.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/81-spirent.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/80-sonicwall.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/82-splunk.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/84-teamviewer.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/85-tenable.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2023/03/thales-logo.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/86-Trend-Micro.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img width="494" height="494"
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/tripwire-logo-white-1-svg.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        >wp-content/uploads/sites/33/2022/10/tripwire-logo-white-1-svg-12x12.png 12w"
                                            sizes="(max-width: 494px) 100vw, 494px">
                                    </div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/88-troy.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/89-tufin.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/90-varonis.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/veeam.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/vertros.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/93-vmware.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/zoom.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/zscaler.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                            </div>
                                </div>
                            </div>
                            <div class="footer border-top">05 | TD SYNNEX</div>
                        </div>
                        <div class="page content grey page-2">
                            <div class="info">
                                <h2 class="title">Observações</h2>
                            </div>
                            <div class="box-info product-info brand-2">
                                <div class="list-ob pb-3">
                                    ${desc}
                                </div>
                            </div>
                            <div class="footer border-top" style="text-align:right;"> TD SYNNEX | 06</div>
                        </div>
                        
                        <div class="page contra-capa"></div>
                    </div>
                </div>
            </div>`


        $('#book-zoom').append(tpl)
        // loadBrands()
        if (data.itemList.length > 0) {

            var list = `<a target="_blank" title="As informações do Produto serão abertas em uma nova guia.">
            <div class="row g-0 ">
                <div class="col-md-5 title-quote text-blue p-2 pt-0 pb-0" style="font-size:12px">Nome do Produto</div>
                <div class="col-md-2 quantity text-center" style="font-size:10px;">Valor Unitário</div>
                <div class="col-md-2 quantity text-center" style="font-size:10px;">Quantidade</div>
                <div class="col-md-3 budget text-center" style="font-size:10px;">Valor Total</div>
            </div></a>`;
            $('.product-info .list-products').append(list)

            data.itemList.map((item, key) => {
                console.log(data)
                var list = `<a  title="As informações do Produto serão abertas em uma nova guia.">
                    <div class="row g-0 ">
                        <div class="col-md-5 title-quote text-blue p-2 pt-0 pb-0" style="font-size:12px">${item.name}</div>
                        <div class="col-md-2 quantity text-center">${item.unitPrice.toLocaleString('pt-br', { style: 'currency', currency: 'BRL' })}</div>
                        <div class="col-md-2 quantity text-center">${item.quantity}</div>
                        <div class="col-md-3 budget text-center">${(item.unitPrice * item.quantity).toLocaleString('pt-br', { style: 'currency', currency: 'BRL' })}</div>
                    </div></a>`;

                $('.product-info .list-products').append(list)

            })

        }
        setTimeout(() => {

            if ($(window).width() > 768) {
                $(className).turn({
                    width: 1060,
                    height: 550,
                    elevation: 50,
                    gradients: true,
                    autoCenter: true
                });
                $('.samples').show()
            } else {
                $('.samples').show()
            }
        }, 2000);
    })

}

function download(id) {
    var myHeaders = new Headers();
    myHeaders.append("Authorization", "Basic bWF0aGV1c2w6VHViYXJAMDE=");
    myHeaders.append("Content-Type", "application/json");
    var raw = JSON.stringify({
        "idList": [
            id
        ],
        "entityType": "Quote",
        "templateId": "61256edb1baefa825"
    });

    var requestOptions = {
        method: 'POST',
        headers: myHeaders,
        body: raw,
        redirect: 'follow'
    };

    fetch("https://cdp.cloudanalytics.me/api/v1/Pdf/action/massPrint", requestOptions)
        .then(response => response.json())
        .then(result => {
            window.open('https://cdp.cloudanalytics.me/?entryPoint=download&id=' + result.id)
        })
        .catch(error => console.log('error', error));
}

function appLoad() {

}


function UpdateQuote(id, request) {
    var myHeaders = new Headers();
    myHeaders.append("Authorization", "Basic bWF0aGV1c2w6VHViYXJAMDE=");
    myHeaders.append("Content-Type", "application/json");
    var requestOptions = {
        method: 'PATCH',
        headers: myHeaders,
        redirect: 'manual',
        body: JSON.stringify(request)
    };

    fetch(`https://cdp.cloudanalytics.me/api/v1/Quote/${id}`, requestOptions)
        .then(response => response.json())
        .then(data => {
            console.log(data)
            location.reload(true)
        })
        .catch(error => {
            console.log(error)
        });
}