/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2015-2025 Letrium Ltd.
 *
 * License ID: e4c270586a0c8a9fda53bda910f357e0
 ************************************************************************************/

define('advanced:views/bpmn-flowchart-element/fields/message-related-to', ['views/fields/enum'], function (Dep, From) {

    return Dep.extend({

        fetchEmptyValueAsNull: true,

        setupOptions: function () {
            const list = [''];
            const translatedOptions = {};

            if (this.getMetadata().get(['scopes', this.model.targetEntityType, 'object'])) {
                list.push('targetEntity');
            }

            const ignoreEntityTypeList = ['User', 'Email'];

            this.model.elementHelper.getTargetCreatedList().forEach(item => {
                const entityType = this.model.elementHelper.getEntityTypeFromTarget(item);

                if (~ignoreEntityTypeList.indexOf(entityType)) {
                    return;
                }

                if (!this.getMetadata().get(['scopes', entityType, 'object'])) {
                    return;
                }

                list.push(item);

                translatedOptions[item] = this.model.elementHelper.translateTargetItem(item);
            });

            this.model.elementHelper.getTargetLinkList(2, false, false).forEach(item => {
                const entityType = this.model.elementHelper.getEntityTypeFromTarget(item);

                if (~ignoreEntityTypeList.indexOf(entityType)) {
                    return;
                }

                if (!this.getMetadata().get(['scopes', entityType, 'object'])) {
                    return;
                }

                list.push(item);

                translatedOptions[item] = this.model.elementHelper.translateTargetItem(item);
            });

            this.params.options = list;

            translatedOptions[''] = this.translate('None');

            translatedOptions['targetEntity'] =
                this.getLanguage().translateOption('targetEntity', 'emailAddress', 'BpmnFlowchartElement') +
            ' · ' + this.translate(this.model.targetEntityType, 'scopeNames');

            this.translatedOptions = translatedOptions;
        },
    });
});
