<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2024-2025 Letrium Ltd.
 *
 * License ID: f27e70ce6801a13265271f5669c8bc5c
 ************************************************************************************/

namespace Espo\Modules\Project\Entities;

use Espo\Core\ORM\Entity;

class ProjectColumn extends Entity
{
    public const ENTITY_TYPE = 'ProjectColumn';

    public function getName(): string
    {
        return $this->get('name');
    }

    public function getMappedStatus(): string
    {
        return $this->get('mappedStatus') ?? '';
    }

    public function getOrder(): int
    {
        return $this->get('order') ?? 0;
    }

    public function getBoardId(): string
    {
        return $this->get('boardId') ?? '';
    }

    public function setName(string $name): self
    {
        $this->set('name', $name);

        return $this;
    }

    public function setMappedStatus(string $status): self
    {
        $this->set('mappedStatus', $status);

        return $this;
    }

    public function setBoardId(string $boardId): self
    {
        $this->set('boardId', $boardId);

        return $this;
    }

    public function setOrder(int $order): self
    {
        $this->set('order', $order);

        return $this;
    }
}
