<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2024-2025 Letrium Ltd.
 *
 * License ID: f27e70ce6801a13265271f5669c8bc5c
 ************************************************************************************/

namespace Espo\Modules\Project\Hooks\ProjectColumn;

use Espo\Core\Hook\Hook\BeforeSave;
use Espo\Core\ORM\Repository\Option\SaveOption;
use Espo\Core\Utils\Metadata;
use Espo\Modules\Project\Entities\ProjectBoard;
use Espo\Modules\Project\Entities\ProjectColumn;
use Espo\ORM\Collection;
use Espo\ORM\Entity;
use Espo\ORM\EntityManager;
use Espo\ORM\Repository\Option\SaveOptions;

/**
 * @implements BeforeSave<ProjectColumn>
 */
class ReOrder implements BeforeSave
{
    public function __construct(
        private EntityManager $entityManager,
        private Metadata $metadata,
    ) {}

    public function beforeSave(Entity $entity, SaveOptions $options): void
    {
        if (!$entity->isNew()) {
            return;
        }

        /** @var string[] $statusList */
        $statusList = $this->metadata->get("entityDefs.ProjectTask.fields.status.options") ?? [];

        $columns = $this->getColumns($entity);

        $i = 0;
        $newList = [];

        foreach ($statusList as $status) {
            foreach ($columns as $column) {
                if ($column->getMappedStatus() === $status) {
                    $newList[] = $column;

                    $column->setOrder($i);
                    $i++;
                }
            }

            if ($entity->getMappedStatus() === $status) {
                $newList[] = $entity;

                $entity->setOrder($i);
                $i++;
            }
        }

        foreach ($newList as $column) {
            if ($column->getId() === $entity->getId()) {
                continue;
            }

            $this->entityManager->saveEntity($column, [SaveOption::SILENT => true]);
        }
    }

    /**
     * @return iterable<ProjectColumn>
     */
    private function getColumns(ProjectColumn $entity): iterable
    {
        $board = $this->entityManager
            ->getRDBRepositoryByClass(ProjectBoard::class)
            ->getById($entity->getBoardId());

        if (!$board) {
            return [];
        }

        /** @var Collection<ProjectColumn> */
        return $this->entityManager
            ->getRDBRepositoryByClass(ProjectBoard::class)
            ->getRelation($board, 'columns')
            ->order('order')
            ->find();
    }
}
