<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2024-2025 Letrium Ltd.
 *
 * License ID: f27e70ce6801a13265271f5669c8bc5c
 ************************************************************************************/

namespace Espo\Modules\Project\Hooks\ProjectTask;

use Espo\Core\Hook\Hook\BeforeSave;
use Espo\Modules\Project\Entities\ProjectColumn;
use Espo\Modules\Project\Entities\ProjectTask;
use Espo\Modules\Project\Tools\ProjectTask\RecordService;
use Espo\ORM\Entity;
use Espo\ORM\EntityManager;
use Espo\ORM\Repository\Option\SaveOptions;

/**
 * @implements BeforeSave<ProjectTask>
 */
class SetStatus implements BeforeSave
{
    public function __construct(
        private EntityManager $entityManager,
    ) {}

    public function beforeSave(Entity $entity, SaveOptions $options): void
    {
        if (!$entity->getColumnId()) {
            return;
        }

        if ($options->get(RecordService::SAVE_OPTION_SKIP_SET_STATUS)) {
            return;
        }

        $column = $this->entityManager
            ->getRDBRepositoryByClass(ProjectColumn::class)
            ->getById($entity->getColumnId());

        if (!$column) {
            return;
        }

        $entity->setStatus($column->getMappedStatus());
    }
}
