<?php
return [
  'aclDefs' => [
    'ActionHistoryRecord' => [
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\ActionHistoryRecord\\OwnershipChecker'
    ],
    'Attachment' => [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\Attachment\\AccessChecker',
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\Attachment\\OwnershipChecker',
      'portalAccessCheckerClassName' => 'Espo\\Classes\\AclPortal\\Attachment\\AccessChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Classes\\AclPortal\\Attachment\\OwnershipChecker'
    ],
    'AuthToken' => [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\AuthToken\\AccessChecker'
    ],
    'Email' => [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\Email\\AccessChecker',
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\Email\\OwnershipChecker',
      'portalAccessCheckerClassName' => 'Espo\\Classes\\AclPortal\\Email\\AccessChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Classes\\AclPortal\\Email\\OwnershipChecker',
      'assignmentCheckerClassName' => 'Espo\\Classes\\Acl\\Email\\AssignmentChecker',
      'readOwnerUserField' => 'users',
      'linkCheckerClassNameMap' => [
        'parent' => 'Espo\\Classes\\Acl\\Email\\LinkCheckers\\ParentLinkChecker',
        'teams' => 'Espo\\Classes\\Acl\\Email\\LinkCheckers\\TeamsLinkChecker'
      ]
    ],
    'EmailFilter' => [
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\EmailFilter\\OwnershipChecker'
    ],
    'Import' => [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\Import\\AccessChecker'
    ],
    'ImportEml' => [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\ImportEml\\AccessChecker'
    ],
    'ImportError' => [
      'accessCheckerClassName' => 'Espo\\Core\\Acl\\AccessChecker\\AccessCheckers\\Foreign',
      'link' => 'import'
    ],
    'Note' => [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\Note\\AccessChecker',
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\Note\\OwnershipChecker',
      'portalAccessCheckerClassName' => 'Espo\\Classes\\AclPortal\\Note\\AccessChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Classes\\AclPortal\\Note\\OwnershipChecker'
    ],
    'Notification' => [
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\Notification\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Classes\\AclPortal\\Notification\\OwnershipChecker'
    ],
    'Portal' => [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\Portal\\AccessChecker'
    ],
    'ScheduledJob' => [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\ScheduledJob\\AccessChecker'
    ],
    'Team' => [
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\Team\\OwnershipChecker'
    ],
    'User' => [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\User\\AccessChecker',
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\User\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Classes\\AclPortal\\User\\OwnershipChecker'
    ],
    'Webhook' => [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\Webhook\\AccessChecker',
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\Webhook\\OwnershipChecker'
    ],
    'WorkingTimeRange' => [
      'assignmentCheckerClassName' => 'Espo\\Classes\\Acl\\WorkingTimeRange\\AssignmentChecker'
    ],
    'Account' => [
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\AclPortal\\Account\\OwnershipChecker'
    ],
    'Call' => [
      'accessCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Call\\AccessChecker',
      'assignmentCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Meeting\\AssignmentChecker',
      'readOwnerUserField' => 'users',
      'contactLink' => 'contacts',
      'accountLink' => 'account'
    ],
    'CampaignLogRecord' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\CampaignLogRecord\\OwnershipChecker'
    ],
    'CampaignTrackingUrl' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\CampaignTrackingUrl\\OwnershipChecker'
    ],
    'Case' => [
      'linkCheckerClassNameMap' => [
        'lead' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Case\\LinkCheckers\\LeadLinkChecker',
        'account' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Case\\LinkCheckers\\AccountLinkChecker',
        'contact' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Case\\LinkCheckers\\ContactLinkChecker',
        'contacts' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Case\\LinkCheckers\\ContactLinkChecker'
      ],
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\AclPortal\\Case\\OwnershipChecker',
      'contactLink' => 'contacts',
      'accountLink' => 'account'
    ],
    'Contact' => [
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\AclPortal\\Contact\\OwnershipChecker',
      'accountLink' => 'accounts'
    ],
    'Document' => [
      'contactLink' => 'contacts',
      'accountLink' => 'accounts'
    ],
    'KnowledgeBaseArticle' => [
      'portalAccessCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\AclPortal\\KnowledgeBaseArticle\\AccessChecker'
    ],
    'MassEmail' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\MassEmail\\OwnershipChecker',
      'linkCheckerClassNameMap' => [
        'inboundEmail' => 'Espo\\Modules\\Crm\\Classes\\Acl\\MassEmail\\LinkCheckers\\InboundEmailLinkChecker'
      ],
      'accessCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\MassEmail\\AccessChecker'
    ],
    'Meeting' => [
      'accessCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Meeting\\AccessChecker',
      'assignmentCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Meeting\\AssignmentChecker',
      'readOwnerUserField' => 'users',
      'contactLink' => 'contacts',
      'accountLink' => 'account'
    ],
    'Opportunity' => [
      'contactLink' => 'contacts',
      'accountLink' => 'account'
    ],
    'Task' => [
      'linkCheckerClassNameMap' => [
        'parent' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Task\\LinkCheckers\\ParentLinkChecker',
        'account' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Task\\LinkCheckers\\AccountLinkChecker'
      ],
      'contactLink' => 'contacts',
      'accountLink' => 'account'
    ],
    'BpmnFlowNode' => [
      'accessCheckerClassName' => 'Espo\\Modules\\Advanced\\Classes\\Acl\\BpmnFlowNode\\AccessChecker'
    ],
    'BpmnProcess' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Advanced\\Classes\\Acl\\BpmnProcess\\OwnershipChecker'
    ],
    'Report' => [
      'accessCheckerClassName' => 'Espo\\Modules\\Advanced\\Classes\\Acl\\Report\\AccessChecker',
      'portalAccessCheckerClassName' => 'Espo\\Modules\\Advanced\\Classes\\AclPortal\\Report\\AccessChecker'
    ],
    'DeliveryOrder' => [
      'accountLink' => 'account'
    ],
    'DeliveryOrderItem' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'InventoryAdjustmentItem' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'InventoryNumber' => [
      'accessCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\InventoryNumber\\AccessChecker'
    ],
    'Invoice' => [
      'accountLink' => 'account'
    ],
    'InvoiceItem' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'OpportunityItem' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'PriceBook' => [
      'accountLink' => 'accounts'
    ],
    'PriceRule' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\PriceRule\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\PriceRule\\OwnershipChecker',
      'accessCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\PriceRule\\AccessChecker'
    ],
    'ProductPrice' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\ProductPrice\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\ProductPrice\\OwnershipChecker',
      'accessCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\ProductPrice\\AccessChecker'
    ],
    'PurchaseOrder' => [
      'accountLink' => 'account'
    ],
    'PurchaseOrderItem' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'Quote' => [
      'accountLink' => 'account'
    ],
    'QuoteItem' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'ReceiptOrder' => [
      'accountLink' => 'account'
    ],
    'ReceiptOrderItem' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'ReturnOrder' => [
      'accountLink' => 'account'
    ],
    'ReturnOrderItem' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'SalesOrder' => [
      'accountLink' => 'account'
    ],
    'SalesOrderItem' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'SupplierProductPrice' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\SupplierProductPrice\\OwnershipChecker'
    ],
    'TransferOrderItem' => [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'Analytics' => [
      'contactLink' => 'contacts',
      'accountLink' => NULL
    ],
    'Api' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'Assessment' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'CDashboardAccess' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'CImporter' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'CPatchNotes' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'CRecommendations' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'CRecommendationsConfig' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'CspUsage' => [
      'contactLink' => 'contact',
      'accountLink' => NULL
    ],
    'Monitoring' => [
      'contactLink' => 'contacts',
      'accountLink' => 'account'
    ],
    'OrderManager' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'PartnerID' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'QnA' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'Recommendation' => [
      'contactLink' => 'contact',
      'accountLink' => 'account'
    ],
    'ResourceCategory' => [
      'contactLink' => 'contact',
      'accountLink' => 'account'
    ],
    'ResourceGroup' => [
      'contactLink' => 'contacts',
      'accountLink' => 'account'
    ],
    'Rocket' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'Subscriptions' => [
      'contactLink' => 'contacts',
      'accountLink' => 'account'
    ],
    'Tags' => [
      'contactLink' => 'contact',
      'accountLink' => 'account'
    ],
    'Tutorial' => [
      'contactLink' => NULL,
      'accountLink' => NULL
    ]
  ],
  'app' => [
    'acl' => [
      'mandatory' => [
        'scopeLevel' => [
          'Note' => [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'Portal' => [
            'read' => 'all',
            'edit' => 'no',
            'delete' => 'no',
            'create' => 'no'
          ],
          'Attachment' => [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'EmailAccount' => [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'EmailFilter' => [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'EmailFolder' => [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'GroupEmailFolder' => [
            'read' => 'team',
            'edit' => 'no',
            'delete' => 'no',
            'create' => 'no'
          ],
          'Preferences' => [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'no',
            'create' => 'no'
          ],
          'Notification' => [
            'read' => 'own',
            'edit' => 'no',
            'delete' => 'own',
            'create' => 'no'
          ],
          'ActionHistoryRecord' => [
            'read' => 'own'
          ],
          'Role' => false,
          'PortalRole' => false,
          'ImportError' => 'Import',
          'ImportEml' => 'Import',
          'WorkingTimeRange' => 'WorkingTimeCalendar',
          'Stream' => true,
          'MassEmail' => 'Campaign',
          'CampaignLogRecord' => 'Campaign',
          'CampaignTrackingUrl' => 'Campaign',
          'EmailQueueItem' => 'Campaign',
          'Workflow' => false,
          'WorkflowLogRecord' => false,
          'ReportPanel' => false,
          'BpmnFlowNode' => 'BpmnProcess',
          'QuoteItem' => 'Quote',
          'SalesOrderItem' => 'SalesOrder',
          'InvoiceItem' => 'Invoice',
          'PurchaseOrderItem' => 'PurchaseOrder',
          'DeliveryOrderItem' => 'DeliveryOrder',
          'ReceiptOrderItem' => 'ReceiptOrder',
          'TransferOrderItem' => 'TransferOrder',
          'ReturnOrderItem' => 'ReturnOrder',
          'OpportunityItem' => 'Opportunity',
          'InventoryAdjustmentItem' => 'InventoryAdjustment',
          'ProductPrice' => 'PriceBook',
          'PriceRule' => 'PriceBook',
          'SupplierProductPrice' => 'Supplier',
          'ProductAttributeOption' => 'ProductAttribute'
        ],
        'fieldLevel' => [],
        'scopeFieldLevel' => [
          'EmailAccount' => [
            'assignedUser' => [
              'read' => 'yes',
              'edit' => 'no'
            ]
          ],
          'EmailFolder' => [
            'assignedUser' => [
              'read' => 'yes',
              'edit' => 'no'
            ]
          ],
          'Email' => [
            'inboundEmails' => false,
            'emailAccounts' => false
          ],
          'User' => [
            'dashboardTemplate' => false,
            'workingTimeCalendar' => [
              'read' => 'yes',
              'edit' => 'no'
            ],
            'password' => false,
            'passwordConfirm' => false,
            'auth2FA' => false,
            'authMethod' => false,
            'apiKey' => false,
            'secretKey' => false,
            'token' => false
          ],
          'ActionHistoryRecord' => [
            'authToken' => false,
            'authLogRecord' => false
          ]
        ]
      ],
      'strictDefault' => [
        'scopeLevel' => [
          'User' => [
            'read' => 'own',
            'edit' => 'no'
          ],
          'Team' => [
            'read' => 'team'
          ],
          'Import' => false,
          'Webhook' => false
        ],
        'fieldLevel' => [],
        'scopeFieldLevel' => [
          'User' => [
            'gender' => false,
            'avatarColor' => [
              'read' => 'yes',
              'edit' => 'no'
            ]
          ],
          'Meeting' => [
            'uid' => false
          ],
          'Call' => [
            'uid' => false
          ]
        ]
      ],
      'adminMandatory' => [
        'scopeLevel' => [
          'User' => [
            'create' => 'yes',
            'read' => 'all',
            'edit' => 'all',
            'delete' => 'all'
          ],
          'Team' => [
            'create' => 'yes',
            'read' => 'all',
            'edit' => 'all',
            'delete' => 'all'
          ],
          'Job' => [
            'create' => 'no',
            'read' => 'all',
            'edit' => 'no',
            'delete' => 'all'
          ],
          'Extension' => [
            'create' => 'no',
            'read' => 'all',
            'edit' => 'no',
            'delete' => 'all'
          ],
          'Stream' => true,
          'ImportEml' => 'Import',
          'BpmnFlowchart' => [
            'create' => 'yes',
            'read' => 'all',
            'edit' => 'all',
            'delete' => 'all',
            'stream' => 'all'
          ],
          'InventoryTransaction' => [
            'create' => 'yes',
            'read' => 'all',
            'edit' => 'all',
            'delete' => 'all'
          ],
          'PriceRuleCondition' => [
            'create' => 'yes',
            'read' => 'all',
            'edit' => 'all',
            'delete' => 'all'
          ]
        ]
      ],
      'valuePermissionList' => [
        0 => 'assignmentPermission',
        1 => 'messagePermission',
        2 => 'mentionPermission',
        3 => 'userCalendarPermission',
        4 => 'auditPermission',
        5 => 'exportPermission',
        6 => 'massUpdatePermission',
        7 => 'userPermission',
        8 => 'portalPermission',
        9 => 'groupEmailAccountPermission',
        10 => 'followerManagementPermission',
        11 => 'dataPrivacyPermission'
      ],
      'valuePermissionHighestLevels' => [
        'assignmentPermission' => 'all',
        'userPermission' => 'all',
        'messagePermission' => 'all',
        'portalPermission' => 'yes',
        'groupEmailAccountPermission' => 'all',
        'exportPermission' => 'yes',
        'massUpdatePermission' => 'yes',
        'followerManagementPermission' => 'all',
        'dataPrivacyPermission' => 'yes',
        'auditPermission' => 'yes',
        'mentionPermission' => 'yes',
        'userCalendarPermission' => 'all'
      ],
      'permissionsStrictDefaults' => [
        'assignmentPermission' => 'no',
        'userPermission' => 'no',
        'messagePermission' => 'no',
        'portalPermission' => 'no',
        'groupEmailAccountPermission' => 'no',
        'exportPermission' => 'no',
        'massUpdatePermission' => 'no',
        'followerManagementPermission' => 'no',
        'dataPrivacyPermission' => 'no',
        'auditPermission' => 'no',
        'mentionPermission' => 'no',
        'userCalendarPermission' => 'no'
      ]
    ],
    'aclPortal' => [
      'mandatory' => [
        'scopeLevel' => [
          'User' => [
            'read' => 'own',
            'edit' => 'no',
            'delete' => 'no',
            'stream' => 'no',
            'create' => 'no'
          ],
          'Team' => false,
          'Note' => [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'Notification' => [
            'read' => 'own',
            'edit' => 'no',
            'delete' => 'own',
            'create' => 'no'
          ],
          'Portal' => false,
          'Attachment' => [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'ExternalAccount' => false,
          'Role' => false,
          'PortalRole' => false,
          'EmailFilter' => false,
          'EmailFolder' => false,
          'EmailAccount' => false,
          'EmailTemplate' => false,
          'ActionHistoryRecord' => [
            'read' => 'own'
          ],
          'Preferences' => [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'no',
            'create' => 'no'
          ],
          'MassEmail' => 'Campaign',
          'CampaignLogRecord' => 'Campaign',
          'CampaignTrackingUrl' => 'Campaign',
          'EmailQueueItem' => false,
          'QuoteItem' => 'Quote',
          'SalesOrderItem' => 'SalesOrder',
          'InvoiceItem' => 'Invoice',
          'PurchaseOrderItem' => 'PurchaseOrder',
          'DeliveryOrderItem' => 'DeliveryOrder',
          'ReceiptOrderItem' => 'ReceiptOrder',
          'TransferOrderItem' => 'TransferOrder',
          'ReturnOrderItem' => 'ReturnOrder',
          'OpportunityItem' => 'Opportunity',
          'ProductPrice' => 'PriceBook'
        ],
        'fieldLevel' => [],
        'scopeFieldLevel' => [
          'Preferences' => [
            'smtpServer' => false,
            'smtpPort' => false,
            'smtpSecurity' => false,
            'smtpUsername' => false,
            'smtpPassword' => false,
            'smtpAuth' => false,
            'receiveAssignmentEmailNotifications' => false,
            'receiveMentionEmailNotifications' => false,
            'defaultReminders' => false,
            'autoFollowEntityTypeList' => false,
            'emailReplyForceHtml' => false,
            'emailReplyToAllByDefault' => false,
            'signature' => false,
            'followCreatedEntities' => false,
            'followEntityOnStreamPost' => false,
            'doNotFillAssignedUserIfNotRequired' => false,
            'useCustomTabList' => false,
            'addCustomTabs' => false,
            'tabList' => false,
            'emailUseExternalClient' => false,
            'assignmentNotificationsIgnoreEntityTypeList' => false,
            'assignmentEmailNotificationsIgnoreEntityTypeList' => false,
            'dashletsOptions' => false,
            'dashboardLayout' => false
          ],
          'Call' => [
            'reminders' => false,
            'uid' => false
          ],
          'Meeting' => [
            'reminders' => false,
            'uid' => false
          ],
          'Note' => [
            'isInternal' => false,
            'isGlobal' => false
          ],
          'Email' => [
            'inboundEmails' => false,
            'emailAccounts' => false
          ],
          'User' => [
            'dashboardTemplate' => false,
            'workingTimeCalendar' => false,
            'password' => false,
            'authMethod' => false,
            'apiKey' => false,
            'secretKey' => false,
            'token' => false,
            'isAdmin' => false,
            'type' => false,
            'contact' => false,
            'accounts' => false,
            'account' => false,
            'portalRoles' => false,
            'portals' => false,
            'roles' => false,
            'defaultTeam' => false,
            'auth2FA' => false,
            'isActive' => false
          ],
          'ActionHistoryRecord' => [
            'authToken' => false,
            'authLogRecord' => false
          ],
          'Case' => [
            'isInternal' => false
          ],
          'Report' => [
            'portals' => false,
            'assignedUser' => false,
            'teams' => false,
            'emailSendingInterval' => false,
            'emailSendingSettingMonth' => false,
            'emailSendingSettingDay' => false,
            'emailSendingSettingWeekdays' => false,
            'emailSendingTime' => false,
            'emailSendingUsers' => false,
            'emailSendingLastDateSent' => false,
            'emailSendingDoNotSendEmptyReport' => false,
            'applyAcl' => false
          ]
        ]
      ],
      'strictDefault' => [
        'scopeLevel' => [],
        'fieldLevel' => [
          'assignedUser' => [
            'read' => 'yes',
            'edit' => 'no'
          ],
          'assignedUsers' => [
            'read' => 'yes',
            'edit' => 'no'
          ],
          'collaborators' => false,
          'teams' => false
        ],
        'scopeFieldLevel' => [
          'User' => [
            'gender' => false
          ],
          'KnowledgeBaseArticle' => [
            'portals' => false,
            'order' => false,
            'status' => false,
            'assignedUser' => false
          ],
          'Call' => [
            'users' => [
              'read' => 'yes',
              'edit' => 'no'
            ],
            'leads' => false
          ],
          'Meeting' => [
            'users' => [
              'read' => 'yes',
              'edit' => 'no'
            ],
            'leads' => false
          ],
          'Case' => [
            'status' => [
              'read' => 'yes',
              'edit' => 'no'
            ]
          ],
          'Report' => [
            'modifiedAt' => false,
            'modifiedBy' => false,
            'createdAt' => false,
            'createdBy' => false
          ]
        ]
      ],
      'valuePermissionList' => [
        0 => 'exportPermission',
        1 => 'massUpdatePermission'
      ],
      'permissionsStrictDefaults' => [
        'exportPermission' => 'no',
        'massUpdatePermission' => 'no'
      ],
      'default' => [
        'scopeFieldLevel' => [
          'Report' => [
            'modifiedAt' => false,
            'modifiedBy' => false,
            'createdAt' => false,
            'createdBy' => false
          ]
        ]
      ]
    ],
    'actions' => [
      'convertCurrency' => [
        'implementationClassName' => 'Espo\\Core\\Action\\Actions\\ConvertCurrency'
      ],
      'merge' => [
        'implementationClassName' => 'Espo\\Core\\Action\\Actions\\Merge'
      ]
    ],
    'addressFormats' => [
      1 => [
        'formatterClassName' => 'Espo\\Classes\\AddressFormatters\\Formatter1'
      ],
      2 => [
        'formatterClassName' => 'Espo\\Classes\\AddressFormatters\\Formatter2'
      ],
      3 => [
        'formatterClassName' => 'Espo\\Classes\\AddressFormatters\\Formatter3'
      ],
      4 => [
        'formatterClassName' => 'Espo\\Classes\\AddressFormatters\\Formatter4'
      ]
    ],
    'adminPanel' => [
      'system' => [
        'label' => 'System',
        'itemList' => [
          0 => [
            'url' => '#Admin/settings',
            'label' => 'Settings',
            'iconClass' => 'fas fa-cog',
            'description' => 'settings',
            'recordView' => 'views/admin/settings'
          ],
          1 => [
            'url' => '#Admin/userInterface',
            'label' => 'User Interface',
            'iconClass' => 'fas fa-desktop',
            'description' => 'userInterface',
            'recordView' => 'views/admin/user-interface'
          ],
          2 => [
            'url' => '#Admin/authentication',
            'label' => 'Authentication',
            'iconClass' => 'fas fa-sign-in-alt',
            'description' => 'authentication',
            'recordView' => 'views/admin/authentication'
          ],
          3 => [
            'url' => '#ScheduledJob',
            'label' => 'Scheduled Jobs',
            'iconClass' => 'fas fa-clock',
            'description' => 'scheduledJob'
          ],
          4 => [
            'url' => '#Admin/currency',
            'label' => 'Currency',
            'iconClass' => 'fas fa-euro-sign',
            'description' => 'currency',
            'recordView' => 'views/admin/currency'
          ],
          5 => [
            'url' => '#Admin/notifications',
            'label' => 'Notifications',
            'iconClass' => 'fas fa-bell',
            'description' => 'notifications',
            'recordView' => 'views/admin/notifications'
          ],
          6 => [
            'url' => '#Admin/integrations',
            'label' => 'Integrations',
            'iconClass' => 'fas fa-network-wired',
            'description' => 'integrations'
          ],
          7 => [
            'url' => '#Admin/extensions',
            'label' => 'Extensions',
            'iconClass' => 'fas fa-upload',
            'description' => 'extensions'
          ],
          8 => [
            'url' => '#Admin/systemRequirements',
            'label' => 'System Requirements',
            'iconClass' => 'fas fa-server',
            'description' => 'systemRequirements'
          ],
          9 => [
            'url' => '#Admin/jobsSettings',
            'label' => 'Job Settings',
            'iconClass' => 'fas fa-list-ul',
            'description' => 'jobsSettings',
            'recordView' => 'views/admin/jobs-settings'
          ],
          10 => [
            'url' => '#Admin/upgrade',
            'label' => 'Upgrade',
            'iconClass' => 'fas fa-arrow-alt-circle-up',
            'description' => 'upgrade',
            'view' => 'views/admin/upgrade/index'
          ],
          11 => [
            'action' => 'clearCache',
            'label' => 'Clear Cache',
            'iconClass' => 'fas fa-broom',
            'description' => 'clearCache'
          ],
          12 => [
            'action' => 'rebuild',
            'label' => 'Rebuild',
            'iconClass' => 'fas fa-database',
            'description' => 'rebuild'
          ]
        ],
        'order' => 0
      ],
      'users' => [
        'label' => 'Users',
        'itemList' => [
          0 => [
            'url' => '#Admin/users',
            'label' => 'Users',
            'iconClass' => 'fas fa-user',
            'description' => 'users',
            'tabQuickSearch' => true
          ],
          1 => [
            'url' => '#Admin/teams',
            'label' => 'Teams',
            'iconClass' => 'fas fa-users',
            'description' => 'teams',
            'tabQuickSearch' => true
          ],
          2 => [
            'url' => '#Admin/roles',
            'label' => 'Roles',
            'iconClass' => 'fas fa-key',
            'description' => 'roles',
            'tabQuickSearch' => true
          ],
          3 => [
            'url' => '#Admin/authLog',
            'label' => 'Auth Log',
            'iconClass' => 'fas fa-sign-in-alt',
            'description' => 'authLog'
          ],
          4 => [
            'url' => '#Admin/authTokens',
            'label' => 'Auth Tokens',
            'iconClass' => 'fas fa-shield-alt',
            'description' => 'authTokens'
          ],
          5 => [
            'url' => '#Admin/actionHistory',
            'label' => 'Action History',
            'iconClass' => 'fas fa-history',
            'description' => 'actionHistory'
          ],
          6 => [
            'url' => '#Admin/apiUsers',
            'label' => 'API Users',
            'iconClass' => 'fas fa-user-cog',
            'description' => 'apiUsers'
          ]
        ],
        'order' => 5
      ],
      'customization' => [
        'label' => 'Customization',
        'itemList' => [
          0 => [
            'url' => '#Admin/entityManager',
            'label' => 'Entity Manager',
            'iconClass' => 'fas fa-tools',
            'description' => 'entityManager',
            'tabQuickSearch' => true
          ],
          1 => [
            'url' => '#Admin/layouts',
            'label' => 'Layout Manager',
            'iconClass' => 'fas fa-table',
            'description' => 'layoutManager'
          ],
          2 => [
            'url' => '#Admin/labelManager',
            'label' => 'Label Manager',
            'iconClass' => 'fas fa-language',
            'description' => 'labelManager'
          ],
          3 => [
            'url' => '#Admin/templateManager',
            'label' => 'Template Manager',
            'iconClass' => 'fas fa-envelope-open-text',
            'description' => 'templateManager'
          ],
          4 => [
            'url' => '#ReportFilter',
            'label' => 'Report Filters',
            'iconClass' => 'fas fa-filter',
            'description' => 'reportFilters'
          ],
          5 => [
            'url' => '#ReportPanel',
            'label' => 'Report Panels',
            'iconClass' => 'fas fa-chart-area',
            'description' => 'reportPanels'
          ]
        ],
        'order' => 10
      ],
      'email' => [
        'label' => 'Messaging',
        'itemList' => [
          0 => [
            'url' => '#Admin/outboundEmails',
            'label' => 'Outbound Emails',
            'iconClass' => 'fas fa-paper-plane',
            'description' => 'outboundEmails',
            'recordView' => 'views/admin/outbound-emails'
          ],
          1 => [
            'url' => '#Admin/inboundEmails',
            'label' => 'Inbound Emails',
            'iconClass' => 'fas fa-envelope',
            'description' => 'inboundEmails',
            'recordView' => 'views/admin/inbound-emails'
          ],
          2 => [
            'url' => '#Admin/groupEmailAccounts',
            'label' => 'Group Email Accounts',
            'iconClass' => 'fas fa-inbox',
            'description' => 'groupEmailAccounts'
          ],
          3 => [
            'url' => '#Admin/personalEmailAccounts',
            'label' => 'Personal Email Accounts',
            'iconClass' => 'fas fa-inbox',
            'description' => 'personalEmailAccounts'
          ],
          4 => [
            'url' => '#Admin/emailFilters',
            'label' => 'Email Filters',
            'iconClass' => 'fas fa-filter',
            'description' => 'emailFilters'
          ],
          5 => [
            'url' => '#Admin/groupEmailFolders',
            'label' => 'Group Email Folders',
            'iconClass' => 'fas fa-folder',
            'description' => 'groupEmailFolders'
          ],
          6 => [
            'url' => '#Admin/emailTemplates',
            'label' => 'Email Templates',
            'iconClass' => 'fas fa-envelope-square',
            'description' => 'emailTemplates'
          ],
          7 => [
            'url' => '#Admin/sms',
            'label' => 'SMS',
            'iconClass' => 'fas fa-paper-plane',
            'description' => 'sms',
            'recordView' => 'views/admin/sms'
          ]
        ],
        'order' => 15
      ],
      'portal' => [
        'label' => 'Portal',
        'itemList' => [
          0 => [
            'url' => '#Admin/portals',
            'label' => 'Portals',
            'iconClass' => 'fas fa-parking',
            'description' => 'portals'
          ],
          1 => [
            'url' => '#Admin/portalUsers',
            'label' => 'Portal Users',
            'iconClass' => 'fas fa-user',
            'description' => 'portalUsers',
            'tabQuickSearch' => true
          ],
          2 => [
            'url' => '#Admin/portalRoles',
            'label' => 'Portal Roles',
            'iconClass' => 'fas fa-key',
            'description' => 'portalRoles'
          ]
        ],
        'order' => 20
      ],
      'setup' => [
        'label' => 'Setup',
        'itemList' => [
          0 => [
            'url' => '#Admin/workingTimeCalendar',
            'label' => 'Working Time Calendars',
            'iconClass' => 'far fa-calendar-alt',
            'description' => 'workingTimeCalendars',
            'tabQuickSearch' => true
          ],
          1 => [
            'url' => '#Admin/layoutSets',
            'label' => 'Layout Sets',
            'iconClass' => 'fas fa-table',
            'description' => 'layoutSets'
          ],
          2 => [
            'url' => '#Admin/dashboardTemplates',
            'label' => 'Dashboard Templates',
            'iconClass' => 'fas fa-th-large',
            'description' => 'dashboardTemplates'
          ],
          3 => [
            'url' => '#Admin/leadCapture',
            'label' => 'Lead Capture',
            'iconClass' => 'fas fa-id-card',
            'description' => 'leadCapture'
          ],
          4 => [
            'url' => '#Admin/pdfTemplates',
            'label' => 'PDF Templates',
            'iconClass' => 'fas fa-file-pdf',
            'description' => 'pdfTemplates'
          ],
          5 => [
            'url' => '#Admin/webhooks',
            'label' => 'Webhooks',
            'iconClass' => 'fas fa-share-alt icon-rotate-90',
            'description' => 'webhooks'
          ],
          6 => [
            'url' => '#Admin/addressCountries',
            'label' => 'Address Countries',
            'iconClass' => 'far fa-flag',
            'description' => 'addressCountries'
          ],
          7 => [
            'url' => '#Admin/authenticationProviders',
            'label' => 'Authentication Providers',
            'iconClass' => 'fas fa-sign-in-alt',
            'description' => 'authenticationProviders'
          ]
        ],
        'order' => 24
      ],
      'data' => [
        'label' => 'Data',
        'itemList' => [
          0 => [
            'url' => '#Admin/import',
            'label' => 'Import',
            'iconClass' => 'fas fa-file-import',
            'description' => 'import'
          ],
          1 => [
            'url' => '#Admin/attachments',
            'label' => 'Attachments',
            'iconClass' => 'fas fa-paperclip',
            'description' => 'attachments'
          ],
          2 => [
            'url' => '#Admin/jobs',
            'label' => 'Jobs',
            'iconClass' => 'fas fa-list-ul',
            'description' => 'jobs'
          ],
          3 => [
            'url' => '#Admin/emailAddresses',
            'label' => 'Email Addresses',
            'iconClass' => 'fas fa-envelope',
            'description' => 'emailAddresses'
          ],
          4 => [
            'url' => '#Admin/phoneNumbers',
            'label' => 'Phone Numbers',
            'iconClass' => 'fas fa-phone',
            'description' => 'phoneNumbers'
          ],
          5 => [
            'url' => '#Admin/appSecrets',
            'label' => 'App Secrets',
            'iconClass' => 'fas fa-key',
            'description' => 'appSecrets'
          ],
          6 => [
            'url' => '#Admin/appLog',
            'label' => 'App Log',
            'iconClass' => 'fas fa-list',
            'description' => 'appLog'
          ]
        ],
        'order' => 25
      ],
      'misc' => [
        'label' => 'Misc',
        'itemList' => [
          0 => [
            'url' => '#Admin/formulaSandbox',
            'label' => 'Formula Sandbox',
            'iconClass' => 'fas fa-code',
            'description' => 'formulaSandbox',
            'view' => 'views/admin/formula-sandbox/index'
          ]
        ],
        'order' => 26
      ],
      'workflows' => [
        'label' => 'Workflow Manager',
        'itemList' => [
          0 => [
            'url' => '#Workflow',
            'label' => 'Workflow Manager',
            'iconClass' => 'fas fa-code-branch icon-rotate-180',
            'description' => 'workflowManager',
            'tabQuickSearch' => true
          ]
        ],
        'order' => 99
      ],
      'bpmn' => [
        'label' => 'Business Process Management',
        'itemList' => [
          0 => [
            'url' => '#BpmnFlowchart',
            'label' => 'Flowcharts',
            'iconClass' => 'fas fa-project-diagram',
            'description' => 'bpmnFlowcharts',
            'tabQuickSearch' => true
          ],
          1 => [
            'url' => '#BpmnProcess',
            'label' => 'Processes',
            'iconClass' => 'fas fa-cogs',
            'description' => 'bpmnProcesses',
            'tabQuickSearch' => true
          ]
        ],
        'order' => 100
      ],
      'salesPack' => [
        'label' => 'Sales Pack',
        'itemList' => [
          0 => [
            'url' => '#Admin/salesPackSettings',
            'label' => 'Settings',
            'iconClass' => 'fas fa-cog',
            'description' => 'salesPackSettings',
            'recordView' => 'sales:views/settings/record/settings'
          ],
          1 => [
            'url' => '#PriceRuleCondition',
            'label' => 'Price Rule Conditions',
            'iconClass' => 'fas fa-code',
            'description' => 'priceRuleConditions'
          ]
        ]
      ],
      'ebla' => [
        'label' => 'Ebla Extensions',
        'itemList' => [
          0 => [
            'url' => '#EblaForm',
            'iconClass' => 'fas fa-link',
            'keywords' => [
              0 => 'ebla-form',
              1 => 'ebla'
            ],
            'label' => 'Ebla Public Forms',
            'description' => 'eblaFormDescription'
          ]
        ]
      ]
    ],
    'api' => [
      'globalMiddlewareClassNameList' => [],
      'routeMiddlewareClassNameListMap' => [],
      'controllerMiddlewareClassNameListMap' => [],
      'controllerActionMiddlewareClassNameListMap' => []
    ],
    'appParams' => [
      'templateEntityTypeList' => [
        'className' => 'Espo\\Classes\\AppParams\\TemplateEntityTypeList'
      ],
      'extensions' => [
        'className' => 'Espo\\Classes\\AppParams\\Extensions'
      ],
      'addressCountryData' => [
        'className' => 'Espo\\Classes\\AppParams\\AddressCountryData'
      ],
      'flowchartEntityTypeList' => [
        'className' => 'Espo\\Modules\\Advanced\\Core\\AppParams\\FlowchartEntityTypeList'
      ],
      'manualWorkflows' => [
        'className' => 'Espo\\Modules\\Advanced\\Classes\\AppParams\\ManualWorkflows'
      ],
      'defaultTaxRateQuote' => [
        'className' => 'Espo\\Modules\\Sales\\AppParams\\DefaultTaxRateQuote'
      ],
      'defaultTaxRateSalesOrder' => [
        'className' => 'Espo\\Modules\\Sales\\AppParams\\DefaultTaxRateSalesOrder'
      ],
      'defaultTaxRateInvoice' => [
        'className' => 'Espo\\Modules\\Sales\\AppParams\\DefaultTaxRateInvoice'
      ],
      'defaultTaxRatePurchaseOrder' => [
        'className' => 'Espo\\Modules\\Sales\\AppParams\\DefaultTaxRatePurchaseOrder'
      ]
    ],
    'authentication' => [
      'beforeLoginHookClassNameList' => [
        0 => 'Espo\\Core\\Authentication\\Hook\\Hooks\\FailedAttemptsLimit',
        1 => 'Espo\\Core\\Authentication\\Hook\\Hooks\\FailedCodeAttemptsLimit'
      ],
      'onLoginHookClassNameList' => [
        0 => 'Espo\\Core\\Authentication\\Hook\\Hooks\\IpAddressWhitelist'
      ],
      'onFailHookClassNameList' => [],
      'onSuccessHookClassNameList' => [],
      'onSuccessByTokenHookClassNameList' => [],
      'onSecondStepRequiredHookClassNameList' => []
    ],
    'authentication2FAMethods' => [
      'Totp' => [
        'settings' => [
          'isAvailable' => true
        ],
        'userApplyView' => 'views/user-security/modals/totp',
        'loginClassName' => 'Espo\\Core\\Authentication\\TwoFactor\\Totp\\TotpLogin',
        'userSetupClassName' => 'Espo\\Core\\Authentication\\TwoFactor\\Totp\\TotpUserSetup'
      ],
      'Email' => [
        'settings' => [
          'isAvailable' => true
        ],
        'userApplyView' => 'views/user-security/modals/two-factor-email',
        'loginClassName' => 'Espo\\Core\\Authentication\\TwoFactor\\Email\\EmailLogin',
        'userSetupClassName' => 'Espo\\Core\\Authentication\\TwoFactor\\Email\\EmailUserSetup'
      ],
      'Sms' => [
        'settings' => [
          'isAvailable' => true
        ],
        'userApplyView' => 'views/user-security/modals/two-factor-sms',
        'loginClassName' => 'Espo\\Core\\Authentication\\TwoFactor\\Sms\\SmsLogin',
        'userSetupClassName' => 'Espo\\Core\\Authentication\\TwoFactor\\Sms\\SmsUserSetup'
      ]
    ],
    'cleanup' => [
      'reminders' => [
        'className' => 'Espo\\Classes\\Cleanup\\Reminders',
        'order' => 10
      ],
      'webhookQueue' => [
        'className' => 'Espo\\Classes\\Cleanup\\WebhookQueue',
        'order' => 11
      ],
      'twoFactorCodes' => [
        'className' => 'Espo\\Classes\\Cleanup\\TwoFactorCodes'
      ],
      'massActions' => [
        'className' => 'Espo\\Classes\\Cleanup\\MassActions'
      ],
      'exports' => [
        'className' => 'Espo\\Classes\\Cleanup\\Exports'
      ],
      'passwordChangeRequests' => [
        'className' => 'Espo\\Classes\\Cleanup\\PasswordChangeRequests'
      ],
      'subscribers' => [
        'className' => 'Espo\\Classes\\Cleanup\\Subscribers'
      ],
      'audit' => [
        'className' => 'Espo\\Classes\\Cleanup\\Audit'
      ],
      'stars' => [
        'className' => 'Espo\\Classes\\Cleanup\\Stars'
      ],
      'appLog' => [
        'className' => 'Espo\\Classes\\Cleanup\\AppLog'
      ],
      'workflowLog' => [
        'className' => 'Espo\\Modules\\Advanced\\Core\\Cleanup\\WorkflowLog',
        'order' => 20
      ],
      'advancedPack' => [
        'className' => 'Espo\\Modules\\Advanced\\Core\\Cleanup\\Integrity'
      ],
      'salesIntegrity' => [
        'className' => 'Espo\\Modules\\Sales\\Classes\\Cleanup\\Integrity'
      ]
    ],
    'client' => [
      'scriptList' => [
        0 => 'client/lib/espo.js',
        1 => 'client/lib/espo-main.js',
        2 => 'client/custom/modules/ebla-form/src/ebla-form-script.js',
        3 => 'client/custom/modules/enube/patchNotes.js'
      ],
      'developerModeScriptList' => [
        0 => 'client/src/loader.js',
        1 => 'client/custom/modules/ebla-form/src/ebla-form-script.js'
      ],
      'linkList' => [
        0 => [
          'href' => 'client/fonts/inter/Inter-Regular.woff2',
          'as' => 'font',
          'type' => 'font/woff2',
          'rel' => 'preload',
          'noTimestamp' => true,
          'crossorigin' => true
        ],
        1 => [
          'href' => 'client/fonts/inter/Inter-Medium.woff2',
          'as' => 'font',
          'type' => 'font/woff2',
          'rel' => 'preload',
          'noTimestamp' => true,
          'crossorigin' => true
        ],
        2 => [
          'href' => 'client/fonts/inter/Inter-SemiBold.woff2',
          'as' => 'font',
          'type' => 'font/woff2',
          'rel' => 'preload',
          'noTimestamp' => true,
          'crossorigin' => true
        ],
        3 => [
          'href' => 'client/fonts/inter/Inter-Bold.woff2',
          'as' => 'font',
          'type' => 'font/woff2',
          'rel' => 'preload',
          'noTimestamp' => true,
          'crossorigin' => true
        ],
        4 => [
          'href' => 'client/fonts/fa-solid-900.woff2',
          'as' => 'font',
          'type' => 'font/woff2',
          'rel' => 'preload',
          'noTimestamp' => true,
          'crossorigin' => true
        ],
        5 => [
          'href' => 'client/fonts/fa-regular-400.woff2',
          'as' => 'font',
          'type' => 'font/woff2',
          'rel' => 'preload',
          'noTimestamp' => true,
          'crossorigin' => true
        ]
      ],
      'cssList' => [
        0 => 'client/custom/css/style.css'
      ]
    ],
    'clientNavbar' => [
      'items' => [
        'globalSearch' => [
          'view' => 'views/global-search/global-search',
          'class' => 'navbar-form global-search-container',
          'order' => 5,
          'disabled' => false
        ],
        'quickCreate' => [
          'view' => 'views/site/navbar/quick-create',
          'class' => 'dropdown hidden-xs quick-create-container',
          'order' => 10,
          'disabled' => false
        ],
        'notificationBadge' => [
          'view' => 'views/notification/badge',
          'class' => 'dropdown notifications-badge-container',
          'order' => 15,
          'disabled' => false
        ]
      ],
      'menuItems' => [
        'admin' => [
          'order' => 0,
          'groupIndex' => 1,
          'link' => '#Admin',
          'labelTranslation' => 'Global.labels.Administration',
          'accessDataList' => [
            0 => [
              'isAdminOnly' => true
            ]
          ]
        ],
        'preferences' => [
          'order' => 1,
          'groupIndex' => 1,
          'link' => '#Preferences',
          'labelTranslation' => 'Global.labels.Preferences'
        ],
        'lastViewed' => [
          'order' => 0,
          'groupIndex' => 5,
          'link' => '#LastViewed',
          'labelTranslation' => 'Global.scopeNamesPlural.LastViewed',
          'configCheck' => '!actionHistoryDisabled',
          'handler' => 'handlers/navbar-menu',
          'actionFunction' => 'lastViewed'
        ],
        'about' => [
          'order' => 0,
          'groupIndex' => 10,
          'link' => '#About',
          'labelTranslation' => 'Global.labels.About'
        ],
        'logout' => [
          'order' => 1,
          'groupIndex' => 10,
          'labelTranslation' => 'Global.labels.Log Out',
          'handler' => 'handlers/navbar-menu',
          'actionFunction' => 'logout'
        ]
      ]
    ],
    'clientRecord' => [
      'panels' => [
        'activities' => [
          'name' => 'activities',
          'label' => 'Activities',
          'view' => 'crm:views/record/panels/activities',
          'aclScope' => 'Activities'
        ],
        'history' => [
          'name' => 'history',
          'label' => 'History',
          'view' => 'crm:views/record/panels/history',
          'aclScope' => 'Activities'
        ],
        'tasks' => [
          'name' => 'tasks',
          'label' => 'Tasks',
          'view' => 'crm:views/record/panels/tasks',
          'aclScope' => 'Task'
        ]
      ]
    ],
    'clientRoutes' => [
      'AddressMap/view/:entityType/:id/:field' => [
        'params' => [
          'controller' => 'AddressMap',
          'action' => 'view'
        ]
      ],
      'Admin/:page' => [
        'params' => [
          'controller' => 'Admin',
          'action' => 'page'
        ],
        'order' => 1
      ],
      'Admin/:page/:options' => [
        'params' => [
          'controller' => 'Admin',
          'action' => 'page'
        ],
        'order' => 1
      ],
      ':entityType/activities/:id/:targetEntityType' => [
        'params' => [
          'controller' => 'Activities',
          'action' => 'activities'
        ],
        'order' => 1
      ],
      ':entityType/history/:id/:targetEntityType' => [
        'params' => [
          'controller' => 'Activities',
          'action' => 'history'
        ],
        'order' => 1
      ],
      'Report/show/:id' => [
        'params' => [
          'controller' => 'Report',
          'action' => 'show'
        ]
      ]
    ],
    'complexExpression' => [
      'functionList' => [
        0 => [
          'name' => 'EQUAL',
          'insertText' => 'EQUAL:(VALUE1, VALUE2)',
          'returnType' => 'bool'
        ],
        1 => [
          'name' => 'NOT_EQUAL',
          'insertText' => 'NOT_EQUAL:(VALUE1, VALUE2)',
          'returnType' => 'bool'
        ],
        2 => [
          'name' => 'OR',
          'insertText' => 'OR:(EXPR1, EXPR2)',
          'returnType' => 'bool'
        ],
        3 => [
          'name' => 'AND',
          'insertText' => 'AND:(EXPR1, EXPR2)',
          'returnType' => 'bool'
        ],
        4 => [
          'name' => 'NOT',
          'insertText' => 'NOT:(EXPR)',
          'returnType' => 'bool'
        ],
        5 => [
          'name' => 'LIKE',
          'insertText' => 'LIKE:(VALUE, \'pattern%\')',
          'returnType' => 'bool'
        ],
        6 => [
          'name' => 'NOT_LIKE',
          'insertText' => 'NOT_LIKE:(VALUE, \'pattern%\')',
          'returnType' => 'bool'
        ],
        7 => [
          'name' => 'GREATER_THAN',
          'insertText' => 'GREATER_THAN:(VALUE1, VALUE2)',
          'returnType' => 'bool'
        ],
        8 => [
          'name' => 'LESS_THAN',
          'insertText' => 'LESS_THAN:(VALUE1, VALUE2)',
          'returnType' => 'bool'
        ],
        9 => [
          'name' => 'GREATER_THAN_OR_EQUAL',
          'insertText' => 'GREATER_THAN_OR_EQUAL:(VALUE1, VALUE2)',
          'returnType' => 'bool'
        ],
        10 => [
          'name' => 'LESS_THAN_OR_EQUAL',
          'insertText' => 'LESS_THAN_OR_EQUAL:(VALUE1, VALUE2)',
          'returnType' => 'bool'
        ],
        11 => [
          'name' => 'IS_NULL',
          'insertText' => 'IS_NULL:(VALUE)',
          'returnType' => 'bool'
        ],
        12 => [
          'name' => 'IS_NOT_NULL',
          'insertText' => 'IS_NOT_NULL:(VALUE)',
          'returnType' => 'bool'
        ],
        13 => [
          'name' => 'IN',
          'insertText' => 'IN:(VALUE, VALUE1, VALUE2, VALUE3)',
          'returnType' => 'bool'
        ],
        14 => [
          'name' => 'NOT_IN',
          'insertText' => 'NOT_IN:(VALUE, VALUE1, VALUE2, VALUE3)',
          'returnType' => 'bool'
        ],
        15 => [
          'name' => 'IF',
          'insertText' => 'IF:(CONDITION, THEN_VALUE, ELSE_VALUE)'
        ],
        16 => [
          'name' => 'SWITCH',
          'insertText' => 'SWITCH:(CONDITION1, VALUE1, CONDITION2, VALUE2, ELSE_VALUE)'
        ],
        17 => [
          'name' => 'MAP',
          'insertText' => 'MAP:(EXPR, WHEN_VALUE1, THEN_VALUE1, WHEN_VALUE2, THEN_VALUE2, ELSE_VALUE)'
        ],
        18 => [
          'name' => 'MONTH_NUMBER',
          'insertText' => 'MONTH_NUMBER:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        19 => [
          'name' => 'WEEK_NUMBER_0',
          'insertText' => 'WEEK_NUMBER_0:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        20 => [
          'name' => 'WEEK_NUMBER_1',
          'insertText' => 'WEEK_NUMBER_1:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        21 => [
          'name' => 'DAYOFWEEK',
          'insertText' => 'DAYOFWEEK:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        22 => [
          'name' => 'DAYOFMONTH',
          'insertText' => 'DAYOFMONTH:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        23 => [
          'name' => 'YEAR',
          'insertText' => 'YEAR:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        24 => [
          'name' => 'HOUR',
          'insertText' => 'HOUR:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        25 => [
          'name' => 'MINUTE',
          'insertText' => 'MINUTE:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        26 => [
          'name' => 'MONTH',
          'insertText' => 'MONTH:(DATE_VALUE)',
          'returnType' => 'string'
        ],
        27 => [
          'name' => 'QUARTER',
          'insertText' => 'QUARTER:(DATE_VALUE)',
          'returnType' => 'string'
        ],
        28 => [
          'name' => 'WEEK',
          'insertText' => 'WEEK:(DATE_VALUE)',
          'returnType' => 'string'
        ],
        29 => [
          'name' => 'NOW',
          'insertText' => 'NOW:()',
          'returnType' => 'string'
        ],
        30 => [
          'name' => 'TZ',
          'insertText' => 'TZ:(DATE_VALUE, OFFSET)',
          'returnType' => 'string'
        ],
        31 => [
          'name' => 'UNIX_TIMESTAMP',
          'insertText' => 'UNIX_TIMESTAMP:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        32 => [
          'name' => 'TIMESTAMPDIFF_YEAR',
          'insertText' => 'TIMESTAMPDIFF_YEAR:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        33 => [
          'name' => 'TIMESTAMPDIFF_MONTH',
          'insertText' => 'TIMESTAMPDIFF_MONTH:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        34 => [
          'name' => 'TIMESTAMPDIFF_WEEK',
          'insertText' => 'TIMESTAMPDIFF_WEEK:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        35 => [
          'name' => 'TIMESTAMPDIFF_DAY',
          'insertText' => 'TIMESTAMPDIFF_DAY:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        36 => [
          'name' => 'TIMESTAMPDIFF_HOUR',
          'insertText' => 'TIMESTAMPDIFF_HOUR:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        37 => [
          'name' => 'TIMESTAMPDIFF_MINUTE',
          'insertText' => 'TIMESTAMPDIFF_MINUTE:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        38 => [
          'name' => 'TIMESTAMPDIFF_SECOND',
          'insertText' => 'TIMESTAMPDIFF_SECOND:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        39 => [
          'name' => 'CONCAT',
          'insertText' => 'CONCAT:(STRING1, STRING2)',
          'returnType' => 'string'
        ],
        40 => [
          'name' => 'LEFT',
          'insertText' => 'LEFT:(STRING, NUMBER_OF_CHARACTERS)',
          'returnType' => 'string'
        ],
        41 => [
          'name' => 'LOWER',
          'insertText' => 'LOWER:(STRING)',
          'returnType' => 'string'
        ],
        42 => [
          'name' => 'UPPER',
          'insertText' => 'UPPER:(STRING)',
          'returnType' => 'string'
        ],
        43 => [
          'name' => 'TRIM',
          'insertText' => 'TRIM:(STRING)',
          'returnType' => 'string'
        ],
        44 => [
          'name' => 'CHAR_LENGTH',
          'insertText' => 'CHAR_LENGTH:(STRING)',
          'returnType' => 'int'
        ],
        45 => [
          'name' => 'BINARY',
          'insertText' => 'BINARY:(STRING)',
          'returnType' => 'string'
        ],
        46 => [
          'name' => 'REPLACE',
          'insertText' => 'REPLACE:(HAYSTACK, NEEDLE, REPLACE_WITH)',
          'returnType' => 'string'
        ],
        47 => [
          'name' => 'ADD',
          'insertText' => 'ADD:(VALUE1, VALUE2)',
          'returnType' => 'float'
        ],
        48 => [
          'name' => 'SUB',
          'insertText' => 'SUB:(VALUE1, VALUE2)',
          'returnType' => 'float'
        ],
        49 => [
          'name' => 'MUL',
          'insertText' => 'MUL:(VALUE1, VALUE2)',
          'returnType' => 'float'
        ],
        50 => [
          'name' => 'DIV',
          'insertText' => 'DIV:(VALUE1, VALUE2)',
          'returnType' => 'float'
        ],
        51 => [
          'name' => 'MOD',
          'insertText' => 'MOD:(VALUE1, VALUE2)',
          'returnType' => 'float'
        ],
        52 => [
          'name' => 'FLOOR',
          'insertText' => 'FLOOR:(VALUE)',
          'returnType' => 'int'
        ],
        53 => [
          'name' => 'CEIL',
          'insertText' => 'CEIL:(VALUE)',
          'returnType' => 'int'
        ],
        54 => [
          'name' => 'ROUND',
          'insertText' => 'ROUND:(VALUE, PRECISION)',
          'returnType' => 'float'
        ],
        55 => [
          'name' => 'COUNT',
          'insertText' => 'COUNT:(EXPR)',
          'returnType' => 'int'
        ],
        56 => [
          'name' => 'SUM',
          'insertText' => 'SUM:(EXPR)',
          'returnType' => 'int|float'
        ],
        57 => [
          'name' => 'AVG',
          'insertText' => 'AVG:(EXPR)',
          'returnType' => 'float'
        ],
        58 => [
          'name' => 'MAX',
          'insertText' => 'MAX:(EXPR)',
          'returnType' => 'int|float'
        ],
        59 => [
          'name' => 'MIN',
          'insertText' => 'MIN:(EXPR)',
          'returnType' => 'int|float'
        ]
      ]
    ],
    'config' => [
      'entityTypeListParamList' => [
        0 => 'tabList',
        1 => 'quickCreateList',
        2 => 'globalSearchEntityList',
        3 => 'assignmentEmailNotificationsEntityList',
        4 => 'assignmentNotificationsEntityList',
        5 => 'calendarEntityList',
        6 => 'streamEmailNotificationsEntityList',
        7 => 'activitiesEntityList',
        8 => 'historyEntityList',
        9 => 'streamEmailNotificationsTypeList',
        10 => 'emailKeepParentTeamsEntityList'
      ],
      'params' => [
        'isDeveloperMode' => [
          'readOnly' => true
        ],
        'clientSecurityHeadersDisabled' => [
          'readOnly' => true
        ],
        'clientCspDisabled' => [
          'readOnly' => true
        ],
        'clientCspScriptSourceList' => [
          'readOnly' => true
        ],
        'clientStrictTransportSecurityHeaderDisabled' => [
          'readOnly' => true
        ],
        'clientXFrameOptionsHeaderDisabled' => [
          'readOnly' => true
        ],
        'systemUserId' => [
          'level' => 'admin',
          'readOnly' => true
        ],
        'smtpPassword' => [
          'level' => 'internal'
        ],
        'awsS3Storage' => [
          'level' => 'system'
        ],
        'defaultFileStorage' => [
          'level' => 'admin',
          'readOnly' => true
        ],
        'smsProvider' => [
          'level' => 'admin'
        ],
        'authAnotherUserDisabled' => [
          'level' => 'admin',
          'readOnly' => true
        ],
        'userNameRegularExpression' => [
          'readOnly' => true
        ],
        'workingTimeCalendar' => [
          'level' => 'admin'
        ],
        'ldapPassword' => [
          'level' => 'internal'
        ],
        'oidcClientId' => [
          'level' => 'admin'
        ],
        'oidcClientSecret' => [
          'level' => 'internal'
        ],
        'oidcAuthorizationEndpoint' => [
          'level' => 'admin'
        ],
        'oidcTokenEndpoint' => [
          'level' => 'admin'
        ],
        'oidcJwksEndpoint' => [
          'level' => 'admin'
        ],
        'oidcJwksCachePeriod' => [
          'level' => 'admin'
        ],
        'oidcJwtSignatureAlgorithmList' => [
          'level' => 'admin'
        ],
        'oidcScopes' => [
          'level' => 'admin'
        ],
        'oidcGroupClaim' => [
          'level' => 'admin'
        ],
        'oidcCreateUser' => [
          'level' => 'admin'
        ],
        'oidcUsernameClaim' => [
          'level' => 'admin'
        ],
        'oidcTeamsIds' => [
          'level' => 'admin'
        ],
        'oidcTeamsNames' => [
          'level' => 'admin'
        ],
        'oidcTeamsColumns' => [
          'level' => 'admin'
        ],
        'oidcSync' => [
          'level' => 'admin'
        ],
        'oidcSyncTeams' => [
          'level' => 'admin'
        ],
        'oidcFallback' => [
          'level' => 'admin'
        ],
        'oidcAllowRegularUserFallback' => [
          'level' => 'admin'
        ],
        'oidcAllowAdminUser' => [
          'level' => 'admin'
        ],
        'oidcAuthorizationPrompt' => [
          'level' => 'admin'
        ],
        'oidcAuthorizationMaxAge' => [
          'level' => 'admin'
        ],
        'oidcLogoutUrl' => [
          'level' => 'admin'
        ],
        'apiCorsAllowedMethodList' => [
          'level' => 'admin'
        ],
        'apiCorsAllowedHeaderList' => [
          'level' => 'admin'
        ],
        'apiCorsAllowedOriginList' => [
          'level' => 'admin'
        ],
        'apiCorsMaxAge' => [
          'level' => 'admin'
        ],
        'customExportManifest' => [
          'level' => 'admin'
        ],
        'starsLimit' => [
          'level' => 'admin'
        ],
        'authIpAddressCheck' => [
          'level' => 'superAdmin'
        ],
        'authIpAddressWhitelist' => [
          'level' => 'superAdmin'
        ],
        'authIpAddressCheckExcludedUsers' => [
          'level' => 'superAdmin'
        ],
        'availableReactions' => [
          'level' => 'default'
        ],
        'emailScheduledBatchCount' => [
          'level' => 'admin'
        ],
        'streamEmailWithContentEntityTypeList' => [
          'level' => 'admin'
        ],
        'defaultPriceBook' => [],
        'priceBooksEnabled' => [],
        'inventoryTransactionsEnabled' => [],
        'warehousesEnabled' => [],
        'deliveryOrdersEnabled' => [],
        'receiptOrdersEnabled' => [],
        'inventoryCompressJobPeriod' => [
          'level' => 'admin'
        ],
        'inventoryDetachJobPeriod' => [
          'level' => 'admin'
        ],
        'notActualOrderLockingJobPeriod' => [
          'level' => 'admin'
        ],
        'productVariantMaxCount' => [],
        'salesForbidOrderUnlock' => [
          'level' => 'default'
        ],
        'eInvoiceFormat' => [
          'level' => 'default'
        ],
        'sellerCompanyName' => [
          'level' => 'admin'
        ],
        'sellerElectronicAddressScheme' => [
          'level' => 'admin'
        ],
        'sellerElectronicAddressIdentifier' => [
          'level' => 'admin'
        ],
        'sellerVatNumber' => [
          'level' => 'admin'
        ],
        'sellerTaxRegistrationScheme' => [
          'level' => 'admin'
        ],
        'sellerTaxRegistrationIdentifier' => [
          'level' => 'admin'
        ],
        'sellerAddress' => [
          'level' => 'admin'
        ],
        'sellerContactName' => [
          'level' => 'admin'
        ],
        'sellerContactEmailAddress' => [
          'level' => 'admin'
        ],
        'sellerContactPhoneNumber' => [
          'level' => 'admin'
        ]
      ]
    ],
    'consoleCommands' => [
      'import' => [
        'className' => 'Espo\\Classes\\ConsoleCommands\\Import',
        'listed' => true
      ],
      'clearCache' => [
        'listed' => true,
        'noSystemUser' => true
      ],
      'rebuild' => [
        'listed' => true,
        'noSystemUser' => true,
        'allowedFlags' => [
          0 => 'hard',
          1 => 'y'
        ]
      ],
      'updateAppTimestamp' => [
        'listed' => true,
        'noSystemUser' => true
      ],
      'appInfo' => [
        'listed' => true
      ],
      'setPassword' => [
        'listed' => true
      ],
      'upgrade' => [
        'listed' => true
      ],
      'extension' => [
        'listed' => true
      ],
      'runJob' => [
        'listed' => true,
        'allowedOptions' => [
          0 => 'job',
          1 => 'targetId',
          2 => 'targetType'
        ]
      ],
      'version' => [
        'listed' => true,
        'noSystemUser' => true
      ],
      'createAdminUser' => [
        'className' => 'Espo\\Classes\\ConsoleCommands\\CreateAdminUser',
        'listed' => true
      ],
      'rebuildCategoryPaths' => [
        'className' => 'Espo\\Classes\\ConsoleCommands\\RebuildCategoryPaths',
        'listed' => true
      ],
      'populateArrayValues' => [
        'className' => 'Espo\\Classes\\ConsoleCommands\\PopulateArrayValues',
        'listed' => true
      ],
      'populateNumbers' => [
        'className' => 'Espo\\Classes\\ConsoleCommands\\PopulateNumbers',
        'listed' => false
      ],
      'checkFilePermissions' => [
        'className' => 'Espo\\Classes\\ConsoleCommands\\CheckFilePermissions',
        'listed' => true,
        'noSystemUser' => true
      ],
      'migrate' => [
        'listed' => true,
        'noSystemUser' => true
      ],
      'migrationVersionStep' => [
        'listed' => false,
        'noSystemUser' => true
      ],
      'inventoryAclCheck' => [
        'className' => 'Espo\\Modules\\Sales\\Classes\\ConsoleCommands\\InventoryAclCheck',
        'listed' => false
      ],
      'inventoryCompress' => [
        'className' => 'Espo\\Modules\\Sales\\Classes\\ConsoleCommands\\InventoryCompress',
        'listed' => true
      ],
      'inventoryDetach' => [
        'className' => 'Espo\\Modules\\Sales\\Classes\\ConsoleCommands\\InventoryDetach',
        'listed' => true
      ]
    ],
    'containerServices' => [
      'authTokenManager' => [
        'className' => 'Espo\\Core\\Authentication\\AuthToken\\EspoManager'
      ],
      'ormMetadataData' => [
        'className' => 'Espo\\Core\\Utils\\Metadata\\OrmMetadataData'
      ],
      'classFinder' => [
        'className' => 'Espo\\Core\\Utils\\ClassFinder'
      ],
      'fileStorageManager' => [
        'className' => 'Espo\\Core\\FileStorage\\Manager'
      ],
      'jobManager' => [
        'className' => 'Espo\\Core\\Job\\JobManager'
      ],
      'webSocketSubmission' => [
        'className' => 'Espo\\Core\\WebSocket\\Submission'
      ],
      'crypt' => [
        'className' => 'Espo\\Core\\Utils\\Crypt'
      ],
      'passwordHash' => [
        'className' => 'Espo\\Core\\Utils\\PasswordHash'
      ],
      'number' => [
        'loaderClassName' => 'Espo\\Core\\Loaders\\NumberUtil'
      ],
      'selectBuilderFactory' => [
        'className' => 'Espo\\Core\\Select\\SelectBuilderFactory'
      ],
      'selectManagerFactory' => [
        'className' => 'Espo\\Core\\Select\\SelectManagerFactory'
      ],
      'serviceFactory' => [
        'className' => 'Espo\\Core\\ServiceFactory'
      ],
      'recordServiceContainer' => [
        'className' => 'Espo\\Core\\Record\\ServiceContainer'
      ],
      'templateFileManager' => [
        'className' => 'Espo\\Core\\Utils\\TemplateFileManager'
      ],
      'webhookManager' => [
        'className' => 'Espo\\Core\\Webhook\\Manager'
      ],
      'hookManager' => [
        'className' => 'Espo\\Core\\HookManager'
      ],
      'clientManager' => [
        'className' => 'Espo\\Core\\Utils\\ClientManager'
      ],
      'themeManager' => [
        'className' => 'Espo\\Core\\Utils\\ThemeManager'
      ],
      'fieldUtil' => [
        'className' => 'Espo\\Core\\Utils\\FieldUtil'
      ],
      'emailSender' => [
        'className' => 'Espo\\Core\\Mail\\EmailSender'
      ],
      'mailSender' => [
        'className' => 'Espo\\Core\\Mail\\Sender'
      ],
      'htmlizerFactory' => [
        'className' => 'Espo\\Core\\Htmlizer\\HtmlizerFactory'
      ],
      'fieldValidationManager' => [
        'className' => 'Espo\\Core\\FieldValidation\\FieldValidationManager'
      ],
      'assignmentCheckerManager' => [
        'className' => 'Espo\\Core\\Acl\\AssignmentChecker\\AssignmentCheckerManager'
      ],
      'hasher' => [
        'className' => 'Espo\\Core\\Utils\\Hasher'
      ],
      'emailFilterManager' => [
        'className' => 'Espo\\Core\\Utils\\EmailFilterManager'
      ],
      'externalAccountClientManager' => [
        'className' => 'Espo\\Core\\ExternalAccount\\ClientManager'
      ],
      'formulaManager' => [
        'className' => 'Espo\\Core\\Formula\\Manager'
      ],
      'user' => [
        'settable' => true
      ],
      'streamService' => [
        'className' => 'Espo\\Tools\\Stream\\Service'
      ],
      'workflowManager' => [
        'loaderClassName' => 'Espo\\Modules\\Advanced\\Core\\Loaders\\WorkflowManager'
      ],
      'workflowHelper' => [
        'loaderClassName' => 'Espo\\Modules\\Advanced\\Core\\Loaders\\WorkflowHelper'
      ],
      'signalManager' => [
        'loaderClassName' => 'Espo\\Modules\\Advanced\\Core\\Loaders\\SignalManager'
      ]
    ],
    'currency' => [
      'symbolMap' => [
        'AED' => 'د.إ',
        'AFN' => '؋',
        'ALL' => 'L',
        'ANG' => 'ƒ',
        'AOA' => 'Kz',
        'ARS' => '$',
        'AUD' => '$',
        'AWG' => 'ƒ',
        'AZN' => '₼',
        'BAM' => 'KM',
        'BBD' => '$',
        'BDT' => '৳',
        'BGN' => 'лв',
        'BHD' => '.د.ب',
        'BIF' => 'FBu',
        'BMD' => '$',
        'BND' => '$',
        'BOB' => 'Bs.',
        'BRL' => 'R$',
        'BSD' => '$',
        'BTN' => 'Nu.',
        'BWP' => 'P',
        'BYN' => 'Br',
        'BYR' => 'p.',
        'BZD' => 'BZ$',
        'CAD' => '$',
        'CDF' => 'FC',
        'CHF' => 'Fr.',
        'CLP' => '$',
        'CNY' => '¥',
        'COP' => '$',
        'CRC' => '₡',
        'CUC' => '$',
        'CUP' => '₱',
        'CVE' => '$',
        'CZK' => 'Kč',
        'DJF' => 'Fdj',
        'DKK' => 'kr',
        'DOP' => 'RD$',
        'DZD' => 'دج',
        'EEK' => 'kr',
        'EGP' => '£',
        'ERN' => 'Nfk',
        'ETB' => 'Br',
        'EUR' => '€',
        'FJD' => '$',
        'FKP' => '£',
        'GBP' => '£',
        'GEL' => '₾',
        'GGP' => '£',
        'GHC' => '₵',
        'GHS' => 'GH₵',
        'GIP' => '£',
        'GMD' => 'D',
        'GNF' => 'FG',
        'GTQ' => 'Q',
        'GYD' => '$',
        'HKD' => '$',
        'HNL' => 'L',
        'HRK' => 'kn',
        'HTG' => 'G',
        'HUF' => 'Ft',
        'IDR' => 'Rp',
        'ILS' => '₪',
        'IMP' => '£',
        'INR' => '₹',
        'IQD' => 'ع.د',
        'IRR' => '﷼',
        'ISK' => 'kr',
        'JEP' => '£',
        'JMD' => 'J$',
        'JPY' => '¥',
        'KES' => 'KSh',
        'KGS' => 'лв',
        'KHR' => '៛',
        'KMF' => 'CF',
        'KPW' => '₩',
        'KRW' => '₩',
        'KYD' => '$',
        'KZT' => '₸',
        'LAK' => '₭',
        'LBP' => '£',
        'LKR' => '₨',
        'LRD' => '$',
        'LSL' => 'M',
        'LTL' => 'Lt',
        'LVL' => 'Ls',
        'MAD' => 'MAD',
        'MDL' => 'lei',
        'MGA' => 'Ar',
        'MKD' => 'ден',
        'MMK' => 'K',
        'MNT' => '₮',
        'MOP' => 'MOP$',
        'MUR' => '₨',
        'MVR' => 'Rf',
        'MWK' => 'MK',
        'MXN' => '$',
        'MYR' => 'RM',
        'MZN' => 'MT',
        'NAD' => '$',
        'NGN' => '₦',
        'NIO' => 'C$',
        'NOK' => 'kr',
        'NPR' => '₨',
        'NZD' => '$',
        'OMR' => '﷼',
        'PAB' => 'B/.',
        'PEN' => 'S/.',
        'PGK' => 'K',
        'PHP' => '₱',
        'PKR' => '₨',
        'PLN' => 'zł',
        'PYG' => 'Gs',
        'QAR' => '﷼',
        'RMB' => '￥',
        'RON' => 'lei',
        'RSD' => 'Дин.',
        'RUB' => '₽',
        'RWF' => 'R₣',
        'SAR' => '﷼',
        'SBD' => '$',
        'SCR' => '₨',
        'SDG' => 'ج.س.',
        'SEK' => 'kr',
        'SGD' => '$',
        'SHP' => '£',
        'SLL' => 'Le',
        'SOS' => 'S',
        'SRD' => '$',
        'SSP' => '£',
        'STD' => 'Db',
        'SVC' => '$',
        'SYP' => '£',
        'SZL' => 'E',
        'THB' => '฿',
        'TJS' => 'SM',
        'TMT' => 'T',
        'TND' => 'د.ت',
        'TOP' => 'T$',
        'TRL' => '₤',
        'TRY' => '₺',
        'TTD' => 'TT$',
        'TVD' => '$',
        'TWD' => 'NT$',
        'TZS' => 'TSh',
        'UAH' => '₴',
        'UGX' => 'USh',
        'USD' => '$',
        'UYU' => '$U',
        'UZS' => 'лв',
        'VEF' => 'Bs',
        'VND' => '₫',
        'VUV' => 'VT',
        'WST' => 'WS$',
        'XAF' => 'FCFA',
        'XBT' => 'Ƀ',
        'XCD' => '$',
        'XOF' => 'CFA',
        'XPF' => '₣',
        'YER' => '﷼',
        'ZAR' => 'R',
        'ZWD' => 'Z$',
        'BTC' => '฿'
      ],
      'list' => [
        0 => 'AFN',
        1 => 'AED',
        2 => 'ALL',
        3 => 'ANG',
        4 => 'AOA',
        5 => 'ARS',
        6 => 'AUD',
        7 => 'BAM',
        8 => 'BDT',
        9 => 'BGN',
        10 => 'BHD',
        11 => 'BND',
        12 => 'BOB',
        13 => 'BRL',
        14 => 'BWP',
        15 => 'BYN',
        16 => 'CAD',
        17 => 'CHF',
        18 => 'CLP',
        19 => 'CNY',
        20 => 'COP',
        21 => 'CRC',
        22 => 'CVE',
        23 => 'CZK',
        24 => 'DKK',
        25 => 'DOP',
        26 => 'DZD',
        27 => 'EGP',
        28 => 'EUR',
        29 => 'FJD',
        30 => 'GBP',
        31 => 'GNF',
        32 => 'GTQ',
        33 => 'HKD',
        34 => 'HNL',
        35 => 'HRK',
        36 => 'HUF',
        37 => 'IDR',
        38 => 'ILS',
        39 => 'INR',
        40 => 'IRR',
        41 => 'JMD',
        42 => 'JOD',
        43 => 'JPY',
        44 => 'KES',
        45 => 'KRW',
        46 => 'KWD',
        47 => 'KYD',
        48 => 'KZT',
        49 => 'LBP',
        50 => 'LKR',
        51 => 'MAD',
        52 => 'MDL',
        53 => 'MKD',
        54 => 'MMK',
        55 => 'MUR',
        56 => 'MXN',
        57 => 'MYR',
        58 => 'MZN',
        59 => 'NAD',
        60 => 'NGN',
        61 => 'NIO',
        62 => 'NOK',
        63 => 'NPR',
        64 => 'NZD',
        65 => 'OMR',
        66 => 'PEN',
        67 => 'PGK',
        68 => 'PHP',
        69 => 'PKR',
        70 => 'PLN',
        71 => 'PYG',
        72 => 'QAR',
        73 => 'RON',
        74 => 'RSD',
        75 => 'RUB',
        76 => 'SAR',
        77 => 'SCR',
        78 => 'SEK',
        79 => 'SGD',
        80 => 'SLL',
        81 => 'SVC',
        82 => 'THB',
        83 => 'TND',
        84 => 'TRY',
        85 => 'TTD',
        86 => 'TWD',
        87 => 'TZS',
        88 => 'UAH',
        89 => 'UGX',
        90 => 'USD',
        91 => 'UYU',
        92 => 'UZS',
        93 => 'VND',
        94 => 'XAF',
        95 => 'YER',
        96 => 'ZAR',
        97 => 'ZMW',
        98 => 'ZWL'
      ]
    ],
    'currencyConversion' => [
      'entityConverterClassNameMap' => [
        'Quote' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'SalesOrder' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'Invoice' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'PurchaseOrder' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'DeliveryOrder' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'ReceiptOrder' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'TransferOrder' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'ReturnOrder' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'Opportunity' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter'
      ]
    ],
    'databasePlatforms' => [
      'Mysql' => [
        'detailsProviderClassName' => 'Espo\\Core\\Utils\\Database\\DetailsProviders\\MysqlDetailsProvider',
        'dbalConnectionFactoryClassName' => 'Espo\\Core\\Utils\\Database\\Dbal\\Factories\\MysqlConnectionFactory',
        'indexHelperClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\IndexHelpers\\MysqlIndexHelper',
        'columnPreparatorClassName' => 'Espo\\Core\\Utils\\Database\\Schema\\ColumnPreparators\\MysqlColumnPreparator',
        'preRebuildActionClassNameList' => [
          0 => 'Espo\\Core\\Utils\\Database\\Schema\\RebuildActions\\PrepareForFulltextIndex'
        ],
        'postRebuildActionClassNameList' => [],
        'dbalTypeClassNameMap' => [
          'mediumtext' => 'Espo\\Core\\Utils\\Database\\Dbal\\Types\\MediumtextType',
          'longtext' => 'Espo\\Core\\Utils\\Database\\Dbal\\Types\\LongtextType',
          'uuid' => 'Espo\\Core\\Utils\\Database\\Dbal\\Types\\UuidType'
        ]
      ],
      'Postgresql' => [
        'detailsProviderClassName' => 'Espo\\Core\\Utils\\Database\\DetailsProviders\\PostgresqlDetailsProvider',
        'dbalConnectionFactoryClassName' => 'Espo\\Core\\Utils\\Database\\Dbal\\Factories\\PostgresqlConnectionFactory',
        'indexHelperClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\IndexHelpers\\PostgresqlIndexHelper',
        'columnPreparatorClassName' => 'Espo\\Core\\Utils\\Database\\Schema\\ColumnPreparators\\PostgresqlColumnPreparator',
        'dbalTypeClassNameMap' => [
          'uuid' => 'Espo\\Core\\Utils\\Database\\Dbal\\Types\\UuidType'
        ]
      ]
    ],
    'dateTime' => [
      'dateFormatList' => [
        0 => 'DD.MM.YYYY',
        1 => 'MM/DD/YYYY',
        2 => 'DD/MM/YYYY',
        3 => 'YYYY-MM-DD',
        4 => 'DD. MM. YYYY'
      ],
      'timeFormatList' => [
        0 => 'HH:mm',
        1 => 'hh:mma',
        2 => 'hh:mmA',
        3 => 'hh:mm A',
        4 => 'hh:mm a'
      ]
    ],
    'defaultDashboardLayouts' => [
      'Standard' => [
        0 => [
          'name' => 'My Espo',
          'layout' => [
            0 => [
              'id' => 'defaultActivities',
              'name' => 'Activities',
              'x' => 2,
              'y' => 2,
              'width' => 2,
              'height' => 2
            ],
            1 => [
              'id' => 'defaultStream',
              'name' => 'Stream',
              'x' => 0,
              'y' => 0,
              'width' => 2,
              'height' => 4
            ],
            2 => [
              'id' => 'defaultTasks',
              'name' => 'Tasks',
              'x' => 2,
              'y' => 4,
              'width' => 2,
              'height' => 2
            ]
          ]
        ]
      ]
    ],
    'defaultDashboardOptions' => [
      'Standard' => [
        'defaultStream' => [
          'displayRecords' => 10
        ]
      ]
    ],
    'emailTemplate' => [
      'placeholders' => [
        'today' => [
          'className' => 'Espo\\Tools\\EmailTemplate\\Placeholders\\Today',
          'order' => 0
        ],
        'now' => [
          'className' => 'Espo\\Tools\\EmailTemplate\\Placeholders\\Now',
          'order' => 1
        ],
        'currentYear' => [
          'className' => 'Espo\\Tools\\EmailTemplate\\Placeholders\\CurrentYear',
          'order' => 2
        ]
      ]
    ],
    'entityManager' => [
      'createHookClassNameList' => [
        0 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\PlusCreateHook',
        1 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\EventCreateHook'
      ],
      'deleteHookClassNameList' => [
        0 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\PlusDeleteHook',
        1 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\EventDeleteHook',
        2 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\DeleteHasChildrenLinks'
      ],
      'updateHookClassNameList' => [
        0 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\AssignedUsersUpdateHook',
        1 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\CollaboratorsUpdateHook',
        2 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\StreamUpdateHook'
      ]
    ],
    'entityManagerParams' => [
      'Global' => [
        'stars' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'optimisticConcurrencyControl' => [
          'location' => 'entityDefs',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'preserveAuditLog' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      '@Company' => [
        'updateDuplicateCheck' => [
          'location' => 'recordDefs',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'aclContactLink' => [
          'location' => 'aclDefs',
          'param' => 'contactLink',
          'fieldDefs' => [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-contact-link'
          ]
        ],
        'aclAccountLink' => [
          'location' => 'aclDefs',
          'param' => 'accountLink',
          'fieldDefs' => [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-account-link'
          ]
        ]
      ],
      '@Person' => [
        'updateDuplicateCheck' => [
          'location' => 'recordDefs',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'aclContactLink' => [
          'location' => 'aclDefs',
          'param' => 'contactLink',
          'fieldDefs' => [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-contact-link'
          ]
        ],
        'aclAccountLink' => [
          'location' => 'aclDefs',
          'param' => 'accountLink',
          'fieldDefs' => [
            'type' => 'enum',
            'tooltip' => true
          ],
          'view' => 'views/admin/entity-manager/fields/acl-account-link'
        ]
      ],
      '@Base' => [
        'updateDuplicateCheck' => [
          'location' => 'recordDefs',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'aclContactLink' => [
          'location' => 'aclDefs',
          'param' => 'contactLink',
          'fieldDefs' => [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-contact-link'
          ]
        ],
        'aclAccountLink' => [
          'location' => 'aclDefs',
          'param' => 'accountLink',
          'fieldDefs' => [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-account-link'
          ]
        ]
      ],
      '@BasePlus' => [
        'updateDuplicateCheck' => [
          'location' => 'recordDefs',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'aclContactLink' => [
          'location' => 'aclDefs',
          'param' => 'contactLink',
          'fieldDefs' => [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-contact-link'
          ]
        ],
        'aclAccountLink' => [
          'location' => 'aclDefs',
          'param' => 'accountLink',
          'fieldDefs' => [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-account-link'
          ]
        ]
      ],
      'Account' => [
        'updateDuplicateCheck' => [
          'location' => 'recordDefs',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'Contact' => [
        'updateDuplicateCheck' => [
          'location' => 'recordDefs',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'Lead' => [
        'updateDuplicateCheck' => [
          'location' => 'recordDefs',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'Opportunity' => [
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'Document' => [
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'Case' => [
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'KnowledgeBaseArticle' => [
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'Meeting' => [
        'activityStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'historyStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'completedStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'canceledStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ]
      ],
      'Call' => [
        'activityStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'historyStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'completedStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'canceledStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ]
      ],
      'Task' => [
        'completedStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'canceledStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'TargetList' => [
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      '@Event' => [
        'activityStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'historyStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'completedStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'canceledStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'collaborators' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'aclContactLink' => [
          'location' => 'aclDefs',
          'param' => 'contactLink',
          'fieldDefs' => [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-contact-link'
          ]
        ],
        'aclAccountLink' => [
          'location' => 'aclDefs',
          'param' => 'accountLink',
          'fieldDefs' => [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-account-link'
          ]
        ]
      ],
      'Product' => [
        'variantSyncFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/product-variant-sync-field-list',
            'tooltip' => 'productVariantSyncFieldList'
          ]
        ]
      ],
      'SalesOrder' => [
        'softReserveStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/sales-order-status-list',
            'tooltip' => 'salesOrderSoftReserveStatusList'
          ]
        ],
        'doneStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/sales-order-status-list',
            'tooltip' => 'salesOrderDoneStatusList'
          ]
        ],
        'canceledStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/sales-order-status-list',
            'tooltip' => 'salesOrderCanceledStatusList'
          ]
        ],
        'deliveryRequiredStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/sales-order-status-list',
            'tooltip' => 'deliveryRequiredStatusList'
          ]
        ],
        'lockableFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'DeliveryOrder' => [
        'softReserveStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/delivery-order-status-list',
            'tooltip' => 'deliveryOrderSoftReserveStatusList'
          ]
        ],
        'reserveStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/delivery-order-status-list',
            'tooltip' => 'deliveryOrderReserveStatusList'
          ]
        ],
        'canceledStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/delivery-order-status-list',
            'tooltip' => 'deliveryOrderCanceledStatusList'
          ]
        ],
        'doneStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/delivery-order-status-list',
            'tooltip' => 'deliveryOrderDoneStatusList'
          ]
        ],
        'failedStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/delivery-order-status-list',
            'tooltip' => 'deliveryOrderFailedStatusList'
          ]
        ],
        'lockableFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'TransferOrder' => [
        'softReserveStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/transfer-order-status-list',
            'tooltip' => 'transferOrderSoftReserveStatusList'
          ]
        ],
        'reserveStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/transfer-order-status-list',
            'tooltip' => 'transferOrderReserveStatusList'
          ]
        ],
        'canceledStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/transfer-order-status-list',
            'tooltip' => 'transferOrderCanceledStatusList'
          ]
        ],
        'doneStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/transfer-order-status-list',
            'tooltip' => 'transferOrderDoneStatusList'
          ]
        ],
        'failedStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/transfer-order-status-list',
            'tooltip' => 'transferOrderFailedStatusList'
          ]
        ],
        'lockableFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'PurchaseOrder' => [
        'doneStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/purchase-order-status-list',
            'tooltip' => 'purchaseOrderDoneStatusList'
          ]
        ],
        'canceledStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/purchase-order-status-list',
            'tooltip' => 'purchaseOrderCanceledStatusList'
          ]
        ],
        'lockableFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'ReceiptOrder' => [
        'doneStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/receipt-order-status-list',
            'tooltip' => 'receiptOrderDoneStatusList'
          ]
        ],
        'canceledStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/receipt-order-status-list',
            'tooltip' => 'receiptOrderCanceledStatusList'
          ]
        ],
        'lockableFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'Quote' => [
        'doneStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/quote-status-list',
            'tooltip' => 'quoteDoneStatusList'
          ]
        ],
        'canceledStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/quote-status-list',
            'tooltip' => 'quoteCanceledStatusList'
          ]
        ],
        'lockableFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'Invoice' => [
        'doneStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/invoice-status-list',
            'tooltip' => 'invoiceDoneStatusList'
          ]
        ],
        'canceledStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/invoice-status-list',
            'tooltip' => 'invoiceCanceledStatusList'
          ]
        ],
        'lockableFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'ReturnOrder' => [
        'doneStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/return-order-status-list',
            'tooltip' => 'returnOrderDoneStatusList'
          ]
        ],
        'canceledStatusList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/return-order-status-list',
            'tooltip' => 'returnOrderCanceledStatusList'
          ]
        ],
        'lockableFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'InventoryAdjustment' => [
        'lockableFieldList' => [
          'location' => 'scopes',
          'fieldDefs' => [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ]
    ],
    'entityTemplateList' => [
      0 => 'Base',
      1 => 'BasePlus',
      2 => 'Event',
      3 => 'Person',
      4 => 'Company'
    ],
    'entityTemplates' => [
      'Base' => [
        'entityClassName' => 'Espo\\Core\\Templates\\Entities\\Base',
        'repositoryClassName' => 'Espo\\Core\\Templates\\Repositories\\Base'
      ],
      'BasePlus' => [
        'entityClassName' => 'Espo\\Core\\Templates\\Entities\\BasePlus',
        'repositoryClassName' => 'Espo\\Core\\Templates\\Repositories\\BasePlus'
      ],
      'Event' => [
        'entityClassName' => 'Espo\\Core\\Templates\\Entities\\Event',
        'repositoryClassName' => 'Espo\\Core\\Templates\\Repositories\\Event'
      ],
      'Company' => [
        'entityClassName' => 'Espo\\Core\\Templates\\Entities\\Company',
        'repositoryClassName' => 'Espo\\Core\\Templates\\Repositories\\Company'
      ],
      'Person' => [
        'entityClassName' => 'Espo\\Core\\Templates\\Entities\\Person',
        'repositoryClassName' => 'Espo\\Core\\Templates\\Repositories\\Person'
      ]
    ],
    'export' => [
      'formatList' => [
        0 => 'xlsx',
        1 => 'csv'
      ],
      'formatDefs' => [
        'csv' => [
          'processorClassName' => 'Espo\\Tools\\Export\\Format\\Csv\\Processor',
          'additionalFieldsLoaderClassName' => 'Espo\\Tools\\Export\\Format\\Csv\\AdditionalFieldsLoader',
          'mimeType' => 'text/csv',
          'fileExtension' => 'csv'
        ],
        'xlsx' => [
          'processorClassName' => 'Espo\\Tools\\Export\\Format\\Xlsx\\Processor',
          'processorParamsHandler' => 'Espo\\Tools\\Export\\Format\\Xlsx\\ParamsHandler',
          'additionalFieldsLoaderClassName' => 'Espo\\Tools\\Export\\Format\\Xlsx\\AdditionalFieldsLoader',
          'mimeType' => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
          'fileExtension' => 'xlsx',
          'cellValuePreparatorClassNameMap' => [
            'link' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Link',
            'linkOne' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Link',
            'linkParent' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Link',
            'file' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Link',
            'bool' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Boolean',
            'int' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Integer',
            'float' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Floating',
            'currency' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Currency',
            'currencyConverted' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\CurrencyConverted',
            'personName' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\PersonName',
            'date' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Date',
            'datetime' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\DateTime',
            'datetimeOptional' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\DateTimeOptional',
            'linkMultiple' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\LinkMultiple',
            'attachmentMultiple' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\LinkMultiple',
            'address' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Address',
            'duration' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Duration',
            'enum' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Enumeration',
            'multiEnum' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\MultiEnum',
            'array' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\MultiEnum',
            'checklist' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\MultiEnum',
            'urlMultiple' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\MultiEnum'
          ],
          'params' => [
            'fields' => [
              'lite' => [
                'type' => 'bool',
                'default' => false,
                'tooltip' => true
              ],
              'recordLinks' => [
                'type' => 'bool',
                'default' => false
              ],
              'title' => [
                'type' => 'bool',
                'default' => false,
                'tooltip' => true
              ]
            ],
            'layout' => [
              0 => [
                0 => [
                  'name' => 'lite'
                ],
                1 => [
                  'name' => 'recordLinks'
                ],
                2 => [
                  'name' => 'title'
                ]
              ]
            ],
            'dynamicLogic' => [
              'recordLinks' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'isFalse',
                      'attribute' => 'xlsxLite'
                    ]
                  ]
                ]
              ],
              'title' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'isFalse',
                      'attribute' => 'xlsxLite'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'gridReportFormatList' => [
        0 => 'xlsx',
        1 => 'csv'
      ]
    ],
    'fieldProcessing' => [
      'readLoaderClassNameList' => [
        0 => 'Espo\\Core\\FieldProcessing\\Link\\HasOneLoader',
        1 => 'Espo\\Core\\FieldProcessing\\Link\\NotJoinedLoader',
        2 => 'Espo\\Core\\FieldProcessing\\LinkMultiple\\Loader',
        3 => 'Espo\\Core\\FieldProcessing\\LinkParent\\Loader',
        4 => 'Espo\\Core\\FieldProcessing\\EmailAddress\\Loader',
        5 => 'Espo\\Core\\FieldProcessing\\PhoneNumber\\Loader',
        6 => 'Espo\\Core\\FieldProcessing\\Stream\\FollowersLoader',
        7 => 'Espo\\Core\\FieldProcessing\\Stars\\StarLoader'
      ],
      'listLoaderClassNameList' => [
        0 => 'Espo\\Core\\FieldProcessing\\LinkParent\\Loader',
        1 => 'Espo\\Core\\FieldProcessing\\LinkMultiple\\ListLoader'
      ],
      'saverClassNameList' => [
        0 => 'Espo\\Core\\FieldProcessing\\EmailAddress\\Saver',
        1 => 'Espo\\Core\\FieldProcessing\\PhoneNumber\\Saver',
        2 => 'Espo\\Core\\FieldProcessing\\Relation\\Saver',
        3 => 'Espo\\Core\\FieldProcessing\\MultiEnum\\Saver',
        4 => 'Espo\\Core\\FieldProcessing\\File\\Saver',
        5 => 'Espo\\Core\\FieldProcessing\\Wysiwyg\\Saver'
      ]
    ],
    'file' => [
      'extensionMimeTypeMap' => [
        'aac' => [
          0 => 'audio/aac'
        ],
        'abw' => [
          0 => 'application/x-abiword'
        ],
        'arc' => [
          0 => 'application/x-freearc'
        ],
        'avif' => [
          0 => 'image/avif'
        ],
        'avi' => [
          0 => 'video/x-msvideo'
        ],
        'azw' => [
          0 => 'application/vnd.amazon.ebook'
        ],
        'bin' => [
          0 => 'application/octet-stream'
        ],
        'bmp' => [
          0 => 'image/bmp'
        ],
        'bz' => [
          0 => 'application/x-bzip'
        ],
        'bz2' => [
          0 => 'application/x-bzip2'
        ],
        'cda' => [
          0 => 'application/x-cdf'
        ],
        'csh' => [
          0 => 'application/x-csh'
        ],
        'css' => [
          0 => 'text/css'
        ],
        'csv' => [
          0 => 'text/csv'
        ],
        'doc' => [
          0 => 'application/msword'
        ],
        'docx' => [
          0 => 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'
        ],
        'eot' => [
          0 => 'application/vnd.ms-fontobject'
        ],
        'epub' => [
          0 => 'application/epub+zip'
        ],
        'gz' => [
          0 => 'application/gzip'
        ],
        'gif' => [
          0 => 'image/gif'
        ],
        'htm' => [
          0 => 'text/html'
        ],
        'html' => [
          0 => 'text/html'
        ],
        'ico' => [
          0 => 'image/vnd.microsoft.icon'
        ],
        'ics' => [
          0 => 'text/calendar'
        ],
        'jar' => [
          0 => 'application/java-archive'
        ],
        'jpeg' => [
          0 => 'image/jpeg'
        ],
        'jpg' => [
          0 => 'image/jpeg'
        ],
        'js' => [
          0 => 'text/javascript'
        ],
        'json' => [
          0 => 'application/json'
        ],
        'jsonld' => [
          0 => 'application/ld+json'
        ],
        'mid' => [
          0 => 'audio/midi',
          1 => 'audio/x-midi'
        ],
        'midi' => [
          0 => 'audio/midi',
          1 => 'audio/x-midi'
        ],
        'mjs' => [
          0 => 'text/javascript'
        ],
        'mp3' => [
          0 => 'audio/mpeg'
        ],
        'mp4' => [
          0 => 'video/mp4'
        ],
        'mpeg' => [
          0 => 'video/mpeg'
        ],
        'mpkg' => [
          0 => 'application/vnd.apple.installer+xml'
        ],
        'odp' => [
          0 => 'application/vnd.oasis.opendocument.presentation'
        ],
        'ods' => [
          0 => 'application/vnd.oasis.opendocument.spreadsheet'
        ],
        'odt' => [
          0 => 'application/vnd.oasis.opendocument.text'
        ],
        'oga' => [
          0 => 'audio/ogg'
        ],
        'ogv' => [
          0 => 'video/ogg'
        ],
        'ogx' => [
          0 => 'application/ogg'
        ],
        'opus' => [
          0 => 'audio/opus'
        ],
        'otf' => [
          0 => 'font/otf'
        ],
        'png' => [
          0 => 'image/png'
        ],
        'pdf' => [
          0 => 'application/pdf'
        ],
        'php' => [
          0 => 'application/x-httpd-php'
        ],
        'ppt' => [
          0 => 'application/vnd.ms-powerpoint'
        ],
        'pptx' => [
          0 => 'application/vnd.openxmlformats-officedocument.presentationml.presentation'
        ],
        'rar' => [
          0 => 'application/vnd.rar'
        ],
        'rtf' => [
          0 => 'application/rtf'
        ],
        'sh' => [
          0 => 'application/x-sh'
        ],
        'svg' => [
          0 => 'image/svg+xml'
        ],
        'swf' => [
          0 => 'application/x-shockwave-flash'
        ],
        'tar' => [
          0 => 'application/x-tar'
        ],
        'tif' => [
          0 => 'image/tiff'
        ],
        'tiff' => [
          0 => 'image/tiff'
        ],
        'ts' => [
          0 => 'video/mp2t'
        ],
        'ttf' => [
          0 => 'font/ttf'
        ],
        'txt' => [
          0 => 'text/plain'
        ],
        'vsd' => [
          0 => 'application/vnd.visio'
        ],
        'wav' => [
          0 => 'audio/wav'
        ],
        'weba' => [
          0 => 'audio/webm'
        ],
        'webm' => [
          0 => 'video/webm'
        ],
        'webp' => [
          0 => 'image/webp'
        ],
        'woff' => [
          0 => 'font/woff'
        ],
        'woff2' => [
          0 => 'font/woff2'
        ],
        'xhtml' => [
          0 => 'application/xhtml+xml'
        ],
        'xls' => [
          0 => 'application/vnd.ms-excel'
        ],
        'xlsx' => [
          0 => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
        ],
        'xml' => [
          0 => 'application/xml'
        ],
        'xul' => [
          0 => 'application/vnd.mozilla.xul+xml'
        ],
        'zip' => [
          0 => 'application/zip'
        ],
        '3gp' => [
          0 => 'video/3gpp',
          1 => 'audio/3gpp'
        ],
        '3g2' => [
          0 => 'video/3gpp2',
          1 => 'audio/3gpp2'
        ],
        '7z' => [
          0 => 'application/x-7z-compressed'
        ],
        'md' => [
          0 => 'text/markdown'
        ]
      ],
      'inlineMimeTypeList' => [
        0 => 'application/pdf',
        1 => 'text/plain',
        2 => 'audio/wav',
        3 => 'audio/mpeg',
        4 => 'audio/ogg',
        5 => 'audio/webm',
        6 => 'video/mpeg',
        7 => 'video/mp4',
        8 => 'video/ogg',
        9 => 'video/webm',
        10 => 'image/jpeg',
        11 => 'image/png',
        12 => 'image/gif',
        13 => 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
        14 => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
        15 => 'application/vnd.ms-word',
        16 => 'application/vnd.ms-excel',
        17 => 'application/vnd.oasis.opendocument.text',
        18 => 'application/vnd.oasis.opendocument.spreadsheet',
        19 => 'application/msword',
        20 => 'application/msexcel'
      ]
    ],
    'fileStorage' => [
      'implementationClassNameMap' => [
        'EspoUploadDir' => 'Espo\\Core\\FileStorage\\Storages\\EspoUploadDir',
        'AwsS3' => 'Espo\\Core\\FileStorage\\Storages\\AwsS3'
      ]
    ],
    'formula' => [
      'functionList' => [
        0 => [
          'name' => 'ifThenElse',
          'insertText' => 'ifThenElse(CONDITION, CONSEQUENT, ALTERNATIVE)'
        ],
        1 => [
          'name' => 'ifThen',
          'insertText' => 'ifThen(CONDITION, CONSEQUENT)'
        ],
        2 => [
          'name' => 'list',
          'insertText' => 'list(ITEM_1, ITEM_2)',
          'returnType' => 'array'
        ],
        3 => [
          'name' => 'string\\concatenate',
          'insertText' => 'string\\concatenate(STRING_1, STRING_2)',
          'returnType' => 'string'
        ],
        4 => [
          'name' => 'string\\substring',
          'insertText' => 'string\\substring(STRING, START, LENGTH)',
          'returnType' => 'string'
        ],
        5 => [
          'name' => 'string\\contains',
          'insertText' => 'string\\contains(STRING, NEEDLE)',
          'returnType' => 'bool'
        ],
        6 => [
          'name' => 'string\\pos',
          'insertText' => 'string\\pos(STRING, NEEDLE)',
          'returnType' => 'int'
        ],
        7 => [
          'name' => 'string\\pad',
          'insertText' => 'string\\pad(STRING, LENGTH, PAD_STRING)',
          'returnType' => 'string'
        ],
        8 => [
          'name' => 'string\\test',
          'insertText' => 'string\\test(STRING, REGULAR_EXPRESSION)',
          'returnType' => 'bool'
        ],
        9 => [
          'name' => 'string\\length',
          'insertText' => 'string\\length(STRING)',
          'returnType' => 'int'
        ],
        10 => [
          'name' => 'string\\trim',
          'insertText' => 'string\\trim(STRING)',
          'returnType' => 'string'
        ],
        11 => [
          'name' => 'string\\lowerCase',
          'insertText' => 'string\\lowerCase(STRING)',
          'returnType' => 'string'
        ],
        12 => [
          'name' => 'string\\upperCase',
          'insertText' => 'string\\upperCase(STRING)',
          'returnType' => 'string'
        ],
        13 => [
          'name' => 'string\\match',
          'insertText' => 'string\\match(STRING, REGULAR_EXPRESSION)',
          'returnType' => 'string|null'
        ],
        14 => [
          'name' => 'string\\matchAll',
          'insertText' => 'string\\matchAll(STRING, REGULAR_EXPRESSION)',
          'returnType' => 'string[]|null'
        ],
        15 => [
          'name' => 'string\\matchExtract',
          'insertText' => 'string\\matchExtract(STRING, REGULAR_EXPRESSION)',
          'returnType' => 'string[]|null'
        ],
        16 => [
          'name' => 'string\\replace',
          'insertText' => 'string\\replace(STRING, SEARCH, REPLACE)',
          'returnType' => 'string'
        ],
        17 => [
          'name' => 'string\\split',
          'insertText' => 'string\\split(STRING, SEPARATOR)',
          'returnType' => 'string[]'
        ],
        18 => [
          'name' => 'datetime\\today',
          'insertText' => 'datetime\\today()',
          'returnType' => 'string'
        ],
        19 => [
          'name' => 'datetime\\now',
          'insertText' => 'datetime\\now()',
          'returnType' => 'string'
        ],
        20 => [
          'name' => 'datetime\\format',
          'insertText' => 'datetime\\format(VALUE)',
          'returnType' => 'string'
        ],
        21 => [
          'name' => 'datetime\\date',
          'insertText' => 'datetime\\date(VALUE)',
          'returnType' => 'int'
        ],
        22 => [
          'name' => 'datetime\\month',
          'insertText' => 'datetime\\month(VALUE)',
          'returnType' => 'int'
        ],
        23 => [
          'name' => 'datetime\\year',
          'insertText' => 'datetime\\year(VALUE)',
          'returnType' => 'int'
        ],
        24 => [
          'name' => 'datetime\\hour',
          'insertText' => 'datetime\\hour(VALUE)',
          'returnType' => 'int'
        ],
        25 => [
          'name' => 'datetime\\minute',
          'insertText' => 'datetime\\minute(VALUE)',
          'returnType' => 'int'
        ],
        26 => [
          'name' => 'datetime\\dayOfWeek',
          'insertText' => 'datetime\\dayOfWeek(VALUE)',
          'returnType' => 'int'
        ],
        27 => [
          'name' => 'datetime\\addMinutes',
          'insertText' => 'datetime\\addMinutes(VALUE, MINUTES)',
          'returnType' => 'string'
        ],
        28 => [
          'name' => 'datetime\\addHours',
          'insertText' => 'datetime\\addHours(VALUE, HOURS)',
          'returnType' => 'string'
        ],
        29 => [
          'name' => 'datetime\\addDays',
          'insertText' => 'datetime\\addDays(VALUE, DAYS)',
          'returnType' => 'string'
        ],
        30 => [
          'name' => 'datetime\\addWeeks',
          'insertText' => 'datetime\\addWeeks(VALUE, WEEKS)',
          'returnType' => 'string'
        ],
        31 => [
          'name' => 'datetime\\addMonths',
          'insertText' => 'datetime\\addMonths(VALUE, MONTHS)',
          'returnType' => 'string'
        ],
        32 => [
          'name' => 'datetime\\addYears',
          'insertText' => 'datetime\\addYears(VALUE, YEARS)',
          'returnType' => 'string'
        ],
        33 => [
          'name' => 'datetime\\diff',
          'insertText' => 'datetime\\diff(VALUE_1, VALUE_2, INTERVAL_TYPE)',
          'returnType' => 'int'
        ],
        34 => [
          'name' => 'datetime\\closest',
          'insertText' => 'datetime\\closest(VALUE, TYPE, TARGET, IS_PAST, TIMEZONE)',
          'returnType' => 'string'
        ],
        35 => [
          'name' => 'number\\format',
          'insertText' => 'number\\format(VALUE)',
          'returnType' => 'string'
        ],
        36 => [
          'name' => 'number\\abs',
          'insertText' => 'number\\abs(VALUE)'
        ],
        37 => [
          'name' => 'number\\power',
          'insertText' => 'number\\power(VALUE, EXP)',
          'returnType' => 'int|float'
        ],
        38 => [
          'name' => 'number\\round',
          'insertText' => 'number\\round(VALUE, PRECISION)',
          'returnType' => 'int|float'
        ],
        39 => [
          'name' => 'number\\floor',
          'insertText' => 'number\\floor(VALUE)',
          'returnType' => 'int'
        ],
        40 => [
          'name' => 'number\\ceil',
          'insertText' => 'number\\ceil(VALUE)',
          'returnType' => 'int'
        ],
        41 => [
          'name' => 'number\\randomInt',
          'insertText' => 'number\\randomInt(MIN, MAX)',
          'returnType' => 'int'
        ],
        42 => [
          'name' => 'number\\parseInt',
          'insertText' => 'number\\parseInt(STRING)',
          'returnType' => 'int'
        ],
        43 => [
          'name' => 'number\\parseFloat',
          'insertText' => 'number\\parseFloat(STRING)',
          'returnType' => 'float'
        ],
        44 => [
          'name' => 'entity\\isNew',
          'insertText' => 'entity\\isNew()',
          'returnType' => 'bool'
        ],
        45 => [
          'name' => 'entity\\isAttributeChanged',
          'insertText' => 'entity\\isAttributeChanged(ATTRIBUTE)',
          'returnType' => 'bool'
        ],
        46 => [
          'name' => 'entity\\isAttributeNotChanged',
          'insertText' => 'entity\\isAttributeNotChanged(ATTRIBUTE)',
          'returnType' => 'bool'
        ],
        47 => [
          'name' => 'entity\\attribute',
          'insertText' => 'entity\\attribute(ATTRIBUTE)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        48 => [
          'name' => 'entity\\attributeFetched',
          'insertText' => 'entity\\attributeFetched(ATTRIBUTE)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        49 => [
          'name' => 'entity\\setAttribute',
          'insertText' => 'entity\\setAttribute(ATTRIBUTE, VALUE)',
          'unsafe' => true
        ],
        50 => [
          'name' => 'entity\\clearAttribute',
          'insertText' => 'entity\\clearAttribute(ATTRIBUTE)',
          'unsafe' => true
        ],
        51 => [
          'name' => 'entity\\addLinkMultipleId',
          'insertText' => 'entity\\addLinkMultipleId(LINK, ID)',
          'unsafe' => true
        ],
        52 => [
          'name' => 'entity\\hasLinkMultipleId',
          'insertText' => 'entity\\hasLinkMultipleId(LINK, ID)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        53 => [
          'name' => 'entity\\removeLinkMultipleId',
          'insertText' => 'entity\\removeLinkMultipleId(LINK, ID)',
          'unsafe' => true
        ],
        54 => [
          'name' => 'entity\\getLinkColumn',
          'insertText' => 'entity\\getLinkColumn(LINK, ID, COLUMN)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        55 => [
          'name' => 'entity\\setLinkMultipleColumn',
          'insertText' => 'entity\\setLinkMultipleColumn(LINK, ID, COLUMN, VALUE)',
          'unsafe' => true
        ],
        56 => [
          'name' => 'entity\\isRelated',
          'insertText' => 'entity\\isRelated(LINK, ID)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        57 => [
          'name' => 'entity\\sumRelated',
          'insertText' => 'entity\\sumRelated(LINK, FIELD, FILTER)',
          'returnType' => 'int|float',
          'unsafe' => true
        ],
        58 => [
          'name' => 'entity\\countRelated',
          'insertText' => 'entity\\countRelated(LINK, FILTER)',
          'returnType' => 'int',
          'unsafe' => true
        ],
        59 => [
          'name' => 'record\\exists',
          'insertText' => 'record\\exists(ENTITY_TYPE, KEY, VALUE)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        60 => [
          'name' => 'record\\count',
          'insertText' => 'record\\count(ENTITY_TYPE, KEY, VALUE)',
          'returnType' => 'int',
          'unsafe' => true
        ],
        61 => [
          'name' => 'record\\attribute',
          'insertText' => 'record\\attribute(ENTITY_TYPE, ID, ATTRIBUTE)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        62 => [
          'name' => 'record\\findOne',
          'insertText' => 'record\\findOne(ENTITY_TYPE, ORDER_BY, ORDER, KEY1, VALUE1, KEY2, VALUE2)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        63 => [
          'name' => 'record\\findMany',
          'insertText' => 'record\\findMany(ENTITY_TYPE, LIMIT, ORDER_BY, ORDER, KEY1, VALUE1, KEY2, VALUE2)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        64 => [
          'name' => 'record\\findRelatedOne',
          'insertText' => 'record\\findRelatedOne(ENTITY_TYPE, ID, LINK, ORDER_BY, ORDER, KEY1, VALUE1, KEY2, VALUE2)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        65 => [
          'name' => 'record\\findRelatedMany',
          'insertText' => 'record\\findRelatedMany(ENTITY_TYPE, ID, LINK, LIMIT, ORDER_BY, ORDER, KEY1, VALUE1, KEY2, VALUE2)',
          'returnType' => 'string[]',
          'unsafe' => true
        ],
        66 => [
          'name' => 'record\\fetch',
          'insertText' => 'record\\fetch(ENTITY_TYPE, ID)',
          'returnType' => '?object',
          'unsafe' => true
        ],
        67 => [
          'name' => 'record\\relate',
          'insertText' => 'record\\relate(ENTITY_TYPE, ID, LINK, FOREIGN_ID)',
          'unsafe' => true
        ],
        68 => [
          'name' => 'record\\unrelate',
          'insertText' => 'record\\unrelate(ENTITY_TYPE, ID, LINK, FOREIGN_ID)',
          'unsafe' => true
        ],
        69 => [
          'name' => 'record\\create',
          'insertText' => 'record\\create(ENTITY_TYPE, ATTRIBUTE1, VALUE1, ATTRIBUTE2, VALUE2)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        70 => [
          'name' => 'record\\update',
          'insertText' => 'record\\update(ENTITY_TYPE, ID, ATTRIBUTE1, VALUE1, ATTRIBUTE2, VALUE2)',
          'unsafe' => true
        ],
        71 => [
          'name' => 'record\\delete',
          'insertText' => 'record\\delete(ENTITY_TYPE, ID)',
          'unsafe' => true
        ],
        72 => [
          'name' => 'record\\relationColumn',
          'insertText' => 'record\\relationColumn(ENTITY_TYPE, ID, LINK, FOREIGN_ID, COLUMN)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        73 => [
          'name' => 'record\\updateRelationColumn',
          'insertText' => 'record\\updateRelationColumn(ENTITY_TYPE, ID, LINK, FOREIGN_ID, COLUMN, VALUE)',
          'unsafe' => true
        ],
        74 => [
          'name' => 'env\\userAttribute',
          'insertText' => 'env\\userAttribute(ATTRIBUTE)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        75 => [
          'name' => 'util\\generateId',
          'insertText' => 'util\\generateId()',
          'returnType' => 'string'
        ],
        76 => [
          'name' => 'util\\generateRecordId',
          'insertText' => 'util\\generateRecordId()',
          'returnType' => 'string'
        ],
        77 => [
          'name' => 'util\\base64Encode',
          'insertText' => 'util\\base64Encode(STRING)',
          'returnType' => 'string'
        ],
        78 => [
          'name' => 'util\\base64Decode',
          'insertText' => 'util\\base64Decode(STRING)',
          'returnType' => 'string'
        ],
        79 => [
          'name' => 'object\\create',
          'insertText' => 'object\\create()',
          'returnType' => 'object'
        ],
        80 => [
          'name' => 'object\\get',
          'insertText' => 'object\\get(OBJECT, KEY)',
          'returnType' => 'mixed'
        ],
        81 => [
          'name' => 'object\\has',
          'insertText' => 'object\\has(OBJECT, KEY)',
          'returnType' => 'bool'
        ],
        82 => [
          'name' => 'object\\set',
          'insertText' => 'object\\set(OBJECT, KEY, VALUE)'
        ],
        83 => [
          'name' => 'object\\clear',
          'insertText' => 'object\\clear(OBJECT, KEY)',
          'returnType' => 'object'
        ],
        84 => [
          'name' => 'object\\cloneDeep',
          'insertText' => 'object\\cloneDeep(OBJECT)',
          'returnType' => 'object'
        ],
        85 => [
          'name' => 'password\\generate',
          'insertText' => 'password\\generate()',
          'returnType' => 'string'
        ],
        86 => [
          'name' => 'password\\hash',
          'insertText' => 'password\\hash(PASSWORD)',
          'returnType' => 'string'
        ],
        87 => [
          'name' => 'array\\includes',
          'insertText' => 'array\\includes(LIST, VALUE)',
          'returnType' => 'bool'
        ],
        88 => [
          'name' => 'array\\push',
          'insertText' => 'array\\push(LIST, VALUE)'
        ],
        89 => [
          'name' => 'array\\length',
          'insertText' => 'array\\length(LIST)',
          'returnType' => 'int'
        ],
        90 => [
          'name' => 'array\\at',
          'insertText' => 'array\\at(LIST, INDEX)',
          'returnType' => 'mixed'
        ],
        91 => [
          'name' => 'array\\join',
          'insertText' => 'array\\join(LIST, SEPARATOR)',
          'returnType' => 'string'
        ],
        92 => [
          'name' => 'array\\indexOf',
          'insertText' => 'array\\indexOf(LIST, ELEMENT)',
          'returnType' => '?int'
        ],
        93 => [
          'name' => 'array\\removeAt',
          'insertText' => 'array\\removeAt(LIST, INDEX)',
          'returnType' => 'array'
        ],
        94 => [
          'name' => 'array\\unique',
          'insertText' => 'array\\unique(LIST)',
          'returnType' => 'array'
        ],
        95 => [
          'name' => 'language\\translate',
          'insertText' => 'language\\translate(LABEL, CATEGORY, SCOPE)',
          'returnType' => 'string'
        ],
        96 => [
          'name' => 'language\\translateOption',
          'insertText' => 'language\\translateOption(OPTION, FIELD, SCOPE)',
          'returnType' => 'string'
        ],
        97 => [
          'name' => 'log\\info',
          'insertText' => 'log\\info(MESSAGE)',
          'unsafe' => true
        ],
        98 => [
          'name' => 'log\\notice',
          'insertText' => 'log\\notice(MESSAGE)',
          'unsafe' => true
        ],
        99 => [
          'name' => 'log\\warning',
          'insertText' => 'log\\warning(MESSAGE)',
          'unsafe' => true
        ],
        100 => [
          'name' => 'log\\error',
          'insertText' => 'log\\error(MESSAGE)',
          'unsafe' => true
        ],
        101 => [
          'name' => 'json\\retrieve',
          'insertText' => 'json\\retrieve(JSON, PATH)',
          'returnType' => 'mixed'
        ],
        102 => [
          'name' => 'json\\encode',
          'insertText' => 'json\\encode(VALUE)',
          'returnType' => 'string'
        ],
        103 => [
          'name' => 'ext\\email\\send',
          'insertText' => 'ext\\email\\send(EMAIL_ID)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        104 => [
          'name' => 'ext\\sms\\send',
          'insertText' => 'ext\\sms\\send(SMS_ID)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        105 => [
          'name' => 'ext\\email\\applyTemplate',
          'insertText' => 'ext\\email\\applyTemplate(EMAIL_ID, EMAIL_TEMPLATE_ID)',
          'unsafe' => true
        ],
        106 => [
          'name' => 'ext\\markdown\\transform',
          'insertText' => 'ext\\markdown\\transform(STRING)',
          'returnType' => 'string'
        ],
        107 => [
          'name' => 'ext\\pdf\\generate',
          'insertText' => 'ext\\pdf\\generate(ENTITY_TYPE, ENTITY_ID, TEMPLATE_ID, FILENAME)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        108 => [
          'name' => 'ext\\workingTime\\addWorkingDays',
          'insertText' => 'ext\\workingTime\\addWorkingDays(DATE, DAYS)',
          'returnType' => 'string|null'
        ],
        109 => [
          'name' => 'ext\\workingTime\\findClosestWorkingTime',
          'insertText' => 'ext\\workingTime\\findClosestWorkingTime(DATE)',
          'returnType' => 'string|null'
        ],
        110 => [
          'name' => 'ext\\workingTime\\getSummedWorkingHours',
          'insertText' => 'ext\\workingTime\\getSummedWorkingHours(FROM, TO)',
          'returnType' => 'float'
        ],
        111 => [
          'name' => 'ext\\workingTime\\getWorkingDays',
          'insertText' => 'ext\\workingTime\\getWorkingDays(FROM, TO)',
          'returnType' => 'int'
        ],
        112 => [
          'name' => 'ext\\workingTime\\hasWorkingTime',
          'insertText' => 'ext\\workingTime\\hasWorkingTime(FROM, TO)',
          'returnType' => 'bool'
        ],
        113 => [
          'name' => 'ext\\workingTime\\isWorkingDay',
          'insertText' => 'ext\\workingTime\\isWorkingDay(DATE)',
          'returnType' => 'bool'
        ],
        114 => [
          'name' => 'ext\\user\\sendAccessInfo',
          'insertText' => 'ext\\user\\sendAccessInfo(USER_ID)',
          'unsafe' => true
        ],
        115 => [
          'name' => 'ext\\email\\send',
          'insertText' => 'ext\\email\\send(EMAIL_ID)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        116 => [
          'name' => 'ext\\currency\\convert',
          'insertText' => 'ext\\currency\\convert(AMOUNT, FROM_CODE)',
          'returnType' => 'string'
        ],
        117 => [
          'name' => 'ext\\acl\\checkEntity',
          'insertText' => 'ext\\acl\\checkEntity(USER_ID, ENTITY_TYPE, ID, ACTION)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        118 => [
          'name' => 'ext\\acl\\checkScope',
          'insertText' => 'ext\\acl\\checkScope(USER_ID, SCOPE, ACTION)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        119 => [
          'name' => 'ext\\acl\\getLevel',
          'insertText' => 'ext\\acl\\getLevel(USER_ID, SCOPE, ACTION)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        120 => [
          'name' => 'ext\\acl\\getPermissionLevel',
          'insertText' => 'ext\\acl\\getPermissionLevel(USER_ID, PERMISSION)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        121 => [
          'name' => 'ext\\account\\findByEmailAddress',
          'insertText' => 'ext\\account\\findByEmailAddress(EMAIL_ADDRESS)',
          'returnType' => 'string'
        ],
        122 => [
          'name' => 'ext\\calendar\\userIsBusy',
          'insertText' => 'ext\\calendar\\userIsBusy(USER_ID, FROM, TO)',
          'returnType' => 'bool'
        ],
        123 => [
          'name' => 'report\\export',
          'insertText' => 'report\\export(\'REPORT_ID\')',
          'returnType' => 'string',
          'unsafe' => true
        ],
        124 => [
          'name' => 'report\\recordAttribute',
          'unsafe' => true
        ],
        125 => [
          'name' => 'bpm\\processEntity\\attribute',
          'insertText' => 'bpm\\processEntity\\attribute(\'ATTRIBUTE_NAME\')',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        126 => [
          'name' => 'bpm\\targetEntity\\attribute',
          'insertText' => 'bpm\\targetEntity\\attribute(\'ATTRIBUTE_NAME)\'',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        127 => [
          'name' => 'bpm\\createdEntity\\attribute',
          'insertText' => 'bpm\\createdEntity\\attribute(\'ALIAS_ID\', \'ATTRIBUTE_NAME\')',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        128 => [
          'name' => 'bpm\\broadcastSignal',
          'insertText' => 'bpm\\broadcastSignal(SIGNAL_NAME, [ENTITY_TYPE], [ENTITY_ID])',
          'unsafe' => true
        ],
        129 => [
          'name' => 'bpm\\startProcess',
          'insertText' => 'bpm\\startProcess(FLOWCHART_ID, TARGET_TYPE, TARGET_ID)',
          'unsafe' => true
        ],
        130 => [
          'name' => 'bpm\\caughtErrorCode',
          'insertText' => 'bpm\\caughtErrorCode()',
          'returnType' => '?string',
          'unsafe' => true
        ],
        131 => [
          'name' => 'bpm\\caughtErrorMessage',
          'insertText' => 'bpm\\caughtErrorMessage()',
          'returnType' => '?string',
          'unsafe' => true
        ],
        132 => [
          'name' => 'workflow\\targetEntity\\attribute',
          'insertText' => 'workflow\\targetEntity\\attribute(\'ATTRIBUTE_NAME\')',
          'unsafe' => true
        ],
        133 => [
          'name' => 'workflow\\targetEntity\\attributeFetched',
          'insertText' => 'workflow\\targetEntity\\attributeFetched(\'ATTRIBUTE_NAME\')',
          'unsafe' => true
        ],
        134 => [
          'name' => 'workflow\\trigger',
          'insertText' => 'workflow\\trigger(ENTITY_TYPE, ID, WORKFLOW_ID)',
          'unsafe' => true
        ],
        135 => [
          'name' => 'workflow\\lastHttpResponseBody',
          'insertText' => 'workflow\\lastHttpResponseBody()',
          'returnType' => 'string|null',
          'unsafe' => true
        ],
        136 => [
          'name' => 'workflow\\lastHttpResponseCode',
          'insertText' => 'workflow\\lastHttpResponseCode()',
          'returnType' => 'int|null',
          'unsafe' => true
        ],
        137 => [
          'name' => 'workflow\\signalParam',
          'insertText' => 'workflow\\signalParam(NAME)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        138 => [
          'name' => 'workflow\\lastCreatedEntityId',
          'insertText' => 'workflow\\lastCreatedEntityId()',
          'returnType' => 'string|null',
          'unsafe' => true
        ],
        139 => [
          'name' => 'workflow\\alert',
          'insertText' => 'workflow\\alert(MESSAGE)',
          'unsafe' => true
        ]
      ],
      'functionClassNameMap' => [
        'log\\info' => 'Espo\\Core\\Formula\\Functions\\LogGroup\\InfoType',
        'log\\notice' => 'Espo\\Core\\Formula\\Functions\\LogGroup\\NoticeType',
        'log\\warning' => 'Espo\\Core\\Formula\\Functions\\LogGroup\\WarningType',
        'log\\error' => 'Espo\\Core\\Formula\\Functions\\LogGroup\\ErrorType',
        'ext\\acl\\checkEntity' => 'Espo\\Core\\Formula\\Functions\\ExtGroup\\AclGroup\\CheckEntityType',
        'ext\\acl\\checkScope' => 'Espo\\Core\\Formula\\Functions\\ExtGroup\\AclGroup\\CheckScopeType',
        'ext\\acl\\getLevel' => 'Espo\\Core\\Formula\\Functions\\ExtGroup\\AclGroup\\GetLevelType',
        'ext\\acl\\getPermissionLevel' => 'Espo\\Core\\Formula\\Functions\\ExtGroup\\AclGroup\\GetPermissionLevelType',
        'util\\base64Encode' => 'Espo\\Core\\Formula\\Functions\\UtilGroup\\Base64EncodeType',
        'util\\base64Decode' => 'Espo\\Core\\Formula\\Functions\\UtilGroup\\Base64DecodeType',
        'ext\\account\\findByEmailAddress' => 'Espo\\Modules\\Crm\\Classes\\FormulaFunctions\\ExtGroup\\AccountGroup\\FindByEmailAddressType',
        'ext\\calendar\\userIsBusy' => 'Espo\\Modules\\Crm\\Classes\\FormulaFunctions\\ExtGroup\\CalendarGroup\\UserIsBusyType',
        'processEntity\\attribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\ProcessEntityGroup\\AttributeType',
        'bpm\\broadcastSignal' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\BroadcastSignalType',
        'bpm\\processEntity\\attribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\ProcessEntityGroup\\AttributeType',
        'bpm\\createdEntity\\attribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\CreatedEntityGroup\\AttributeType',
        'bpm\\targetEntity\\attribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\AttributeType',
        'bpm\\startProcess' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\StartProcessType',
        'bpm\\caughtErrorMessage' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\CaughtErrorMessage',
        'bpm\\caughtErrorCode' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\CaughtErrorCode',
        'targetEntity\\attribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\AttributeType',
        'targetEntity\\attributeFetched' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\AttributeFetchedType',
        'targetEntity\\isAttributeChanged' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\IsAttributeChangedType',
        'targetEntity\\isAttributeNotChanged' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\IsAttributeNotChangedType',
        'targetEntity\\isNew' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\IsNewType',
        'targetEntity\\isRelated' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\IsRelatedType',
        'targetEntity\\hasLinkMultipleId' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\HasLinkMultipleIdType',
        'workflow\\lastHttpResponseBody' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\WorkflowGroup\\LastHttpResponseBodyType',
        'workflow\\lastHttpResponseCode' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\WorkflowGroup\\LastHttpResponseCodeType',
        'workflow\\trigger' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\WorkflowGroup\\TriggerType',
        'workflow\\targetEntity\\attribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\AttributeType',
        'workflow\\targetEntity\\attributeFetched' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\AttributeFetchedType',
        'workflow\\targetEntity\\isAttributeChanged' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\IsAttributeChangedType',
        'workflow\\targetEntity\\isAttributeNotChanged' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\IsAttributeNotChangedType',
        'workflow\\signalParam' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\WorkflowGroup\\SignalParamType',
        'workflow\\lastCreatedEntityId' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\WorkflowGroup\\LastCreatedEntityIdType',
        'workflow\\alert' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\WorkflowGroup\\AlertType',
        'report\\recordAttribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\ReportGroup\\RecordAttribute',
        'report\\export' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\ReportGroup\\Export',
        'ext\\priceRule\\productAttribute' => 'Espo\\Modules\\Sales\\Classes\\FormulaFunctions\\PriceRule\\ProductAttribute',
        'ext\\priceRule\\accountAttribute' => 'Espo\\Modules\\Sales\\Classes\\FormulaFunctions\\PriceRule\\AccountAttribute'
      ]
    ],
    'hook' => [
      'suppressClassNameList' => []
    ],
    'image' => [
      'allowedFileTypeList' => [
        0 => 'image/jpeg',
        1 => 'image/png',
        2 => 'image/gif',
        3 => 'image/webp',
        4 => 'image/svg+xml'
      ],
      'resizableFileTypeList' => [
        0 => 'image/jpeg',
        1 => 'image/png',
        2 => 'image/gif',
        3 => 'image/webp'
      ],
      'fixOrientationFileTypeList' => [
        0 => 'image/jpeg'
      ],
      'previewFileTypeList' => [
        0 => 'image/jpeg',
        1 => 'image/png',
        2 => 'image/gif',
        3 => 'image/webp',
        4 => 'image/svg+xml'
      ],
      'sizes' => [
        'xxx-small' => [
          0 => 18,
          1 => 18
        ],
        'xx-small' => [
          0 => 32,
          1 => 32
        ],
        'x-small' => [
          0 => 64,
          1 => 64
        ],
        'small' => [
          0 => 128,
          1 => 128
        ],
        'medium' => [
          0 => 256,
          1 => 256
        ],
        'large' => [
          0 => 512,
          1 => 512
        ],
        'x-large' => [
          0 => 864,
          1 => 864
        ],
        'xx-large' => [
          0 => 1024,
          1 => 1024
        ],
        'small-logo' => [
          0 => 181,
          1 => 44
        ]
      ]
    ],
    'jsLibs' => [
      'jquery' => [
        'exposeAs' => '$'
      ],
      'backbone' => [
        'exportsTo' => 'window',
        'exportsAs' => 'Backbone'
      ],
      'bullbone' => [
        'exposeAs' => 'Bull'
      ],
      'handlebars' => [
        'exposeAs' => 'Handlebars'
      ],
      'underscore' => [
        'exposeAs' => '_'
      ],
      'marked' => [],
      'dompurify' => [
        'exposeAs' => 'DOMPurify'
      ],
      'js-base64' => [
        'exportsTo' => 'window',
        'exportsAs' => 'Base64'
      ],
      'moment' => [
        'exportsTo' => 'window',
        'exportsAs' => 'moment'
      ],
      'flotr2' => [
        'path' => 'client/lib/flotr2.js',
        'devPath' => 'client/lib/original/flotr2.js',
        'exportsTo' => 'window',
        'exportsAs' => 'Flotr',
        'sourceMap' => true,
        'aliases' => [
          0 => 'lib!Flotr'
        ]
      ],
      'espo-funnel-chart' => [
        'path' => 'client/lib/espo-funnel-chart.js',
        'exportsTo' => 'window',
        'exportsAs' => 'EspoFunnel'
      ],
      'summernote' => [
        'path' => 'client/lib/summernote.js',
        'devPath' => 'client/lib/original/summernote.js',
        'exportsTo' => '$.fn',
        'exportsAs' => 'summernote',
        'sourceMap' => true
      ],
      'jquery-ui' => [
        'exportsTo' => '$',
        'exportsAs' => 'ui'
      ],
      'jquery-ui-touch-punch' => [
        'exportsTo' => '$',
        'exportsAs' => 'ui'
      ],
      'jquery-textcomplete' => [
        'exportsTo' => '$.fn',
        'exportsAs' => 'textcomplete'
      ],
      'autocomplete' => [
        'exportsTo' => '$.fn',
        'exportsAs' => 'autocomplete'
      ],
      'timepicker' => [
        'exportsTo' => '$.fn',
        'exportsAs' => 'timepicker'
      ],
      'bootstrap-datepicker' => [
        'exportsTo' => '$.fn',
        'exportsAs' => 'datepicker'
      ],
      'selectize' => [
        'path' => 'client/lib/selectize.js',
        'devPath' => 'client/lib/original/selectize.js',
        'exportsTo' => 'window',
        'exportsAs' => 'Selectize'
      ],
      'autonumeric' => [],
      'intl-tel-input' => [
        'exportsTo' => 'window',
        'exportsAs' => 'intlTelInput'
      ],
      'intl-tel-input-utils' => [
        'exportsTo' => 'window',
        'exportsAs' => 'intlTelInputUtils'
      ],
      'intl-tel-input-globals' => [
        'exportsTo' => 'window',
        'exportsAs' => 'intlTelInputGlobals'
      ],
      'cronstrue' => [
        'path' => 'client/lib/cronstrue-i18n.js',
        'devPath' => 'client/lib/original/cronstrue-i18n.js',
        'sourceMap' => true
      ],
      'cropper' => [
        'path' => 'client/lib/cropper.js',
        'exportsTo' => '$.fn',
        'exportsAs' => 'cropper',
        'sourceMap' => true
      ],
      'gridstack' => [
        'exportsTo' => 'window',
        'exportsAs' => 'GridStack'
      ],
      'bootstrap-colorpicker' => [
        'path' => 'client/lib/bootstrap-colorpicker.js',
        'exportsTo' => '$.fn',
        'exportsAs' => 'colorpicker',
        'aliases' => [
          0 => 'lib!Colorpicker'
        ]
      ],
      'exif-js' => [
        'path' => 'client/lib/exif.js',
        'devPath' => 'client/lib/original/exif.js',
        'sourceMap' => true
      ],
      'jsbarcode' => [
        'path' => 'client/lib/JsBarcode.all.js',
        'devPath' => 'client/lib/original/JsBarcode.all.js',
        'exportsTo' => 'window',
        'exportsAs' => 'JsBarcode',
        'sourceMap' => true
      ],
      'qrcodejs' => [
        'path' => 'client/lib/qrcode.js',
        'exportsTo' => 'window',
        'exportsAs' => 'QRCode'
      ],
      'turndown' => [
        'path' => 'client/lib/turndown.browser.umd.js',
        'devPath' => 'client/lib/turndown.browser.umd.js',
        'sourceMap' => true
      ],
      'ace' => [
        'path' => 'client/lib/ace.js',
        'exportsTo' => 'window',
        'exportsAs' => 'ace'
      ],
      'ace-mode-css' => [
        'path' => 'client/lib/ace-mode-css.js',
        'exportsTo' => 'ace.require.define.modules',
        'exportsAs' => 'ace/mode/css'
      ],
      'ace-mode-html' => [
        'path' => 'client/lib/ace-mode-html.js',
        'exportsTo' => 'ace.require.define.modules',
        'exportsAs' => 'ace/mode/html'
      ],
      'ace-mode-handlebars' => [
        'path' => 'client/lib/ace-mode-handlebars.js',
        'exportsTo' => 'ace.require.define.modules',
        'exportsAs' => 'ace/mode/handlebars'
      ],
      'ace-mode-javascript' => [
        'path' => 'client/lib/ace-mode-javascript.js',
        'exportsTo' => 'ace.require.define.modules',
        'exportsAs' => 'ace/mode/javascript'
      ],
      'ace-ext-language_tools' => [
        'path' => 'client/lib/ace-ext-language_tools.js',
        'exportsTo' => 'ace.require.define.modules',
        'exportsAs' => 'ace/ext/language_tools'
      ],
      'ace-theme-tomorrow_night' => [
        'path' => 'client/lib/ace-theme-tomorrow_night.js',
        'exportsTo' => 'ace.require.define.modules',
        'exportsAs' => 'ace/theme/tomorrow_night'
      ],
      'fullcalendar' => [
        'path' => 'client/modules/crm/lib/fullcalendar.js',
        'devPath' => 'client/modules/crm/lib/original/fullcalendar.js',
        'exportsTo' => 'window',
        'exportsAs' => 'FullCalendar',
        'sourceMap' => true
      ],
      '@fullcalendar/moment' => [
        'path' => 'client/modules/crm/lib/fullcalendar-moment.js',
        'devPath' => 'client/modules/crm/lib/original/fullcalendar-moment.js',
        'exportsTo' => 'FullCalendar',
        'exportsAs' => 'Moment',
        'sourceMap' => true
      ],
      '@fullcalendar/moment-timezone' => [
        'path' => 'client/modules/crm/lib/fullcalendar-moment-timezone.js',
        'devPath' => 'client/modules/crm/lib/original/fullcalendar-moment-timezone.js',
        'exportsTo' => 'FullCalendar',
        'exportsAs' => 'MomentTimezone',
        'sourceMap' => true
      ],
      'vis-timeline' => [
        'path' => 'client/modules/crm/lib/vis-timeline.js',
        'devPath' => 'client/modules/crm/lib/original/vis-timeline.js',
        'sourceMap' => true
      ],
      'vis-data' => [
        'path' => 'client/modules/crm/lib/vis-data.js',
        'devPath' => 'client/modules/crm/lib/original/vis-data.js',
        'aliases' => [
          0 => 'vis-data/peer/umd/vis-data.js'
        ],
        'sourceMap' => true
      ],
      'swal' => [
        'path' => 'client/custom/src/js/swal.js',
        'exportsTo' => 'window',
        'exportsAs' => 'swal',
        'sourceMap' => false
      ]
    ],
    'language' => [
      'list' => [
        0 => 'en_US',
        1 => 'ar_AR',
        2 => 'bg_BG',
        3 => 'en_GB',
        4 => 'es_MX',
        5 => 'cs_CZ',
        6 => 'da_DK',
        7 => 'de_DE',
        8 => 'es_ES',
        9 => 'hr_HR',
        10 => 'hu_HU',
        11 => 'fa_IR',
        12 => 'fr_FR',
        13 => 'id_ID',
        14 => 'it_IT',
        15 => 'lt_LT',
        16 => 'lv_LV',
        17 => 'nb_NO',
        18 => 'nl_NL',
        19 => 'th_TH',
        20 => 'tr_TR',
        21 => 'sk_SK',
        22 => 'sl_SI',
        23 => 'sr_RS',
        24 => 'sv_SE',
        25 => 'ro_RO',
        26 => 'ru_RU',
        27 => 'pl_PL',
        28 => 'pt_BR',
        29 => 'pt_PT',
        30 => 'uk_UA',
        31 => 'vi_VN',
        32 => 'zh_CN',
        33 => 'zh_TW'
      ],
      'aclDependencies' => [
        'Meeting' => [
          'anyScopeList' => [
            0 => 'Call'
          ]
        ],
        'Workflow' => [
          'anyScopeList' => [
            0 => 'BpmnProcess',
            1 => 'BpmnFlowchart'
          ]
        ],
        'BpmnFlowchart' => [
          'anyScopeList' => [
            0 => 'BpmnProcess'
          ]
        ],
        'Opportunity' => [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'SalesOrder',
            2 => 'Invoice',
            3 => 'PurchaseOrder',
            4 => 'DeliveryOrder',
            5 => 'ReceiptOrder',
            6 => 'TransferOrder',
            7 => 'ReturnOrder'
          ]
        ],
        'Quote' => [
          'anyScopeList' => [
            0 => 'SalesOrder',
            1 => 'Invoice',
            2 => 'Opportunity',
            3 => 'PurchaseOrder',
            4 => 'DeliveryOrder',
            5 => 'ReceiptOrder',
            6 => 'TransferOrder',
            7 => 'ReturnOrder',
            8 => 'InventoryAdjustment',
            9 => 'Product'
          ]
        ],
        'QuoteItem' => [
          'anyScopeList' => [
            0 => 'Product',
            1 => 'SalesOrder',
            2 => 'Invoice',
            3 => 'Opportunity',
            4 => 'PurchaseOrder',
            5 => 'DeliveryOrder',
            6 => 'ReceiptOrder',
            7 => 'TransferOrder',
            8 => 'ReturnOrder',
            9 => 'InventoryAdjustment'
          ]
        ],
        'SalesOrder' => [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'Invoice'
          ]
        ],
        'Invoice' => [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'SalesOrder'
          ]
        ],
        'PurchaseOrder' => [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'Invoice',
            2 => 'SalesOrder',
            3 => 'ReturnOrder'
          ]
        ],
        'ReturnOrder' => [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'SalesOrder'
          ]
        ],
        'DeliveryOrder' => [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'SalesOrder',
            2 => 'TransferOrder'
          ]
        ],
        'DeliveryOrderItem' => [
          'anyScopeList' => [
            0 => 'ReceiptOrder'
          ]
        ],
        'ReceiptOrder' => [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'PurchaseOrder'
          ]
        ],
        'Account' => [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'SalesOrder',
            2 => 'Invoice'
          ]
        ],
        'Warehouse' => [
          'anyScopeList' => [
            0 => 'SalesOrder',
            1 => 'DeliveryOrder',
            2 => 'ReceiptOrder',
            3 => 'PurchaseOrder',
            4 => 'TransferOrder',
            5 => 'InventoryAdjustment',
            6 => 'InventoryTransaction'
          ]
        ],
        'Product' => [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'Invoice',
            2 => 'PurchaseOrder',
            3 => 'SalesOrder',
            4 => 'DeliveryOrder',
            5 => 'ReceiptOrder',
            6 => 'TransferOrder',
            7 => 'InventoryTransaction',
            8 => 'InventoryAdjustment',
            9 => 'ReturnOrder',
            10 => 'Warehouse',
            11 => 'PriceBook',
            12 => 'Supplier'
          ]
        ],
        'PriceRule' => [
          'anyScopeList' => [
            0 => 'Product',
            1 => 'ProductPrice',
            2 => 'SupplierProductPrice'
          ]
        ]
      ]
    ],
    'layouts' => [],
    'linkManager' => [
      'createHookClassNameList' => [
        0 => 'Espo\\Tools\\LinkManager\\Hook\\Hooks\\TargetListCreate'
      ],
      'deleteHookClassNameList' => [
        0 => 'Espo\\Tools\\LinkManager\\Hook\\Hooks\\TargetListDelete',
        1 => 'Espo\\Tools\\LinkManager\\Hook\\Hooks\\ForeignFieldDelete'
      ]
    ],
    'mapProviders' => [
      'Google' => [
        'renderer' => 'handlers/map/google-maps-renderer'
      ]
    ],
    'massActions' => [
      'convertCurrency' => [
        'implementationClassName' => 'Espo\\Core\\MassAction\\Actions\\MassConvertCurrency'
      ],
      'follow' => [
        'implementationClassName' => 'Espo\\Core\\MassAction\\Actions\\MassFollow'
      ],
      'unfollow' => [
        'implementationClassName' => 'Espo\\Core\\MassAction\\Actions\\MassUnfollow'
      ],
      'recalculateFormula' => [
        'implementationClassName' => 'Espo\\Core\\MassAction\\Actions\\MassRecalculateFormula'
      ],
      'update' => [
        'implementationClassName' => 'Espo\\Core\\MassAction\\Actions\\MassUpdate'
      ],
      'delete' => [
        'implementationClassName' => 'Espo\\Core\\MassAction\\Actions\\MassDelete'
      ]
    ],
    'metadata' => [
      'frontendHiddenPathList' => [
        0 => [
          0 => 'app',
          1 => 'metadata'
        ],
        1 => [
          0 => 'app',
          1 => 'containerServices'
        ],
        2 => [
          0 => 'app',
          1 => 'portalContainerServices'
        ],
        3 => [
          0 => 'app',
          1 => 'consoleCommands'
        ],
        4 => [
          0 => 'app',
          1 => 'formula',
          2 => 'functionClassNameMap'
        ],
        5 => [
          0 => 'app',
          1 => 'fileStorage',
          2 => 'implementationClassNameMap'
        ],
        6 => [
          0 => 'app',
          1 => 'client'
        ],
        7 => [
          0 => 'app',
          1 => 'language',
          2 => 'aclDependencies'
        ],
        8 => [
          0 => 'app',
          1 => 'templateHelpers'
        ],
        9 => [
          0 => 'app',
          1 => 'appParams'
        ],
        10 => [
          0 => 'app',
          1 => 'cleanup'
        ],
        11 => [
          0 => 'app',
          1 => 'authentication'
        ],
        12 => [
          0 => 'app',
          1 => 'pdfEngines',
          2 => '__ANY__',
          3 => 'implementationClassNameMap'
        ],
        13 => [
          0 => 'app',
          1 => 'addressFormats',
          2 => '__ANY__',
          3 => 'formatterClassName'
        ],
        14 => [
          0 => 'app',
          1 => 'authentication2FAMethods',
          2 => '__ANY__',
          3 => 'loginClassName'
        ],
        15 => [
          0 => 'app',
          1 => 'authentication2FAMethods',
          2 => '__ANY__',
          3 => 'userSetupClassName'
        ],
        16 => [
          0 => 'app',
          1 => 'select'
        ],
        17 => [
          0 => 'app',
          1 => 'massActions',
          2 => '__ANY__',
          3 => 'implementationClassName'
        ],
        18 => [
          0 => 'app',
          1 => 'actions',
          2 => '__ANY__',
          3 => 'implementationClassName'
        ],
        19 => [
          0 => 'app',
          1 => 'fieldProcessing'
        ],
        20 => [
          0 => 'app',
          1 => 'scheduledJobs'
        ],
        21 => [
          0 => 'app',
          1 => 'webSocket',
          2 => 'messagers'
        ],
        22 => [
          0 => 'app',
          1 => 'config'
        ],
        23 => [
          0 => 'app',
          1 => 'rebuild'
        ],
        24 => [
          0 => 'app',
          1 => 'smsProviders',
          2 => '__ANY__',
          3 => 'senderClassName'
        ],
        25 => [
          0 => 'app',
          1 => 'orm'
        ],
        26 => [
          0 => 'app',
          1 => 'relationships'
        ],
        27 => [
          0 => 'app',
          1 => 'linkManager'
        ],
        28 => [
          0 => 'app',
          1 => 'hook'
        ],
        29 => [
          0 => 'app',
          1 => 'api'
        ],
        30 => [
          0 => 'app',
          1 => 'databasePlatforms'
        ],
        31 => [
          0 => 'app',
          1 => 'recordId'
        ],
        32 => [
          0 => 'app',
          1 => 'currencyConversion'
        ],
        33 => [
          0 => 'selectDefs'
        ],
        34 => [
          0 => 'pdfDefs'
        ],
        35 => [
          0 => 'notificationDefs',
          1 => '__ANY__',
          2 => 'assignmentNotificatorClassName'
        ],
        36 => [
          0 => 'authenticationMethods',
          1 => '__ANY__',
          2 => 'implementationClassName'
        ],
        37 => [
          0 => 'aclDefs',
          1 => '__ANY__',
          2 => 'accessCheckerClassName'
        ],
        38 => [
          0 => 'aclDefs',
          1 => '__ANY__',
          2 => 'portalAccessCheckerClassName'
        ],
        39 => [
          0 => 'aclDefs',
          1 => '__ANY__',
          2 => 'ownershipCheckerClassName'
        ],
        40 => [
          0 => 'aclDefs',
          1 => '__ANY__',
          2 => 'portalOwnershipCheckerClassName'
        ],
        41 => [
          0 => 'aclDefs',
          1 => '__ANY__',
          2 => 'assignmentCheckerClassName'
        ],
        42 => [
          0 => 'aclDefs',
          1 => '__ANY__',
          2 => 'linkCheckerClassNameMap'
        ],
        43 => [
          0 => 'app',
          1 => 'calendar',
          2 => 'additionalAttributeList'
        ]
      ],
      'frontendNonAdminHiddenPathList' => [
        0 => [
          0 => 'recordDefs'
        ]
      ],
      'additionalBuilderClassNameList' => [
        0 => 'Espo\\Core\\Utils\\Metadata\\AdditionalBuilder\\Fields',
        1 => 'Espo\\Core\\Utils\\Metadata\\AdditionalBuilder\\FilterFields',
        2 => 'Espo\\Core\\Utils\\Metadata\\AdditionalBuilder\\DeleteIdField',
        3 => 'Espo\\Core\\Utils\\Metadata\\AdditionalBuilder\\StreamUpdatedAtField'
      ],
      'aclDependencies' => []
    ],
    'orm' => [
      'platforms' => [
        'Mysql' => [
          'queryComposerClassName' => 'Espo\\ORM\\QueryComposer\\MysqlQueryComposer',
          'pdoFactoryClassName' => 'Espo\\ORM\\PDO\\MysqlPDOFactory',
          'functionConverterClassNameMap' => [
            'ABS' => 'Espo\\Core\\ORM\\QueryComposer\\Part\\FunctionConverters\\Abs'
          ]
        ],
        'Postgresql' => [
          'queryComposerClassName' => 'Espo\\ORM\\QueryComposer\\PostgresqlQueryComposer',
          'pdoFactoryClassName' => 'Espo\\ORM\\PDO\\PostgresqlPDOFactory',
          'functionConverterClassNameMap' => [
            'ABS' => 'Espo\\Core\\ORM\\QueryComposer\\Part\\FunctionConverters\\Abs'
          ]
        ]
      ]
    ],
    'pdfEngines' => [
      'Dompdf' => [
        'implementationClassNameMap' => [
          'entity' => 'Espo\\Tools\\Pdf\\Dompdf\\EntityPrinter'
        ],
        'fontFaceList' => [
          0 => 'Courier',
          1 => 'Helvetica',
          2 => 'Times',
          3 => 'Symbol',
          4 => 'ZapfDingbats',
          5 => 'DejaVu Sans',
          6 => 'DejaVu Serif',
          7 => 'DejaVu Sans Mono'
        ]
      ]
    ],
    'portalContainerServices' => [
      'layoutProvider' => [
        'className' => 'Espo\\Tools\\Layout\\PortalLayoutProvider'
      ],
      'themeManager' => [
        'className' => 'Espo\\Core\\Portal\\Utils\\ThemeManager'
      ]
    ],
    'reactions' => [
      'list' => [
        0 => [
          'type' => 'Smile',
          'iconClass' => 'far fa-face-smile'
        ],
        1 => [
          'type' => 'Surprise',
          'iconClass' => 'far fa-face-surprise'
        ],
        2 => [
          'type' => 'Laugh',
          'iconClass' => 'far fa-face-laugh'
        ],
        3 => [
          'type' => 'Meh',
          'iconClass' => 'far fa-face-meh'
        ],
        4 => [
          'type' => 'Sad',
          'iconClass' => 'far fa-face-frown'
        ],
        5 => [
          'type' => 'Love',
          'iconClass' => 'far fa-heart'
        ],
        6 => [
          'type' => 'Like',
          'iconClass' => 'far fa-thumbs-up'
        ],
        7 => [
          'type' => 'Dislike',
          'iconClass' => 'far fa-thumbs-down'
        ]
      ]
    ],
    'rebuild' => [
      'actionClassNameList' => [
        0 => 'Espo\\Core\\Rebuild\\Actions\\AddSystemUser',
        1 => 'Espo\\Core\\Rebuild\\Actions\\AddSystemData',
        2 => 'Espo\\Core\\Rebuild\\Actions\\CurrencyRates',
        3 => 'Espo\\Core\\Rebuild\\Actions\\ScheduledJobs',
        4 => 'Espo\\Core\\Rebuild\\Actions\\ConfigMetadataCheck',
        5 => 'Espo\\Core\\Rebuild\\Actions\\GenerateInstanceId'
      ]
    ],
    'record' => [
      'selectApplierClassNameList' => [
        0 => 'Espo\\Core\\Select\\Applier\\AdditionalAppliers\\IsStarred'
      ]
    ],
    'recordId' => [
      'length' => 24
    ],
    'regExpPatterns' => [
      'noBadCharacters' => [
        'pattern' => '[^<>=]+'
      ],
      'noAsciiSpecialCharacters' => [
        'pattern' => '[^`~!@#$%^&*()_+={}\\[\\]|\\\\:;"\'<,>.?]+'
      ],
      'latinLetters' => [
        'pattern' => '[A-Za-z]+'
      ],
      'latinLettersDigits' => [
        'pattern' => '[A-Za-z0-9]+'
      ],
      'latinLettersDigitsWhitespace' => [
        'pattern' => '[A-Za-z0-9 ]+'
      ],
      'latinLettersWhitespace' => [
        'pattern' => '[A-Za-z ]+'
      ],
      'digits' => [
        'pattern' => '[0-9]+'
      ],
      'id' => [
        'pattern' => '[A-Za-z0-9_=\\-\\.]+',
        'isSystem' => true
      ],
      'phoneNumberLoose' => [
        'pattern' => '[0-9A-Za-z_@:#\\+\\(\\)\\-\\. ]+',
        'isSystem' => true
      ],
      'uriOptionalProtocol' => [
        'pattern' => '([a-zA-Z0-9]+\\:\\/\\/)?[a-zA-Z0-9%\\.\\/\\?\\:@\\-_=#$!+*\\(\\)\',]+\\.([a-zA-Z0-9%\\&\\.\\/\\?\\:@\\-_=#$!+*\\(\\)\',~])*',
        'isSystem' => true
      ],
      'uri' => [
        'pattern' => '([a-zA-Z0-9]+\\:\\/\\/){1}[a-zA-Z0-9%\\.\\/\\?\\:@\\-_=#$!+*\\(\\)\',]+\\.([a-zA-Z0-9%\\&\\.\\/\\?\\:@\\-_=#$!+*\\(\\)\',~])*',
        'isSystem' => true
      ]
    ],
    'relationships' => [
      'attachments' => [
        'converterClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\LinkConverters\\Attachments'
      ],
      'emailEmailAddress' => [
        'converterClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\LinkConverters\\EmailEmailAddress'
      ],
      'entityTeam' => [
        'converterClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\LinkConverters\\EntityTeam'
      ],
      'entityUser' => [
        'converterClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\LinkConverters\\EntityUser'
      ],
      'entityCollaborator' => [
        'converterClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\LinkConverters\\EntityCollaborator'
      ],
      'smsPhoneNumber' => [
        'converterClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\LinkConverters\\SmsPhoneNumber'
      ]
    ],
    'scheduledJobs' => [
      'ProcessJobGroup' => [
        'name' => 'Process Job Group',
        'isSystem' => true,
        'scheduling' => '* * * * *',
        'jobClassName' => 'Espo\\Core\\Job\\Job\\Jobs\\ProcessJobGroup',
        'preparatorClassName' => 'Espo\\Core\\Job\\Preparator\\Preparators\\ProcessJobGroupPreparator'
      ],
      'ProcessJobQueueQ0' => [
        'name' => 'Process Job Queue q0',
        'isSystem' => true,
        'scheduling' => '* * * * *',
        'jobClassName' => 'Espo\\Core\\Job\\Job\\Jobs\\ProcessJobQueueQ0'
      ],
      'ProcessJobQueueQ1' => [
        'name' => 'Process Job Queue q1',
        'isSystem' => true,
        'scheduling' => '*/1 * * * *',
        'jobClassName' => 'Espo\\Core\\Job\\Job\\Jobs\\ProcessJobQueueQ1'
      ],
      'ProcessJobQueueE0' => [
        'name' => 'Process Job Queue e0',
        'isSystem' => true,
        'scheduling' => '* * * * *',
        'jobClassName' => 'Espo\\Core\\Job\\Job\\Jobs\\ProcessJobQueueE0'
      ],
      'Dummy' => [
        'isSystem' => true,
        'scheduling' => '1 */12 * * *',
        'jobClassName' => 'Espo\\Classes\\Jobs\\Dummy'
      ],
      'CheckNewVersion' => [
        'name' => 'Check for New Version',
        'isSystem' => true,
        'scheduling' => '15 5 * * *',
        'jobClassName' => 'Espo\\Classes\\Jobs\\CheckNewVersion'
      ],
      'CheckNewExtensionVersion' => [
        'name' => 'Check for New Versions of Installed Extensions',
        'isSystem' => true,
        'scheduling' => '25 5 * * *',
        'jobClassName' => 'Espo\\Classes\\Jobs\\CheckNewExtensionVersion'
      ],
      'Cleanup' => [
        'jobClassName' => 'Espo\\Classes\\Jobs\\Cleanup'
      ],
      'AuthTokenControl' => [
        'jobClassName' => 'Espo\\Classes\\Jobs\\AuthTokenControl'
      ],
      'SendEmailNotifications' => [
        'jobClassName' => 'Espo\\Classes\\Jobs\\SendEmailNotifications'
      ],
      'ProcessWebhookQueue' => [
        'jobClassName' => 'Espo\\Classes\\Jobs\\ProcessWebhookQueue'
      ],
      'CheckEmailAccounts' => [
        'preparatorClassName' => 'Espo\\Classes\\JobPreparators\\CheckEmailAccounts',
        'jobClassName' => 'Espo\\Classes\\Jobs\\CheckEmailAccounts'
      ],
      'CheckInboundEmails' => [
        'preparatorClassName' => 'Espo\\Classes\\JobPreparators\\CheckInboundEmails',
        'jobClassName' => 'Espo\\Classes\\Jobs\\CheckInboundEmails'
      ],
      'SendScheduledEmails' => [
        'jobClassName' => 'Espo\\Classes\\Jobs\\SendScheduledEmails'
      ],
      'AdvancedPack' => [
        'isSystem' => true,
        'scheduling' => '3 3 * * *',
        'jobClassName' => 'Espo\\Modules\\Advanced\\Core\\App\\Job'
      ],
      'SalesJob' => [
        'isSystem' => true,
        'scheduling' => '3 5 * * *',
        'jobClassName' => 'Espo\\Modules\\Sales\\Classes\\App\\Job'
      ],
      'InventoryCompress' => [
        'scheduling' => '10 0 * * 6',
        'jobClassName' => 'Espo\\Modules\\Sales\\Classes\\Jobs\\InventoryCompress'
      ],
      'NotActualOrderLocking' => [
        'scheduling' => '10 1 * * 6',
        'jobClassName' => 'Espo\\Modules\\Sales\\Classes\\Jobs\\NotActualOrderLocking'
      ],
      'InventoryDetach' => [
        'scheduling' => '10 2 * * 6',
        'jobClassName' => 'Espo\\Modules\\Sales\\Classes\\Jobs\\InventoryDetach'
      ]
    ],
    'select' => [
      'whereItemConverterClassNameMap' => [
        'inCategory' => 'Espo\\Core\\Select\\Where\\ItemConverters\\InCategory',
        'isUserFromTeams' => 'Espo\\Core\\Select\\Where\\ItemConverters\\IsUserFromTeams'
      ]
    ],
    'smsProviders' => [],
    'templateHelpers' => [
      'googleMapsImage' => 'Espo\\Classes\\TemplateHelpers\\GoogleMaps',
      'markdownText' => 'Espo\\Classes\\TemplateHelpers\\MarkdownText',
      'tableTag' => 'Espo\\Classes\\TemplateHelpers\\TableTag',
      'trTag' => 'Espo\\Classes\\TemplateHelpers\\TrTag',
      'tdTag' => 'Espo\\Classes\\TemplateHelpers\\TdTag',
      'reportTable' => 'Espo\\Modules\\Advanced\\Core\\TemplateHelpers\\Report'
    ],
    'templates' => [
      'accessInfo' => [
        'scope' => 'User'
      ],
      'accessInfoPortal' => [
        'scope' => 'User'
      ],
      'assignment' => [
        'scopeListConfigParam' => 'assignmentEmailNotificationsEntityList'
      ],
      'mention' => [
        'scope' => 'Note'
      ],
      'noteEmailReceived' => [
        'scope' => 'Note'
      ],
      'notePost' => [
        'scope' => 'Note'
      ],
      'notePostNoParent' => [
        'scope' => 'Note'
      ],
      'noteStatus' => [
        'scope' => 'Note'
      ],
      'passwordChangeLink' => [
        'scope' => 'User'
      ],
      'twoFactorCode' => [
        'scope' => 'User'
      ],
      'invitation' => [
        'scopeList' => [
          0 => 'Meeting',
          1 => 'Call'
        ],
        'module' => 'Crm'
      ],
      'cancellation' => [
        'scopeList' => [
          0 => 'Meeting',
          1 => 'Call'
        ],
        'module' => 'Crm'
      ],
      'reminder' => [
        'scopeList' => [
          0 => 'Meeting',
          1 => 'Call',
          2 => 'Task'
        ],
        'module' => 'Crm'
      ],
      'reportSendingGrid1' => [
        'scope' => 'Report',
        'module' => 'Advanced'
      ],
      'reportSendingGrid2' => [
        'scope' => 'Report',
        'module' => 'Advanced'
      ],
      'reportSendingList' => [
        'scope' => 'Report',
        'module' => 'Advanced'
      ],
      'salesEmailPdf' => [
        'scopeList' => [
          0 => 'Quote',
          1 => 'SalesOrder',
          2 => 'Invoice',
          3 => 'PurchaseOrder',
          4 => 'DeliveryOrder',
          5 => 'ReceiptOrder',
          6 => 'TransferOrder',
          7 => 'ReturnOrder'
        ],
        'module' => 'Sales'
      ]
    ],
    'webSocket' => [
      'categories' => [
        'newNotification' => [],
        'recordUpdate' => [
          'paramList' => [
            0 => 'scope',
            1 => 'id'
          ],
          'accessCheckCommand' => 'AclCheck --userId=:userId --scope=:scope --id=:id --action=read'
        ],
        'streamUpdate' => [
          'paramList' => [
            0 => 'scope',
            1 => 'id'
          ],
          'accessCheckCommand' => 'AclCheck --userId=:userId --scope=:scope --id=:id --action=stream'
        ],
        'popupNotifications.event' => [],
        'inventoryQuantityUpdate' => [
          'accessCheckCommand' => 'InventoryAclCheck --userId=:userId'
        ]
      ],
      'messagers' => [
        'ZeroMQ' => [
          'senderClassName' => 'Espo\\Core\\WebSocket\\ZeroMQSender',
          'subscriberClassName' => 'Espo\\Core\\WebSocket\\ZeroMQSubscriber'
        ]
      ]
    ],
    'calendar' => [
      'additionalAttributeList' => [
        0 => 'color'
      ]
    ],
    'popupNotifications' => [
      'event' => [
        'grouped' => true,
        'providerClassName' => 'Espo\\Modules\\Crm\\Tools\\Activities\\PopupNotificationsProvider',
        'useWebSocket' => true,
        'portalDisabled' => true,
        'view' => 'crm:views/meeting/popup-notification'
      ]
    ],
    'workflow' => [
      'serviceActions' => [
        'Meeting' => [
          'sendEventInvitations' => [
            'className' => 'Espo\\Modules\\Advanced\\Classes\\ServiceActions\\Meeting\\SendInvitations'
          ]
        ],
        'Call' => [
          'sendEventInvitations' => [
            'className' => 'Espo\\Modules\\Advanced\\Classes\\ServiceActions\\Meeting\\SendInvitations'
          ]
        ],
        'Contact' => [
          'optOut' => [
            'className' => 'Espo\\Modules\\Advanced\\Classes\\ServiceActions\\Person\\OptOut'
          ]
        ],
        'Lead' => [
          'optOut' => [
            'className' => 'Espo\\Modules\\Advanced\\Classes\\ServiceActions\\Person\\OptOut'
          ]
        ],
        'Account' => [
          'optOut' => [
            'className' => 'Espo\\Modules\\Advanced\\Classes\\ServiceActions\\Person\\OptOut'
          ]
        ],
        'User' => [
          'generateAndSendPassword' => [
            'className' => 'Espo\\Modules\\Advanced\\Classes\\ServiceActions\\User\\GenerateAndSendPassword'
          ]
        ],
        'Quote' => [
          'addQuoteItemList' => [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\AddItemList'
          ],
          'convertCurrency' => [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\ConvertCurrency'
          ],
          'sendInEmail' => [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\SendInEmail'
          ]
        ],
        'Invoice' => [
          'addInvoiceItemList' => [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\AddItemList'
          ],
          'convertCurrency' => [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\ConvertCurrency'
          ],
          'sendInEmail' => [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\SendInEmail'
          ]
        ],
        'SalesOrder' => [
          'addSalesOrderItemList' => [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\AddItemList'
          ],
          'convertCurrency' => [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\ConvertCurrency'
          ],
          'sendInEmail' => [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\SendInEmail'
          ]
        ],
        'Opportunity' => [
          'convertCurrency' => [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\ConvertCurrency'
          ]
        ]
      ]
    ],
    'eInvoice' => [
      'formatList' => [
        0 => 'Peppol',
        1 => 'XRechnung',
        2 => 'CiusAtGov',
        3 => 'CiusAtNat',
        4 => 'CiusEsFace',
        5 => 'CiusIt',
        6 => 'CiusRo',
        7 => 'Nlcius'
      ],
      'easCodeList' => [
        0 => '0002',
        1 => '0007',
        2 => '0009',
        3 => '0037',
        4 => '0060',
        5 => '0088',
        6 => '0096',
        7 => '0097',
        8 => '0106',
        9 => '0130',
        10 => '0135',
        11 => '0142',
        12 => '0147',
        13 => '0151',
        14 => '0170',
        15 => '0183',
        16 => '0184',
        17 => '0188',
        18 => '0190',
        19 => '0191',
        20 => '0192',
        21 => '0193',
        22 => '0194',
        23 => '0195',
        24 => '0196',
        25 => '0198',
        26 => '0199',
        27 => '0200',
        28 => '0201',
        29 => '0202',
        30 => '0203',
        31 => '0204',
        32 => '0205',
        33 => '0208',
        34 => '0209',
        35 => '0210',
        36 => '0211',
        37 => '0212',
        38 => '0213',
        39 => '0215',
        40 => '0216',
        41 => '0217',
        42 => '0218',
        43 => '0221',
        44 => '0225',
        45 => '0230',
        46 => '9901',
        47 => '9910',
        48 => '9913',
        49 => '9914',
        50 => '9915',
        51 => '9918',
        52 => '9919',
        53 => '9920',
        54 => '9922',
        55 => '9923',
        56 => '9924',
        57 => '9925',
        58 => '9926',
        59 => '9927',
        60 => '9928',
        61 => '9929',
        62 => '9930',
        63 => '9931',
        64 => '9932',
        65 => '9933',
        66 => '9934',
        67 => '9935',
        68 => '9936',
        69 => '9937',
        70 => '9938',
        71 => '9939',
        72 => '9940',
        73 => '9941',
        74 => '9942',
        75 => '9943',
        76 => '9944',
        77 => '9945',
        78 => '9946',
        79 => '9947',
        80 => '9948',
        81 => '9949',
        82 => '9950',
        83 => '9951',
        84 => '9952',
        85 => '9953',
        86 => '9957',
        87 => '9959',
        88 => 'AN',
        89 => 'AQ',
        90 => 'AS',
        91 => 'AU',
        92 => 'EM'
      ],
      'easNames' => [
        9901 => 'Danish Ministry of the Interior and Health',
        9910 => 'Hungary VAT number',
        9913 => 'Business Registers Network',
        9914 => 'Österreichische Umsatzsteuer-Identifikationsnummer',
        9915 => 'Österreichisches Verwaltungs bzw. Organisationskennzeichen',
        9918 => 'SOCIETY FOR WORLDWIDE INTERBANK FINANCIAL, TELECOMMUNICATION S.W.I.F.T',
        9919 => 'Kennziffer des Unternehmensregisters',
        9920 => 'Agencia Española de Administración Tributaria',
        9922 => 'Andorra VAT number',
        9923 => 'Albania VAT number',
        9924 => 'Bosnia and Herzegovina VAT number',
        9925 => 'Belgium VAT number',
        9926 => 'Bulgaria VAT number',
        9927 => 'Switzerland VAT number',
        9928 => 'Cyprus VAT number',
        9929 => 'Czech Republic VAT number',
        9930 => 'Germany VAT number',
        9931 => 'Estonia VAT number',
        9932 => 'United Kingdom VAT number',
        9933 => 'Greece VAT number',
        9934 => 'Croatia VAT number',
        9935 => 'Ireland VAT number',
        9936 => 'Liechtenstein VAT number',
        9937 => 'Lithuania VAT number',
        9938 => 'Luxemburg VAT number',
        9939 => 'Latvia VAT number',
        9940 => 'Monaco VAT number',
        9941 => 'Montenegro VAT number',
        9942 => 'Macedonia, the former Yugoslav Republic of VAT number',
        9943 => 'Malta VAT number',
        9944 => 'Netherlands VAT number',
        9945 => 'Poland VAT number',
        9946 => 'Portugal VAT number',
        9947 => 'Romania VAT number',
        9948 => 'Serbia VAT number',
        9949 => 'Slovenia VAT number',
        9950 => 'Slovakia VAT number',
        9951 => 'San Marino VAT number',
        9952 => 'Turkey VAT number',
        9953 => 'Holy See (Vatican City State) VAT number',
        9957 => 'French VAT number',
        9959 => 'Employer Identification Number (EIN, USA)',
        '0002' => 'System Information et Repertoire des Entreprise et des Etablissements: SIRENE',
        '0007' => 'Organisationsnummer (Swedish legal entities)',
        '0009' => 'SIRET-CODE',
        '0037' => 'LY-tunnus',
        '0060' => 'Data Universal Numbering System (D-U-N-S Number)',
        '0088' => 'EAN Location Code',
        '0096' => 'DANISH CHAMBER OF COMMERCE Scheme (EDIRA compliant)',
        '0097' => 'FTI - Ediforum Italia, (EDIRA compliant)',
        '0106' => 'Vereniging van Kamers van Koophandel en Fabrieken in Nederland (Association of Chambers of Commerce and Industry in the Netherlands), Scheme (EDIRA compliant)',
        '0130' => 'Directorates of the European Commission',
        '0135' => 'SIA Object Identifiers',
        '0142' => 'SECETI Object Identifiers',
        '0147' => 'Standard Company Code',
        '0151' => 'Australian Business Number (ABN) Scheme',
        '0170' => 'Teikoku Company Code',
        '0183' => 'Numéro d\'identification suisse des enterprises (IDE), Swiss Unique Business Identification Number (UIDB)',
        '0184' => 'DIGSTORG',
        '0188' => 'Corporate Number of The Social Security and Tax Number System',
        '0190' => 'Dutch Originator\'s Identification Number',
        '0191' => 'Centre of Registers and Information Systems of the Ministry of Justice',
        '0192' => 'Enhetsregisteret ved Bronnoysundregisterne',
        '0193' => 'UBL.BE party identifier',
        '0194' => 'KOIOS Open Technical Dictionary',
        '0195' => 'Singapore UEN identifier',
        '0196' => 'Kennitala - Iceland legal id for individuals and legal entities',
        '0198' => 'ERSTORG',
        '0199' => 'Legal Entity Identifier (LEI)',
        '0200' => 'Legal entity code (Lithuania)',
        '0201' => 'Codice Univoco Unità Organizzativa iPA',
        '0202' => 'Indirizzo di Posta Elettronica Certificata',
        '0203' => 'eDelivery Network Participant identifier',
        '0204' => 'Leitweg-ID',
        '0205' => 'CODDEST',
        '0208' => 'Numero d\'entreprise / ondernemingsnummer / Unternehmensnummer',
        '0209' => 'GS1 identification keys',
        '0210' => 'CODICE FISCALE',
        '0211' => 'PARTITA IVA',
        '0212' => 'Finnish Organization Identifier',
        '0213' => 'Finnish Organization Value Add Tax Identifier',
        '0215' => 'Net service ID',
        '0216' => 'OVTcode',
        '0217' => 'The Netherlands Chamber of Commerce and Industry establishment number',
        '0218' => 'Unified registration number (Latvia)',
        '0221' => 'The registered number of the qualified invoice issuer',
        '0225' => 'FRCTC ELECTRONIC ADDRESS',
        '0230' => 'National e-Invoicing Framework',
        'AN' => 'O.F.T.P. (ODETTE File Transfer Protocol)',
        'AQ' => 'X.400 address for mail text',
        'AS' => 'AS2 exchange',
        'AU' => 'File Transfer Protocol',
        'EM' => 'Electronic mail'
      ]
    ],
    'customCSS' => [
      0 => 'font-style',
      1 => 'font-weight',
      2 => 'font-size',
      3 => 'font-family',
      4 => 'text-align',
      5 => 'letter spacing',
      6 => 'Text-outline',
      7 => 'word-wrap',
      8 => 'direction',
      9 => 'text-wrap',
      10 => 'text-indent',
      11 => 'word-spacing',
      12 => 'text-transform',
      13 => 'text-emphasis',
      14 => 'text-justify',
      15 => 'nav-up',
      16 => 'nav-down',
      17 => 'nav-left',
      18 => 'nav-right',
      19 => 'resize',
      20 => 'icon',
      21 => 'background-size',
      22 => 'background-image',
      23 => 'background-repeat',
      24 => 'background-attachment',
      25 => 'background-color',
      26 => 'background-position',
      27 => 'background-origin',
      28 => 'background-clip',
      29 => 'border-width',
      30 => 'border-style',
      31 => 'border-color',
      32 => 'border-left',
      33 => 'border-left-color',
      34 => 'border-left-width',
      35 => 'border-right',
      36 => 'border-right-color',
      37 => 'border-right-width',
      38 => 'border-top',
      39 => 'border-top-width',
      40 => 'border-top-color',
      41 => 'border-bottom',
      42 => 'border-bottom-color',
      43 => 'border-bottom-width',
      44 => 'border-decoration-break',
      45 => 'border-radius',
      46 => 'border-top-right-radius',
      47 => 'border-bottom-right-radius',
      48 => 'border-bottom-left-radius',
      49 => 'border-top-left-radius',
      50 => 'border-image',
      51 => 'float',
      52 => 'height',
      53 => 'max-height',
      54 => 'max-width',
      55 => 'min-height',
      56 => 'min-width',
      57 => 'margin-bottom',
      58 => 'margin',
      59 => 'margin-left',
      60 => 'margin-right',
      61 => 'margin-top',
      62 => 'padding-bottom',
      63 => 'padding-top',
      64 => 'padding-right',
      65 => 'padding-left',
      66 => 'display',
      67 => 'marquee-direction',
      68 => 'marquee-loop',
      69 => 'marquee-play-count',
      70 => 'marquee-speed',
      71 => 'marquee-style',
      72 => 'overflow',
      73 => 'overflow-style',
      74 => 'overflow-x',
      75 => 'rotation',
      76 => 'rotation-point',
      77 => 'visibility',
      78 => 'clear',
      79 => 'box-align',
      80 => 'box-direction',
      81 => 'box-flex',
      82 => 'box-flex-group',
      83 => 'box-lines',
      84 => 'box-orient',
      85 => 'box-pack',
      86 => 'box-sizing',
      87 => 'tab-side',
      88 => 'border-collapse',
      89 => 'empty-cells',
      90 => 'border-spacing',
      91 => 'table-layout',
      92 => 'caption-side',
      93 => 'column-count',
      94 => 'column-fill',
      95 => 'column-gap',
      96 => 'column-rule-width',
      97 => 'column-rule-style',
      98 => 'column-rule-color',
      99 => 'column-width',
      100 => 'column-span',
      101 => 'color',
      102 => 'opacity',
      103 => 'grid-columns',
      104 => 'grid-rows',
      105 => 'list-style-type',
      106 => 'list-style-position',
      107 => 'list-style-position',
      108 => 'list-style-image',
      109 => 'marker-offset',
      110 => 'animation-name',
      111 => 'animation-duration',
      112 => 'animation-timing-function',
      113 => 'animation-delay',
      114 => 'animation-iteration-count',
      115 => 'animation-direction',
      116 => 'animation-play-state',
      117 => 'animation-fill-mode',
      118 => 'outline-color',
      119 => 'outline-style',
      120 => 'outline-width',
      121 => 'outline-offset',
      122 => 'target-name',
      123 => 'target-new',
      124 => 'target-position',
      125 => 'fit',
      126 => 'fit-position',
      127 => 'orphans',
      128 => 'image-orientation',
      129 => 'page',
      130 => 'page-break-after',
      131 => 'page-break-before',
      132 => 'page-break-inside',
      133 => 'size',
      134 => 'windows',
      135 => 'bottom',
      136 => 'right',
      137 => 'top',
      138 => 'left',
      139 => 'z-index',
      140 => 'clip',
      141 => 'position',
      142 => 'transitions-delay',
      143 => 'transitions-duration',
      144 => 'transitions-property',
      145 => 'transition-timing-function',
      146 => 'backface-visibility',
      147 => 'perspective',
      148 => 'perspective-origin',
      149 => 'transform',
      150 => 'transform-origin',
      151 => 'transform-style',
      152 => 'cue-before – play a sound file before an element',
      153 => 'cue-after - play a sound file after an element',
      154 => 'pause',
      155 => 'pause-before',
      156 => 'pause-after',
      157 => 'voice-stress',
      158 => 'voice-pitch',
      159 => 'voice-duration',
      160 => 'voice-volume',
      161 => 'voice-family',
      162 => 'voice-rate',
      163 => 'speak',
      164 => 'caption-side – position for table caption',
      165 => 'rest-before',
      166 => 'rest-after',
      167 => 'alignment-adjust',
      168 => 'alignment-baseline',
      169 => 'drop-initial-after-align',
      170 => 'drop-initial-before-align',
      171 => 'drop-initial-before-adjust',
      172 => 'drop-initial-value',
      173 => 'drop-initial-size',
      174 => 'baseline-shift',
      175 => 'dominant-baseline',
      176 => 'line-stacking-shift',
      177 => 'line-stacking-strategy',
      178 => 'inline-box-align',
      179 => 'line-height',
      180 => 'text-height',
      181 => 'vertical-align',
      182 => 'left',
      183 => 'center',
      184 => 'top',
      185 => 'justify',
      186 => 'right',
      187 => 'normal',
      188 => 'none',
      189 => 'length',
      190 => 'color',
      191 => 'auto',
      192 => 'px',
      193 => 'distribute',
      194 => 'inter-word',
      195 => 'fixed',
      196 => 'scroll',
      197 => 'start',
      198 => 'end',
      199 => 'padding',
      200 => 'aliceblue',
      201 => 'black',
      202 => 'silver',
      203 => 'gray',
      204 => 'white',
      205 => 'maroon',
      206 => 'red',
      207 => 'purple',
      208 => 'fuchsia',
      209 => 'green',
      210 => 'lime',
      211 => 'olive',
      212 => 'yellow',
      213 => 'navy',
      214 => 'blue',
      215 => 'teal',
      216 => 'aqua',
      217 => 'aliceblue',
      218 => 'antiquewhite',
      219 => 'aquamarine',
      220 => 'azure',
      221 => 'beige',
      222 => 'bisque',
      223 => 'blanchedalmond',
      224 => 'blueviolet',
      225 => 'brown',
      226 => 'burlywood',
      227 => 'cadetblue',
      228 => 'chartreuse',
      229 => 'chocolate',
      230 => 'coral',
      231 => 'cornflowerblue',
      232 => 'cornsilk',
      233 => 'crimson',
      234 => 'cyan',
      235 => 'darkblue',
      236 => 'darkcyan',
      237 => 'darkgoldenrod',
      238 => 'darkgray',
      239 => 'darkgreen',
      240 => 'darkgrey',
      241 => 'darkkhaki',
      242 => 'darkmagenta',
      243 => 'darkolivegreen',
      244 => 'darkorange',
      245 => 'darkorchid',
      246 => 'darkred',
      247 => 'darksalmon',
      248 => 'darkseagreen',
      249 => 'darkslateblue',
      250 => 'darkslategray',
      251 => 'darkslategrey',
      252 => 'darkturquoise',
      253 => 'darkviolet',
      254 => 'deeppink',
      255 => 'deepskyblue',
      256 => 'dimgray',
      257 => 'dimgrey',
      258 => 'dodgerblue',
      259 => 'firebrick',
      260 => 'floralwhite',
      261 => 'forestgreen',
      262 => 'gainsboro',
      263 => 'ghostwhite',
      264 => 'gold',
      265 => 'goldenrod',
      266 => 'greenyellow',
      267 => 'grey',
      268 => 'honeydew',
      269 => 'hotpink',
      270 => 'indianred',
      271 => 'indigo',
      272 => 'ivory',
      273 => 'khaki',
      274 => 'lavender',
      275 => 'lavenderblush',
      276 => 'lawngreen',
      277 => 'lemonchiffon',
      278 => 'lightblue',
      279 => 'lightcoral',
      280 => 'lightcyan',
      281 => 'lightgoldenrodyellow',
      282 => 'lightgray',
      283 => 'lightgreen',
      284 => 'lightgrey',
      285 => 'lightpink',
      286 => 'lightsalmon',
      287 => 'lightseagreen',
      288 => 'lightskyblue',
      289 => 'lightslategray',
      290 => 'lightslategrey',
      291 => 'lightsteelblue',
      292 => 'lightyellow',
      293 => 'limegreen',
      294 => 'linen',
      295 => 'magenta',
      296 => 'mediumaquamarine',
      297 => 'mediumblue',
      298 => 'mediumorchid',
      299 => 'mediumpurple',
      300 => 'mediumseagreen',
      301 => 'mediumslateblue',
      302 => 'mediumspringgreen',
      303 => 'mediumturquoise',
      304 => 'mediumvioletred',
      305 => 'midnightblue',
      306 => 'mintcream',
      307 => 'mistyrose',
      308 => 'moccasin',
      309 => 'navajowhite',
      310 => 'oldlace',
      311 => 'olivedrab',
      312 => 'orangered',
      313 => 'orchid',
      314 => 'palegoldenrod',
      315 => 'palegreen',
      316 => 'paleturquoise',
      317 => 'palevioletred',
      318 => 'papayawhip',
      319 => 'peachpuff',
      320 => 'peru',
      321 => 'pink',
      322 => 'plum',
      323 => 'powderblue',
      324 => 'rosybrown',
      325 => 'royalblue',
      326 => 'saddlebrown',
      327 => 'salmon',
      328 => 'sandybrown',
      329 => 'seagreen',
      330 => 'seashell',
      331 => 'sienna',
      332 => 'skyblue',
      333 => 'slateblue',
      334 => 'slategray',
      335 => 'slategrey',
      336 => 'snow',
      337 => 'springgreen',
      338 => 'steelblue',
      339 => 'tan',
      340 => 'thistle',
      341 => 'tomato',
      342 => 'turquoise',
      343 => 'violet',
      344 => 'wheat',
      345 => 'whitesmoke',
      346 => 'yellowgreen'
    ]
  ],
  'authenticationMethods' => [
    'ApiKey' => [
      'api' => true,
      'credentialsHeader' => 'X-Api-Key'
    ],
    'Espo' => [
      'portalDefault' => true,
      'settings' => [
        'isAvailable' => true
      ]
    ],
    'Hmac' => [
      'api' => true,
      'credentialsHeader' => 'X-Hmac-Authorization'
    ],
    'LDAP' => [
      'implementationClassName' => 'Espo\\Core\\Authentication\\Ldap\\LdapLogin',
      'portalDefault' => true,
      'settings' => [
        'isAvailable' => true,
        'layout' => [
          'label' => 'LDAP',
          'rows' => [
            0 => [
              0 => [
                'name' => 'ldapHost'
              ],
              1 => [
                'name' => 'ldapPort'
              ]
            ],
            1 => [
              0 => [
                'name' => 'ldapAuth'
              ],
              1 => [
                'name' => 'ldapSecurity'
              ]
            ],
            2 => [
              0 => [
                'name' => 'ldapUsername',
                'fullWidth' => true
              ]
            ],
            3 => [
              0 => [
                'name' => 'ldapPassword'
              ],
              1 => [
                'name' => 'testConnection',
                'customLabel' => NULL,
                'view' => 'views/admin/authentication/fields/test-connection'
              ]
            ],
            4 => [
              0 => [
                'name' => 'ldapUserNameAttribute'
              ],
              1 => [
                'name' => 'ldapUserObjectClass'
              ]
            ],
            5 => [
              0 => [
                'name' => 'ldapAccountCanonicalForm'
              ],
              1 => [
                'name' => 'ldapBindRequiresDn'
              ]
            ],
            6 => [
              0 => [
                'name' => 'ldapBaseDn',
                'fullWidth' => true
              ]
            ],
            7 => [
              0 => [
                'name' => 'ldapUserLoginFilter',
                'fullWidth' => true
              ]
            ],
            8 => [
              0 => [
                'name' => 'ldapAccountDomainName'
              ],
              1 => [
                'name' => 'ldapAccountDomainNameShort'
              ]
            ],
            9 => [
              0 => [
                'name' => 'ldapTryUsernameSplit'
              ],
              1 => [
                'name' => 'ldapOptReferrals'
              ]
            ],
            10 => [
              0 => [
                'name' => 'ldapCreateEspoUser'
              ],
              1 => false
            ],
            11 => [
              0 => [
                'name' => 'ldapUserFirstNameAttribute'
              ],
              1 => [
                'name' => 'ldapUserLastNameAttribute'
              ]
            ],
            12 => [
              0 => [
                'name' => 'ldapUserTitleAttribute'
              ],
              1 => false
            ],
            13 => [
              0 => [
                'name' => 'ldapUserEmailAddressAttribute'
              ],
              1 => [
                'name' => 'ldapUserPhoneNumberAttribute'
              ]
            ],
            14 => [
              0 => [
                'name' => 'ldapUserTeams'
              ],
              1 => [
                'name' => 'ldapUserDefaultTeam'
              ]
            ],
            15 => [
              0 => [
                'name' => 'ldapPortalUserLdapAuth'
              ],
              1 => false
            ],
            16 => [
              0 => [
                'name' => 'ldapPortalUserPortals'
              ],
              1 => [
                'name' => 'ldapPortalUserRoles'
              ]
            ]
          ]
        ],
        'fieldList' => [
          0 => 'ldapHost',
          1 => 'ldapPort',
          2 => 'ldapAuth',
          3 => 'ldapSecurity',
          4 => 'ldapUsername',
          5 => 'ldapPassword',
          6 => 'ldapBindRequiresDn',
          7 => 'ldapUserLoginFilter',
          8 => 'ldapBaseDn',
          9 => 'ldapAccountCanonicalForm',
          10 => 'ldapAccountDomainName',
          11 => 'ldapAccountDomainNameShort',
          12 => 'ldapAccountDomainName',
          13 => 'ldapAccountDomainNameShort',
          14 => 'ldapTryUsernameSplit',
          15 => 'ldapOptReferrals',
          16 => 'ldapCreateEspoUser',
          17 => 'ldapPortalUserLdapAuth'
        ],
        'dynamicLogic' => [
          'fields' => [
            'ldapHost' => [
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'LDAP'
                  ]
                ]
              ]
            ],
            'ldapUserNameAttribute' => [
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'LDAP'
                  ]
                ]
              ]
            ],
            'ldapUserObjectClass' => [
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'LDAP'
                  ]
                ]
              ]
            ],
            'ldapUsername' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapAuth'
                  ]
                ]
              ],
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapAuth'
                  ]
                ]
              ]
            ],
            'ldapPassword' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapAuth'
                  ]
                ]
              ]
            ],
            'testConnection' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapAuth'
                  ]
                ]
              ]
            ],
            'ldapAccountDomainName' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'in',
                    'attribute' => 'ldapAccountCanonicalForm',
                    'value' => [
                      0 => 'Backslash',
                      1 => 'Principal'
                    ]
                  ]
                ]
              ]
            ],
            'ldapAccountDomainNameShort' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'in',
                    'attribute' => 'ldapAccountCanonicalForm',
                    'value' => [
                      0 => 'Backslash',
                      1 => 'Principal'
                    ]
                  ]
                ]
              ]
            ],
            'ldapUserTitleAttribute' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ],
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapUserFirstNameAttribute' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ],
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapUserLastNameAttribute' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ],
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapUserEmailAddressAttribute' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ],
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapUserPhoneNumberAttribute' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ],
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapUserTeams' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapUserDefaultTeam' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapPortalUserPortals' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapPortalUserLdapAuth'
                  ]
                ]
              ]
            ],
            'ldapPortalUserRoles' => [
              'visible' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'isTrue',
                    'attribute' => 'ldapPortalUserLdapAuth'
                  ]
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Oidc' => [
      'implementationClassName' => 'Espo\\Core\\Authentication\\Oidc\\Login',
      'logoutClassName' => 'Espo\\Core\\Authentication\\Oidc\\Logout',
      'login' => [
        'handler' => 'handlers/login/oidc',
        'fallbackConfigParam' => 'oidcFallback'
      ],
      'provider' => [
        'isAvailable' => true
      ],
      'settings' => [
        'isAvailable' => true,
        'layout' => [
          'label' => 'OIDC',
          'rows' => [
            0 => [
              0 => [
                'name' => 'oidcClientId'
              ],
              1 => [
                'name' => 'oidcClientSecret'
              ]
            ],
            1 => [
              0 => [
                'name' => 'oidcAuthorizationRedirectUri',
                'view' => 'views/settings/fields/oidc-redirect-uri',
                'params' => [
                  'readOnly' => true,
                  'copyToClipboard' => true
                ]
              ],
              1 => false
            ],
            2 => [
              0 => [
                'name' => 'oidcAuthorizationEndpoint'
              ],
              1 => [
                'name' => 'oidcTokenEndpoint'
              ]
            ],
            3 => [
              0 => [
                'name' => 'oidcJwksEndpoint'
              ],
              1 => [
                'name' => 'oidcJwtSignatureAlgorithmList'
              ]
            ],
            4 => [
              0 => [
                'name' => 'oidcScopes'
              ],
              1 => [
                'name' => 'oidcUsernameClaim'
              ]
            ],
            5 => [
              0 => [
                'name' => 'oidcCreateUser'
              ],
              1 => [
                'name' => 'oidcSync'
              ]
            ],
            6 => [
              0 => [
                'name' => 'oidcTeams'
              ],
              1 => [
                'name' => 'oidcGroupClaim'
              ]
            ],
            7 => [
              0 => [
                'name' => 'oidcSyncTeams'
              ],
              1 => false
            ],
            8 => [
              0 => [
                'name' => 'oidcFallback'
              ],
              1 => [
                'name' => 'oidcAllowRegularUserFallback'
              ]
            ],
            9 => [
              0 => [
                'name' => 'oidcAllowAdminUser'
              ],
              1 => [
                'name' => 'oidcLogoutUrl'
              ]
            ],
            10 => [
              0 => [
                'name' => 'oidcAuthorizationPrompt'
              ],
              1 => false
            ]
          ]
        ],
        'fieldList' => [
          0 => 'oidcClientId',
          1 => 'oidcClientSecret',
          2 => 'oidcAuthorizationEndpoint',
          3 => 'oidcTokenEndpoint',
          4 => 'oidcJwksEndpoint',
          5 => 'oidcJwtSignatureAlgorithmList',
          6 => 'oidcScopes',
          7 => 'oidcGroupClaim',
          8 => 'oidcCreateUser',
          9 => 'oidcUsernameClaim',
          10 => 'oidcTeams',
          11 => 'oidcSync',
          12 => 'oidcSyncTeams',
          13 => 'oidcAuthorizationRedirectUri',
          14 => 'oidcFallback',
          15 => 'oidcAllowRegularUserFallback',
          16 => 'oidcAllowAdminUser',
          17 => 'oidcLogoutUrl'
        ],
        'dynamicLogic' => [
          'fields' => [
            'oidcClientId' => [
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ]
                ]
              ]
            ],
            'oidcAuthorizationEndpoint' => [
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ]
                ]
              ]
            ],
            'oidcTokenEndpoint' => [
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ]
                ]
              ]
            ],
            'oidcUsernameClaim' => [
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ]
                ]
              ]
            ],
            'oidcJwtSignatureAlgorithmList' => [
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ]
                ]
              ]
            ],
            'oidcJwksEndpoint' => [
              'required' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ],
                  1 => [
                    'type' => 'or',
                    'value' => [
                      0 => [
                        'type' => 'contains',
                        'attribute' => 'oidcJwtSignatureAlgorithmList',
                        'value' => 'RS256'
                      ],
                      1 => [
                        'type' => 'contains',
                        'attribute' => 'oidcJwtSignatureAlgorithmList',
                        'value' => 'RS384'
                      ],
                      2 => [
                        'type' => 'contains',
                        'attribute' => 'oidcJwtSignatureAlgorithmList',
                        'value' => 'RS512'
                      ]
                    ]
                  ]
                ]
              ]
            ],
            'oidcAllowRegularUserFallback' => [
              'invalid' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ],
                  1 => [
                    'type' => 'isTrue',
                    'attribute' => 'oidcAllowRegularUserFallback'
                  ],
                  2 => [
                    'type' => 'isFalse',
                    'attribute' => 'oidcFallback'
                  ]
                ]
              ]
            ],
            'oidcAllowAdminUser' => [
              'invalid' => [
                'conditionGroup' => [
                  0 => [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ],
                  1 => [
                    'type' => 'isFalse',
                    'attribute' => 'oidcAllowAdminUser'
                  ],
                  2 => [
                    'type' => 'isFalse',
                    'attribute' => 'oidcFallback'
                  ]
                ]
              ]
            ]
          ]
        ]
      ]
    ]
  ],
  'clientDefs' => [
    'ActionHistoryRecord' => [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'recordViews' => [
        'list' => 'views/action-history-record/record/list'
      ],
      'modalViews' => [
        'detail' => 'views/action-history-record/modals/detail'
      ]
    ],
    'AddressCountry' => [
      'controller' => 'controllers/record',
      'duplicateDisabled' => true,
      'mergeDisabled' => true,
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'name' => 'populateDefaults',
              'labelTranslation' => 'AddressCountry.strings.populateDefaults',
              'handler' => 'handlers/admin/address-country/populate-defaults',
              'actionFunction' => 'populate'
            ]
          ]
        ]
      ]
    ],
    'AddressMap' => [
      'controller' => 'controllers/address-map'
    ],
    'ApiUser' => [
      'controller' => 'controllers/api-user',
      'views' => [
        'detail' => 'views/user/detail',
        'list' => 'views/api-user/list'
      ],
      'recordViews' => [
        'list' => 'views/user/record/list',
        'detail' => 'views/user/record/detail',
        'edit' => 'views/user/record/edit',
        'detailSmall' => 'views/user/record/detail-quick',
        'editSmall' => 'views/user/record/edit-quick'
      ],
      'defaultSidePanelFieldLists' => [
        'detail' => [
          0 => 'avatar',
          1 => 'createdAt',
          2 => 'lastAccess'
        ],
        'detailSmall' => [
          0 => 'avatar',
          1 => 'createdAt'
        ],
        'edit' => [
          0 => 'avatar'
        ],
        'editSmall' => [
          0 => 'avatar'
        ]
      ],
      'filterList' => [],
      'boolFilterList' => []
    ],
    'AppLogRecord' => [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'editDisabled' => true,
      'mergeDisabled' => true,
      'recordViews' => [
        'list' => 'views/admin/app-log-record/record/list'
      ],
      'filterList' => [
        0 => [
          'name' => 'errors'
        ]
      ]
    ],
    'AppSecret' => [
      'controller' => 'controllers/record',
      'mergeDisabled' => true,
      'exportDisabled' => true,
      'massUpdateDisabled' => true
    ],
    'Attachment' => [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'recordViews' => [
        'list' => 'views/attachment/record/list',
        'detail' => 'views/attachment/record/detail'
      ],
      'modalViews' => [
        'detail' => 'views/attachment/modals/detail'
      ],
      'filterList' => [
        0 => 'orphan'
      ]
    ],
    'AuthLogRecord' => [
      'controller' => 'controllers/record',
      'recordViews' => [
        'list' => 'views/admin/auth-log-record/record/list',
        'detail' => 'views/admin/auth-log-record/record/detail',
        'detailSmall' => 'views/admin/auth-log-record/record/detail-small'
      ],
      'modalViews' => [
        'detail' => 'views/admin/auth-log-record/modals/detail'
      ],
      'filterList' => [
        0 => 'accepted',
        1 => 'denied'
      ],
      'createDisabled' => true,
      'relationshipPanels' => [
        'actionHistoryRecords' => [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'rowActionsView' => 'views/record/row-actions/relationship-view-only'
        ]
      ]
    ],
    'AuthToken' => [
      'controller' => 'controllers/record',
      'recordViews' => [
        'list' => 'views/admin/auth-token/record/list',
        'detail' => 'views/admin/auth-token/record/detail',
        'detailSmall' => 'views/admin/auth-token/record/detail-small'
      ],
      'modalViews' => [
        'detail' => 'views/admin/auth-token/modals/detail'
      ],
      'filterList' => [
        0 => 'active',
        1 => 'inactive'
      ],
      'createDisabled' => true,
      'relationshipPanels' => [
        'actionHistoryRecords' => [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'rowActionsView' => 'views/record/row-actions/relationship-view-only'
        ]
      ]
    ],
    'AuthenticationProvider' => [
      'controller' => 'controllers/record',
      'recordViews' => [
        'detail' => 'views/authentication-provider/record/detail',
        'edit' => 'views/authentication-provider/record/edit'
      ],
      'searchPanelDisabled' => true,
      'inlineEditDisabled' => true,
      'duplicateDisabled' => true,
      'massUpdateDisabled' => true,
      'massRemoveDisabled' => true,
      'mergeDisabled' => true
    ],
    'Dashboard' => [
      'controller' => 'controllers/dashboard',
      'iconClass' => 'fas fa-th-large'
    ],
    'DashboardTemplate' => [
      'controller' => 'controllers/record',
      'views' => [
        'detail' => 'views/dashboard-template/detail'
      ],
      'recordViews' => [
        'list' => 'views/dashboard-template/record/list'
      ],
      'menu' => [
        'detail' => [
          'buttons' => [
            0 => [
              'action' => 'deployToUsers',
              'label' => 'Deploy to Users'
            ],
            1 => [
              'action' => 'deployToTeam',
              'label' => 'Deploy to Team'
            ]
          ]
        ]
      ],
      'searchPanelDisabled' => true
    ],
    'DynamicLogic' => [
      'itemTypes' => [
        'and' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/group-base',
          'operator' => 'and'
        ],
        'or' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/group-base',
          'operator' => 'or'
        ],
        'not' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/group-not',
          'operator' => 'not'
        ],
        'equals' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-base',
          'operatorString' => '='
        ],
        'notEquals' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-base',
          'operatorString' => '&ne;'
        ],
        'greaterThan' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-base',
          'operatorString' => '&gt;'
        ],
        'lessThan' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-base',
          'operatorString' => '&lt;'
        ],
        'greaterThanOrEquals' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-base',
          'operatorString' => '&ge;'
        ],
        'lessThanOrEquals' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-base',
          'operatorString' => '&le;'
        ],
        'isEmpty' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-operator-only-base',
          'operatorString' => '= &empty;'
        ],
        'isNotEmpty' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-operator-only-base',
          'operatorString' => '&ne; &empty;'
        ],
        'isTrue' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-operator-only-base',
          'operatorString' => '= 1'
        ],
        'isFalse' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-operator-only-base',
          'operatorString' => '= 0'
        ],
        'in' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-multiple-values-base',
          'operatorString' => '&isin;'
        ],
        'notIn' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-multiple-values-base',
          'operatorString' => '&notin;'
        ],
        'isToday' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-is-today',
          'operatorString' => '='
        ],
        'inFuture' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-in-future',
          'operatorString' => '&isin;'
        ],
        'inPast' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-in-past',
          'operatorString' => '&isin;'
        ],
        'contains' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-link',
          'operatorString' => '&niv;'
        ],
        'notContains' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-link',
          'operatorString' => '&notni;'
        ],
        'has' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-enum',
          'operatorString' => '&niv;'
        ],
        'notHas' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-enum',
          'operatorString' => '&notni;'
        ],
        'startsWith' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-varchar'
        ],
        'endsWith' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-varchar'
        ],
        'matches' => [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-varchar'
        ]
      ],
      'fieldTypes' => [
        'bool' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isTrue',
            1 => 'isFalse'
          ]
        ],
        'varchar' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'equals',
            1 => 'notEquals',
            2 => 'isEmpty',
            3 => 'isNotEmpty',
            4 => 'contains',
            5 => 'notContains',
            6 => 'startsWith',
            7 => 'endsWith',
            8 => 'matches'
          ],
          'conditionTypes' => [
            'contains' => [
              'valueType' => 'field',
              'itemView' => 'views/admin/dynamic-logic/conditions-string/item-base'
            ],
            'notContains' => [
              'valueType' => 'field',
              'itemView' => 'views/admin/dynamic-logic/conditions-string/item-base'
            ]
          ]
        ],
        'url' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'equals',
            1 => 'notEquals',
            2 => 'isEmpty',
            3 => 'isNotEmpty'
          ]
        ],
        'email' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty'
          ]
        ],
        'phone' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty'
          ]
        ],
        'text' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'contains',
            3 => 'notContains',
            4 => 'matches'
          ],
          'conditionTypes' => [
            'contains' => [
              'valueType' => 'varchar',
              'itemView' => 'views/admin/dynamic-logic/conditions-string/item-value-varchar'
            ],
            'notContains' => [
              'valueType' => 'varchar',
              'itemView' => 'views/admin/dynamic-logic/conditions-string/item-value-varchar'
            ]
          ]
        ],
        'int' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'equals',
            3 => 'notEquals',
            4 => 'greaterThan',
            5 => 'lessThan',
            6 => 'greaterThanOrEquals',
            7 => 'lessThanOrEquals'
          ]
        ],
        'float' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'equals',
            3 => 'notEquals',
            4 => 'greaterThan',
            5 => 'lessThan',
            6 => 'greaterThanOrEquals',
            7 => 'lessThanOrEquals'
          ]
        ],
        'currency' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'equals',
            3 => 'notEquals',
            4 => 'greaterThan',
            5 => 'lessThan',
            6 => 'greaterThanOrEquals',
            7 => 'lessThanOrEquals'
          ]
        ],
        'date' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/date',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'isToday',
            3 => 'inFuture',
            4 => 'inPast',
            5 => 'equals',
            6 => 'notEquals'
          ]
        ],
        'datetime' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/date',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'isToday',
            3 => 'inFuture',
            4 => 'inPast'
          ]
        ],
        'datetimeOptional' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/date',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'isToday',
            3 => 'inFuture',
            4 => 'inPast'
          ]
        ],
        'enum' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/enum',
          'typeList' => [
            0 => 'equals',
            1 => 'notEquals',
            2 => 'isEmpty',
            3 => 'isNotEmpty',
            4 => 'in',
            5 => 'notIn'
          ]
        ],
        'link' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/link',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'equals',
            3 => 'notEquals'
          ]
        ],
        'linkOne' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/link',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'equals',
            3 => 'notEquals'
          ]
        ],
        'file' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/link',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty'
          ]
        ],
        'image' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/link',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty'
          ]
        ],
        'linkParent' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/link-parent',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'equals',
            3 => 'notEquals'
          ]
        ],
        'linkMultiple' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/link-multiple',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'contains',
            3 => 'notContains'
          ]
        ],
        'foreign' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'equals',
            1 => 'notEquals',
            2 => 'isEmpty',
            3 => 'isNotEmpty'
          ]
        ],
        'id' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/enum',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty'
          ]
        ],
        'multiEnum' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/multi-enum',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'has',
            3 => 'notHas'
          ]
        ],
        'array' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/multi-enum',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'has',
            3 => 'notHas'
          ]
        ],
        'checklist' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/multi-enum',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'has',
            3 => 'notHas'
          ]
        ],
        'urlMultiple' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/multi-enum',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty'
          ]
        ],
        'currentUser' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/current-user',
          'typeList' => [
            0 => 'equals',
            1 => 'notEquals'
          ]
        ],
        'currentUserTeams' => [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/current-user-teams',
          'typeList' => [
            0 => 'contains',
            1 => 'notContains'
          ]
        ]
      ],
      'conditionTypes' => [
        'isTrue' => [
          'valueType' => 'empty'
        ],
        'isFalse' => [
          'valueType' => 'empty'
        ],
        'isEmpty' => [
          'valueType' => 'empty'
        ],
        'isNotEmpty' => [
          'valueType' => 'empty'
        ],
        'equals' => [
          'valueType' => 'field'
        ],
        'notEquals' => [
          'valueType' => 'field'
        ],
        'greaterThan' => [
          'valueType' => 'field'
        ],
        'lessThan' => [
          'valueType' => 'field'
        ],
        'greaterThanOrEquals' => [
          'valueType' => 'field'
        ],
        'lessThanOrEquals' => [
          'valueType' => 'field'
        ],
        'in' => [
          'valueType' => 'field'
        ],
        'notIn' => [
          'valueType' => 'field'
        ],
        'contains' => [
          'valueType' => 'custom'
        ],
        'notContains' => [
          'valueType' => 'custom'
        ],
        'inPast' => [
          'valueType' => 'empty'
        ],
        'isFuture' => [
          'valueType' => 'empty'
        ],
        'isToday' => [
          'valueType' => 'empty'
        ],
        'has' => [
          'valueType' => 'field'
        ],
        'notHas' => [
          'valueType' => 'field'
        ],
        'startsWith' => [
          'valueType' => 'varchar'
        ],
        'endsWith' => [
          'valueType' => 'varchar'
        ],
        'matches' => [
          'valueType' => 'varchar'
        ]
      ]
    ],
    'Email' => [
      'controller' => 'controllers/email',
      'acl' => 'acl/email',
      'views' => [
        'list' => 'views/email/list',
        'detail' => 'views/email/detail'
      ],
      'recordViews' => [
        'list' => 'views/email/record/list',
        'detail' => 'views/email/record/detail',
        'edit' => 'views/email/record/edit',
        'editQuick' => 'views/email/record/edit-quick',
        'detailQuick' => 'views/email/record/detail-quick',
        'compose' => 'views/email/record/compose',
        'listRelated' => 'views/email/record/list-related'
      ],
      'modalViews' => [
        'detail' => 'views/email/modals/detail',
        'compose' => 'views/modals/compose-email'
      ],
      'quickCreateModalType' => 'compose',
      'defaultSidePanelView' => 'views/email/record/panels/default-side',
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'event',
            'label' => 'Event',
            'view' => 'views/email/record/panels/event',
            'isForm' => true,
            'hidden' => true
          ]
        ]
      ],
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Compose',
              'action' => 'composeEmail',
              'style' => 'danger',
              'acl' => 'create',
              'className' => 'btn-s-wide',
              'title' => 'Ctrl+Space'
            ]
          ],
          'dropdown' => [
            0 => [
              'name' => 'archiveEmail',
              'label' => 'Archive Email',
              'link' => '#Email/create',
              'acl' => 'create'
            ],
            1 => [
              'name' => 'importEml',
              'label' => 'Import EML',
              'handler' => 'handlers/email/list-actions',
              'checkVisibilityFunction' => 'checkImportEml',
              'actionFunction' => 'importEml'
            ],
            2 => false,
            3 => [
              'label' => 'Email Templates',
              'link' => '#EmailTemplate',
              'acl' => 'read',
              'aclScope' => 'EmailTemplate'
            ],
            4 => [
              'label' => 'Folders',
              'link' => '#EmailFolder',
              'configCheck' => '!emailFoldersDisabled',
              'accessDataList' => [
                0 => [
                  'inPortalDisabled' => true
                ]
              ]
            ],
            5 => [
              'label' => 'Group Folders',
              'link' => '#GroupEmailFolder',
              'configCheck' => '!emailFoldersDisabled',
              'accessDataList' => [
                0 => [
                  'inPortalDisabled' => true
                ],
                1 => [
                  'isAdminOnly' => true
                ]
              ]
            ],
            6 => [
              'label' => 'Filters',
              'link' => '#EmailFilter',
              'accessDataList' => [
                0 => [
                  'inPortalDisabled' => true
                ]
              ]
            ]
          ]
        ],
        'detail' => [
          'dropdown' => [
            0 => [
              'label' => 'Reply',
              'action' => 'reply',
              'acl' => 'read'
            ],
            1 => [
              'label' => 'Reply to All',
              'action' => 'replyToAll',
              'acl' => 'read'
            ],
            2 => [
              'label' => 'Forward',
              'action' => 'forward',
              'acl' => 'read'
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'users' => [
          'selectHandler' => 'handlers/email/select-user'
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'replied' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'repliedId',
                  'data' => [
                    'field' => 'replied'
                  ]
                ]
              ]
            ]
          ],
          'replies' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'repliesIds',
                  'data' => [
                    'field' => 'replies'
                  ]
                ]
              ]
            ]
          ],
          'folderString' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'and',
                      'value' => [
                        0 => [
                          'type' => 'isTrue',
                          'attribute' => 'isUsers'
                        ]
                      ]
                    ],
                    1 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'groupFolderId'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'sendAt' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'status',
                  'value' => [
                    0 => 'Draft'
                  ]
                ]
              ]
            ]
          ]
        ],
        'panels' => [
          'event' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'icsEventDateStart'
                ]
              ]
            ]
          ]
        ]
      ],
      'filterList' => [],
      'defaultFilterData' => [],
      'boolFilterList' => [],
      'iconClass' => 'fas fa-envelope',
      'layoutBottomPanelsDetailDisabled' => true,
      'layoutDetailDisabled' => true,
      'layoutDetailSmallDisabled' => true,
      'layoutSidePanelsDetailSmallDisabled' => true,
      'layoutSidePanelsEditSmallDisabled' => true
    ],
    'EmailAccount' => [
      'controller' => 'controllers/record',
      'recordViews' => [
        'list' => 'views/email-account/record/list',
        'detail' => 'views/email-account/record/detail',
        'edit' => 'views/email-account/record/edit'
      ],
      'views' => [
        'list' => 'views/email-account/list'
      ],
      'inlineEditDisabled' => true,
      'formDependency' => [
        'storeSentEmails' => [
          'map' => [
            'true' => [
              0 => [
                'action' => 'show',
                'fields' => [
                  0 => 'sentFolder'
                ]
              ],
              1 => [
                'action' => 'setRequired',
                'fields' => [
                  0 => 'sentFolder'
                ]
              ]
            ]
          ],
          'default' => [
            0 => [
              'action' => 'hide',
              'fields' => [
                0 => 'sentFolder'
              ]
            ],
            1 => [
              'action' => 'setNotRequired',
              'fields' => [
                0 => 'sentFolder'
              ]
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'smtpUsername' => [
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'and',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'useSmtp'
                    ],
                    1 => [
                      'type' => 'isTrue',
                      'attribute' => 'smtpAuth'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'fetchSince' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'useImap'
                ]
              ]
            ],
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'fetchData'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'useImap'
                ]
              ]
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => [
          'name' => 'active'
        ]
      ],
      'relationshipPanels' => [
        'filters' => [
          'select' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-edit-and-remove',
          'unlinkDisabled' => true
        ],
        'emails' => [
          'select' => false,
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/remove-only',
          'unlinkDisabled' => true
        ]
      ]
    ],
    'EmailAddress' => [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'editDisabled' => true,
      'exportDisabled' => true,
      'mergeDisabled' => true,
      'filterList' => [
        0 => 'orphan'
      ]
    ],
    'EmailFilter' => [
      'controller' => 'controllers/email-filter',
      'dynamicHandler' => 'handlers/email-filter',
      'modalViews' => [
        'edit' => 'views/email-filter/modals/edit'
      ],
      'recordViews' => [
        'list' => 'views/email-filter/record/list'
      ],
      'inlineEditDisabled' => true,
      'searchPanelDisabled' => false,
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Emails',
              'link' => '#Email',
              'style' => 'default',
              'aclScope' => 'Email'
            ]
          ]
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'dynamicLogic' => [
        'fields' => [
          'parent' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'attribute' => 'isGlobal',
                  'type' => 'isFalse'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'attribute' => 'isGlobal',
                  'type' => 'isFalse'
                ]
              ]
            ]
          ],
          'emailFolder' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'attribute' => 'action',
                  'type' => 'equals',
                  'value' => 'Move to Folder'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'attribute' => 'action',
                  'type' => 'equals',
                  'value' => 'Move to Folder'
                ]
              ]
            ]
          ],
          'groupEmailFolder' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'attribute' => 'action',
                  'type' => 'equals',
                  'value' => 'Move to Group Folder'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'attribute' => 'action',
                  'type' => 'equals',
                  'value' => 'Move to Group Folder'
                ]
              ]
            ]
          ],
          'markAsRead' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'attribute' => 'parentType',
                  'type' => 'equals',
                  'value' => 'User'
                ]
              ]
            ]
          ],
          'skipNotification' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'attribute' => 'parentType',
                  'type' => 'equals',
                  'value' => 'User'
                ]
              ]
            ]
          ]
        ],
        'options' => [
          'action' => [
            0 => [
              'conditionGroup' => [
                0 => [
                  'attribute' => 'isGlobal',
                  'type' => 'isTrue'
                ]
              ],
              'optionList' => [
                0 => 'Skip'
              ]
            ],
            1 => [
              'conditionGroup' => [
                0 => [
                  'attribute' => 'parentType',
                  'type' => 'equals',
                  'value' => 'User'
                ]
              ],
              'optionList' => [
                0 => 'Skip',
                1 => 'Move to Folder',
                2 => 'None'
              ]
            ],
            2 => [
              'conditionGroup' => [
                0 => [
                  'attribute' => 'parentType',
                  'type' => 'equals',
                  'value' => 'InboundEmail'
                ]
              ],
              'optionList' => [
                0 => 'Skip',
                1 => 'Move to Group Folder'
              ]
            ],
            3 => [
              'conditionGroup' => [],
              'optionList' => [
                0 => 'Skip'
              ]
            ]
          ]
        ]
      ]
    ],
    'EmailFolder' => [
      'controller' => 'controllers/record',
      'views' => [
        'list' => 'views/email-folder/list'
      ],
      'recordViews' => [
        'list' => 'views/email-folder/record/list',
        'editQuick' => 'views/email-folder/record/edit-small'
      ],
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Emails',
              'link' => '#Email',
              'style' => 'default',
              'aclScope' => 'Email'
            ]
          ]
        ]
      ],
      'searchPanelDisabled' => true
    ],
    'EmailTemplate' => [
      'controller' => 'controllers/record',
      'views' => [
        'list' => 'views/email-template/list'
      ],
      'recordViews' => [
        'edit' => 'views/email-template/record/edit',
        'detail' => 'views/email-template/record/detail',
        'editQuick' => 'views/email-template/record/edit-quick'
      ],
      'modalViews' => [
        'select' => 'views/modals/select-records-with-categories'
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'information',
            'label' => 'Info',
            'view' => 'views/email-template/record/panels/information'
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'information',
            'label' => 'Info',
            'view' => 'views/email-template/record/panels/information'
          ]
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual'
      ],
      'placeholderList' => [
        0 => 'optOutUrl',
        1 => 'optOutLink'
      ],
      'iconClass' => 'fas fa-envelope-square'
    ],
    'EmailTemplateCategory' => [
      'controller' => 'controllers/record-tree',
      'collection' => 'collections/tree',
      'menu' => [
        'listTree' => [
          'buttons' => [
            0 => [
              'label' => 'List View',
              'link' => '#EmailTemplateCategory/list',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => [
              'label' => 'Email Templates',
              'link' => '#EmailTemplate',
              'acl' => 'read',
              'aclScope' => 'EmailTemplate',
              'style' => 'default'
            ]
          ]
        ],
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Tree View',
              'link' => '#EmailTemplateCategory',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => [
              'label' => 'Email Templates',
              'link' => '#EmailTemplate',
              'acl' => 'read',
              'aclScope' => 'EmailTemplate',
              'style' => 'default'
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'emailTemplates' => [
          'create' => false
        ],
        'children' => [
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ]
      ]
    ],
    'ExternalAccount' => [
      'controller' => 'controllers/external-account'
    ],
    'Global' => [
      'detailActionList' => [
        0 => [
          'name' => 'viewAuditLog',
          'label' => 'View Audit Log',
          'actionFunction' => 'show',
          'checkVisibilityFunction' => 'isAvailable',
          'handler' => 'handlers/record/view-audit-log',
          'groupIndex' => 4
        ],
        1 => [
          'name' => 'viewUserAccess',
          'label' => 'View User Access',
          'actionFunction' => 'show',
          'checkVisibilityFunction' => 'isAvailable',
          'handler' => 'handlers/record/view-user-access',
          'groupIndex' => 4
        ]
      ],
      'menu' => [
        'detail' => [
          'dropdown' => [
            0 => [
              'name' => 'startProcessGlobal',
              'action' => 'startProcessGlobal',
              'label' => 'Start Process',
              'acl' => 'create',
              'aclScope' => 'BpmnProcess',
              'hidden' => true,
              'data' => [
                'handler' => 'advanced:start-process-action-handler'
              ],
              'initFunction' => 'init'
            ]
          ]
        ]
      ],
      'viewSetupHandlers' => [
        'detail' => [
          0 => 'advanced:handlers/manual-workflow'
        ]
      ]
    ],
    'GlobalStream' => [
      'controller' => 'controllers/global-stream',
      'iconClass' => 'fas fa-rss-square'
    ],
    'GroupEmailFolder' => [
      'controller' => 'controllers/record',
      'views' => [
        'list' => 'views/group-email-folder/list'
      ],
      'recordViews' => [
        'list' => 'views/group-email-folder/record/list',
        'editQuick' => 'views/email-folder/record/edit-small'
      ],
      'searchPanelDisabled' => true,
      'massUpdateDisabled' => true,
      'mergeDisabled' => true,
      'massRemoveDisabled' => true,
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'name' => 'emails',
              'labelTranslation' => 'Global.scopeNamesPlural.Email',
              'link' => '#Email',
              'style' => 'default',
              'aclScope' => 'Email'
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'emails' => [
          'select' => false,
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/remove-only',
          'unlinkDisabled' => true
        ]
      ]
    ],
    'Home' => [
      'iconClass' => 'fas fa-th-large'
    ],
    'Import' => [
      'controller' => 'controllers/import',
      'acl' => 'acl/import',
      'recordViews' => [
        'list' => 'views/import/record/list',
        'detail' => 'views/import/record/detail'
      ],
      'views' => [
        'list' => 'views/import/list',
        'detail' => 'views/import/detail'
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'imported',
            'label' => 'Imported',
            'view' => 'views/import/record/panels/imported',
            'createDisabled' => true,
            'selectDisabled' => true,
            'unlinkDisabled' => true
          ],
          1 => [
            'name' => 'duplicates',
            'label' => 'Duplicates',
            'view' => 'views/import/record/panels/duplicates',
            'rowActionsView' => 'views/import/record/row-actions/duplicates',
            'createDisabled' => true,
            'selectDisabled' => true,
            'unlinkDisabled' => true
          ],
          2 => [
            'name' => 'updated',
            'label' => 'Updated',
            'view' => 'views/import/record/panels/updated',
            'createDisabled' => true,
            'selectDisabled' => true,
            'unlinkDisabled' => true
          ]
        ]
      ],
      'searchPanelDisabled' => true,
      'relationshipPanels' => [
        'errors' => [
          'unlinkDisabled' => true,
          'actionList' => [
            0 => [
              'name' => 'export',
              'label' => 'Export',
              'handler' => 'handlers/import',
              'actionFunction' => 'errorExport'
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-file-import',
      'dateFormatList' => [
        0 => 'YYYY-MM-DD',
        1 => 'DD-MM-YYYY',
        2 => 'MM-DD-YYYY',
        3 => 'MM/DD/YYYY',
        4 => 'DD/MM/YYYY',
        5 => 'DD.MM.YYYY',
        6 => 'MM.DD.YYYY',
        7 => 'YYYY.MM.DD',
        8 => 'DD. MM. YYYY'
      ],
      'timeFormatList' => [
        0 => 'HH:mm:ss',
        1 => 'HH:mm',
        2 => 'hh:mm a',
        3 => 'hh:mma',
        4 => 'hh:mm A',
        5 => 'hh:mmA',
        6 => 'hh:mm:ss a',
        7 => 'hh:mm:ssa',
        8 => 'hh:mm:ss A',
        9 => 'hh:mm:ssA'
      ]
    ],
    'ImportError' => [
      'controller' => 'controllers/record',
      'acl' => 'acl/foreign',
      'searchPanelDisabled' => true,
      'createDisabled' => true,
      'editDisabled' => true
    ],
    'InboundEmail' => [
      'recordViews' => [
        'detail' => 'views/inbound-email/record/detail',
        'edit' => 'views/inbound-email/record/edit',
        'list' => 'views/inbound-email/record/list'
      ],
      'inlineEditDisabled' => true,
      'formDependency' => [
        'reply' => [
          'map' => [
            'true' => [
              0 => [
                'action' => 'show',
                'fields' => [
                  0 => 'replyEmailTemplate',
                  1 => 'replyFromAddress',
                  2 => 'replyFromName'
                ]
              ],
              1 => [
                'action' => 'setRequired',
                'fields' => [
                  0 => 'replyEmailTemplate'
                ]
              ]
            ]
          ],
          'default' => [
            0 => [
              'action' => 'hide',
              'fields' => [
                0 => 'replyEmailTemplate',
                1 => 'replyFromAddress',
                2 => 'replyFromName'
              ]
            ],
            1 => [
              'action' => 'setNotRequired',
              'fields' => [
                0 => 'replyEmailTemplate'
              ]
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'smtpUsername' => [
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'and',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'useSmtp'
                    ],
                    1 => [
                      'type' => 'isTrue',
                      'attribute' => 'smtpAuth'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'fetchSince' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'useImap'
                ]
              ]
            ],
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'fetchData'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'useImap'
                ]
              ]
            ]
          ],
          'isSystem' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'searchPanelDisabled' => true,
      'relationshipPanels' => [
        'filters' => [
          'select' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-edit-and-remove',
          'unlinkDisabled' => true
        ],
        'emails' => [
          'select' => false,
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/remove-only',
          'unlinkDisabled' => true
        ]
      ],
      'defaultSidePanelFieldLists' => [
        'detail' => [],
        'detailSmall' => [],
        'edit' => [],
        'editSmall' => []
      ]
    ],
    'Job' => [
      'modalViews' => [
        'detail' => 'views/admin/job/modals/detail'
      ],
      'recordViews' => [
        'list' => 'views/admin/job/record/list',
        'detailQuick' => 'views/admin/job/record/detail-small'
      ]
    ],
    'LastViewed' => [
      'controller' => 'controllers/last-viewed',
      'views' => [
        'list' => 'views/last-viewed/list'
      ],
      'recordViews' => [
        'list' => 'views/last-viewed/record/list'
      ]
    ],
    'LayoutSet' => [
      'controller' => 'controllers/layout-set',
      'recordViews' => [
        'list' => 'views/layout-set/record/list'
      ],
      'searchPanelDisabled' => true,
      'duplicateDisabled' => true,
      'relationshipPanels' => [
        'teams' => [
          'createDisabled' => true,
          'viewDisabled' => true,
          'rowActionsView' => 'views/record/row-actions/relationship-unlink-only'
        ]
      ]
    ],
    'LeadCapture' => [
      'controller' => 'controllers/record',
      'searchPanelDisabled' => true,
      'recordViews' => [
        'detail' => 'views/lead-capture/record/detail',
        'list' => 'views/lead-capture/record/list'
      ],
      'dynamicLogic' => [
        'fields' => [
          'targetList' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'subscribeToTargetList'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'subscribeToTargetList'
                ]
              ]
            ]
          ],
          'subscribeContactToTargetList' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'subscribeToTargetList'
                ]
              ]
            ]
          ],
          'optInConfirmationLifetime' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ]
          ],
          'optInConfirmationSuccessMessage' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ]
          ],
          'createLeadBeforeOptInConfirmation' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ]
          ],
          'smtpAccount' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ]
          ],
          'skipOptInConfirmationIfSubscribed' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'and',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'optInConfirmation'
                    ],
                    1 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'targetListId',
                      'data' => [
                        'field' => 'targetList'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'optInConfirmationEmailTemplate' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ]
          ],
          'apiKey' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'phoneNumberCountry' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'contains',
                  'attribute' => 'fieldList',
                  'value' => 'phoneNumber'
                ]
              ]
            ]
          ],
          'formSuccessText' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ],
          'formText' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ],
          'formSuccessRedirectUrl' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ],
          'formLanguage' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ],
          'formFrameAncestors' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ],
          'formCaptcha' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ]
        ],
        'panels' => [
          'form' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ],
                1 => [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ]
        ]
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'request',
            'label' => 'Request',
            'isForm' => true,
            'view' => 'views/lead-capture/record/panels/request',
            'notRefreshable' => true
          ],
          1 => [
            'name' => 'form',
            'label' => 'Web Form',
            'isForm' => true,
            'view' => 'views/lead-capture/record/panels/form',
            'notRefreshable' => true
          ]
        ]
      ],
      'relationshipPanels' => [
        'logRecords' => [
          'rowActionsView' => 'views/record/row-actions/view-and-remove',
          'layout' => 'listForLeadCapture',
          'select' => false,
          'create' => false
        ]
      ]
    ],
    'LeadCaptureLogRecord' => [
      'modalViews' => [
        'detail' => 'views/lead-capture-log-record/modals/detail'
      ]
    ],
    'Note' => [
      'controller' => 'controllers/note',
      'collection' => 'collections/note',
      'recordViews' => [
        'edit' => 'views/note/record/edit',
        'editQuick' => 'views/note/record/edit',
        'listRelated' => 'views/stream/record/list'
      ],
      'modalViews' => [
        'edit' => 'views/note/modals/edit'
      ],
      'itemViews' => [
        'Post' => 'views/stream/notes/post',
        'EventConfirmation' => 'crm:views/stream/notes/event-confirmation'
      ],
      'viewSetupHandlers' => [
        'record/detail' => [
          0 => 'handlers/note/record-detail-setup'
        ]
      ]
    ],
    'Notification' => [
      'controller' => 'controllers/notification',
      'acl' => 'acl/notification',
      'aclPortal' => 'acl-portal/notification',
      'collection' => 'collections/note',
      'itemViews' => [
        'System' => 'views/notification/items/system',
        'EmailInbox' => 'views/notification/items/email-inbox',
        'EventAttendee' => 'crm:views/notification/items/event-attendee'
      ]
    ],
    'PasswordChangeRequest' => [
      'controller' => 'controllers/password-change-request'
    ],
    'PhoneNumber' => [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'editDisabled' => true,
      'exportDisabled' => true,
      'mergeDisabled' => true,
      'filterList' => [
        0 => 'orphan'
      ]
    ],
    'Portal' => [
      'controller' => 'controllers/record',
      'recordViews' => [
        'list' => 'views/portal/record/list'
      ],
      'relationshipPanels' => [
        'users' => [
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-unlink-only',
          'layout' => 'listSmall',
          'selectPrimaryFilterName' => 'activePortal'
        ],
        'authenticationProvider' => [
          'createDisabled' => true
        ]
      ],
      'searchPanelDisabled' => true
    ],
    'PortalRole' => [
      'recordViews' => [
        'detail' => 'views/portal-role/record/detail',
        'edit' => 'views/portal-role/record/edit',
        'editQuick' => 'views/portal-role/record/edit',
        'list' => 'views/portal-role/record/list'
      ],
      'relationshipPanels' => [
        'users' => [
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-unlink-only'
        ]
      ],
      'views' => [
        'list' => 'views/portal-role/list'
      ]
    ],
    'PortalUser' => [
      'controller' => 'controllers/portal-user',
      'views' => [
        'detail' => 'views/user/detail',
        'list' => 'views/portal-user/list'
      ],
      'recordViews' => [
        'list' => 'views/user/record/list',
        'detail' => 'views/user/record/detail',
        'edit' => 'views/user/record/edit',
        'detailSmall' => 'views/user/record/detail-quick',
        'editSmall' => 'views/user/record/edit-quick'
      ],
      'defaultSidePanelFieldLists' => [
        'detail' => [
          0 => 'avatar',
          1 => 'createdAt',
          2 => 'lastAccess'
        ],
        'detailSmall' => [
          0 => 'avatar',
          1 => 'createdAt'
        ],
        'edit' => [
          0 => 'avatar'
        ],
        'editSmall' => [
          0 => 'avatar'
        ]
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history'
          ]
        ],
        'detailSmall' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history'
          ]
        ]
      ],
      'filterList' => [
        0 => 'activePortal'
      ],
      'boolFilterList' => [],
      'selectDefaultFilters' => [
        'filter' => 'activePortal'
      ],
      'iconClass' => 'far fa-user-circle'
    ],
    'Preferences' => [
      'recordViews' => [
        'edit' => 'views/preferences/record/edit'
      ],
      'views' => [
        'edit' => 'views/preferences/edit'
      ],
      'acl' => 'acl/preferences',
      'aclPortal' => 'acl-portal/preferences',
      'dynamicLogic' => [
        'fields' => [
          'assignmentEmailNotificationsIgnoreEntityTypeList' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'receiveAssignmentEmailNotifications'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Role' => [
      'recordViews' => [
        'detail' => 'views/role/record/detail',
        'edit' => 'views/role/record/edit',
        'editQuick' => 'views/role/record/edit',
        'list' => 'views/role/record/list'
      ],
      'relationshipPanels' => [
        'users' => [
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-unlink-only'
        ],
        'teams' => [
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-unlink-only'
        ]
      ],
      'views' => [
        'list' => 'views/role/list'
      ]
    ],
    'ScheduledJob' => [
      'controller' => 'controllers/record',
      'relationshipPanels' => [
        'log' => [
          'readOnly' => true,
          'view' => 'views/scheduled-job/record/panels/log',
          'createDisabled' => true,
          'selectDisabled' => true,
          'viewDisabled' => true,
          'unlinkDisabled' => true
        ]
      ],
      'recordViews' => [
        'list' => 'views/scheduled-job/record/list',
        'detail' => 'views/scheduled-job/record/detail'
      ],
      'views' => [
        'list' => 'views/scheduled-job/list'
      ],
      'jobWithTargetList' => [
        0 => 'CheckEmailAccounts',
        1 => 'CheckInboundEmails'
      ],
      'dynamicLogic' => [
        'fields' => [
          'job' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'ScheduledJobLogRecord' => [
      'controller' => 'controllers/record'
    ],
    'Stream' => [
      'controller' => 'controllers/stream',
      'iconClass' => 'fas fa-rss'
    ],
    'Team' => [
      'acl' => 'acl/team',
      'defaultSidePanel' => [
        'edit' => false,
        'editSmall' => false
      ],
      'mergeDisabled' => true,
      'massUpdateDisabled' => true,
      'defaultSidePanelFieldLists' => [
        'detail' => [
          0 => 'createdAt'
        ]
      ],
      'relationshipPanels' => [
        'users' => [
          'createDisabled' => true,
          'editDisabled' => true,
          'removeDisabled' => true,
          'layout' => 'listForTeam',
          'selectPrimaryFilterName' => 'active',
          'filterList' => [
            0 => 'all',
            1 => 'active'
          ],
          'rowActionList' => [
            0 => 'changeTeamPosition'
          ],
          'selectMandatoryAttributeList' => [
            0 => 'teamRole'
          ]
        ]
      ],
      'recordViews' => [
        'detail' => 'views/team/record/detail',
        'edit' => 'views/team/record/edit',
        'list' => 'views/team/record/list'
      ],
      'modalViews' => [
        'detail' => 'views/team/modals/detail'
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-users'
    ],
    'Template' => [
      'controller' => 'controllers/record',
      'recordViews' => [
        'detail' => 'views/template/record/detail',
        'edit' => 'views/template/record/edit'
      ],
      'mergeDisabled' => true,
      'dynamicLogic' => [
        'fields' => [
          'entityType' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'footer' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'printFooter'
                ]
              ]
            ]
          ],
          'footerPosition' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'printFooter'
                ]
              ]
            ]
          ],
          'header' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'printHeader'
                ]
              ]
            ]
          ],
          'headerPosition' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'printHeader'
                ]
              ]
            ]
          ],
          'body' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'entityType'
                ]
              ]
            ]
          ],
          'pageWidth' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'pageFormat',
                  'value' => 'Custom'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'pageFormat',
                  'value' => 'Custom'
                ]
              ]
            ]
          ],
          'pageHeight' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'pageFormat',
                  'value' => 'Custom'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'pageFormat',
                  'value' => 'Custom'
                ]
              ]
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-file-pdf'
    ],
    'User' => [
      'controller' => 'controllers/user',
      'model' => 'models/user',
      'acl' => 'acl/user',
      'views' => [
        'detail' => 'views/user/detail',
        'list' => 'views/user/list'
      ],
      'recordViews' => [
        'detail' => 'views/user/record/detail',
        'detailSmall' => 'views/user/record/detail-quick',
        'edit' => 'views/user/record/edit',
        'editSmall' => 'views/user/record/edit-quick',
        'list' => 'views/user/record/list'
      ],
      'modalViews' => [
        'selectFollowers' => 'views/user/modals/select-followers',
        'detail' => 'views/user/modals/detail',
        'massUpdate' => 'views/user/modals/mass-update'
      ],
      'rowActionDefs' => [
        'changeTeamPosition' => [
          'labelTranslation' => 'User.actions.changePosition',
          'handler' => 'handlers/user/change-team-position-row-action',
          'groupIndex' => 3
        ]
      ],
      'defaultSidePanel' => [
        'detail' => [
          'name' => 'default',
          'label' => false,
          'view' => 'views/user/record/panels/default-side',
          'isForm' => true
        ],
        'detailSmall' => [
          'name' => 'default',
          'label' => false,
          'view' => 'views/user/record/panels/default-side',
          'isForm' => true
        ],
        'edit' => [
          'name' => 'default',
          'label' => false,
          'view' => 'views/user/record/panels/default-side',
          'isForm' => true
        ],
        'editSmall' => [
          'name' => 'default',
          'label' => false,
          'view' => 'views/user/record/panels/default-side',
          'isForm' => true
        ]
      ],
      'defaultSidePanelFieldLists' => [
        'detail' => [
          0 => 'avatar',
          1 => 'createdAt',
          2 => 'lastAccess',
          3 => 'auth2FA'
        ],
        'detailSmall' => [
          0 => 'avatar',
          1 => 'lastAccess'
        ],
        'edit' => [
          0 => 'avatar'
        ],
        'editSmall' => [
          0 => 'avatar'
        ]
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => [
            'name' => 'tasks',
            'reference' => 'tasks',
            'view' => 'crm:views/user/record/panels/tasks'
          ]
        ],
        'detailSmall' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => [
            'name' => 'tasks',
            'reference' => 'tasks',
            'view' => 'crm:views/user/record/panels/tasks'
          ]
        ]
      ],
      'relationshipPanels' => [
        'targetLists' => [
          'create' => false,
          'rowActionsView' => 'crm:views/record/row-actions/relationship-target',
          'layout' => 'listForTarget',
          'view' => 'crm:views/record/panels/target-lists'
        ],
        'registration' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'portals' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ],
      'layoutDefaultSidePanelDisabled' => true,
      'filterList' => [
        0 => 'active'
      ],
      'boolFilterList' => [
        0 => 'onlyMyTeam'
      ],
      'selectDefaultFilters' => [
        'filter' => 'active'
      ],
      'selectRecords' => [
        'orderBy' => 'userNameOwnFirst'
      ],
      'iconClass' => 'fas fa-user-circle',
      'dynamicLogic' => [
        'fields' => [
          'avatarColor' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'avatarId',
                  'value' => NULL,
                  'data' => [
                    'field' => 'avatar'
                  ]
                ],
                1 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'regular',
                    1 => 'admin',
                    2 => 'api'
                  ]
                ]
              ]
            ]
          ],
          'emailAddress' => [
            'readOnly' => NULL
          ],
          'cRegistration' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'cRegistrationId',
                  'data' => [
                    'field' => 'cRegistration'
                  ]
                ]
              ]
            ]
          ],
          'usertoken' => [
            'visible' => NULL
          ]
        ],
        'options' => [
          'authMethod' => [
            0 => [
              'optionList' => [
                0 => 'ApiKey',
                1 => 'Hmac'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'api'
                ]
              ]
            ]
          ]
        ]
      ],
      'kanbanViewMode' => false,
      'color' => NULL
    ],
    'Webhook' => [
      'controller' => 'controllers/record',
      'inlineEditDisabled' => true,
      'recordViews' => [
        'list' => 'views/webhook/record/list'
      ],
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.WebhookQueueItem',
              'link' => '#WebhookQueueItem',
              'aclScope' => 'WebhookQueueItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'event' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'secretKey' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'WebhookQueueItem' => [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'editDisabled' => true,
      'mergeDisabled' => true,
      'exportDisabled' => true,
      'textFilterDisabled' => true
    ],
    'WorkingTimeCalendar' => [
      'controller' => 'controllers/record',
      'searchPanelDisabled' => true,
      'massUpdateDisabled' => true,
      'mergeDisabled' => true,
      'massRemoveDisabled' => true,
      'iconClass' => 'fas fa-calendar-week',
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'name' => 'ranges',
              'labelTranslation' => 'WorkingTimeCalendar.links.ranges',
              'link' => '#WorkingTimeRange'
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'weekday0TimeRanges' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'weekday0'
                ]
              ]
            ]
          ],
          'weekday1TimeRanges' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'weekday1'
                ]
              ]
            ]
          ],
          'weekday2TimeRanges' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'weekday2'
                ]
              ]
            ]
          ],
          'weekday3TimeRanges' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'weekday3'
                ]
              ]
            ]
          ],
          'weekday4TimeRanges' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'weekday4'
                ]
              ]
            ]
          ],
          'weekday5TimeRanges' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'weekday5'
                ]
              ]
            ]
          ],
          'weekday6TimeRanges' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'weekday6'
                ]
              ]
            ]
          ],
          'teams' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'teamsIds'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'WorkingTimeRange' => [
      'controller' => 'controllers/record',
      'viewSetupHandlers' => [
        'record/edit' => [
          0 => 'handlers/working-time-range'
        ]
      ],
      'mergeDisabled' => true,
      'massUpdateDisabled' => true,
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'name' => 'calendars',
              'label' => 'Calendars',
              'link' => '#WorkingTimeCalendar'
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'timeRanges' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Working'
                ]
              ]
            ]
          ],
          'users' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'id'
                    ],
                    1 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'usersIds'
                    ],
                    2 => [
                      'type' => 'isEmpty',
                      'attribute' => 'calendarsIds'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => 'actual'
      ]
    ],
    'Account' => [
      'controller' => 'controllers/record',
      'aclPortal' => 'crm:acl-portal/account',
      'views' => [
        'detail' => 'crm:views/account/detail'
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ],
        'detailSmall' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities',
            'disabled' => true
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history',
            'disabled' => true
          ]
        ]
      ],
      'relationshipPanels' => [
        'contacts' => [
          'filterList' => [
            0 => 'all',
            1 => 'accountActive'
          ],
          'layout' => 'listForAccount',
          'orderBy' => 'name',
          'createAttributeMap' => [
            'billingAddressCity' => 'addressCity',
            'billingAddressStreet' => 'addressStreet',
            'billingAddressPostalCode' => 'addressPostalCode',
            'billingAddressState' => 'addressState',
            'billingAddressCountry' => 'addressCountry',
            'id' => 'accountId',
            'name' => 'accountName'
          ]
        ],
        'opportunities' => [
          'layout' => 'listForAccount',
          'createHandler' => 'sales:handlers/account/create-opportunity'
        ],
        'campaignLogRecords' => [
          'rowActionsView' => 'views/record/row-actions/empty',
          'select' => false,
          'create' => false
        ],
        'targetLists' => [
          'rowActionsView' => 'crm:views/record/row-actions/relationship-target',
          'layout' => 'listForTarget',
          'view' => 'crm:views/record/panels/target-lists'
        ],
        'quotes' => [
          'createAction' => 'createRelatedQuote',
          'view' => 'sales:views/account/record/panels/quotes',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'salesOrders' => [
          'createAction' => 'createRelatedQuote',
          'view' => 'sales:views/account/record/panels/quotes',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'invoices' => [
          'createAction' => 'createRelatedQuote',
          'view' => 'sales:views/account/record/panels/quotes',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'deliveryOrders' => [
          'createAction' => 'createRelatedQuote',
          'view' => 'sales:views/account/record/panels/quotes',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'purchaseOrders' => [
          'createAction' => 'createRelatedPurchaseOrder',
          'view' => 'sales:views/account/record/panels/purchase-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'createDisabled' => true
        ],
        'registrationsReseller' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'registrationsCustomer' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'recommendationsConfig' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'recommendationses' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ],
      'filterList' => [
        0 => [
          'name' => 'recentlyCreated'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'additionalLayouts' => [
        'detailConvert' => [
          'type' => 'detail'
        ],
        'formulárioDeCadastro-4customers' => [
          'type' => 'detail'
        ]
      ],
      'color' => '#00bbd0',
      'iconClass' => 'fas fa-building',
      'kanbanViewMode' => false,
      'dynamicLogic' => [
        'fields' => [
          'cMpnID' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Partner'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Partner'
                ]
              ]
            ]
          ],
          'cTenantID' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customer'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customer'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Activities' => [
      'controller' => 'crm:controllers/activities'
    ],
    'Calendar' => [
      'colors' => [
        'Meeting' => '#558BBD',
        'Call' => '#CF605D',
        'Task' => '#70c173'
      ],
      'scopeList' => [
        0 => 'Meeting',
        1 => 'Call',
        2 => 'Task'
      ],
      'allDayScopeList' => [
        0 => 'Task'
      ],
      'modeList' => [
        0 => 'month',
        1 => 'agendaWeek',
        2 => 'timeline',
        3 => 'agendaDay'
      ],
      'sharedViewModeList' => [
        0 => 'basicWeek',
        1 => 'month',
        2 => 'basicDay'
      ],
      'additionalColorList' => [
        0 => '#AB78AD',
        1 => '#CC9B45'
      ],
      'iconClass' => 'far fa-calendar-alt',
      'slotDuration' => 30
    ],
    'Call' => [
      'controller' => 'controllers/record',
      'acl' => 'crm:acl/call',
      'views' => [
        'detail' => 'crm:views/call/detail'
      ],
      'recordViews' => [
        'list' => 'crm:views/call/record/list',
        'detail' => 'crm:views/call/record/detail',
        'editSmall' => 'crm:views/call/record/edit-small'
      ],
      'modalViews' => [
        'detail' => 'crm:views/meeting/modals/detail'
      ],
      'viewSetupHandlers' => [
        'record/detail' => [
          0 => 'crm:handlers/event/reminders-handler'
        ],
        'record/edit' => [
          0 => 'crm:handlers/event/reminders-handler'
        ]
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ],
        'detailSmall' => [
          0 => [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ],
        'editSmall' => [
          0 => [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'scheduler',
            'label' => 'Scheduler',
            'view' => 'crm:views/meeting/record/panels/scheduler',
            'disabled' => false,
            'order' => 3
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'scheduler',
            'label' => 'Scheduler',
            'view' => 'crm:views/meeting/record/panels/scheduler',
            'disabled' => false,
            'order' => 1
          ]
        ],
        'editSmall' => [
          0 => [
            'name' => 'scheduler',
            'label' => 'Scheduler',
            'view' => 'crm:views/meeting/record/panels/scheduler',
            'disabled' => false,
            'order' => 1
          ]
        ]
      ],
      'filterList' => [
        0 => [
          'name' => 'planned'
        ],
        1 => [
          'name' => 'held',
          'style' => 'success'
        ],
        2 => [
          'name' => 'todays'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'activityDefs' => [
        'link' => 'calls',
        'activitiesCreate' => true,
        'historyCreate' => true
      ],
      'forcePatchAttributeDependencyMap' => [
        'dateEnd' => [
          0 => 'dateStart'
        ],
        'dateEndDate' => [
          0 => 'dateStartDate'
        ]
      ],
      'relationshipPanels' => [
        'contacts' => [
          'selectHandler' => 'handlers/select-related/same-account-many'
        ]
      ],
      'additionalLayouts' => [
        'bottomPanelsEditSmall' => [
          'type' => 'bottomPanelsEditSmall'
        ]
      ],
      'iconClass' => 'fas fa-phone'
    ],
    'Campaign' => [
      'controller' => 'controllers/record',
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Target Lists',
              'link' => '#TargetList',
              'acl' => 'read',
              'style' => 'default',
              'aclScope' => 'TargetList'
            ]
          ],
          'dropdown' => [
            0 => [
              'label' => 'Mass Emails',
              'link' => '#MassEmail',
              'acl' => 'read',
              'aclScope' => 'MassEmail'
            ],
            1 => [
              'label' => 'Email Templates',
              'link' => '#EmailTemplate',
              'acl' => 'read',
              'aclScope' => 'EmailTemplate'
            ],
            2 => [
              'label' => 'Tracking URLs',
              'labelTranslation' => 'Campaign.links.trackingUrls',
              'link' => '#CampaignTrackingUrl',
              'acl' => 'read',
              'aclScope' => 'CampaignTrackingUrl'
            ]
          ]
        ]
      ],
      'recordViews' => [
        'detail' => 'crm:views/campaign/record/detail'
      ],
      'views' => [
        'detail' => 'crm:views/campaign/detail'
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'statistics',
            'label' => 'Statistics',
            'view' => 'crm:views/campaign/record/panels/campaign-stats',
            'hidden' => false,
            'isForm' => true
          ]
        ]
      ],
      'relationshipPanels' => [
        'campaignLogRecords' => [
          'view' => 'crm:views/campaign/record/panels/campaign-log-records',
          'layout' => 'listForCampaign',
          'rowActionsView' => 'views/record/row-actions/remove-only',
          'select' => false,
          'create' => false
        ],
        'massEmails' => [
          'createAttributeMap' => [
            'targetListsIds' => 'targetListsIds',
            'targetListsNames' => 'targetListsNames',
            'excludingTargetListsIds' => 'excludingTargetListsIds',
            'excludingTargetListsNames' => 'excludingTargetListsNames'
          ],
          'createHandler' => 'crm:handlers/campaign/mass-emails-create'
        ]
      ],
      'filterList' => [
        0 => 'active'
      ],
      'dynamicLogic' => [
        'fields' => [
          'targetLists' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Email'
                    ],
                    1 => [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Newsletter'
                    ],
                    2 => [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Mail'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'excludingTargetLists' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Email'
                    ],
                    1 => [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Newsletter'
                    ],
                    2 => [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Mail'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'contactsTemplate' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Mail'
                ]
              ]
            ]
          ],
          'leadsTemplate' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Mail'
                ]
              ]
            ]
          ],
          'accountsTemplate' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Mail'
                ]
              ]
            ]
          ],
          'usersTemplate' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Mail'
                ]
              ]
            ]
          ],
          'mailMergeOnlyWithAddress' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Mail'
                ]
              ]
            ]
          ]
        ],
        'panels' => [
          'mailMerge' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Mail'
                ]
              ]
            ]
          ]
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-chart-line'
    ],
    'CampaignLogRecord' => [
      'acl' => 'crm:acl/campaign-tracking-url'
    ],
    'CampaignTrackingUrl' => [
      'controller' => 'controllers/record',
      'acl' => 'crm:acl/campaign-tracking-url',
      'recordViews' => [
        'edit' => 'crm:views/campaign-tracking-url/record/edit',
        'editQuick' => 'crm:views/campaign-tracking-url/record/edit-small'
      ],
      'defaultSidePanel' => [
        'edit' => false,
        'editSmall' => false
      ],
      'dynamicLogic' => [
        'fields' => [
          'url' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'action',
                  'value' => 'Redirect'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'action',
                  'value' => 'Redirect'
                ]
              ]
            ]
          ],
          'message' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'action',
                  'value' => 'Show Message'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'action',
                  'value' => 'Show Message'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Case' => [
      'controller' => 'controllers/record',
      'recordViews' => [
        'detail' => 'crm:views/case/record/detail'
      ],
      'detailActionList' => [
        0 => [
          'name' => 'close',
          'label' => 'Close',
          'handler' => 'crm:handlers/case/detail-actions',
          'actionFunction' => 'close',
          'checkVisibilityFunction' => 'isCloseAvailable'
        ],
        1 => [
          'name' => 'reject',
          'label' => 'Reject',
          'handler' => 'crm:handlers/case/detail-actions',
          'actionFunction' => 'reject',
          'checkVisibilityFunction' => 'isRejectAvailable'
        ]
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities',
            'view' => 'crm:views/case/record/panels/activities'
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ],
        'detailSmall' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities',
            'view' => 'crm:views/case/record/panels/activities'
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities',
            'view' => 'crm:views/case/record/panels/activities',
            'disabled' => true
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history',
            'disabled' => true
          ]
        ]
      ],
      'filterList' => [
        0 => [
          'name' => 'open'
        ],
        1 => [
          'name' => 'closed',
          'style' => 'success'
        ]
      ],
      'relationshipPanels' => [
        'articles' => [
          'createDisabled' => true,
          'editDisabled' => true,
          'removeDisabled' => true,
          'rowActionList' => [
            0 => 'sendInEmail'
          ]
        ],
        'contacts' => [
          'createAttributeMap' => [
            'accountId' => 'accountId',
            'accountName' => 'accountName'
          ],
          'selectHandler' => 'handlers/select-related/same-account-many'
        ],
        'contact' => [
          'createAttributeMap' => [
            'accountId' => 'accountId',
            'accountName' => 'accountName'
          ],
          'selectHandler' => 'handlers/select-related/same-account-many'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'selectDefaultFilters' => [
        'filter' => 'open'
      ],
      'allowInternalNotes' => true,
      'dynamicLogic' => [
        'fields' => [
          'number' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'cApiUser' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'API Access'
                ],
                1 => [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Closed'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'API Access'
                ],
                1 => [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Closed'
                ]
              ]
            ]
          ],
          'cApiPassword' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'API Access'
                ],
                1 => [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Closed'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'API Access'
                ],
                1 => [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Closed'
                ]
              ]
            ]
          ],
          'cCustomizeUrl' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customize URL'
                ],
                1 => [
                  'type' => 'equals',
                  'attribute' => 'cUrlType',
                  'value' => 'domain'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customize URL'
                ],
                1 => [
                  'type' => 'equals',
                  'attribute' => 'cUrlType',
                  'value' => 'domain'
                ]
              ]
            ]
          ],
          'cRegistrationAddress' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customize URL'
                ],
                1 => [
                  'type' => 'in',
                  'attribute' => 'status',
                  'value' => [
                    0 => 'Pending',
                    1 => 'Closed'
                  ]
                ],
                2 => [
                  'type' => 'equals',
                  'attribute' => 'cUrlType',
                  'value' => 'domain'
                ]
              ]
            ]
          ],
          'cUrlType' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customize URL'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customize URL'
                ]
              ]
            ]
          ],
          'cStandardUrl' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customize URL'
                ],
                1 => [
                  'type' => 'equals',
                  'attribute' => 'cUrlType',
                  'value' => 'standard'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customize URL'
                ],
                1 => [
                  'type' => 'equals',
                  'attribute' => 'cUrlType',
                  'value' => 'standard'
                ]
              ]
            ]
          ],
          'description' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'notIn',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'API Access',
                    1 => 'Customize URL'
                  ]
                ]
              ]
            ]
          ],
          'attachments' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'notIn',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'API Access',
                    1 => 'Customize URL'
                  ]
                ]
              ]
            ]
          ],
          'status' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'name' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'notIn',
                      'attribute' => 'type',
                      'value' => [
                        0 => 'Customize URL',
                        1 => 'API Access'
                      ]
                    ],
                    1 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'name'
                    ]
                  ]
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'notIn',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'Customize URL',
                    1 => 'API Access'
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'detailPortal' => [
          'type' => 'detail'
        ],
        'detailSmallPortal' => [
          'type' => 'detail'
        ],
        'listPortal' => [
          'type' => 'list'
        ]
      ],
      'iconClass' => 'fas fa-wrench',
      'kanbanViewMode' => true,
      'color' => '#00bbd0'
    ],
    'Contact' => [
      'controller' => 'controllers/record',
      'aclPortal' => 'crm:acl-portal/contact',
      'views' => [
        'detail' => 'crm:views/contact/detail'
      ],
      'recordViews' => [
        'detail' => 'crm:views/contact/record/detail',
        'detailQuick' => 'crm:views/contact/record/detail-small'
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ],
        'detailSmall' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities',
            'disabled' => true
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history',
            'disabled' => true
          ]
        ]
      ],
      'relationshipPanels' => [
        'campaignLogRecords' => [
          'rowActionsView' => 'views/record/row-actions/empty',
          'select' => false,
          'create' => false
        ],
        'opportunities' => [
          'layout' => 'listForContact',
          'createAttributeMap' => [
            'accountId' => 'accountId',
            'accountName' => 'accountName',
            'id' => 'contactId',
            'name' => 'contactName'
          ],
          'selectHandler' => 'handlers/select-related/same-account'
        ],
        'cases' => [
          'createAttributeMap' => [
            'accountId' => 'accountId',
            'accountName' => 'accountName',
            'id' => 'contactId',
            'name' => 'contactName'
          ],
          'selectHandler' => 'handlers/select-related/same-account'
        ],
        'targetLists' => [
          'create' => false,
          'rowActionsView' => 'crm:views/record/row-actions/relationship-target',
          'layout' => 'listForTarget',
          'view' => 'crm:views/record/panels/target-lists'
        ],
        'registrationsContact' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'additionalLayouts' => [
        'detailConvert' => [
          'type' => 'detail'
        ],
        'listForAccount' => [
          'type' => 'listSmall'
        ]
      ],
      'filterList' => [
        0 => 'portalUsers'
      ],
      'dynamicLogic' => [
        'fields' => [
          'title' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'accountId'
                ]
              ]
            ]
          ],
          'portalUser' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'portalUserId',
                  'data' => [
                    'field' => 'portalUser'
                  ]
                ]
              ]
            ]
          ],
          'customerID' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Customer'
                    ],
                    1 => [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'ISV'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'partnerID' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'ISV'
                    ],
                    1 => [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Reseller'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'color' => '#00bbd0',
      'iconClass' => 'fas fa-user-friends',
      'kanbanViewMode' => false
    ],
    'Document' => [
      'aclPortal' => 'crm:acl-portal/document',
      'controller' => 'controllers/record',
      'views' => [
        'list' => 'crm:views/document/list'
      ],
      'modalViews' => [
        'select' => 'crm:views/document/modals/select-records'
      ],
      'viewSetupHandlers' => [
        'list' => [
          0 => 'crm:view-setup-handlers/document/record-list-drag-n-drop'
        ]
      ],
      'filterList' => [
        0 => 'active',
        1 => 'draft'
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'selectDefaultFilters' => [
        'filter' => 'active'
      ],
      'iconClass' => 'far fa-file-alt',
      'kanbanViewMode' => false,
      'color' => NULL
    ],
    'DocumentFolder' => [
      'controller' => 'controllers/record-tree',
      'collection' => 'collections/tree',
      'menu' => [
        'listTree' => [
          'buttons' => [
            0 => [
              'label' => 'List View',
              'link' => '#DocumentFolder/list',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => [
              'label' => 'Documents',
              'link' => '#Document',
              'acl' => 'read',
              'style' => 'default',
              'aclScope' => 'Document'
            ]
          ]
        ],
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Tree View',
              'link' => '#DocumentFolder',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => [
              'label' => 'Documents',
              'link' => '#Document',
              'acl' => 'read',
              'style' => 'default',
              'aclScope' => 'Document'
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'children' => [
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ]
      ]
    ],
    'EmailQueueItem' => [
      'controller' => 'controllers/record',
      'views' => [
        'list' => 'crm:views/email-queue-item/list'
      ],
      'recordViews' => [
        'list' => 'crm:views/email-queue-item/record/list'
      ],
      'createDisabled' => true,
      'mergeDisabled' => true,
      'massUpdateDisabled' => true
    ],
    'KnowledgeBaseArticle' => [
      'controller' => 'controllers/record',
      'views' => [
        'list' => 'crm:views/knowledge-base-article/list'
      ],
      'recordViews' => [
        'editQuick' => 'crm:views/knowledge-base-article/record/edit-quick',
        'detailQuick' => 'crm:views/knowledge-base-article/record/detail-quick',
        'detail' => 'crm:views/knowledge-base-article/record/detail',
        'edit' => 'crm:views/knowledge-base-article/record/edit',
        'list' => 'crm:views/knowledge-base-article/record/list'
      ],
      'modalViews' => [
        'select' => 'crm:views/knowledge-base-article/modals/select-records'
      ],
      'rowActionDefs' => [
        'moveToTop' => [
          'label' => 'Move to Top',
          'handler' => 'crm:handlers/knowledge-base-article/move',
          'acl' => 'edit'
        ],
        'moveUp' => [
          'label' => 'Move Up',
          'handler' => 'crm:handlers/knowledge-base-article/move',
          'acl' => 'edit'
        ],
        'moveDown' => [
          'label' => 'Move Down',
          'handler' => 'crm:handlers/knowledge-base-article/move',
          'acl' => 'edit'
        ],
        'moveToBottom' => [
          'labelTranslation' => 'KnowledgeBaseArticle.labels.Move to Bottom',
          'handler' => 'crm:handlers/knowledge-base-article/move',
          'acl' => 'edit'
        ],
        'sendInEmail' => [
          'label' => 'Send in Email',
          'handler' => 'crm:handlers/knowledge-base-article/send-in-email'
        ]
      ],
      'rowActionList' => [
        0 => 'moveToTop',
        1 => 'moveUp',
        2 => 'moveDown',
        3 => 'moveToBottom'
      ],
      'filterList' => [
        0 => [
          'name' => 'published',
          'accessDataList' => [
            0 => [
              'inPortalDisabled' => true
            ]
          ]
        ]
      ],
      'boolFilterList' => [
        0 => [
          'name' => 'onlyMy',
          'accessDataList' => [
            0 => [
              'inPortalDisabled' => true
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'cases' => [
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-view-and-unlink'
        ]
      ],
      'additionalLayouts' => [
        'detailPortal' => [
          'type' => 'detail'
        ],
        'detailSmallPortal' => [
          'type' => 'detail'
        ],
        'listPortal' => [
          'type' => 'list'
        ]
      ],
      'iconClass' => 'fas fa-book',
      'kanbanViewMode' => false,
      'color' => NULL
    ],
    'KnowledgeBaseCategory' => [
      'controller' => 'controllers/record-tree',
      'collection' => 'collections/tree',
      'menu' => [
        'listTree' => [
          'buttons' => [
            0 => [
              'label' => 'List View',
              'link' => '#KnowledgeBaseCategory/list',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => [
              'label' => 'Articles',
              'link' => '#KnowledgeBaseArticle',
              'acl' => 'read',
              'style' => 'default',
              'aclScope' => 'KnowledgeBaseArticle'
            ]
          ]
        ],
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Tree View',
              'link' => '#KnowledgeBaseCategory',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => [
              'label' => 'Articles',
              'link' => '#KnowledgeBaseArticle',
              'acl' => 'read',
              'style' => 'default',
              'aclScope' => 'KnowledgeBaseArticle'
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'children' => [
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ]
      ]
    ],
    'Lead' => [
      'controller' => 'crm:controllers/lead',
      'views' => [
        'detail' => 'crm:views/lead/detail'
      ],
      'recordViews' => [
        'detail' => 'crm:views/lead/record/detail'
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'convertedTo',
            'label' => 'Converted To',
            'view' => 'crm:views/lead/record/panels/converted-to',
            'notRefreshable' => true,
            'hidden' => true,
            'style' => 'success',
            'isForm' => true
          ],
          1 => [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          2 => [
            'name' => 'history',
            'reference' => 'history'
          ],
          3 => [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'convertedTo',
            'label' => 'Converted To',
            'view' => 'crm:views/lead/record/panels/converted-to',
            'notRefreshable' => true,
            'hidden' => true,
            'style' => 'success',
            'isForm' => true
          ]
        ],
        'detailSmall' => [
          0 => [
            'name' => 'convertedTo',
            'label' => 'Converted To',
            'view' => 'crm:views/lead/record/panels/converted-to',
            'notRefreshable' => true,
            'hidden' => true,
            'style' => 'success',
            'isForm' => true
          ],
          1 => [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          2 => [
            'name' => 'history',
            'reference' => 'history'
          ],
          3 => [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ],
        'editSmall' => [
          0 => [
            'name' => 'convertedTo',
            'label' => 'Converted To',
            'view' => 'crm:views/lead/record/panels/converted-to',
            'notRefreshable' => true,
            'hidden' => true,
            'style' => 'success',
            'isForm' => true
          ]
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities',
            'disabled' => true
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history',
            'disabled' => true
          ]
        ]
      ],
      'relationshipPanels' => [
        'campaignLogRecords' => [
          'rowActionsView' => 'views/record/row-actions/empty',
          'select' => false,
          'create' => false
        ],
        'targetLists' => [
          'create' => false,
          'rowActionsView' => 'crm:views/record/row-actions/relationship-target',
          'layout' => 'listForTarget',
          'view' => 'crm:views/record/panels/target-lists'
        ]
      ],
      'filterList' => [
        0 => [
          'name' => 'actual'
        ],
        1 => [
          'name' => 'converted',
          'style' => 'success'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'dynamicLogic' => [
        'fields' => [
          'name' => [
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isEmpty',
                  'attribute' => 'accountName'
                ],
                1 => [
                  'type' => 'isEmpty',
                  'attribute' => 'emailAddress'
                ],
                2 => [
                  'type' => 'isEmpty',
                  'attribute' => 'phoneNumber'
                ]
              ]
            ]
          ],
          'convertedAt' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'and',
                  'value' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'status',
                      'value' => 'Converted'
                    ],
                    1 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'convertedAt'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ],
        'panels' => [
          'convertedTo' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Converted'
                ]
              ]
            ]
          ]
        ]
      ],
      'color' => NULL,
      'iconClass' => 'fas fa-users',
      'kanbanViewMode' => false
    ],
    'MassEmail' => [
      'controller' => 'controllers/record',
      'acl' => 'crm:acl/mass-email',
      'recordViews' => [
        'detail' => 'crm:views/mass-email/record/detail',
        'edit' => 'crm:views/mass-email/record/edit',
        'editQuick' => 'crm:views/mass-email/record/edit-small'
      ],
      'views' => [
        'detail' => 'crm:views/mass-email/detail'
      ],
      'defaultSidePanel' => [
        'edit' => false,
        'editSmall' => false
      ],
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.EmailQueueItem',
              'link' => '#EmailQueueItem',
              'accessDataList' => [
                0 => [
                  'isAdminOnly' => true
                ]
              ]
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'status' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'and',
                  'value' => [
                    0 => [
                      'type' => 'or',
                      'value' => [
                        0 => [
                          'type' => 'equals',
                          'attribute' => 'status',
                          'value' => 'Complete'
                        ],
                        1 => [
                          'type' => 'equals',
                          'attribute' => 'status',
                          'value' => 'In Process'
                        ],
                        2 => [
                          'type' => 'equals',
                          'attribute' => 'status',
                          'value' => 'Failed'
                        ]
                      ]
                    ],
                    1 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'id'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ],
        'options' => [
          'status' => [
            0 => [
              'optionList' => [
                0 => 'Draft',
                1 => 'Pending'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'status',
                  'value' => [
                    0 => 'Draft',
                    1 => 'Pending'
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => [
          'name' => 'actual'
        ],
        1 => [
          'name' => 'complete',
          'style' => 'success'
        ]
      ],
      'relationshipPanels' => [
        'queueItems' => [
          'unlinkDisabled' => true,
          'viewDisabled' => true,
          'editDisabled' => true
        ]
      ]
    ],
    'Meeting' => [
      'controller' => 'controllers/record',
      'acl' => 'crm:acl/meeting',
      'views' => [
        'detail' => 'crm:views/meeting/detail'
      ],
      'recordViews' => [
        'list' => 'crm:views/meeting/record/list',
        'detail' => 'crm:views/meeting/record/detail',
        'editSmall' => 'crm:views/meeting/record/edit-small'
      ],
      'modalViews' => [
        'detail' => 'crm:views/meeting/modals/detail'
      ],
      'viewSetupHandlers' => [
        'record/detail' => [
          0 => 'crm:handlers/event/reminders-handler'
        ],
        'record/edit' => [
          0 => 'crm:handlers/event/reminders-handler'
        ]
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'options' => [
              'fieldList' => [
                0 => 'users',
                1 => 'contacts',
                2 => 'leads'
              ]
            ],
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ],
        'detailSmall' => [
          0 => [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ],
        'editSmall' => [
          0 => [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'scheduler',
            'label' => 'Scheduler',
            'view' => 'crm:views/meeting/record/panels/scheduler',
            'order' => 3
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'scheduler',
            'label' => 'Scheduler',
            'view' => 'crm:views/meeting/record/panels/scheduler',
            'order' => 1
          ]
        ],
        'editSmall' => [
          0 => [
            'name' => 'scheduler',
            'label' => 'Scheduler',
            'view' => 'crm:views/meeting/record/panels/scheduler',
            'order' => 1
          ]
        ]
      ],
      'filterList' => [
        0 => [
          'name' => 'planned'
        ],
        1 => [
          'name' => 'held',
          'style' => 'success'
        ],
        2 => [
          'name' => 'todays'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'activityDefs' => [
        'link' => 'meetings',
        'activitiesCreate' => true,
        'historyCreate' => true
      ],
      'forcePatchAttributeDependencyMap' => [
        'dateEnd' => [
          0 => 'dateStart'
        ],
        'dateEndDate' => [
          0 => 'dateStartDate'
        ]
      ],
      'relationshipPanels' => [
        'contacts' => [
          'selectHandler' => 'handlers/select-related/same-account-many'
        ]
      ],
      'additionalLayouts' => [
        'bottomPanelsEditSmall' => [
          'type' => 'bottomPanelsEditSmall'
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'duration' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isAllDay'
                ]
              ]
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-calendar-check'
    ],
    'Opportunity' => [
      'controller' => 'controllers/record',
      'modelDefaultsPreparator' => 'crm:handlers/opportunity/defaults-preparator',
      'views' => [
        'detail' => 'crm:views/opportunity/detail'
      ],
      'recordViews' => [
        'edit' => 'crm:views/opportunity/record/edit',
        'editSmall' => 'crm:views/opportunity/record/edit-small',
        'list' => 'crm:views/opportunity/record/list',
        'kanban' => 'crm:views/opportunity/record/kanban'
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities',
            'view' => 'crm:views/opportunity/record/panels/activities'
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ],
        'detailSmall' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities',
            'view' => 'crm:views/opportunity/record/panels/activities'
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities',
            'disabled' => true,
            'view' => 'crm:views/opportunity/record/panels/activities'
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history',
            'disabled' => true
          ],
          2 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/opportunity/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true,
            'order' => 1
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/opportunity/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true,
            'order' => 1
          ]
        ]
      ],
      'filterList' => [
        0 => [
          'name' => 'open'
        ],
        1 => [
          'name' => 'won',
          'style' => 'success'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'additionalLayouts' => [
        'detailConvert' => [
          'type' => 'detail'
        ],
        'listForAccount' => [
          'type' => 'listSmall'
        ],
        'listForContact' => [
          'type' => 'listSmall'
        ]
      ],
      'kanbanViewMode' => true,
      'relationshipPanels' => [
        'contacts' => [
          'createAttributeMap' => [
            'accountId' => 'accountId',
            'accountName' => 'accountName'
          ],
          'createHandler' => 'crm:handlers/opportunity/contacts-create',
          'selectHandler' => 'handlers/select-related/same-account-many'
        ],
        'contact' => [
          'createAttributeMap' => [
            'accountId' => 'accountId',
            'accountName' => 'accountName'
          ],
          'selectHandler' => 'handlers/select-related/same-account-many'
        ],
        'documents' => [
          'selectHandler' => 'handlers/select-related/same-account-many'
        ],
        'quotes' => [
          'createAction' => 'createRelatedQuote',
          'view' => 'sales:views/opportunity/record/panels/quotes',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'salesOrders' => [
          'createAction' => 'createRelatedSalesOrder',
          'view' => 'sales:views/opportunity/record/panels/sales-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'invoices' => [
          'createAction' => 'createRelatedInvoice',
          'view' => 'sales:views/opportunity/record/panels/invoices',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'account' => [
          'selectFieldHandler' => 'sales:handlers/opportunity/select-account',
          'selectMandatoryAttributeList' => [
            0 => 'priceBookId',
            1 => 'priceBookName'
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'lastStage' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'stage',
                  'value' => 'Closed Lost'
                ]
              ]
            ]
          ]
        ]
      ],
      'color' => NULL,
      'iconClass' => 'fas fa-dollar-sign'
    ],
    'TargetList' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'optedOut',
            'label' => 'Opted Out',
            'view' => 'crm:views/target-list/record/panels/opted-out'
          ],
          1 => [
            'name' => 'syncWithReports',
            'label' => 'Sync with Reports',
            'view' => 'advanced:views/target-list/record/panels/sync-with-reports',
            'notRefreshable' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'syncWithReports',
            'label' => 'Sync with Reports',
            'view' => 'advanced:views/target-list/record/panels/sync-with-reports',
            'notRefreshable' => true,
            'isForm' => true
          ]
        ]
      ],
      'recordViews' => [
        'detail' => 'crm:views/target-list/record/detail'
      ],
      'relationshipPanels' => [
        'contacts' => [
          'actionList' => [
            0 => [
              'label' => 'Unlink All',
              'action' => 'unlinkAllRelated',
              'acl' => 'edit',
              'data' => [
                'link' => 'contacts'
              ]
            ],
            1 => [
              'label' => 'Populate from Report',
              'action' => 'populateFromReport',
              'acl' => 'edit',
              'data' => [
                'link' => 'contacts'
              ]
            ]
          ],
          'rowActionsView' => 'crm:views/target-list/record/row-actions/default',
          'view' => 'advanced:views/target-list/record/panels/relationship',
          'removeDisabled' => true,
          'massSelect' => true
        ],
        'leads' => [
          'actionList' => [
            0 => [
              'label' => 'Unlink All',
              'action' => 'unlinkAllRelated',
              'acl' => 'edit',
              'data' => [
                'link' => 'leads'
              ]
            ],
            1 => [
              'label' => 'Populate from Report',
              'action' => 'populateFromReport',
              'acl' => 'edit',
              'data' => [
                'link' => 'leads'
              ]
            ]
          ],
          'rowActionsView' => 'crm:views/target-list/record/row-actions/default',
          'view' => 'advanced:views/target-list/record/panels/relationship',
          'removeDisabled' => true,
          'massSelect' => true
        ],
        'accounts' => [
          'actionList' => [
            0 => [
              'label' => 'Unlink All',
              'action' => 'unlinkAllRelated',
              'acl' => 'edit',
              'data' => [
                'link' => 'accounts'
              ]
            ],
            1 => [
              'label' => 'Populate from Report',
              'action' => 'populateFromReport',
              'acl' => 'edit',
              'data' => [
                'link' => 'accounts'
              ]
            ]
          ],
          'rowActionsView' => 'crm:views/target-list/record/row-actions/default',
          'view' => 'advanced:views/target-list/record/panels/relationship',
          'removeDisabled' => true,
          'massSelect' => true
        ],
        'users' => [
          'create' => false,
          'actionList' => [
            0 => [
              'label' => 'Unlink All',
              'action' => 'unlinkAllRelated',
              'acl' => 'edit',
              'data' => [
                'link' => 'users'
              ]
            ],
            1 => [
              'label' => 'Populate from Report',
              'action' => 'populateFromReport',
              'acl' => 'edit',
              'data' => [
                'link' => 'users'
              ]
            ]
          ],
          'rowActionsView' => 'crm:views/target-list/record/row-actions/default',
          'view' => 'advanced:views/target-list/record/panels/relationship',
          'removeDisabled' => true,
          'massSelect' => true
        ],
        'syncWithReports' => [
          'createDisabled' => true
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'entryCount' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'optedOutCount' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-crosshairs',
      'formDependency' => [
        'syncWithReportsEnabled' => [
          'map' => [
            'true' => [
              0 => [
                'action' => 'show',
                'fields' => [
                  0 => 'syncWithReports',
                  1 => 'syncWithReportsUnlink'
                ]
              ]
            ]
          ],
          'default' => [
            0 => [
              'action' => 'hide',
              'fields' => [
                0 => 'syncWithReports',
                1 => 'syncWithReportsUnlink'
              ]
            ]
          ]
        ]
      ]
    ],
    'Task' => [
      'controller' => 'crm:controllers/task',
      'recordViews' => [
        'list' => 'crm:views/task/record/list',
        'detail' => 'crm:views/task/record/detail'
      ],
      'views' => [
        'list' => 'crm:views/task/list',
        'detail' => 'crm:views/task/detail'
      ],
      'modalViews' => [
        'detail' => 'crm:views/task/modals/detail'
      ],
      'viewSetupHandlers' => [
        'record/detail' => [
          0 => 'crm:handlers/task/reminders-handler'
        ],
        'record/edit' => [
          0 => 'crm:handlers/task/reminders-handler'
        ]
      ],
      'menu' => [
        'detail' => [
          'buttons' => [
            0 => [
              'label' => 'Complete',
              'name' => 'setCompletedMain',
              'iconHtml' => '<span class="fas fa-check fa-sm"></span>',
              'acl' => 'edit',
              'handler' => 'crm:handlers/task/menu',
              'actionFunction' => 'complete',
              'checkVisibilityFunction' => 'isCompleteAvailable'
            ]
          ]
        ]
      ],
      'modalDetailActionList' => [
        0 => [
          'name' => 'complete',
          'label' => 'Complete',
          'acl' => 'edit',
          'handler' => 'crm:handlers/task/detail-actions',
          'actionFunction' => 'complete',
          'checkVisibilityFunction' => 'isCompleteAvailable'
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'dateCompleted' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Completed'
                ]
              ]
            ]
          ],
          'reminders' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'and',
                  'value' => [
                    0 => [
                      'type' => 'or',
                      'value' => [
                        0 => [
                          'type' => 'isNotEmpty',
                          'attribute' => 'dateEnd'
                        ],
                        1 => [
                          'type' => 'isNotEmpty',
                          'attribute' => 'dateEndDate'
                        ]
                      ]
                    ],
                    1 => [
                      'type' => 'notEquals',
                      'attribute' => 'status',
                      'value' => 'Completed'
                    ],
                    2 => [
                      'type' => 'notEquals',
                      'attribute' => 'status',
                      'value' => 'Canceled'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => 'actual',
        1 => [
          'name' => 'completed',
          'style' => 'success'
        ],
        2 => [
          'name' => 'todays'
        ],
        3 => [
          'name' => 'overdue',
          'style' => 'danger'
        ],
        4 => [
          'name' => 'deferred'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-tasks',
      'kanbanViewMode' => true
    ],
    'BpmnFlowNode' => [
      'mergeDisabled' => true,
      'exportDisabled' => true,
      'massUpdateDisabled' => true,
      'massRemoveDisabled' => true
    ],
    'BpmnFlowchart' => [
      'controller' => 'controllers/record',
      'recordViews' => [
        'detail' => 'advanced:views/bpmn-flowchart/record/detail',
        'edit' => 'advanced:views/bpmn-flowchart/record/edit'
      ],
      'views' => [
        'list' => 'modules/advanced/views/bpmn-flowchart/list-with-categories'
      ],
      'modalViews' => [
        'select' => 'views/modals/select-records-with-categories'
      ],
      'mergeDisabled' => true,
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'label' => 'Processes',
              'link' => '#BpmnProcess',
              'acl' => 'read',
              'aclScope' => 'BpmnProcess'
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => 'active'
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'relationshipPanels' => [
        'processes' => [
          'create' => false,
          'select' => false,
          'unlinkDisabled' => true,
          'rowActionsView' => 'views/record/row-actions/view-only'
        ]
      ],
      'iconClass' => 'fas fa-project-diagram',
      'dynamicLogic' => [
        'fields' => [
          'targetType' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'elements' => [
        'eventStartConditional' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ],
            'isInterrupting' => [
              'type' => 'bool'
            ],
            'triggerType' => [
              'type' => 'enum',
              'options' => [
                0 => 'afterRecordCreated',
                1 => 'afterRecordUpdated',
                2 => 'afterRecordSaved'
              ]
            ],
            'conditions' => [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/conditions'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'triggerType'
                  ],
                  1 => false
                ],
                1 => [
                  0 => [
                    'name' => 'isInterrupting'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'label' => 'Conditions',
              'name' => 'conditions',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'conditions',
                    'fullWidth' => true,
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            3 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'defaults' => [
            'triggerType' => 'afterRecordCreated',
            'isInterrupting' => false
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/event-start-conditional-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/event-start-conditional-edit'
        ],
        'eventStartTimer' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ],
            'isInterrupting' => [
              'type' => 'bool'
            ],
            'timer' => [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/timer'
            ],
            'targetReport' => [
              'type' => 'link',
              'entity' => 'Report',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/target-report',
              'tooltip' => true
            ],
            'scheduling' => [
              'type' => 'varchar',
              'maxLength' => 16,
              'tooltip' => true,
              'noSpellCheck' => true
            ],
            'schedulingApplyTimezone' => [
              'type' => 'bool',
              'default' => false,
              'tooltip' => true
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'targetReport'
                  ],
                  1 => [
                    'name' => 'scheduling'
                  ]
                ],
                1 => [
                  0 => [
                    'name' => 'isInterrupting'
                  ],
                  1 => [
                    'name' => 'schedulingApplyTimezone'
                  ]
                ],
                2 => [
                  0 => [
                    'name' => 'timer',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'defaults' => [
            'isInterrupting' => false,
            'timerBase' => NULL,
            'timerShift' => 0,
            'timerShiftUnits' => 'minutes',
            'timerShiftOperator' => 'plus',
            'timerFormula' => NULL,
            'targetReportId' => NULL,
            'scheduling' => '0 0 * * *',
            'schedulingApplyTimezone' => false
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/event-start-timer-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/event-start-timer-edit'
        ],
        'eventStartError' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ],
            'errorCode' => [
              'type' => 'varchar',
              'maxLength' => 64,
              'noSpellCheck' => true
            ]
          ],
          'defaults' => [
            'errorCode' => NULL
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'errorCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventStartEscalation' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ],
            'isInterrupting' => [
              'type' => 'bool'
            ],
            'escalationCode' => [
              'type' => 'varchar',
              'maxLength' => 64,
              'noSpellCheck' => true
            ]
          ],
          'defaults' => [
            'escalationCode' => NULL,
            'isInterrupting' => false
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'isInterrupting'
                  ],
                  1 => false
                ],
                1 => [
                  0 => [
                    'name' => 'escalationCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventStartSignal' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ],
            'isInterrupting' => [
              'type' => 'bool'
            ],
            'signal' => [
              'type' => 'varchar',
              'maxLength' => 200,
              'view' => 'advanced:views/bpmn-flowchart-element/fields/signal',
              'noSpellCheck' => true
            ]
          ],
          'defaults' => [
            'signal' => NULL,
            'isInterrupting' => false
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'isInterrupting'
                  ],
                  1 => false
                ],
                1 => [
                  0 => [
                    'name' => 'signal'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/event-start-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/event-start-signal-edit'
        ],
        'eventStart' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventStartCompensation' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventEnd' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventEndTerminate' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventEndError' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ],
            'errorCode' => [
              'type' => 'varchar',
              'maxLength' => 64,
              'noSpellCheck' => true
            ]
          ],
          'defaults' => [
            'errorCode' => NULL
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'errorCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventEndEscalation' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ],
            'escalationCode' => [
              'type' => 'varchar',
              'maxLength' => 64,
              'noSpellCheck' => true
            ]
          ],
          'defaults' => [
            'escalationCode' => NULL
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'escalationCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventEndSignal' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ],
            'signal' => [
              'type' => 'varchar',
              'maxLength' => 200,
              'noSpellCheck' => true
            ]
          ],
          'defaults' => [
            'signal' => NULL
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'signal'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateSignalThrow' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ],
            'signal' => [
              'type' => 'varchar',
              'maxLength' => 200,
              'noSpellCheck' => true
            ]
          ],
          'defaults' => [
            'signal' => NULL
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'signal'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateSignalCatch' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ],
            'signal' => [
              'type' => 'varchar',
              'maxLength' => 200,
              'view' => 'advanced:views/bpmn-flowchart-element/fields/signal',
              'noSpellCheck' => true
            ]
          ],
          'defaults' => [
            'signal' => NULL
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'signal'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateCompensationThrow' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ],
            'activityId' => [
              'type' => 'varchar',
              'maxLength' => 36,
              'tooltip' => 'compensateActivityId',
              'noSpellCheck' => true
            ]
          ],
          'defaults' => [
            'activityId' => NULL
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text'
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'activityId'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventEndCompensation' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ],
            'activityId' => [
              'type' => 'varchar',
              'maxLength' => 36,
              'tooltip' => 'compensateActivityId',
              'noSpellCheck' => true
            ]
          ],
          'defaults' => [
            'activityId' => NULL
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text'
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'activityId'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateMessageCatch' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ],
            'messageType' => [
              'type' => 'enum',
              'options' => 'Email'
            ],
            'repliedTo' => [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/message-replied-to'
            ],
            'relatedTo' => [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/message-related-to'
            ],
            'conditionsFormula' => [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/message-conditions-formula'
            ]
          ],
          'defaults' => [
            'repliedTo' => NULL,
            'relatedTo' => NULL,
            'messageType' => 'Email'
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'repliedTo'
                  ],
                  1 => false
                ],
                1 => [
                  0 => [
                    'name' => 'relatedTo'
                  ],
                  1 => false
                ],
                2 => [
                  0 => [
                    'name' => 'conditionsFormula'
                  ]
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'dynamicLogic' => [
            'fields' => [
              'relatedTo' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'isEmpty',
                      'attribute' => 'repliedTo'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateEscalationThrow' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ],
            'escalationCode' => [
              'type' => 'varchar',
              'maxLength' => 64,
              'noSpellCheck' => true
            ]
          ],
          'defaults' => [
            'escalationCode' => NULL
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'escalationCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateCompensationBoundary' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventIntermediateMessageBoundary' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ],
            'cancelActivity' => [
              'type' => 'bool'
            ],
            'messageType' => [
              'type' => 'enum',
              'options' => 'Email'
            ],
            'repliedTo' => [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/message-replied-to'
            ],
            'relatedTo' => [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/message-related-to'
            ],
            'conditionsFormula' => [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/message-conditions-formula'
            ]
          ],
          'defaults' => [
            'cancelActivity' => false,
            'repliedTo' => NULL,
            'relatedTo' => NULL,
            'messageType' => 'Email'
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'cancelActivity'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'repliedTo'
                  ],
                  1 => false
                ],
                1 => [
                  0 => [
                    'name' => 'relatedTo'
                  ],
                  1 => false
                ],
                2 => [
                  0 => [
                    'name' => 'conditionsFormula'
                  ]
                ]
              ]
            ],
            3 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'dynamicLogic' => [
            'fields' => [
              'relatedTo' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'isEmpty',
                      'attribute' => 'repliedTo'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateSignalBoundary' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ],
            'cancelActivity' => [
              'type' => 'bool'
            ],
            'signal' => [
              'type' => 'varchar',
              'maxLength' => 200,
              'view' => 'advanced:views/bpmn-flowchart-element/fields/signal',
              'noSpellCheck' => true
            ]
          ],
          'defaults' => [
            'signal' => NULL,
            'cancelActivity' => false
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'cancelActivity'
                  ],
                  1 => false
                ],
                1 => [
                  0 => [
                    'name' => 'signal'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateEscalationBoundary' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ],
            'cancelActivity' => [
              'type' => 'bool'
            ],
            'escalationCode' => [
              'type' => 'varchar',
              'maxLength' => 64,
              'noSpellCheck' => true
            ]
          ],
          'defaults' => [
            'errorCode' => NULL
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'cancelActivity'
                  ],
                  1 => false
                ],
                1 => [
                  0 => [
                    'name' => 'escalationCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateErrorBoundary' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ],
            'errorCode' => [
              'type' => 'varchar',
              'maxLength' => 64,
              'noSpellCheck' => true
            ]
          ],
          'defaults' => [
            'errorCode' => NULL
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'errorCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateConditionalBoundary' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ],
            'cancelActivity' => [
              'type' => 'bool'
            ],
            'conditions' => [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/conditions'
            ]
          ],
          'defaults' => [
            'cancelActivity' => false
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'cancelActivity'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'label' => 'Conditions',
              'name' => 'conditions',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'conditions',
                    'fullWidth' => true,
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            3 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateTimerBoundary' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ],
            'cancelActivity' => [
              'type' => 'bool'
            ],
            'timer' => [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/timer'
            ]
          ],
          'defaults' => [
            'cancelActivity' => false,
            'timerBase' => NULL,
            'timerShift' => 0,
            'timerShiftUnits' => 'minutes',
            'timerShiftOperator' => 'plus',
            'timerFormula' => NULL
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'cancelActivity'
                  ],
                  1 => false
                ],
                1 => [
                  0 => [
                    'name' => 'timer',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateConditionalCatch' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ],
            'conditions' => [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/conditions'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'label' => 'Conditions',
              'name' => 'conditions',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'conditions',
                    'fullWidth' => true,
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventIntermediateTimerCatch' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ],
            'timer' => [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/timer'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'timer',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'defaults' => [
            'timerBase' => NULL,
            'timerShift' => 0,
            'timerShiftUnits' => 'minutes',
            'timerShiftOperator' => 'plus',
            'timerFormula' => NULL
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'gatewayExclusive' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ],
            'defaultFlowId' => [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/default-flow-id'
            ],
            'flowsConditions' => [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/flows-conditions'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'name' => 'divergent',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'defaultFlowId'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'label' => 'Flows Conditions',
              'name' => 'flowsConditions',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'flowsConditions',
                    'fullWidth' => true,
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            3 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/gateway-exclusive-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/gateway-exclusive-edit'
        ],
        'gatewayInclusive' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ],
            'defaultFlowId' => [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/default-flow-id'
            ],
            'flowsConditions' => [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/flows-conditions'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'name' => 'divergent',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'defaultFlowId'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'label' => 'Flows Conditions',
              'name' => 'flowsConditions',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'flowsConditions',
                    'fullWidth' => true,
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            3 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/gateway-exclusive-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/gateway-exclusive-edit'
        ],
        'gatewayParallel' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'gatewayEventBased' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'task' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'actions' => [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/actions',
              'actionTypeList' => [
                0 => 'createEntity',
                1 => 'createRelatedEntity',
                2 => 'updateEntity',
                3 => 'updateRelatedEntity',
                4 => 'updateCreatedEntity',
                5 => 'updateProcessEntity',
                6 => 'relateWithEntity',
                7 => 'unrelateFromEntity',
                8 => 'applyAssignmentRule',
                9 => 'createNotification',
                10 => 'makeFollowed',
                11 => 'triggerWorkflow',
                12 => 'runService',
                13 => 'sendRequest',
                14 => 'executeFormula'
              ]
            ],
            'isolateVariables' => [
              'type' => 'bool',
              'tooltip' => true
            ],
            'returnVariableList' => [
              'type' => 'array',
              'noEmptyString' => true,
              'tooltip' => 'taskReturnVariableList'
            ],
            'description' => [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text'
                  ]
                ]
              ]
            ],
            1 => [
              'label' => 'Actions',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'actions',
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            2 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'isolateVariables'
                  ],
                  1 => [
                    'name' => 'returnVariableList'
                  ]
                ]
              ]
            ],
            3 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description'
                  ]
                ]
              ]
            ],
            4 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'id',
                    'options' => [
                      'readOnly' => true
                    ]
                  ],
                  1 => false
                ]
              ]
            ]
          ],
          'defaults' => [
            'text' => NULL,
            'isolateVariables' => false,
            'returnVariableList' => [],
            'description' => NULL
          ],
          'dynamicLogic' => [
            'fields' => [
              'returnVariableList' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isolateVariables'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'taskScript' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'formula' => [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-script-formula'
            ],
            'isolateVariables' => [
              'type' => 'bool',
              'tooltip' => true
            ],
            'returnVariableList' => [
              'type' => 'array',
              'noEmptyString' => true,
              'tooltip' => 'taskReturnVariableList'
            ],
            'description' => [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'formula',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            2 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'isolateVariables'
                  ],
                  1 => [
                    'name' => 'returnVariableList'
                  ]
                ]
              ]
            ],
            3 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            4 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'id',
                    'options' => [
                      'readOnly' => true
                    ]
                  ],
                  1 => false
                ]
              ]
            ]
          ],
          'defaults' => [
            'text' => NULL,
            'isolateVariables' => false,
            'returnVariableList' => [],
            'description' => NULL,
            'formula' => NULL
          ],
          'dynamicLogic' => [
            'fields' => [
              'returnVariableList' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isolateVariables'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'taskUser' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'name' => [
              'type' => 'varchar',
              'tooltip' => 'userTaskName'
            ],
            'instructions' => [
              'type' => 'text',
              'tooltip' => 'userTaskInstructions'
            ],
            'description' => [
              'type' => 'text'
            ],
            'actionType' => [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-user-action-type',
              'translation' => 'BpmnUserTask.options.actionType'
            ],
            'target' => [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-user-target',
              'tooltip' => true
            ],
            'assignmentType' => [
              'type' => 'enum',
              'options' => [
                0 => '',
                1 => 'processAssignedUser',
                2 => 'specifiedUser',
                3 => 'rule:Round-Robin',
                4 => 'rule:Least-Busy'
              ],
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-user-assignment-type'
            ],
            'targetUser' => [
              'type' => 'link',
              'entity' => 'User'
            ],
            'targetTeam' => [
              'type' => 'link',
              'entity' => 'Team'
            ],
            'targetUserPosition' => [
              'type' => 'enum',
              'entity' => 'Report',
              'view' => 'advanced:views/workflow/fields/target-user-position'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'actionType'
                  ],
                  1 => [
                    'name' => 'target'
                  ]
                ],
                1 => [
                  0 => [
                    'name' => 'name'
                  ],
                  1 => false
                ],
                2 => [
                  0 => [
                    'name' => 'instructions'
                  ]
                ],
                3 => [
                  0 => [
                    'name' => 'assignmentType'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'assignmentRule',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'targetUser'
                  ],
                  1 => false
                ],
                1 => [
                  0 => [
                    'name' => 'targetTeam'
                  ],
                  1 => [
                    'name' => 'targetUserPosition'
                  ]
                ]
              ]
            ],
            3 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            4 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'id',
                    'options' => [
                      'readOnly' => true
                    ]
                  ],
                  1 => false
                ]
              ]
            ]
          ],
          'defaults' => [
            'actionType' => 'Approve',
            'assignmentType' => 'processAssignedUser',
            'instructions' => NULL,
            'name' => NULL,
            'targetTeamId' => NULL,
            'target' => ''
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/task-user-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/task-user-edit'
        ],
        'taskSendMessage' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ],
            'messageType' => [
              'type' => 'enum',
              'options' => [
                0 => 'Email'
              ]
            ],
            'from' => [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-send-message-from',
              'options' => [
                0 => 'system',
                1 => 'specifiedEmailAddress',
                2 => 'processAssignedUser'
              ]
            ],
            'to' => [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-send-message-to',
              'options' => [
                0 => 'processAssignedUser',
                1 => 'specifiedTeams',
                2 => 'specifiedUsers',
                3 => 'specifiedContacts',
                4 => 'specifiedEmailAddress'
              ]
            ],
            'replyTo' => [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-send-message-reply-to',
              'options' => [
                0 => '',
                1 => 'system',
                2 => 'specifiedEmailAddress',
                3 => 'processAssignedUser'
              ]
            ],
            'cc' => [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-send-message-reply-to',
              'options' => [
                0 => '',
                1 => 'system',
                2 => 'specifiedEmailAddress',
                3 => 'processAssignedUser'
              ]
            ],
            'fromEmailAddress' => [
              'type' => 'varchar',
              'tooltip' => 'taskSendMessageFromEmailAddress'
            ],
            'toEmailAddress' => [
              'type' => 'varchar',
              'tooltip' => 'taskSendMessageEmailAddress'
            ],
            'replyToEmailAddress' => [
              'type' => 'varchar',
              'tooltip' => 'taskSendMessageEmailAddress'
            ],
            'ccEmailAddress' => [
              'type' => 'varchar',
              'tooltip' => 'taskSendMessageEmailAddress'
            ],
            'toSpecifiedTeams' => [
              'type' => 'linkMultiple',
              'entity' => 'Team'
            ],
            'toSpecifiedUsers' => [
              'type' => 'linkMultiple',
              'entity' => 'User'
            ],
            'toSpecifiedContacts' => [
              'type' => 'linkMultiple',
              'entity' => 'Contact'
            ],
            'emailTemplate' => [
              'type' => 'link',
              'entity' => 'EmailTemplate'
            ],
            'doNotStore' => [
              'type' => 'bool'
            ],
            'optOutLink' => [
              'type' => 'bool'
            ],
            'attachmentsVariable' => [
              'type' => 'varchar',
              'maxLength' => 64,
              'noSpellCheck' => true,
              'tooltip' => 'attachmentsVariable'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'messageType'
                  ],
                  1 => false
                ],
                1 => [
                  0 => [
                    'name' => 'from'
                  ],
                  1 => [
                    'name' => 'fromEmailAddress'
                  ]
                ],
                2 => [
                  0 => [
                    'name' => 'to'
                  ],
                  1 => [
                    'name' => 'toEmailAddress'
                  ]
                ],
                3 => [
                  0 => [
                    'name' => 'toSpecifiedTeams'
                  ],
                  1 => false
                ],
                4 => [
                  0 => [
                    'name' => 'toSpecifiedUsers'
                  ],
                  1 => false
                ],
                5 => [
                  0 => [
                    'name' => 'toSpecifiedContacts'
                  ],
                  1 => false
                ],
                6 => [
                  0 => [
                    'name' => 'cc'
                  ],
                  1 => [
                    'name' => 'ccEmailAddress'
                  ]
                ],
                7 => [
                  0 => [
                    'name' => 'replyTo'
                  ],
                  1 => [
                    'name' => 'replyToEmailAddress'
                  ]
                ],
                8 => [
                  0 => [
                    'name' => 'emailTemplate'
                  ],
                  1 => false
                ],
                9 => [
                  0 => [
                    'name' => 'doNotStore'
                  ],
                  1 => [
                    'name' => 'optOutLink'
                  ]
                ],
                10 => [
                  0 => [
                    'name' => 'attachmentsVariable'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            3 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'id',
                    'options' => [
                      'readOnly' => true
                    ]
                  ],
                  1 => false
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/task-send-message-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/task-send-message-edit',
          'defaults' => [
            'doNotStore' => false,
            'from' => 'system',
            'to' => 'processAssignedUser',
            'replyTo' => NULL,
            'cc' => NULL,
            'messageType' => 'Email',
            'optOutLink' => false,
            'attachmentsVariable' => NULL
          ]
        ],
        'callActivity' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'callableType' => [
              'type' => 'enum',
              'options' => [
                0 => 'Process'
              ],
              'required' => true
            ],
            'target' => [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/call-activity-target',
              'tooltip' => true
            ],
            'targetIdExpression' => [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/target-id-expression',
              'tooltip' => true
            ],
            'returnCollectionVariable' => [
              'type' => 'varchar',
              'tooltip' => true,
              'options' => [
                0 => 'resultCollection'
              ],
              'noSpellCheck' => true
            ],
            'isMultiInstance' => [
              'type' => 'bool'
            ],
            'isSequential' => [
              'type' => 'bool'
            ],
            'loopCollectionExpression' => [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/loop-collection-expression',
              'tooltip' => true
            ],
            'flowchart' => [
              'type' => 'link',
              'entity' => 'BpmnFlowchart',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/call-activity-flowchart'
            ],
            'returnVariableList' => [
              'type' => 'array',
              'noEmptyString' => true,
              'tooltip' => true
            ],
            'description' => [
              'type' => 'text'
            ]
          ],
          'defaults' => [
            'callableType' => 'Process',
            'target' => '',
            'returnVariableList' => [],
            'returnCollectionVariable' => NULL,
            'targetIdExpression' => NULL,
            'isMultiInstance' => false,
            'isSequential' => false
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'callableType'
                  ],
                  1 => false
                ],
                1 => [
                  0 => [
                    'name' => 'target'
                  ],
                  1 => false
                ],
                2 => [
                  0 => [
                    'name' => 'targetIdExpression'
                  ]
                ],
                3 => [
                  0 => [
                    'name' => 'flowchart'
                  ],
                  1 => false
                ],
                4 => [
                  0 => [
                    'name' => 'isMultiInstance'
                  ],
                  1 => false
                ],
                5 => [
                  0 => [
                    'name' => 'isSequential'
                  ],
                  1 => false
                ],
                6 => [
                  0 => [
                    'name' => 'loopCollectionExpression'
                  ]
                ],
                7 => [
                  0 => [
                    'name' => 'returnVariableList'
                  ],
                  1 => [
                    'name' => 'returnCollectionVariable'
                  ]
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            3 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'id',
                    'options' => [
                      'readOnly' => true
                    ]
                  ],
                  1 => false
                ]
              ]
            ]
          ],
          'dynamicLogic' => [
            'fields' => [
              'flowchart' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'callableType',
                      'value' => 'Process'
                    ]
                  ]
                ],
                'required' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'callableType',
                      'value' => 'Process'
                    ]
                  ]
                ]
              ],
              'returnVariableList' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'equals',
                      'attribute' => 'callableType',
                      'value' => 'Process'
                    ]
                  ]
                ]
              ],
              'loopCollectionExpression' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ],
                'required' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ]
              ],
              'returnCollectionVariable' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ]
              ],
              'isSequential' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ]
              ],
              'targetIdExpression' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'startsWith',
                      'attribute' => 'target',
                      'value' => 'record:'
                    ]
                  ]
                ],
                'required' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'startsWith',
                      'attribute' => 'target',
                      'value' => 'record:'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/call-activity-edit'
        ],
        'subProcess' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'target' => [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/sub-process-target',
              'tooltip' => true
            ],
            'targetType' => [
              'type' => 'varchar'
            ],
            'targetIdExpression' => [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/target-id-expression',
              'tooltip' => true
            ],
            'returnVariableList' => [
              'type' => 'array',
              'noEmptyString' => true,
              'tooltip' => true
            ],
            'returnCollectionVariable' => [
              'type' => 'varchar',
              'tooltip' => true,
              'options' => [
                0 => 'resultCollection'
              ],
              'noSpellCheck' => true
            ],
            'isExpanded' => [
              'type' => 'bool'
            ],
            'triggeredByEvent' => [
              'type' => 'bool'
            ],
            'isMultiInstance' => [
              'type' => 'bool'
            ],
            'isSequential' => [
              'type' => 'bool'
            ],
            'loopCollectionExpression' => [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/loop-collection-expression',
              'tooltip' => true
            ],
            'flowchartVisualization' => [
              'type' => 'base',
              'readOnly' => true,
              'view' => 'advanced:views/bpmn-flowchart-element/fields/sub-process-flowchart'
            ],
            'dataList' => [
              'type' => 'jsonArray'
            ],
            'description' => [
              'type' => 'text'
            ]
          ],
          'defaults' => [
            'isExpanded' => true,
            'triggeredByEvent' => false,
            'loopCollectionExpression' => NULL,
            'dataList' => [],
            'target' => '',
            'returnVariableList' => [],
            'returnCollectionVariable' => NULL,
            'targetIdExpression' => NULL,
            'isMultiInstance' => false,
            'isSequential' => false
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'target'
                  ],
                  1 => [
                    'name' => 'targetType'
                  ]
                ],
                1 => [
                  0 => [
                    'name' => 'targetIdExpression'
                  ]
                ],
                2 => [
                  0 => [
                    'name' => 'isMultiInstance'
                  ],
                  1 => false
                ],
                3 => [
                  0 => [
                    'name' => 'isSequential'
                  ],
                  1 => false
                ],
                4 => [
                  0 => [
                    'name' => 'loopCollectionExpression'
                  ]
                ],
                5 => [
                  0 => [
                    'name' => 'returnVariableList'
                  ],
                  1 => [
                    'name' => 'returnCollectionVariable'
                  ]
                ]
              ]
            ],
            2 => [
              'name' => 'flowchartVisualization',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'flowchartVisualization',
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            3 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            4 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'id',
                    'options' => [
                      'readOnly' => true
                    ]
                  ],
                  1 => false
                ]
              ]
            ]
          ],
          'dynamicLogic' => [
            'fields' => [
              'loopCollectionExpression' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ],
                'required' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ]
              ],
              'returnCollectionVariable' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ]
              ],
              'isSequential' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ]
              ],
              'targetIdExpression' => [
                'visible' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'startsWith',
                      'attribute' => 'target',
                      'value' => 'record:'
                    ]
                  ]
                ],
                'required' => [
                  'conditionGroup' => [
                    0 => [
                      'type' => 'startsWith',
                      'attribute' => 'target',
                      'value' => 'record:'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/sub-process-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/sub-process-edit'
        ],
        'eventSubProcess' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'target' => [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/sub-process-target',
              'tooltip' => true
            ],
            'targetType' => [
              'type' => 'varchar'
            ],
            'isExpanded' => [
              'type' => 'bool'
            ],
            'triggeredByEvent' => [
              'type' => 'bool'
            ],
            'flowchartVisualization' => [
              'type' => 'base',
              'readOnly' => true,
              'view' => 'advanced:views/bpmn-flowchart-element/fields/sub-process-flowchart'
            ],
            'dataList' => [
              'type' => 'jsonArray'
            ],
            'description' => [
              'type' => 'text'
            ]
          ],
          'defaults' => [
            'isExpanded' => true,
            'triggeredByEvent' => true,
            'dataList' => [],
            'target' => ''
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'target'
                  ],
                  1 => [
                    'name' => 'targetType'
                  ]
                ]
              ]
            ],
            2 => [
              'name' => 'flowchartVisualization',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'flowchartVisualization',
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            3 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/sub-process-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/sub-process-edit'
        ],
        'flow' => [
          'fields' => [
            'text' => [
              'type' => 'varchar'
            ],
            'description' => [
              'type' => 'text'
            ],
            'startDirection' => [
              'type' => 'enum',
              'options' => [
                0 => '',
                1 => 'r',
                2 => 'd',
                3 => 'l',
                4 => 'u'
              ],
              'view' => 'advanced:views/bpmn-flowchart-element/fields/start-direction'
            ]
          ],
          'layout' => [
            0 => [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => [
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'startDirection'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ]
      ]
    ],
    'BpmnFlowchartCategory' => [
      'controller' => 'controllers/record-tree',
      'collection' => 'collections/tree',
      'massUpdateDisabled' => true,
      'menu' => [
        'listTree' => [
          'buttons' => [
            0 => [
              'label' => 'List View',
              'link' => '#BpmnFlowchartCategory/list',
              'acl' => 'read'
            ],
            1 => [
              'labelTranslation' => 'Global.scopeNamesPlural.BpmnFlowchart',
              'link' => '#BpmnFlowchart',
              'acl' => 'read',
              'aclScope' => 'BpmnFlowchart'
            ]
          ]
        ],
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Tree View',
              'link' => '#BpmnFlowchartCategory',
              'acl' => 'read'
            ],
            1 => [
              'labelTranslation' => 'Global.scopeNamesPlural.BpmnFlowchart',
              'link' => '#BpmnFlowchart',
              'acl' => 'read',
              'aclScope' => 'BpmnFlowchart'
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'workflows' => [
          'create' => false
        ]
      ]
    ],
    'BpmnProcess' => [
      'controller' => 'controllers/record',
      'recordViews' => [
        'detail' => 'advanced:views/bpmn-process/record/detail',
        'edit' => 'advanced:views/bpmn-process/record/edit',
        'detailQuick' => 'advanced:views/bpmn-process/record/detail-quick',
        'editQuick' => 'advanced:views/bpmn-process/record/edit-quick',
        'list' => 'advanced:views/bpmn-process/record/list'
      ],
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'label' => 'Flowcharts',
              'link' => '#BpmnFlowchart',
              'acl' => 'read',
              'aclScope' => 'BpmnFlowchart'
            ],
            1 => [
              'label' => 'User Tasks',
              'link' => '#BpmnUserTask',
              'acl' => 'read',
              'aclScope' => 'BpmnUserTask'
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'endedAt' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Ended'
                ]
              ]
            ]
          ],
          'status' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'name' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'parentProcess' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'parentProcessId',
                  'data' => [
                    'field' => 'parentProcess'
                  ]
                ]
              ]
            ]
          ],
          'flowchartVisualization' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ],
                1 => [
                  'type' => 'and',
                  'value' => [
                    0 => [
                      'type' => 'notEquals',
                      'attribute' => 'status',
                      'value' => 'Created'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'targetType' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'flowchart' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'target' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'id'
                    ],
                    1 => [
                      'type' => 'isEmpty',
                      'attribute' => 'targetType',
                      'data' => [
                        'field' => 'targetType'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'flowNodes' => [
          'rowActionsView' => 'advanced:views/bpmn-flow-node/record/row-actions/default',
          'recordListView' => 'advanced:views/bpmn-flow-node/record/list',
          'select' => false,
          'create' => false,
          'unlinkDisabled' => true,
          'view' => 'advanced:views/bpmn-process/record/panels/flow-nodes'
        ],
        'userTasks' => [
          'rowActionsView' => 'views/record/row-actions/empty',
          'unlinkDisabled' => true,
          'select' => false,
          'create' => false
        ]
      ],
      'filterList' => [
        0 => 'actual',
        1 => 'ended'
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-cogs'
    ],
    'BpmnUserTask' => [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'recordViews' => [
        'detail' => 'advanced:views/bpmn-user-task/record/detail'
      ],
      'views' => [
        'detail' => 'advanced:views/bpmn-user-task/detail'
      ],
      'dynamicLogic' => [
        'options' => [
          'resolution' => [
            0 => [
              'optionList' => [
                0 => '',
                1 => 'Approved',
                2 => 'Rejected'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'actionType',
                  'value' => 'Approve'
                ]
              ]
            ],
            1 => [
              'optionList' => [
                0 => '',
                1 => 'Reviewed'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'actionType',
                  'value' => 'Review'
                ]
              ]
            ],
            2 => [
              'optionList' => [
                0 => '',
                1 => 'Completed',
                2 => 'Failed'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'actionType',
                  'value' => 'Accomplish'
                ]
              ]
            ]
          ]
        ],
        'fields' => [
          'resolution' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isResolved'
                    ],
                    1 => [
                      'type' => 'isTrue',
                      'attribute' => 'isCanceled'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'resolutionNote' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'resolution'
                ],
                1 => [
                  'type' => 'isFalse',
                  'attribute' => 'isFailed'
                ]
              ]
            ]
          ],
          'instructions' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'instructions'
                ]
              ]
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => 'actual',
        1 => [
          'name' => 'resolved',
          'style' => 'success'
        ],
        2 => [
          'name' => 'canceled'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-user-cog',
      'kanbanViewMode' => true,
      'color' => NULL
    ],
    'Report' => [
      'controller' => 'advanced:controllers/report',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'boolFilters' => [
        0 => 'onlyMy'
      ],
      'recordViews' => [
        'list' => 'advanced:views/report/record/list',
        'detail' => 'advanced:views/report/record/detail',
        'edit' => 'advanced:views/report/record/edit'
      ],
      'views' => [
        'list' => 'advanced:views/report/list',
        'result' => 'advanced:views/report/result',
        'detail' => 'advanced:views/report/detail'
      ],
      'modalViews' => [
        'select' => 'advanced:views/report/modals/select-records'
      ],
      'defaultSidePanelFieldLists' => [
        'detail' => [
          0 => ':assignedUser',
          1 => 'teams',
          2 => 'portals'
        ],
        'edit' => [
          0 => ':assignedUser',
          1 => 'teams',
          2 => 'portals'
        ]
      ],
      'createDisabled' => false,
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'label' => 'Create Joint Grid Report',
              'link' => '#Report/create/type=JointGrid',
              'acl' => 'create'
            ],
            1 => [
              'label' => 'Manage Categories',
              'link' => '#ReportCategory',
              'acl' => 'edit',
              'aclScope' => 'ReportCategory'
            ]
          ]
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'report',
            'label' => 'Report',
            'view' => 'advanced:views/report/record/panels/report'
          ]
        ]
      ],
      'filterList' => [
        0 => 'grid',
        1 => 'list'
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'emailSending',
            'label' => 'EmailSending',
            'view' => 'advanced:views/report/record/panels/email-sending',
            'options' => [
              'fields' => [
                0 => 'emailSendingInterval',
                1 => 'emailSendingSettingWeekdays',
                2 => 'emailSendingSettingDay',
                3 => 'emailSendingSettingMonth',
                4 => 'emailSendingTime',
                5 => 'emailSendingUsers',
                6 => 'emailSendingDoNotSendEmptyReport'
              ],
              'fieldList' => [
                0 => 'emailSendingInterval',
                1 => 'emailSendingSettingWeekdays',
                2 => 'emailSendingSettingDay',
                3 => 'emailSendingSettingMonth',
                4 => 'emailSendingTime',
                5 => 'emailSendingUsers',
                6 => 'emailSendingDoNotSendEmptyReport'
              ],
              'inlineEditDisabled' => true,
              'mode' => 'detail'
            ],
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'emailSending',
            'label' => 'EmailSending',
            'view' => 'views/record/panels/side',
            'options' => [
              'fields' => [
                0 => 'emailSendingInterval',
                1 => 'emailSendingSettingWeekdays',
                2 => 'emailSendingSettingDay',
                3 => 'emailSendingSettingMonth',
                4 => 'emailSendingTime',
                5 => 'emailSendingUsers',
                6 => 'emailSendingDoNotSendEmptyReport'
              ],
              'fieldList' => [
                0 => 'emailSendingInterval',
                1 => 'emailSendingSettingWeekdays',
                2 => 'emailSendingSettingDay',
                3 => 'emailSendingSettingMonth',
                4 => 'emailSendingTime',
                5 => 'emailSendingUsers',
                6 => 'emailSendingDoNotSendEmptyReport'
              ],
              'mode' => 'edit'
            ],
            'isForm' => true
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'applyAcl' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Grid'
                ]
              ]
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-chart-bar'
    ],
    'ReportCategory' => [
      'controller' => 'controllers/record-tree',
      'collection' => 'collections/tree',
      'menu' => [
        'listTree' => [
          'buttons' => [
            0 => [
              'label' => 'List View',
              'link' => '#ReportCategory/list',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => [
              'label' => 'Reports',
              'link' => '#Report',
              'acl' => 'read',
              'aclScope' => 'Report',
              'style' => 'default'
            ]
          ]
        ],
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Tree View',
              'link' => '#ReportCategory',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => [
              'label' => 'Reports',
              'link' => '#Report',
              'acl' => 'read',
              'aclScope' => 'Report',
              'style' => 'default'
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'reports' => [
          'create' => false
        ]
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => 'fas fa-check'
    ],
    'ReportFilter' => [
      'controller' => 'controllers/record',
      'dynamicHandler' => 'advanced:dynamic-handlers/report-filter',
      'views' => [
        'list' => 'advanced:views/report-filter/list'
      ],
      'recordViews' => [
        'list' => 'advanced:views/report-filter/record/list',
        'edit' => 'advanced:views/report-filter/record/edit',
        'editSmall' => 'advanced:views/report-filter/record/edit-small'
      ],
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Rebuild Filters',
              'name' => 'rebuildFilters',
              'action' => 'rebuildFilters'
            ]
          ]
        ]
      ],
      'defaultSidePanelFieldLists' => [
        'detail' => [],
        'edit' => [],
        'detailSmall' => [],
        'editSmall' => []
      ],
      'dynamicLogic' => [
        'fields' => [
          'report' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'entityType'
                ]
              ]
            ]
          ],
          'entityType' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'searchPanelDisabled' => true
    ],
    'ReportPanel' => [
      'controller' => 'controllers/record',
      'dynamicHandler' => 'advanced:dynamic-handlers/report-panel',
      'views' => [
        'list' => 'advanced:views/report-panel/list'
      ],
      'recordViews' => [
        'list' => 'advanced:views/report-panel/record/list',
        'edit' => 'advanced:views/report-panel/record/edit',
        'editSmall' => 'advanced:views/report-panel/record/edit-small'
      ],
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Rebuild Panels',
              'name' => 'rebuildPanels',
              'action' => 'rebuildPanels'
            ]
          ]
        ]
      ],
      'defaultSidePanelFieldLists' => [
        'detail' => [],
        'edit' => [],
        'detailSmall' => [],
        'editSmall' => []
      ],
      'dynamicLogic' => [
        'fields' => [
          'report' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'entityType'
                ]
              ]
            ]
          ],
          'entityType' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'searchPanelDisabled' => true
    ],
    'Workflow' => [
      'controller' => 'controllers/record',
      'recordViews' => [
        'detail' => 'advanced:views/workflow/record/detail',
        'edit' => 'advanced:views/workflow/record/edit',
        'list' => 'advanced:views/workflow/record/list'
      ],
      'views' => [
        'list' => 'advanced:views/workflow/list'
      ],
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'label' => 'Workflows Log',
              'link' => '#WorkflowLogRecord'
            ],
            1 => [
              'label' => 'Manage Categories',
              'link' => '#WorkflowCategory',
              'acl' => 'edit',
              'aclScope' => 'WorkflowCategory'
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => 'active'
      ],
      'dynamicLogic' => [
        'fields' => [
          'entityType' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'id'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'type' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'id'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'signalName' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'signal'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'signal'
                ]
              ]
            ]
          ],
          'manualLabel' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ]
          ],
          'manualTeams' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ]
          ],
          'manualDynamicLogic' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ],
                1 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'entityType'
                ]
              ]
            ]
          ],
          'manualAccessRequired' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ]
          ],
          'manualElementType' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ]
          ],
          'manualConfirmation' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ]
          ],
          'manualConfirmationText' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ],
                1 => [
                  'type' => 'isTrue',
                  'attribute' => 'manualConfirmation'
                ]
              ]
            ]
          ],
          'manualStyle' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ],
                1 => [
                  'type' => 'in',
                  'attribute' => 'manualElementType',
                  'value' => 'Button'
                ]
              ]
            ]
          ],
          'schedulingApplyTimezone' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'scheduled'
                ]
              ]
            ]
          ],
          'processOrder' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'afterRecordCreated',
                    1 => 'afterRecordUpdated',
                    2 => 'afterRecordSaved',
                    3 => 'scheduled',
                    4 => 'signal'
                  ]
                ]
              ]
            ]
          ]
        ],
        'panels' => [
          'manual' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ]
          ],
          'scheduled' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'scheduled'
                ]
              ]
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-code-commit'
    ],
    'WorkflowCategory' => [
      'controller' => 'controllers/record-tree',
      'collection' => 'collections/tree',
      'menu' => [
        'listTree' => [
          'buttons' => [
            0 => [
              'label' => 'List View',
              'link' => '#WorkflowCategory/list',
              'acl' => 'read'
            ],
            1 => [
              'label' => 'Workflows',
              'labelTranslation' => 'Global.scopeNamesPlural.Workflow',
              'link' => '#Workflow',
              'acl' => 'read',
              'aclScope' => 'Workflow'
            ]
          ]
        ],
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Tree View',
              'link' => '#WorkflowCategory',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => [
              'label' => 'Workflows',
              'labelTranslation' => 'Global.scopeNamesPlural.Workflow',
              'link' => '#Workflow',
              'acl' => 'read',
              'aclScope' => 'Workflow'
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'workflows' => [
          'create' => false
        ]
      ]
    ],
    'WorkflowLogRecord' => [
      'controller' => 'controllers/record',
      'views' => [
        'list' => 'advanced:views/workflow-log-record/list'
      ],
      'recordViews' => [
        'list' => 'advanced:views/workflow-log-record/record/list'
      ]
    ],
    'DeliveryOrder' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => [
          'name' => 'completed',
          'style' => 'success'
        ]
      ],
      'recordViews' => [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => [
        'lock' => [
          'aclScope' => 'DeliveryOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => [
          'aclScope' => 'DeliveryOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Quote.labels.Templates',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            3 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Warehouse',
              'link' => '#Warehouse',
              'acl' => 'read',
              'aclScope' => 'Warehouse',
              'configCheck' => 'warehousesEnabled'
            ],
            4 => [
              'labelTranslation' => 'Global.scopeNamesPlural.DeliveryOrderItem',
              'link' => '#DeliveryOrderItem',
              'acl' => 'read',
              'aclScope' => 'DeliveryOrderItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'isLocked' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'isHardLocked' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isHardLocked'
                ]
              ]
            ]
          ],
          'status' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'account' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'salesOrderId',
                      'data' => [
                        'field' => 'salesOrder'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'salesOrder' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'itemList' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => [
                      'type' => 'and',
                      'value' => [
                        0 => [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Completed'
                          ]
                        ],
                        1 => [
                          'type' => 'isTrue',
                          'attribute' => 'isDone'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'inventoryStatus' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'inventoryStatus'
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'inventoryTransactions' => [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ]
      ],
      'additionalLayouts' => [
        'detailBottomTotal' => [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => [
          'type' => 'list'
        ],
        'detailCreateFromSalesOrder' => [
          'type' => 'detail',
          'allFields' => true
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-shipping-fast'
    ],
    'DeliveryOrderItem' => [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.DeliveryOrder',
              'link' => '#DeliveryOrder',
              'acl' => 'read',
              'aclScope' => 'DeliveryOrder'
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'listItem' => [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ],
      'relationshipPanels' => [
        'inventoryNumber' => [
          'selectHandler' => 'sales:handlers/delivery-order-item/select-inventory-number',
          'createDisabled' => true,
          'selectLayout' => 'listForProduct',
          'selectOrderBy' => 'createdAt',
          'selectOrderDirection' => 'asc'
        ]
      ]
    ],
    'InventoryAdjustment' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'duplicateDisabled' => true,
      'filterList' => [
        0 => 'actual',
        1 => [
          'name' => 'completed',
          'style' => 'success'
        ]
      ],
      'recordViews' => [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => [
        'list' => [
          0 => 'sales:handlers/info'
        ],
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => [
        'lock' => [
          'aclScope' => 'Quote',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => [
          'aclScope' => 'Quote',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Warehouse',
              'link' => '#Warehouse',
              'acl' => 'read',
              'aclScope' => 'Warehouse',
              'configCheck' => 'warehousesEnabled'
            ],
            1 => [
              'labelTranslation' => 'Global.scopeNamesPlural.InventoryAdjustmentItem',
              'link' => '#InventoryAdjustmentItem',
              'acl' => 'read',
              'aclScope' => 'InventoryAdjustmentItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'isLocked' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'status' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isDone'
                ]
              ]
            ]
          ],
          'itemList' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isDone'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'inventoryTransactions' => [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ]
      ],
      'additionalLayouts' => [],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-plus-circle'
    ],
    'InventoryAdjustmentItem' => [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.InventoryAdjustment',
              'link' => '#InventoryAdjustment',
              'acl' => 'read',
              'aclScope' => 'InventoryAdjustment'
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'listItem' => [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ],
        'listForProduct' => [
          'type' => 'listSmall'
        ]
      ],
      'relationshipPanels' => [
        'inventoryNumber' => [
          'selectHandler' => 'sales:handlers/delivery-order-item/select-inventory-number',
          'selectLayout' => 'listForProduct',
          'createHandler' => 'sales:handlers/inventory-adjustment-item/create-inventory-number'
        ]
      ]
    ],
    'InventoryNumber' => [
      'controller' => 'controllers/record',
      'mergeDisabled' => true,
      'viewSetupHandlers' => [
        'list' => [
          0 => 'sales:handlers/info'
        ],
        'record/detail' => [
          0 => 'sales:handlers/inventory-number/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/inventory-number/setup-record-detail'
        ]
      ],
      'filterList' => [
        0 => [
          'name' => 'onHand'
        ]
      ],
      'menu' => [
        'detail' => [
          'buttons' => [
            0 => [
              'name' => 'viewHistory',
              'action' => 'viewHistory',
              'label' => 'View History',
              'data' => [
                'handler' => 'sales:handlers/inventory-number/view-history-handler'
              ]
            ]
          ]
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'warehousesQuantity',
            'label' => 'Warehouses',
            'view' => 'sales:views/inventory-number/record/panels/warehouses-quantity'
          ]
        ],
        'detailSmall' => [
          0 => [
            'name' => 'warehousesQuantity',
            'label' => 'Warehouses',
            'view' => 'sales:views/inventory-number/record/panels/warehouses-quantity'
          ]
        ]
      ],
      'relationshipPanels' => [
        'product' => [
          'createDisabled' => true,
          'selectMandatoryAttributeList' => [
            0 => 'inventoryNumberType',
            1 => 'expirationDays'
          ],
          'selectHandler' => 'sales:handlers/inventory-number/select-product',
          'selectPrimaryFilterName' => 'available',
          'selectFieldHandler' => 'sales:handlers/inventory-number/select-field-product'
        ],
        'inventoryTransactions' => [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'removeDisabled' => true,
          'editDisabled' => true,
          'createAttributeMap' => [
            'productId' => 'productId',
            'productName' => 'productName'
          ]
        ]
      ],
      'additionalLayouts' => [
        'listForProduct' => [
          'type' => 'listSmall'
        ],
        'listForTemplateProduct' => [
          'type' => 'listSmall'
        ],
        'listForWarehouse' => [
          'type' => 'listSmall'
        ]
      ],
      'dynamicLogic' => [
        'panels' => [
          'quantity' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'attribute' => 'id',
                  'type' => 'isNotEmpty'
                ]
              ]
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-barcode'
    ],
    'InventoryTransaction' => [
      'controller' => 'controllers/record',
      'viewSetupHandlers' => [
        'list' => [
          0 => 'sales:handlers/info'
        ]
      ],
      'relationshipPanels' => [
        'product' => [
          'selectPrimaryFilterName' => 'inventory',
          'createDisabled' => true
        ],
        'inventoryNumber' => [
          'selectHandler' => 'sales:handlers/inventory-transaction/select-inventory-number'
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'number' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'parent' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'inventoryNumber' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'Transfer',
                    1 => 'Reserve'
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'inlineEditDisabled' => true,
      'massUpdateDisabled' => true,
      'convertCurrencyDisabled' => true,
      'mergeDisabled' => true,
      'layoutMassUpdateDisabled' => true,
      'layoutBottomPanelsDetailDisabled' => true,
      'layoutSidePanelsDetailDisabled' => true,
      'layoutSidePanelsEditDisabled' => true,
      'layoutSidePanelsDetailSmallDisabled' => true,
      'layoutSidePanelsEditSmallDisabled' => true,
      'iconClass' => 'fas fa-retweet'
    ],
    'Invoice' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => [
          'name' => 'paid',
          'style' => 'success'
        ]
      ],
      'recordViews' => [
        'detail' => 'sales:views/invoice/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => [
        'lock' => [
          'aclScope' => 'Invoice',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => [
          'aclScope' => 'Invoice',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ],
        2 => [
          'name' => 'eInvoice',
          'label' => 'E-Invoice',
          'handler' => 'sales:handlers/invoice/e-invoice',
          'checkVisibilityFunction' => 'isAvailable',
          'actionFunction' => 'action',
          'groupIndex' => 6
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'relationshipPanels' => [
        'tax' => [
          'selectMandatoryAttributeList' => [
            0 => 'rate'
          ]
        ]
      ],
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Template',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Tax',
              'link' => '#Tax',
              'acl' => 'read',
              'aclScope' => 'Tax'
            ],
            3 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            4 => [
              'labelTranslation' => 'Global.scopeNamesPlural.InvoiceItem',
              'link' => '#InvoiceItem',
              'acl' => 'read',
              'aclScope' => 'InvoiceItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'isLocked' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'status' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'account' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'opportunityId',
                      'data' => [
                        'field' => 'opportunity'
                      ]
                    ],
                    1 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'quoteId',
                      'data' => [
                        'field' => 'quote'
                      ]
                    ],
                    2 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'salesOrderId',
                      'data' => [
                        'field' => 'salesOrder'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'quote' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'salesOrderId',
                      'data' => [
                        'field' => 'salesOrder'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'salesOrder' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'opportunity' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'quoteId',
                      'data' => [
                        'field' => 'quote'
                      ]
                    ],
                    1 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'salesOrderId',
                      'data' => [
                        'field' => 'salesOrder'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'itemList' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => [
                      'type' => 'and',
                      'value' => [
                        0 => [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Paid'
                          ]
                        ],
                        1 => [
                          'type' => 'isTrue',
                          'attribute' => 'isDone'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'detailBottomTotal' => [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => [
          'type' => 'list'
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-receipt'
    ],
    'InvoiceItem' => [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Invoices',
              'link' => '#Invoice',
              'acl' => 'read',
              'aclScope' => 'Invoice'
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'listItem' => [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ]
    ],
    'OpportunityItem' => [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/opportunity-item',
      'createDisabled' => true,
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Opportunities',
              'link' => '#Opportunity',
              'acl' => 'read',
              'aclScope' => 'Opportunity'
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'listItem' => [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ]
    ],
    'PriceBook' => [
      'controller' => 'controllers/record',
      'viewSetupHandlers' => [
        'list' => [
          0 => 'sales:handlers/info'
        ]
      ],
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ProductPrice',
              'link' => '#ProductPrice',
              'acl' => 'read',
              'aclScope' => 'ProductPrice',
              'configCheck' => 'priceBooksEnabled'
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'prices' => [
          'layout' => 'listForPriceBook',
          'unlinkDisabled' => true,
          'selectDisabled' => true,
          'filterList' => [
            0 => 'all',
            1 => 'active'
          ]
        ],
        'rules' => [
          'layout' => 'listForPriceBook',
          'unlinkDisabled' => true,
          'selectDisabled' => true,
          'filterList' => [
            0 => 'all',
            1 => 'active'
          ]
        ]
      ],
      'filterList' => [
        0 => 'active'
      ],
      'selectDefaultFilters' => [
        'filter' => 'active'
      ],
      'mergeDisabled' => true
    ],
    'PriceRule' => [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/price-rule',
      'filterList' => [
        0 => 'active'
      ],
      'textFilterDisabled' => true,
      'dynamicLogic' => [
        'fields' => [
          'supplier' => [
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'basedOn',
                  'value' => [
                    0 => 'Supplier'
                  ]
                ]
              ]
            ],
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'basedOn',
                  'value' => [
                    0 => 'Supplier'
                  ]
                ]
              ]
            ]
          ],
          'productCategory' => [
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'target',
                  'value' => [
                    0 => 'Product Category'
                  ]
                ]
              ]
            ],
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'target',
                  'value' => [
                    0 => 'Product Category'
                  ]
                ]
              ]
            ]
          ],
          'conditionSelect' => [
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'target',
                  'value' => [
                    0 => 'Conditional'
                  ]
                ]
              ]
            ],
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'target',
                  'value' => [
                    0 => 'Conditional'
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'mergeDisabled' => true
    ],
    'PriceRuleCondition' => [
      'controller' => 'controllers/record',
      'searchPanelDisabled' => true
    ],
    'Product' => [
      'controller' => 'controllers/record',
      'views' => [
        'list' => 'sales:views/product/list'
      ],
      'viewSetupHandlers' => [
        'record/detail' => [
          0 => 'sales:handlers/product/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/product/setup-record-detail'
        ]
      ],
      'modalViews' => [
        'select' => 'views/modals/select-records-with-categories'
      ],
      'detailActionList' => [
        0 => [
          'name' => 'viewPrice',
          'label' => 'View Price',
          'handler' => 'sales:handlers/product/view-price-action',
          'data' => [
            'handler' => 'sales:handlers/product/view-price-action'
          ],
          'actionFunction' => 'process',
          'checkVisibilityFunction' => 'isVisible',
          'configCheck' => 'priceBooksEnabled'
        ]
      ],
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'label' => 'Categories',
              'link' => '#ProductCategory',
              'acl' => 'edit',
              'aclScope' => 'ProductCategory'
            ],
            1 => [
              'label' => 'Brands',
              'link' => '#ProductBrand',
              'acl' => 'read',
              'aclScope' => 'ProductBrand'
            ],
            2 => [
              'labelTranslation' => 'Product.links.attributes',
              'link' => '#ProductAttribute',
              'acl' => 'read',
              'aclScope' => 'ProductAttribute'
            ],
            3 => false,
            4 => [
              'labelTranslation' => 'Global.scopeNamesPlural.PriceBook',
              'link' => '#PriceBook',
              'acl' => 'read',
              'aclScope' => 'PriceBook',
              'configCheck' => 'priceBooksEnabled'
            ],
            5 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Supplier',
              'link' => '#Supplier',
              'acl' => 'read',
              'aclScope' => 'Supplier'
            ],
            6 => false,
            7 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Warehouse',
              'link' => '#Warehouse',
              'acl' => 'read',
              'aclScope' => 'Warehouse',
              'configCheck' => 'warehousesEnabled'
            ],
            8 => [
              'labelTranslation' => 'Global.scopeNamesPlural.InventoryNumber',
              'link' => '#InventoryNumber',
              'acl' => 'read',
              'aclScope' => 'InventoryNumber',
              'configCheck' => 'inventoryTransactionsEnabled'
            ],
            9 => [
              'labelTranslation' => 'Global.scopeNamesPlural.InventoryAdjustment',
              'link' => '#InventoryAdjustment',
              'acl' => 'read',
              'aclScope' => 'InventoryAdjustment',
              'configCheck' => 'inventoryTransactionsEnabled'
            ],
            10 => false,
            11 => [
              'labelTranslation' => 'Global.scopeNamesPlural.InventoryTransaction',
              'link' => '#InventoryTransaction',
              'acl' => 'read',
              'aclScope' => 'InventoryTransaction',
              'configCheck' => 'inventoryTransactionsEnabled'
            ]
          ]
        ]
      ],
      'massActionList' => [
        0 => 'updatePrice'
      ],
      'checkAllResultMassActionList' => [
        0 => 'updatePrice'
      ],
      'massActionDefs' => [
        'updatePrice' => [
          'handler' => 'sales:handlers/product-price/mass-update-price',
          'initFunction' => 'init',
          'actionFunction' => 'process',
          'acl' => 'edit',
          'aclScope' => 'Product'
        ]
      ],
      'filterList' => [
        0 => 'available'
      ],
      'dynamicLogic' => [
        'fields' => [
          'pricingFactor' => [
            'visible' => NULL
          ],
          'unitPrice' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'notEquals',
                  'attribute' => 'pricingType',
                  'value' => 'Fixed'
                ]
              ]
            ]
          ],
          'inventoryNumberType' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'expirationDays' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'and',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isInventory'
                    ],
                    1 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'inventoryNumberType'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'removalStrategy' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'and',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isInventory'
                    ],
                    1 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'inventoryNumberType'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'quantity' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'quantityReserved' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'quantityOnHand' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'quantitySoftReserved' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'quantityInTransit' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'quantityOnOrder' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'type' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ],
        'panels' => [
          'inventoryNumbers' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'inventoryNumberType'
                ]
              ]
            ]
          ],
          'quantity' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'inventoryAdjustmentItems' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ],
                1 => [
                  'type' => 'notIn',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'Template'
                  ]
                ]
              ]
            ]
          ]
        ],
        'options' => [
          'type' => [
            0 => [
              'optionList' => [
                0 => 'Regular',
                1 => 'Template'
              ],
              'conditionGroup' => [
                0 => [
                  'type' => 'isEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'dynamicHandler' => 'sales:product-dynamic-handler',
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'warehousesQuantity',
            'label' => 'Warehouses',
            'view' => 'sales:views/product/record/panels/warehouses-quantity'
          ],
          1 => [
            'name' => 'orderItems',
            'label' => 'Orders',
            'view' => 'sales:views/product/record/panels/order-items',
            'recordListView' => 'sales:views/quote-item/record/list-union'
          ]
        ],
        'detailSmall' => [
          0 => [
            'name' => 'warehousesQuantity',
            'label' => 'Warehouses',
            'view' => 'sales:views/product/record/panels/warehouses-quantity'
          ]
        ]
      ],
      'relationshipPanels' => [
        'prices' => [
          'layout' => 'listForProduct',
          'unlinkDisabled' => true,
          'selectDisabled' => true,
          'createHandler' => 'sales:handlers/product/add-price',
          'filterList' => [
            0 => 'all',
            1 => 'active'
          ]
        ],
        'supplierPrices' => [
          'layout' => 'listForProduct',
          'unlinkDisabled' => true,
          'selectDisabled' => true,
          'filterList' => [
            0 => 'all',
            1 => 'active'
          ]
        ],
        'inventoryTransactions' => [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'inventoryNumbers' => [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'filterList' => [
            0 => 'all',
            1 => 'onHand'
          ],
          'layout' => 'listForProduct',
          'view' => 'sales:views/product/record/panels/inventory-numbers',
          'createHandler' => 'sales:handlers/product/create-inventory-number'
        ],
        'variants' => [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listVariant',
          'view' => 'sales:views/product/record/panels/variants',
          'primaryFilter' => 'allVariants',
          'filterList' => [
            0 => 'allVariants',
            1 => 'availableVariants'
          ],
          'orderBy' => 'variantOrder'
        ],
        'inventoryAdjustmentItems' => [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'removeDisabled' => true,
          'primaryFilter' => 'completed',
          'layout' => 'listForProduct',
          'orderBy' => 'createdAt',
          'orderDirection' => 'desc'
        ]
      ],
      'iconClass' => 'fas fa-cube',
      'additionalLayouts' => [
        'listForAdd' => [
          'type' => 'listSmall'
        ],
        'listForAddInventory' => [
          'type' => 'listSmall'
        ],
        'listForWarehouse' => [
          'type' => 'listSmall'
        ],
        'listVariant' => [
          'type' => 'listSmall'
        ]
      ],
      'kanbanViewMode' => false,
      'color' => NULL
    ],
    'ProductAttribute' => [
      'controller' => 'controllers/record',
      'recordViews' => [
        'list' => 'sales:views/product-attribute/record/list'
      ],
      'massRemoveDisabled' => true,
      'massUpdateDisabled' => true,
      'mergeDisabled' => true,
      'relationshipPanels' => [
        'options' => [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'view' => 'sales:views/product-attribute/record/panels/options',
          'recordListView' => 'sales:views/product-attribute-option/record/list-for-attribute',
          'rowActionsView' => 'sales:views/product-attribute/record/row-actions/default',
          'orderBy' => 'order',
          'orderDirection' => 'asc',
          'layout' => 'listForAttribute'
        ],
        'products' => [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'createDisabled' => true
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'order' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'ProductAttributeOption' => [
      'controller' => 'controllers/record',
      'massRemoveDisabled' => true,
      'massUpdateDisabled' => true,
      'mergeDisabled' => true,
      'relationshipPanels' => [
        'products' => [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'createDisabled' => true
        ],
        'productVariants' => [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'createDisabled' => true
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'order' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'ProductBrand' => [
      'controller' => 'controllers/record',
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => NULL,
      'relationshipPanels' => [
        'patchNotes' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'cPatchNotes' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ]
    ],
    'ProductCategory' => [
      'controller' => 'controllers/record-tree',
      'collection' => 'collections/tree',
      'menu' => [
        'listTree' => [
          'buttons' => [
            0 => [
              'label' => 'List View',
              'link' => '#ProductCategory/list',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => [
              'label' => 'Products',
              'link' => '#Product',
              'acl' => 'read',
              'aclScope' => 'Product',
              'style' => 'default'
            ]
          ]
        ],
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Tree View',
              'link' => '#ProductCategory',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => [
              'label' => 'Products',
              'link' => '#Product',
              'acl' => 'read',
              'aclScope' => 'Product',
              'style' => 'default'
            ]
          ]
        ]
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => NULL
    ],
    'ProductPrice' => [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/product-price',
      'filterList' => [
        0 => 'active'
      ],
      'textFilterDisabled' => true,
      'mergeDisabled' => true,
      'massActionList' => [
        0 => 'updatePrice'
      ],
      'checkAllResultMassActionList' => [
        0 => 'updatePrice'
      ],
      'massActionDefs' => [
        'updatePrice' => [
          'handler' => 'sales:handlers/product-price/mass-update-price',
          'initFunction' => 'init',
          'actionFunction' => 'process',
          'acl' => 'edit',
          'aclScope' => 'PriceBook'
        ]
      ]
    ],
    'PurchaseOrder' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => [
          'name' => 'completed',
          'style' => 'success'
        ]
      ],
      'recordViews' => [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => [
        'lock' => [
          'aclScope' => 'PurchaseOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => [
          'aclScope' => 'PurchaseOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => [
        'detail' => [
          'buttons' => [
            0 => [
              'name' => 'createReceipt',
              'action' => 'createReceipt',
              'label' => 'Create Receipt',
              'acl' => 'create',
              'aclScope' => 'ReceiptOrder',
              'iconHtml' => '<span class="fas fa-dolly-flatbed"></span>',
              'data' => [
                'handler' => 'sales:handlers/purchase-order/receipt-button'
              ],
              'initFunction' => 'init'
            ]
          ]
        ],
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Template',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Tax',
              'link' => '#Tax',
              'acl' => 'read',
              'aclScope' => 'Tax'
            ],
            3 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            4 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Supplier',
              'link' => '#Supplier',
              'acl' => 'read',
              'aclScope' => 'Supplier'
            ],
            5 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ReceiptOrder',
              'link' => '#ReceiptOrder',
              'acl' => 'read',
              'aclScope' => 'ReceiptOrder'
            ],
            6 => [
              'labelTranslation' => 'Global.scopeNamesPlural.PurchaseOrderItem',
              'link' => '#PurchaseOrderItem',
              'acl' => 'read',
              'aclScope' => 'PurchaseOrderItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'isLocked' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'status' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'itemList' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => [
                      'type' => 'and',
                      'value' => [
                        0 => [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Completed'
                          ]
                        ],
                        1 => [
                          'type' => 'isTrue',
                          'attribute' => 'isDone'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'inventoryTransactions' => [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ],
        'receiptOrders' => [
          'createAction' => 'createRelatedReceiptOrder',
          'view' => 'sales:views/purchase-order/record/panels/receipt-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'tax' => [
          'selectMandatoryAttributeList' => [
            0 => 'rate'
          ]
        ]
      ],
      'additionalLayouts' => [
        'detailBottomTotal' => [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => [
          'type' => 'list'
        ]
      ],
      'calculationHandler' => 'sales:purchase-order-calculation-handler',
      'iconClass' => 'fas fa-cart-plus fa-flip-horizontal'
    ],
    'PurchaseOrderItem' => [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Purchase Orders',
              'link' => '#PurchaseOrder',
              'acl' => 'read',
              'aclScope' => 'PurchaseOrder'
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'listItem' => [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ]
    ],
    'Quote' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => [
          'name' => 'approved',
          'style' => 'success'
        ]
      ],
      'recordViews' => [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => [
        'lock' => [
          'aclScope' => 'Quote',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => [
          'aclScope' => 'Quote',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Template',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Tax',
              'link' => '#Tax',
              'acl' => 'read',
              'aclScope' => 'Tax'
            ],
            3 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            4 => [
              'labelTranslation' => 'Global.scopeNamesPlural.QuoteItem',
              'link' => '#QuoteItem',
              'acl' => 'read',
              'aclScope' => 'QuoteItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'isLocked' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'status' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'dateInvoiced' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Approved'
                ]
              ]
            ]
          ],
          'account' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'opportunityId',
                      'data' => [
                        'field' => 'opportunity'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'itemList' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => [
                      'type' => 'and',
                      'value' => [
                        0 => [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Approved'
                          ]
                        ],
                        1 => [
                          'type' => 'isTrue',
                          'attribute' => 'isDone'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'inventoryStatus' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'inventoryStatus'
                ]
              ]
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'detailBottomTotal' => [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => [
          'type' => 'list'
        ]
      ],
      'relationshipPanels' => [
        'salesOrders' => [
          'createAction' => 'createRelatedSalesOrder',
          'view' => 'sales:views/quote/record/panels/sales-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'invoices' => [
          'createAction' => 'createRelatedInvoice',
          'view' => 'sales:views/quote/record/panels/invoices',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'tax' => [
          'selectMandatoryAttributeList' => [
            0 => 'rate'
          ]
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-file-invoice-dollar',
      'kanbanViewMode' => true,
      'color' => NULL
    ],
    'QuoteItem' => [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'convertCurrencyDisabled' => true,
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Quotes',
              'link' => '#Quote',
              'acl' => 'read',
              'aclScope' => 'Quote'
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'listItem' => [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ]
    ],
    'ReceiptOrder' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => [
          'name' => 'completed',
          'style' => 'success'
        ]
      ],
      'recordViews' => [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => [
        'lock' => [
          'aclScope' => 'ReceiptOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => [
          'aclScope' => 'ReceiptOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ],
        2 => [
          'handler' => 'sales:handlers/receipt-order/import-serial-numbers-button',
          'name' => 'importSerialNumbers',
          'label' => 'Import Serial Numbers',
          'acl' => 'edit',
          'checkVisibilityFunction' => 'isVisible'
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ],
          1 => [
            'name' => 'receivedItems',
            'label' => 'Received Inventory',
            'view' => 'sales:views/receipt-order/record/panels/received-items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ],
          1 => [
            'name' => 'receivedItems',
            'label' => 'Received Inventory',
            'view' => 'sales:views/receipt-order/record/panels/received-items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Quote.labels.Templates',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            3 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Warehouse',
              'link' => '#Warehouse',
              'acl' => 'read',
              'aclScope' => 'Warehouse',
              'configCheck' => 'warehousesEnabled'
            ],
            4 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ReceiptOrderItem',
              'link' => '#ReceiptOrderItem',
              'acl' => 'read',
              'aclScope' => 'ReceiptOrderItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'isLocked' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'isHardLocked' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isHardLocked'
                ]
              ]
            ]
          ],
          'account' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'purchaseOrderId',
                      'data' => [
                        'field' => 'purchaseOrder'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'returnOrder' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'id'
                    ],
                    1 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'purchaseOrderId',
                      'data' => [
                        'field' => 'purchaseOrder'
                      ]
                    ],
                    2 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'supplierId',
                      'data' => [
                        'field' => 'supplier'
                      ]
                    ]
                  ]
                ]
              ]
            ],
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'and',
                  'value' => [
                    0 => [
                      'type' => 'isEmpty',
                      'attribute' => 'purchaseOrderId',
                      'data' => [
                        'field' => 'purchaseOrder'
                      ]
                    ],
                    1 => [
                      'type' => 'isEmpty',
                      'attribute' => 'supplierId',
                      'data' => [
                        'field' => 'supplier'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'supplier' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'purchaseOrderId',
                      'data' => [
                        'field' => 'purchaseOrder'
                      ]
                    ]
                  ]
                ]
              ]
            ],
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isEmpty',
                  'attribute' => 'returnOrderId',
                  'data' => [
                    'field' => 'returnOrder'
                  ]
                ]
              ]
            ]
          ],
          'purchaseOrder' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ],
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isEmpty',
                  'attribute' => 'returnOrderId',
                  'data' => [
                    'field' => 'returnOrder'
                  ]
                ]
              ]
            ]
          ],
          'itemList' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => [
                      'type' => 'and',
                      'value' => [
                        0 => [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Completed'
                          ]
                        ],
                        1 => [
                          'type' => 'isTrue',
                          'attribute' => 'isDone'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'receivedItemList' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => [
                      'type' => 'and',
                      'value' => [
                        0 => [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Completed'
                          ]
                        ],
                        1 => [
                          'type' => 'isTrue',
                          'attribute' => 'isDone'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'inventoryTransactions' => [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ]
      ],
      'additionalLayouts' => [
        'detailBottomTotal' => [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => [
          'type' => 'list'
        ],
        'detailCreateFromPurchaseOrder' => [
          'type' => 'detail',
          'allFields' => true
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-truck-loading'
    ],
    'ReceiptOrderItem' => [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ReceiptOrder',
              'link' => '#ReceiptOrder',
              'acl' => 'read',
              'aclScope' => 'ReceiptOrder'
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'listItem' => [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ]
    ],
    'ReturnOrder' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => [
          'name' => 'completed',
          'style' => 'success'
        ]
      ],
      'recordViews' => [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => [
        'lock' => [
          'aclScope' => 'ReturnOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => [
          'aclScope' => 'ReturnOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => [
        'detail' => [
          'buttons' => [
            0 => [
              'name' => 'createReceipt',
              'action' => 'createReceipt',
              'label' => 'Create Receipt',
              'acl' => 'create',
              'aclScope' => 'ReceiptOrder',
              'iconHtml' => '<span class="fas fa-dolly-flatbed"></span>',
              'data' => [
                'handler' => 'sales:handlers/purchase-order/receipt-button'
              ],
              'initFunction' => 'init'
            ]
          ]
        ],
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Template',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            3 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ReturnOrderItem',
              'link' => '#ReturnOrderItem',
              'acl' => 'read',
              'aclScope' => 'ReturnOrderItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'isLocked' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'status' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'itemList' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => [
                      'type' => 'and',
                      'value' => [
                        0 => [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Completed'
                          ]
                        ],
                        1 => [
                          'type' => 'isTrue',
                          'attribute' => 'isDone'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'inventoryTransactions' => [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ],
        'receiptOrders' => [
          'createAction' => 'createRelatedReceiptOrder',
          'view' => 'sales:views/return-order/record/panels/receipt-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'tax' => [
          'selectMandatoryAttributeList' => [
            0 => 'rate'
          ]
        ]
      ],
      'additionalLayouts' => [
        'detailBottomTotal' => [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => [
          'type' => 'list'
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-arrow-alt-circle-left'
    ],
    'ReturnOrderItem' => [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ReturnOrder',
              'link' => '#ReturnOrder',
              'acl' => 'read',
              'aclScope' => 'ReturnOrder'
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'listItem' => [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ],
      'relationshipPanels' => [
        'inventoryNumber' => [
          'selectHandler' => 'sales:handlers/return-order-item/select-inventory-number',
          'createDisabled' => true,
          'selectLayout' => 'listForProduct'
        ]
      ]
    ],
    'SalesOrder' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => [
          'name' => 'completed',
          'style' => 'success'
        ]
      ],
      'recordViews' => [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => [
        'lock' => [
          'aclScope' => 'SalesOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => [
          'aclScope' => 'SalesOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => [
        'detail' => [
          'buttons' => [
            0 => [
              'name' => 'createDelivery',
              'action' => 'createDelivery',
              'label' => 'Create Delivery',
              'acl' => 'create',
              'aclScope' => 'DeliveryOrder',
              'iconHtml' => '<span class="fas fa-shipping-fast"></span>',
              'data' => [
                'handler' => 'sales:handlers/sales-order/delivery-button'
              ],
              'initFunction' => 'init'
            ]
          ]
        ],
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Template',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Tax',
              'link' => '#Tax',
              'acl' => 'read',
              'aclScope' => 'Tax'
            ],
            3 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            4 => [
              'labelTranslation' => 'Global.scopeNamesPlural.DeliveryOrder',
              'link' => '#DeliveryOrder',
              'acl' => 'read',
              'aclScope' => 'DeliveryOrder',
              'configCheck' => 'deliveryOrdersEnabled'
            ],
            5 => [
              'labelTranslation' => 'Global.scopeNamesPlural.SalesOrderItem',
              'link' => '#SalesOrderItem',
              'acl' => 'read',
              'aclScope' => 'SalesOrderItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'isLocked' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'isHardLocked' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isHardLocked'
                ]
              ]
            ]
          ],
          'status' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'dateInvoiced' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Completed'
                ]
              ]
            ]
          ],
          'account' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'opportunityId',
                      'data' => [
                        'field' => 'opportunity'
                      ]
                    ],
                    1 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'quoteId',
                      'data' => [
                        'field' => 'quote'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'opportunity' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isNotEmpty',
                      'attribute' => 'quoteId',
                      'data' => [
                        'field' => 'quote'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'quote' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'itemList' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => [
                      'type' => 'and',
                      'value' => [
                        0 => [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Completed'
                          ]
                        ],
                        1 => [
                          'type' => 'isTrue',
                          'attribute' => 'isDone'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'inventoryStatus' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'inventoryStatus'
                ]
              ]
            ]
          ],
          'isDeliveryCreated' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'detailBottomTotal' => [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => [
          'type' => 'list'
        ]
      ],
      'relationshipPanels' => [
        'invoices' => [
          'createAction' => 'createRelatedInvoice',
          'view' => 'sales:views/sales-order/record/panels/invoices',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'deliveryOrders' => [
          'createAction' => 'createRelatedDeliveryOrder',
          'view' => 'sales:views/sales-order/record/panels/delivery-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'returnOrders' => [
          'createAction' => 'createRelatedReturnOrder',
          'view' => 'sales:views/sales-order/record/panels/return-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'inventoryTransactions' => [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ],
        'tax' => [
          'selectMandatoryAttributeList' => [
            0 => 'rate'
          ]
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-file-invoice',
      'kanbanViewMode' => true,
      'color' => NULL
    ],
    'SalesOrderItem' => [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'label' => 'Sales Orders',
              'link' => '#SalesOrder',
              'acl' => 'read',
              'aclScope' => 'SalesOrder'
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'listItem' => [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ]
    ],
    'ShippingProvider' => [
      'controller' => 'controllers/record',
      'searchPanelDisabled' => false
    ],
    'Supplier' => [
      'controller' => 'controllers/record',
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.SupplierProductPrice',
              'link' => '#SupplierProductPrice',
              'acl' => 'read',
              'aclScope' => 'SupplierProductPrice'
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'purchaseOrders' => [
          'layout' => 'listForAccount',
          'unlinkDisabled' => true,
          'selectDisabled' => true
        ],
        'prices' => [
          'layout' => 'listForSupplier',
          'unlinkDisabled' => true,
          'selectDisabled' => true,
          'filterList' => [
            0 => 'all',
            1 => 'active'
          ]
        ]
      ],
      'filterList' => [
        0 => 'active'
      ],
      'selectDefaultFilters' => [
        'filter' => 'active'
      ]
    ],
    'SupplierProductPrice' => [
      'controller' => 'controllers/record',
      'filterList' => [
        0 => 'active'
      ],
      'textFilterDisabled' => true,
      'mergeDisabled' => true,
      'massActionList' => [
        0 => 'updatePrice'
      ],
      'checkAllResultMassActionList' => [
        0 => 'updatePrice'
      ],
      'massActionDefs' => [
        'updatePrice' => [
          'handler' => 'sales:handlers/product-price/mass-update-price',
          'initFunction' => 'init',
          'actionFunction' => 'process',
          'acl' => 'edit',
          'aclScope' => 'Supplier'
        ]
      ]
    ],
    'Tax' => [
      'controller' => 'controllers/record',
      'searchPanelDisabled' => true
    ],
    'TransferOrder' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => [
          'name' => 'completed',
          'style' => 'success'
        ]
      ],
      'recordViews' => [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => [
        'list' => [
          0 => 'sales:handlers/info'
        ],
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => [
        'lock' => [
          'aclScope' => 'TransferOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => [
          'aclScope' => 'TransferOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Quote.labels.Templates',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            3 => [
              'labelTranslation' => 'Global.scopeNamesPlural.Warehouse',
              'link' => '#Warehouse',
              'acl' => 'read',
              'aclScope' => 'Warehouse',
              'configCheck' => 'warehousesEnabled'
            ],
            4 => [
              'labelTranslation' => 'Global.scopeNamesPlural.TransferOrderItem',
              'link' => '#TransferOrderItem',
              'acl' => 'read',
              'aclScope' => 'TransferOrderItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => [
        'fields' => [
          'isLocked' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'isHardLocked' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isHardLocked'
                ]
              ]
            ]
          ],
          'status' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'itemList' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'or',
                  'value' => [
                    0 => [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => [
                      'type' => 'and',
                      'value' => [
                        0 => [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Completed'
                          ]
                        ],
                        1 => [
                          'type' => 'isTrue',
                          'attribute' => 'isDone'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'inventoryStatus' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'inventoryStatus'
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => [
        'inventoryTransactions' => [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ]
      ],
      'additionalLayouts' => [
        'detailBottomTotal' => [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => [
          'type' => 'list'
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-dolly fa-flip-horizontal'
    ],
    'TransferOrderItem' => [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => [
        'list' => [
          'buttons' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.TransferOrder',
              'link' => '#TransferOrder',
              'acl' => 'read',
              'aclScope' => 'TransferOrder'
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'listItem' => [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ],
      'relationshipPanels' => [
        'inventoryNumber' => [
          'selectHandler' => 'sales:handlers/delivery-order-item/select-inventory-number',
          'createDisabled' => true,
          'selectLayout' => 'listForProduct'
        ]
      ]
    ],
    'Warehouse' => [
      'controller' => 'controllers/record',
      'searchPanelDisabled' => false,
      'filterList' => [
        0 => 'active'
      ],
      'selectDefaultFilters' => [
        'filter' => 'active'
      ],
      'viewSetupHandlers' => [
        'list' => [
          0 => 'sales:handlers/info'
        ],
        'record/detail' => [
          0 => 'sales:handlers/warehouse/setup-record-detail'
        ]
      ],
      'mergeDisabled' => true,
      'menu' => [
        'list' => [
          'dropdown' => [
            0 => [
              'labelTranslation' => 'Global.scopeNamesPlural.TransferOrder',
              'link' => '#TransferOrder',
              'acl' => 'read',
              'aclScope' => 'TransferOrder'
            ]
          ]
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'products',
            'view' => 'sales:views/warehouse/record/panels/products'
          ],
          1 => [
            'name' => 'inventoryNumbers',
            'view' => 'sales:views/warehouse/record/panels/inventory-numbers'
          ]
        ]
      ],
      'relationshipPanels' => [
        'inventoryTransactions' => [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ]
      ],
      'iconClass' => 'fas fa-warehouse'
    ],
    'EblaForm' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'color' => '#55cfe0',
      'iconClass' => 'fas fa-link',
      'kanbanViewMode' => false,
      'dynamicLogic' => [
        'fields' => [
          'backgroundColor' => [
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isTrue',
                  'attribute' => 'isTransparent'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Analytics' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-chart-bar',
      'views' => [
        'detail' => 'custom:views/Analytics/detail'
      ],
      'kanbanViewMode' => false,
      'color' => '#00bbd0',
      'dynamicLogic' => [
        'fields' => [
          'appId' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'urlExterna',
                  'value' => '0'
                ]
              ]
            ]
          ],
          'params' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'urlExterna',
                  'value' => '0'
                ]
              ]
            ]
          ],
          'reportId' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'urlExterna',
                  'value' => '0'
                ]
              ]
            ]
          ],
          'workspace' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'urlExterna',
                  'value' => '0'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Api' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'views' => [
        'detail' => 'custom:views/Api/detail',
        'list' => 'custom:views/Api/list'
      ],
      'iconClass' => 'fas fa-code'
    ],
    'Assessment' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-bullseye',
      'views' => [
        'detail' => 'custom:views/Assessment/detail'
      ],
      'kanbanViewMode' => false,
      'color' => NULL
    ],
    'CDashboardAccess' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => 'fas fa-magnifying-glass'
    ],
    'CImporter' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-download',
      'kanbanViewMode' => false,
      'color' => NULL,
      'dynamicLogic' => [
        'fields' => [
          'inputFile' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'country'
                ]
              ]
            ]
          ],
          'templateURL' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'country',
                  'value' => 'Brazil'
                ]
              ]
            ]
          ],
          'templateURLmexico' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'country',
                  'value' => 'Mexico'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'CPatchNotes' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-angle-right',
      'relationshipPanels' => [
        'productBrands' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ]
    ],
    'CRecommendations' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-bookmark',
      'kanbanViewMode' => false,
      'color' => NULL,
      'relationshipPanels' => [
        'recommendationsConfig' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'account' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ]
    ],
    'CRecommendationsConfig' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'far fa-bookmark',
      'relationshipPanels' => [
        'account' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'recommendations' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ],
      'kanbanViewMode' => false,
      'color' => NULL
    ],
    'CRegistration' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'sidePanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ]
      ],
      'bottomPanels' => [
        'detail' => [
          0 => [
            'name' => 'activities',
            'reference' => 'activities',
            'disabled' => true
          ],
          1 => [
            'name' => 'history',
            'reference' => 'history',
            'disabled' => true
          ]
        ]
      ],
      'color' => '#00bbd0',
      'iconClass' => 'fas fa-user-check',
      'dynamicLogic' => [
        'fields' => [
          'mpnID' => [
            'visible' => NULL,
            'required' => NULL
          ],
          'tenantID' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customer'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customer'
                ]
              ]
            ]
          ],
          'customerName' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customer'
                ]
              ]
            ],
            'required' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customer'
                ]
              ]
            ]
          ],
          'customerRegistered' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customer'
                ],
                1 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'customerRegisteredId',
                  'data' => [
                    'field' => 'customerRegistered'
                  ]
                ]
              ]
            ]
          ],
          'resellerRegistered' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'resellerRegisteredId',
                  'data' => [
                    'field' => 'resellerRegistered'
                  ]
                ]
              ]
            ]
          ],
          'portalUser' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'portalUserId',
                  'data' => [
                    'field' => 'portalUser'
                  ]
                ]
              ]
            ]
          ],
          'contactRegistered' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'contactRegisteredId',
                  'data' => [
                    'field' => 'contactRegistered'
                  ]
                ]
              ]
            ]
          ],
          'approved' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'notIn',
                  'attribute' => 'status',
                  'value' => [
                    0 => 'Created',
                    1 => 'Blocked',
                    2 => 'Canceled'
                  ]
                ]
              ]
            ],
            'readOnly' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'status',
                  'value' => [
                    0 => 'Created',
                    1 => 'Approved',
                    2 => 'Pending',
                    3 => 'Done',
                    4 => 'Canceled',
                    5 => 'Blocked'
                  ]
                ]
              ]
            ]
          ],
          'portalLink' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'in',
                  'attribute' => 'status',
                  'value' => [
                    0 => 'Pending',
                    1 => 'Done',
                    2 => 'Approved',
                    3 => 'Blocked'
                  ]
                ],
                1 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'portalLink'
                ]
              ]
            ]
          ],
          'description' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'description'
                ]
              ]
            ]
          ],
          'isActive' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'portalUserId',
                  'data' => [
                    'field' => 'portalUser'
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'additionalLayouts' => [
        'cadastro-4customers' => [
          'type' => 'detail'
        ]
      ],
      'relationshipPanels' => [
        'resellerRegistered' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'customerRegistered' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'contactRegistered' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'portalUser' => [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ]
    ],
    'CSecurityAlertSettings' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-gears',
      'dynamicLogic' => [
        'fields' => [
          'currentDescription' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'alerts',
                  'value' => 'currentMonth'
                ]
              ]
            ]
          ],
          'lastDescription' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'has',
                  'attribute' => 'alerts',
                  'value' => 'lastMonth'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'CspUsage' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ]
    ],
    'Monitoring' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-exclamation',
      'kanbanViewMode' => true,
      'color' => NULL,
      'dynamicLogic' => [
        'fields' => [
          'subscriptions' => [
            'visible' => NULL
          ],
          'resourceGroups' => [
            'visible' => NULL
          ]
        ]
      ]
    ],
    'OrderManager' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'views' => [
        'detail' => 'custom:views/OrderManager/detail',
        'list' => 'custom:views/OrderManager/list'
      ],
      'iconClass' => 'fas fa-shopping-cart'
    ],
    'PartnerID' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'color' => NULL,
      'iconClass' => 'fas fa-barcode',
      'kanbanViewMode' => false
    ],
    'QnA' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'views' => [
        'detail' => 'custom:views/QnA/detail'
      ],
      'iconClass' => 'fas fa-question-circle'
    ],
    'Recommendation' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'kanbanViewMode' => true,
      'color' => NULL,
      'iconClass' => 'far fa-bell'
    ],
    'ResourceCategory' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => 'fas fa-check',
      'dynamicLogic' => [
        'fields' => [
          'contacts' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'monitoringId',
                  'data' => [
                    'field' => 'monitoring'
                  ]
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'ResourceGroup' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => 'fas fa-check-circle',
      'dynamicLogic' => [
        'fields' => [
          'responsible' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'monitoringId',
                  'data' => [
                    'field' => 'monitoring'
                  ]
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Rocket' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'views' => [
        'list' => 'custom:views/Rocket/list'
      ],
      'kanbanViewMode' => false,
      'color' => '#00bbd0',
      'iconClass' => 'far fa-money-bill-alt'
    ],
    'Subscriptions' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => 'fas fa-wind',
      'dynamicLogic' => [
        'fields' => [
          'responsible' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'monitoringId',
                  'data' => [
                    'field' => 'monitoring'
                  ]
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Tags' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => 'far fa-caret-square-right',
      'dynamicLogic' => [
        'fields' => [
          'contacts' => [
            'visible' => [
              'conditionGroup' => [
                0 => [
                  'type' => 'isNotEmpty',
                  'attribute' => 'monitoringId',
                  'data' => [
                    'field' => 'monitoring'
                  ]
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Tutorial' => [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'views' => [
        'list' => 'custom:views/Tutorial/list',
        'detail' => 'custom:views/Tutorial/detail'
      ],
      'kanbanViewMode' => false,
      'color' => '#00bbd0',
      'iconClass' => 'fas fa-book-open'
    ]
  ],
  'dashlets' => [
    'Emails' => [
      'view' => 'views/dashlets/emails',
      'aclScope' => 'Email',
      'entityType' => 'Email',
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'folder' => [
            'type' => 'enum',
            'view' => 'views/dashlets/fields/emails/folder'
          ]
        ],
        'defaults' => [
          'orderBy' => 'dateSent',
          'order' => 'desc',
          'displayRecords' => 5,
          'folder' => NULL,
          'expandedLayout' => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'subject',
                  'link' => true
                ]
              ],
              1 => [
                0 => [
                  'name' => 'dateSent',
                  'view' => 'views/fields/datetime-short'
                ],
                1 => [
                  'name' => 'personStringData',
                  'view' => 'views/email/fields/person-string-data-for-expanded'
                ]
              ]
            ]
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'displayRecords'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ],
              2 => [
                0 => [
                  'name' => 'folder'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ],
      'accessDataList' => [
        0 => [
          'inPortalDisabled' => true
        ]
      ]
    ],
    'Iframe' => [
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar'
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'url' => [
            'type' => 'url',
            'required' => true
          ]
        ],
        'defaults' => [
          'autorefreshInterval' => 0
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'url'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Memo' => [
      'view' => 'views/dashlets/memo',
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar'
          ],
          'text' => [
            'type' => 'text'
          ]
        ],
        'defaults' => [],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'text'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Records' => [
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => [
            'type' => 'int',
            'min' => 1,
            'max' => 40
          ],
          'entityType' => [
            'type' => 'enum',
            'view' => 'views/dashlets/fields/records/entity-type',
            'translation' => 'Global.scopeNames'
          ],
          'primaryFilter' => [
            'type' => 'enum',
            'view' => 'views/dashlets/fields/records/primary-filter'
          ],
          'boolFilterList' => [
            'type' => 'multiEnum',
            'view' => 'views/dashlets/fields/records/bool-filter-list'
          ],
          'sortBy' => [
            'type' => 'enum',
            'view' => 'views/dashlets/fields/records/sort-by'
          ],
          'sortDirection' => [
            'type' => 'enum',
            'view' => 'views/dashlets/fields/records/sort-direction',
            'options' => [
              0 => 'asc',
              1 => 'desc'
            ],
            'translation' => 'DashletOptions.options.sortDirection'
          ],
          'expandedLayout' => [
            'type' => 'base',
            'view' => 'views/dashlets/fields/records/expanded-layout'
          ]
        ],
        'defaults' => [
          'displayRecords' => 10,
          'autorefreshInterval' => 0.5,
          'expandedLayout' => [
            'rows' => []
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'entityType'
                ],
                1 => false
              ],
              2 => [
                0 => [
                  'name' => 'primaryFilter'
                ],
                1 => [
                  'name' => 'sortBy'
                ]
              ],
              3 => [
                0 => [
                  'name' => 'boolFilterList'
                ],
                1 => [
                  'name' => 'sortDirection'
                ]
              ],
              4 => [
                0 => [
                  'name' => 'displayRecords'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ],
              5 => [
                0 => [
                  'name' => 'expandedLayout'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ]
    ],
    'Stream' => [
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'skipOwn' => [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'defaults' => [
          'displayRecords' => 10,
          'autorefreshInterval' => 0.5,
          'skipOwn' => false
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'displayRecords'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ],
              2 => [
                0 => [
                  'name' => 'skipOwn'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ]
    ],
    'Activities' => [
      'view' => 'crm:views/dashlets/activities',
      'options' => [
        'view' => 'crm:views/dashlets/options/activities',
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'enabledScopeList' => [
            'type' => 'multiEnum',
            'translation' => 'Global.scopeNamesPlural',
            'required' => true
          ],
          'displayRecords' => [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'futureDays' => [
            'type' => 'int',
            'min' => 0,
            'required' => true
          ],
          'includeShared' => [
            'type' => 'bool'
          ]
        ],
        'defaults' => [
          'displayRecords' => 10,
          'autorefreshInterval' => 0.5,
          'futureDays' => 3,
          'enabledScopeList' => [
            0 => 'Meeting',
            1 => 'Call',
            2 => 'Task'
          ],
          'includeShared' => false
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'displayRecords'
                ],
                1 => [
                  'name' => 'enabledScopeList'
                ]
              ],
              2 => [
                0 => [
                  'name' => 'futureDays'
                ],
                1 => [
                  'name' => 'includeShared'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Calendar' => [
      'view' => 'crm:views/dashlets/calendar',
      'aclScope' => 'Calendar',
      'options' => [
        'view' => 'crm:views/dashlets/options/calendar',
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'enabledScopeList' => [
            'type' => 'multiEnum',
            'translation' => 'Global.scopeNamesPlural',
            'required' => true
          ],
          'mode' => [
            'type' => 'enum',
            'options' => [
              0 => 'basicWeek',
              1 => 'agendaWeek',
              2 => 'timeline',
              3 => 'month',
              4 => 'basicDay',
              5 => 'agendaDay'
            ]
          ],
          'users' => [
            'type' => 'linkMultiple',
            'entity' => 'User',
            'view' => 'crm:views/calendar/fields/users',
            'sortable' => true
          ],
          'teams' => [
            'type' => 'linkMultiple',
            'entity' => 'Team',
            'view' => 'crm:views/calendar/fields/teams'
          ]
        ],
        'defaults' => [
          'autorefreshInterval' => 0.5,
          'mode' => 'basicWeek',
          'enabledScopeList' => [
            0 => 'Meeting',
            1 => 'Call',
            2 => 'Task'
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'mode'
                ],
                1 => [
                  'name' => 'enabledScopeList'
                ]
              ],
              2 => [
                0 => [
                  'name' => 'users'
                ],
                1 => false
              ],
              3 => [
                0 => [
                  'name' => 'teams'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ],
      'accessDataList' => [
        0 => [
          'inPortalDisabled' => true
        ]
      ]
    ],
    'Calls' => [
      'view' => 'crm:views/dashlets/calls',
      'aclScope' => 'Call',
      'entityType' => 'Call',
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'expandedLayout' => [
            'type' => 'base',
            'view' => 'views/dashlets/fields/records/expanded-layout'
          ]
        ],
        'defaults' => [
          'orderBy' => 'dateStart',
          'order' => 'asc',
          'displayRecords' => 5,
          'populateAssignedUser' => true,
          'expandedLayout' => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'name',
                  'link' => true
                ]
              ],
              1 => [
                0 => [
                  'name' => 'dateStart'
                ],
                1 => [
                  'name' => 'parent'
                ]
              ]
            ]
          ],
          'searchData' => [
            'bool' => [
              'onlyMy' => true
            ],
            'primary' => 'planned',
            'advanced' => [
              1 => [
                'type' => 'or',
                'value' => [
                  1 => [
                    'type' => 'today',
                    'field' => 'dateStart',
                    'dateTime' => true
                  ],
                  2 => [
                    'type' => 'future',
                    'field' => 'dateEnd',
                    'dateTime' => true
                  ],
                  3 => [
                    'type' => 'lastXDays',
                    'field' => 'dateStart',
                    'value' => 5,
                    'dateTime' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'displayRecords'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ],
              2 => [
                0 => [
                  'name' => 'expandedLayout'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ],
      'accessDataList' => [
        0 => [
          'inPortalDisabled' => true
        ]
      ]
    ],
    'Cases' => [
      'view' => 'views/dashlets/abstract/record-list',
      'aclScope' => 'Case',
      'entityType' => 'Case',
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'expandedLayout' => [
            'type' => 'base',
            'view' => 'views/dashlets/fields/records/expanded-layout'
          ]
        ],
        'defaults' => [
          'orderBy' => 'number',
          'order' => 'desc',
          'displayRecords' => 5,
          'populateAssignedUser' => true,
          'expandedLayout' => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'number'
                ],
                1 => [
                  'name' => 'name',
                  'link' => true
                ],
                2 => [
                  'name' => 'type'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'status'
                ],
                1 => [
                  'name' => 'priority'
                ],
                2 => [
                  'name' => 'account'
                ]
              ]
            ]
          ],
          'searchData' => [
            'bool' => [
              'onlyMy' => true
            ],
            'primary' => 'open'
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'displayRecords'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ],
              2 => [
                0 => [
                  'name' => 'expandedLayout'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ]
    ],
    'Leads' => [
      'view' => 'views/dashlets/abstract/record-list',
      'aclScope' => 'Lead',
      'entityType' => 'Lead',
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'expandedLayout' => [
            'type' => 'base',
            'view' => 'views/dashlets/fields/records/expanded-layout'
          ]
        ],
        'defaults' => [
          'orderBy' => 'createdAt',
          'order' => 'desc',
          'displayRecords' => 5,
          'populateAssignedUser' => true,
          'expandedLayout' => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'name',
                  'link' => true
                ],
                1 => [
                  'name' => 'addressCity'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'status'
                ],
                1 => [
                  'name' => 'source'
                ]
              ]
            ]
          ],
          'searchData' => [
            'bool' => [
              'onlyMy' => true
            ],
            'primary' => 'actual'
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'displayRecords'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ],
              2 => [
                0 => [
                  'name' => 'expandedLayout'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ]
    ],
    'Meetings' => [
      'view' => 'crm:views/dashlets/meetings',
      'aclScope' => 'Meeting',
      'entityType' => 'Meeting',
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'expandedLayout' => [
            'type' => 'base',
            'view' => 'views/dashlets/fields/records/expanded-layout'
          ]
        ],
        'defaults' => [
          'orderBy' => 'dateStart',
          'order' => 'asc',
          'displayRecords' => 5,
          'populateAssignedUser' => true,
          'expandedLayout' => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'name',
                  'link' => true
                ]
              ],
              1 => [
                0 => [
                  'name' => 'dateStart'
                ],
                1 => [
                  'name' => 'parent'
                ]
              ]
            ]
          ],
          'searchData' => [
            'bool' => [
              'onlyMy' => true
            ],
            'primary' => 'planned',
            'advanced' => [
              1 => [
                'type' => 'or',
                'value' => [
                  1 => [
                    'type' => 'today',
                    'field' => 'dateStart',
                    'dateTime' => true
                  ],
                  2 => [
                    'type' => 'future',
                    'field' => 'dateEnd',
                    'dateTime' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'displayRecords'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ],
              2 => [
                0 => [
                  'name' => 'expandedLayout'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ],
      'accessDataList' => [
        0 => [
          'inPortalDisabled' => true
        ]
      ]
    ],
    'Opportunities' => [
      'view' => 'views/dashlets/abstract/record-list',
      'aclScope' => 'Opportunity',
      'entityType' => 'Opportunity',
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'expandedLayout' => [
            'type' => 'base',
            'view' => 'views/dashlets/fields/records/expanded-layout'
          ]
        ],
        'defaults' => [
          'orderBy' => 'closeDate',
          'order' => 'asc',
          'displayRecords' => 5,
          'populateAssignedUser' => true,
          'expandedLayout' => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'name',
                  'link' => true
                ]
              ],
              1 => [
                0 => [
                  'name' => 'stage'
                ],
                1 => [
                  'name' => 'amount'
                ]
              ]
            ]
          ],
          'searchData' => [
            'bool' => [
              'onlyMy' => true
            ],
            'primary' => 'open'
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'displayRecords'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ],
              2 => [
                0 => [
                  'name' => 'expandedLayout'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ]
    ],
    'OpportunitiesByLeadSource' => [
      'view' => 'crm:views/dashlets/opportunities-by-lead-source',
      'aclScope' => 'Opportunity',
      'options' => [
        'view' => 'crm:views/dashlets/options/chart',
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'dateFrom' => [
            'type' => 'date',
            'required' => true
          ],
          'dateTo' => [
            'type' => 'date',
            'required' => true
          ],
          'dateFilter' => [
            'type' => 'enum',
            'options' => [
              0 => 'currentYear',
              1 => 'currentQuarter',
              2 => 'currentMonth',
              3 => 'currentFiscalYear',
              4 => 'currentFiscalQuarter',
              5 => 'ever',
              6 => 'between'
            ],
            'default' => 'currentYear',
            'translation' => 'Global.options.dateSearchRanges'
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'dateFilter'
                ],
                1 => false
              ],
              2 => [
                0 => [
                  'name' => 'dateFrom'
                ],
                1 => [
                  'name' => 'dateTo'
                ]
              ]
            ]
          ]
        ],
        'defaults' => [
          'dateFilter' => 'currentYear'
        ]
      ]
    ],
    'OpportunitiesByStage' => [
      'view' => 'crm:views/dashlets/opportunities-by-stage',
      'aclScope' => 'Opportunity',
      'options' => [
        'view' => 'crm:views/dashlets/options/chart',
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'dateFrom' => [
            'type' => 'date',
            'required' => true
          ],
          'dateTo' => [
            'type' => 'date',
            'required' => true
          ],
          'dateFilter' => [
            'type' => 'enum',
            'options' => [
              0 => 'currentYear',
              1 => 'currentQuarter',
              2 => 'currentMonth',
              3 => 'currentFiscalYear',
              4 => 'currentFiscalQuarter',
              5 => 'ever',
              6 => 'between'
            ],
            'default' => 'currentYear',
            'translation' => 'Global.options.dateSearchRanges'
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'dateFilter'
                ],
                1 => false
              ],
              2 => [
                0 => [
                  'name' => 'dateFrom'
                ],
                1 => [
                  'name' => 'dateTo'
                ]
              ]
            ]
          ]
        ],
        'defaults' => [
          'dateFilter' => 'currentYear'
        ]
      ]
    ],
    'SalesByMonth' => [
      'view' => 'crm:views/dashlets/sales-by-month',
      'aclScope' => 'Opportunity',
      'options' => [
        'view' => 'crm:views/dashlets/options/chart',
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'dateFrom' => [
            'type' => 'date',
            'required' => true
          ],
          'dateTo' => [
            'type' => 'date',
            'required' => true
          ],
          'dateFilter' => [
            'type' => 'enum',
            'options' => [
              0 => 'currentYear',
              1 => 'currentQuarter',
              2 => 'currentFiscalYear',
              3 => 'currentFiscalQuarter',
              4 => 'between'
            ],
            'default' => 'currentYear',
            'translation' => 'Global.options.dateSearchRanges'
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'dateFilter'
                ],
                1 => false
              ],
              2 => [
                0 => [
                  'name' => 'dateFrom'
                ],
                1 => [
                  'name' => 'dateTo'
                ]
              ]
            ]
          ]
        ],
        'defaults' => [
          'dateFilter' => 'currentYear'
        ]
      ]
    ],
    'SalesPipeline' => [
      'view' => 'crm:views/dashlets/sales-pipeline',
      'aclScope' => 'Opportunity',
      'options' => [
        'view' => 'crm:views/dashlets/options/sales-pipeline',
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'dateFrom' => [
            'type' => 'date',
            'required' => true
          ],
          'dateTo' => [
            'type' => 'date',
            'required' => true
          ],
          'dateFilter' => [
            'type' => 'enum',
            'options' => [
              0 => 'currentYear',
              1 => 'currentQuarter',
              2 => 'currentMonth',
              3 => 'currentFiscalYear',
              4 => 'currentFiscalQuarter',
              5 => 'ever',
              6 => 'between'
            ],
            'default' => 'currentYear',
            'translation' => 'Global.options.dateSearchRanges'
          ],
          'useLastStage' => [
            'type' => 'bool'
          ],
          'team' => [
            'type' => 'link',
            'entity' => 'Team',
            'view' => 'crm:views/dashlets/options/sales-pipeline/fields/team'
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title',
                  'span' => 2
                ]
              ],
              1 => [
                0 => [
                  'name' => 'dateFilter'
                ],
                1 => [
                  'name' => 'useLastStage'
                ]
              ],
              2 => [
                0 => [
                  'name' => 'dateFrom'
                ],
                1 => [
                  'name' => 'dateTo'
                ]
              ],
              3 => [
                0 => [
                  'name' => 'team'
                ],
                1 => false
              ]
            ]
          ]
        ],
        'defaults' => [
          'dateFilter' => 'currentYear',
          'teamId' => NULL,
          'teamName' => NULL
        ]
      ]
    ],
    'Tasks' => [
      'view' => 'crm:views/dashlets/tasks',
      'aclScope' => 'Task',
      'entityType' => 'Task',
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'expandedLayout' => [
            'type' => 'base',
            'view' => 'views/dashlets/fields/records/expanded-layout'
          ]
        ],
        'defaults' => [
          'orderBy' => 'dateUpcoming',
          'order' => 'asc',
          'displayRecords' => 5,
          'expandedLayout' => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'name',
                  'link' => true
                ]
              ],
              1 => [
                0 => [
                  'name' => 'status'
                ],
                1 => [
                  'name' => 'dateEnd'
                ],
                2 => [
                  'name' => 'parent'
                ]
              ]
            ]
          ],
          'searchData' => [
            'bool' => [
              'onlyMy' => true
            ],
            'primary' => 'actualStartingNotInFuture'
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'displayRecords'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ],
              2 => [
                0 => [
                  'name' => 'expandedLayout',
                  'fullWidth' => true
                ]
              ]
            ]
          ]
        ]
      ],
      'accessDataList' => [
        0 => [
          'inPortalDisabled' => true
        ]
      ]
    ],
    'BpmnUserTasks' => [
      'view' => 'advanced:views/dashlets/bpmn-user-tasks',
      'aclScope' => 'BpmnUserTask',
      'entityType' => 'BpmnUserTask',
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => [
            'type' => 'enumInt',
            'options' => [
              0 => 3,
              1 => 4,
              2 => 5,
              3 => 10,
              4 => 15,
              5 => 20,
              6 => 30
            ]
          ],
          'expandedLayout' => [
            'type' => 'base',
            'view' => 'views/dashlets/fields/records/expanded-layout'
          ]
        ],
        'defaults' => [
          'orderBy' => 'createdAt',
          'order' => 'desc',
          'displayRecords' => 5,
          'expandedLayout' => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'name',
                  'link' => true
                ]
              ]
            ]
          ],
          'searchData' => [
            'bool' => [
              'onlyMy' => true
            ],
            'primary' => 'actual'
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'displayRecords'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ],
              2 => [
                0 => [
                  'name' => 'expandedLayout'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ]
    ],
    'Report' => [
      'view' => 'advanced:views/dashlets/report',
      'aclScope' => 'Report',
      'options' => [
        'view' => 'advanced:views/dashlets/options/report',
        'fields' => [
          'title' => [
            'type' => 'varchar'
          ],
          'report' => [
            'type' => 'link',
            'entity' => 'Report',
            'required' => true,
            'view' => 'advanced:views/report/fields/dashlet-select'
          ],
          'column' => [
            'type' => 'enum',
            'options' => []
          ],
          'displayType' => [
            'type' => 'enum',
            'default' => '',
            'options' => [
              0 => '',
              1 => 'Chart',
              2 => 'List',
              3 => 'Chart-Total',
              4 => 'Total',
              5 => 'Table'
            ],
            'translation' => 'Report.options.dashletDisplayType',
            'view' => 'advanced:views/dashlets/fields/display-type'
          ],
          'useSiMultiplier' => [
            'type' => 'bool'
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ]
        ],
        'defaults' => [
          'autorefreshInterval' => 0,
          'useSiMultiplier' => true,
          'displayType' => ''
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => [
                  'name' => 'report'
                ],
                1 => [
                  'name' => 'column'
                ]
              ],
              2 => [
                0 => [
                  'name' => 'autorefreshInterval'
                ],
                1 => false
              ],
              3 => [
                0 => [
                  'name' => 'displayType'
                ],
                1 => false
              ],
              4 => [
                0 => [
                  'name' => 'useSiMultiplier'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ]
    ],
    'Rocket' => [
      'view' => 'custom:views/Rocket/detail',
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'ClientID' => [
            'type' => 'varchar',
            'required' => true
          ],
          'ClientSecret' => [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ],
                1 => [
                  'name' => 'autorefreshInterval'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'bluesky' => [
      'view' => 'custom:views/dashlets/bluesky',
      'aclScope' => 'Account',
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'blueskydataanalytics' => [
      'view' => 'custom:views/dashlets/blueskydataanalytics',
      'aclScope' => 'Account',
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'home-4customers' => [
      'view' => 'custom:views/dashlets/home-4customers',
      'aclScope' => 'Account',
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'reports' => [
      'view' => 'custom:views/dashlets/reports',
      'aclScope' => 'Account',
      'options' => [
        'fields' => [
          'title' => [
            'type' => 'varchar',
            'required' => true
          ],
          'altura' => [
            'type' => 'varchar',
            'required' => true
          ],
          'url' => [
            'type' => 'varchar',
            'required' => false
          ]
        ],
        'layout' => [
          0 => [
            'rows' => [
              0 => [
                0 => [
                  'name' => 'title'
                ],
                1 => [
                  'name' => 'altura'
                ],
                2 => [
                  'name' => 'url'
                ]
              ]
            ]
          ]
        ]
      ]
    ]
  ],
  'entityAcl' => [
    'AppSecret' => [
      'fields' => [
        'value' => [
          'internal' => true
        ]
      ]
    ],
    'Attachment' => [
      'fields' => [
        'storage' => [
          'readOnly' => true
        ],
        'source' => [
          'readOnly' => true
        ],
        'sourceId' => [
          'readOnly' => true
        ]
      ]
    ],
    'AuthLogRecord' => [
      'fields' => [
        'username' => [
          'readOnly' => true
        ],
        'portal' => [
          'readOnly' => true
        ],
        'user' => [
          'readOnly' => true
        ],
        'ipAddress' => [
          'readOnly' => true
        ],
        'authToken' => [
          'readOnly' => true
        ],
        'isDenied' => [
          'readOnly' => true
        ],
        'denialReason' => [
          'readOnly' => true
        ],
        'microtime' => [
          'readOnly' => true
        ],
        'requestUrl' => [
          'readOnly' => true
        ],
        'requestMethod' => [
          'readOnly' => true
        ]
      ]
    ],
    'AuthToken' => [
      'fields' => [
        'hash' => [
          'forbidden' => true,
          'readOnly' => true
        ],
        'token' => [
          'forbidden' => true,
          'readOnly' => true
        ],
        'secret' => [
          'forbidden' => true,
          'readOnly' => true
        ],
        'portal' => [
          'readOnly' => true
        ],
        'user' => [
          'readOnly' => true
        ],
        'ipAddress' => [
          'readOnly' => true
        ],
        'lastAccess' => [
          'readOnly' => true
        ],
        'createdAt' => [
          'readOnly' => true
        ],
        'modifiedAt' => [
          'readOnly' => true
        ]
      ]
    ],
    'Email' => [
      'fields' => [
        'users' => [
          'readOnly' => true
        ],
        'messageId' => [
          'readOnly' => true
        ],
        'tasks' => [
          'readOnly' => true
        ]
      ],
      'links' => [
        'users' => [
          'nonAdminReadOnly' => true
        ],
        'tasks' => [
          'readOnly' => true
        ]
      ]
    ],
    'EmailAccount' => [
      'fields' => [
        'password' => [
          'internal' => true
        ],
        'smtpPassword' => [
          'internal' => true
        ],
        'imapHandler' => [
          'forbidden' => true
        ],
        'smtpHandler' => [
          'forbidden' => true
        ],
        'fetchData' => [
          'readOnly' => true
        ]
      ]
    ],
    'InboundEmail' => [
      'fields' => [
        'password' => [
          'internal' => true
        ],
        'smtpPassword' => [
          'internal' => true
        ],
        'imapHandler' => [
          'internal' => true
        ],
        'smtpHandler' => [
          'internal' => true
        ],
        'fetchData' => [
          'readOnly' => true
        ]
      ]
    ],
    'Note' => [
      'links' => [
        'teams' => [
          'readOnly' => true
        ],
        'users' => [
          'readOnly' => true
        ]
      ]
    ],
    'Preferences' => [
      'fields' => [
        'data' => [
          'forbidden' => true
        ]
      ]
    ],
    'User' => [
      'fields' => [
        'userName' => [
          'nonAdminReadOnly' => true
        ],
        'apiKey' => [
          'onlyAdmin' => true,
          'readOnly' => true,
          'nonAdminReadOnly' => true
        ],
        'password' => [
          'internal' => true,
          'nonAdminReadOnly' => true
        ],
        'passwordConfirm' => [
          'internal' => true,
          'nonAdminReadOnly' => true
        ],
        'authLogRecordId' => [
          'forbidden' => true
        ],
        'authMethod' => [
          'onlyAdmin' => true
        ],
        'secretKey' => [
          'readOnly' => true,
          'onlyAdmin' => true
        ],
        'isActive' => [
          'nonAdminReadOnly' => true
        ],
        'emailAddress' => [
          'nonAdminReadOnly' => true
        ],
        'teams' => [
          'nonAdminReadOnly' => true
        ],
        'defaultTeam' => [
          'nonAdminReadOnly' => true
        ],
        'roles' => [
          'nonAdminReadOnly' => true
        ],
        'portals' => [
          'nonAdminReadOnly' => true
        ],
        'portalRoles' => [
          'nonAdminReadOnly' => true
        ],
        'contact' => [
          'nonAdminReadOnly' => true
        ],
        'workingTimeCalendar' => [
          'nonAdminReadOnly' => true
        ],
        'layoutSet' => [
          'onlyAdmin' => true
        ],
        'accounts' => [
          'nonAdminReadOnly' => true
        ],
        'type' => [
          'nonAdminReadOnly' => true
        ],
        'auth2FA' => [
          'onlyAdmin' => true
        ],
        'userData' => [
          'forbidden' => true
        ],
        'deleteId' => [
          'forbidden' => true
        ]
      ],
      'links' => [
        'teams' => [
          'nonAdminReadOnly' => true
        ],
        'roles' => [
          'onlyAdmin' => true
        ],
        'workingTimeRanges' => [
          'nonAdminReadOnly' => true
        ],
        'portalRoles' => [
          'onlyAdmin' => true
        ],
        'accounts' => [
          'onlyAdmin' => true
        ],
        'defaultTeam' => [
          'onlyAdmin' => true
        ],
        'dashboardTemplate' => [
          'onlyAdmin' => true
        ],
        'userData' => [
          'forbidden' => true
        ]
      ]
    ],
    'Webhook' => [
      'fields' => [
        'user' => [
          'onlyAdmin' => true
        ],
        'secretKey' => [
          'readOnly' => true
        ]
      ]
    ],
    'Case' => [
      'fields' => [
        'inboundEmail' => [
          'readOnly' => true
        ]
      ],
      'links' => [
        'inboundEmail' => [
          'readOnly' => true
        ],
        'collaborators' => [
          'readOnly' => true
        ]
      ]
    ],
    'Contact' => [
      'fields' => [
        'inboundEmail' => [
          'readOnly' => true
        ],
        'portalUser' => [
          'readOnly' => true
        ]
      ]
    ],
    'KnowledgeBaseArticle' => [
      'fields' => [
        'order' => [
          'readOnly' => true
        ]
      ]
    ],
    'Task' => [
      'fields' => [
        'email' => [
          'readOnly' => true
        ]
      ],
      'links' => [
        'collaborators' => [
          'readOnly' => true
        ]
      ]
    ],
    'BpmnFlowchart' => [
      'fields' => [
        'elementsDataHash' => [
          'readOnly' => true
        ],
        'eventStartIdList' => [
          'readOnly' => true
        ]
      ]
    ],
    'BpmnProcess' => [
      'fields' => [
        'flowchartElementsDataHash' => [
          'readOnly' => true
        ],
        'workflowId' => [
          'readOnly' => true
        ],
        'parentProcess' => [
          'readOnly' => true
        ],
        'flowchartData' => [
          'readOnly' => true
        ],
        'createdEntitiesData' => [
          'readOnly' => true
        ],
        'variables' => [
          'readOnly' => true
        ],
        'endedAt' => [
          'readOnly' => true
        ],
        'status' => [
          'readOnly' => true
        ],
        'parentProcessFlowNode' => [
          'readOnly' => true
        ]
      ],
      'links' => [
        'parentProcess' => [
          'readOnly' => true
        ],
        'childProcesses' => [
          'readOnly' => true
        ]
      ]
    ],
    'Report' => [
      'fields' => [
        'internalClassName' => [
          'internal' => true
        ]
      ],
      'links' => [
        'portals' => [
          'internal' => true
        ]
      ]
    ],
    'Workflow' => [
      'fields' => [
        'isInternal' => [
          'readOnly' => true
        ]
      ]
    ],
    'DeliveryOrder' => [
      'links' => [
        'inventoryTransactions' => [
          'readOnly' => true
        ],
        'items' => [
          'readOnly' => true
        ]
      ]
    ],
    'InventoryAdjustment' => [
      'links' => [
        'inventoryTransactions' => [
          'readOnly' => true
        ],
        'items' => [
          'readOnly' => true
        ]
      ]
    ],
    'InventoryNumber' => [
      'links' => [
        'inventoryTransactions' => [
          'readOnly' => true
        ]
      ]
    ],
    'Invoice' => [
      'links' => [
        'items' => [
          'readOnly' => true
        ]
      ]
    ],
    'Product' => [
      'links' => [
        'prices' => [
          'readOnly' => true
        ],
        'supplierPrices' => [
          'readOnly' => true
        ],
        'inventoryTransactions' => [
          'readOnly' => true
        ],
        'attributes' => [
          'readOnly' => true
        ],
        'attributeOptions' => [
          'readOnly' => true
        ],
        'variantAttributeOptions' => [
          'readOnly' => true
        ],
        'variants' => [
          'readOnly' => true
        ],
        'inventoryAdjustmentItems' => [
          'readOnly' => true
        ]
      ]
    ],
    'ProductAttribute' => [
      'links' => [
        'products' => [
          'readOnly' => true
        ]
      ]
    ],
    'ProductAttributeOption' => [
      'links' => [
        'products' => [
          'readOnly' => true
        ],
        'productVariants' => [
          'readOnly' => true
        ]
      ]
    ],
    'PurchaseOrder' => [
      'links' => [
        'inventoryTransactions' => [
          'readOnly' => true
        ],
        'receiptOrders' => [
          'readOnly' => true
        ],
        'items' => [
          'readOnly' => true
        ]
      ]
    ],
    'Quote' => [
      'links' => [
        'items' => [
          'readOnly' => true
        ]
      ]
    ],
    'ReceiptOrder' => [
      'links' => [
        'inventoryTransactions' => [
          'readOnly' => true
        ],
        'items' => [
          'readOnly' => true
        ],
        'receivedItems' => [
          'readOnly' => true
        ]
      ]
    ],
    'ReturnOrder' => [
      'links' => [
        'receiptOrders' => [
          'readOnly' => true
        ],
        'items' => [
          'readOnly' => true
        ]
      ]
    ],
    'SalesOrder' => [
      'links' => [
        'inventoryTransactions' => [
          'readOnly' => true
        ],
        'deliveryOrders' => [
          'readOnly' => true
        ],
        'items' => [
          'readOnly' => true
        ]
      ]
    ],
    'TransferOrder' => [
      'links' => [
        'inventoryTransactions' => [
          'readOnly' => true
        ],
        'items' => [
          'readOnly' => true
        ]
      ]
    ],
    'Warehouse' => [
      'links' => [
        'inventoryTransactions' => [
          'readOnly' => true
        ]
      ]
    ]
  ],
  'entityDefs' => [
    'ActionHistoryRecord' => [
      'fields' => [
        'number' => [
          'type' => 'autoincrement',
          'index' => true,
          'dbType' => 'bigint'
        ],
        'targetType' => [
          'type' => 'varchar',
          'view' => 'views/action-history-record/fields/target-type',
          'translation' => 'Global.scopeNames'
        ],
        'target' => [
          'type' => 'linkParent',
          'view' => 'views/action-history-record/fields/target'
        ],
        'data' => [
          'type' => 'jsonObject'
        ],
        'action' => [
          'type' => 'enum',
          'options' => [
            0 => 'read',
            1 => 'update',
            2 => 'create',
            3 => 'delete'
          ]
        ],
        'createdAt' => [
          'type' => 'datetime',
          'hasSeconds' => true
        ],
        'user' => [
          'type' => 'link',
          'view' => 'views/fields/user'
        ],
        'userType' => [
          'type' => 'foreign',
          'link' => 'user',
          'field' => 'type',
          'view' => 'views/fields/foreign-enum',
          'notStorable' => true
        ],
        'ipAddress' => [
          'type' => 'varchar',
          'maxLength' => 39
        ],
        'authToken' => [
          'type' => 'link'
        ],
        'authLogRecord' => [
          'type' => 'link'
        ]
      ],
      'links' => [
        'user' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'target' => [
          'type' => 'belongsToParent'
        ],
        'authToken' => [
          'type' => 'belongsTo',
          'entity' => 'AuthToken',
          'foreignName' => 'id',
          'foreign' => 'actionHistoryRecords'
        ],
        'authLogRecord' => [
          'type' => 'belongsTo',
          'entity' => 'AuthLogRecord',
          'foreignName' => 'id',
          'foreign' => 'actionHistoryRecords'
        ]
      ],
      'collection' => [
        'orderBy' => 'number',
        'order' => 'desc',
        'textFilterFields' => [
          0 => 'ipAddress',
          1 => 'userName'
        ],
        'countDisabled' => true,
        'sortBy' => 'number',
        'asc' => false
      ],
      'hooksDisabled' => true
    ],
    'AddressCountry' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 100
        ],
        'code' => [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 2,
          'tooltip' => true,
          'pattern' => '[A-Z]{2}',
          'sanitizerClassNameList' => [
            0 => 'Espo\\Classes\\FieldSanitizers\\StringUpperCase'
          ],
          'options' => [
            0 => 'AF',
            1 => 'AX',
            2 => 'AL',
            3 => 'DZ',
            4 => 'AS',
            5 => 'AD',
            6 => 'AO',
            7 => 'AI',
            8 => 'AQ',
            9 => 'AG',
            10 => 'AR',
            11 => 'AM',
            12 => 'AW',
            13 => 'AU',
            14 => 'AT',
            15 => 'AZ',
            16 => 'BS',
            17 => 'BH',
            18 => 'BD',
            19 => 'BB',
            20 => 'BY',
            21 => 'BE',
            22 => 'BZ',
            23 => 'BJ',
            24 => 'BM',
            25 => 'BT',
            26 => 'BO',
            27 => 'BA',
            28 => 'BW',
            29 => 'BV',
            30 => 'BR',
            31 => 'IO',
            32 => 'BN',
            33 => 'BG',
            34 => 'BF',
            35 => 'BI',
            36 => 'KH',
            37 => 'CM',
            38 => 'CA',
            39 => 'CV',
            40 => 'KY',
            41 => 'CF',
            42 => 'TD',
            43 => 'CL',
            44 => 'CN',
            45 => 'CX',
            46 => 'CC',
            47 => 'CO',
            48 => 'KM',
            49 => 'CG',
            50 => 'CD',
            51 => 'CK',
            52 => 'CR',
            53 => 'CI',
            54 => 'HR',
            55 => 'CU',
            56 => 'CY',
            57 => 'CZ',
            58 => 'DK',
            59 => 'DJ',
            60 => 'DM',
            61 => 'DO',
            62 => 'EC',
            63 => 'EG',
            64 => 'SV',
            65 => 'GQ',
            66 => 'ER',
            67 => 'EE',
            68 => 'ET',
            69 => 'FK',
            70 => 'FO',
            71 => 'FJ',
            72 => 'FI',
            73 => 'FR',
            74 => 'GF',
            75 => 'PF',
            76 => 'TF',
            77 => 'GA',
            78 => 'GM',
            79 => 'GE',
            80 => 'DE',
            81 => 'GH',
            82 => 'GI',
            83 => 'GR',
            84 => 'GL',
            85 => 'GD',
            86 => 'GP',
            87 => 'GU',
            88 => 'GT',
            89 => 'GG',
            90 => 'GN',
            91 => 'GW',
            92 => 'GY',
            93 => 'HT',
            94 => 'HM',
            95 => 'VA',
            96 => 'HN',
            97 => 'HK',
            98 => 'HU',
            99 => 'IS',
            100 => 'IN',
            101 => 'ID',
            102 => 'IR',
            103 => 'IQ',
            104 => 'IE',
            105 => 'IM',
            106 => 'IL',
            107 => 'IT',
            108 => 'JM',
            109 => 'JP',
            110 => 'JE',
            111 => 'JO',
            112 => 'KZ',
            113 => 'KE',
            114 => 'KI',
            115 => 'KR',
            116 => 'KW',
            117 => 'KG',
            118 => 'LA',
            119 => 'LV',
            120 => 'LB',
            121 => 'LS',
            122 => 'LR',
            123 => 'LY',
            124 => 'LI',
            125 => 'LT',
            126 => 'LU',
            127 => 'MO',
            128 => 'MK',
            129 => 'MG',
            130 => 'MW',
            131 => 'MY',
            132 => 'MV',
            133 => 'ML',
            134 => 'MT',
            135 => 'MH',
            136 => 'MQ',
            137 => 'MR',
            138 => 'MU',
            139 => 'YT',
            140 => 'MX',
            141 => 'FM',
            142 => 'MD',
            143 => 'MC',
            144 => 'MN',
            145 => 'ME',
            146 => 'MS',
            147 => 'MA',
            148 => 'MZ',
            149 => 'MM',
            150 => 'NA',
            151 => 'NR',
            152 => 'NP',
            153 => 'NL',
            154 => 'AN',
            155 => 'NC',
            156 => 'NZ',
            157 => 'NI',
            158 => 'NE',
            159 => 'NG',
            160 => 'NU',
            161 => 'NF',
            162 => 'MP',
            163 => 'NO',
            164 => 'OM',
            165 => 'PK',
            166 => 'PW',
            167 => 'PS',
            168 => 'PA',
            169 => 'PG',
            170 => 'PY',
            171 => 'PE',
            172 => 'PH',
            173 => 'PN',
            174 => 'PL',
            175 => 'PT',
            176 => 'PR',
            177 => 'QA',
            178 => 'RE',
            179 => 'RO',
            180 => 'RU',
            181 => 'RW',
            182 => 'BL',
            183 => 'SH',
            184 => 'KN',
            185 => 'LC',
            186 => 'MF',
            187 => 'PM',
            188 => 'VC',
            189 => 'WS',
            190 => 'SM',
            191 => 'ST',
            192 => 'SA',
            193 => 'SN',
            194 => 'RS',
            195 => 'SC',
            196 => 'SL',
            197 => 'SG',
            198 => 'SK',
            199 => 'SI',
            200 => 'SB',
            201 => 'SO',
            202 => 'ZA',
            203 => 'GS',
            204 => 'ES',
            205 => 'LK',
            206 => 'SD',
            207 => 'SR',
            208 => 'SJ',
            209 => 'SZ',
            210 => 'SE',
            211 => 'CH',
            212 => 'SY',
            213 => 'TW',
            214 => 'TJ',
            215 => 'TZ',
            216 => 'TH',
            217 => 'TL',
            218 => 'TG',
            219 => 'TK',
            220 => 'TO',
            221 => 'TT',
            222 => 'TN',
            223 => 'TR',
            224 => 'TM',
            225 => 'TC',
            226 => 'TV',
            227 => 'UG',
            228 => 'UA',
            229 => 'AE',
            230 => 'GB',
            231 => 'US',
            232 => 'UM',
            233 => 'UY',
            234 => 'UZ',
            235 => 'VU',
            236 => 'VE',
            237 => 'VN',
            238 => 'VG',
            239 => 'VI',
            240 => 'WF',
            241 => 'EH',
            242 => 'YE',
            243 => 'ZM',
            244 => 'ZW'
          ]
        ],
        'isPreferred' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'preferredName' => [
          'type' => 'base',
          'notStorable' => true,
          'utility' => true
        ]
      ],
      'links' => [],
      'collection' => [
        'orderBy' => 'preferredName',
        'order' => 'asc',
        'textFilterFields' => [
          0 => 'name',
          1 => 'code'
        ],
        'sortBy' => 'preferredName',
        'asc' => true
      ],
      'indexes' => [
        'name' => [
          'unique' => true,
          'columns' => [
            0 => 'name'
          ]
        ]
      ],
      'noDeletedAttribute' => true
    ],
    'AppLogRecord' => [
      'fields' => [
        'number' => [
          'type' => 'autoincrement',
          'dbType' => 'bigint'
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'message' => [
          'type' => 'text',
          'readOnly' => true,
          'orderDisabled' => true
        ],
        'level' => [
          'type' => 'enum',
          'options' => [
            0 => 'Debug',
            1 => 'Info',
            2 => 'Notice',
            3 => 'Warning',
            4 => 'Error',
            5 => 'Critical',
            6 => 'Alert',
            7 => 'Emergency'
          ],
          'style' => [
            'Info' => 'info',
            'Notice' => 'primary',
            'Warning' => 'warning',
            'Error' => 'danger',
            'Critical' => 'danger',
            'Alert' => 'danger',
            'Emergency' => 'danger'
          ],
          'maxLength' => 9,
          'readOnly' => true,
          'index' => true
        ],
        'code' => [
          'type' => 'int',
          'readOnly' => true
        ],
        'exceptionClass' => [
          'type' => 'varchar',
          'maxLength' => 512,
          'readOnly' => true
        ],
        'file' => [
          'type' => 'varchar',
          'maxLength' => 512,
          'readOnly' => true
        ],
        'line' => [
          'type' => 'int',
          'readOnly' => true
        ],
        'requestMethod' => [
          'type' => 'enum',
          'maxLength' => 7,
          'options' => [
            0 => 'GET',
            1 => 'POST',
            2 => 'PUT',
            3 => 'UPDATE',
            4 => 'DELETE',
            5 => 'PATCH',
            6 => 'HEAD',
            7 => 'OPTIONS',
            8 => 'TRACE'
          ],
          'readOnly' => true
        ],
        'requestResourcePath' => [
          'type' => 'varchar',
          'maxLength' => 255,
          'readOnly' => true
        ],
        'requestUrl' => [
          'type' => 'varchar',
          'maxLength' => 512,
          'readOnly' => true
        ]
      ],
      'links' => [],
      'collection' => [
        'orderBy' => 'number',
        'order' => 'desc',
        'textFilterFields' => [
          0 => 'message'
        ],
        'sortBy' => 'number',
        'asc' => false
      ],
      'indexes' => [],
      'hooksDisabled' => true
    ],
    'AppSecret' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'required' => true,
          'pattern' => '[a-zA-Z]{1}[a-zA-Z0-9_]+',
          'index' => true,
          'tooltip' => true
        ],
        'value' => [
          'type' => 'text',
          'required' => true,
          'view' => 'views/admin/app-secret/fields/value'
        ],
        'description' => [
          'type' => 'text'
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => [
          'type' => 'link',
          'readOnly' => true
        ],
        'deleteId' => [
          'type' => 'varchar',
          'maxLength' => 17,
          'readOnly' => true,
          'notNull' => true,
          'default' => '0',
          'utility' => true,
          'customizationDisabled' => true
        ]
      ],
      'links' => [
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ],
      'collection' => [
        'orderBy' => 'name',
        'order' => 'asc',
        'textFilterFields' => [
          0 => 'name'
        ],
        'sortBy' => 'name',
        'asc' => true
      ],
      'indexes' => [
        'nameDeleteId' => [
          'type' => 'unique',
          'columns' => [
            0 => 'name',
            1 => 'deleteId'
          ]
        ]
      ],
      'deleteId' => true
    ],
    'ArrayValue' => [
      'fields' => [
        'value' => [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 100
        ],
        'entity' => [
          'type' => 'linkParent'
        ],
        'attribute' => [
          'type' => 'varchar',
          'maxLength' => 100
        ]
      ],
      'indexes' => [
        'entityTypeValue' => [
          'columns' => [
            0 => 'entityType',
            1 => 'value'
          ]
        ],
        'entityValue' => [
          'columns' => [
            0 => 'entityType',
            1 => 'entityId',
            2 => 'value'
          ]
        ]
      ],
      'hooksDisabled' => true
    ],
    'Attachment' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'required' => true,
          'view' => 'views/attachment/fields/name',
          'maxLength' => 255
        ],
        'type' => [
          'type' => 'varchar',
          'maxLength' => 100
        ],
        'size' => [
          'type' => 'int',
          'dbType' => 'bigint',
          'min' => 0
        ],
        'parent' => [
          'type' => 'linkParent',
          'view' => 'views/attachment/fields/parent'
        ],
        'related' => [
          'type' => 'linkParent',
          'noLoad' => true,
          'view' => 'views/attachment/fields/parent',
          'validatorClassName' => 'Espo\\Classes\\FieldValidators\\Attachment\\Related'
        ],
        'source' => [
          'type' => 'link',
          'readOnly' => true,
          'utility' => true
        ],
        'field' => [
          'type' => 'varchar',
          'utility' => true
        ],
        'isBeingUploaded' => [
          'type' => 'bool',
          'default' => false
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true
        ],
        'contents' => [
          'type' => 'text',
          'notStorable' => true,
          'sanitizerClassNameList' => [],
          'sanitizerSuppressClassNameList' => [
            0 => 'Espo\\Classes\\FieldSanitizers\\EmptyStringToNull'
          ]
        ],
        'role' => [
          'type' => 'enum',
          'maxLength' => 36,
          'options' => [
            0 => 'Attachment',
            1 => 'Inline Attachment',
            2 => 'Import File',
            3 => 'Export File',
            4 => 'Mail Merge',
            5 => 'Mass Pdf'
          ]
        ],
        'storage' => [
          'type' => 'varchar',
          'maxLength' => 24,
          'default' => NULL
        ],
        'storageFilePath' => [
          'type' => 'varchar',
          'maxLength' => 260,
          'default' => NULL
        ],
        'global' => [
          'type' => 'bool',
          'default' => false
        ]
      ],
      'links' => [
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'parent' => [
          'type' => 'belongsToParent',
          'foreign' => 'attachments'
        ],
        'related' => [
          'type' => 'belongsToParent'
        ]
      ],
      'collection' => [
        'orderBy' => 'createdAt',
        'order' => 'desc',
        'sortBy' => 'createdAt',
        'asc' => false
      ],
      'indexes' => [
        'parent' => [
          'columns' => [
            0 => 'parentType',
            1 => 'parentId'
          ]
        ]
      ],
      'sourceList' => [
        0 => 'Document'
      ]
    ],
    'AuthLogRecord' => [
      'fields' => [
        'username' => [
          'type' => 'varchar',
          'readOnly' => true,
          'maxLength' => 100
        ],
        'portal' => [
          'type' => 'link',
          'readOnly' => true
        ],
        'user' => [
          'type' => 'link',
          'readOnly' => true
        ],
        'authToken' => [
          'type' => 'link',
          'readOnly' => true
        ],
        'ipAddress' => [
          'type' => 'varchar',
          'maxLength' => 45,
          'readOnly' => true
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true,
          'hasSeconds' => true
        ],
        'isDenied' => [
          'type' => 'bool',
          'readOnly' => true
        ],
        'denialReason' => [
          'type' => 'enum',
          'options' => [
            0 => '',
            1 => 'CREDENTIALS',
            2 => 'INACTIVE_USER',
            3 => 'IS_PORTAL_USER',
            4 => 'IS_NOT_PORTAL_USER',
            5 => 'USER_IS_NOT_IN_PORTAL',
            6 => 'IS_SYSTEM_USER',
            7 => 'FORBIDDEN'
          ],
          'readOnly' => true
        ],
        'requestTime' => [
          'type' => 'float',
          'readOnly' => true
        ],
        'requestUrl' => [
          'type' => 'varchar',
          'readOnly' => true
        ],
        'requestMethod' => [
          'type' => 'varchar',
          'readOnly' => true,
          'maxLength' => 15
        ],
        'authTokenIsActive' => [
          'type' => 'foreign',
          'link' => 'authToken',
          'field' => 'isActive',
          'readOnly' => true,
          'view' => 'views/fields/foreign-bool'
        ],
        'authenticationMethod' => [
          'type' => 'enum',
          'view' => 'views/admin/auth-log-record/fields/authentication-method',
          'translation' => 'Settings.options.authenticationMethod'
        ]
      ],
      'links' => [
        'user' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'portal' => [
          'type' => 'belongsTo',
          'entity' => 'Portal'
        ],
        'authToken' => [
          'type' => 'belongsTo',
          'entity' => 'AuthToken',
          'foreignName' => 'id'
        ],
        'actionHistoryRecords' => [
          'type' => 'hasMany',
          'entity' => 'ActionHistoryRecord',
          'foreign' => 'authLogRecord'
        ]
      ],
      'collection' => [
        'orderBy' => 'requestTime',
        'order' => 'desc',
        'textFilterFields' => [
          0 => 'ipAddress',
          1 => 'username'
        ],
        'sortBy' => 'requestTime',
        'asc' => false
      ],
      'indexes' => [
        'ipAddress' => [
          'columns' => [
            0 => 'ipAddress'
          ]
        ],
        'ipAddressRequestTime' => [
          'columns' => [
            0 => 'ipAddress',
            1 => 'requestTime'
          ]
        ],
        'requestTime' => [
          'columns' => [
            0 => 'requestTime'
          ]
        ]
      ],
      'hooksDisabled' => true
    ],
    'AuthToken' => [
      'fields' => [
        'token' => [
          'type' => 'varchar',
          'maxLength' => 36,
          'index' => true,
          'readOnly' => true
        ],
        'hash' => [
          'type' => 'varchar',
          'maxLength' => 150,
          'index' => true,
          'readOnly' => true
        ],
        'secret' => [
          'type' => 'varchar',
          'maxLength' => 36,
          'readOnly' => true
        ],
        'user' => [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user'
        ],
        'portal' => [
          'type' => 'link',
          'readOnly' => true
        ],
        'ipAddress' => [
          'type' => 'varchar',
          'maxLength' => 45,
          'readOnly' => true
        ],
        'isActive' => [
          'type' => 'bool',
          'default' => true
        ],
        'lastAccess' => [
          'type' => 'datetime',
          'readOnly' => true,
          'hasSeconds' => true
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true,
          'hasSeconds' => true
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ]
      ],
      'links' => [
        'user' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'portal' => [
          'type' => 'belongsTo',
          'entity' => 'Portal'
        ],
        'actionHistoryRecords' => [
          'type' => 'hasMany',
          'entity' => 'ActionHistoryRecord',
          'foreign' => 'authToken'
        ]
      ],
      'collection' => [
        'orderBy' => 'lastAccess',
        'order' => 'desc',
        'textFilterFields' => [
          0 => 'ipAddress',
          1 => 'userName'
        ],
        'sortBy' => 'lastAccess',
        'asc' => false
      ],
      'indexes' => [
        'token' => [
          'columns' => [
            0 => 'token',
            1 => 'deleted'
          ]
        ]
      ],
      'hooksDisabled' => true
    ],
    'AuthenticationProvider' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'required' => true
        ],
        'method' => [
          'type' => 'enum',
          'view' => 'views/authentication-provider/fields/method',
          'translation' => 'Settings.options.authenticationMethod',
          'required' => true,
          'validatorClassNameMap' => [
            'valid' => 'Espo\\Classes\\FieldValidators\\AuthenticationProvider\\MethodValid'
          ]
        ],
        'oidcAuthorizationRedirectUri' => [
          'type' => 'varchar',
          'notStorable' => true,
          'readOnly' => true
        ],
        'oidcClientId' => [
          'type' => 'varchar'
        ],
        'oidcClientSecret' => [
          'type' => 'password'
        ],
        'oidcAuthorizationEndpoint' => [
          'type' => 'url',
          'strip' => false
        ],
        'oidcTokenEndpoint' => [
          'type' => 'url',
          'strip' => false
        ],
        'oidcJwksEndpoint' => [
          'type' => 'url',
          'strip' => false
        ],
        'oidcJwtSignatureAlgorithmList' => [
          'type' => 'multiEnum',
          'optionsPath' => 'entityDefs.Settings.fields.oidcJwtSignatureAlgorithmList.options',
          'default' => [
            0 => 'RS256'
          ]
        ],
        'oidcScopes' => [
          'type' => 'multiEnum',
          'allowCustomOptions' => true,
          'optionsPath' => 'entityDefs.Settings.fields.oidcScopes.options',
          'default' => [
            0 => 'profile',
            1 => 'email',
            2 => 'phone'
          ]
        ],
        'oidcCreateUser' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'oidcUsernameClaim' => [
          'type' => 'varchar',
          'optionsPath' => 'entityDefs.Settings.fields.oidcUsernameClaim.options',
          'tooltip' => true,
          'default' => 'sub'
        ],
        'oidcSync' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'oidcLogoutUrl' => [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'oidcAuthorizationPrompt' => [
          'type' => 'enum',
          'options' => [
            0 => 'none',
            1 => 'consent',
            2 => 'login',
            3 => 'select_account'
          ],
          'maxLength' => 14
        ]
      ]
    ],
    'Autofollow' => [
      'fields' => [
        'id' => [
          'type' => 'id',
          'dbType' => 'integer',
          'autoincrement' => true
        ],
        'entityType' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'index' => true
        ],
        'user' => [
          'type' => 'link'
        ]
      ]
    ],
    'Currency' => [
      'fields' => [
        'id' => [
          'type' => 'id',
          'maxLength' => 3,
          'dbType' => 'string'
        ],
        'rate' => [
          'type' => 'float'
        ]
      ],
      'noDeletedAttribute' => true
    ],
    'DashboardTemplate' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'required' => true
        ],
        'layout' => [
          'type' => 'jsonArray',
          'view' => 'views/settings/fields/dashboard-layout',
          'inlineEditDisabled' => true,
          'required' => true
        ],
        'dashletsOptions' => [
          'type' => 'jsonObject',
          'disabled' => true
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => [
          'type' => 'link',
          'readOnly' => true
        ]
      ],
      'links' => [
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ],
      'collection' => [
        'orderBy' => 'name',
        'order' => 'asc',
        'sortBy' => 'name',
        'asc' => true
      ]
    ],
    'Email' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'required' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'massUpdateDisabled' => true
        ],
        'subject' => [
          'type' => 'varchar',
          'required' => true,
          'notStorable' => true,
          'orderDisabled' => true,
          'view' => 'views/email/fields/subject',
          'utility' => true
        ],
        'fromName' => [
          'type' => 'varchar',
          'readOnly' => true,
          'notStorable' => true,
          'textFilterDisabled' => true,
          'layoutFiltersDisabled' => true,
          'customizationDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'massUpdateDisabled' => true,
          'default' => NULL,
          'maxLength' => NULL,
          'trim' => false,
          'options' => []
        ],
        'fromAddress' => [
          'type' => 'varchar',
          'readOnly' => true,
          'notStorable' => true,
          'orderDisabled' => true,
          'textFilterDisabled' => true,
          'layoutFiltersDisabled' => true,
          'customizationDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'massUpdateDisabled' => true
        ],
        'fromString' => [
          'type' => 'varchar',
          'customizationDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'massUpdateDisabled' => true,
          'default' => NULL,
          'maxLength' => NULL,
          'trim' => false,
          'options' => []
        ],
        'replyToString' => [
          'type' => 'varchar',
          'customizationDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'massUpdateDisabled' => true
        ],
        'replyToName' => [
          'type' => 'varchar',
          'readOnly' => true,
          'notStorable' => true,
          'orderDisabled' => true,
          'textFilterDisabled' => true,
          'layoutFiltersDisabled' => true,
          'customizationDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'massUpdateDisabled' => true,
          'default' => NULL,
          'maxLength' => NULL,
          'trim' => false,
          'options' => []
        ],
        'replyToAddress' => [
          'type' => 'varchar',
          'readOnly' => true,
          'notStorable' => true,
          'orderDisabled' => true,
          'textFilterDisabled' => true,
          'layoutFiltersDisabled' => true,
          'customizationDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'massUpdateDisabled' => true,
          'default' => NULL,
          'maxLength' => NULL,
          'trim' => false,
          'options' => []
        ],
        'addressNameMap' => [
          'type' => 'jsonObject',
          'utility' => true,
          'readOnly' => true,
          'customizationDisabled' => true,
          'name' => 'addressNameMap',
          'label' => 'endereço Nome Mapa',
          'disabled' => true,
          'inlineEditDisabled' => false,
          'tooltip' => false
        ],
        'from' => [
          'type' => 'varchar',
          'notStorable' => true,
          'orderDisabled' => true,
          'required' => true,
          'view' => 'views/email/fields/from-address-varchar',
          'textFilterDisabled' => true,
          'customizationDisabled' => true,
          'layoutAvailabilityList' => [
            0 => 'detail',
            1 => 'filters'
          ],
          'massUpdateDisabled' => true,
          'reportDisabled' => true
        ],
        'to' => [
          'type' => 'varchar',
          'notStorable' => true,
          'orderDisabled' => true,
          'required' => true,
          'view' => 'views/email/fields/email-address-varchar',
          'validatorClassName' => 'Espo\\Classes\\FieldValidators\\Email\\EmailAddresses',
          'validatorClassNameList' => [
            0 => 'Espo\\Classes\\FieldValidators\\Email\\Addresses\\Valid',
            1 => 'Espo\\Classes\\FieldValidators\\Email\\Addresses\\MaxCount'
          ],
          'textFilterDisabled' => true,
          'customizationDisabled' => true,
          'layoutAvailabilityList' => [
            0 => 'detail',
            1 => 'filters'
          ],
          'massUpdateDisabled' => true,
          'reportDisabled' => true
        ],
        'cc' => [
          'type' => 'varchar',
          'notStorable' => true,
          'orderDisabled' => true,
          'view' => 'views/email/fields/email-address-varchar',
          'validatorClassNameList' => [
            0 => 'Espo\\Classes\\FieldValidators\\Email\\Addresses\\Valid',
            1 => 'Espo\\Classes\\FieldValidators\\Email\\Addresses\\MaxCount'
          ],
          'customizationDisabled' => true,
          'textFilterDisabled' => true,
          'layoutAvailabilityList' => [
            0 => 'detail',
            1 => 'filters'
          ],
          'massUpdateDisabled' => true,
          'reportDisabled' => true
        ],
        'bcc' => [
          'type' => 'varchar',
          'notStorable' => true,
          'orderDisabled' => true,
          'view' => 'views/email/fields/email-address-varchar',
          'validatorClassNameList' => [
            0 => 'Espo\\Classes\\FieldValidators\\Email\\Addresses\\Valid',
            1 => 'Espo\\Classes\\FieldValidators\\Email\\Addresses\\MaxCount'
          ],
          'customizationDisabled' => true,
          'textFilterDisabled' => true,
          'layoutAvailabilityList' => [
            0 => 'detail'
          ],
          'massUpdateDisabled' => true,
          'reportDisabled' => true
        ],
        'replyTo' => [
          'type' => 'varchar',
          'notStorable' => true,
          'orderDisabled' => true,
          'view' => 'views/email/fields/email-address-varchar',
          'textFilterDisabled' => true,
          'customizationDisabled' => true,
          'layoutAvailabilityList' => [
            0 => 'detail'
          ],
          'massUpdateDisabled' => true,
          'reportDisabled' => true
        ],
        'personStringData' => [
          'type' => 'varchar',
          'notStorable' => true,
          'orderDisabled' => true,
          'utility' => true,
          'view' => 'views/email/fields/person-string-data',
          'customizationDisabled' => true,
          'massUpdateDisabled' => true,
          'default' => NULL,
          'maxLength' => NULL,
          'trim' => false,
          'options' => []
        ],
        'isRead' => [
          'type' => 'bool',
          'notStorable' => true,
          'default' => true,
          'readOnly' => true,
          'customizationDisabled' => true,
          'reportGroupByDisabled' => true,
          'reportFilterDisabled' => true,
          'reportOrderByDisabled' => true,
          'workflowDisabled' => true
        ],
        'isNotRead' => [
          'type' => 'bool',
          'notStorable' => true,
          'layoutListDisabled' => true,
          'layoutDetailDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'readOnly' => true,
          'customizationDisabled' => true,
          'reportGroupByDisabled' => true,
          'reportFilterDisabled' => true,
          'reportOrderByDisabled' => true,
          'workflowDisabled' => true
        ],
        'isReplied' => [
          'type' => 'bool',
          'readOnly' => true,
          'customizationDisabled' => true
        ],
        'isNotReplied' => [
          'type' => 'bool',
          'notStorable' => true,
          'layoutListDisabled' => true,
          'layoutDetailDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'readOnly' => true,
          'customizationDisabled' => true
        ],
        'isImportant' => [
          'type' => 'bool',
          'notStorable' => true,
          'default' => false,
          'customizationDisabled' => true,
          'readOnly' => true,
          'reportGroupByDisabled' => true,
          'reportFilterDisabled' => true,
          'reportOrderByDisabled' => true,
          'workflowDisabled' => true
        ],
        'inTrash' => [
          'type' => 'bool',
          'notStorable' => true,
          'default' => false,
          'customizationDisabled' => true,
          'readOnly' => true,
          'reportGroupByDisabled' => true,
          'reportFilterDisabled' => true,
          'reportOrderByDisabled' => true,
          'workflowDisabled' => true
        ],
        'inArchive' => [
          'type' => 'bool',
          'notStorable' => true,
          'default' => false,
          'customizationDisabled' => true,
          'readOnly' => true
        ],
        'folderId' => [
          'type' => 'varchar',
          'notStorable' => true,
          'default' => NULL,
          'textFilterDisabled' => true,
          'customizationDisabled' => true,
          'layoutAvailabilityList' => [],
          'readOnly' => true,
          'reportDisabled' => true
        ],
        'isUsers' => [
          'type' => 'bool',
          'notStorable' => true,
          'default' => false,
          'customizationDisabled' => true,
          'readOnly' => true,
          'reportDisabled' => true,
          'workflowDisabled' => true
        ],
        'isUsersSent' => [
          'type' => 'bool',
          'notStorable' => true,
          'readOnly' => true,
          'utility' => true
        ],
        'folder' => [
          'type' => 'link',
          'notStorable' => true,
          'orderDisabled' => true,
          'readOnly' => true,
          'entity' => 'EmailFolder',
          'customizationDisabled' => true,
          'layoutAvailabilityList' => [],
          'reportDisabled' => true
        ],
        'folderString' => [
          'type' => 'link',
          'notStorable' => true,
          'orderDisabled' => true,
          'readOnly' => true,
          'entity' => 'EmailFolder',
          'customizationDisabled' => true,
          'view' => 'views/email/fields/folder-string',
          'layoutAvailabilityList' => [
            0 => 'defaultSidePanel'
          ]
        ],
        'nameHash' => [
          'type' => 'jsonObject',
          'notStorable' => true,
          'orderDisabled' => true,
          'readOnly' => true,
          'utility' => true,
          'customizationDisabled' => true,
          'default' => NULL,
          'maxLength' => NULL,
          'rows' => NULL,
          'cutHeight' => NULL
        ],
        'typeHash' => [
          'type' => 'jsonObject',
          'notStorable' => true,
          'readOnly' => true,
          'utility' => true,
          'customizationDisabled' => true,
          'default' => NULL,
          'maxLength' => NULL,
          'rows' => NULL,
          'cutHeight' => NULL
        ],
        'idHash' => [
          'type' => 'jsonObject',
          'notStorable' => true,
          'orderDisabled' => true,
          'readOnly' => true,
          'utility' => true,
          'customizationDisabled' => true,
          'default' => NULL,
          'maxLength' => NULL,
          'rows' => NULL,
          'cutHeight' => NULL
        ],
        'messageId' => [
          'type' => 'varchar',
          'maxLength' => 255,
          'readOnly' => true,
          'index' => true,
          'textFilterDisabled' => true,
          'customizationDisabled' => true,
          'default' => NULL,
          'trim' => false,
          'options' => []
        ],
        'messageIdInternal' => [
          'type' => 'varchar',
          'maxLength' => 300,
          'readOnly' => true,
          'textFilterDisabled' => true,
          'customizationDisabled' => true,
          'layoutAvailabilityList' => [],
          'default' => NULL,
          'trim' => false,
          'options' => []
        ],
        'emailAddress' => [
          'type' => 'base',
          'notStorable' => true,
          'view' => 'views/email/fields/email-address',
          'customizationDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'massUpdateDisabled' => true
        ],
        'fromEmailAddress' => [
          'type' => 'link',
          'view' => 'views/email/fields/from-email-address',
          'textFilterDisabled' => true,
          'customizationDisabled' => true,
          'layoutAvailabilityList' => [],
          'massUpdateDisabled' => true,
          'readOnly' => true,
          'defaultAttributes' => NULL
        ],
        'toEmailAddresses' => [
          'type' => 'linkMultiple',
          'customizationDisabled' => true,
          'layoutAvailabilityList' => [],
          'massUpdateDisabled' => true,
          'readOnly' => true
        ],
        'ccEmailAddresses' => [
          'type' => 'linkMultiple',
          'customizationDisabled' => true,
          'layoutAvailabilityList' => [],
          'massUpdateDisabled' => true,
          'readOnly' => true
        ],
        'bccEmailAddresses' => [
          'type' => 'linkMultiple',
          'customizationDisabled' => true,
          'layoutAvailabilityList' => [],
          'massUpdateDisabled' => true,
          'readOnly' => true
        ],
        'replyToEmailAddresses' => [
          'type' => 'linkMultiple',
          'customizationDisabled' => true,
          'layoutAvailabilityList' => [],
          'massUpdateDisabled' => true,
          'readOnly' => true
        ],
        'bodyPlain' => [
          'type' => 'text',
          'seeMoreDisabled' => true,
          'clientReadOnly' => true,
          'customizationDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'massUpdateDisabled' => true,
          'default' => NULL,
          'maxLength' => NULL,
          'rows' => NULL,
          'cutHeight' => NULL
        ],
        'body' => [
          'type' => 'wysiwyg',
          'view' => 'views/email/fields/body',
          'attachmentField' => 'attachments',
          'useIframe' => true,
          'customizationDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'massUpdateDisabled' => true
        ],
        'isHtml' => [
          'type' => 'bool',
          'default' => true,
          'fieldManagerParamList' => [
            0 => 'default',
            1 => 'tooltipText'
          ],
          'inlineEditDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'massUpdateDisabled' => true
        ],
        'status' => [
          'type' => 'enum',
          'options' => [
            0 => 'Draft',
            1 => 'Sending',
            2 => 'Sent',
            3 => 'Archived',
            4 => 'Failed'
          ],
          'default' => 'Archived',
          'clientReadOnly' => true,
          'style' => [
            'Draft' => 'warning',
            'Failed' => 'danger',
            'Sending' => 'warning'
          ],
          'customizationDisabled' => true,
          'massUpdateDisabled' => true
        ],
        'attachments' => [
          'type' => 'attachmentMultiple',
          'sourceList' => [
            0 => 'Document'
          ],
          'layoutDefaultSidePanelDisabled' => true,
          'massUpdateDisabled' => true
        ],
        'hasAttachment' => [
          'type' => 'bool',
          'readOnly' => true,
          'customizationDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true
        ],
        'parent' => [
          'type' => 'linkParent',
          'fieldManagerParamList' => [
            0 => 'required',
            1 => 'entityList',
            2 => 'autocompleteOnEmpty',
            3 => 'audited',
            4 => 'tooltipText'
          ],
          'entityList' => [
            0 => 'Account',
            1 => 'Lead',
            2 => 'Contact',
            3 => 'Opportunity',
            4 => 'Case',
            5 => 'CRegistration',
            6 => 'User'
          ]
        ],
        'dateSent' => [
          'type' => 'datetime',
          'customizationDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'massUpdateDisabled' => true,
          'view' => 'views/email/fields/date-sent'
        ],
        'deliveryDate' => [
          'type' => 'datetime',
          'readOnly' => true,
          'customizationDisabled' => true
        ],
        'sendAt' => [
          'type' => 'datetime',
          'customizationDisabled' => true,
          'layoutAvailabilityList' => [
            0 => 'filters',
            1 => 'list'
          ],
          'validatorClassNameList' => [
            0 => 'Espo\\Classes\\FieldValidators\\Email\\SendAt\\Future'
          ]
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true,
          'fieldManagerParamList' => [
            0 => 'useNumericFormat'
          ]
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true,
          'fieldManagerParamList' => [
            0 => 'useNumericFormat'
          ]
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user',
          'customizationDisabled' => true
        ],
        'sentBy' => [
          'type' => 'link',
          'readOnly' => true,
          'noLoad' => true,
          'customizationDisabled' => true
        ],
        'modifiedBy' => [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user',
          'customizationDisabled' => true
        ],
        'assignedUser' => [
          'type' => 'link',
          'required' => false,
          'view' => 'views/fields/assigned-user',
          'massUpdateDisabled' => true
        ],
        'replied' => [
          'type' => 'link',
          'noJoin' => true,
          'view' => 'views/email/fields/replied',
          'customizationDisabled' => true,
          'massUpdateDisabled' => true
        ],
        'replies' => [
          'type' => 'linkMultiple',
          'readOnly' => true,
          'orderBy' => 'dateSent',
          'view' => 'views/email/fields/replies',
          'customizationDisabled' => true,
          'columns' => [
            'status' => 'status'
          ],
          'massUpdateDisabled' => true
        ],
        'isSystem' => [
          'type' => 'bool',
          'default' => false,
          'readOnly' => true,
          'customizationDisabled' => true,
          'massUpdateDisabled' => true
        ],
        'isJustSent' => [
          'type' => 'bool',
          'default' => false,
          'readOnly' => true,
          'utility' => true,
          'notStorable' => true,
          'customizationDisabled' => true,
          'massUpdateDisabled' => true
        ],
        'isBeingImported' => [
          'type' => 'bool',
          'readOnly' => true,
          'utility' => true,
          'notStorable' => true,
          'customizationDisabled' => true,
          'massUpdateDisabled' => true
        ],
        'skipNotificationMap' => [
          'type' => 'jsonObject',
          'utility' => true,
          'readOnly' => true,
          'notStorable' => true
        ],
        'teams' => [
          'type' => 'linkMultiple',
          'view' => 'views/fields/teams'
        ],
        'users' => [
          'type' => 'linkMultiple',
          'noLoad' => true,
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'readOnly' => true,
          'columns' => [
            'inTrash' => 'inTrash',
            'folderId' => 'folderId'
          ],
          'customizationDisabled' => true
        ],
        'assignedUsers' => [
          'type' => 'linkMultiple',
          'layoutListDisabled' => true,
          'readOnly' => true,
          'customizationDisabled' => true,
          'view' => 'views/fields/assigned-users'
        ],
        'inboundEmails' => [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'noLoad' => true,
          'readOnly' => true,
          'fieldManagerParamList' => [
            0 => 'default'
          ]
        ],
        'emailAccounts' => [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'noLoad' => true,
          'readOnly' => true,
          'fieldManagerParamList' => [
            0 => 'default'
          ]
        ],
        'icsContents' => [
          'type' => 'text',
          'readOnly' => true,
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'customizationDisabled' => true,
          'layoutAvailabilityList' => []
        ],
        'icsEventData' => [
          'type' => 'jsonObject',
          'readOnly' => true,
          'directAccessDisabled' => true,
          'notStorable' => true,
          'customizationDisabled' => true,
          'layoutAvailabilityList' => []
        ],
        'icsEventUid' => [
          'type' => 'varchar',
          'maxLength' => 255,
          'index' => true,
          'readOnly' => true,
          'customizationDisabled' => true,
          'layoutAvailabilityList' => []
        ],
        'icsEventDateStart' => [
          'type' => 'datetimeOptional',
          'readOnly' => true,
          'notStorable' => true,
          'customizationDisabled' => true,
          'layoutAvailabilityList' => []
        ],
        'createEvent' => [
          'type' => 'base',
          'utility' => true,
          'notStorable' => true,
          'view' => 'views/email/fields/create-event',
          'customizationDisabled' => true,
          'massUpdateDisabled' => true,
          'layoutAvailabilityList' => []
        ],
        'createdEvent' => [
          'type' => 'linkParent',
          'readOnly' => true,
          'view' => 'views/email/fields/created-event',
          'fieldManagerParamList' => [
            0 => 'tooltipText'
          ],
          'layoutAvailabilityList' => []
        ],
        'groupFolder' => [
          'type' => 'link',
          'massUpdateDisabled' => true,
          'readOnly' => true,
          'fieldManagerParamList' => [
            0 => 'audited'
          ],
          'audited' => true
        ],
        'groupStatusFolder' => [
          'type' => 'enum',
          'options' => [
            0 => '',
            1 => 'Archive',
            2 => 'Trash'
          ],
          'maxLength' => 7,
          'readOnly' => true,
          'customizationDisabled' => true,
          'index' => true
        ],
        'account' => [
          'type' => 'link',
          'readOnly' => true,
          'customizationDisabled' => true
        ],
        'tasks' => [
          'type' => 'linkMultiple',
          'readOnly' => true,
          'columns' => [
            'status' => 'status'
          ],
          'view' => 'crm:views/task/fields/tasks',
          'customizationDefaultDisabled' => true
        ],
        'icsEventDateStartDate' => [
          'readOnly' => true,
          'notStorable' => true,
          'customizationDisabled' => true,
          'type' => 'date',
          'disabled' => true
        ]
      ],
      'links' => [
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'assignedUser' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'teams' => [
          'type' => 'hasMany',
          'entity' => 'Team',
          'relationName' => 'entityTeam'
        ],
        'assignedUsers' => [
          'type' => 'hasMany',
          'entity' => 'User',
          'relationName' => 'entityUser'
        ],
        'users' => [
          'type' => 'hasMany',
          'entity' => 'User',
          'foreign' => 'emails',
          'additionalColumns' => [
            'isRead' => [
              'type' => 'bool',
              'default' => false
            ],
            'isImportant' => [
              'type' => 'bool',
              'default' => false
            ],
            'inTrash' => [
              'type' => 'bool',
              'default' => false
            ],
            'inArchive' => [
              'type' => 'bool',
              'default' => false
            ],
            'folderId' => [
              'type' => 'foreignId',
              'default' => NULL
            ]
          ]
        ],
        'sentBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'attachments' => [
          'type' => 'hasChildren',
          'entity' => 'Attachment',
          'foreign' => 'parent',
          'relationName' => 'attachments',
          'audited' => false
        ],
        'parent' => [
          'type' => 'belongsToParent',
          'entityList' => [],
          'foreign' => 'emails'
        ],
        'replied' => [
          'type' => 'belongsTo',
          'entity' => 'Email',
          'foreign' => 'replies'
        ],
        'replies' => [
          'type' => 'hasMany',
          'entity' => 'Email',
          'foreign' => 'replied'
        ],
        'fromEmailAddress' => [
          'type' => 'belongsTo',
          'entity' => 'EmailAddress'
        ],
        'toEmailAddresses' => [
          'type' => 'hasMany',
          'entity' => 'EmailAddress',
          'relationName' => 'emailEmailAddress',
          'conditions' => [
            'addressType' => 'to'
          ],
          'additionalColumns' => [
            'addressType' => [
              'type' => 'varchar',
              'len' => '4'
            ]
          ]
        ],
        'ccEmailAddresses' => [
          'type' => 'hasMany',
          'entity' => 'EmailAddress',
          'relationName' => 'emailEmailAddress',
          'conditions' => [
            'addressType' => 'cc'
          ],
          'additionalColumns' => [
            'addressType' => [
              'type' => 'varchar',
              'len' => '4'
            ]
          ],
          'layoutDefaultSidePanelDisabled' => true
        ],
        'bccEmailAddresses' => [
          'type' => 'hasMany',
          'entity' => 'EmailAddress',
          'relationName' => 'emailEmailAddress',
          'conditions' => [
            'addressType' => 'bcc'
          ],
          'additionalColumns' => [
            'addressType' => [
              'type' => 'varchar',
              'len' => '4'
            ]
          ],
          'layoutDefaultSidePanelDisabled' => true
        ],
        'replyToEmailAddresses' => [
          'type' => 'hasMany',
          'entity' => 'EmailAddress',
          'relationName' => 'emailEmailAddress',
          'conditions' => [
            'addressType' => 'rto'
          ],
          'additionalColumns' => [
            'addressType' => [
              'type' => 'varchar',
              'len' => '4'
            ]
          ]
        ],
        'inboundEmails' => [
          'type' => 'hasMany',
          'entity' => 'InboundEmail',
          'foreign' => 'emails',
          'audited' => false
        ],
        'emailAccounts' => [
          'type' => 'hasMany',
          'entity' => 'EmailAccount',
          'foreign' => 'emails',
          'audited' => false
        ],
        'createdEvent' => [
          'type' => 'belongsToParent',
          'entityList' => [
            0 => 'Meeting'
          ]
        ],
        'groupFolder' => [
          'type' => 'belongsTo',
          'entity' => 'GroupEmailFolder',
          'foreign' => 'emails'
        ],
        'account' => [
          'type' => 'belongsTo',
          'entity' => 'Account'
        ],
        'tasks' => [
          'type' => 'hasMany',
          'entity' => 'Task',
          'foreign' => 'email'
        ]
      ],
      'collection' => [
        'orderBy' => 'dateSent',
        'order' => 'desc',
        'textFilterFields' => [
          0 => 'name',
          1 => 'bodyPlain',
          2 => 'body'
        ],
        'countDisabled' => true,
        'fullTextSearch' => true,
        'fullTextSearchOrderType' => 'original',
        'sortBy' => 'dateSent',
        'asc' => false
      ],
      'indexes' => [
        'createdById' => [
          'columns' => [
            0 => 'createdById'
          ]
        ],
        'dateSent' => [
          'columns' => [
            0 => 'dateSent',
            1 => 'deleted'
          ]
        ],
        'dateSentStatus' => [
          'columns' => [
            0 => 'dateSent',
            1 => 'status',
            2 => 'deleted'
          ]
        ]
      ]
    ],
    'EmailAccount' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'required' => true,
          'pattern' => '$noBadCharacters'
        ],
        'emailAddress' => [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 100,
          'tooltip' => true,
          'view' => 'views/email-account/fields/email-address'
        ],
        'status' => [
          'type' => 'enum',
          'options' => [
            0 => 'Active',
            1 => 'Inactive'
          ],
          'default' => 'Active'
        ],
        'host' => [
          'type' => 'varchar'
        ],
        'port' => [
          'type' => 'int',
          'min' => 0,
          'max' => 65535,
          'default' => 993
        ],
        'security' => [
          'type' => 'enum',
          'default' => 'SSL',
          'options' => [
            0 => '',
            1 => 'SSL',
            2 => 'TLS'
          ]
        ],
        'username' => [
          'type' => 'varchar'
        ],
        'password' => [
          'type' => 'password'
        ],
        'monitoredFolders' => [
          'type' => 'array',
          'default' => [
            0 => 'INBOX'
          ],
          'view' => 'views/email-account/fields/folders',
          'displayAsList' => true,
          'noEmptyString' => true,
          'duplicateIgnore' => true
        ],
        'sentFolder' => [
          'type' => 'varchar',
          'view' => 'views/email-account/fields/folder',
          'duplicateIgnore' => true
        ],
        'storeSentEmails' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'keepFetchedEmailsUnread' => [
          'type' => 'bool'
        ],
        'fetchSince' => [
          'type' => 'date',
          'validatorClassNameList' => [
            0 => 'Espo\\Classes\\FieldValidators\\InboundEmail\\FetchSince\\Required'
          ],
          'forceValidation' => true
        ],
        'fetchData' => [
          'type' => 'jsonObject',
          'readOnly' => true,
          'duplicateIgnore' => true
        ],
        'emailFolder' => [
          'type' => 'link',
          'view' => 'views/email-account/fields/email-folder',
          'duplicateIgnore' => true
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'assignedUser' => [
          'type' => 'link',
          'required' => true,
          'view' => 'views/fields/assigned-user'
        ],
        'connectedAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'useImap' => [
          'type' => 'bool',
          'default' => true
        ],
        'useSmtp' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'smtpHost' => [
          'type' => 'varchar'
        ],
        'smtpPort' => [
          'type' => 'int',
          'min' => 0,
          'max' => 65535,
          'default' => 587
        ],
        'smtpAuth' => [
          'type' => 'bool',
          'default' => true
        ],
        'smtpSecurity' => [
          'type' => 'enum',
          'default' => 'TLS',
          'options' => [
            0 => '',
            1 => 'SSL',
            2 => 'TLS'
          ]
        ],
        'smtpUsername' => [
          'type' => 'varchar'
        ],
        'smtpPassword' => [
          'type' => 'password'
        ],
        'smtpAuthMechanism' => [
          'type' => 'enum',
          'options' => [
            0 => 'login',
            1 => 'crammd5',
            2 => 'plain'
          ],
          'default' => 'login'
        ],
        'imapHandler' => [
          'type' => 'varchar',
          'readOnly' => true
        ],
        'smtpHandler' => [
          'type' => 'varchar',
          'readOnly' => true
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => [
          'type' => 'link',
          'readOnly' => true
        ]
      ],
      'links' => [
        'assignedUser' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'filters' => [
          'type' => 'hasChildren',
          'foreign' => 'parent',
          'entity' => 'EmailFilter'
        ],
        'emails' => [
          'type' => 'hasMany',
          'entity' => 'Email',
          'foreign' => 'emailAccounts',
          'audited' => false
        ],
        'emailFolder' => [
          'type' => 'belongsTo',
          'entity' => 'EmailFolder'
        ]
      ],
      'collection' => [
        'orderBy' => 'name',
        'order' => 'asc',
        'sortBy' => 'name',
        'asc' => true
      ]
    ],
    'EmailAddress' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 255
        ],
        'lower' => [
          'type' => 'varchar',
          'required' => true,
          'index' => true
        ],
        'invalid' => [
          'type' => 'bool'
        ],
        'optOut' => [
          'type' => 'bool'
        ],
        'primary' => [
          'type' => 'bool',
          'notStorable' => true
        ]
      ],
      'links' => [],
      'collection' => [
        'orderBy' => 'name',
        'order' => 'asc',
        'sortBy' => 'name',
        'asc' => true
      ],
      'hooksDisabled' => true
    ],
    'EmailFilter' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 100,
          'tooltip' => true,
          'pattern' => '$noBadCharacters'
        ],
        'from' => [
          'type' => 'varchar',
          'maxLength' => 255,
          'tooltip' => true
        ],
        'to' => [
          'type' => 'varchar',
          'maxLength' => 255,
          'tooltip' => true
        ],
        'subject' => [
          'type' => 'varchar',
          'maxLength' => 255,
          'tooltip' => true
        ],
        'bodyContains' => [
          'type' => 'array',
          'tooltip' => true
        ],
        'bodyContainsAll' => [
          'type' => 'array',
          'tooltip' => true
        ],
        'isGlobal' => [
          'type' => 'bool',
          'tooltip' => true,
          'default' => false,
          'readOnlyAfterCreate' => true
        ],
        'parent' => [
          'type' => 'linkParent',
          'view' => 'views/email-filter/fields/parent',
          'readOnlyAfterCreate' => true
        ],
        'action' => [
          'type' => 'enum',
          'default' => 'Skip',
          'options' => [
            0 => 'Skip',
            1 => 'Move to Folder',
            2 => 'Move to Group Folder',
            3 => 'None'
          ]
        ],
        'emailFolder' => [
          'type' => 'link',
          'view' => 'views/email-filter/fields/email-folder'
        ],
        'groupEmailFolder' => [
          'type' => 'link'
        ],
        'markAsRead' => [
          'type' => 'bool'
        ],
        'skipNotification' => [
          'type' => 'bool'
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => [
          'type' => 'link',
          'readOnly' => true
        ]
      ],
      'links' => [
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'parent' => [
          'type' => 'belongsToParent',
          'entityList' => [
            0 => 'User',
            1 => 'EmailAccount',
            2 => 'InboundEmail'
          ]
        ],
        'emailFolder' => [
          'type' => 'belongsTo',
          'entity' => 'EmailFolder'
        ],
        'groupEmailFolder' => [
          'type' => 'belongsTo',
          'entity' => 'GroupEmailFolder'
        ]
      ],
      'collection' => [
        'orderBy' => 'createdAt',
        'order' => 'desc',
        'sortBy' => 'createdAt',
        'asc' => false
      ]
    ],
    'EmailFolder' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 64,
          'pattern' => '$noBadCharacters'
        ],
        'order' => [
          'type' => 'int'
        ],
        'assignedUser' => [
          'type' => 'link',
          'readOnly' => true
        ],
        'skipNotifications' => [
          'type' => 'bool'
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => [
          'type' => 'link',
          'readOnly' => true
        ]
      ],
      'links' => [
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'assignedUser' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ],
      'collection' => [
        'orderBy' => 'order',
        'order' => 'asc',
        'sortBy' => 'order',
        'asc' => true
      ]
    ],
    'EmailTemplate' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'required' => true
        ],
        'subject' => [
          'type' => 'varchar'
        ],
        'body' => [
          'type' => 'wysiwyg',
          'view' => 'views/email-template/fields/body',
          'useIframe' => true,
          'attachmentField' => 'attachments'
        ],
        'isHtml' => [
          'type' => 'bool',
          'default' => true,
          'inlineEditDisabled' => true
        ],
        'oneOff' => [
          'type' => 'bool',
          'default' => false,
          'tooltip' => true
        ],
        'attachments' => [
          'type' => 'attachmentMultiple'
        ],
        'category' => [
          'type' => 'link',
          'view' => 'views/fields/link-category-tree'
        ],
        'assignedUser' => [
          'type' => 'link',
          'view' => 'views/fields/assigned-user'
        ],
        'teams' => [
          'type' => 'linkMultiple'
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user'
        ],
        'modifiedBy' => [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user'
        ]
      ],
      'links' => [
        'attachments' => [
          'type' => 'hasChildren',
          'entity' => 'Attachment',
          'foreign' => 'parent'
        ],
        'category' => [
          'type' => 'belongsTo',
          'foreign' => 'emailTemplates',
          'entity' => 'EmailTemplateCategory'
        ],
        'teams' => [
          'type' => 'hasMany',
          'entity' => 'Team',
          'relationName' => 'entityTeam'
        ],
        'assignedUser' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ],
      'collection' => [
        'orderBy' => 'createdAt',
        'order' => 'desc',
        'textFilterFields' => [
          0 => 'name',
          1 => 'subject'
        ],
        'sortBy' => 'createdAt',
        'asc' => false
      ],
      'optimisticConcurrencyControl' => true
    ],
    'EmailTemplateCategory' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'required' => true
        ],
        'order' => [
          'type' => 'int',
          'minValue' => 1,
          'required' => true,
          'textFilterDisabled' => true
        ],
        'description' => [
          'type' => 'text'
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => [
          'type' => 'link',
          'readOnly' => true
        ],
        'teams' => [
          'type' => 'linkMultiple'
        ],
        'parent' => [
          'type' => 'link'
        ],
        'childList' => [
          'type' => 'jsonArray',
          'notStorable' => true,
          'name' => 'childList',
          'label' => 'Lista filho',
          'dynamicLogicVisible' => NULL,
          'dynamicLogicReadOnly' => NULL,
          'inlineEditDisabled' => false,
          'tooltip' => false
        ]
      ],
      'links' => [
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'teams' => [
          'type' => 'hasMany',
          'entity' => 'Team',
          'relationName' => 'entityTeam',
          'layoutRelationshipsDisabled' => true
        ],
        'parent' => [
          'type' => 'belongsTo',
          'foreign' => 'children',
          'entity' => 'EmailTemplateCategory'
        ],
        'children' => [
          'type' => 'hasMany',
          'foreign' => 'parent',
          'entity' => 'EmailTemplateCategory',
          'readOnly' => true
        ],
        'emailTemplates' => [
          'type' => 'hasMany',
          'foreign' => 'category',
          'entity' => 'EmailTemplate',
          'audited' => false
        ]
      ],
      'collection' => [
        'orderBy' => 'parent',
        'order' => 'asc',
        'sortBy' => 'parent',
        'asc' => true
      ],
      'additionalTables' => [
        'EmailTemplateCategoryPath' => [
          'attributes' => [
            'id' => [
              'type' => 'id',
              'dbType' => 'integer',
              'len' => 11,
              'autoincrement' => true
            ],
            'ascendorId' => [
              'type' => 'foreignId',
              'index' => true
            ],
            'descendorId' => [
              'type' => 'foreignId',
              'index' => true
            ]
          ]
        ]
      ],
      'repositoryClassName' => 'Espo\\Core\\Repositories\\CategoryTree'
    ],
    'Export' => [
      'fields' => [
        'status' => [
          'type' => 'enum',
          'options' => [
            0 => 'Pending',
            1 => 'Running',
            2 => 'Success',
            3 => 'Failed'
          ],
          'default' => 'Pending'
        ],
        'params' => [
          'type' => 'text'
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => [
          'type' => 'link',
          'required' => true
        ],
        'notifyOnFinish' => [
          'type' => 'bool',
          'default' => false
        ],
        'attachment' => [
          'type' => 'link',
          'entity' => 'Attachment'
        ]
      ],
      'links' => [
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ]
    ],
    'Extension' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'required' => true
        ],
        'version' => [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 50
        ],
        'fileList' => [
          'type' => 'jsonArray'
        ],
        'licenseStatus' => [
          'type' => 'enum',
          'options' => [
            0 => '',
            1 => 'Valid',
            2 => 'Invalid',
            3 => 'Expired',
            4 => 'Soft-Expired'
          ],
          'index' => true,
          'maxLength' => 36
        ],
        'licenseStatusMessage' => [
          'type' => 'varchar'
        ],
        'description' => [
          'type' => 'text'
        ],
        'isInstalled' => [
          'type' => 'bool',
          'default' => false
        ],
        'checkVersionUrl' => [
          'type' => 'url'
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true
        ]
      ],
      'links' => [
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ],
      'collection' => [
        'orderBy' => 'createdAt',
        'order' => 'desc',
        'sortBy' => 'createdAt',
        'asc' => false
      ],
      'hooksDisabled' => true
    ],
    'ExternalAccount' => [
      'fields' => [
        'id' => [
          'type' => 'id',
          'dbType' => 'string',
          'maxLength' => 64
        ],
        'data' => [
          'type' => 'jsonObject'
        ],
        'enabled' => [
          'type' => 'bool'
        ],
        'isLocked' => [
          'type' => 'bool'
        ]
      ]
    ],
    'GroupEmailFolder' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 64,
          'pattern' => '$noBadCharacters'
        ],
        'order' => [
          'type' => 'int'
        ],
        'teams' => [
          'type' => 'linkMultiple'
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => [
          'type' => 'link',
          'readOnly' => true
        ]
      ],
      'links' => [
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'teams' => [
          'type' => 'hasMany',
          'entity' => 'Team',
          'foreign' => 'groupEmailFolders'
        ],
        'emails' => [
          'type' => 'hasMany',
          'entity' => 'Email',
          'foreign' => 'groupFolder'
        ]
      ],
      'collection' => [
        'orderBy' => 'order',
        'order' => 'asc',
        'sortBy' => 'order',
        'asc' => true
      ]
    ],
    'Import' => [
      'fields' => [
        'entityType' => [
          'type' => 'enum',
          'translation' => 'Global.scopeNames',
          'required' => true,
          'readOnly' => true,
          'view' => 'views/fields/entity-type'
        ],
        'status' => [
          'type' => 'enum',
          'options' => [
            0 => 'Standby',
            1 => 'Pending',
            2 => 'In Process',
            3 => 'Complete',
            4 => 'Failed'
          ],
          'readOnly' => true,
          'style' => [
            'Complete' => 'success',
            'Failed' => 'danger'
          ]
        ],
        'file' => [
          'type' => 'file',
          'required' => true,
          'readOnly' => true
        ],
        'importedCount' => [
          'type' => 'int',
          'readOnly' => true,
          'notStorable' => true
        ],
        'duplicateCount' => [
          'type' => 'int',
          'readOnly' => true,
          'notStorable' => true
        ],
        'updatedCount' => [
          'type' => 'int',
          'readOnly' => true,
          'notStorable' => true
        ],
        'lastIndex' => [
          'type' => 'int',
          'readOnly' => true
        ],
        'params' => [
          'type' => 'jsonObject',
          'readOnly' => true
        ],
        'attributeList' => [
          'type' => 'jsonArray',
          'readOnly' => true
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true
        ]
      ],
      'links' => [
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'errors' => [
          'type' => 'hasMany',
          'entity' => 'ImportError',
          'foreign' => 'import',
          'readOnly' => true
        ]
      ],
      'collection' => [
        'orderBy' => 'createdAt',
        'order' => 'desc',
        'sortBy' => 'createdAt',
        'asc' => false
      ]
    ],
    'ImportEml' => [
      'fields' => [
        'file' => [
          'type' => 'file'
        ]
      ],
      'skipRebuild' => true
    ],
    'ImportEntity' => [
      'fields' => [
        'id' => [
          'type' => 'id',
          'dbType' => 'bigint',
          'autoincrement' => true
        ],
        'entity' => [
          'type' => 'linkParent'
        ],
        'import' => [
          'type' => 'link'
        ],
        'isImported' => [
          'type' => 'bool'
        ],
        'isUpdated' => [
          'type' => 'bool'
        ],
        'isDuplicate' => [
          'type' => 'bool'
        ]
      ],
      'indexes' => [
        'entityImport' => [
          'columns' => [
            0 => 'importId',
            1 => 'entityType'
          ]
        ]
      ]
    ],
    'ImportError' => [
      'fields' => [
        'import' => [
          'type' => 'link',
          'readOnly' => true
        ],
        'entityType' => [
          'type' => 'foreign',
          'link' => 'import',
          'field' => 'entityType'
        ],
        'rowIndex' => [
          'type' => 'int',
          'readOnly' => true,
          'tooltip' => true
        ],
        'exportRowIndex' => [
          'type' => 'int',
          'readOnly' => true
        ],
        'lineNumber' => [
          'type' => 'int',
          'readOnly' => true,
          'tooltip' => true,
          'notStorable' => true,
          'view' => 'views/import-error/fields/line-number'
        ],
        'exportLineNumber' => [
          'type' => 'int',
          'readOnly' => true,
          'tooltip' => true,
          'notStorable' => true,
          'view' => 'views/import-error/fields/line-number'
        ],
        'type' => [
          'type' => 'enum',
          'options' => [
            0 => '',
            1 => 'Validation',
            2 => 'No-Access',
            3 => 'Not-Found',
            4 => 'Integrity-Constraint-Violation'
          ],
          'readOnly' => true
        ],
        'validationFailures' => [
          'type' => 'jsonArray',
          'readOnly' => true,
          'view' => 'views/import-error/fields/validation-failures'
        ],
        'row' => [
          'type' => 'array',
          'readOnly' => true,
          'displayAsList' => true,
          'doNotStoreArrayValues' => true
        ]
      ],
      'links' => [
        'import' => [
          'type' => 'belongsTo',
          'entity' => 'Import',
          'foreign' => 'errors',
          'foreignName' => 'id'
        ]
      ],
      'collection' => [
        'orderBy' => 'rowIndex',
        'sortBy' => 'rowIndex'
      ],
      'indexes' => [
        'rowIndex' => [
          'columns' => [
            0 => 'rowIndex'
          ]
        ],
        'importRowIndex' => [
          'columns' => [
            0 => 'importId',
            1 => 'rowIndex'
          ]
        ]
      ]
    ],
    'InboundEmail' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'required' => true,
          'pattern' => '$noBadCharacters'
        ],
        'emailAddress' => [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 100,
          'view' => 'views/inbound-email/fields/email-address'
        ],
        'status' => [
          'type' => 'enum',
          'options' => [
            0 => 'Active',
            1 => 'Inactive'
          ],
          'default' => 'Active'
        ],
        'host' => [
          'type' => 'varchar'
        ],
        'port' => [
          'type' => 'int',
          'min' => 0,
          'max' => 65535,
          'default' => 993
        ],
        'security' => [
          'type' => 'enum',
          'default' => 'SSL',
          'options' => [
            0 => '',
            1 => 'SSL',
            2 => 'TLS'
          ]
        ],
        'username' => [
          'type' => 'varchar'
        ],
        'password' => [
          'type' => 'password'
        ],
        'monitoredFolders' => [
          'type' => 'array',
          'default' => [
            0 => 'INBOX'
          ],
          'view' => 'views/inbound-email/fields/folders',
          'displayAsList' => true,
          'noEmptyString' => true,
          'duplicateIgnore' => true
        ],
        'fetchSince' => [
          'type' => 'date',
          'validatorClassNameList' => [
            0 => 'Espo\\Classes\\FieldValidators\\InboundEmail\\FetchSince\\Required'
          ],
          'forceValidation' => true
        ],
        'fetchData' => [
          'type' => 'jsonObject',
          'readOnly' => true,
          'duplicateIgnore' => true
        ],
        'assignToUser' => [
          'type' => 'link',
          'tooltip' => true
        ],
        'team' => [
          'type' => 'link',
          'tooltip' => true
        ],
        'teams' => [
          'type' => 'linkMultiple',
          'tooltip' => true
        ],
        'addAllTeamUsers' => [
          'type' => 'bool',
          'tooltip' => true,
          'default' => true
        ],
        'isSystem' => [
          'type' => 'bool',
          'notStorable' => true,
          'readOnly' => true,
          'directAccessDisabled' => true,
          'tooltip' => true
        ],
        'sentFolder' => [
          'type' => 'varchar',
          'view' => 'views/inbound-email/fields/folder',
          'duplicateIgnore' => true
        ],
        'storeSentEmails' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'keepFetchedEmailsUnread' => [
          'type' => 'bool'
        ],
        'connectedAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'excludeFromReply' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'useImap' => [
          'type' => 'bool',
          'default' => true
        ],
        'useSmtp' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'smtpIsShared' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'smtpIsForMassEmail' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'smtpHost' => [
          'type' => 'varchar'
        ],
        'smtpPort' => [
          'type' => 'int',
          'min' => 0,
          'max' => 65535,
          'default' => 587
        ],
        'smtpAuth' => [
          'type' => 'bool',
          'default' => true
        ],
        'smtpSecurity' => [
          'type' => 'enum',
          'default' => 'TLS',
          'options' => [
            0 => '',
            1 => 'SSL',
            2 => 'TLS'
          ]
        ],
        'smtpUsername' => [
          'type' => 'varchar'
        ],
        'smtpPassword' => [
          'type' => 'password'
        ],
        'smtpAuthMechanism' => [
          'type' => 'enum',
          'options' => [
            0 => 'login',
            1 => 'crammd5',
            2 => 'plain'
          ],
          'default' => 'login'
        ],
        'createCase' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'caseDistribution' => [
          'type' => 'enum',
          'options' => [
            0 => '',
            1 => 'Direct-Assignment',
            2 => 'Round-Robin',
            3 => 'Least-Busy'
          ],
          'default' => 'Direct-Assignment',
          'tooltip' => true
        ],
        'targetUserPosition' => [
          'type' => 'enum',
          'view' => 'views/inbound-email/fields/target-user-position',
          'tooltip' => true
        ],
        'reply' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'replyEmailTemplate' => [
          'type' => 'link'
        ],
        'replyFromAddress' => [
          'type' => 'varchar'
        ],
        'replyToAddress' => [
          'type' => 'varchar',
          'view' => 'views/fields/email-address',
          'tooltip' => true
        ],
        'replyFromName' => [
          'type' => 'varchar'
        ],
        'fromName' => [
          'type' => 'varchar'
        ],
        'groupEmailFolder' => [
          'type' => 'link',
          'tooltip' => true
        ],
        'imapHandler' => [
          'type' => 'varchar',
          'readOnly' => true
        ],
        'smtpHandler' => [
          'type' => 'varchar',
          'readOnly' => true
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => [
          'type' => 'link',
          'readOnly' => true
        ]
      ],
      'links' => [
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'teams' => [
          'type' => 'hasMany',
          'entity' => 'Team',
          'foreign' => 'inboundEmails'
        ],
        'assignToUser' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'team' => [
          'type' => 'belongsTo',
          'entity' => 'Team'
        ],
        'replyEmailTemplate' => [
          'type' => 'belongsTo',
          'entity' => 'EmailTemplate'
        ],
        'filters' => [
          'type' => 'hasChildren',
          'foreign' => 'parent',
          'entity' => 'EmailFilter'
        ],
        'emails' => [
          'type' => 'hasMany',
          'entity' => 'Email',
          'foreign' => 'inboundEmails',
          'audited' => false
        ],
        'groupEmailFolder' => [
          'type' => 'belongsTo',
          'entity' => 'GroupEmailFolder'
        ]
      ],
      'collection' => [
        'orderBy' => 'name',
        'order' => 'asc',
        'sortBy' => 'name',
        'asc' => true
      ]
    ],
    'Integration' => [
      'fields' => [
        'id' => [
          'type' => 'id',
          'dbType' => 'string',
          'maxLength' => 24
        ],
        'data' => [
          'type' => 'jsonObject'
        ],
        'enabled' => [
          'type' => 'bool'
        ]
      ]
    ],
    'Job' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'required' => true,
          'view' => 'views/admin/job/fields/name'
        ],
        'status' => [
          'type' => 'enum',
          'options' => [
            0 => 'Pending',
            1 => 'Ready',
            2 => 'Running',
            3 => 'Success',
            4 => 'Failed'
          ],
          'default' => 'Pending',
          'style' => [
            'Success' => 'success',
            'Failed' => 'danger',
            'Running' => 'warning',
            'Ready' => 'warning'
          ],
          'maxLength' => 16
        ],
        'executeTime' => [
          'type' => 'datetime',
          'required' => true,
          'hasSeconds' => true
        ],
        'number' => [
          'type' => 'int',
          'index' => true,
          'readOnly' => true,
          'view' => 'views/fields/autoincrement',
          'dbType' => 'bigint',
          'unique' => true,
          'autoincrement' => true
        ],
        'className' => [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 255
        ],
        'serviceName' => [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 100
        ],
        'methodName' => [
          'type' => 'varchar',
          'maxLength' => 100
        ],
        'job' => [
          'type' => 'varchar',
          'view' => 'views/scheduled-job/fields/job'
        ],
        'data' => [
          'type' => 'jsonObject'
        ],
        'scheduledJob' => [
          'type' => 'link'
        ],
        'scheduledJobJob' => [
          'type' => 'foreign',
          'link' => 'scheduledJob',
          'field' => 'job'
        ],
        'queue' => [
          'type' => 'varchar',
          'maxLength' => 36,
          'default' => NULL
        ],
        'group' => [
          'type' => 'varchar',
          'maxLength' => 128,
          'default' => NULL
        ],
        'targetGroup' => [
          'type' => 'varchar',
          'maxLength' => 128,
          'default' => NULL
        ],
        'startedAt' => [
          'type' => 'datetime',
          'hasSeconds' => true
        ],
        'executedAt' => [
          'type' => 'datetime',
          'hasSeconds' => true
        ],
        'pid' => [
          'type' => 'int'
        ],
        'attempts' => [
          'type' => 'int'
        ],
        'targetId' => [
          'type' => 'varchar',
          'maxLength' => 48
        ],
        'targetType' => [
          'type' => 'varchar',
          'maxLength' => 64
        ],
        'failedAttempts' => [
          'type' => 'int'
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true,
          'hasSeconds' => true
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true,
          'hasSeconds' => true
        ]
      ],
      'links' => [
        'scheduledJob' => [
          'type' => 'belongsTo',
          'entity' => 'ScheduledJob'
        ]
      ],
      'collection' => [
        'orderBy' => 'number',
        'order' => 'desc',
        'textFilterFields' => [
          0 => 'id',
          1 => 'name',
          2 => 'methodName',
          3 => 'serviceName'
        ],
        'countDisabled' => true,
        'sortBy' => 'number',
        'asc' => false
      ],
      'indexes' => [
        'executeTime' => [
          'columns' => [
            0 => 'status',
            1 => 'executeTime'
          ]
        ],
        'status' => [
          'columns' => [
            0 => 'status',
            1 => 'deleted'
          ]
        ],
        'statusScheduledJobId' => [
          'columns' => [
            0 => 'status',
            1 => 'scheduledJobId'
          ]
        ]
      ],
      'hooksDisabled' => true
    ],
    'KanbanOrder' => [
      'fields' => [
        'order' => [
          'type' => 'int',
          'dbType' => 'smallint'
        ],
        'entity' => [
          'type' => 'linkParent'
        ],
        'group' => [
          'type' => 'varchar',
          'maxLength' => 100
        ],
        'user' => [
          'type' => 'link'
        ]
      ],
      'links' => [
        'entity' => [
          'type' => 'belongsToParent'
        ]
      ],
      'indexes' => [
        'entityUserId' => [
          'columns' => [
            0 => 'entityType',
            1 => 'entityId',
            2 => 'userId'
          ]
        ],
        'entityType' => [
          'columns' => [
            0 => 'entityType'
          ]
        ],
        'entityTypeUserId' => [
          'columns' => [
            0 => 'entityType',
            1 => 'userId'
          ]
        ]
      ]
    ],
    'LayoutRecord' => [
      'fields' => [
        'name' => [
          'type' => 'varchar'
        ],
        'layoutSet' => [
          'type' => 'link'
        ],
        'data' => [
          'type' => 'text'
        ]
      ],
      'links' => [
        'layoutSet' => [
          'type' => 'belongsTo',
          'entity' => 'LayoutSet',
          'foreign' => 'layoutRecords'
        ]
      ],
      'indexes' => [
        'nameLayoutSetId' => [
          'columns' => [
            0 => 'name',
            1 => 'layoutSetId'
          ]
        ]
      ]
    ],
    'LayoutSet' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 100
        ],
        'layoutList' => [
          'type' => 'multiEnum',
          'displayAsList' => true,
          'view' => 'views/layout-set/fields/layout-list'
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ]
      ],
      'links' => [
        'layoutRecords' => [
          'type' => 'hasMany',
          'entity' => 'LayoutRecord',
          'foreign' => 'layoutSet'
        ],
        'teams' => [
          'type' => 'hasMany',
          'entity' => 'Team',
          'foreign' => 'layoutSet'
        ],
        'portals' => [
          'type' => 'hasMany',
          'entity' => 'Portal',
          'foreign' => 'layoutSet'
        ]
      ],
      'collection' => [
        'orderBy' => 'name',
        'order' => 'asc',
        'sortBy' => 'name',
        'asc' => true
      ]
    ],
    'LeadCapture' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'maxLength' => 100
        ],
        'campaign' => [
          'type' => 'link',
          'audited' => true
        ],
        'isActive' => [
          'type' => 'bool',
          'default' => true,
          'audited' => true
        ],
        'subscribeToTargetList' => [
          'type' => 'bool',
          'default' => true,
          'audited' => true
        ],
        'subscribeContactToTargetList' => [
          'type' => 'bool',
          'default' => true,
          'audited' => true
        ],
        'targetList' => [
          'type' => 'link',
          'audited' => true
        ],
        'fieldList' => [
          'type' => 'multiEnum',
          'default' => [
            0 => 'firstName',
            1 => 'lastName',
            2 => 'emailAddress'
          ],
          'view' => 'views/lead-capture/fields/field-list',
          'displayAsList' => true,
          'required' => true,
          'ignoreFieldList' => [
            0 => 'targetList',
            1 => 'targetLists',
            2 => 'acceptanceStatus',
            3 => 'acceptanceStatusMeetings',
            4 => 'acceptanceStatusCalls',
            5 => 'campaign',
            6 => 'source',
            7 => 'teams',
            8 => 'createdOpportunity',
            9 => 'createdAccount',
            10 => 'createdContact',
            11 => 'emailAddressIsOptedOut',
            12 => 'emailAddressIsInvalid',
            13 => 'phoneNumberIsOptedOut',
            14 => 'phoneNumberIsInvalid',
            15 => 'opportunityAmountCurrency',
            16 => 'originalEmail'
          ],
          'webFormFieldTypeList' => [
            0 => 'varchar',
            1 => 'email',
            2 => 'phone',
            3 => 'text',
            4 => 'personName',
            5 => 'enum',
            6 => 'multiEnum',
            7 => 'array',
            8 => 'checklist',
            9 => 'int',
            10 => 'float',
            11 => 'currency',
            12 => 'date',
            13 => 'datetime',
            14 => 'boolean',
            15 => 'url',
            16 => 'urlMultiple',
            17 => 'address'
          ],
          'audited' => true
        ],
        'fieldParams' => [
          'type' => 'jsonObject',
          'audited' => true
        ],
        'duplicateCheck' => [
          'type' => 'bool',
          'default' => true,
          'audited' => true
        ],
        'optInConfirmation' => [
          'type' => 'bool',
          'audited' => true
        ],
        'optInConfirmationEmailTemplate' => [
          'type' => 'link',
          'audited' => true
        ],
        'optInConfirmationLifetime' => [
          'type' => 'int',
          'default' => 48,
          'min' => 1,
          'audited' => true
        ],
        'optInConfirmationSuccessMessage' => [
          'type' => 'text',
          'tooltip' => true,
          'audited' => true
        ],
        'createLeadBeforeOptInConfirmation' => [
          'type' => 'bool',
          'audited' => true
        ],
        'skipOptInConfirmationIfSubscribed' => [
          'type' => 'bool',
          'audited' => true
        ],
        'leadSource' => [
          'type' => 'enum',
          'customizationOptionsDisabled' => true,
          'optionsPath' => 'entityDefs.Lead.fields.source.options',
          'translation' => 'Lead.options.source',
          'default' => 'Web Site',
          'audited' => true
        ],
        'apiKey' => [
          'type' => 'varchar',
          'maxLength' => 36,
          'readOnly' => true
        ],
        'formId' => [
          'type' => 'varchar',
          'maxLength' => 17,
          'readOnly' => true
        ],
        'formEnabled' => [
          'type' => 'bool',
          'audited' => true
        ],
        'formText' => [
          'type' => 'text',
          'tooltip' => 'optInConfirmationSuccessMessage'
        ],
        'formSuccessText' => [
          'type' => 'text',
          'tooltip' => 'optInConfirmationSuccessMessage'
        ],
        'formSuccessRedirectUrl' => [
          'type' => 'url',
          'audited' => true
        ],
        'formLanguage' => [
          'type' => 'enum',
          'maxLength' => 5,
          'view' => 'views/preferences/fields/language',
          'audited' => true
        ],
        'formFrameAncestors' => [
          'type' => 'urlMultiple',
          'audited' => true
        ],
        'formCaptcha' => [
          'type' => 'bool',
          'audited' => true,
          'tooltip' => true
        ],
        'targetTeam' => [
          'type' => 'link',
          'audited' => true
        ],
        'exampleRequestUrl' => [
          'type' => 'varchar',
          'notStorable' => true,
          'readOnly' => true,
          'copyToClipboard' => true
        ],
        'exampleRequestMethod' => [
          'type' => 'varchar',
          'notStorable' => true,
          'readOnly' => true
        ],
        'exampleRequestPayload' => [
          'type' => 'text',
          'notStorable' => true,
          'readOnly' => true,
          'seeMoreDisabled' => true
        ],
        'exampleRequestHeaders' => [
          'type' => 'array',
          'notStorable' => true,
          'readOnly' => true
        ],
        'formUrl' => [
          'type' => 'url',
          'notStorable' => true,
          'readOnly' => true,
          'copyToClipboard' => true
        ],
        'inboundEmail' => [
          'type' => 'link',
          'audited' => true
        ],
        'smtpAccount' => [
          'type' => 'base',
          'notStorable' => true,
          'view' => 'views/lead-capture/fields/smtp-account'
        ],
        'phoneNumberCountry' => [
          'type' => 'enum',
          'view' => 'views/lead-capture/fields/phone-number-country',
          'maxLength' => 2
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => [
          'type' => 'link',
          'readOnly' => true
        ]
      ],
      'links' => [
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'targetList' => [
          'type' => 'belongsTo',
          'entity' => 'TargetList'
        ],
        'campaign' => [
          'type' => 'belongsTo',
          'entity' => 'Campaign'
        ],
        'targetTeam' => [
          'type' => 'belongsTo',
          'entity' => 'Team'
        ],
        'inboundEmail' => [
          'type' => 'belongsTo',
          'entity' => 'InboundEmail'
        ],
        'optInConfirmationEmailTemplate' => [
          'type' => 'belongsTo',
          'entity' => 'EmailTemplate'
        ],
        'logRecords' => [
          'type' => 'hasMany',
          'entity' => 'LeadCaptureLogRecord',
          'foreign' => 'leadCapture'
        ]
      ],
      'collection' => [
        'orderBy' => 'name',
        'order' => 'asc',
        'sortBy' => 'name',
        'asc' => true
      ]
    ],
    'LeadCaptureLogRecord' => [
      'fields' => [
        'number' => [
          'type' => 'autoincrement',
          'index' => true,
          'readOnly' => true
        ],
        'data' => [
          'type' => 'jsonObject'
        ],
        'isCreated' => [
          'type' => 'bool'
        ],
        'description' => [
          'type' => 'text'
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'leadCapture' => [
          'type' => 'link'
        ],
        'target' => [
          'type' => 'linkParent'
        ]
      ],
      'links' => [
        'leadCapture' => [
          'type' => 'belongsTo',
          'entity' => 'LeadCapture',
          'foreign' => 'logRecords'
        ],
        'target' => [
          'type' => 'belongsToParent',
          'entityList' => [
            0 => 'Contact',
            1 => 'Lead'
          ]
        ]
      ],
      'collection' => [
        'orderBy' => 'number',
        'order' => 'desc',
        'sortBy' => 'number',
        'asc' => false
      ]
    ],
    'MassAction' => [
      'fields' => [
        'entityType' => [
          'type' => 'varchar',
          'required' => true
        ],
        'action' => [
          'type' => 'varchar',
          'required' => true
        ],
        'status' => [
          'type' => 'enum',
          'options' => [
            0 => 'Pending',
            1 => 'Running',
            2 => 'Success',
            3 => 'Failed'
          ],
          'default' => 'Pending'
        ],
        'data' => [
          'type' => 'jsonObject'
        ],
        'params' => [
          'type' => 'text'
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => [
          'type' => 'link',
          'required' => true
        ],
        'processedCount' => [
          'type' => 'int'
        ],
        'notifyOnFinish' => [
          'type' => 'bool',
          'default' => false
        ]
      ],
      'links' => [
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ]
    ],
    'NextNumber' => [
      'fields' => [
        'entityType' => [
          'type' => 'varchar',
          'index' => true,
          'maxLength' => 100
        ],
        'fieldName' => [
          'type' => 'varchar',
          'maxLength' => 100
        ],
        'value' => [
          'type' => 'int',
          'default' => 1
        ]
      ],
      'indexes' => [
        'entityTypeFieldName' => [
          'columns' => [
            0 => 'entityType',
            1 => 'fieldName'
          ]
        ]
      ],
      'hooksDisabled' => true
    ],
    'Note' => [
      'fields' => [
        'post' => [
          'type' => 'text',
          'rows' => 100000,
          'view' => 'views/note/fields/post',
          'preview' => true,
          'attachmentField' => 'attachments',
          'customizationDefaultDisabled' => true,
          'customizationRequiredDisabled' => true,
          'customizationInlineEditDisabledDisabled' => true,
          'customizationTooltipTextDisabled' => true,
          'customizationSeeMoreDisabledDisabled' => true,
          'customizationRowsDisabled' => true,
          'customizationDisplayRawTextDisabled' => true,
          'customizationReadOnlyDisabled' => true,
          'dynamicLogicDisabled' => true
        ],
        'data' => [
          'type' => 'jsonObject',
          'readOnly' => true,
          'customizationDisabled' => true
        ],
        'type' => [
          'type' => 'enum',
          'readOnly' => true,
          'view' => 'views/note/fields/type',
          'options' => [
            0 => 'Post',
            1 => 'Create',
            2 => 'CreateRelated',
            3 => 'Update',
            4 => 'Status',
            5 => 'Assign',
            6 => 'Relate',
            7 => 'Unrelate',
            8 => 'EmailReceived',
            9 => 'EmailSent'
          ],
          'maxLength' => 24,
          'customizationDisabled' => true,
          'default' => 'Post'
        ],
        'targetType' => [
          'type' => 'enum',
          'options' => [
            0 => 'self',
            1 => 'all',
            2 => 'teams',
            3 => 'users',
            4 => 'portals'
          ],
          'maxLength' => 7,
          'customizationDisabled' => true,
          'readOnlyAfterCreate' => true
        ],
        'parent' => [
          'type' => 'linkParent',
          'customizationDisabled' => true,
          'view' => 'views/note/fields/parent',
          'readOnlyAfterCreate' => true
        ],
        'related' => [
          'type' => 'linkParent',
          'readOnly' => true,
          'customizationDisabled' => true,
          'view' => 'views/note/fields/related'
        ],
        'attachments' => [
          'type' => 'attachmentMultiple',
          'view' => 'views/stream/fields/attachment-multiple',
          'customizationRequiredDisabled' => true,
          'customizationPreviewSizeDisabled' => true,
          'customizationInlineEditDisabledDisabled' => true,
          'customizationTooltipTextDisabled' => true,
          'dynamicLogicDisabled' => true
        ],
        'number' => [
          'type' => 'autoincrement',
          'index' => true,
          'dbType' => 'bigint',
          'readOnly' => true,
          'customizationDisabled' => true
        ],
        'teams' => [
          'type' => 'linkMultiple',
          'noLoad' => true,
          'customizationDisabled' => true,
          'readOnlyAfterCreate' => true
        ],
        'portals' => [
          'type' => 'linkMultiple',
          'noLoad' => true,
          'customizationDisabled' => true,
          'readOnlyAfterCreate' => true
        ],
        'users' => [
          'type' => 'linkMultiple',
          'noLoad' => true,
          'customizationDisabled' => true,
          'readOnlyAfterCreate' => true
        ],
        'isGlobal' => [
          'type' => 'bool',
          'customizationDisabled' => true,
          'readOnlyAfterCreate' => true
        ],
        'createdByGender' => [
          'type' => 'foreign',
          'link' => 'createdBy',
          'field' => 'gender',
          'customizationDisabled' => true
        ],
        'notifiedUserIdList' => [
          'type' => 'jsonArray',
          'notStorable' => true,
          'utility' => true,
          'customizationDisabled' => true,
          'readOnly' => true
        ],
        'isInternal' => [
          'type' => 'bool',
          'customizationDisabled' => true,
          'readOnlyAfterCreate' => true
        ],
        'isPinned' => [
          'type' => 'bool',
          'customizationDisabled' => true,
          'readOnly' => true
        ],
        'reactionCounts' => [
          'type' => 'jsonObject',
          'notStorable' => true,
          'readOnly' => true,
          'customizationDisabled' => true,
          'utility' => true
        ],
        'myReactions' => [
          'type' => 'jsonArray',
          'notStorable' => true,
          'readOnly' => true,
          'customizationDisabled' => true,
          'utility' => true
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true,
          'customizationDisabled' => true
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true,
          'customizationDisabled' => true
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true,
          'customizationDisabled' => true,
          'view' => 'views/fields/user'
        ],
        'modifiedBy' => [
          'type' => 'link',
          'readOnly' => true,
          'customizationDisabled' => true,
          'view' => 'views/fields/user'
        ]
      ],
      'links' => [
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'attachments' => [
          'type' => 'hasChildren',
          'entity' => 'Attachment',
          'relationName' => 'attachments',
          'foreign' => 'parent'
        ],
        'parent' => [
          'type' => 'belongsToParent',
          'foreign' => 'notes'
        ],
        'superParent' => [
          'type' => 'belongsToParent'
        ],
        'related' => [
          'type' => 'belongsToParent'
        ],
        'teams' => [
          'type' => 'hasMany',
          'entity' => 'Team',
          'foreign' => 'notes'
        ],
        'portals' => [
          'type' => 'hasMany',
          'entity' => 'Portal',
          'foreign' => 'notes'
        ],
        'users' => [
          'type' => 'hasMany',
          'entity' => 'User',
          'foreign' => 'notes'
        ]
      ],
      'collection' => [
        'orderBy' => 'number',
        'order' => 'desc',
        'textFilterFields' => [
          0 => 'post'
        ],
        'fullTextSearch' => true,
        'fullTextSearchOrderType' => 'original',
        'sortBy' => 'number',
        'asc' => false
      ],
      'statusStyles' => [
        'Lead' => [],
        'Case' => [],
        'Opportunity' => [],
        'Task' => []
      ],
      'indexes' => [
        'createdAt' => [
          'type' => 'index',
          'columns' => [
            0 => 'createdAt'
          ]
        ],
        'createdByNumber' => [
          'columns' => [
            0 => 'createdById',
            1 => 'number'
          ]
        ],
        'type' => [
          'type' => 'index',
          'columns' => [
            0 => 'type'
          ]
        ],
        'targetType' => [
          'type' => 'index',
          'columns' => [
            0 => 'targetType'
          ]
        ],
        'parentId' => [
          'type' => 'index',
          'columns' => [
            0 => 'parentId'
          ]
        ],
        'parentType' => [
          'type' => 'index',
          'columns' => [
            0 => 'parentType'
          ]
        ],
        'relatedId' => [
          'type' => 'index',
          'columns' => [
            0 => 'relatedId'
          ]
        ],
        'relatedType' => [
          'type' => 'index',
          'columns' => [
            0 => 'relatedType'
          ]
        ],
        'superParentType' => [
          'type' => 'index',
          'columns' => [
            0 => 'superParentType'
          ]
        ],
        'superParentId' => [
          'type' => 'index',
          'columns' => [
            0 => 'superParentId'
          ]
        ]
      ],
      'streamRelated' => [
        'Opportunity' => [
          0 => 'quotes'
        ]
      ]
    ],
    'Notification' => [
      'fields' => [
        'number' => [
          'type' => 'autoincrement',
          'dbType' => 'bigint',
          'index' => true
        ],
        'data' => [
          'type' => 'jsonObject'
        ],
        'noteData' => [
          'type' => 'jsonObject',
          'notStorable' => true,
          'orderDisabled' => true
        ],
        'type' => [
          'type' => 'varchar'
        ],
        'read' => [
          'type' => 'bool'
        ],
        'emailIsProcessed' => [
          'type' => 'bool'
        ],
        'user' => [
          'type' => 'link'
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'message' => [
          'type' => 'text'
        ],
        'related' => [
          'type' => 'linkParent',
          'readOnly' => true
        ],
        'relatedParent' => [
          'type' => 'linkParent',
          'readOnly' => true
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user'
        ]
      ],
      'links' => [
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User',
          'noJoin' => true
        ],
        'user' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'related' => [
          'type' => 'belongsToParent'
        ],
        'relatedParent' => [
          'type' => 'belongsToParent'
        ]
      ],
      'collection' => [
        'orderBy' => 'number',
        'order' => 'desc',
        'sortBy' => 'number',
        'asc' => false
      ],
      'indexes' => [
        'createdAt' => [
          'type' => 'index',
          'columns' => [
            0 => 'createdAt'
          ]
        ],
        'user' => [
          'type' => 'index',
          'columns' => [
            0 => 'userId',
            1 => 'createdAt'
          ]
        ]
      ]
    ],
    'PasswordChangeRequest' => [
      'fields' => [
        'requestId' => [
          'type' => 'varchar',
          'maxLength' => 64,
          'index' => true
        ],
        'user' => [
          'type' => 'link',
          'readOnly' => true,
          'index' => true
        ],
        'url' => [
          'type' => 'url'
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ]
      ],
      'links' => [
        'user' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ]
    ],
    'PhoneNumber' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 36,
          'index' => true
        ],
        'type' => [
          'type' => 'enum'
        ],
        'numeric' => [
          'type' => 'varchar',
          'maxLength' => 36,
          'index' => true
        ],
        'invalid' => [
          'type' => 'bool'
        ],
        'optOut' => [
          'type' => 'bool'
        ],
        'primary' => [
          'type' => 'bool',
          'notStorable' => true
        ]
      ],
      'links' => [],
      'collection' => [
        'orderBy' => 'name',
        'order' => 'asc',
        'sortBy' => 'name',
        'asc' => true
      ],
      'hooksDisabled' => true
    ],
    'Portal' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'pattern' => '$noBadCharacters'
        ],
        'logo' => [
          'type' => 'image'
        ],
        'url' => [
          'type' => 'url',
          'notStorable' => true,
          'readOnly' => true
        ],
        'customId' => [
          'type' => 'varchar',
          'maxLength' => 36,
          'view' => 'views/portal/fields/custom-id',
          'index' => true
        ],
        'isActive' => [
          'type' => 'bool',
          'default' => true
        ],
        'isDefault' => [
          'type' => 'bool',
          'default' => false,
          'notStorable' => true
        ],
        'portalRoles' => [
          'type' => 'linkMultiple'
        ],
        'tabList' => [
          'type' => 'array',
          'view' => 'views/portal/fields/tab-list',
          'validationList' => [
            0 => 'array',
            1 => 'required'
          ],
          'suppressValidationList' => [
            0 => 'arrayOfString'
          ],
          'doNotStoreArrayValues' => true
        ],
        'quickCreateList' => [
          'type' => 'array',
          'translation' => 'Global.scopeNames',
          'view' => 'views/portal/fields/quick-create-list'
        ],
        'applicationName' => [
          'type' => 'varchar'
        ],
        'companyLogo' => [
          'type' => 'image'
        ],
        'theme' => [
          'type' => 'enum',
          'view' => 'views/preferences/fields/theme',
          'translation' => 'Global.themes'
        ],
        'themeParams' => [
          'type' => 'jsonObject'
        ],
        'language' => [
          'type' => 'enum',
          'view' => 'views/preferences/fields/language'
        ],
        'timeZone' => [
          'type' => 'enum',
          'view' => 'views/preferences/fields/time-zone'
        ],
        'dateFormat' => [
          'type' => 'enum',
          'view' => 'views/preferences/fields/date-format'
        ],
        'timeFormat' => [
          'type' => 'enum',
          'view' => 'views/preferences/fields/time-format'
        ],
        'weekStart' => [
          'type' => 'enumInt',
          'options' => [
            0 => 0,
            1 => 1,
            2 => 2,
            3 => 3,
            4 => 4,
            5 => 5,
            6 => 6
          ],
          'default' => -1,
          'view' => 'views/preferences/fields/week-start'
        ],
        'defaultCurrency' => [
          'type' => 'enum',
          'view' => 'views/preferences/fields/default-currency'
        ],
        'dashboardLayout' => [
          'type' => 'jsonArray',
          'view' => 'views/settings/fields/dashboard-layout'
        ],
        'dashletsOptions' => [
          'type' => 'jsonObject',
          'utility' => true
        ],
        'customUrl' => [
          'type' => 'url'
        ],
        'layoutSet' => [
          'type' => 'link',
          'tooltip' => true
        ],
        'authenticationProvider' => [
          'type' => 'link'
        ],
        'authTokenLifetime' => [
          'type' => 'float',
          'min' => 0,
          'tooltip' => 'Settings.authTokenMaxIdleTime'
        ],
        'authTokenMaxIdleTime' => [
          'type' => 'float',
          'min' => 0,
          'tooltip' => 'Settings.authTokenMaxIdleTime'
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedBy' => [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user'
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user'
        ]
      ],
      'links' => [
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'users' => [
          'type' => 'hasMany',
          'entity' => 'User',
          'foreign' => 'portals',
          'audited' => false
        ],
        'portalRoles' => [
          'type' => 'hasMany',
          'entity' => 'PortalRole',
          'foreign' => 'portals'
        ],
        'notes' => [
          'type' => 'hasMany',
          'entity' => 'Note',
          'foreign' => 'portals'
        ],
        'layoutSet' => [
          'type' => 'belongsTo',
          'entity' => 'LayoutSet',
          'foreign' => 'portals'
        ],
        'authenticationProvider' => [
          'type' => 'belongsTo',
          'entity' => 'AuthenticationProvider'
        ],
        'articles' => [
          'type' => 'hasMany',
          'entity' => 'KnowledgeBaseArticle',
          'foreign' => 'portals',
          'audited' => false
        ],
        'reports' => [
          'type' => 'hasMany',
          'entity' => 'Report',
          'foreign' => 'portals'
        ]
      ],
      'collection' => [
        'orderBy' => 'name',
        'order' => 'asc',
        'sortBy' => 'name',
        'asc' => true
      ]
    ],
    'PortalRole' => [
      'fields' => [
        'name' => [
          'maxLength' => 150,
          'required' => true,
          'type' => 'varchar',
          'pattern' => '$noBadCharacters'
        ],
        'data' => [
          'type' => 'jsonObject',
          'audited' => true
        ],
        'fieldData' => [
          'type' => 'jsonObject',
          'audited' => true
        ],
        'exportPermission' => [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'yes',
            2 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => 'Role.exportPermission',
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'massUpdatePermission' => [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'yes',
            2 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => 'Role.massUpdatePermission',
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ]
      ],
      'links' => [
        'users' => [
          'type' => 'hasMany',
          'entity' => 'User',
          'foreign' => 'portalRoles',
          'audited' => false
        ],
        'portals' => [
          'type' => 'hasMany',
          'entity' => 'Portal',
          'foreign' => 'portalRoles'
        ]
      ],
      'collection' => [
        'orderBy' => 'name',
        'order' => 'asc',
        'sortBy' => 'name',
        'asc' => true
      ]
    ],
    'Preferences' => [
      'fields' => [
        'timeZone' => [
          'type' => 'enum',
          'view' => 'views/preferences/fields/time-zone'
        ],
        'dateFormat' => [
          'type' => 'enum',
          'view' => 'views/preferences/fields/date-format'
        ],
        'timeFormat' => [
          'type' => 'enum',
          'view' => 'views/preferences/fields/time-format'
        ],
        'weekStart' => [
          'type' => 'enumInt',
          'options' => [
            0 => 0,
            1 => 1,
            2 => 2,
            3 => 3,
            4 => 4,
            5 => 5,
            6 => 6
          ],
          'default' => -1,
          'view' => 'views/preferences/fields/week-start'
        ],
        'defaultCurrency' => [
          'type' => 'enum',
          'view' => 'views/preferences/fields/default-currency'
        ],
        'thousandSeparator' => [
          'type' => 'varchar',
          'default' => ',',
          'maxLength' => 1,
          'view' => 'views/settings/fields/thousand-separator',
          'options' => [
            0 => '.',
            1 => ',',
            2 => '\''
          ],
          'validatorClassNameList' => [
            0 => 'Espo\\Classes\\FieldValidators\\Settings\\ThousandSeparator\\Valid'
          ]
        ],
        'decimalMark' => [
          'type' => 'varchar',
          'default' => '.',
          'required' => true,
          'maxLength' => 1,
          'options' => [
            0 => '.',
            1 => ','
          ]
        ],
        'dashboardLayout' => [
          'type' => 'jsonArray',
          'view' => 'views/settings/fields/dashboard-layout'
        ],
        'dashletsOptions' => [
          'type' => 'jsonObject'
        ],
        'dashboardLocked' => [
          'type' => 'bool'
        ],
        'importParams' => [
          'type' => 'jsonObject'
        ],
        'sharedCalendarUserList' => [
          'type' => 'jsonArray'
        ],
        'calendarViewDataList' => [
          'type' => 'jsonArray'
        ],
        'presetFilters' => [
          'type' => 'jsonObject'
        ],
        'language' => [
          'type' => 'enum',
          'view' => 'views/preferences/fields/language'
        ],
        'exportDelimiter' => [
          'type' => 'varchar',
          'default' => ',',
          'required' => true,
          'maxLength' => 1,
          'options' => [
            0 => ',',
            1 => ';',
            2 => '\\t',
            3 => '|'
          ]
        ],
        'receiveAssignmentEmailNotifications' => [
          'type' => 'bool',
          'default' => true
        ],
        'receiveMentionEmailNotifications' => [
          'type' => 'bool',
          'default' => true
        ],
        'receiveStreamEmailNotifications' => [
          'type' => 'bool',
          'default' => true
        ],
        'assignmentNotificationsIgnoreEntityTypeList' => [
          'type' => 'checklist',
          'translation' => 'Global.scopeNamesPlural',
          'view' => 'views/preferences/fields/assignment-notifications-ignore-entity-type-list',
          'default' => []
        ],
        'assignmentEmailNotificationsIgnoreEntityTypeList' => [
          'type' => 'checklist',
          'translation' => 'Global.scopeNamesPlural',
          'view' => 'views/preferences/fields/assignment-email-notifications-ignore-entity-type-list'
        ],
        'reactionNotifications' => [
          'type' => 'bool',
          'default' => true
        ],
        'autoFollowEntityTypeList' => [
          'type' => 'multiEnum',
          'view' => 'views/preferences/fields/auto-follow-entity-type-list',
          'translation' => 'Global.scopeNamesPlural',
          'notStorable' => true,
          'tooltip' => true
        ],
        'signature' => [
          'type' => 'wysiwyg',
          'view' => 'views/preferences/fields/signature'
        ],
        'defaultReminders' => [
          'type' => 'jsonArray',
          'view' => 'crm:views/meeting/fields/reminders',
          'default' => [],
          'validatorClassNameList' => [
            0 => 'Espo\\Modules\\Crm\\Classes\\FieldValidators\\Event\\Reminders\\Valid',
            1 => 'Espo\\Modules\\Crm\\Classes\\FieldValidators\\Event\\Reminders\\MaxCount'
          ]
        ],
        'defaultRemindersTask' => [
          'type' => 'jsonArray',
          'view' => 'crm:views/meeting/fields/reminders',
          'default' => [],
          'validatorClassNameList' => [
            0 => 'Espo\\Modules\\Crm\\Classes\\FieldValidators\\Event\\Reminders\\Valid',
            1 => 'Espo\\Modules\\Crm\\Classes\\FieldValidators\\Event\\Reminders\\MaxCount'
          ]
        ],
        'theme' => [
          'type' => 'enum',
          'view' => 'views/preferences/fields/theme',
          'translation' => 'Global.themes'
        ],
        'themeParams' => [
          'type' => 'jsonObject'
        ],
        'useCustomTabList' => [
          'type' => 'bool',
          'default' => false
        ],
        'addCustomTabs' => [
          'type' => 'bool',
          'default' => false,
          'tooltip' => true
        ],
        'tabList' => [
          'type' => 'array',
          'view' => 'views/preferences/fields/tab-list',
          'validationList' => [
            0 => 'array',
            1 => 'required'
          ],
          'mandatoryValidationList' => [
            0 => 'array'
          ]
        ],
        'emailReplyToAllByDefault' => [
          'type' => 'bool',
          'default' => true
        ],
        'emailReplyForceHtml' => [
          'type' => 'bool',
          'default' => true
        ],
        'isPortalUser' => [
          'type' => 'bool',
          'notStorable' => true
        ],
        'doNotFillAssignedUserIfNotRequired' => [
          'type' => 'bool',
          'tooltip' => true,
          'default' => true
        ],
        'followEntityOnStreamPost' => [
          'type' => 'bool',
          'default' => true
        ],
        'followCreatedEntities' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'followCreatedEntityTypeList' => [
          'type' => 'multiEnum',
          'view' => 'views/preferences/fields/auto-follow-entity-type-list',
          'translation' => 'Global.scopeNamesPlural',
          'default' => [],
          'tooltip' => true
        ],
        'emailUseExternalClient' => [
          'type' => 'bool',
          'default' => false
        ],
        'scopeColorsDisabled' => [
          'type' => 'bool',
          'default' => false
        ],
        'tabColorsDisabled' => [
          'type' => 'bool',
          'default' => false
        ],
        'textSearchStoringDisabled' => [
          'type' => 'bool',
          'default' => false
        ],
        'calendarSlotDuration' => [
          'type' => 'enumInt',
          'options' => [
            0 => '',
            1 => 15,
            2 => 30
          ],
          'default' => NULL,
          'view' => 'views/preferences/fields/calendar-slot-duration'
        ],
        'calendarScrollHour' => [
          'type' => 'enumInt',
          'options' => [
            0 => '',
            1 => 0,
            2 => 1,
            3 => 2,
            4 => 3,
            5 => 4,
            6 => 5,
            7 => 6,
            8 => 7,
            9 => 8,
            10 => 9,
            11 => 10,
            12 => 11,
            13 => 12,
            14 => 14,
            15 => 15
          ],
          'default' => NULL,
          'view' => 'views/preferences/fields/calendar-scroll-hour'
        ]
      ],
      'noDeletedAttribute' => true,
      'modifierClassName' => 'Espo\\Core\\Utils\\Database\\Schema\\EntityDefsModifiers\\JsonData'
    ],
    'Role' => [
      'fields' => [
        'name' => [
          'maxLength' => 150,
          'required' => true,
          'type' => 'varchar',
          'pattern' => '$noBadCharacters'
        ],
        'assignmentPermission' => [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'all',
            2 => 'team',
            3 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => true,
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'userPermission' => [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'all',
            2 => 'team',
            3 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => true,
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'messagePermission' => [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'all',
            2 => 'team',
            3 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => true,
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'portalPermission' => [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'yes',
            2 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => true,
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'groupEmailAccountPermission' => [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'all',
            2 => 'team',
            3 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => true,
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'exportPermission' => [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'yes',
            2 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => true,
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'massUpdatePermission' => [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'yes',
            2 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => true,
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'dataPrivacyPermission' => [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'yes',
            2 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => true,
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'followerManagementPermission' => [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'all',
            2 => 'team',
            3 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => true,
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'auditPermission' => [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'yes',
            2 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => true,
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'mentionPermission' => [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'all',
            2 => 'team',
            3 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => true,
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'userCalendarPermission' => [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'all',
            2 => 'team',
            3 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => true,
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'data' => [
          'type' => 'jsonObject',
          'audited' => true
        ],
        'fieldData' => [
          'type' => 'jsonObject',
          'audited' => true
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ]
      ],
      'links' => [
        'users' => [
          'type' => 'hasMany',
          'entity' => 'User',
          'foreign' => 'roles',
          'audited' => false
        ],
        'teams' => [
          'type' => 'hasMany',
          'entity' => 'Team',
          'foreign' => 'roles'
        ]
      ],
      'collection' => [
        'orderBy' => 'name',
        'order' => 'asc',
        'sortBy' => 'name',
        'asc' => true
      ]
    ],
    'ScheduledJob' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'required' => true
        ],
        'job' => [
          'type' => 'varchar',
          'required' => true,
          'view' => 'views/scheduled-job/fields/job'
        ],
        'status' => [
          'type' => 'enum',
          'options' => [
            0 => 'Active',
            1 => 'Inactive'
          ],
          'default' => 'Active',
          'audited' => true
        ],
        'scheduling' => [
          'type' => 'varchar',
          'required' => true,
          'view' => 'views/scheduled-job/fields/scheduling',
          'tooltip' => true,
          'audited' => true,
          'validatorClassNameList' => [
            0 => 'Espo\\Classes\\FieldValidators\\ScheduledJob\\Scheduling\\Valid'
          ]
        ],
        'lastRun' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => [
          'type' => 'link',
          'readOnly' => true
        ],
        'isInternal' => [
          'type' => 'bool',
          'readOnly' => true,
          'disabled' => true,
          'default' => false
        ]
      ],
      'links' => [
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'log' => [
          'type' => 'hasMany',
          'entity' => 'ScheduledJobLogRecord',
          'foreign' => 'scheduledJob'
        ]
      ],
      'collection' => [
        'orderBy' => 'name',
        'order' => 'asc',
        'sortBy' => 'name',
        'asc' => true
      ],
      'jobSchedulingMap' => [
        'CheckInboundEmails' => '*/2 * * * *',
        'CheckEmailAccounts' => '*/1 * * * *',
        'SendEmailReminders' => '*/2 * * * *',
        'Cleanup' => '1 1 * * 0',
        'AuthTokenControl' => '*/6 * * * *',
        'SendEmailNotifications' => '*/2 * * * *',
        'ProcessWebhookQueue' => '*/2 * * * *',
        'SendScheduledEmails' => '*/10 * * * *',
        'ProcessMassEmail' => '10,30,50 * * * *',
        'ControlKnowledgeBaseArticleStatus' => '10 1 * * *',
        'ReportTargetListSync' => '0 2 * * *',
        'ScheduleReportSending' => '0 * * * *',
        'RunScheduledWorkflows' => '*/10 * * * *',
        'ProcessPendingProcessFlows' => '* * * * *',
        'InventoryCompress' => '10 0 * * 6',
        'NotActualOrderLocking' => '10 1 * * 6',
        'InventoryDetach' => '10 2 * * 6'
      ],
      'jobs' => [
        'SubmitPopupReminders' => [
          'name' => 'Submit Popup Reminders',
          'isSystem' => true,
          'scheduling' => '* * * * *'
        ],
        'EblaForm' => [
          'isSystem' => true,
          'scheduling' => '3 3 * * 6'
        ]
      ]
    ],
    'ScheduledJobLogRecord' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'required' => true,
          'readOnly' => true
        ],
        'status' => [
          'type' => 'enum',
          'readOnly' => true,
          'options' => [
            0 => 'Success',
            1 => 'Failed'
          ],
          'style' => [
            'Success' => 'success',
            'Failed' => 'danger'
          ]
        ],
        'executionTime' => [
          'type' => 'datetime',
          'readOnly' => true,
          'hasSeconds' => true
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'scheduledJob' => [
          'type' => 'link'
        ],
        'target' => [
          'type' => 'linkParent'
        ]
      ],
      'links' => [
        'scheduledJob' => [
          'type' => 'belongsTo',
          'entity' => 'ScheduledJob'
        ]
      ],
      'collection' => [
        'orderBy' => 'executionTime',
        'order' => 'desc',
        'sortBy' => 'executionTime',
        'asc' => false
      ],
      'indexes' => [
        'scheduledJobIdExecutionTime' => [
          'type' => 'index',
          'columns' => [
            0 => 'scheduledJobId',
            1 => 'executionTime'
          ]
        ]
      ]
    ],
    'Settings' => [
      'skipRebuild' => true,
      'fields' => [
        'useCache' => [
          'type' => 'bool',
          'default' => true,
          'tooltip' => true
        ],
        'recordsPerPage' => [
          'type' => 'int',
          'min' => 1,
          'max' => 200,
          'default' => 20,
          'required' => true,
          'tooltip' => true
        ],
        'recordsPerPageSmall' => [
          'type' => 'int',
          'min' => 1,
          'max' => 100,
          'default' => 5,
          'required' => true,
          'tooltip' => true
        ],
        'recordsPerPageSelect' => [
          'type' => 'int',
          'min' => 1,
          'max' => 100,
          'default' => 10,
          'required' => true,
          'tooltip' => true
        ],
        'recordsPerPageKanban' => [
          'type' => 'int',
          'min' => 1,
          'max' => 100,
          'required' => true,
          'tooltip' => true
        ],
        'timeZone' => [
          'type' => 'enum',
          'default' => 'UTC',
          'options' => [
            0 => 'UTC',
            1 => 'Africa/Abidjan',
            2 => 'Africa/Accra',
            3 => 'Africa/Addis_Ababa',
            4 => 'Africa/Algiers',
            5 => 'Africa/Asmara',
            6 => 'Africa/Bamako',
            7 => 'Africa/Bangui',
            8 => 'Africa/Banjul',
            9 => 'Africa/Bissau',
            10 => 'Africa/Blantyre',
            11 => 'Africa/Brazzaville',
            12 => 'Africa/Bujumbura',
            13 => 'Africa/Cairo',
            14 => 'Africa/Casablanca',
            15 => 'Africa/Ceuta',
            16 => 'Africa/Conakry',
            17 => 'Africa/Dakar',
            18 => 'Africa/Dar_es_Salaam',
            19 => 'Africa/Djibouti',
            20 => 'Africa/Douala',
            21 => 'Africa/El_Aaiun',
            22 => 'Africa/Freetown',
            23 => 'Africa/Gaborone',
            24 => 'Africa/Harare',
            25 => 'Africa/Johannesburg',
            26 => 'Africa/Juba',
            27 => 'Africa/Kampala',
            28 => 'Africa/Khartoum',
            29 => 'Africa/Kigali',
            30 => 'Africa/Kinshasa',
            31 => 'Africa/Lagos',
            32 => 'Africa/Libreville',
            33 => 'Africa/Lome',
            34 => 'Africa/Luanda',
            35 => 'Africa/Lubumbashi',
            36 => 'Africa/Lusaka',
            37 => 'Africa/Malabo',
            38 => 'Africa/Maputo',
            39 => 'Africa/Maseru',
            40 => 'Africa/Mbabane',
            41 => 'Africa/Mogadishu',
            42 => 'Africa/Monrovia',
            43 => 'Africa/Nairobi',
            44 => 'Africa/Ndjamena',
            45 => 'Africa/Niamey',
            46 => 'Africa/Nouakchott',
            47 => 'Africa/Ouagadougou',
            48 => 'Africa/Porto-Novo',
            49 => 'Africa/Sao_Tome',
            50 => 'Africa/Tripoli',
            51 => 'Africa/Tunis',
            52 => 'Africa/Windhoek',
            53 => 'America/Adak',
            54 => 'America/Anchorage',
            55 => 'America/Anguilla',
            56 => 'America/Antigua',
            57 => 'America/Araguaina',
            58 => 'America/Argentina/Buenos_Aires',
            59 => 'America/Argentina/Catamarca',
            60 => 'America/Argentina/Cordoba',
            61 => 'America/Argentina/Jujuy',
            62 => 'America/Argentina/La_Rioja',
            63 => 'America/Argentina/Mendoza',
            64 => 'America/Argentina/Rio_Gallegos',
            65 => 'America/Argentina/Salta',
            66 => 'America/Argentina/San_Juan',
            67 => 'America/Argentina/San_Luis',
            68 => 'America/Argentina/Tucuman',
            69 => 'America/Argentina/Ushuaia',
            70 => 'America/Aruba',
            71 => 'America/Asuncion',
            72 => 'America/Atikokan',
            73 => 'America/Bahia',
            74 => 'America/Bahia_Banderas',
            75 => 'America/Barbados',
            76 => 'America/Belem',
            77 => 'America/Belize',
            78 => 'America/Blanc-Sablon',
            79 => 'America/Boa_Vista',
            80 => 'America/Bogota',
            81 => 'America/Boise',
            82 => 'America/Cambridge_Bay',
            83 => 'America/Campo_Grande',
            84 => 'America/Cancun',
            85 => 'America/Caracas',
            86 => 'America/Cayenne',
            87 => 'America/Cayman',
            88 => 'America/Chicago',
            89 => 'America/Chihuahua',
            90 => 'America/Costa_Rica',
            91 => 'America/Creston',
            92 => 'America/Cuiaba',
            93 => 'America/Curacao',
            94 => 'America/Danmarkshavn',
            95 => 'America/Dawson',
            96 => 'America/Dawson_Creek',
            97 => 'America/Denver',
            98 => 'America/Detroit',
            99 => 'America/Dominica',
            100 => 'America/Edmonton',
            101 => 'America/Eirunepe',
            102 => 'America/El_Salvador',
            103 => 'America/Fortaleza',
            104 => 'America/Glace_Bay',
            105 => 'America/Godthab',
            106 => 'America/Goose_Bay',
            107 => 'America/Grand_Turk',
            108 => 'America/Grenada',
            109 => 'America/Guadeloupe',
            110 => 'America/Guatemala',
            111 => 'America/Guayaquil',
            112 => 'America/Guyana',
            113 => 'America/Halifax',
            114 => 'America/Havana',
            115 => 'America/Hermosillo',
            116 => 'America/Indiana/Indianapolis',
            117 => 'America/Indiana/Knox',
            118 => 'America/Indiana/Marengo',
            119 => 'America/Indiana/Petersburg',
            120 => 'America/Indiana/Tell_City',
            121 => 'America/Indiana/Vevay',
            122 => 'America/Indiana/Vincennes',
            123 => 'America/Indiana/Winamac',
            124 => 'America/Inuvik',
            125 => 'America/Iqaluit',
            126 => 'America/Jamaica',
            127 => 'America/Juneau',
            128 => 'America/Kentucky/Louisville',
            129 => 'America/Kentucky/Monticello',
            130 => 'America/Kralendijk',
            131 => 'America/La_Paz',
            132 => 'America/Lima',
            133 => 'America/Los_Angeles',
            134 => 'America/Lower_Princes',
            135 => 'America/Maceio',
            136 => 'America/Managua',
            137 => 'America/Manaus',
            138 => 'America/Marigot',
            139 => 'America/Martinique',
            140 => 'America/Matamoros',
            141 => 'America/Mazatlan',
            142 => 'America/Menominee',
            143 => 'America/Merida',
            144 => 'America/Metlakatla',
            145 => 'America/Mexico_City',
            146 => 'America/Miquelon',
            147 => 'America/Moncton',
            148 => 'America/Monterrey',
            149 => 'America/Montevideo',
            150 => 'America/Montserrat',
            151 => 'America/Nassau',
            152 => 'America/New_York',
            153 => 'America/Nipigon',
            154 => 'America/Nome',
            155 => 'America/Noronha',
            156 => 'America/North_Dakota/Beulah',
            157 => 'America/North_Dakota/Center',
            158 => 'America/North_Dakota/New_Salem',
            159 => 'America/Ojinaga',
            160 => 'America/Panama',
            161 => 'America/Pangnirtung',
            162 => 'America/Paramaribo',
            163 => 'America/Phoenix',
            164 => 'America/Port-au-Prince',
            165 => 'America/Port_of_Spain',
            166 => 'America/Porto_Velho',
            167 => 'America/Puerto_Rico',
            168 => 'America/Rainy_River',
            169 => 'America/Rankin_Inlet',
            170 => 'America/Recife',
            171 => 'America/Regina',
            172 => 'America/Resolute',
            173 => 'America/Rio_Branco',
            174 => 'America/Santa_Isabel',
            175 => 'America/Santarem',
            176 => 'America/Santiago',
            177 => 'America/Santo_Domingo',
            178 => 'America/Sao_Paulo',
            179 => 'America/Scoresbysund',
            180 => 'America/Sitka',
            181 => 'America/St_Barthelemy',
            182 => 'America/St_Johns',
            183 => 'America/St_Kitts',
            184 => 'America/St_Lucia',
            185 => 'America/St_Thomas',
            186 => 'America/St_Vincent',
            187 => 'America/Swift_Current',
            188 => 'America/Tegucigalpa',
            189 => 'America/Thule',
            190 => 'America/Thunder_Bay',
            191 => 'America/Tijuana',
            192 => 'America/Toronto',
            193 => 'America/Tortola',
            194 => 'America/Vancouver',
            195 => 'America/Whitehorse',
            196 => 'America/Winnipeg',
            197 => 'America/Yakutat',
            198 => 'America/Yellowknife',
            199 => 'Antarctica/Casey',
            200 => 'Antarctica/Davis',
            201 => 'Antarctica/DumontDUrville',
            202 => 'Antarctica/Macquarie',
            203 => 'Antarctica/Mawson',
            204 => 'Antarctica/McMurdo',
            205 => 'Antarctica/Palmer',
            206 => 'Antarctica/Rothera',
            207 => 'Antarctica/Syowa',
            208 => 'Antarctica/Vostok',
            209 => 'Arctic/Longyearbyen',
            210 => 'Asia/Aden',
            211 => 'Asia/Almaty',
            212 => 'Asia/Amman',
            213 => 'Asia/Anadyr',
            214 => 'Asia/Aqtau',
            215 => 'Asia/Aqtobe',
            216 => 'Asia/Ashgabat',
            217 => 'Asia/Baghdad',
            218 => 'Asia/Bahrain',
            219 => 'Asia/Baku',
            220 => 'Asia/Bangkok',
            221 => 'Asia/Beirut',
            222 => 'Asia/Bishkek',
            223 => 'Asia/Brunei',
            224 => 'Asia/Choibalsan',
            225 => 'Asia/Chongqing',
            226 => 'Asia/Colombo',
            227 => 'Asia/Damascus',
            228 => 'Asia/Dhaka',
            229 => 'Asia/Dili',
            230 => 'Asia/Dubai',
            231 => 'Asia/Dushanbe',
            232 => 'Asia/Gaza',
            233 => 'Asia/Harbin',
            234 => 'Asia/Hebron',
            235 => 'Asia/Ho_Chi_Minh',
            236 => 'Asia/Hong_Kong',
            237 => 'Asia/Hovd',
            238 => 'Asia/Irkutsk',
            239 => 'Asia/Jakarta',
            240 => 'Asia/Jayapura',
            241 => 'Asia/Jerusalem',
            242 => 'Asia/Kabul',
            243 => 'Asia/Kamchatka',
            244 => 'Asia/Karachi',
            245 => 'Asia/Kashgar',
            246 => 'Asia/Kathmandu',
            247 => 'Asia/Khandyga',
            248 => 'Asia/Kolkata',
            249 => 'Asia/Krasnoyarsk',
            250 => 'Asia/Kuala_Lumpur',
            251 => 'Asia/Kuching',
            252 => 'Asia/Kuwait',
            253 => 'Asia/Macau',
            254 => 'Asia/Magadan',
            255 => 'Asia/Makassar',
            256 => 'Asia/Manila',
            257 => 'Asia/Muscat',
            258 => 'Asia/Nicosia',
            259 => 'Asia/Novokuznetsk',
            260 => 'Asia/Novosibirsk',
            261 => 'Asia/Omsk',
            262 => 'Asia/Oral',
            263 => 'Asia/Phnom_Penh',
            264 => 'Asia/Pontianak',
            265 => 'Asia/Pyongyang',
            266 => 'Asia/Qatar',
            267 => 'Asia/Qyzylorda',
            268 => 'Asia/Rangoon',
            269 => 'Asia/Riyadh',
            270 => 'Asia/Sakhalin',
            271 => 'Asia/Samarkand',
            272 => 'Asia/Seoul',
            273 => 'Asia/Shanghai',
            274 => 'Asia/Singapore',
            275 => 'Asia/Taipei',
            276 => 'Asia/Tashkent',
            277 => 'Asia/Tbilisi',
            278 => 'Asia/Tehran',
            279 => 'Asia/Thimphu',
            280 => 'Asia/Tokyo',
            281 => 'Asia/Ulaanbaatar',
            282 => 'Asia/Urumqi',
            283 => 'Asia/Ust-Nera',
            284 => 'Asia/Vientiane',
            285 => 'Asia/Vladivostok',
            286 => 'Asia/Yakutsk',
            287 => 'Asia/Yekaterinburg',
            288 => 'Asia/Yerevan',
            289 => 'Atlantic/Azores',
            290 => 'Atlantic/Bermuda',
            291 => 'Atlantic/Canary',
            292 => 'Atlantic/Cape_Verde',
            293 => 'Atlantic/Faroe',
            294 => 'Atlantic/Madeira',
            295 => 'Atlantic/Reykjavik',
            296 => 'Atlantic/South_Georgia',
            297 => 'Atlantic/St_Helena',
            298 => 'Atlantic/Stanley',
            299 => 'Australia/Adelaide',
            300 => 'Australia/Brisbane',
            301 => 'Australia/Broken_Hill',
            302 => 'Australia/Currie',
            303 => 'Australia/Darwin',
            304 => 'Australia/Eucla',
            305 => 'Australia/Hobart',
            306 => 'Australia/Lindeman',
            307 => 'Australia/Lord_Howe',
            308 => 'Australia/Melbourne',
            309 => 'Australia/Perth',
            310 => 'Australia/Sydney',
            311 => 'Europe/Amsterdam',
            312 => 'Europe/Andorra',
            313 => 'Europe/Athens',
            314 => 'Europe/Belgrade',
            315 => 'Europe/Berlin',
            316 => 'Europe/Bratislava',
            317 => 'Europe/Brussels',
            318 => 'Europe/Bucharest',
            319 => 'Europe/Budapest',
            320 => 'Europe/Busingen',
            321 => 'Europe/Chisinau',
            322 => 'Europe/Copenhagen',
            323 => 'Europe/Dublin',
            324 => 'Europe/Gibraltar',
            325 => 'Europe/Guernsey',
            326 => 'Europe/Helsinki',
            327 => 'Europe/Isle_of_Man',
            328 => 'Europe/Istanbul',
            329 => 'Europe/Jersey',
            330 => 'Europe/Kaliningrad',
            331 => 'Europe/Kyiv',
            332 => 'Europe/Lisbon',
            333 => 'Europe/Ljubljana',
            334 => 'Europe/London',
            335 => 'Europe/Luxembourg',
            336 => 'Europe/Madrid',
            337 => 'Europe/Malta',
            338 => 'Europe/Mariehamn',
            339 => 'Europe/Minsk',
            340 => 'Europe/Monaco',
            341 => 'Europe/Moscow',
            342 => 'Europe/Oslo',
            343 => 'Europe/Paris',
            344 => 'Europe/Podgorica',
            345 => 'Europe/Prague',
            346 => 'Europe/Riga',
            347 => 'Europe/Rome',
            348 => 'Europe/Samara',
            349 => 'Europe/San_Marino',
            350 => 'Europe/Sarajevo',
            351 => 'Europe/Simferopol',
            352 => 'Europe/Skopje',
            353 => 'Europe/Sofia',
            354 => 'Europe/Stockholm',
            355 => 'Europe/Tallinn',
            356 => 'Europe/Tirane',
            357 => 'Europe/Uzhhorod',
            358 => 'Europe/Vaduz',
            359 => 'Europe/Vatican',
            360 => 'Europe/Vienna',
            361 => 'Europe/Vilnius',
            362 => 'Europe/Volgograd',
            363 => 'Europe/Warsaw',
            364 => 'Europe/Zagreb',
            365 => 'Europe/Zaporizhzhia',
            366 => 'Europe/Zurich',
            367 => 'Indian/Antananarivo',
            368 => 'Indian/Chagos',
            369 => 'Indian/Christmas',
            370 => 'Indian/Cocos',
            371 => 'Indian/Comoro',
            372 => 'Indian/Kerguelen',
            373 => 'Indian/Mahe',
            374 => 'Indian/Maldives',
            375 => 'Indian/Mauritius',
            376 => 'Indian/Mayotte',
            377 => 'Indian/Reunion',
            378 => 'Pacific/Apia',
            379 => 'Pacific/Auckland',
            380 => 'Pacific/Chatham',
            381 => 'Pacific/Chuuk',
            382 => 'Pacific/Easter',
            383 => 'Pacific/Efate',
            384 => 'Pacific/Enderbury',
            385 => 'Pacific/Fakaofo',
            386 => 'Pacific/Fiji',
            387 => 'Pacific/Funafuti',
            388 => 'Pacific/Galapagos',
            389 => 'Pacific/Gambier',
            390 => 'Pacific/Guadalcanal',
            391 => 'Pacific/Guam',
            392 => 'Pacific/Honolulu',
            393 => 'Pacific/Johnston',
            394 => 'Pacific/Kiritimati',
            395 => 'Pacific/Kosrae',
            396 => 'Pacific/Kwajalein',
            397 => 'Pacific/Majuro',
            398 => 'Pacific/Marquesas',
            399 => 'Pacific/Midway',
            400 => 'Pacific/Nauru',
            401 => 'Pacific/Niue',
            402 => 'Pacific/Norfolk',
            403 => 'Pacific/Noumea',
            404 => 'Pacific/Pago_Pago',
            405 => 'Pacific/Palau',
            406 => 'Pacific/Pitcairn',
            407 => 'Pacific/Pohnpei',
            408 => 'Pacific/Port_Moresby',
            409 => 'Pacific/Rarotonga',
            410 => 'Pacific/Saipan',
            411 => 'Pacific/Tahiti',
            412 => 'Pacific/Tarawa',
            413 => 'Pacific/Tongatapu',
            414 => 'Pacific/Wake',
            415 => 'Pacific/Wallis'
          ],
          'global' => true
        ],
        'dateFormat' => [
          'type' => 'enum',
          'default' => 'DD.MM.YYYY',
          'view' => 'views/settings/fields/date-format',
          'global' => true
        ],
        'timeFormat' => [
          'type' => 'enum',
          'default' => 'HH:mm',
          'view' => 'views/settings/fields/time-format',
          'global' => true
        ],
        'weekStart' => [
          'type' => 'enumInt',
          'options' => [
            0 => 0,
            1 => 1,
            2 => 2,
            3 => 3,
            4 => 4,
            5 => 5,
            6 => 6
          ],
          'default' => 0,
          'translation' => 'Global.lists.dayNames'
        ],
        'fiscalYearShift' => [
          'type' => 'enumInt',
          'default' => 0,
          'view' => 'views/settings/fields/fiscal-year-shift'
        ],
        'thousandSeparator' => [
          'type' => 'varchar',
          'default' => ',',
          'maxLength' => 1,
          'view' => 'views/settings/fields/thousand-separator',
          'options' => [
            0 => '.',
            1 => ',',
            2 => '\''
          ],
          'validatorClassNameList' => [
            0 => 'Espo\\Classes\\FieldValidators\\Settings\\ThousandSeparator\\Valid'
          ]
        ],
        'decimalMark' => [
          'type' => 'varchar',
          'default' => '.',
          'required' => true,
          'maxLength' => 1,
          'options' => [
            0 => '.',
            1 => ','
          ]
        ],
        'currencyList' => [
          'type' => 'multiEnum',
          'default' => [
            0 => 'USD',
            1 => 'EUR'
          ],
          'required' => true,
          'view' => 'views/settings/fields/currency-list',
          'tooltip' => true,
          'global' => true
        ],
        'defaultCurrency' => [
          'type' => 'enum',
          'default' => 'USD',
          'required' => true,
          'view' => 'views/settings/fields/default-currency',
          'global' => true
        ],
        'baseCurrency' => [
          'type' => 'enum',
          'default' => 'USD',
          'required' => true,
          'view' => 'views/settings/fields/default-currency'
        ],
        'currencyRates' => [
          'type' => 'base',
          'view' => 'views/settings/fields/currency-rates'
        ],
        'outboundEmailIsShared' => [
          'type' => 'bool',
          'default' => false,
          'tooltip' => true
        ],
        'outboundEmailFromName' => [
          'type' => 'varchar',
          'default' => 'Partners'
        ],
        'outboundEmailFromAddress' => [
          'type' => 'varchar',
          'default' => 'crm@example.com',
          'tooltip' => true,
          'view' => 'views/settings/fields/outbound-email-from-address'
        ],
        'emailAddressLookupEntityTypeList' => [
          'type' => 'multiEnum',
          'tooltip' => true,
          'view' => 'views/settings/fields/email-address-lookup-entity-type-list'
        ],
        'emailAddressSelectEntityTypeList' => [
          'type' => 'multiEnum',
          'tooltip' => true,
          'view' => 'views/settings/fields/email-address-lookup-entity-type-list'
        ],
        'smtpServer' => [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'smtpPort' => [
          'type' => 'int',
          'min' => 0,
          'max' => 65535,
          'default' => 587
        ],
        'smtpAuth' => [
          'type' => 'bool'
        ],
        'smtpSecurity' => [
          'type' => 'enum',
          'default' => 'TLS',
          'options' => [
            0 => '',
            1 => 'SSL',
            2 => 'TLS'
          ]
        ],
        'smtpUsername' => [
          'type' => 'varchar'
        ],
        'smtpPassword' => [
          'type' => 'password'
        ],
        'tabList' => [
          'type' => 'array',
          'view' => 'views/settings/fields/tab-list',
          'validationList' => [
            0 => 'array',
            1 => 'required'
          ],
          'mandatoryValidationList' => [
            0 => 'array'
          ]
        ],
        'quickCreateList' => [
          'type' => 'array',
          'translation' => 'Global.scopeNames',
          'view' => 'views/settings/fields/quick-create-list'
        ],
        'language' => [
          'type' => 'enum',
          'default' => 'en_US',
          'view' => 'views/settings/fields/language',
          'isSorted' => true
        ],
        'globalSearchEntityList' => [
          'type' => 'multiEnum',
          'translation' => 'Global.scopeNames',
          'view' => 'views/settings/fields/global-search-entity-list',
          'tooltip' => true
        ],
        'exportDelimiter' => [
          'type' => 'varchar',
          'default' => ',',
          'required' => true,
          'maxLength' => 1
        ],
        'companyLogo' => [
          'type' => 'image'
        ],
        'authenticationMethod' => [
          'type' => 'enum',
          'default' => 'Espo',
          'view' => 'views/settings/fields/authentication-method'
        ],
        'auth2FA' => [
          'type' => 'bool'
        ],
        'auth2FAMethodList' => [
          'type' => 'multiEnum',
          'view' => 'views/settings/fields/auth-two-fa-method-list'
        ],
        'auth2FAForced' => [
          'type' => 'bool'
        ],
        'auth2FAInPortal' => [
          'type' => 'bool'
        ],
        'passwordRecoveryDisabled' => [
          'type' => 'bool'
        ],
        'passwordRecoveryForAdminDisabled' => [
          'type' => 'bool'
        ],
        'passwordRecoveryForInternalUsersDisabled' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'passwordRecoveryNoExposure' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'passwordGenerateLength' => [
          'type' => 'int',
          'min' => 6,
          'max' => 150,
          'required' => true
        ],
        'passwordStrengthLength' => [
          'type' => 'int',
          'max' => 150,
          'min' => 1
        ],
        'passwordStrengthLetterCount' => [
          'type' => 'int',
          'max' => 150,
          'min' => 0
        ],
        'passwordStrengthNumberCount' => [
          'type' => 'int',
          'max' => 150,
          'min' => 0
        ],
        'passwordStrengthSpecialCharacterCount' => [
          'type' => 'int',
          'max' => 50,
          'min' => 0
        ],
        'passwordStrengthBothCases' => [
          'type' => 'bool'
        ],
        'ldapHost' => [
          'type' => 'varchar'
        ],
        'ldapPort' => [
          'type' => 'varchar',
          'default' => 389
        ],
        'ldapSecurity' => [
          'type' => 'enum',
          'options' => [
            0 => '',
            1 => 'SSL',
            2 => 'TLS'
          ]
        ],
        'ldapAuth' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'ldapUsername' => [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'ldapPassword' => [
          'type' => 'password',
          'tooltip' => true
        ],
        'ldapBindRequiresDn' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'ldapUserLoginFilter' => [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'ldapBaseDn' => [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'ldapAccountCanonicalForm' => [
          'type' => 'enum',
          'options' => [
            0 => 'Dn',
            1 => 'Username',
            2 => 'Backslash',
            3 => 'Principal'
          ],
          'tooltip' => true
        ],
        'ldapAccountDomainName' => [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'ldapAccountDomainNameShort' => [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'ldapAccountFilterFormat' => [
          'type' => 'varchar'
        ],
        'ldapTryUsernameSplit' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'ldapOptReferrals' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'ldapPortalUserLdapAuth' => [
          'type' => 'bool',
          'default' => false,
          'tooltip' => true
        ],
        'ldapCreateEspoUser' => [
          'type' => 'bool',
          'default' => true,
          'tooltip' => true
        ],
        'ldapUserNameAttribute' => [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'ldapUserObjectClass' => [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'ldapUserFirstNameAttribute' => [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'ldapUserLastNameAttribute' => [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'ldapUserTitleAttribute' => [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'ldapUserEmailAddressAttribute' => [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'ldapUserPhoneNumberAttribute' => [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'ldapUserDefaultTeam' => [
          'type' => 'link',
          'tooltip' => true,
          'entity' => 'Team'
        ],
        'ldapUserTeams' => [
          'type' => 'linkMultiple',
          'tooltip' => true,
          'entity' => 'Team'
        ],
        'ldapPortalUserPortals' => [
          'type' => 'linkMultiple',
          'tooltip' => true,
          'entity' => 'Portal'
        ],
        'ldapPortalUserRoles' => [
          'type' => 'linkMultiple',
          'tooltip' => true,
          'entity' => 'PortalRole'
        ],
        'exportDisabled' => [
          'type' => 'bool',
          'default' => false,
          'tooltip' => true
        ],
        'emailNotificationsDelay' => [
          'type' => 'int',
          'min' => 0,
          'max' => 18000,
          'tooltip' => true
        ],
        'assignmentEmailNotifications' => [
          'type' => 'bool',
          'default' => false
        ],
        'assignmentEmailNotificationsEntityList' => [
          'type' => 'multiEnum',
          'translation' => 'Global.scopeNamesPlural',
          'view' => 'views/settings/fields/assignment-email-notifications-entity-list'
        ],
        'assignmentNotificationsEntityList' => [
          'type' => 'multiEnum',
          'translation' => 'Global.scopeNamesPlural',
          'view' => 'views/settings/fields/assignment-notifications-entity-list'
        ],
        'postEmailNotifications' => [
          'type' => 'bool',
          'default' => false
        ],
        'updateEmailNotifications' => [
          'type' => 'bool',
          'default' => false
        ],
        'mentionEmailNotifications' => [
          'type' => 'bool',
          'default' => false
        ],
        'streamEmailNotifications' => [
          'type' => 'bool',
          'default' => false
        ],
        'portalStreamEmailNotifications' => [
          'type' => 'bool',
          'default' => true
        ],
        'streamEmailNotificationsEntityList' => [
          'type' => 'multiEnum',
          'translation' => 'Global.scopeNamesPlural',
          'view' => 'views/settings/fields/stream-email-notifications-entity-list',
          'tooltip' => true
        ],
        'streamEmailNotificationsTypeList' => [
          'type' => 'multiEnum',
          'options' => [
            0 => 'Post',
            1 => 'Status',
            2 => 'EmailReceived'
          ]
        ],
        'streamEmailWithContentEntityTypeList' => [
          'type' => 'multiEnum',
          'view' => 'views/settings/fields/stream-email-with-content-entity-type-list'
        ],
        'newNotificationCountInTitle' => [
          'type' => 'bool'
        ],
        'b2cMode' => [
          'type' => 'bool',
          'default' => false,
          'tooltip' => true
        ],
        'avatarsDisabled' => [
          'type' => 'bool',
          'default' => false
        ],
        'followCreatedEntities' => [
          'type' => 'bool',
          'default' => false,
          'tooltip' => true
        ],
        'adminPanelIframeUrl' => [
          'type' => 'varchar'
        ],
        'displayListViewRecordCount' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'userThemesDisabled' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'theme' => [
          'type' => 'enum',
          'view' => 'views/settings/fields/theme',
          'translation' => 'Global.themes'
        ],
        'themeParams' => [
          'type' => 'jsonObject'
        ],
        'attachmentUploadMaxSize' => [
          'type' => 'float',
          'min' => 0
        ],
        'attachmentUploadChunkSize' => [
          'type' => 'float',
          'min' => 0
        ],
        'emailMessageMaxSize' => [
          'type' => 'float',
          'min' => 0,
          'tooltip' => true
        ],
        'inboundEmailMaxPortionSize' => [
          'type' => 'int',
          'min' => 1,
          'max' => 500
        ],
        'personalEmailMaxPortionSize' => [
          'type' => 'int',
          'min' => 1,
          'max' => 500
        ],
        'maxEmailAccountCount' => [
          'type' => 'int'
        ],
        'massEmailMaxPerHourCount' => [
          'type' => 'int',
          'min' => 1,
          'required' => true
        ],
        'massEmailMaxPerBatchCount' => [
          'type' => 'int',
          'min' => 1
        ],
        'massEmailVerp' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'emailScheduledBatchCount' => [
          'type' => 'int',
          'min' => 1,
          'required' => true
        ],
        'authTokenLifetime' => [
          'type' => 'float',
          'min' => 0,
          'default' => 0,
          'tooltip' => true
        ],
        'authTokenMaxIdleTime' => [
          'type' => 'float',
          'min' => 0,
          'default' => 0,
          'tooltip' => true
        ],
        'authTokenPreventConcurrent' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'dashboardLayout' => [
          'type' => 'jsonArray',
          'view' => 'views/settings/fields/dashboard-layout'
        ],
        'dashletsOptions' => [
          'type' => 'jsonObject',
          'disabled' => true
        ],
        'siteUrl' => [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'applicationName' => [
          'type' => 'varchar'
        ],
        'readableDateFormatDisabled' => [
          'type' => 'bool'
        ],
        'addressFormat' => [
          'type' => 'enumInt',
          'options' => [
            0 => 1,
            1 => 2,
            2 => 3,
            3 => 4
          ]
        ],
        'addressPreview' => [
          'type' => 'address',
          'notStorable' => true,
          'readOnly' => true,
          'view' => 'views/settings/fields/address-preview'
        ],
        'personNameFormat' => [
          'type' => 'enum',
          'options' => [
            0 => 'firstLast',
            1 => 'lastFirst',
            2 => 'firstMiddleLast',
            3 => 'lastFirstMiddle'
          ]
        ],
        'currencyFormat' => [
          'type' => 'enumInt',
          'options' => [
            0 => 1,
            1 => 2,
            2 => 3
          ]
        ],
        'currencyDecimalPlaces' => [
          'type' => 'int',
          'tooltip' => true,
          'min' => 0,
          'max' => 20,
          'global' => true
        ],
        'notificationSoundsDisabled' => [
          'type' => 'bool'
        ],
        'calendarEntityList' => [
          'type' => 'multiEnum',
          'view' => 'views/settings/fields/calendar-entity-list',
          'tooltip' => true
        ],
        'activitiesEntityList' => [
          'type' => 'multiEnum',
          'view' => 'views/settings/fields/activities-entity-list',
          'tooltip' => true
        ],
        'historyEntityList' => [
          'type' => 'multiEnum',
          'view' => 'views/settings/fields/history-entity-list',
          'tooltip' => true
        ],
        'busyRangesEntityList' => [
          'type' => 'multiEnum',
          'tooltip' => true,
          'view' => 'views/settings/fields/busy-ranges-entity-list'
        ],
        'googleMapsApiKey' => [
          'type' => 'varchar'
        ],
        'massEmailDisableMandatoryOptOutLink' => [
          'type' => 'bool'
        ],
        'massEmailOpenTracking' => [
          'type' => 'bool'
        ],
        'aclAllowDeleteCreated' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'lastViewedCount' => [
          'type' => 'int',
          'min' => 1,
          'max' => 200,
          'default' => 20,
          'required' => true
        ],
        'adminNotifications' => [
          'type' => 'bool'
        ],
        'adminNotificationsNewVersion' => [
          'type' => 'bool'
        ],
        'adminNotificationsNewExtensionVersion' => [
          'type' => 'bool'
        ],
        'textFilterUseContainsForVarchar' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'phoneNumberNumericSearch' => [
          'type' => 'bool'
        ],
        'phoneNumberInternational' => [
          'type' => 'bool'
        ],
        'phoneNumberExtensions' => [
          'type' => 'bool'
        ],
        'phoneNumberPreferredCountryList' => [
          'type' => 'multiEnum',
          'view' => 'views/settings/fields/phone-number-preferred-country-list'
        ],
        'scopeColorsDisabled' => [
          'type' => 'bool'
        ],
        'tabColorsDisabled' => [
          'type' => 'bool'
        ],
        'tabIconsDisabled' => [
          'type' => 'bool'
        ],
        'emailAddressIsOptedOutByDefault' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'outboundEmailBccAddress' => [
          'type' => 'varchar',
          'view' => 'views/fields/email-address'
        ],
        'cleanupDeletedRecords' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'addressCityList' => [
          'type' => 'multiEnum',
          'tooltip' => true
        ],
        'addressStateList' => [
          'type' => 'multiEnum',
          'tooltip' => true
        ],
        'jobRunInParallel' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'jobMaxPortion' => [
          'type' => 'int',
          'tooltip' => true
        ],
        'jobPoolConcurrencyNumber' => [
          'type' => 'int',
          'tooltip' => true,
          'min' => 1
        ],
        'jobForceUtc' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'daemonInterval' => [
          'type' => 'int',
          'tooltip' => true
        ],
        'daemonMaxProcessNumber' => [
          'type' => 'int',
          'tooltip' => true,
          'min' => 1
        ],
        'daemonProcessTimeout' => [
          'type' => 'int',
          'tooltip' => true
        ],
        'cronDisabled' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'maintenanceMode' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'useWebSocket' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'awsS3Storage' => [
          'type' => 'jsonObject'
        ],
        'outboundSmsFromNumber' => [
          'type' => 'varchar'
        ],
        'smsProvider' => [
          'type' => 'enum',
          'view' => 'views/settings/fields/sms-provider'
        ],
        'workingTimeCalendar' => [
          'type' => 'link',
          'tooltip' => true,
          'entity' => 'WorkingTimeCalendar'
        ],
        'oidcClientId' => [
          'type' => 'varchar'
        ],
        'oidcClientSecret' => [
          'type' => 'password'
        ],
        'oidcAuthorizationEndpoint' => [
          'type' => 'url',
          'strip' => false
        ],
        'oidcTokenEndpoint' => [
          'type' => 'url',
          'strip' => false
        ],
        'oidcJwksEndpoint' => [
          'type' => 'url',
          'strip' => false
        ],
        'oidcJwtSignatureAlgorithmList' => [
          'type' => 'multiEnum',
          'options' => [
            0 => 'RS256',
            1 => 'RS384',
            2 => 'RS512',
            3 => 'HS256',
            4 => 'HS384',
            5 => 'HS512'
          ]
        ],
        'oidcScopes' => [
          'type' => 'multiEnum',
          'allowCustomOptions' => true,
          'options' => [
            0 => 'profile',
            1 => 'email',
            2 => 'phone',
            3 => 'address'
          ]
        ],
        'oidcGroupClaim' => [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'oidcCreateUser' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'oidcUsernameClaim' => [
          'type' => 'varchar',
          'options' => [
            0 => 'sub',
            1 => 'preferred_username',
            2 => 'email'
          ],
          'tooltip' => true
        ],
        'oidcTeams' => [
          'type' => 'linkMultiple',
          'entity' => 'Team',
          'additionalAttributeList' => [
            0 => 'columns'
          ],
          'view' => 'views/settings/fields/oidc-teams',
          'tooltip' => true
        ],
        'oidcSync' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'oidcSyncTeams' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'oidcFallback' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'oidcAllowRegularUserFallback' => [
          'type' => 'bool'
        ],
        'oidcAllowAdminUser' => [
          'type' => 'bool'
        ],
        'oidcLogoutUrl' => [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'oidcAuthorizationPrompt' => [
          'type' => 'enum',
          'options' => [
            0 => 'none',
            1 => 'consent',
            2 => 'login',
            3 => 'select_account'
          ]
        ],
        'pdfEngine' => [
          'type' => 'enum',
          'view' => 'views/settings/fields/pdf-engine'
        ],
        'quickSearchFullTextAppendWildcard' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'authIpAddressCheck' => [
          'type' => 'bool'
        ],
        'authIpAddressWhitelist' => [
          'type' => 'array',
          'allowCustomOptions' => true,
          'noEmptyString' => true,
          'validatorClassNameList' => [
            0 => 'Espo\\Classes\\FieldValidators\\Settings\\AuthIpAddressWhitelist\\Valid'
          ],
          'tooltip' => true
        ],
        'authIpAddressCheckExcludedUsers' => [
          'type' => 'linkMultiple',
          'entity' => 'User',
          'tooltip' => true
        ],
        'availableReactions' => [
          'type' => 'array',
          'maxCount' => 9,
          'view' => 'views/settings/fields/available-reactions',
          'validatorClassNameList' => [
            0 => 'Espo\\Classes\\FieldValidators\\Settings\\AvailableReactions\\Valid'
          ]
        ],
        'defaultPriceBook' => [
          'type' => 'link',
          'entity' => 'PriceBook'
        ],
        'priceBooksEnabled' => [
          'type' => 'bool'
        ],
        'inventoryTransactionsEnabled' => [
          'type' => 'bool'
        ],
        'deliveryOrdersEnabled' => [
          'type' => 'bool'
        ],
        'receiptOrdersEnabled' => [
          'type' => 'bool'
        ],
        'warehousesEnabled' => [
          'type' => 'bool'
        ],
        'salesForbidOrderUnlock' => [
          'type' => 'bool',
          'tooltip' => true
        ],
        'eInvoiceFormat' => [
          'type' => 'enum',
          'view' => 'sales:views/settings/fields/e-invoice-format',
          'translation' => 'Invoice.options.eInvoiceFormats'
        ],
        'sellerCompanyName' => [
          'type' => 'varchar',
          'maxLength' => 150
        ],
        'sellerElectronicAddressScheme' => [
          'type' => 'enum',
          'maxLength' => 4,
          'view' => 'sales:views/fields/electronic-address-scheme',
          'validatorClassNameList' => [
            0 => 'Espo\\Modules\\Sales\\FieldValidators\\Account\\ElectronicAddressScheme\\Valid'
          ]
        ],
        'sellerElectronicAddressIdentifier' => [
          'type' => 'varchar',
          'maxLength' => 255
        ],
        'sellerTaxRegistrationScheme' => [
          'type' => 'enum',
          'maxLength' => 4,
          'view' => 'sales:views/fields/electronic-address-scheme',
          'validatorClassNameList' => [
            0 => 'Espo\\Modules\\Sales\\FieldValidators\\Account\\ElectronicAddressScheme\\Valid'
          ]
        ],
        'sellerTaxRegistrationIdentifier' => [
          'type' => 'varchar',
          'maxLength' => 255
        ],
        'sellerVatNumber' => [
          'type' => 'varchar',
          'maxLength' => 100
        ],
        'sellerAddress' => [
          'type' => 'address'
        ],
        'sellerContactName' => [
          'type' => 'varchar',
          'maxLength' => 150
        ],
        'sellerContactEmailAddress' => [
          'type' => 'varchar',
          'maxLength' => 255,
          'view' => 'views/fields/email-address'
        ],
        'sellerContactPhoneNumber' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'pattern' => '$phoneNumberLoose'
        ],
        'reCaptchaSiteKey' => [
          'global' => true,
          'type' => 'varchar'
        ],
        'reCaptchaSecretKey' => [
          'global' => true,
          'type' => 'varchar'
        ],
        'addressPreviewStreet' => [
          'notStorable' => true,
          'readOnly' => true,
          'type' => 'text',
          'maxLength' => 255,
          'dbType' => 'varchar'
        ],
        'addressPreviewCity' => [
          'notStorable' => true,
          'readOnly' => true,
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'views/fields/address-city',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'pattern' => '$noBadCharacters'
        ],
        'addressPreviewState' => [
          'notStorable' => true,
          'readOnly' => true,
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'views/fields/address-state',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'pattern' => '$noBadCharacters'
        ],
        'addressPreviewCountry' => [
          'notStorable' => true,
          'readOnly' => true,
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'views/fields/address-country',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'pattern' => '$noBadCharacters'
        ],
        'addressPreviewPostalCode' => [
          'notStorable' => true,
          'readOnly' => true,
          'type' => 'varchar',
          'maxLength' => 40,
          'pattern' => '$noBadCharacters'
        ],
        'addressPreviewMap' => [
          'notStorable' => true,
          'readOnly' => true,
          'type' => 'map',
          'orderDisabled' => true,
          'layoutListDisabled' => true,
          'provider' => 'Google',
          'height' => 300,
          'exportDisabled' => true,
          'importDisabled' => true
        ],
        'sellerAddressStreet' => [
          'type' => 'text',
          'maxLength' => 255,
          'dbType' => 'varchar'
        ],
        'sellerAddressCity' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'views/fields/address-city',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'pattern' => '$noBadCharacters'
        ],
        'sellerAddressState' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'views/fields/address-state',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'pattern' => '$noBadCharacters'
        ],
        'sellerAddressCountry' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'views/fields/address-country',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'pattern' => '$noBadCharacters'
        ],
        'sellerAddressPostalCode' => [
          'type' => 'varchar',
          'maxLength' => 40,
          'pattern' => '$noBadCharacters'
        ],
        'sellerAddressMap' => [
          'type' => 'map',
          'notStorable' => true,
          'orderDisabled' => true,
          'readOnly' => true,
          'layoutListDisabled' => true,
          'provider' => 'Google',
          'height' => 300,
          'exportDisabled' => true,
          'importDisabled' => true
        ]
      ]
    ],
    'Sms' => [
      'fields' => [
        'from' => [
          'type' => 'varchar',
          'notStorable' => true,
          'required' => true,
          'textFilterDisabled' => true
        ],
        'fromName' => [
          'type' => 'varchar'
        ],
        'to' => [
          'type' => 'varchar',
          'notStorable' => true,
          'required' => true,
          'textFilterDisabled' => true
        ],
        'fromPhoneNumber' => [
          'type' => 'link',
          'textFilterDisabled' => true
        ],
        'toPhoneNumbers' => [
          'type' => 'linkMultiple'
        ],
        'body' => [
          'type' => 'text'
        ],
        'status' => [
          'type' => 'enum',
          'options' => [
            0 => 'Draft',
            1 => 'Sending',
            2 => 'Sent',
            3 => 'Archived',
            4 => 'Failed'
          ],
          'default' => 'Archived',
          'clientReadOnly' => true,
          'style' => [
            'Draft' => 'warning',
            'Failed' => 'danger',
            'Sending' => 'warning'
          ]
        ],
        'parent' => [
          'type' => 'linkParent'
        ],
        'dateSent' => [
          'type' => 'datetime'
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user'
        ],
        'modifiedBy' => [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user'
        ],
        'replied' => [
          'type' => 'link',
          'noJoin' => true,
          'readOnly' => true,
          'view' => 'views/email/fields/replied'
        ],
        'replies' => [
          'type' => 'linkMultiple',
          'readOnly' => true,
          'orderBy' => 'dateSent',
          'view' => 'views/email/fields/replies'
        ],
        'teams' => [
          'type' => 'linkMultiple',
          'view' => 'views/fields/teams'
        ]
      ],
      'links' => [
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'teams' => [
          'type' => 'hasMany',
          'entity' => 'Team',
          'relationName' => 'entityTeam'
        ],
        'parent' => [
          'type' => 'belongsToParent',
          'entityList' => [
            0 => 'Account',
            1 => 'Contact',
            2 => 'Lead',
            3 => 'Opportunity'
          ],
          'foreign' => 'emails'
        ],
        'replied' => [
          'type' => 'belongsTo',
          'entity' => 'Sms',
          'foreign' => 'replies',
          'foreignName' => 'id'
        ],
        'replies' => [
          'type' => 'hasMany',
          'entity' => 'Sms',
          'foreign' => 'replied'
        ],
        'fromPhoneNumber' => [
          'type' => 'belongsTo',
          'entity' => 'PhoneNumber'
        ],
        'toPhoneNumbers' => [
          'type' => 'hasMany',
          'entity' => 'PhoneNumber',
          'relationName' => 'smsPhoneNumber',
          'conditions' => [
            'addressType' => 'to'
          ],
          'additionalColumns' => [
            'addressType' => [
              'type' => 'varchar',
              'len' => '4'
            ]
          ]
        ]
      ],
      'collection' => [
        'orderBy' => 'dateSent',
        'order' => 'desc',
        'textFilterFields' => [
          0 => 'name',
          1 => 'body'
        ],
        'sortBy' => 'dateSent',
        'asc' => false
      ],
      'indexes' => [
        'dateSent' => [
          'columns' => [
            0 => 'dateSent',
            1 => 'deleted'
          ]
        ],
        'dateSentStatus' => [
          'columns' => [
            0 => 'dateSent',
            1 => 'status',
            2 => 'deleted'
          ]
        ]
      ]
    ],
    'StarSubscription' => [
      'fields' => [
        'id' => [
          'type' => 'id',
          'dbType' => 'bigint',
          'autoincrement' => true
        ],
        'entity' => [
          'type' => 'linkParent'
        ],
        'user' => [
          'type' => 'link'
        ],
        'createdAt' => [
          'type' => 'datetime'
        ]
      ],
      'indexes' => [
        'userEntity' => [
          'unique' => true,
          'columns' => [
            0 => 'userId',
            1 => 'entityId',
            2 => 'entityType'
          ]
        ],
        'userEntityType' => [
          'columns' => [
            0 => 'userId',
            1 => 'entityType'
          ]
        ]
      ]
    ],
    'StreamSubscription' => [
      'fields' => [
        'id' => [
          'type' => 'id',
          'dbType' => 'bigint',
          'autoincrement' => true
        ],
        'entity' => [
          'type' => 'linkParent'
        ],
        'user' => [
          'type' => 'link'
        ]
      ],
      'indexes' => [
        'userEntity' => [
          'columns' => [
            0 => 'userId',
            1 => 'entityId',
            2 => 'entityType'
          ]
        ]
      ]
    ],
    'SystemData' => [
      'fields' => [
        'id' => [
          'type' => 'id',
          'dbType' => 'string',
          'maxLength' => 1
        ],
        'lastPasswordRecoveryDate' => [
          'type' => 'datetime'
        ]
      ]
    ],
    'Team' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'pattern' => '$noBadCharacters',
          'audited' => true
        ],
        'roles' => [
          'type' => 'linkMultiple',
          'tooltip' => true,
          'audited' => true
        ],
        'positionList' => [
          'type' => 'array',
          'displayAsList' => true,
          'tooltip' => true,
          'audited' => true
        ],
        'userRole' => [
          'type' => 'varchar',
          'notStorable' => true,
          'utility' => true
        ],
        'layoutSet' => [
          'type' => 'link',
          'tooltip' => true,
          'audited' => true
        ],
        'workingTimeCalendar' => [
          'type' => 'link',
          'tooltip' => true,
          'audited' => true
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ]
      ],
      'links' => [
        'users' => [
          'type' => 'hasMany',
          'entity' => 'User',
          'foreign' => 'teams',
          'columnAttributeMap' => [
            'role' => 'userRole'
          ],
          'audited' => false
        ],
        'roles' => [
          'type' => 'hasMany',
          'entity' => 'Role',
          'foreign' => 'teams'
        ],
        'notes' => [
          'type' => 'hasMany',
          'entity' => 'Note',
          'foreign' => 'teams'
        ],
        'inboundEmails' => [
          'type' => 'hasMany',
          'entity' => 'InboundEmail',
          'foreign' => 'teams'
        ],
        'layoutSet' => [
          'type' => 'belongsTo',
          'entity' => 'LayoutSet',
          'foreign' => 'teams'
        ],
        'workingTimeCalendar' => [
          'type' => 'belongsTo',
          'entity' => 'WorkingTimeCalendar',
          'foreign' => 'teams'
        ],
        'groupEmailFolders' => [
          'type' => 'hasMany',
          'entity' => 'GroupEmailFolder',
          'foreign' => 'teams'
        ],
        'manualWorkflows' => [
          'type' => 'hasMany',
          'entity' => 'Workflow',
          'foreign' => 'manualTeams'
        ]
      ],
      'collection' => [
        'orderBy' => 'name',
        'order' => 'asc',
        'sortBy' => 'name',
        'asc' => true
      ]
    ],
    'Template' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'required' => true,
          'pattern' => '$noBadCharacters'
        ],
        'body' => [
          'type' => 'wysiwyg',
          'view' => 'views/template/fields/body'
        ],
        'header' => [
          'type' => 'wysiwyg',
          'view' => 'views/template/fields/body'
        ],
        'footer' => [
          'type' => 'wysiwyg',
          'view' => 'views/template/fields/body',
          'tooltip' => true
        ],
        'entityType' => [
          'type' => 'enum',
          'required' => true,
          'translation' => 'Global.scopeNames',
          'view' => 'views/template/fields/entity-type'
        ],
        'leftMargin' => [
          'type' => 'float',
          'default' => 10
        ],
        'rightMargin' => [
          'type' => 'float',
          'default' => 10
        ],
        'topMargin' => [
          'type' => 'float',
          'default' => 10
        ],
        'bottomMargin' => [
          'type' => 'float',
          'default' => 20
        ],
        'printFooter' => [
          'type' => 'bool',
          'inlineEditDisabled' => true
        ],
        'printHeader' => [
          'type' => 'bool',
          'inlineEditDisabled' => true
        ],
        'footerPosition' => [
          'type' => 'float',
          'default' => 10,
          'min' => NULL,
          'max' => NULL
        ],
        'headerPosition' => [
          'type' => 'float',
          'default' => 0
        ],
        'style' => [
          'type' => 'text',
          'view' => 'views/template/fields/style'
        ],
        'teams' => [
          'type' => 'linkMultiple'
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => [
          'type' => 'link',
          'readOnly' => true
        ],
        'variables' => [
          'type' => 'base',
          'notStorable' => true,
          'tooltip' => true
        ],
        'pageOrientation' => [
          'type' => 'enum',
          'options' => [
            0 => 'Portrait',
            1 => 'Landscape'
          ],
          'default' => 'Portrait',
          'style' => [
            'Portrait' => NULL,
            'Landscape' => NULL
          ]
        ],
        'pageFormat' => [
          'type' => 'enum',
          'options' => [
            0 => 'A3',
            1 => 'A4',
            2 => 'A5',
            3 => 'A6',
            4 => 'A7',
            5 => 'Custom'
          ],
          'default' => 'A4',
          'style' => [
            'A3' => NULL,
            'A4' => NULL,
            'A5' => NULL,
            'A6' => NULL,
            'A7' => NULL,
            'Custom' => NULL
          ]
        ],
        'pageWidth' => [
          'type' => 'float',
          'min' => 1,
          'default' => NULL,
          'max' => NULL
        ],
        'pageHeight' => [
          'type' => 'float',
          'min' => 1,
          'default' => NULL,
          'max' => NULL
        ],
        'fontFace' => [
          'type' => 'enum',
          'view' => 'views/template/fields/font-face'
        ],
        'title' => [
          'type' => 'varchar'
        ]
      ],
      'links' => [
        'teams' => [
          'type' => 'hasMany',
          'entity' => 'Team',
          'relationName' => 'entityTeam'
        ],
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ],
      'collection' => [
        'orderBy' => 'name',
        'order' => 'asc',
        'sortBy' => 'name',
        'asc' => true
      ],
      'optimisticConcurrencyControl' => true,
      'defaultTemplates' => [
        'Report' => [
          'body' => '<h1>{{name}}</h1><br>{{reportTable border=1 borderColor="#333" cellpadding=2}}',
          'footer' => '<div style="text-align: center;"><span style="font-size: 10px;">{pageNumber}</span></div>'
        ],
        'Quote' => [
          'body' => '<table style="line-height: 1.36; width: 100%;">
  <tbody>
     <tr>
       <td style="width: 50%; vertical-align: top;">
         <p><span style="font-size: 1.4em;">Company Name</span></p>
         <p><br></p>
         <p>
           {{accountName}}
         </p>
         <p>
           {{{billingAddressStreet}}}
           <br>
           {{billingAddressCity}}{{#if billingAddressState}},{{/if}} {{billingAddressState}} {{billingAddressPostalCode}}<br>{{billingAddressCountry}}
         </p>
      </td>
      <td style="width: 50%; vertical-align: top; text-align: right;">
        <p><span style="font-size: 1.2em;">Quote</span></p>
        <p>Date: {{dateQuoted}}</p>
      </td>
    </tr>
  </tbody>
</table>
<p><span style="font-size: 1.2em;">{{name}}</span></p>
<p>Currency: {{amountCurrency}}</p>

<table style="border: 0.5pt; border-spacing: 0; border-collapse: collapse; width: 100%;" cellpadding="2" border="0.5pt">
<tbody>
 <tr>
  <th width="5%" align="left">#</th>
  <th width="37%" align="left">Name</th>
  <th width="8%" align="left">Qty</th>
  <th width="16%" align="left">List Price</th>
  <th width="16%" align="left">Unit Price</th>
  <th width="16%" align="left">Amount</th>
 </tr>
 <!-- {{#each itemList}} --> <tr>
  <td>{{order}}</td>
  <td>{{name}}</td>
  <td>{{quantity}}</td>
  <td align="right">{{listPrice}}</td>
  <td align="right">{{unitPrice}}</td>
  <td align="right">{{amount}}</td>
 </tr>
<!-- {{#if description}} -->
<tr><td colspan="6">{{{description}}}</td></tr>
<!-- {{/if}} -->
<!-- {{/each}} --> <tr>
   <td colspan="6">&nbsp;</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Pre-Discounted Amount</td>
   <td align="right">{{preDiscountedAmount}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Discount Amount</td>
   <td align="right">{{discountAmount}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Amount</td>
   <td align="right">{{amount}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Tax Amount</td>
   <td align="right">{{taxAmount}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Shipping Cost</td>
   <td align="right">{{shippingCost}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Grand Total Amount</td>
   <td align="right"><b>{{grandTotalAmount}}</b></td>
 </tr>
</tbody>
</table>
<p><br></p>
<p align="center">Thank you for your business.</p>',
          'footer' => '<div style="width: 100%; text-align: center;"><span style="font-size: 0.8em">{pageNumber}</span></div>'
        ],
        'SalesOrder' => [
          'body' => '<table style="line-height: 1.36; width: 100%;">
  <tbody>
     <tr>
       <td style="width: 50%; vertical-align: top;">
         <p><span style="font-size: 1.4em;">Company Name</span></p>
         <p><br></p>
         <p>
           {{accountName}}
         </p>
         <p>
           {{{billingAddressStreet}}}
           <br>
           {{billingAddressCity}}{{#if billingAddressState}},{{/if}} {{billingAddressState}} {{billingAddressPostalCode}}<br>{{billingAddressCountry}}
         </p>
      </td>
      <td style="width: 50%; vertical-align: top; text-align: right;">
        <p><span style="font-size: 1.2em;">Sales Order</span></p>
        <p>Date: {{dateOrdered}}</p>
      </td>
    </tr>
  </tbody>
</table>
<p><span style="font-size: 1.2em;">{{name}}</span></p>
<p>Currency: {{amountCurrency}}</p>

<table style="border: 0.5pt; border-spacing: 0; border-collapse: collapse; width: 100%;" cellpadding="2" border="0.5pt">
<tbody>
 <tr>
  <th width="5%" align="left">#</th>
  <th width="37%" align="left">Name</th>
  <th width="8%" align="left">Qty</th>
  <th width="16%" align="left">List Price</th>
  <th width="16%" align="left">Unit Price</th>
  <th width="16%" align="left">Amount</th>
 </tr>
 <!-- {{#each itemList}} --> <tr>
  <td>{{order}}</td>
  <td>{{name}}</td>
  <td>{{quantity}}</td>
  <td align="right">{{listPrice}}</td>
  <td align="right">{{unitPrice}}</td>
  <td align="right">{{amount}}</td>
 </tr>
<!-- {{#if description}} -->
<tr><td colspan="6">{{{description}}}</td></tr>
<!-- {{/if}} -->
<!-- {{/each}} --> <tr>
   <td colspan="6">&nbsp;</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Pre-Discounted Amount</td>
   <td align="right">{{preDiscountedAmount}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Discount Amount</td>
   <td align="right">{{discountAmount}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Amount</td>
   <td align="right">{{amount}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Tax Amount</td>
   <td align="right">{{taxAmount}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Shipping Cost</td>
   <td align="right">{{shippingCost}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Grand Total Amount</td>
   <td align="right"><b>{{grandTotalAmount}}</b></td>
 </tr>
</tbody>
</table>
<p><br></p>
<p align="center">Thank you for your business.</p>',
          'footer' => '<div style="width: 100%; text-align: center;"><span style="font-size: 0.8em">{pageNumber}</span></div>'
        ],
        'Invoice' => [
          'body' => '<table style="line-height: 1.36; width: 100%;">
  <tbody>
     <tr>
       <td style="width: 50%; vertical-align: top;">
         <p><span style="font-size: 1.4em;">Company Name</span></p>
         <p><br></p>
         <p>
           {{accountName}}
         </p>
         <p>
           {{{billingAddressStreet}}}
           <br>
           {{billingAddressCity}}{{#if billingAddressState}},{{/if}} {{billingAddressState}} {{billingAddressPostalCode}}<br>{{billingAddressCountry}}
         </p>
      </td>
      <td style="width: 50%; vertical-align: top; text-align: right;">
        <p><span style="font-size: 1.2em;">Invoice</span></p>
        <p>Date: {{dateInvoiced}}</p>
      </td>
    </tr>
  </tbody>
</table>
<p><span style="font-size: 1.2em;">{{name}}</span></p>
<p>Currency: {{amountCurrency}}</p>

<table style="border: 0.5pt; border-spacing: 0; border-collapse: collapse; width: 100%;" cellpadding="2" border="0.5pt">
<tbody>
 <tr>
  <th width="5%" align="left">#</th>
  <th width="37%" align="left">Name</th>
  <th width="8%" align="left">Qty</th>
  <th width="16%" align="left">List Price</th>
  <th width="16%" align="left">Unit Price</th>
  <th width="16%" align="left">Amount</th>
 </tr>
 <!-- {{#each itemList}} --> <tr>
  <td>{{order}}</td>
  <td>{{name}}</td>
  <td>{{quantity}}</td>
  <td align="right">{{listPrice}}</td>
  <td align="right">{{unitPrice}}</td>
  <td align="right">{{amount}}</td>
 </tr>
<!-- {{#if description}} -->
<tr><td colspan="6">{{{description}}}</td></tr>
<!-- {{/if}} -->
<!-- {{/each}} --> <tr>
   <td colspan="6">&nbsp;</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Pre-Discounted Amount</td>
   <td align="right">{{preDiscountedAmount}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Discount Amount</td>
   <td align="right">{{discountAmount}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Amount</td>
   <td align="right">{{amount}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Tax Amount</td>
   <td align="right">{{taxAmount}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Shipping Cost</td>
   <td align="right">{{shippingCost}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Grand Total Amount</td>
   <td align="right"><b>{{grandTotalAmount}}</b></td>
 </tr>
</tbody>
</table>
<p>{{#if dateDue}}Due date: {{dateDue}}{{else}}<br>{{/if}}</p>
<p align="center">Thank you for your business.</p>',
          'footer' => '<div style="width: 100%; text-align: center;"><span style="font-size: 0.8em">{pageNumber}</span></div>'
        ],
        'PurchaseOrder' => [
          'body' => '<table style="line-height: 1.36; width: 100%;">
  <tbody>
     <tr>
       <td style="width: 50%; vertical-align: top;">
         <p><span style="font-size: 1.4em;">Company Name</span></p>
         <p><br></p>
         <p>
           {{supplierName}}
         </p>
         <p>
           {{{supplierAddressStreet}}}
           <br>
           {{supplierAddressCity}}{{#if supplierAddressState}},{{/if}} {{supplierAddressState}} {{supplierAddressPostalCode}}<br>{{supplierAddressCountry}}
         </p>
       </td>
       <td style="width: 50%; vertical-align: top; text-align: right;">
         <p><span style="font-size: 1.2em;">Purchase Order</span></p>
         <p>Date: {{dateOrdered}}</p>
         <p>
           Ship to
         </p>
         <p>
           {{{shippingAddressStreet}}}
           <br>
           {{shippingAddressCity}}{{#if shippingAddressState}},{{/if}} {{shippingAddressState}} {{shippingAddressPostalCode}}<br>{{shippingAddressCountry}}
         </p>
      </td>
    </tr>
  </tbody>
</table>
<p><span style="font-size: 1.2em;">{{name}}</span></p>
<p>Currency: {{amountCurrency}}</p>

<table style="border: 0.5pt; border-spacing: 0; border-collapse: collapse; width: 100%;" cellpadding="2" border="0.5pt">
<tbody>
 <tr>
  <th width="5%" align="left">#</th>
  <th width="37%" align="left">Name</th>
  <th width="8%" align="left">Qty</th>
   <th width="16%" align="left">Unit Price</th>
  <th width="16%" align="left">Amount</th>
 </tr>
 <!-- {{#each itemList}} --> <tr>
  <td>{{order}}</td>
  <td>{{name}}</td>
  <td>{{quantity}}</td>
   <td align="right">{{unitPrice}}</td>
  <td align="right">{{amount}}</td>
 </tr>
<!-- {{#if description}} -->
<tr><td colspan="4">{{{description}}}</td></tr>
<!-- {{/if}} -->
<!-- {{/each}} --> <tr>
   <td colspan="5">&nbsp;</td>
 </tr>
  <tr><td colspan="4" align="right">Amount</td>
   <td align="right">{{amount}}</td>
 </tr>
 <tr>
   <td colspan="4" align="right">Tax Amount</td>
   <td align="right">{{taxAmount}}</td>
 </tr>
 <tr>
   <td colspan="4" align="right">Shipping Cost</td>
   <td align="right">{{shippingCost}}</td>
 </tr>
 <tr>
   <td colspan="4" align="right">Grand Total Amount</td>
   <td align="right"><b>{{grandTotalAmount}}</b></td>
 </tr>
</tbody>
</table>
<p><br></p>
<p align="center">Thank you for your business.</p>',
          'footer' => '<div style="width: 100%; text-align: center;"><span style="font-size: 0.8em">{pageNumber}</span></div>'
        ],
        'DeliveryOrder' => [
          'body' => '<table style="line-height: 1.36; width: 100%;">
  <tbody>
     <tr>
       <td style="width: 50%; vertical-align: top;">
         <p><span style="font-size: 1.4em;">Company Name</span></p>
         <p><br></p>
         <p>
           {{accountName}}
         </p>
         <p>
           {{{shippingAddressStreet}}}
           <br>
           {{shippingAddressCity}}{{#if shippingAddressState}},{{/if}} {{shippingAddressState}} {{shippingAddressPostalCode}}<br>{{shippingAddressCountry}}
         </p>
      </td>
      <td style="width: 50%; vertical-align: top; text-align: right;">
        <p><span style="font-size: 1.2em;">Delivery Order</span></p>
        <p>Date: {{dateOrdered}}</p>
      </td>
    </tr>
  </tbody>
</table>
<p><span style="font-size: 1.2em;">{{name}}</span></p>

<table style="border: 0.5pt; border-spacing: 0; border-collapse: collapse; width: 100%;" cellpadding="2" border="0.5pt">
<tbody>
 <tr>
  <th width="5%" align="left">#</th>
  <th width="37%" align="left">Name</th>
  <th width="8%" align="left">Qty</th>
    </tr>
 <!-- {{#each itemList}} --> <tr>
  <td>{{order}}</td>
  <td>{{name}}</td>
  <td>{{quantity}}</td>
   </tr>
<!-- {{#if description}} -->
<tr><td colspan="2">{{{description}}}</td></tr>
<!-- {{/if}} -->
<!-- {{/each}} --> 
</tbody>
</table>
<p><br></p>
',
          'footer' => '<div style="width: 100%; text-align: center;"><span style="font-size: 0.8em">{pageNumber}</span></div>'
        ],
        'ReceiptOrder' => [
          'body' => '<table style="line-height: 1.36; width: 100%;">
  <tbody>
     <tr>
       <td style="width: 50%; vertical-align: top;">
         <p><span style="font-size: 1.4em;">Company Name</span></p>
         <p><br></p>
         <p>
           {{supplierName}}
         </p>
         <p>
          {{shippingProviderName}}
           </p>
      </td>
      <td style="width: 50%; vertical-align: top; text-align: right;">
        <p><span style="font-size: 1.2em;">Receipt Order</span></p>
        <p>Date: {{dateOrdered}}</p>
      </td>
    </tr>
  </tbody>
</table>
<p><span style="font-size: 1.2em;">{{name}}</span></p>

<table style="border: 0.5pt; border-spacing: 0; border-collapse: collapse; width: 100%;" cellpadding="2" border="0.5pt">
<tbody>
 <tr>
  <th width="5%" align="left">#</th>
  <th width="37%" align="left">Name</th>
  <th width="8%" align="left">Qty</th>
    </tr>
 <!-- {{#each itemList}} --> <tr>
  <td>{{order}}</td>
  <td>{{name}}</td>
  <td>{{quantity}}</td>
   </tr>
<!-- {{#if description}} -->
<tr><td colspan="2">{{{description}}}</td></tr>
<!-- {{/if}} -->
<!-- {{/each}} --> 
</tbody>
</table>
<p><br></p>
',
          'footer' => '<div style="width: 100%; text-align: center;"><span style="font-size: 0.8em">{pageNumber}</span></div>'
        ],
        'TransferOrder' => [
          'body' => '<table style="line-height: 1.36; width: 100%;">
  <tbody>
     <tr>
      <td style="width: 50%; vertical-align: top; text-align: right;">
        <p><span style="font-size: 1.2em;">Transfer Order</span></p>
        <p>Date: {{dateOrdered}}</p>
      </td>
    </tr>
  </tbody>
</table>

<table style="line-height: 1.36; width: 100%;">
  <tbody>
     <tr>
       <td style="width: 50%; vertical-align: top;">
         From
       </td>
       <td style="width: 50%; vertical-align: top;">
         To
       </td>
     </tr>
     <tr>
       <td style="vertical-align: top;">
         {{fromWarehouseName}}
       </td>
       <td style="width: 50%; vertical-align: top;">
         {{toWarehouseName}}
       </td>
     </tr>
     <tr>
       <td style="width: 50%; vertical-align: top;">
         <p>
           {{{fromAddressStreet}}}
           <br>
           {{fromAddressCity}}{{#if fromAddressState}},{{/if}} {{fromAddressState}} {{fromAddressPostalCode}}<br>{{fromAddressCountry}}
         </p>
       </td>
       <td style="width: 50%; vertical-align: top;">
         <p>
           {{{toAddressStreet}}}
           <br>
           {{toAddressCity}}{{#if toAddressState}},{{/if}} {{toAddressState}} {{toAddressPostalCode}}<br>{{toAddressCountry}}
         </p>
       </td>
     </tr>
  </tbody>
</table>

<p><span style="font-size: 1.2em;">{{name}}</span></p>

<table style="border: 0.5pt; border-spacing: 0; border-collapse: collapse; width: 100%;" cellpadding="2" border="0.5pt">
<tbody>
 <tr>
  <th width="5%" align="left">#</th>
  <th width="37%" align="left">Name</th>
  <th width="8%" align="left">Qty</th>
    </tr>
 <!-- {{#each itemList}} --> <tr>
  <td>{{order}}</td>
  <td>{{name}}</td>
  <td>{{quantity}}</td>
   </tr>
<!-- {{#if description}} -->
<tr><td colspan="2">{{{description}}}</td></tr>
<!-- {{/if}} -->
<!-- {{/each}} --> 
</tbody>
</table>
<p><br></p>
',
          'footer' => '<div style="width: 100%; text-align: center;"><span style="font-size: 0.8em">{pageNumber}</span></div>'
        ],
        'ReturnOrder' => [
          'body' => '<table style="line-height: 1.36; width: 100%;">
  <tbody>
     <tr>
       <td style="width: 50%; vertical-align: top;">
         <p><span style="font-size: 1.4em;">Company Name</span></p>
         <p><br></p>
         <p>
           {{accountName}}
         </p>
         <p>
          {{shippingProviderName}}
           </p>
      </td>
      <td style="width: 50%; vertical-align: top; text-align: right;">
        <p><span style="font-size: 1.2em;">Return Order</span></p>
        <p>Date: {{dateOrdered}}</p>
      </td>
    </tr>
  </tbody>
</table>
<p><span style="font-size: 1.2em;">{{name}}</span></p>

<table style="border: 0.5pt; border-spacing: 0; border-collapse: collapse; width: 100%;" cellpadding="2" border="0.5pt">
<tbody>
 <tr>
  <th width="5%" align="left">#</th>
  <th width="37%" align="left">Name</th>
  <th width="8%" align="left">Qty</th>
    </tr>
 <!-- {{#each itemList}} --> <tr>
  <td>{{order}}</td>
  <td>{{name}}</td>
  <td>{{quantity}}</td>
   </tr>
<!-- {{#if description}} -->
<tr><td colspan="2">{{{description}}}</td></tr>
<!-- {{/if}} -->
<!-- {{/each}} --> 
</tbody>
</table>
<p><br></p>
',
          'footer' => '<div style="width: 100%; text-align: center;"><span style="font-size: 0.8em">{pageNumber}</span></div>'
        ]
      ]
    ],
    'TwoFactorCode' => [
      'fields' => [
        'code' => [
          'type' => 'varchar',
          'maxLength' => 100
        ],
        'method' => [
          'type' => 'varchar',
          'maxLength' => 100
        ],
        'attemptsLeft' => [
          'type' => 'int'
        ],
        'isActive' => [
          'type' => 'bool',
          'default' => true
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ]
      ],
      'links' => [
        'user' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ],
      'indexes' => [
        'createdAt' => [
          'columns' => [
            0 => 'createdAt'
          ]
        ],
        'userIdMethod' => [
          'columns' => [
            0 => 'userId',
            1 => 'method'
          ]
        ],
        'userIdMethodIsActive' => [
          'columns' => [
            0 => 'userId',
            1 => 'method',
            2 => 'isActive'
          ]
        ],
        'userIdMethodCreatedAt' => [
          'columns' => [
            0 => 'userId',
            1 => 'method',
            2 => 'createdAt'
          ]
        ]
      ]
    ],
    'UniqueId' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'required' => true,
          'index' => true
        ],
        'data' => [
          'type' => 'jsonObject'
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true
        ],
        'terminateAt' => [
          'type' => 'datetime'
        ],
        'target' => [
          'type' => 'linkParent'
        ]
      ],
      'links' => [
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'target' => [
          'type' => 'belongsToParent'
        ]
      ],
      'collection' => [
        'orderBy' => 'createdAt',
        'order' => 'desc',
        'sortBy' => 'createdAt',
        'asc' => false
      ],
      'hooksDisabled' => true
    ],
    'User' => [
      'fields' => [
        'userName' => [
          'type' => 'varchar',
          'maxLength' => 50,
          'required' => true,
          'view' => 'views/user/fields/user-name',
          'tooltip' => true,
          'fieldManagerParamList' => [
            0 => 'maxLength',
            1 => 'tooltipText',
            2 => 'inlineEditDisabled'
          ],
          'index' => true,
          'validatorClassNameList' => [
            0 => 'Espo\\Classes\\FieldValidators\\User\\UserName\\Valid'
          ],
          'default' => NULL,
          'trim' => false,
          'options' => []
        ],
        'name' => [
          'type' => 'personName',
          'view' => 'views/user/fields/name',
          'dependeeAttributeList' => [
            0 => 'userName'
          ],
          'dynamicLogicVisibleDisabled' => true
        ],
        'type' => [
          'type' => 'enum',
          'options' => [
            0 => 'regular',
            1 => 'admin',
            2 => 'portal',
            3 => 'system',
            4 => 'super-admin',
            5 => 'api'
          ],
          'default' => 'regular',
          'maxLength' => 24,
          'index' => true,
          'inlineEditDisabled' => true,
          'layoutDetailDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'fieldManagerParamList' => [
            0 => 'tooltipText'
          ],
          'style' => [
            'regular' => NULL,
            'admin' => NULL,
            'portal' => NULL,
            'system' => NULL,
            'super-admin' => NULL,
            'api' => NULL
          ]
        ],
        'password' => [
          'type' => 'password',
          'maxLength' => 150,
          'internal' => true,
          'utility' => true,
          'directAccessDisabled' => true,
          'fieldManagerParamList' => [
            0 => 'tooltipText'
          ],
          'orderDisabled' => true
        ],
        'passwordConfirm' => [
          'type' => 'password',
          'maxLength' => 150,
          'internal' => true,
          'utility' => true,
          'notStorable' => true,
          'orderDisabled' => true,
          'directAccessDisabled' => true,
          'fieldManagerParamList' => []
        ],
        'authMethod' => [
          'type' => 'enum',
          'options' => [
            0 => '',
            1 => 'ApiKey',
            2 => 'Hmac'
          ],
          'maxLength' => 24,
          'layoutMassUpdateDisabled' => true,
          'layoutDetailDisabled' => true,
          'layoutFiltersDisabled' => true,
          'layoutListDisabled' => true,
          'fieldManagerParamList' => [
            0 => 'tooltipText'
          ],
          'style' => [
            'ApiKey' => NULL,
            'Hmac' => NULL
          ],
          'default' => 'ApiKey'
        ],
        'apiKey' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'readOnly' => true,
          'layoutMassUpdateDisabled' => true,
          'layoutDetailDisabled' => true,
          'layoutFiltersDisabled' => true,
          'layoutListDisabled' => true,
          'fieldManagerParamList' => [
            0 => 'tooltipText'
          ],
          'copyToClipboard' => true,
          'dynamicLogicVisibleDisabled' => true,
          'orderDisabled' => true
        ],
        'secretKey' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'readOnly' => true,
          'notStorable' => true,
          'orderDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'layoutDetailDisabled' => true,
          'layoutFiltersDisabled' => true,
          'layoutListDisabled' => true,
          'fieldManagerParamList' => [
            0 => 'tooltipText'
          ],
          'copyToClipboard' => true,
          'dynamicLogicVisibleDisabled' => true,
          'default' => NULL,
          'trim' => false,
          'options' => []
        ],
        'salutationName' => [
          'type' => 'enum',
          'customizationOptionsReferenceDisabled' => true,
          'options' => [
            0 => '',
            1 => 'Mr.',
            2 => 'Ms.',
            3 => 'Mrs.',
            4 => 'Dr.'
          ]
        ],
        'firstName' => [
          'type' => 'varchar',
          'pattern' => '$noBadCharacters',
          'maxLength' => 100,
          'suppressValidationList' => [
            0 => 'required'
          ]
        ],
        'lastName' => [
          'type' => 'varchar',
          'pattern' => '$noBadCharacters',
          'maxLength' => 100,
          'required' => false,
          'suppressValidationList' => [
            0 => 'required'
          ],
          'default' => NULL,
          'options' => []
        ],
        'isActive' => [
          'type' => 'bool',
          'layoutDetailDisabled' => true,
          'tooltip' => true,
          'default' => true,
          'customizationAuditedDisabled' => true,
          'audited' => true
        ],
        'title' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'pattern' => '$noBadCharacters',
          'customizationAuditedDisabled' => true,
          'dynamicLogicVisibleDisabled' => true,
          'default' => NULL,
          'options' => []
        ],
        'position' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'notStorable' => true,
          'orderDisabled' => true,
          'where' => [
            'LIKE' => [
              'whereClause' => [
                'id=s' => [
                  'from' => 'TeamUser',
                  'select' => [
                    0 => 'userId'
                  ],
                  'whereClause' => [
                    'deleted' => false,
                    'role*' => '{value}'
                  ]
                ]
              ]
            ],
            'NOT LIKE' => [
              'whereClause' => [
                'id!=s' => [
                  'from' => 'TeamUser',
                  'select' => [
                    0 => 'userId'
                  ],
                  'whereClause' => [
                    'deleted' => false,
                    'role*' => '{value}'
                  ]
                ]
              ]
            ],
            '=' => [
              'whereClause' => [
                'id=s' => [
                  'from' => 'TeamUser',
                  'select' => [
                    0 => 'userId'
                  ],
                  'whereClause' => [
                    'deleted' => false,
                    'role' => '{value}'
                  ]
                ]
              ]
            ],
            '<>' => [
              'whereClause' => [
                'id=!s' => [
                  'from' => 'TeamUser',
                  'select' => [
                    0 => 'userId'
                  ],
                  'whereClause' => [
                    'deleted' => false,
                    'role' => '{value}'
                  ]
                ]
              ]
            ],
            'IS NULL' => [
              'whereClause' => [
                'NOT' => [
                  'EXISTS' => [
                    'from' => 'User',
                    'fromAlias' => 'sq',
                    'select' => [
                      0 => 'id'
                    ],
                    'leftJoins' => [
                      0 => [
                        0 => 'teams',
                        1 => 'm',
                        2 => [],
                        3 => [
                          'onlyMiddle' => true
                        ]
                      ]
                    ],
                    'whereClause' => [
                      'm.role!=' => NULL,
                      'sq.id:' => 'user.id'
                    ]
                  ]
                ]
              ]
            ],
            'IS NOT NULL' => [
              'whereClause' => [
                'EXISTS' => [
                  'from' => 'User',
                  'fromAlias' => 'sq',
                  'select' => [
                    0 => 'id'
                  ],
                  'leftJoins' => [
                    0 => [
                      0 => 'teams',
                      1 => 'm',
                      2 => [],
                      3 => [
                        'onlyMiddle' => true
                      ]
                    ]
                  ],
                  'whereClause' => [
                    'm.role!=' => NULL,
                    'sq.id:' => 'user.id'
                  ]
                ]
              ]
            ]
          ],
          'directUpdateDisabled' => true,
          'readOnly' => true,
          'importDisabled' => true,
          'exportDisabled' => true,
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'textFilterDisabled' => true,
          'fieldManagerParamList' => [
            0 => 'tooltipText'
          ]
        ],
        'emailAddress' => [
          'type' => 'email',
          'required' => false,
          'layoutMassUpdateDisabled' => true,
          'dynamicLogicVisibleDisabled' => true
        ],
        'phoneNumber' => [
          'type' => 'phone',
          'typeList' => [
            0 => 'Mobile',
            1 => 'Office',
            2 => 'Home',
            3 => 'Fax',
            4 => 'Other'
          ],
          'defaultType' => 'Mobile',
          'dynamicLogicVisibleDisabled' => true
        ],
        'token' => [
          'type' => 'varchar',
          'notStorable' => true,
          'orderDisabled' => true,
          'utility' => true,
          'customizationDisabled' => true
        ],
        'authTokenId' => [
          'type' => 'varchar',
          'notStorable' => true,
          'orderDisabled' => true,
          'utility' => true,
          'customizationDisabled' => true,
          'default' => NULL,
          'maxLength' => NULL,
          'trim' => false,
          'options' => []
        ],
        'authLogRecordId' => [
          'type' => 'varchar',
          'notStorable' => true,
          'orderDisabled' => true,
          'utility' => true,
          'customizationDisabled' => true,
          'default' => NULL,
          'maxLength' => NULL,
          'trim' => false,
          'options' => []
        ],
        'ipAddress' => [
          'type' => 'varchar',
          'notStorable' => true,
          'orderDisabled' => true,
          'utility' => true,
          'customizationDisabled' => true
        ],
        'defaultTeam' => [
          'type' => 'link',
          'layoutDetailDisabled' => true,
          'tooltip' => true,
          'customizationAuditedDisabled' => true,
          'customizationAutocompleteOnEmptyDisabled' => true,
          'validatorClassNameList' => [
            0 => 'Espo\\Classes\\FieldValidators\\User\\DefaultTeam\\IsUserTeam'
          ],
          'view' => 'views/user/fields/default-team',
          'dynamicLogicVisibleDisabled' => true,
          'defaultAttributes' => NULL
        ],
        'acceptanceStatus' => [
          'type' => 'varchar',
          'notStorable' => true,
          'orderDisabled' => true,
          'exportDisabled' => true,
          'utility' => true,
          'fieldManagerParamList' => [],
          'default' => NULL,
          'maxLength' => NULL,
          'trim' => false,
          'options' => []
        ],
        'acceptanceStatusMeetings' => [
          'type' => 'enum',
          'notStorable' => true,
          'orderDisabled' => true,
          'directUpdateDisabled' => true,
          'layoutAvailabilityList' => [
            0 => 'filters'
          ],
          'importDisabled' => true,
          'exportDisabled' => true,
          'view' => 'crm:views/lead/fields/acceptance-status',
          'link' => 'meetings',
          'column' => 'status',
          'fieldManagerParamList' => [],
          'reportDisabled' => true,
          'options' => false,
          'style' => [],
          'default' => ''
        ],
        'acceptanceStatusCalls' => [
          'type' => 'enum',
          'notStorable' => true,
          'orderDisabled' => true,
          'directUpdateDisabled' => true,
          'layoutAvailabilityList' => [
            0 => 'filters'
          ],
          'importDisabled' => true,
          'exportDisabled' => true,
          'view' => 'crm:views/lead/fields/acceptance-status',
          'link' => 'calls',
          'column' => 'status',
          'fieldManagerParamList' => [],
          'reportDisabled' => true,
          'options' => false,
          'style' => [],
          'default' => ''
        ],
        'teamRole' => [
          'type' => 'varchar',
          'notStorable' => true,
          'orderDisabled' => true,
          'utility' => true,
          'fieldManagerParamList' => [],
          'default' => NULL,
          'maxLength' => NULL,
          'trim' => false,
          'options' => []
        ],
        'teams' => [
          'type' => 'linkMultiple',
          'tooltip' => true,
          'columns' => [
            'role' => 'userRole'
          ],
          'additionalAttributeList' => [
            0 => 'columns'
          ],
          'layoutDetailDisabled' => true,
          'view' => 'views/user/fields/teams',
          'default' => 'javascript: return {teamsIds: []}',
          'audited' => true
        ],
        'roles' => [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => true,
          'tooltip' => true,
          'audited' => true,
          'dynamicLogicVisibleDisabled' => true
        ],
        'portals' => [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'tooltip' => true,
          'audited' => true,
          'dynamicLogicVisibleDisabled' => true
        ],
        'portalRoles' => [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => true,
          'tooltip' => true,
          'audited' => true,
          'dynamicLogicVisibleDisabled' => true
        ],
        'contact' => [
          'type' => 'link',
          'layoutDetailDisabled' => true,
          'view' => 'views/user/fields/contact',
          'fieldManagerParamList' => [
            0 => 'inlineEditDisabled',
            1 => 'tooltipText'
          ],
          'audited' => true,
          'dynamicLogicVisibleDisabled' => true,
          'defaultAttributes' => NULL
        ],
        'accounts' => [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'fieldManagerParamList' => [
            0 => 'inlineEditDisabled',
            1 => 'tooltipText'
          ],
          'audited' => true,
          'dynamicLogicVisibleDisabled' => true
        ],
        'account' => [
          'type' => 'link',
          'notStorable' => true,
          'orderDisabled' => true,
          'directAccessDisabled' => true,
          'foreignAccessDisabled' => true,
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'readOnly' => true,
          'audited' => true,
          'defaultAttributes' => NULL
        ],
        'portal' => [
          'type' => 'link',
          'notStorable' => true,
          'orderDisabled' => true,
          'readOnly' => true,
          'customizationDisabled' => true,
          'utility' => true
        ],
        'avatar' => [
          'type' => 'image',
          'view' => 'views/user/fields/avatar',
          'layoutDetailDisabled' => true,
          'previewSize' => 'small',
          'customizationAuditedDisabled' => true,
          'defaultAttributes' => [
            'avatarId' => NULL
          ],
          'layoutAvailabilityList' => []
        ],
        'avatarColor' => [
          'type' => 'colorpicker',
          'dynamicLogicDisabled' => true,
          'layoutAvailabilityList' => []
        ],
        'sendAccessInfo' => [
          'type' => 'bool',
          'notStorable' => true,
          'orderDisabled' => true,
          'utility' => true
        ],
        'gender' => [
          'type' => 'enum',
          'options' => [
            0 => '',
            1 => 'Male',
            2 => 'Female',
            3 => 'Neutral'
          ],
          'dynamicLogicVisibleDisabled' => true,
          'style' => [
            '' => NULL,
            'Male' => NULL,
            'Female' => NULL,
            'Neutral' => NULL
          ]
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true,
          'fieldManagerParamList' => [
            0 => 'useNumericFormat'
          ],
          'useNumericFormat' => true
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true,
          'fieldManagerParamList' => [
            0 => 'useNumericFormat'
          ]
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user',
          'fieldManagerParamList' => []
        ],
        'dashboardTemplate' => [
          'type' => 'link',
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'customizationAuditedDisabled' => true
        ],
        'workingTimeCalendar' => [
          'type' => 'link',
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'customizationAuditedDisabled' => true
        ],
        'layoutSet' => [
          'type' => 'link',
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'customizationAuditedDisabled' => true,
          'tooltip' => true
        ],
        'auth2FA' => [
          'type' => 'foreign',
          'link' => 'userData',
          'field' => 'auth2FA',
          'readOnly' => true,
          'view' => 'views/fields/foreign-bool'
        ],
        'userData' => [
          'type' => 'linkOne',
          'utility' => true,
          'customizationDisabled' => true
        ],
        'lastAccess' => [
          'type' => 'datetime',
          'notStorable' => true,
          'orderDisabled' => true,
          'readOnly' => true,
          'layoutListDisabled' => true,
          'layoutFiltersDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'layoutDetailDisabled' => true,
          'directAccessDisabled' => true,
          'exportDisabled' => true,
          'default' => NULL,
          'after' => NULL,
          'before' => NULL,
          'minuteStep' => 30
        ],
        'emailAddressList' => [
          'type' => 'array',
          'utility' => true,
          'notStorable' => true,
          'readOnly' => true
        ],
        'userEmailAddressList' => [
          'type' => 'array',
          'utility' => true,
          'notStorable' => true,
          'readOnly' => true
        ],
        'excludeFromReplyEmailAddressList' => [
          'type' => 'array',
          'utility' => true,
          'notStorable' => true,
          'readOnly' => true
        ],
        'recordAccessLevels' => [
          'type' => 'jsonObject',
          'utility' => true,
          'notStorable' => true,
          'readOnly' => true
        ],
        'targetListIsOptedOut' => [
          'type' => 'bool',
          'notStorable' => true,
          'orderDisabled' => true,
          'readOnly' => true,
          'utility' => true,
          'fieldManagerParamList' => []
        ],
        'customerId' => [
          'type' => 'varchar',
          'audited' => true,
          'readOnly' => false,
          'default' => NULL,
          'maxLength' => NULL,
          'options' => [],
          'isCustom' => true,
          'trim' => false
        ],
        'usertoken' => [
          'type' => 'varchar',
          'audited' => true,
          'default' => NULL,
          'maxLength' => NULL,
          'options' => [],
          'isCustom' => true,
          'trim' => false
        ],
        'partnerid' => [
          'type' => 'varchar',
          'default' => NULL,
          'maxLength' => NULL,
          'options' => [],
          'isCustom' => true,
          'trim' => false
        ],
        'isChecked' => [
          'notNull' => true,
          'type' => 'bool',
          'audited' => true,
          'isCustom' => true
        ],
        'clientid' => [
          'type' => 'varchar',
          'default' => NULL,
          'maxLength' => NULL,
          'options' => [],
          'isCustom' => true
        ],
        'clientsecret' => [
          'type' => 'varchar',
          'default' => NULL,
          'maxLength' => NULL,
          'options' => [],
          'isCustom' => true
        ],
        'country' => [
          'readOnly' => true,
          'type' => 'foreign',
          'link' => 'contact',
          'field' => 'country',
          'view' => 'views/fields/foreign-enum',
          'isCustom' => true
        ],
        'awsClientId' => [
          'type' => 'varchar',
          'maxLength' => 200,
          'default' => NULL,
          'options' => [],
          'isCustom' => true
        ],
        'awsClientSecret' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'default' => NULL,
          'options' => [],
          'isCustom' => true
        ],
        'awsMargem' => [
          'notNull' => false,
          'type' => 'float',
          'default' => NULL,
          'min' => NULL,
          'max' => NULL,
          'isCustom' => true
        ],
        'cRegistration' => [
          'type' => 'link'
        ],
        'cAccess' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'options' => [],
          'isCustom' => true
        ],
        'cLinkPortal' => [
          'type' => 'url',
          'audited' => true,
          'isCustom' => true
        ],
        'middleName' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'pattern' => '$noBadCharacters'
        ],
        'emailAddressIsOptedOut' => [
          'layoutMassUpdateDisabled' => true,
          'type' => 'bool',
          'notStorable' => true,
          'layoutDetailDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'mergeDisabled' => true,
          'customizationDefaultDisabled' => true,
          'customizationReadOnlyDisabled' => true,
          'customizationInlineEditDisabledDisabled' => true
        ],
        'emailAddressIsInvalid' => [
          'layoutMassUpdateDisabled' => true,
          'type' => 'bool',
          'notStorable' => true,
          'layoutDetailDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'mergeDisabled' => true,
          'customizationDefaultDisabled' => true,
          'customizationReadOnlyDisabled' => true,
          'customizationInlineEditDisabledDisabled' => true
        ],
        'phoneNumberIsOptedOut' => [
          'type' => 'bool',
          'notStorable' => true,
          'layoutDetailDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'mergeDisabled' => true,
          'customizationDefaultDisabled' => true,
          'customizationReadOnlyDisabled' => true,
          'customizationInlineEditDisabledDisabled' => true
        ],
        'phoneNumberIsInvalid' => [
          'type' => 'bool',
          'notStorable' => true,
          'layoutDetailDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'mergeDisabled' => true,
          'customizationDefaultDisabled' => true,
          'customizationReadOnlyDisabled' => true,
          'customizationInlineEditDisabledDisabled' => true
        ],
        'deleteId' => [
          'type' => 'varchar',
          'maxLength' => 17,
          'readOnly' => true,
          'notNull' => true,
          'default' => '0',
          'utility' => true,
          'customizationDisabled' => true
        ]
      ],
      'links' => [
        'defaultTeam' => [
          'type' => 'belongsTo',
          'entity' => 'Team'
        ],
        'teams' => [
          'type' => 'hasMany',
          'entity' => 'Team',
          'foreign' => 'users',
          'additionalColumns' => [
            'role' => [
              'type' => 'varchar',
              'len' => 100
            ]
          ],
          'layoutRelationshipsDisabled' => true,
          'columnAttributeMap' => [
            'role' => 'teamRole'
          ],
          'dynamicLogicVisibleDisabled' => true,
          'audited' => false
        ],
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'roles' => [
          'type' => 'hasMany',
          'entity' => 'Role',
          'foreign' => 'users',
          'layoutRelationshipsDisabled' => true,
          'audited' => false
        ],
        'portals' => [
          'type' => 'hasMany',
          'entity' => 'Portal',
          'foreign' => 'users',
          'layoutRelationshipsDisabled' => true,
          'audited' => false
        ],
        'portalRoles' => [
          'type' => 'hasMany',
          'entity' => 'PortalRole',
          'foreign' => 'users',
          'layoutRelationshipsDisabled' => true,
          'audited' => false
        ],
        'dashboardTemplate' => [
          'type' => 'belongsTo',
          'entity' => 'DashboardTemplate'
        ],
        'workingTimeCalendar' => [
          'type' => 'belongsTo',
          'entity' => 'WorkingTimeCalendar',
          'noJoin' => true
        ],
        'workingTimeRanges' => [
          'type' => 'hasMany',
          'foreign' => 'users',
          'entity' => 'WorkingTimeRange'
        ],
        'layoutSet' => [
          'type' => 'belongsTo',
          'entity' => 'LayoutSet',
          'noJoin' => true
        ],
        'userData' => [
          'type' => 'hasOne',
          'entity' => 'UserData',
          'foreign' => 'user',
          'foreignName' => 'id'
        ],
        'meetings' => [
          'type' => 'hasMany',
          'entity' => 'Meeting',
          'foreign' => 'users',
          'columnAttributeMap' => [
            'status' => 'acceptanceStatus'
          ]
        ],
        'calls' => [
          'type' => 'hasMany',
          'entity' => 'Call',
          'foreign' => 'users',
          'columnAttributeMap' => [
            'status' => 'acceptanceStatus'
          ]
        ],
        'emails' => [
          'type' => 'hasMany',
          'entity' => 'Email',
          'foreign' => 'users'
        ],
        'notes' => [
          'type' => 'hasMany',
          'entity' => 'Note',
          'foreign' => 'users',
          'layoutRelationshipsDisabled' => true
        ],
        'contact' => [
          'type' => 'belongsTo',
          'entity' => 'Contact',
          'foreign' => 'portalUser'
        ],
        'accounts' => [
          'type' => 'hasMany',
          'entity' => 'Account',
          'foreign' => 'portalUsers',
          'relationName' => 'AccountPortalUser',
          'audited' => false
        ],
        'tasks' => [
          'type' => 'hasMany',
          'entity' => 'Task',
          'foreign' => 'assignedUser',
          'audited' => false
        ],
        'targetLists' => [
          'type' => 'hasMany',
          'entity' => 'TargetList',
          'foreign' => 'users',
          'columnAttributeMap' => [
            'optedOut' => 'targetListIsOptedOut'
          ],
          'audited' => false
        ],
        'reportEmailSending' => [
          'type' => 'hasMany',
          'entity' => 'Report',
          'foreign' => 'emailSendingUsers',
          'utility' => true,
          'audited' => false
        ],
        'cRegistration' => [
          'type' => 'belongsTo',
          'foreign' => 'portalUser',
          'entity' => 'CRegistration',
          'isCustom' => true
        ]
      ],
      'collection' => [
        'orderBy' => 'userName',
        'order' => 'asc',
        'textFilterFields' => [
          0 => 'name',
          1 => 'userName',
          2 => 'emailAddress',
          3 => 'phoneNumber'
        ],
        'fullTextSearch' => false,
        'sortBy' => 'userName',
        'asc' => true
      ],
      'indexes' => [
        'userNameDeleteId' => [
          'type' => 'unique',
          'columns' => [
            0 => 'userName',
            1 => 'deleteId'
          ]
        ]
      ],
      'deleteId' => true
    ],
    'UserData' => [
      'fields' => [
        'auth2FA' => [
          'type' => 'bool'
        ],
        'auth2FAMethod' => [
          'type' => 'enum'
        ],
        'auth2FATotpSecret' => [
          'type' => 'varchar',
          'maxLength' => 32
        ],
        'auth2FAEmailAddress' => [
          'type' => 'varchar'
        ]
      ],
      'links' => [
        'user' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ]
    ],
    'UserReaction' => [
      'fields' => [
        'type' => [
          'type' => 'varchar',
          'maxLength' => 10
        ],
        'user' => [
          'type' => 'link'
        ],
        'parent' => [
          'type' => 'linkParent'
        ],
        'createdAt' => [
          'type' => 'datetime'
        ]
      ],
      'links' => [
        'user' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'parent' => [
          'type' => 'belongsToParent',
          'entityList' => [
            0 => 'Note'
          ]
        ]
      ],
      'indexes' => [
        'parentUserType' => [
          'unique' => true,
          'columns' => [
            0 => 'parentId',
            1 => 'parentType',
            2 => 'userId',
            3 => 'type'
          ]
        ]
      ],
      'noDeletedAttribute' => true
    ],
    'Webhook' => [
      'fields' => [
        'event' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'required' => true,
          'view' => 'views/webhook/fields/event'
        ],
        'url' => [
          'type' => 'varchar',
          'maxLength' => 512,
          'required' => true,
          'copyToClipboard' => true
        ],
        'isActive' => [
          'type' => 'bool',
          'default' => true
        ],
        'user' => [
          'type' => 'link',
          'view' => 'views/webhook/fields/user'
        ],
        'entityType' => [
          'type' => 'varchar',
          'readOnly' => true,
          'view' => 'views/fields/entity-type'
        ],
        'type' => [
          'type' => 'enum',
          'options' => [
            0 => 'create',
            1 => 'update',
            2 => 'fieldUpdate',
            3 => 'delete'
          ],
          'readOnly' => true
        ],
        'field' => [
          'type' => 'varchar',
          'readOnly' => true
        ],
        'secretKey' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'readOnly' => true,
          'layoutMassUpdateDisabled' => true,
          'layoutFiltersDisabled' => true,
          'layoutListDisabled' => true
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => [
          'type' => 'link',
          'readOnly' => true
        ]
      ],
      'links' => [
        'user' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ],
      'collection' => [
        'orderBy' => 'createdAt',
        'order' => 'desc',
        'textFilterFields' => [
          0 => 'event'
        ],
        'sortBy' => 'createdAt',
        'asc' => false
      ],
      'indexes' => [
        'event' => [
          'columns' => [
            0 => 'event'
          ]
        ],
        'entityTypeType' => [
          'columns' => [
            0 => 'entityType',
            1 => 'type'
          ]
        ],
        'entityTypeField' => [
          'columns' => [
            0 => 'entityType',
            1 => 'field'
          ]
        ]
      ],
      'hooksDisabled' => true
    ],
    'WebhookEventQueueItem' => [
      'fields' => [
        'number' => [
          'type' => 'autoincrement',
          'dbType' => 'bigint'
        ],
        'event' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'required' => true
        ],
        'target' => [
          'type' => 'linkParent'
        ],
        'data' => [
          'type' => 'jsonObject'
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'isProcessed' => [
          'type' => 'bool'
        ]
      ],
      'links' => [],
      'collection' => [
        'orderBy' => 'number',
        'order' => 'desc',
        'sortBy' => 'number',
        'asc' => false
      ]
    ],
    'WebhookQueueItem' => [
      'fields' => [
        'number' => [
          'type' => 'autoincrement',
          'dbType' => 'bigint'
        ],
        'event' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'required' => true
        ],
        'webhook' => [
          'type' => 'link'
        ],
        'target' => [
          'type' => 'linkParent'
        ],
        'data' => [
          'type' => 'jsonObject'
        ],
        'createdAt' => [
          'type' => 'datetime',
          'hasSeconds' => true
        ],
        'status' => [
          'type' => 'enum',
          'options' => [
            0 => 'Pending',
            1 => 'Success',
            2 => 'Failed'
          ],
          'default' => 'Pending',
          'maxLength' => 7,
          'style' => [
            'Success' => 'success',
            'Failed' => 'danger'
          ]
        ],
        'processedAt' => [
          'type' => 'datetime',
          'hasSeconds' => true
        ],
        'attempts' => [
          'type' => 'int',
          'default' => 0
        ],
        'processAt' => [
          'type' => 'datetime'
        ]
      ],
      'links' => [
        'target' => [
          'type' => 'belongsToParent'
        ],
        'webhook' => [
          'type' => 'belongsTo',
          'entity' => 'Webhook',
          'foreignName' => 'id'
        ]
      ],
      'collection' => [
        'orderBy' => 'number',
        'order' => 'desc',
        'sortBy' => 'number',
        'asc' => false
      ]
    ],
    'WorkingTimeCalendar' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'required' => true
        ],
        'description' => [
          'type' => 'text'
        ],
        'timeZone' => [
          'type' => 'enum',
          'default' => '',
          'view' => 'views/preferences/fields/time-zone'
        ],
        'timeRanges' => [
          'type' => 'jsonArray',
          'default' => [
            0 => [
              0 => '9:00',
              1 => '17:00'
            ]
          ],
          'view' => 'views/working-time-calendar/fields/time-ranges',
          'required' => true
        ],
        'weekday0' => [
          'type' => 'bool',
          'default' => false
        ],
        'weekday1' => [
          'type' => 'bool',
          'default' => true
        ],
        'weekday2' => [
          'type' => 'bool',
          'default' => true
        ],
        'weekday3' => [
          'type' => 'bool',
          'default' => true
        ],
        'weekday4' => [
          'type' => 'bool',
          'default' => true
        ],
        'weekday5' => [
          'type' => 'bool',
          'default' => true
        ],
        'weekday6' => [
          'type' => 'bool',
          'default' => false
        ],
        'weekday0TimeRanges' => [
          'type' => 'jsonArray',
          'default' => NULL,
          'view' => 'views/working-time-calendar/fields/time-ranges'
        ],
        'weekday1TimeRanges' => [
          'type' => 'jsonArray',
          'default' => NULL,
          'view' => 'views/working-time-calendar/fields/time-ranges'
        ],
        'weekday2TimeRanges' => [
          'type' => 'jsonArray',
          'default' => NULL,
          'view' => 'views/working-time-calendar/fields/time-ranges'
        ],
        'weekday3TimeRanges' => [
          'type' => 'jsonArray',
          'default' => NULL,
          'view' => 'views/working-time-calendar/fields/time-ranges'
        ],
        'weekday4TimeRanges' => [
          'type' => 'jsonArray',
          'default' => NULL,
          'view' => 'views/working-time-calendar/fields/time-ranges'
        ],
        'weekday5TimeRanges' => [
          'type' => 'jsonArray',
          'default' => NULL,
          'view' => 'views/working-time-calendar/fields/time-ranges'
        ],
        'weekday6TimeRanges' => [
          'type' => 'jsonArray',
          'default' => NULL,
          'view' => 'views/working-time-calendar/fields/time-ranges'
        ],
        'teams' => [
          'type' => 'linkMultiple',
          'readOnly' => true
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => [
          'type' => 'link',
          'readOnly' => true
        ]
      ],
      'links' => [
        'ranges' => [
          'type' => 'hasMany',
          'foreign' => 'calendars',
          'entity' => 'WorkingTimeRange'
        ],
        'teams' => [
          'type' => 'hasMany',
          'foreign' => 'workingTimeCalendar',
          'entity' => 'Team',
          'readOnly' => true
        ],
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ],
      'collection' => [
        'orderBy' => 'name',
        'order' => 'asc',
        'textFilterFields' => [
          0 => 'name'
        ],
        'sortBy' => 'name',
        'asc' => true
      ]
    ],
    'WorkingTimeRange' => [
      'fields' => [
        'timeRanges' => [
          'type' => 'jsonArray',
          'default' => NULL,
          'view' => 'views/working-time-calendar/fields/time-ranges'
        ],
        'dateStart' => [
          'type' => 'date',
          'required' => true
        ],
        'dateEnd' => [
          'type' => 'date',
          'required' => true,
          'view' => 'views/working-time-range/fields/date-end',
          'after' => 'dateStart',
          'afterOrEqual' => true
        ],
        'type' => [
          'type' => 'enum',
          'options' => [
            0 => 'Non-working',
            1 => 'Working'
          ],
          'default' => 'Non-working',
          'index' => true,
          'maxLength' => 11
        ],
        'name' => [
          'type' => 'varchar'
        ],
        'description' => [
          'type' => 'text'
        ],
        'calendars' => [
          'type' => 'linkMultiple',
          'tooltip' => true
        ],
        'users' => [
          'type' => 'linkMultiple',
          'view' => 'views/working-time-range/fields/users',
          'tooltip' => true
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => [
          'type' => 'link',
          'readOnly' => true
        ]
      ],
      'links' => [
        'calendars' => [
          'type' => 'hasMany',
          'foreign' => 'ranges',
          'entity' => 'WorkingTimeCalendar'
        ],
        'users' => [
          'type' => 'hasMany',
          'foreign' => 'workingTimeRanges',
          'entity' => 'User'
        ],
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ],
      'collection' => [
        'orderBy' => 'dateStart',
        'order' => 'desc',
        'sortBy' => 'dateStart',
        'asc' => false
      ],
      'indexes' => [
        'typeRange' => [
          'columns' => [
            0 => 'type',
            1 => 'dateStart',
            2 => 'dateEnd'
          ]
        ],
        'type' => [
          'columns' => [
            0 => 'type'
          ]
        ]
      ]
    ],
    'Account' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'maxLength' => 249,
          'required' => true,
          'pattern' => '$noBadCharacters',
          'audited' => true,
          'default' => NULL,
          'options' => []
        ],
        'website' => [
          'type' => 'url',
          'strip' => true
        ],
        'emailAddress' => [
          'type' => 'email',
          'isPersonalData' => true
        ],
        'phoneNumber' => [
          'type' => 'phone',
          'typeList' => [
            0 => 'Office',
            1 => 'Mobile',
            2 => 'Fax',
            3 => 'Other'
          ],
          'defaultType' => 'Office'
        ],
        'type' => [
          'type' => 'enum',
          'options' => [
            0 => '',
            1 => 'Customer',
            2 => 'ISV',
            3 => 'Partner'
          ],
          'customizationOptionsReferenceDisabled' => true,
          'style' => [
            '' => NULL,
            'Customer' => NULL,
            'ISV' => NULL,
            'Partner' => NULL
          ],
          'required' => true
        ],
        'industry' => [
          'type' => 'enum',
          'options' => [
            0 => '',
            1 => 'Advertising',
            2 => 'Aerospace',
            3 => 'Agriculture',
            4 => 'Apparel & Accessories',
            5 => 'Architecture',
            6 => 'Automotive',
            7 => 'Banking',
            8 => 'Biotechnology',
            9 => 'Building Materials & Equipment',
            10 => 'Chemical',
            11 => 'Construction',
            12 => 'Consulting',
            13 => 'Computer',
            14 => 'Culture',
            15 => 'Creative',
            16 => 'Defense',
            17 => 'Education',
            18 => 'Electronics',
            19 => 'Electric Power',
            20 => 'Energy',
            21 => 'Entertainment & Leisure',
            22 => 'Finance',
            23 => 'Food & Beverage',
            24 => 'Grocery',
            25 => 'Healthcare',
            26 => 'Hospitality',
            27 => 'Insurance',
            28 => 'Manufacturing',
            29 => 'Mass Media',
            30 => 'Marketing',
            31 => 'Mining',
            32 => 'Music',
            33 => 'Publishing',
            34 => 'Petroleum',
            35 => 'Real Estate',
            36 => 'Retail',
            37 => 'Service',
            38 => 'Sports',
            39 => 'Software',
            40 => 'Support',
            41 => 'Shipping',
            42 => 'Travel',
            43 => 'Technology',
            44 => 'Telecommunications',
            45 => 'Television',
            46 => 'Transportation',
            47 => 'Testing, Inspection & Certification',
            48 => 'Venture Capital',
            49 => 'Wholesale',
            50 => 'Water'
          ],
          'isSorted' => true,
          'customizationOptionsReferenceDisabled' => true,
          'style' => [
            '' => NULL,
            'Advertising' => NULL,
            'Aerospace' => NULL,
            'Agriculture' => NULL,
            'Apparel & Accessories' => NULL,
            'Architecture' => NULL,
            'Automotive' => NULL,
            'Banking' => NULL,
            'Biotechnology' => NULL,
            'Building Materials & Equipment' => NULL,
            'Chemical' => NULL,
            'Construction' => NULL,
            'Consulting' => NULL,
            'Computer' => NULL,
            'Culture' => NULL,
            'Creative' => NULL,
            'Defense' => NULL,
            'Education' => NULL,
            'Electronics' => NULL,
            'Electric Power' => NULL,
            'Energy' => NULL,
            'Entertainment & Leisure' => NULL,
            'Finance' => NULL,
            'Food & Beverage' => NULL,
            'Grocery' => NULL,
            'Healthcare' => NULL,
            'Hospitality' => NULL,
            'Insurance' => NULL,
            'Manufacturing' => NULL,
            'Mass Media' => NULL,
            'Marketing' => NULL,
            'Mining' => NULL,
            'Music' => NULL,
            'Publishing' => NULL,
            'Petroleum' => NULL,
            'Real Estate' => NULL,
            'Retail' => NULL,
            'Service' => NULL,
            'Sports' => NULL,
            'Software' => NULL,
            'Support' => NULL,
            'Shipping' => NULL,
            'Travel' => NULL,
            'Technology' => NULL,
            'Telecommunications' => NULL,
            'Television' => NULL,
            'Transportation' => NULL,
            'Testing, Inspection & Certification' => NULL,
            'Venture Capital' => NULL,
            'Wholesale' => NULL,
            'Water' => NULL
          ]
        ],
        'sicCode' => [
          'type' => 'varchar',
          'maxLength' => 40,
          'pattern' => '$noBadCharacters',
          'noSpellCheck' => true
        ],
        'contactRole' => [
          'type' => 'varchar',
          'notStorable' => true,
          'utility' => true,
          'orderDisabled' => true,
          'maxLength' => 100,
          'pattern' => '$noBadCharacters',
          'layoutMassUpdateDisabled' => true,
          'layoutListDisabled' => true,
          'layoutDetailDisabled' => true,
          'layoutSearchDisabled' => true,
          'fieldManagerParamList' => [
            0 => 'pattern'
          ],
          'default' => NULL,
          'trim' => false,
          'options' => []
        ],
        'contactIsInactive' => [
          'type' => 'bool',
          'notStorable' => true,
          'orderDisabled' => true,
          'default' => false,
          'utility' => true
        ],
        'billingAddress' => [
          'type' => 'address'
        ],
        'billingAddressStreet' => [
          'type' => 'text',
          'maxLength' => 255,
          'dbType' => 'varchar'
        ],
        'billingAddressCity' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'views/fields/address-city',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'pattern' => '$noBadCharacters'
        ],
        'billingAddressState' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'views/fields/address-state',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'pattern' => '$noBadCharacters'
        ],
        'billingAddressCountry' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'views/fields/address-country',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'pattern' => '$noBadCharacters'
        ],
        'billingAddressPostalCode' => [
          'type' => 'varchar',
          'maxLength' => 40,
          'pattern' => '$noBadCharacters'
        ],
        'shippingAddress' => [
          'type' => 'address',
          'view' => 'crm:views/account/fields/shipping-address'
        ],
        'shippingAddressStreet' => [
          'type' => 'text',
          'maxLength' => 255,
          'dbType' => 'varchar'
        ],
        'shippingAddressCity' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'views/fields/address-city',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'pattern' => '$noBadCharacters'
        ],
        'shippingAddressState' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'views/fields/address-state',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'pattern' => '$noBadCharacters'
        ],
        'shippingAddressCountry' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'views/fields/address-country',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'pattern' => '$noBadCharacters'
        ],
        'shippingAddressPostalCode' => [
          'type' => 'varchar',
          'maxLength' => 40,
          'pattern' => '$noBadCharacters'
        ],
        'description' => [
          'type' => 'text',
          'default' => NULL,
          'maxLength' => NULL,
          'rows' => NULL,
          'cutHeight' => NULL
        ],
        'campaign' => [
          'type' => 'link'
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true,
          'fieldManagerParamList' => [
            0 => 'useNumericFormat'
          ]
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true,
          'fieldManagerParamList' => [
            0 => 'useNumericFormat'
          ]
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user',
          'fieldManagerParamList' => []
        ],
        'modifiedBy' => [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user',
          'fieldManagerParamList' => []
        ],
        'assignedUser' => [
          'type' => 'link',
          'view' => 'views/fields/assigned-user'
        ],
        'teams' => [
          'type' => 'linkMultiple',
          'view' => 'views/fields/teams'
        ],
        'targetLists' => [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'importDisabled' => true,
          'exportDisabled' => true,
          'noLoad' => true
        ],
        'targetList' => [
          'type' => 'link',
          'notStorable' => true,
          'orderDisabled' => true,
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'layoutFiltersDisabled' => true,
          'entity' => 'TargetList',
          'directAccessDisabled' => true,
          'reportDisabled' => true,
          'defaultAttributes' => NULL
        ],
        'originalLead' => [
          'type' => 'linkOne',
          'readOnly' => true,
          'view' => 'views/fields/link-one',
          'defaultAttributes' => NULL
        ],
        'targetListIsOptedOut' => [
          'type' => 'bool',
          'notStorable' => true,
          'orderDisabled' => true,
          'readOnly' => true,
          'utility' => true
        ],
        'priceBook' => [
          'type' => 'link',
          'autocompleteOnEmpty' => true
        ],
        'electronicAddressScheme' => [
          'type' => 'enum',
          'maxLength' => 4,
          'view' => 'sales:views/fields/electronic-address-scheme',
          'validatorClassNameList' => [
            0 => 'Espo\\Modules\\Sales\\FieldValidators\\Account\\ElectronicAddressScheme\\Valid'
          ]
        ],
        'electronicAddressIdentifier' => [
          'type' => 'varchar',
          'maxLength' => 255
        ],
        'products' => [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => false,
          'layoutMassUpdateDisabled' => false,
          'noLoad' => false,
          'importDisabled' => false,
          'isCustom' => true
        ],
        'recommendations' => [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'noLoad' => true,
          'importDisabled' => true,
          'isCustom' => true
        ],
        'resourceCategories' => [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'noLoad' => true,
          'importDisabled' => true,
          'isCustom' => true
        ],
        'resourceGroups' => [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'noLoad' => true,
          'importDisabled' => true,
          'isCustom' => true
        ],
        'monitorings' => [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'noLoad' => true,
          'importDisabled' => true,
          'isCustom' => true
        ],
        'edge' => [
          'type' => 'enum',
          'options' => [
            0 => 'Engage',
            1 => 'Develop',
            2 => 'Grow',
            3 => 'Extend',
            4 => ''
          ],
          'style' => [
            'Engage' => NULL,
            'Develop' => NULL,
            'Grow' => NULL,
            'Extend' => NULL,
            '' => NULL
          ],
          'default' => NULL,
          'isCustom' => true,
          'audited' => true
        ],
        'tags' => [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'noLoad' => true,
          'importDisabled' => true,
          'isCustom' => true
        ],
        'subscriptions' => [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => false,
          'layoutMassUpdateDisabled' => false,
          'noLoad' => false,
          'importDisabled' => false,
          'isCustom' => true
        ],
        'country' => [
          'type' => 'enum',
          'options' => [
            0 => 'Select',
            1 => 'Argentina',
            2 => 'Brazil',
            3 => 'Colombia',
            4 => 'Canada',
            5 => 'Equador',
            6 => 'Mexico',
            7 => 'South Africa',
            8 => 'United States of America',
            9 => 'Cala',
            10 => 'Chile',
            11 => 'Peru',
            12 => 'Uruguai',
            13 => ''
          ],
          'style' => [
            'Select' => 'warning',
            'Argentina' => NULL,
            'Brazil' => NULL,
            'Colombia' => NULL,
            'Canada' => NULL,
            'Equador' => NULL,
            'Mexico' => NULL,
            'South Africa' => NULL,
            'United States of America' => NULL,
            'Cala' => NULL,
            'Chile' => NULL,
            'Peru' => NULL,
            'Uruguai' => NULL,
            '' => NULL
          ],
          'default' => NULL,
          'isCustom' => true,
          'required' => true
        ],
        'clientsecret' => [
          'type' => 'varchar',
          'default' => NULL,
          'maxLength' => NULL,
          'options' => [],
          'isCustom' => true
        ],
        'clientid' => [
          'type' => 'varchar',
          'default' => NULL,
          'maxLength' => NULL,
          'options' => [],
          'isCustom' => true
        ],
        'cMpnID' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'options' => [],
          'isCustom' => true
        ],
        'cTenantID' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'options' => [],
          'isCustom' => true
        ],
        'cRegistrationsReseller' => [
          'type' => 'linkMultiple'
        ],
        'cRegistrationsCustomer' => [
          'type' => 'linkMultiple'
        ],
        'cRecommendationsConfig' => [
          'type' => 'linkMultiple'
        ],
        'cRecommendationses' => [
          'type' => 'linkMultiple'
        ],
        'emailAddressIsOptedOut' => [
          'type' => 'bool',
          'notStorable' => true,
          'layoutDetailDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'mergeDisabled' => true,
          'customizationDefaultDisabled' => true,
          'customizationReadOnlyDisabled' => true,
          'customizationInlineEditDisabledDisabled' => true
        ],
        'emailAddressIsInvalid' => [
          'type' => 'bool',
          'notStorable' => true,
          'layoutDetailDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'mergeDisabled' => true,
          'customizationDefaultDisabled' => true,
          'customizationReadOnlyDisabled' => true,
          'customizationInlineEditDisabledDisabled' => true
        ],
        'phoneNumberIsOptedOut' => [
          'type' => 'bool',
          'notStorable' => true,
          'layoutDetailDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'mergeDisabled' => true,
          'customizationDefaultDisabled' => true,
          'customizationReadOnlyDisabled' => true,
          'customizationInlineEditDisabledDisabled' => true
        ],
        'phoneNumberIsInvalid' => [
          'type' => 'bool',
          'notStorable' => true,
          'layoutDetailDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'mergeDisabled' => true,
          'customizationDefaultDisabled' => true,
          'customizationReadOnlyDisabled' => true,
          'customizationInlineEditDisabledDisabled' => true
        ],
        'billingAddressMap' => [
          'type' => 'map',
          'notStorable' => true,
          'orderDisabled' => true,
          'readOnly' => true,
          'layoutListDisabled' => true,
          'provider' => 'Google',
          'height' => 300,
          'exportDisabled' => true,
          'importDisabled' => true
        ],
        'shippingAddressMap' => [
          'type' => 'map',
          'notStorable' => true,
          'orderDisabled' => true,
          'readOnly' => true,
          'layoutListDisabled' => true,
          'provider' => 'Google',
          'height' => 300,
          'exportDisabled' => true,
          'importDisabled' => true
        ],
        'streamUpdatedAt' => [
          'type' => 'datetime',
          'readOnly' => true,
          'customizationReadOnlyDisabled' => true
        ]
      ],
      'links' => [
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'assignedUser' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'teams' => [
          'type' => 'hasMany',
          'entity' => 'Team',
          'relationName' => 'entityTeam',
          'layoutRelationshipsDisabled' => true
        ],
        'contacts' => [
          'type' => 'hasMany',
          'entity' => 'Contact',
          'foreign' => 'accounts',
          'columnAttributeMap' => [
            'role' => 'contactRole',
            'isInactive' => 'contactIsInactive'
          ],
          'audited' => false
        ],
        'contactsPrimary' => [
          'type' => 'hasMany',
          'entity' => 'Contact',
          'foreign' => 'account',
          'layoutRelationshipsDisabled' => true
        ],
        'opportunities' => [
          'type' => 'hasMany',
          'entity' => 'Opportunity',
          'foreign' => 'account',
          'audited' => false
        ],
        'cases' => [
          'type' => 'hasMany',
          'entity' => 'Case',
          'foreign' => 'account'
        ],
        'documents' => [
          'type' => 'hasMany',
          'entity' => 'Document',
          'foreign' => 'accounts',
          'audited' => true
        ],
        'meetingsPrimary' => [
          'type' => 'hasMany',
          'entity' => 'Meeting',
          'foreign' => 'account',
          'layoutRelationshipsDisabled' => true
        ],
        'emailsPrimary' => [
          'type' => 'hasMany',
          'entity' => 'Email',
          'foreign' => 'account',
          'layoutRelationshipsDisabled' => true,
          'audited' => false
        ],
        'callsPrimary' => [
          'type' => 'hasMany',
          'entity' => 'Call',
          'foreign' => 'account',
          'layoutRelationshipsDisabled' => true
        ],
        'tasksPrimary' => [
          'type' => 'hasMany',
          'entity' => 'Task',
          'foreign' => 'account',
          'layoutRelationshipsDisabled' => true
        ],
        'meetings' => [
          'type' => 'hasChildren',
          'entity' => 'Meeting',
          'foreign' => 'parent',
          'audited' => true
        ],
        'calls' => [
          'type' => 'hasChildren',
          'entity' => 'Call',
          'foreign' => 'parent',
          'audited' => true
        ],
        'tasks' => [
          'type' => 'hasChildren',
          'entity' => 'Task',
          'foreign' => 'parent'
        ],
        'emails' => [
          'type' => 'hasChildren',
          'entity' => 'Email',
          'foreign' => 'parent',
          'layoutRelationshipsDisabled' => true
        ],
        'campaign' => [
          'type' => 'belongsTo',
          'entity' => 'Campaign',
          'foreign' => 'accounts'
        ],
        'campaignLogRecords' => [
          'type' => 'hasChildren',
          'entity' => 'CampaignLogRecord',
          'foreign' => 'parent'
        ],
        'targetLists' => [
          'type' => 'hasMany',
          'entity' => 'TargetList',
          'foreign' => 'accounts',
          'columnAttributeMap' => [
            'optedOut' => 'targetListIsOptedOut'
          ]
        ],
        'portalUsers' => [
          'type' => 'hasMany',
          'entity' => 'User',
          'foreign' => 'accounts',
          'audited' => false
        ],
        'originalLead' => [
          'type' => 'hasOne',
          'entity' => 'Lead',
          'foreign' => 'createdAccount'
        ],
        'supplier' => [
          'type' => 'hasOne',
          'foreign' => 'account',
          'entity' => 'Supplier'
        ],
        'quotes' => [
          'type' => 'hasMany',
          'entity' => 'Quote',
          'foreign' => 'account',
          'audited' => true
        ],
        'quoteItems' => [
          'type' => 'hasMany',
          'entity' => 'QuoteItem',
          'foreign' => 'account',
          'layoutRelationshipsDisabled' => true,
          'audited' => false
        ],
        'salesOrders' => [
          'type' => 'hasMany',
          'entity' => 'SalesOrder',
          'foreign' => 'account',
          'audited' => true
        ],
        'salesOrderItems' => [
          'type' => 'hasMany',
          'entity' => 'SalesOrderItem',
          'foreign' => 'account',
          'layoutRelationshipsDisabled' => true,
          'audited' => false
        ],
        'invoices' => [
          'type' => 'hasMany',
          'entity' => 'Invoice',
          'foreign' => 'account',
          'audited' => true
        ],
        'invoiceItems' => [
          'type' => 'hasMany',
          'entity' => 'InvoiceItem',
          'foreign' => 'account',
          'layoutRelationshipsDisabled' => true,
          'audited' => false
        ],
        'purchaseOrders' => [
          'type' => 'hasMany',
          'entity' => 'PurchaseOrder',
          'foreign' => 'account',
          'audited' => true
        ],
        'purchaseOrderItems' => [
          'type' => 'hasMany',
          'entity' => 'PurchaseOrderItem',
          'foreign' => 'account',
          'layoutRelationshipsDisabled' => true
        ],
        'deliveryOrders' => [
          'type' => 'hasMany',
          'entity' => 'DeliveryOrder',
          'foreign' => 'account',
          'audited' => true
        ],
        'deliveryOrderItems' => [
          'type' => 'hasMany',
          'entity' => 'DeliveryOrderItem',
          'foreign' => 'account',
          'layoutRelationshipsDisabled' => true
        ],
        'receiptOrders' => [
          'type' => 'hasMany',
          'entity' => 'ReceiptOrder',
          'foreign' => 'account',
          'audited' => true
        ],
        'returnOrders' => [
          'type' => 'hasMany',
          'entity' => 'ReturnOrder',
          'foreign' => 'account',
          'audited' => true
        ],
        'receiptOrderItems' => [
          'type' => 'hasMany',
          'entity' => 'ReceiptOrderItem',
          'foreign' => 'account',
          'layoutRelationshipsDisabled' => true
        ],
        'returnOrderItems' => [
          'type' => 'hasMany',
          'entity' => 'ReturnOrderItem',
          'foreign' => 'account',
          'layoutRelationshipsDisabled' => true
        ],
        'priceBook' => [
          'type' => 'belongsTo',
          'entity' => 'PriceBook',
          'foreign' => 'accounts'
        ],
        'products' => [
          'type' => 'hasMany',
          'foreign' => 'account',
          'entity' => 'Product',
          'audited' => false,
          'isCustom' => true
        ],
        'recommendations' => [
          'type' => 'hasMany',
          'foreign' => 'account',
          'entity' => 'Recommendation',
          'audited' => false,
          'isCustom' => true
        ],
        'resourceCategories' => [
          'type' => 'hasMany',
          'foreign' => 'account',
          'entity' => 'ResourceCategory',
          'audited' => false,
          'isCustom' => true
        ],
        'resourceGroups' => [
          'type' => 'hasMany',
          'foreign' => 'account',
          'entity' => 'ResourceGroup',
          'audited' => false,
          'isCustom' => true
        ],
        'monitorings' => [
          'type' => 'hasMany',
          'foreign' => 'account',
          'entity' => 'Monitoring',
          'audited' => false,
          'isCustom' => true
        ],
        'tags' => [
          'type' => 'hasMany',
          'foreign' => 'account',
          'entity' => 'Tags',
          'audited' => false,
          'isCustom' => true
        ],
        'subscriptions' => [
          'type' => 'hasMany',
          'foreign' => 'account',
          'entity' => 'Subscriptions',
          'audited' => false,
          'isCustom' => true
        ],
        'cRegistrationsReseller' => [
          'type' => 'hasMany',
          'foreign' => 'resellerRegistered',
          'entity' => 'CRegistration',
          'audited' => false,
          'isCustom' => true
        ],
        'cRegistrationsCustomer' => [
          'type' => 'hasMany',
          'foreign' => 'customerRegistered',
          'entity' => 'CRegistration',
          'audited' => false,
          'isCustom' => true
        ],
        'cRecommendationsConfig' => [
          'type' => 'hasMany',
          'foreign' => 'account',
          'entity' => 'CRecommendationsConfig',
          'audited' => false,
          'isCustom' => true
        ],
        'cRecommendationses' => [
          'type' => 'hasMany',
          'foreign' => 'account',
          'entity' => 'CRecommendations',
          'audited' => false,
          'isCustom' => true
        ]
      ],
      'collection' => [
        'orderBy' => 'createdAt',
        'order' => 'desc',
        'textFilterFields' => [
          0 => 'name',
          1 => 'emailAddress'
        ],
        'fullTextSearch' => false,
        'countDisabled' => false,
        'sortBy' => 'createdAt',
        'asc' => false
      ],
      'indexes' => [
        'createdAt' => [
          'columns' => [
            0 => 'createdAt',
            1 => 'deleted'
          ]
        ],
        'createdAtId' => [
          'unique' => true,
          'columns' => [
            0 => 'createdAt',
            1 => 'id'
          ]
        ],
        'name' => [
          'columns' => [
            0 => 'name',
            1 => 'deleted'
          ]
        ],
        'assignedUser' => [
          'columns' => [
            0 => 'assignedUserId',
            1 => 'deleted'
          ]
        ]
      ],
      'optimisticConcurrencyControl' => false
    ],
    'Call' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'required' => true,
          'pattern' => '$noBadCharacters'
        ],
        'status' => [
          'type' => 'enum',
          'options' => [
            0 => 'Planned',
            1 => 'Held',
            2 => 'Not Held'
          ],
          'default' => 'Planned',
          'style' => [
            'Held' => 'success',
            'Not Held' => 'info'
          ],
          'displayAsLabel' => true,
          'labelType' => 'state',
          'audited' => true,
          'customizationOptionsReferenceDisabled' => true
        ],
        'dateStart' => [
          'type' => 'datetime',
          'required' => true,
          'default' => 'javascript: return this.dateTime.getNow(15);',
          'audited' => true,
          'view' => 'crm:views/call/fields/date-start'
        ],
        'dateEnd' => [
          'type' => 'datetime',
          'required' => true,
          'after' => 'dateStart',
          'afterOrEqual' => true
        ],
        'duration' => [
          'type' => 'duration',
          'start' => 'dateStart',
          'end' => 'dateEnd',
          'options' => [
            0 => 300,
            1 => 600,
            2 => 900,
            3 => 1800,
            4 => 2700,
            5 => 3600,
            6 => 7200
          ],
          'default' => 300,
          'notStorable' => true,
          'select' => [
            'select' => 'TIMESTAMPDIFF_SECOND:(dateStart, dateEnd)'
          ],
          'order' => [
            'order' => [
              0 => [
                0 => 'TIMESTAMPDIFF_SECOND:(dateStart, dateEnd)',
                1 => '{direction}'
              ]
            ]
          ]
        ],
        'reminders' => [
          'type' => 'jsonArray',
          'notStorable' => true,
          'orderDisabled' => true,
          'view' => 'crm:views/meeting/fields/reminders',
          'layoutListDisabled' => true,
          'validatorClassNameList' => [
            0 => 'Espo\\Modules\\Crm\\Classes\\FieldValidators\\Event\\Reminders\\Valid',
            1 => 'Espo\\Modules\\Crm\\Classes\\FieldValidators\\Event\\Reminders\\MaxCount'
          ],
          'dynamicLogicDisabled' => true,
          'duplicateIgnore' => true
        ],
        'direction' => [
          'type' => 'enum',
          'options' => [
            0 => 'Outbound',
            1 => 'Inbound'
          ],
          'default' => 'Outbound'
        ],
        'description' => [
          'type' => 'text'
        ],
        'parent' => [
          'type' => 'linkParent',
          'entityList' => [
            0 => 'Account',
            1 => 'Lead',
            2 => 'Contact',
            3 => 'Opportunity',
            4 => 'Case',
            5 => 'CRegistration'
          ]
        ],
        'account' => [
          'type' => 'link',
          'readOnly' => true,
          'customizationReadOnlyDisabled' => true
        ],
        'uid' => [
          'type' => 'varchar',
          'maxLength' => 255,
          'index' => true,
          'readOnly' => true,
          'duplicateIgnore' => true
        ],
        'acceptanceStatus' => [
          'type' => 'enum',
          'notStorable' => true,
          'options' => [
            0 => 'None',
            1 => 'Accepted',
            2 => 'Tentative',
            3 => 'Declined'
          ],
          'style' => [
            'Accepted' => 'success',
            'Declined' => 'danger',
            'Tentative' => 'warning',
            'None' => NULL
          ],
          'layoutDetailDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'orderDisabled' => true,
          'importDisabled' => true,
          'exportDisabled' => true,
          'customizationDefaultDisabled' => true,
          'customizationRequiredDisabled' => true,
          'customizationIsSortedDisabled' => true,
          'customizationReadOnlyDisabled' => true,
          'customizationAuditedDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'directAccessDisabled' => true,
          'where' => [
            '=' => [
              'whereClause' => [
                'OR' => [
                  0 => [
                    'id=s' => [
                      'from' => 'CallContact',
                      'select' => [
                        0 => 'callId'
                      ],
                      'whereClause' => [
                        'deleted' => false,
                        'status' => '{value}'
                      ]
                    ]
                  ],
                  1 => [
                    'id=s' => [
                      'from' => 'CallLead',
                      'select' => [
                        0 => 'callId'
                      ],
                      'whereClause' => [
                        'deleted' => false,
                        'status' => '{value}'
                      ]
                    ]
                  ],
                  2 => [
                    'id=s' => [
                      'from' => 'CallUser',
                      'select' => [
                        0 => 'callId'
                      ],
                      'whereClause' => [
                        'deleted' => false,
                        'status' => '{value}'
                      ]
                    ]
                  ]
                ]
              ]
            ],
            '<>' => [
              'whereClause' => [
                'AND' => [
                  0 => [
                    'id!=s' => [
                      'from' => 'CallContact',
                      'select' => [
                        0 => 'callId'
                      ],
                      'whereClause' => [
                        'deleted' => false,
                        'status' => '{value}'
                      ]
                    ]
                  ],
                  1 => [
                    'id!=s' => [
                      'from' => 'CallLead',
                      'select' => [
                        0 => 'callId'
                      ],
                      'whereClause' => [
                        'deleted' => false,
                        'status' => '{value}'
                      ]
                    ]
                  ],
                  2 => [
                    'id!=s' => [
                      'from' => 'CallUser',
                      'select' => [
                        0 => 'callId'
                      ],
                      'whereClause' => [
                        'deleted' => false,
                        'status' => '{value}'
                      ]
                    ]
                  ]
                ]
              ]
            ],
            'IN' => [
              'whereClause' => [
                'OR' => [
                  0 => [
                    'id=s' => [
                      'from' => 'CallContact',
                      'select' => [
                        0 => 'callId'
                      ],
                      'whereClause' => [
                        'deleted' => false,
                        'status' => '{value}'
                      ]
                    ]
                  ],
                  1 => [
                    'id=s' => [
                      'from' => 'CallLead',
                      'select' => [
                        0 => 'callId'
                      ],
                      'whereClause' => [
                        'deleted' => false,
                        'status' => '{value}'
                      ]
                    ]
                  ],
                  2 => [
                    'id=s' => [
                      'from' => 'CallUser',
                      'select' => [
                        0 => 'callId'
                      ],
                      'whereClause' => [
                        'deleted' => false,
                        'status' => '{value}'
                      ]
                    ]
                  ]
                ]
              ]
            ],
            'NOT IN' => [
              'whereClause' => [
                'AND' => [
                  0 => [
                    'id!=s' => [
                      'from' => 'CallContact',
                      'select' => [
                        0 => 'callId'
                      ],
                      'whereClause' => [
                        'deleted' => false,
                        'status' => '{value}'
                      ]
                    ]
                  ],
                  1 => [
                    'id!=s' => [
                      'from' => 'CallLead',
                      'select' => [
                        0 => 'callId'
                      ],
                      'whereClause' => [
                        'deleted' => false,
                        'status' => '{value}'
                      ]
                    ]
                  ],
                  2 => [
                    'id!=s' => [
                      'from' => 'CallUser',
                      'select' => [
                        0 => 'callId'
                      ],
                      'whereClause' => [
                        'deleted' => false,
                        'status' => '{value}'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'view' => 'crm:views/meeting/fields/acceptance-status',
          'default' => 'None'
        ],
        'users' => [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'view' => 'crm:views/meeting/fields/users',
          'columns' => [
            'status' => 'acceptanceStatus'
          ],
          'additionalAttributeList' => [
            0 => 'columns'
          ],
          'orderBy' => 'name',
          'duplicatorClassName' => 'Espo\\Modules\\Crm\\Classes\\FieldDuplicators\\Meeting\\Attendees'
        ],
        'contacts' => [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'view' => 'crm:views/call/fields/contacts',
          'columns' => [
            'status' => 'acceptanceStatus'
          ],
          'additionalAttributeList' => [
            0 => 'columns'
          ],
          'orderBy' => 'name',
          'duplicatorClassName' => 'Espo\\Modules\\Crm\\Classes\\FieldDuplicators\\Meeting\\Attendees'
        ],
        'leads' => [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'view' => 'crm:views/call/fields/leads',
          'columns' => [
            'status' => 'acceptanceStatus'
          ],
          'additionalAttributeList' => [
            0 => 'columns'
          ],
          'orderBy' => 'name',
          'duplicatorClassName' => 'Espo\\Modules\\Crm\\Classes\\FieldDuplicators\\Meeting\\Attendees'
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true,
          'fieldManagerParamList' => [
            0 => 'useNumericFormat'
          ]
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true,
          'fieldManagerParamList' => [
            0 => 'useNumericFormat'
          ]
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user',
          'fieldManagerParamList' => []
        ],
        'modifiedBy' => [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user',
          'fieldManagerParamList' => []
        ],
        'phoneNumbersMap' => [
          'type' => 'jsonObject',
          'notStorable' => true,
          'orderDisabled' => true,
          'utility' => true,
          'customizationDisabled' => true,
          'name' => 'phoneNumbersMap',
          'label' => 'Mapa de número de telefones',
          'disabled' => true,
          'inlineEditDisabled' => false,
          'tooltip' => false
        ],
        'assignedUser' => [
          'type' => 'link',
          'required' => true,
          'view' => 'views/fields/assigned-user'
        ],
        'teams' => [
          'type' => 'linkMultiple',
          'view' => 'views/fields/teams'
        ]
      ],
      'links' => [
        'account' => [
          'type' => 'belongsTo',
          'entity' => 'Account'
        ],
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'assignedUser' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'teams' => [
          'type' => 'hasMany',
          'entity' => 'Team',
          'relationName' => 'entityTeam',
          'layoutRelationshipsDisabled' => true
        ],
        'users' => [
          'type' => 'hasMany',
          'entity' => 'User',
          'foreign' => 'calls',
          'additionalColumns' => [
            'status' => [
              'type' => 'varchar',
              'len' => '36',
              'default' => 'None'
            ]
          ],
          'columnAttributeMap' => [
            'status' => 'acceptanceStatus'
          ]
        ],
        'contacts' => [
          'type' => 'hasMany',
          'entity' => 'Contact',
          'foreign' => 'calls',
          'additionalColumns' => [
            'status' => [
              'type' => 'varchar',
              'len' => '36',
              'default' => 'None'
            ]
          ],
          'columnAttributeMap' => [
            'status' => 'acceptanceStatus'
          ]
        ],
        'leads' => [
          'type' => 'hasMany',
          'entity' => 'Lead',
          'foreign' => 'calls',
          'additionalColumns' => [
            'status' => [
              'type' => 'varchar',
              'len' => '36',
              'default' => 'None'
            ]
          ],
          'columnAttributeMap' => [
            'status' => 'acceptanceStatus'
          ]
        ],
        'parent' => [
          'type' => 'belongsToParent',
          'foreign' => 'calls'
        ]
      ],
      'collection' => [
        'orderBy' => 'dateStart',
        'order' => 'desc',
        'sortBy' => 'dateStart',
        'asc' => false
      ],
      'indexes' => [
        'dateStartStatus' => [
          'columns' => [
            0 => 'dateStart',
            1 => 'status'
          ]
        ],
        'dateStart' => [
          'columns' => [
            0 => 'dateStart',
            1 => 'deleted'
          ]
        ],
        'status' => [
          'columns' => [
            0 => 'status',
            1 => 'deleted'
          ]
        ],
        'assignedUser' => [
          'columns' => [
            0 => 'assignedUserId',
            1 => 'deleted'
          ]
        ],
        'assignedUserStatus' => [
          'columns' => [
            0 => 'assignedUserId',
            1 => 'status'
          ]
        ]
      ],
      'repositoryClassName' => 'Espo\\Core\\Repositories\\Event'
    ],
    'Campaign' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'required' => true,
          'pattern' => '$noBadCharacters'
        ],
        'status' => [
          'type' => 'enum',
          'options' => [
            0 => 'Planning',
            1 => 'Active',
            2 => 'Inactive',
            3 => 'Complete'
          ],
          'default' => 'Planning',
          'style' => [
            'Active' => 'primary',
            'Inactive' => 'info',
            'Complete' => 'success'
          ],
          'displayAsLabel' => true,
          'labelType' => 'state',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true
        ],
        'type' => [
          'type' => 'enum',
          'options' => [
            0 => 'Email',
            1 => 'Newsletter',
            2 => 'Web',
            3 => 'Television',
            4 => 'Radio',
            5 => 'Mail'
          ],
          'default' => 'Email',
          'customizationOptionsReferenceDisabled' => true
        ],
        'startDate' => [
          'type' => 'date',
          'validatorClassNameList' => [
            0 => 'Espo\\Modules\\Crm\\Classes\\FieldValidators\\Campaign\\StartDate\\BeforeEndDate'
          ]
        ],
        'endDate' => [
          'type' => 'date',
          'validatorClassNameList' => [
            0 => 'Espo\\Modules\\Crm\\Classes\\FieldValidators\\Campaign\\EndDate\\AfterStartDate'
          ]
        ],
        'description' => [
          'type' => 'text'
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true,
          'fieldManagerParamList' => [
            0 => 'useNumericFormat'
          ]
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true,
          'fieldManagerParamList' => [
            0 => 'useNumericFormat'
          ]
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user',
          'fieldManagerParamList' => []
        ],
        'modifiedBy' => [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user',
          'fieldManagerParamList' => []
        ],
        'assignedUser' => [
          'type' => 'link',
          'view' => 'views/fields/assigned-user'
        ],
        'teams' => [
          'type' => 'linkMultiple',
          'view' => 'views/fields/teams'
        ],
        'targetLists' => [
          'type' => 'linkMultiple',
          'tooltip' => true
        ],
        'excludingTargetLists' => [
          'type' => 'linkMultiple',
          'tooltip' => true
        ],
        'sentCount' => [
          'type' => 'int',
          'notStorable' => true,
          'orderDisabled' => true,
          'directAccessDisabled' => true,
          'readOnly' => true,
          'utility' => true
        ],
        'openedCount' => [
          'view' => 'crm:views/campaign/fields/int-with-percentage',
          'type' => 'int',
          'notStorable' => true,
          'orderDisabled' => true,
          'directAccessDisabled' => true,
          'readOnly' => true,
          'utility' => true
        ],
        'clickedCount' => [
          'view' => 'crm:views/campaign/fields/int-with-percentage',
          'type' => 'int',
          'notStorable' => true,
          'orderDisabled' => true,
          'directAccessDisabled' => true,
          'readOnly' => true,
          'utility' => true
        ],
        'optedInCount' => [
          'type' => 'int',
          'notStorable' => true,
          'orderDisabled' => true,
          'directAccessDisabled' => true,
          'readOnly' => true,
          'utility' => true,
          'default' => NULL,
          'min' => NULL,
          'max' => NULL
        ],
        'optedOutCount' => [
          'view' => 'crm:views/campaign/fields/int-with-percentage',
          'type' => 'int',
          'notStorable' => true,
          'orderDisabled' => true,
          'directAccessDisabled' => true,
          'readOnly' => true,
          'utility' => true
        ],
        'bouncedCount' => [
          'view' => 'crm:views/campaign/fields/int-with-percentage',
          'type' => 'int',
          'notStorable' => true,
          'orderDisabled' => true,
          'directAccessDisabled' => true,
          'readOnly' => true,
          'utility' => true,
          'default' => NULL,
          'min' => NULL,
          'max' => NULL
        ],
        'hardBouncedCount' => [
          'type' => 'int',
          'notStorable' => true,
          'orderDisabled' => true,
          'directAccessDisabled' => true,
          'readOnly' => true,
          'utility' => true
        ],
        'softBouncedCount' => [
          'type' => 'int',
          'notStorable' => true,
          'orderDisabled' => true,
          'directAccessDisabled' => true,
          'readOnly' => true,
          'utility' => true
        ],
        'leadCreatedCount' => [
          'type' => 'int',
          'notStorable' => true,
          'orderDisabled' => true,
          'directAccessDisabled' => true,
          'readOnly' => true,
          'utility' => true
        ],
        'openedPercentage' => [
          'type' => 'int',
          'notStorable' => true,
          'orderDisabled' => true,
          'directAccessDisabled' => true,
          'readOnly' => true,
          'utility' => true,
          'default' => NULL,
          'min' => NULL,
          'max' => NULL
        ],
        'clickedPercentage' => [
          'type' => 'int',
          'notStorable' => true,
          'orderDisabled' => true,
          'directAccessDisabled' => true,
          'readOnly' => true,
          'utility' => true,
          'default' => NULL,
          'min' => NULL,
          'max' => NULL
        ],
        'optedOutPercentage' => [
          'type' => 'int',
          'notStorable' => true,
          'orderDisabled' => true,
          'directAccessDisabled' => true,
          'readOnly' => true,
          'utility' => true,
          'default' => NULL,
          'min' => NULL,
          'max' => NULL
        ],
        'bouncedPercentage' => [
          'type' => 'int',
          'notStorable' => true,
          'orderDisabled' => true,
          'directAccessDisabled' => true,
          'readOnly' => true,
          'utility' => true,
          'default' => NULL,
          'min' => NULL,
          'max' => NULL
        ],
        'revenue' => [
          'type' => 'currency',
          'notStorable' => true,
          'orderDisabled' => true,
          'directAccessDisabled' => true,
          'readOnly' => true,
          'utility' => true
        ],
        'budget' => [
          'type' => 'currency'
        ],
        'contactsTemplate' => [
          'type' => 'link',
          'view' => 'crm:views/campaign/fields/template',
          'targetEntityType' => 'Contact',
          'defaultAttributes' => NULL
        ],
        'leadsTemplate' => [
          'type' => 'link',
          'view' => 'crm:views/campaign/fields/template',
          'targetEntityType' => 'Lead',
          'defaultAttributes' => NULL
        ],
        'accountsTemplate' => [
          'type' => 'link',
          'view' => 'crm:views/campaign/fields/template',
          'targetEntityType' => 'Account',
          'defaultAttributes' => NULL
        ],
        'usersTemplate' => [
          'type' => 'link',
          'view' => 'crm:views/campaign/fields/template',
          'targetEntityType' => 'User',
          'defaultAttributes' => NULL
        ],
        'mailMergeOnlyWithAddress' => [
          'type' => 'bool',
          'default' => true
        ],
        'budgetCurrency' => [
          'type' => 'enum',
          'view' => 'views/fields/currency-list',
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'customizationRequiredDisabled' => true,
          'customizationOptionsDisabled' => true,
          'customizationIsSortedDisabled' => true,
          'customizationDisplayAsLabelDisabled' => true,
          'customizationAuditedDisabled' => true,
          'customizationReadOnlyDisabled' => true,
          'customizationInlineEditDisabledDisabled' => true,
          'customizationDefaultView' => 'views/admin/field-manager/fields/currency-default',
          'customizationTooltipTextDisabled' => true,
          'maxLength' => 3,
          'default' => NULL
        ],
        'revenueCurrency' => [
          'notStorable' => true,
          'directAccessDisabled' => true,
          'readOnly' => true,
          'type' => 'enum',
          'view' => 'views/fields/currency-list',
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'customizationRequiredDisabled' => true,
          'customizationOptionsDisabled' => true,
          'customizationIsSortedDisabled' => true,
          'customizationDisplayAsLabelDisabled' => true,
          'customizationAuditedDisabled' => true,
          'customizationReadOnlyDisabled' => true,
          'customizationInlineEditDisabledDisabled' => true,
          'customizationDefaultView' => 'views/admin/field-manager/fields/currency-default',
          'customizationTooltipTextDisabled' => true,
          'maxLength' => 3,
          'default' => NULL
        ],
        'revenueConverted' => [
          'notStorable' => true,
          'directAccessDisabled' => true,
          'readOnly' => true,
          'type' => 'currencyConverted',
          'importDisabled' => true,
          'customizationInlineEditDisabledDisabled' => true
        ],
        'budgetConverted' => [
          'type' => 'currencyConverted',
          'readOnly' => true,
          'importDisabled' => true,
          'customizationInlineEditDisabledDisabled' => true
        ]
      ],
      'links' => [
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'assignedUser' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'teams' => [
          'type' => 'hasMany',
          'entity' => 'Team',
          'relationName' => 'entityTeam',
          'layoutRelationshipsDisabled' => true
        ],
        'targetLists' => [
          'type' => 'hasMany',
          'entity' => 'TargetList',
          'foreign' => 'campaigns'
        ],
        'excludingTargetLists' => [
          'type' => 'hasMany',
          'entity' => 'TargetList',
          'foreign' => 'campaignsExcluding',
          'relationName' => 'campaignTargetListExcluding',
          'audited' => false
        ],
        'accounts' => [
          'type' => 'hasMany',
          'entity' => 'Account',
          'foreign' => 'campaign'
        ],
        'contacts' => [
          'type' => 'hasMany',
          'entity' => 'Contact',
          'foreign' => 'campaign',
          'audited' => false
        ],
        'leads' => [
          'type' => 'hasMany',
          'entity' => 'Lead',
          'foreign' => 'campaign',
          'audited' => false
        ],
        'opportunities' => [
          'type' => 'hasMany',
          'entity' => 'Opportunity',
          'foreign' => 'campaign',
          'audited' => false
        ],
        'campaignLogRecords' => [
          'type' => 'hasMany',
          'entity' => 'CampaignLogRecord',
          'foreign' => 'campaign'
        ],
        'trackingUrls' => [
          'type' => 'hasMany',
          'entity' => 'CampaignTrackingUrl',
          'foreign' => 'campaign',
          'audited' => false
        ],
        'massEmails' => [
          'type' => 'hasMany',
          'entity' => 'MassEmail',
          'foreign' => 'campaign',
          'layoutRelationshipsDisabled' => true,
          'audited' => false
        ],
        'contactsTemplate' => [
          'type' => 'belongsTo',
          'entity' => 'Template',
          'noJoin' => true
        ],
        'leadsTemplate' => [
          'type' => 'belongsTo',
          'entity' => 'Template',
          'noJoin' => true
        ],
        'accountsTemplate' => [
          'type' => 'belongsTo',
          'entity' => 'Template',
          'noJoin' => true
        ],
        'usersTemplate' => [
          'type' => 'belongsTo',
          'entity' => 'Template',
          'noJoin' => true
        ]
      ],
      'collection' => [
        'orderBy' => 'createdAt',
        'order' => 'desc',
        'sortBy' => 'createdAt',
        'asc' => false
      ],
      'indexes' => [
        'createdAt' => [
          'columns' => [
            0 => 'createdAt',
            1 => 'deleted'
          ]
        ]
      ]
    ],
    'CampaignLogRecord' => [
      'fields' => [
        'action' => [
          'type' => 'enum',
          'required' => true,
          'maxLength' => 50,
          'options' => [
            0 => 'Sent',
            1 => 'Opened',
            2 => 'Opted Out',
            3 => 'Bounced',
            4 => 'Clicked',
            5 => 'Opted In',
            6 => 'Lead Created'
          ]
        ],
        'actionDate' => [
          'type' => 'datetime',
          'required' => true
        ],
        'data' => [
          'type' => 'jsonObject',
          'view' => 'crm:views/campaign-log-record/fields/data'
        ],
        'stringData' => [
          'type' => 'varchar',
          'maxLength' => 100
        ],
        'stringAdditionalData' => [
          'type' => 'varchar',
          'maxLength' => 100
        ],
        'application' => [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 36,
          'default' => 'Espo'
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true,
          'fieldManagerParamList' => [
            0 => 'useNumericFormat'
          ]
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true,
          'fieldManagerParamList' => []
        ],
        'campaign' => [
          'type' => 'link'
        ],
        'parent' => [
          'type' => 'linkParent'
        ],
        'object' => [
          'type' => 'linkParent'
        ],
        'queueItem' => [
          'type' => 'link'
        ],
        'isTest' => [
          'type' => 'bool',
          'default' => false
        ]
      ],
      'links' => [
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'campaign' => [
          'type' => 'belongsTo',
          'entity' => 'Campaign',
          'foreign' => 'campaignLogRecords'
        ],
        'queueItem' => [
          'type' => 'belongsTo',
          'entity' => 'EmailQueueItem',
          'noJoin' => true
        ],
        'parent' => [
          'type' => 'belongsToParent',
          'entityList' => [
            0 => 'Account',
            1 => 'Contact',
            2 => 'Lead',
            3 => 'Opportunity',
            4 => 'User'
          ]
        ],
        'object' => [
          'type' => 'belongsToParent',
          'entityList' => [
            0 => 'Email',
            1 => 'CampaignTrackingUrl'
          ]
        ]
      ],
      'collection' => [
        'textFilterFields' => [
          0 => 'queueItem.id',
          1 => 'queueItem.emailAddress'
        ],
        'orderBy' => 'createdAt',
        'order' => 'desc',
        'sortBy' => 'createdAt',
        'asc' => false
      ],
      'indexes' => [
        'actionDate' => [
          'columns' => [
            0 => 'actionDate',
            1 => 'deleted'
          ]
        ],
        'action' => [
          'columns' => [
            0 => 'action',
            1 => 'deleted'
          ]
        ]
      ]
    ],
    'CampaignTrackingUrl' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'required' => true
        ],
        'url' => [
          'type' => 'url',
          'tooltip' => true
        ],
        'urlToUse' => [
          'type' => 'varchar',
          'notStorable' => true,
          'orderDisabled' => true,
          'readOnly' => true
        ],
        'campaign' => [
          'type' => 'link'
        ],
        'action' => [
          'type' => 'enum',
          'options' => [
            0 => 'Redirect',
            1 => 'Show Message'
          ],
          'default' => 'Redirect'
        ],
        'message' => [
          'type' => 'text',
          'tooltip' => true
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true,
          'fieldManagerParamList' => [
            0 => 'useNumericFormat'
          ]
        ],
        'modifiedBy' => [
          'type' => 'link',
          'readOnly' => true,
          'fieldManagerParamList' => []
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true,
          'fieldManagerParamList' => [
            0 => 'useNumericFormat'
          ]
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true,
          'fieldManagerParamList' => []
        ]
      ],
      'links' => [
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'campaign' => [
          'type' => 'belongsTo',
          'entity' => 'Campaign',
          'foreign' => 'trackingUrls'
        ]
      ],
      'collection' => [
        'orderBy' => 'name',
        'order' => 'asc',
        'sortBy' => 'name',
        'asc' => true
      ]
    ],
    'Case' => [
      'fields' => [
        'name' => [
          'type' => 'varchar',
          'required' => false,
          'pattern' => '$noBadCharacters',
          'default' => NULL,
          'maxLength' => NULL,
          'options' => []
        ],
        'number' => [
          'type' => 'autoincrement',
          'index' => true
        ],
        'status' => [
          'type' => 'enum',
          'options' => [
            0 => 'New',
            1 => 'Assigned',
            2 => 'Pending',
            3 => 'Closed',
            4 => 'Rejected',
            5 => 'Duplicate'
          ],
          'default' => 'New',
          'style' => [
            'Closed' => 'success',
            'Assigned' => 'primary',
            'Duplicate' => 'info',
            'Pending' => 'warning',
            'Rejected' => 'danger',
            'New' => NULL
          ],
          'audited' => true,
          'displayAsLabel' => true,
          'labelType' => 'state',
          'fieldManagerAdditionalParamList' => [
            0 => [
              'name' => 'notActualOptions',
              'view' => 'views/admin/field-manager/fields/not-actual-options'
            ]
          ],
          'notActualOptions' => [
            0 => 'Closed',
            1 => 'Rejected',
            2 => 'Duplicate'
          ],
          'customizationOptionsReferenceDisabled' => true
        ],
        'priority' => [
          'type' => 'enum',
          'options' => [
            0 => 'Low',
            1 => 'Normal',
            2 => 'High',
            3 => 'Urgent'
          ],
          'default' => 'Normal',
          'displayAsLabel' => true,
          'style' => [
            'High' => 'danger',
            'Urgent' => 'warning',
            'Low' => 'primary',
            'Normal' => 'info'
          ],
          'audited' => true,
          'customizationOptionsReferenceDisabled' => true
        ],
        'type' => [
          'type' => 'enum',
          'options' => [
            0 => '',
            1 => 'API Access',
            2 => 'Customize URL',
            3 => 'Question',
            4 => 'Incident',
            5 => 'Problem'
          ],
          'audited' => true,
          'customizationOptionsReferenceDisabled' => true,
          'style' => [
            '' => NULL,
            'API Access' => NULL,
            'Customize URL' => NULL,
            'Question' => NULL,
            'Incident' => NULL,
            'Problem' => NULL
          ],
          'required' => true,
          'displayAsLabel' => true
        ],
        'description' => [
          'type' => 'text',
          'preview' => true,
          'attachmentField' => 'attachments',
          'default' => NULL,
          'maxLength' => NULL,
          'rows' => NULL,
          'cutHeight' => NULL
        ],
        'account' => [
          'type' => 'link',
          'defaultAttributes' => NULL
        ],
        'lead' => [
          'type' => 'link'
        ],
        'contact' => [
          'type' => 'link',
          'view' => 'crm:views/case/fields/contact',
          'audited' => true,
          'defaultAttributes' => NULL
        ],
        'contacts' => [
          'type' => 'linkMultiple',
          'view' => 'crm:views/case/fields/contacts',
          'orderBy' => 'name',
          'detailLayoutIncompatibleFieldList' => [
            0 => 'contact'
          ]
        ],
        'inboundEmail' => [
          'type' => 'link',
          'readOnly' => true,
          'defaultAttributes' => NULL
        ],
        'originalEmail' => [
          'type' => 'link',
          'notStorable' => true,
          'orderDisabled' => true,
          'entity' => 'Email',
          'customizationDisabled' => true,
          'layoutAvailabilityList' => [],
          'directAccessDisabled' => true
        ],
        'isInternal' => [
          'type' => 'bool'
        ],
        'createdAt' => [
          'type' => 'datetime',
          'readOnly' => true,
          'fieldManagerParamList' => [
            0 => 'useNumericFormat'
          ]
        ],
        'modifiedAt' => [
          'type' => 'datetime',
          'readOnly' => true,
          'fieldManagerParamList' => [
            0 => 'useNumericFormat'
          ]
        ],
        'createdBy' => [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user',
          'fieldManagerParamList' => []
        ],
        'modifiedBy' => [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user',
          'fieldManagerParamList' => []
        ],
        'assignedUser' => [
          'type' => 'link',
          'view' => 'views/fields/assigned-user'
        ],
        'teams' => [
          'type' => 'linkMultiple',
          'view' => 'views/fields/teams'
        ],
        'attachments' => [
          'type' => 'attachmentMultiple',
          'sourceList' => [],
          'maxFileSize' => NULL,
          'previewSize' => NULL,
          'accept' => []
        ],
        'instructions' => [
          'type' => 'wysiwyg',
          'default' => '<b>Bem-vindo ao canal de suporte do Cloud Analytics!</b>
Este canal de comunicação é dedicado à navegação e funcionalidades do Analytics. Escreva sua dúvida, será um prazer ajudá-lo!
<br>
<br>
<b>¡Bienvenido al canal de soporte de Cloud Analytics!</b>
Este canal de comunicación está dedicado a la navegación y funcionalidades de Analytics. Escriba su consulta, ¡será un placer ayudarle!',
          'readOnly' => true,
          'height' => NULL,
          'minHeight' => NULL,
          'isCustom' => true
        ],
        'cApiUser' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'audited' => true,
          'options' => [],
          'isCustom' => true
        ],
        'cApiPassword' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'options' => [],
          'audited' => true,
          'isCustom' => true
        ],
        'cCustomizeUrl' => [
          'type' => 'url',
          'isCustom' => true
        ],
        'cRegistrationAddress' => [
          'type' => 'text',
          'rowsMin' => 2,
          'cutHeight' => 200,
          'audited' => true,
          'isCustom' => true
        ],
        'cUrlType' => [
          'type' => 'enum',
          'options' => [
            0 => '',
            1 => 'standard',
            2 => 'domain'
          ],
          'audited' => true,
          'style' => [
            '' => NULL,
            'standard' => NULL,
            'domain' => NULL
          ],
          'maxLength' => 100,
          'isCustom' => true
        ],
        'cStandardUrl' => [
          'type' => 'url',
          'default' => 'https://partners.enube.me/portal/customizehere',
          'audited' => true,
          'tooltip' => true,
          'isCustom' => true
        ],
        'streamUpdatedAt' => [
          'type' => 'datetime',
          'readOnly' => true,
          'customizationReadOnlyDisabled' => true
        ]
      ],
      'links' => [
        'createdBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'assignedUser' => [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'teams' => [
          'type' => 'hasMany',
          'entity' => 'Team',
          'relationName' => 'entityTeam',
          'layoutRelationshipsDisabled' => true
        ],
        'inboundEmail' => [
          'type' => 'belongsTo',
          'entity' => 'InboundEmail'
        ],
        'account' => [
          'type' => 'belongsTo',
          'entity' => 'Account',
          'foreign' => 'cases',
          'deferredLoad' => true
        ],
        'lead' => [
          'type' => 'belongsTo',
          'entity' => 'Lead',
          'foreign' => 'cases',
          'deferredLoad' => true
        ],
        'contact' => [
          'type' => 'belongsTo',
          'entity' => 'Contact',
          'foreign' => 'casesPrimary',
          'deferredLoad' => true
        ],
        'contacts' => [
          'type' => 'hasMany',
          'entity' => 'Contact',
          'foreign' => 'cases',
          'layoutRelationshipsDisabled' => true
        ],
        'meetings' => [
          'type' => 'hasChildren',
          'entity' => 'Meeting',
          'foreign' => 'parent',
          'audited' => true
        ],
        'calls' => [
          'type' => 'hasChildren',
          'entity' => 'Call',
          'foreign' => 'parent',
          'audited' => true
        ],
        'tasks' => [
          'type' => 'hasChildren',
          'entity' => 'Task',
          'foreign' => 'parent',
          'audited' => true
        ],
        'emails' => [
          'type' => 'hasChildren',
          'entity' => 'Email',
          'foreign' => 'parent',
          'layoutRelationshipsDisabled' => true
        ],
        'articles' => [
          'type' => 'hasMany',
          'entity' => 'KnowledgeBaseArticle',
          'foreign' => 'cases',
          'audited' => true
        ],
        'attachments' => [
          'type' => 'hasChildren',
          'entity' => 'Attachment',
          'foreign' => 'parent',
          'layoutRelationshipsDisabled' => true,
          'relationName' => 'attachments',
          'utility' => true
        ]
      ],
      'collection' => [
        'orderBy' => 'number',
        'order' => 'desc',
        'textFilterFields' => [
          0 => 'name',
          1 => 'number'
        ],
        'fullTextSearch' => false,
        'countDisabled' => false,
        'sortBy' => 'number',
        'asc' => false
      ],
      'indexes' => [
        'status' => [
          'columns' => [
            0 => 'status',
            1 => 'deleted'
          ]
        ],
        'assignedUser' => [
          'columns' => [
            0 => 'assignedUserId',
            1 => 'deleted'
          ]
        ],
        'assignedUserStatus' => [
          'columns' => [
            0 => 'assignedUserId',
            1 => 'status'
          ]
        ]
      ],
      'optimisticConcurrencyControl' => false
    ],
    'Contact' => [
      'fields' => [
        'name' => [
          'type' => 'personName',
          'isPersonalData' => true
        ],
        'salutationName' => [
          'type' => 'enum',
          'customizationOptionsReferenceDisabled' => true,
          'options' => [
            0 => '',
            1 => 'Mr.',
            2 => 'Ms.',
            3 => 'Mrs.',
            4 => 'Dr.'
          ]
        ],
        'firstName' => [
          'type' => 'varchar',
          'pattern' => '$noBadCharacters',
          'maxLength' => 100
        ],
        'lastName' => [
          'type' => 'varchar',
          'pattern' => '$noBadCharacters',
          'maxLength' => 100,
          'required' => true,
          'default' => NULL,
          'options' => []
        ],
        'accountAnyId' => [
          'notStorable' => true,
          'orderDisabled' => true,
          'customizationDisabled' => true,
          'utility' => true,
          'type' => 'varchar',
          'where' => [
            '=' => [
              'whereClause' => [
                'id=s' => [
                  'from' => 'AccountContact',
                  'select' => [
                    0 => 'contactId'
                  ],
                  'whereClause' => [
                    'deleted' => false,
                    'accountId' => '{value}'
                  ]
                ]
              ]
            ],
            '<>' => [
              'whereClause' => [
                'id!=s' => [
                  'from' => 'AccountContact',
                  'select' => [
                    0 => 'contactId'
                  ],
                  'whereClause' => [
                    'deleted' => false,
                    'accountId' => '{value}'
                  ]
                ]
              ]
            ],
            'IN' => [
              'whereClause' => [
                'id=s' => [
                  'from' => 'AccountContact',
                  'select' => [
                    0 => 'contactId'
                  ],
                  'whereClause' => [
                    'deleted' => false,
                    'accountId' => '{value}'
                  ]
                ]
              ]
            ],
            'NOT IN' => [
              'whereClause' => [
                'id!=s' => [
                  'from' => 'AccountContact',
                  'select' => [
                    0 => 'contactId'
                  ],
                  'whereClause' => [
                    'deleted' => false,
                    'accountId' => '{value}'
                  ]
                ]
              ]
            ],
            'IS NULL' => [
              'whereClause' => [
                'accountId' => NULL
              ]
            ],
            'IS NOT NULL' => [
              'whereClause' => [
                'accountId!=' => NULL
              ]
            ]
          ]
        ],
        'title' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'crm:views/contact/fields/title',
          'directUpdateDisabled' => true,
          'notStorable' => true,
          'select' => [
            'select' => 'accountContactPrimary.role',
            'leftJoins' => [
              0 => [
                0 => 'AccountContact',
                1 => 'accountContactPrimary',
                2 => [
                  'contact.id:' => 'accountContactPrimary.contactId',
                  'contact.accountId:' => 'accountContactPrimary.accountId',
                  'accountContactPrimary.deleted' => false
                ]
              ]
            ]
          ],
          'order' => [
            'order' => [
              0 => [
                0 => 'accountContactPrimary.role',
                1 => '{direction}'
              ]
            ],
            'leftJoins' => [
              0 => [
                0 => 'AccountContact',
                1 => 'accountContactPrimary',
                2 => [
                  'contact.id:' => 'accountContactPrimary.contactId',
                  'contact.accountId:' => 'accountContactPrimary.accountId',
                  'accountContactPrimary.deleted' => false
                ]
              ]
            ]
          ],
          'where' => [
            'LIKE' => [
              'whereClause' => [
                'id=s' => [
                  'from' => 'AccountContact',
                  'select' => [
                    0 => 'contactId'
                  ],
                  'whereClause' => [
                    'deleted' => false,
                    'role*' => '{value}'
                  ]
                ]
              ]
            ],
            'NOT LIKE' => [
              'whereClause' => [
                'id!=s' => [
                  'from' => 'AccountContact',
                  'select' => [
                    0 => 'contactId'
                  ],
                  'whereClause' => [
                    'deleted' => false,
                    'role*' => '{value}'
                  ]
                ]
              ]
            ],
            '=' => [
              'whereClause' => [
                'id=s' => [
                  'from' => 'AccountContact',
                  'select' => [
                    0 => 'contactId'
                  ],
                  'whereClause' => [
                    'deleted' => false,
                    'role' => '{value}'
                  ]
                ]
              ]
            ],
            '<>' => [
              'whereClause' => [
                'id!=s' => [
                  'from' => 'AccountContact',
                  'select' => [
                    0 => 'contactId'
                  ],
                  'whereClause' => [
                    'deleted' => false,
                    'role' => '{value}'
                  ]
                ]
              ]
            ],
            'IS NULL' => [
              'whereClause' => [
                'NOT' => [
                  'EXISTS' => [
                    'from' => 'Contact',
                    'fromAlias' => 'sq',
                    'select' => [
                      0 => 'id'
                    ],
                    'leftJoins' => [
                      0 => [
                        0 => 'accounts',
                        1 => 'm',
                        2 => [],
                        3 => [
                          'onlyMiddle' => true
                        ]
                      ]
                    ],
                    'whereClause' => [
                      'AND' => [
                        0 => [
                          'm.role!=' => NULL
                        ],
                        1 => [
                          'm.role!=' => ''
                        ],
                        2 => [
                          'sq.id:' => 'contact.id'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ],
            'IS NOT NULL' => [
              'whereClause' => [
                'EXISTS' => [
                  'from' => 'Contact',
                  'fromAlias' => 'sq',
                  'select' => [
                    0 => 'id'
                  ],
                  'leftJoins' => [
                    0 => [
                      0 => 'accounts',
                      1 => 'm',
                      2 => [],
                      3 => [
                        'onlyMiddle' => true
                      ]
                    ]
                  ],
                  'whereClause' => [
                    'AND' => [
                      0 => [
                        'm.role!=' => NULL
                      ],
                      1 => [
                        'm.role!=' => ''
                      ],
                      2 => [
                        'sq.id:' => 'contact.id'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'customizationOptionsDisabled' => true,
          'textFilterDisabled' => true,
          'default' => NULL,
          'options' => []
        ],
        'description' => [
          'type' => 'text',
          'default' => NULL,
          'maxLength' => NULL,
          'rows' => NULL,
          'cutHeight' => NULL
        ],
        'emailAddress' => [
          'type' => 'email',
          'isPersonalData' => true
        ],
        'phoneNumber' => [
          'type' => 'phone',
          'typeList' => [
            0 => 'Mobile',
            1 => 'Office',
            2 => 'Home',
            3 => 'Fax',
            4 => 'Other'
          ],
          'defaultType' => 'Mobile',
          'isPersonalData' => true
        ],
        'doNotCall' => [
          'type' => 'bool'
        ],
        'address' => [
          'type' => 'address',
          'isPersonalData' => true
        ],
        'addressStreet' => [
          'type' => 'text',
          'maxLength' => 255,
          'dbType' => 'varchar'
        ],
        'addressCity' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'views/fields/address-city',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'pattern' => '$noBadCharacters'
        ],
        'addressState' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'views/fields/address-state',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'pattern' => '$noBadCharacters'
        ],
        'addressCountry' => [
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'views/fields/address-country',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'pattern' => '$noBadCharacters',
          'default' => NULL
        ],
        'addressPostalCode' => [
          'type' => 'varchar',
          'maxLength' => 40,
          'pattern' => '$noBadCharacters'
        ],
        'account' => [
          'type' => 'link',
          'view' => 'crm:views/contact/fields/account',
          'audited' => true
        ],
        'accounts' => [
          'type' => 'linkMultiple',
          'view' => 'crm:views/contact/fields/accounts',
          'columns' => [
            'role' => 'contactRole',
            'isInactive' => 'contactIsInactive'
          ],
          'additionalAttributeList' => [
            0 => 'columns'
          ],
          'orderBy' => 'name',
          'detailLayoutIncompatibleFieldList' => [
            0 => 'account'
          ]
        ],
        'accountRole' => [
          'type' => 'varchar',
          'notStorable' => true,
          'orderDisabled' => true,
          'directUpdateDisabled' => true,
          'layoutDetailDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'layoutFiltersDisabled' => true,
          'layoutAvailabilityList' => [
            0 => 'listForAccount'
          ],
          'exportDisabled' => true,
          'importDisabled' => true,
          'view' => 'crm:views/contact/fields/account-role',
          'customizationOptionsDisabled' => true,
          'textFilterDisabled' => true
        ],
        'accountIsInactive' => [
          'type' => 'bool',
          'notStorable' => true,
          'mergeDisabled' => true,
          'foreignAccessDisabled' => true,
          'select' => [
            'select' => 'accountContactPrimary.isInactive',
            'leftJoins' => [
              0 => [
                0 => 'AccountContact',
                1 => 'accountContactPrimary',
                2 => [
                  'contact.id:' => 'accountContactPrimary.contactId',
                  'contact.accountId:' => 'accountContactPrimary.accountId',
                  'accountContactPrimary.deleted' => false
                ]
              ]
            ]
          ],
          'order' => [
            'order' => [
              0 => [
                0 => 'accountContactPrimary.isInactive',
                1 => '{direction}'
              ]
            ],
            'leftJoins' => [
              0 => [
                0 => 'AccountContact',
                1 => 'accountContactPrimary',
                2 => [
                  'contact.id:' => 'accountContactPrimary.contactId',
                  'contact.accountId:' => 'accountContactPrimary.accountId',
                  'accountContactPrimary.deleted' => false
                ]
              ]
            ]
          ],
          'where' => [
            '= TRUE' => [
              'leftJoins' => [
                0 => [
                  0 => 'AccountContact',
                  1 => 'accountContactFilterIsInactive',
                  2 => [
                    'accountContactFilterIsInactive.contactId:' => 'id',
                    'accountContactFilterIsInactive.accountId:' => 'accountId',
                    'accountContactFilterIsInactive.deleted' => false
                  ]
             